/*
 *	Creation or mapping of the Endeavour program's windows
 */

#ifndef EDVWINDOW_H
#define EDVWINDOW_H

#include <glib.h>
#include "edvcontext.h"

/*
 *	Creates a new file browser window.
 */
extern void EDVWindowBrowserNew(
	edv_context_struct *ctx, const gchar *path
);
#define EDVWindowFileBrowserNew		EDVWindowBrowserNew

/*
 *      Creates a new image browser window.
 */
extern void EDVWindowImageBrowserNew(
        edv_context_struct *ctx, const gchar *path
);

/*
 *      Creates a new archiver window.
 */
extern void EDVWindowArchiverNew(
        edv_context_struct *ctx, const gchar *path
);

/*
 *	Maps the recycle bin window.
 */
extern void EDVWindowRecycleBinMap(edv_context_struct *ctx);

/*
 *      Creates a new properties window.
 */
extern void EDVWindowPropertiesNew(
        edv_context_struct *ctx, const gchar *path, const gchar *tab_name
);

/*
 *      Maps the options window.
 */
extern void EDVWindowOptionsMap(edv_context_struct *ctx);

/*
 *      Maps the customize window.
 */
extern void EDVWindowCustomizeMap(edv_context_struct *ctx);

/*
 *      Maps the devices window.
 */
extern void EDVWindowDevicesMap(edv_context_struct *ctx);

/*
 *      Maps the mime types window.
 */
extern void EDVWindowMIMETypesMap(edv_context_struct *ctx);

/*
 *      Maps the run dialog.
 */
extern void EDVWindowRunDialogMap(edv_context_struct *ctx);

/*
 *      Maps the about dialog.
 */
extern void EDVWindowAboutDialogMap(edv_context_struct *ctx);
#define EDVWindowAbout	EDVWindowAboutDialogMap
#define EDVAbout	EDVWindowAboutDialogMap


#endif	/* EDVWINDOW_H */
