#include <glib.h>
#include "../../include/prochandle.h"
#include "edvcontext.h"
#include "edvwindow.h"
#include "config.h"

#define ENDEAVOUR_BIN_PATH	"/usr/bin/endeavour2"

void EDVWindowBrowserNew(
        edv_context_struct *ctx, const gchar *path
);
void EDVWindowImageBrowserNew(
        edv_context_struct *ctx, const gchar *path
);
void EDVWindowArchiverNew(
        edv_context_struct *ctx, const gchar *path
);
void EDVWindowRecycleBinMap(edv_context_struct *ctx);
void EDVWindowPropertiesNew(
        edv_context_struct *ctx, const gchar *path, const gchar *tab_name
);
void EDVWindowOptionsMap(edv_context_struct *ctx);
void EDVWindowCustomizeMap(edv_context_struct *ctx);
void EDVWindowDevicesMap(edv_context_struct *ctx);
void EDVWindowMIMETypesMap(edv_context_struct *ctx);
void EDVWindowRunDialogMap(edv_context_struct *ctx);
void EDVWindowAboutDialogMap(edv_context_struct *ctx);

/*
 *	Creates a new file browser window.
 */
void EDVWindowBrowserNew(
	edv_context_struct *ctx, const gchar *path
)
{
	const gchar *window_name = "--file-browser";
	gchar *cmd;

	if(path != NULL)
	    cmd = g_strdup_printf(
		ENDEAVOUR_BIN_PATH " %s %s",
		window_name, path
	    );
	else
	    cmd = g_strdup_printf(
		ENDEAVOUR_BIN_PATH " %s",
		window_name
	    );
	Exec(cmd);
	g_free(cmd);
}

/*
 *      Creates a new image browser window.
 */
void EDVWindowImageBrowserNew(
        edv_context_struct *ctx, const gchar *path
)
{
        const gchar *window_name = "--image-browser";
        gchar *cmd;

        if(path != NULL)
            cmd = g_strdup_printf(
                ENDEAVOUR_BIN_PATH " %s %s",
                window_name, path
            );
        else
            cmd = g_strdup_printf(
                ENDEAVOUR_BIN_PATH " %s",
                window_name
            );
        Exec(cmd);
        g_free(cmd);
}

/*
 *      Creates a new archiver window.
 */
void EDVWindowArchiverNew(
        edv_context_struct *ctx, const gchar *path
)
{
        const gchar *window_name = "--archiver";
        gchar *cmd;

        if(path != NULL)
            cmd = g_strdup_printf(
                ENDEAVOUR_BIN_PATH " %s %s",
                window_name, path
            );
        else
            cmd = g_strdup_printf(
                ENDEAVOUR_BIN_PATH " %s",
                window_name
            );
        Exec(cmd);
        g_free(cmd);
}

/*
 *	Maps the recycle bin window.
 */
void EDVWindowRecycleBinMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--recycle-bin";
        gchar *cmd = g_strdup_printf(
	    ENDEAVOUR_BIN_PATH " %s",
	    window_name
	);
        Exec(cmd);
        g_free(cmd);
}

/*
 *      Creates a new properties window.
 */
void EDVWindowPropertiesNew(
        edv_context_struct *ctx, const gchar *path, const gchar *tab_name
)
{
        const gchar *window_name = "--properties";
        gchar *cmd;

        if(path != NULL)
            cmd = g_strdup_printf(
                ENDEAVOUR_BIN_PATH " %s %s",
                window_name, path
            );
        else
            cmd = g_strdup_printf(
                ENDEAVOUR_BIN_PATH " %s",
                window_name
            );
        Exec(cmd);
        g_free(cmd);
}

/*
 *	Maps the options window.
 */
void EDVWindowOptionsMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--options";
        gchar *cmd = g_strdup_printf(
            ENDEAVOUR_BIN_PATH " %s",
            window_name
        );
        Exec(cmd);
        g_free(cmd);
}

/*
 *      Maps the customize window.
 */
void EDVWindowCustomizeMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--customize";
        gchar *cmd = g_strdup_printf(
            ENDEAVOUR_BIN_PATH " %s",
            window_name
        );
        Exec(cmd);
        g_free(cmd);
}

/*
 *      Maps the devices window.
 */
void EDVWindowDevicesMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--devices";
        gchar *cmd = g_strdup_printf(
            ENDEAVOUR_BIN_PATH " %s",
            window_name
        );
        Exec(cmd);
        g_free(cmd);
}

/*
 *      Maps the mime types window.
 */
void EDVWindowMIMETypesMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--mimetypes";
        gchar *cmd = g_strdup_printf(
            ENDEAVOUR_BIN_PATH " %s",
            window_name
        );
        Exec(cmd);
        g_free(cmd);
}

/*
 *      Maps the run dialog.
 */
void EDVWindowRunDialogMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--run-dialog";
        gchar *cmd = g_strdup_printf(
            ENDEAVOUR_BIN_PATH " %s",
            window_name
        );
        Exec(cmd);
        g_free(cmd);
}


/*
 *      Maps the about dialog.
 */
void EDVWindowAboutDialogMap(edv_context_struct *ctx)
{
        const gchar *window_name = "--about-dialog";
        gchar *cmd = g_strdup_printf(
            ENDEAVOUR_BIN_PATH " %s",
            window_name
        );
        Exec(cmd);
        g_free(cmd);
}
