/*
 *	Prints a list of all recycled objects found in the recycle bin.
 *
 *	Use "recover" to recover a recycled object or "purge" to
 *	permanently purge it.
 */

#include <stdio.h>
#include <sys/stat.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	gchar **path;
	struct stat **stat_buf;
	guint *index;
	gint i, total = 0;

	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	/* Get a list of all recycled objects, here we obtain each
	 * recycled object's index, original full path, and statistics
	 *
	 * The returned path strings, statistics structures, and the
	 * pointer arrays must be deallocated.
	 */
	EDVRecycledObjectStatAll(
	    ctx, &path, &index, &stat_buf, &total
	);
	for(i = 0; i < total; i++)
	{
	    printf(
		"#%i\t%s\t%ld bytes\n",
		index[i], path[i], stat_buf[i]->st_size
	    );

	    g_free(path[i]);
	    g_free(stat_buf[i]);
	}
	g_free(path);
	g_free(index);
	g_free(stat_buf);

	printf("%i recycled objects found\n", i);

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
