/*
 *	Recycles the object specified from the command line, placing
 *	the object into the recycle bin.
 *
 *	No recursive recycling is supported, you may recycle directories
 *	but they must be empty.
 *
 *	Use "rls" to see what is currently recycled and "recover" to
 *	recover a recycled object.
 */

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include <endeavour2.h>

int main(int argc, char *argv[])
{
	edv_context_struct *ctx = EDVContextNew();
	EDVContextLoadConfigurationFile(ctx, NULL);

	if(argc >= 2)
	{
	    /* Recycle the object specified from the command line and
	     * get the index number of the new recycled object.
	     *
             * Note that notify is set to TRUE, which means that if
             * Endeavour2 is running then it will be aware of this
             * incident and update it's values to reflect the change.
             *
             * We skip the callback functions (last two arguments) by
             * setting them both NULL. This means that we are not
             * interested in the progress of this operation.
             */
	    const gchar *path = argv[1];
	    guint index = EDVRecycle(
		ctx, path, TRUE, NULL, NULL
	    );
	    if(index > 0)
		printf("%s: Recycled as index #%i.\n", path, index);
	    else
		printf("%s: %s.\n", path, EDVRecycleGetError(ctx));
	}
	else
	{
	    printf("%s: <file>\n", argv[0]);
	}

	EDVContextSync(ctx);
	EDVContextDelete(ctx);

	return(0);
}
