/*
 *	Runs Endeavour2 and instructs it to show the about dialog.
 *
 *	This example outlines the basic initialization and shutdown
 *	of the Endeavour2 context and using the context to send
 *	instructions to Endeavour2 (in this case, telling it to
 *	create a new file browser).
 */

#include <glib.h>	/* Needed by endeavour2.h. */
#include <endeavour2.h>	/* All applications using the Endeavour2 API
			 * must #include this.
			 */

int main(int argc, char *argv[])
{
	/* Create a new Endeavour2 context in which subsequent calls
	 * to the Endeavour2 API will need.
	 */
	edv_context_struct *ctx = EDVContextNew();

	/* Load the default configuration, this should always be done
	 * right after you create a new Endeavour2 context.
	 *
	 * Note that you must have installed Endeavour2 (runned it at
	 * least once) as this user to ensure that the configuration
	 * file exists.  The configuration file is read by this
	 * function.
	 */
	EDVContextLoadConfigurationFile(ctx, NULL);

	/* Run Endeavour2 (as needed) and have it show the about
	 * dialog.
	 */
	EDVAbout(ctx);

	/* You should frequently (e.g. once per loop) sync the
	 * Endeavour2 context so that all queued operations are flushed
	 * to the actual Endeavour2 process and that we wait (block)
	 * until all Endeavour2 procedures are sent back to us.
	 * You can also call EDVContextFlush() if you do not want to
	 * wait (block).
	 */
	EDVContextSync(ctx);

	/* Deallocate all resources on the Endeavour2 context, you
	 * should call this whenever you no longer need to use the
	 * context anymore.
	 */
	EDVContextDelete(ctx);

	return(0);
}
