/*
                 Endeavour History list window
 */

#ifndef HISTORYWIN_H
#define HISTORYWIN_H


#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvhistory.h"


/*
 *	Cell style index codes.
 */
#define EDV_HISTORY_CELL_STYLE_SUCCESS	0
#define EDV_HISTORY_CELL_STYLE_ERROR	1	/* General/system/ambiguous */
#define EDV_HISTORY_CELL_STYLE_CANCEL	2	/* Cancel/no/abort */

#define EDV_HISTORY_TOTAL_CELL_STYLES	3


/*
 *	History list window structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
        gint busy_count;

	gpointer core_ptr;

	GtkAccelGroup *accelgrp;

	GtkWidget	*toplevel,
			*main_vbox,
			*find_entry,
			*history_clist,
			*refresh_btn,
			*save_btn,
			*clear_btn,
			*close_btn;

	/* Right click menu. */
	GtkWidget	*menu,
			*refresh_mi,
			*save_mi,
			*clear_mi;

	/* Pixmap and mask pairs for icons used in the history_clist. */
	GdkPixmap *object_create_pixmap;
	GdkBitmap *object_create_mask;
        GdkPixmap *object_copy_pixmap;
        GdkBitmap *object_copy_mask;
        GdkPixmap *object_move_pixmap;
        GdkBitmap *object_move_mask;
        GdkPixmap *object_link_pixmap;
        GdkBitmap *object_link_mask;
        GdkPixmap *object_chown_pixmap;
        GdkBitmap *object_chown_mask;
        GdkPixmap *object_chmod_pixmap;
        GdkBitmap *object_chmod_mask;
        GdkPixmap *object_download_pixmap;
        GdkBitmap *object_download_mask;
        GdkPixmap *object_delete_pixmap;
        GdkBitmap *object_delete_mask;
        GdkPixmap *recobj_recover_pixmap;
        GdkBitmap *recobj_recover_mask;
        GdkPixmap *recobj_purge_pixmap;
        GdkBitmap *recobj_purge_mask;
        GdkPixmap *arcobj_add_pixmap;
        GdkBitmap *arcobj_add_mask;
        GdkPixmap *arcobj_extract_pixmap;
        GdkBitmap *arcobj_extract_mask;
        GdkPixmap *arcobj_delete_pixmap;
        GdkBitmap *arcobj_delete_mask;

        /* Styles for directory_ctree and contents_clist cells. */
        GtkStyle *cell_style[EDV_HISTORY_TOTAL_CELL_STYLES];

} edv_history_listwin_struct;


/* In historywin.c */
extern void EDVHistoryListWinSetRow(
	edv_history_listwin_struct *lw,
	gint row, edv_history_struct *h_ptr
);
extern void EDVHistoryListWinFetchValues(
	edv_history_listwin_struct *lw
);

extern edv_history_listwin_struct *EDVHistoryListWinNew(
	gpointer core_ptr
);
extern void EDVHistoryListWinUpdateMenus(
        edv_history_listwin_struct *lw
);
extern void EDVHistoryListWinSetBusy(
        edv_history_listwin_struct *lw, gbool is_busy
);
extern void EDVHistoryListWinMap(
        edv_history_listwin_struct *lw
);
extern void EDVHistoryListWinUnmap(
        edv_history_listwin_struct *lw
);
extern void EDVHistoryListWinDelete(
	edv_history_listwin_struct *lw
);





#endif	/* HISTORYWIN_H */
