/*
	                        Hex View Widget
 */

#ifndef HVIEW_H
#define HVIEW_H

#include <gtk/gtk.h>


/*
 *	Hex view widget structure:
 */
typedef struct {

	GtkWidget 	*toplevel;
	gboolean 	initialized;
	gboolean 	map_state;
	GdkVisibilityState	visibility;
	gint		busy_count;
	GdkCursor	*busy_cur,
			*text_cur,
			*translate_cur;
	GdkFont 	*font;
	GdkColormap	*colormap;
	GdkGC		*gc;
	gboolean	dragging_selection, dragging_scroll;
	gint		last_motion_x, last_motion_y;

	gint		cell_width, cell_height, cells_per_row;

	/* Column positions. */
	gint		address_x, hex_x, ascii_x;

	GtkAdjustment	*vadj;
	GtkWidget	*view_da,
			*vscrollbar,
			*status_label;
	GdkPixmap	*view_pm;
	guint		scroll_toid;

	/* Right click menu. */
	GtkWidget	*menu,
			*cut_mi,
			*copy_mi,
			*paste_mi,
			*insert_mi,
			*delete_mi,
			*edit_mode_hex_mi,
			*edit_mode_ascii_mi;

	/* Loaded data. */
	guint8 *buf;
	gint buf_len, buf_pos;
	gint buf_sel_start, buf_sel_end;

	/* Edit mode. */
	gint edit_mode;
#define HVIEW_EDIT_MODE_HEX	0
#define HVIEW_EDIT_MODE_ASCII	1

	/* If not 0, indicates the hex is being edited. When this is
	 * 1 then it means the user pressed one key to indicate the
	 * first character of the hex value, pressing another key
	 * finishes the editing.
	 */
	gint buf_hex_edit;
	/* Tempory buffer for holding the user typed hex characters. */
	gchar buf_hex_edit_buf[3];


	gboolean modified;

} hview_struct;

/* Returns TRUE if the buffer is selected (not nessisarly has selection
 * or FALSE if the buffer is not selected.
 */
#define HVIEW_IS_BUF_SELECTED(h)	( \
 ((h) != NULL) ? \
  (((h)->buf_sel_start > -1) && ((h)->buf_sel_end > -1)) : \
  FALSE \
)

/* Returns TRUE if the position i is in bounds. */
#define HVIEW_IS_BUF_POS_VALID(h,i)	( \
 ((h) != NULL) ? \
  (((h)->buf != NULL) && ((i) >= 0) && ((i) < (h)->buf_len)) : \
  FALSE \
)


extern gint HViewPositionXYToBuffer(hview_struct *hv, gint x, gint y);
extern void HViewScrollTo(hview_struct *hv, gint pos, gfloat ycoeff);
extern gint HViewIsBufferPositionVisible(hview_struct *hv, gint i);

extern gint HViewLoadFile(hview_struct *hv, const gchar *path);
extern gint HViewSaveFile(hview_struct *hv, const gchar *path);
extern void HViewClear(hview_struct *hv);

extern void HViewSetEditMode(hview_struct *hv, gint edit_mode);
extern void HViewSetSelected(hview_struct *hv, guint8 v);
extern void HViewSetPosition(hview_struct *hv, gint pos);
extern void HViewSelect(
	hview_struct *hv, gint start_pos, gint end_pos
);
extern void HViewCut(hview_struct *hv);
extern void HViewCopy(hview_struct *hv);
extern void HViewPaste(hview_struct *hv);
extern void HViewInsert(hview_struct *hv);
extern void HViewDeleteSelected(hview_struct *hv);
extern gint HViewFind(
        hview_struct *hv, const guint8 *needle, gint needle_len,
        gint start_pos, gboolean case_sensitive
);

extern hview_struct *HViewNew(GtkWidget *parent);
extern void HViewUpdateMenus(hview_struct *hv);
extern void HViewDraw(hview_struct *hv);
extern void HViewSetStatusMessage(
        hview_struct *hv, const gchar *mesg,
        gboolean allow_gtk_iteration
);
extern void HViewSetBusy(hview_struct *hv, gboolean is_busy);
extern void HViewMap(hview_struct *hv);
extern void HViewUnmap(hview_struct *hv);
extern void HViewDelete(hview_struct *hv);

#endif	/* HVIEW_H */
