/*
                          Endeavour Find Bar
 */

#ifndef FINDBAR_H
#define FINDBAR_H

#include <sys/stat.h>
#include <gtk/gtk.h>

#include "edvtypes.h"


/*
 *      Find operation codes:
 */
#define EDV_FINDBAR_FIND_OBJECT_NAME		0
#define EDV_FINDBAR_FIND_OBJECT_CONTENT		1

/*
 *	Find roles:
 */
#define EDV_FINDBAR_ROLE_DISK_OBJECT		0
#define EDV_FINDBAR_ROLE_RECYCLED_OBJECT	1
#define EDV_FINDBAR_ROLE_ARCHIVE_OBJECT		2


/*
 *	Find bar structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gbool processing;

	gpointer core_ptr;

	gint role;		/* One of EDV_FINDBAR_ROLE_*. */

	gint stop_count;

	GtkWidget *toplevel;

	GtkWidget *find_op_combo;
        GtkWidget *search_combo;
	GtkWidget *case_sensitive_check;
	GtkWidget *stop_btn;

	/* Status bar message callback, inputs are;
	 * edv_findbar_struct *fb, const gchar *mesg, gpointer client_data
	 */
	void (*status_message_cb)(gpointer, const gchar *, gpointer);

	/* status bar progress callback inputs are;
	 * edv_findbar_struct *fb, gfloat progress, gpointer client_data
	 */
	void (*status_progress_cb)(gpointer, gfloat, gpointer);

	/* Current location callback, inputs are; edv_findbar_struct *fb,
	 * gpointer client_data. Return snould be a string containing the
	 * current location. Note that this function is only called if
	 * the role is set to EDV_FINDBAR_ROLE_DISK_OBJECT.
	 */
	gchar *(*get_location_cb)(gpointer, gpointer);

	/* Find start callback, inputs are; edv_findbar_struct *fb,
	 * gpointer client_data.
	 */
	void (*start_cb)(gpointer, gpointer);

        /* Find end callback, inputs are; edv_findbar_struct *fb,
         * gint total_matches, gpointer client_data.
         */
        void (*end_cb)(gpointer, gint, gpointer);

	/* Matched path callback, inputs are; const gchar *path,
	 * const struct stat *lstat_buf, const gchar *excerpt,
	 * gpointer client_data
	 * If the role is set to EDV_FINDBAR_ROLE_RECYCLED_OBJECT then
	 * the path is a string containing the index of the recycled
	 * object.
	 */
        void (*match_cb)(
            const gchar *, const struct stat *, const gchar *, gpointer
	);

        gpointer client_data;

} edv_findbar_struct;


void EDVFindBarSetSearch(
        edv_findbar_struct *fb, const gchar *s,
        gbool record_history
);
extern gint EDVFindBarCurrentFindOP(edv_findbar_struct *fb);

extern edv_findbar_struct *EDVFindBarNew(
	gpointer core_ptr, GtkWidget *parent,
	gint role,		/* One of EDV_FINDBAR_ROLE_*. */
        void (*status_message_cb)(gpointer, const gchar *, gpointer),
        void (*status_progress_cb)(gpointer, gfloat, gpointer),
        gchar *(*get_location_cb)(gpointer, gpointer),
        void (*start_cb)(gpointer, gpointer),
        void (*end_cb)(gpointer, gint, gpointer),
        void (*match_cb)(
            const gchar *, const struct stat *, const gchar *, gpointer
	),
        gpointer client_data
);
extern void EDVFindBarUpdateMenus(edv_findbar_struct *fb);
extern void EDVFindBarMap(edv_findbar_struct *fb);
extern void EDVFindBarUnmap(edv_findbar_struct *fb);
extern void EDVFindBarDelete(edv_findbar_struct *fb);


#endif	/* FINDBAR_H */
