/*
                      Endeavour GTK+ Utility Functions

	These functions are different from those in edvutils.c because
	they require either the pointer to the core (edv_core_struct *)
	or GTK+ resources.
 */

#ifndef EDVUTILSGTK_H
#define EDVUTILSGTK_H

#include <sys/types.h>
#include <gtk/gtk.h>
#include "edvtypes.h"
#include "edvdevices.h"
#include "edvmimetypes.h"
#include "edvobj.h"
#include "browser.h"
#include "endeavour.h"

extern gchar *EDVGetObjectSizeStr(edv_core_struct *core_ptr, gulong i);

extern GdkCursor *EDVGetCursor(
	edv_core_struct *core_ptr, gint cursor_code
);

extern GtkCTreeNode *EDVNodeGetParent(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetChild(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetSibling(GtkCTreeNode *node);
extern GtkCTreeNode *EDVNodeGetToplevel(GtkCTree *ctree);

extern gint EDVCListGetSelectedLast(
        GtkCList *clist, GtkCListRow **row_ptr_rtn
);
extern GtkCTreeNode *EDVCTreeGetSelectedLast(
        GtkCTree *ctree, GtkCTreeRow **row_ptr_rtn
);

extern gboolean EDVNodeGetIndex(
        GtkCTree *ctree, GtkCTreeNode *node,
        gint *row_rtn, gint *column_rtn
);
extern GtkCTreeNode *EDVNodeGetByCoordinates(
        GtkCTree *ctree, gint x, gint y
);

extern void EDVScrollCListToPosition(
        GtkCList *clist, gfloat hpos, gfloat vpos
);

extern gboolean EDVObjectNameNotationOK(const gchar *name);
extern gboolean EDVCheckObjectHidden(
        edv_core_struct *core_ptr, edv_object_struct *object
);

extern gboolean EDVCheckWriteProtect(edv_core_struct *core_ptr, gboolean verbose);

extern gboolean EDVCheckUIDIsOwner(gint effective_uid, gint owner_id);
extern gboolean EDVCheckIsOwner(edv_core_struct *core_ptr, gint owner_id);

extern gboolean EDVCheckObjectAccessable(
        edv_core_struct *core_ptr, edv_object_struct *object
);
extern gboolean EDVCheckObjectReadable(
        edv_core_struct *core_ptr, edv_object_struct *object
);
extern gboolean EDVCheckObjectWriteable(
        edv_core_struct *core_ptr, edv_object_struct *object
);
extern gboolean EDVCheckObjectExecutable(
        edv_core_struct *core_ptr, edv_object_struct *object
);

extern gboolean EDVCheckImlibImage(
        edv_core_struct *core_ptr, const gchar *path
);
extern gboolean EDVCheckEDVArchiverArchive(
        edv_core_struct *core_ptr, const gchar *path
);

extern gint EDVMatchObjectIcon(
        edv_device_struct **device, gint total_devices,
        edv_mimetype_struct **mimetype, gint total_mimetypes,
        gint type,              /* One of EDV_OBJECT_TYPE_*. */
        const gchar *path,      /* Full path or just name. */
	gboolean link_valid, guint permissions,
        gint icon_size,         /* 0 = small, 1 = medium, 2 = large. */
        GdkPixmap **pixmap_closed, GdkBitmap **mask_closed,
        GdkPixmap **pixmap_opened, GdkBitmap **mask_opened,
        GdkPixmap **pixmap_extended, GdkBitmap **mask_extended
);
extern gint EDVMatchObjectTypeString(
        edv_mimetype_struct **mimetype, gint total_mimetypes,
        gint type,              /* One of EDV_OBJECT_TYPE_*. */
	guint permissions,
        const gchar *path,      /* Full path or just name. */
        gchar **type_str
);

extern void EDVShowFileInCDialog(
        const gchar *path, const gchar *title, gint cdialog_icon,
        GtkWidget *toplevel
);

extern void EDVCenterWindowToWindow(GtkWidget *w1, GtkWidget *w2);
extern void EDVEntrySetDND(edv_core_struct *core_ptr, GtkWidget *w);

extern void EDVCopyDiskObjectsToDDEPath(
        edv_core_struct *core_ptr,
        edv_object_struct **list, gint total
);
extern void EDVCopyDiskObjectsToDDEURL(
        edv_core_struct *core_ptr,
        edv_object_struct **list, gint total
);

extern void EDVAppendHistory(
        edv_core_struct *core_ptr,
        gint type,              /* One of EDV_HISTORY_*. */
        gulong time_start,      /* Time the operation first started. */
        gulong time_end,        /* Time the operation ended. */
        gint status,
        const gchar *src_path, const gchar *tar_path,
        const gchar *comments
);


#endif	/* EDVUTILSGTK_H */
