/*
                           Endeavour Status Bar
 */

#ifndef EDVSTATUSBAR_H
#define EDVSTATUSBAR_H

#include <gtk/gtk.h>
#include "edvtypes.h"


#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Status bar structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;
	gpointer core_ptr;

	GtkWidget *toplevel;		/* A GtkFrame. */
	GtkWidget *progress_bar;	/* A GtkProgressBar. */
	gfloat progress_pos_last;
	GtkWidget *label;		/* A GtkLabel. */

	GtkWidget	*write_protect_enabled_eb,
			*write_protect_disabled_eb;

} edv_status_bar_struct;


extern edv_status_bar_struct *EDVStatusBarNew(
        gpointer core_ptr, GtkWidget *parent
);
extern void EDVStatusBarUpdateMenus(edv_status_bar_struct *sb);
extern void EDVStatusBarMap(edv_status_bar_struct *sb);
extern void EDVStatusBarUnmap(edv_status_bar_struct *sb);
extern void EDVStatusBarDelete(edv_status_bar_struct *sb);

extern void EDVStatusBarMessage(
	edv_status_bar_struct *sb, const gchar *message,
	gbool allow_gtk_iteration
);
extern void EDVStatusBarProgress(
	edv_status_bar_struct *sb, gfloat percent,
	gbool allow_gtk_iteration
);

#endif	/* VMASTATUSBAR_H */
