/*
               Endeavour Recycle Bin File Operations
 */

#ifndef EDVRECBINFOP_H
#define EDVRECBINFOP_H

#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvrecbin.h"
#include "endeavour.h"


extern const gchar *EDVRecBinFOPGetError();

extern gint EDVRecBinFOPRecover(
        edv_core_struct *core_ptr,
	guint index,			/* Recycled object to recover. */
	const gchar *tar_obj,		/* Can be NULL. */
	gchar **new_obj_rtn,		/* Dynamically allocated. */
	GtkWidget *toplevel,		/* Can be NULL. */
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);

extern gint EDVRecBinFOPDelete(
	edv_core_struct *core_ptr,
	const gchar *path,		/* Disk object to delete. */
        guint **index_rtn, gint *total_index_rtns,
	GtkWidget *toplevel,		/* Can be NULL. */
	gbool show_progress, gbool interactive,
	gbool *yes_to_all
);

extern gint EDVRecBinFOPPurge(
        edv_core_struct *core_ptr,
        guint index,
        GtkWidget *toplevel,            /* Can be NULL. */
        gfloat progress_value,          /* Can be -1.0. */
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);
extern gint EDVRecBinFOPPurgeAll(
        edv_core_struct *core_ptr,
        GtkWidget *toplevel,            /* Can be NULL. */
        gbool show_progress, gbool interactive,
        gbool *yes_to_all
);



#endif	/* EDVRECBINFOP_H */
