/*
                          Recycle bin file IO
 */

#ifndef EDVRECBINFIO_H
#define EDVRECBINFIO_H

#include <stdio.h>
#include <glib.h>
#include "edvrecbin.h"


/*
 *	Recycle bin index file IO handle (reading only):
 */
typedef struct {

	/* Opened index file. */
	FILE *fp;

	/* Current index. */
	guint index;

        edv_recbin_object_struct *obj;

} edv_recbin_index_struct;



extern const gchar *EDVRecBinFIOGetError(void);


/* Recycled index file functions. */
extern gint EDVRecBinFIOTotalItems(const gchar *filename);
extern guint *EDVRecBinFIOGetIndexList(
        const gchar *filename, gint *total
);

extern edv_recbin_index_struct *EDVRecBinIndexOpen(
	const gchar *filename
);
extern gint EDVRecBinIndexNext(edv_recbin_index_struct *rbi_ptr);
extern void EDVRecBinIndexClose(edv_recbin_index_struct *rbi_ptr);

extern guint EDVRecBinIndexAdd(
        const gchar *filename, edv_recbin_object_struct *obj
);
extern gint EDVRecBinIndexRemove(
        const gchar *filename, gint index
);

/* Recycled object reference functions. */
extern edv_recbin_object_struct *EDVRecBinObjectStat(
        const gchar *filename,          /* recycled.ini */
        guint index                     /* Index of object stats to load. */
);

/* Deleting and recovering disk objects functions. */
extern gint EDVRecBinDiskObjectDelete(
        const gchar *index_filename,    /* recycled.ini */
        guint index,                    /* Put into recycled index file under this index. */
        const gchar *path,              /* Object to delete. */
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);
extern gint EDVRecBinDiskObjectRecover(
        const gchar *index_filename,    /* recycled.ini */
        guint index,                    /* Recycled object to recover. */
        const gchar *path,              /* Alternate recovery dir if not NULL. */
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);
extern gint EDVRecBinDiskObjectPurge(
        const gchar *index_filename,    /* recycled.ini */
        guint index,                    /* Recycled object to recover. */
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);
extern gint EDVRecBinDiskObjectPurgeAll(
        const gchar *index_filename,    /* recycled.ini */
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);


#endif	/* EDVRECBINFIO_H */
