#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "guiutils.h"
#include "cdialog.h"
#include "fb.h"
#include "stacklist.h"

#include "edvtypes.h"
#include "edvdate.h"
#include "edvcfg.h"
#include "browser.h"
#include "browsercb.h"
#include "optwin.h"
#include "edvoptions.h"
#include "endeavour.h"
#include "edvcfglist.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "config.h"

#include "images/icon_options2_48x48.xpm"

#include "images/endeavour_48x48.xpm"
#include "images/image_browser_48x48.xpm"
#include "images/archiver_48x48.xpm"
#include "images/icon_trash_empty_48x48.xpm"


static void EDVOptionsWarnDeleteMethodPurge(
	GtkWidget *widget, gpointer data
);
static void EDVOptionsBrowseProgramCB(gpointer button, gpointer data);

static void EDVCreateOptionsMiscPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateOptionsDatePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateOptionsConfirmationPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateOptionsProgramsPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateOptionsDisplayPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);
static void EDVCreateOptionsGeneralPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
);

edv_optwin_struct *EDVCreateOptionsWindow(
	gpointer core_ptr
);



/*
 *	Called whenever the radio button for the parameter
 *	EDV_DELETE_METHOID_PURGE has been "toggled".
 */
static void EDVOptionsWarnDeleteMethodPurge(
        GtkWidget *widget, gpointer data
)
{
	edv_core_struct *core_ptr = (edv_core_struct *)data;
	if((widget == NULL) || (core_ptr == NULL))
	    return;

	if(!GTK_IS_TOGGLE_BUTTON(widget))
	    return;

	if(GTK_TOGGLE_BUTTON(widget)->active)
	{
	    CDialogSetTransientFor(
		gtk_widget_get_toplevel(widget)
	    );
	    CDialogGetResponse(
#ifdef PROG_LANGUAGE_ENGLISH
		"Delete Method Warning",
"If you delete an object using this method, then you\n\
will not be able to recover that object!\n\
\n\
If you wish to use a safer method of deletion, please\n\
choose \"Moving Them To The Recycle Bin\" instead.",
#endif
#ifdef PROG_LANGUAGE_SPANISH
		"Borre Advertir De Mtodo",
"Si usted borra un objeto que usa este mtodo, entonces\n\
usted no ser capaz de recuperar que se opone!\n\
\n\
Si usted desea usar un mtodo ms seguro de la supresin,\n\
escoge por favor \"MoverLos Al Cajn de la Recirculacin\"\n\
en lugar. ",
#endif
#ifdef PROG_LANGUAGE_FRENCH
		"Effacer l'Avertissement De Mthode",
"Si vous effacez un objet en utilisant cette mthode,\n\
alors vous ne pourrez pas retrouver cet objet!\n\
\n\
Si vous souhaitez utiliser une mthode plus sre de\n\
suppression, s'il vous plat choisir se \"Transfrer Les\n\
Au Recycler l'Huche\" plutt.",
#endif
		NULL,
		CDIALOG_ICON_WARNING,
		CDIALOG_BTNFLAG_OK,
		CDIALOG_BTNFLAG_OK
	    );
	    CDialogSetTransientFor(NULL);
	}
}


/*
 *	Browse for program browse button "clicked" signal callback.
 */
static void EDVOptionsBrowseProgramCB(gpointer button, gpointer data)
{
	gbool status;
	GtkWidget *toplevel;
        fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
        gint total_ftypes = 0;
        gchar **path_rtn = NULL;
        gint total_path_rtns = 0;
	GtkEntry *entry = (GtkEntry *)data;
	if(entry == NULL)
	    return;


        if(FileBrowserIsQuery())
            return;

	toplevel = gtk_widget_get_toplevel(GTK_WIDGET(entry));

        FileBrowserTypeListNew(
            &ftype, &total_ftypes,
            "*.*", "All files"
        );

	/* Query user for program path. */
        FileBrowserSetTransientFor(toplevel);
        status = FileBrowserGetResponse(
            "Select Program",
            "Select", "Cancel",
	    gtk_entry_get_text(entry),		/* Startup path. */
            ftype, total_ftypes,
            &path_rtn, &total_path_rtns,
            &ftype_rtn
        );
        FileBrowserSetTransientFor(NULL);

        /* Got user response? */
        if(status)
        {
            const gchar *new_path = (total_path_rtns > 0) ?
                path_rtn[0] : NULL;
            if((new_path != NULL) ? (*new_path != '\0') : FALSE)
		gtk_entry_set_text(entry, new_path);
        }

        /* Deallocate file types list. */
        FileBrowserDeleteTypeList(ftype, total_ftypes);
}


/*
 *      Create misc page on options window.
 */
static void EDVCreateOptionsMiscPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
	GtkAdjustment *adj;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


        /* Pointer operations frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Pointer Operations"
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "Las Operaciones De La Flecha"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Oprations De Pointeur"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* "Right click menus also select" check button. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Select Before Mapping Right Click Menus"
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "Escoja Antes De Trazar Mens De Chasquido De Derecho"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Choisir Avant Les Menus De Dclic De Droite De Mapping"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this if you want the item under the pointer to be selected\
 when you map the right click menu"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"El cheque este si usted quiere que el artculo bajo la flecha para sea\
 escogido cuando usted traza el men correcto del chasquido"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Le chque ceci si vous voulez que l'article sous le pointeur soit\
 choisi quand vous la carte le bon menu de dclic"
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RIGHT_CLICK_MENU_SELECTS
        );


        /* History frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "History"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Historia"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Histoire"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;


        /* History events max. */
	w = gtk_label_new("Maximum History Events:");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);

	/* Spin. */
        adj = (GtkAdjustment *)gtk_adjustment_new(
            1000000.0, 0.0, 1000000.0, 10.0, 100.0, 100.0
	);
        w = gtk_spin_button_new(adj, 1.0, 0);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_set_usize(w, 120, -1);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_HISTORY_EVENTS_MAX
        );


}

/*
 *      Create date/time page on options window.
 */
static void EDVCreateOptionsDatePage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GSList *gslist;
	gpointer label_rtn, entry_rtn;
        GtkWidget *w, *parent2;
        edv_cfg_wref_struct *wref;


        /* Relativity frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
"Relativity"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"El Tiempo Relativo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Temps Relatif"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_hbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* Absolute radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(
	    gslist,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Absolute"
#endif
#ifdef PROG_LANGUAGE_SPANISH
	    "Absolute"
#endif
#ifdef PROG_LANGUAGE_FRENCH
	    "Absolu"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to display date & time strings relative to the beginning of\
 time defined for the current locale"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto demostrar la fecha & el pariente de cuerdas de tiempo\ 
 al tiempo del principio of definido para el locale actual"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour montrer la date & les ficelles de temps relatives\
 au temps de of premier dfini pour le locale actuel"
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_DATE_RELATIVITY
        );
        wref->radio_value = EDV_DATE_RELATIVITY_ABSOLUTE;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        /* Current radio button. */
        w = gtk_radio_button_new_with_label(
	    gslist,
#ifdef PROG_LANGUAGE_ENGLISH
            "Current"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Corriente"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Courant"
#endif
	);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to display date & time strings relative to the current time"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto demostrar la fecha & el pariente de cuerdas de tiempo\
 al tiempo actual"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour montrer la date & les ficelles de temps relatives\
 au temps actuel"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_DATE_RELATIVITY
        );
        wref->radio_value = EDV_DATE_RELATIVITY_CURRENT;


        /* Date format. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Date Format"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Formato De La Fecha"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Dater Le Format"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

	/* Format string prompt. */
	w = (GtkWidget *)GUIPromptBar(
	    NULL, "Format String:",
	    &label_rtn, &entry_rtn
	);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            (GtkWidget *)entry_rtn,
#ifdef PROG_LANGUAGE_ENGLISH
"Enter the format string for all displayed date & time values\
 (see \"man strftime\" for available substitutions)"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Entre la cuerda de formato por toda fecha demostrada & los valores\
 de tiempo (ve \"man strftime\" para sustituciones disponibles)"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Entrer la ficelle de format pour toute date montre & les valeurs\
 de temps (voit \"man strftime\" pour les remplacements disponibles)"
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, (GtkWidget *)entry_rtn, NULL,
            EDV_CFG_PARM_DATE_FORMAT
        );



}


/*
 *      Create confirmation page on options window.
 */
static void EDVCreateOptionsConfirmationPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


        /* File operations frame. */
        w = gtk_frame_new("Confirm When");
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_major);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;


	/* Disk object operation confirmations set vbox. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* "Moving an object" check button. */
        w = gtk_check_button_new_with_label("Moving an object");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_MOVE
        );

        /* "Copying an object" check button. */
        w = gtk_check_button_new_with_label("Copying an object");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_COPY
        );

        /* "Linking an object" check button. */
        w = gtk_check_button_new_with_label("Linking an object");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_LINK
        );

        /* "Deleting an object" check button. */
        w = gtk_check_button_new_with_label("Deleting an object");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_DELETE
        );


        /* Archive operation confirmations set vbox. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* "Adding object to archive" check button. */
        w = gtk_check_button_new_with_label("Adding object to archive");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_ARCHIVE_ADD
        );

	/* "Extracting object from archive" check button. */
	w = gtk_check_button_new_with_label("Extracting object from archive");
	gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_ARCHIVE_EXTRACT
        );

        /* "Deleting object from archive" check button. */
        w = gtk_check_button_new_with_label("Deleting object from archive");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_ARCHIVE_DELETE
        );


        /* Recycled object operation confirmations set vbox. */
        w = gtk_vbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* "Recovering an object" check button. */
        w = gtk_check_button_new_with_label("Recovering an object");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_RECOVER
        );

        /* "Purging an object from recycle bin" check button. */
        w = gtk_check_button_new_with_label(
	    "Purging an object from the Recycle Bin"
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_PURGE
        );

        /* "Downloading an object" check button. */
        w = gtk_check_button_new_with_label(
            "Downloading an object"
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_CONFIRM_DOWNLOAD
        );

}

/*
 *      Create programs page on options window.
 */
static void EDVCreateOptionsProgramsPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
	const gchar *label, *cfg_parm;
	gpointer label_rtn, entry_rtn, browse_rtn;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;


        /* Create a scrolled window to allow scrolling through the many
	 * widgets on this page.
	 */
        w = gtk_scrolled_window_new(NULL, NULL);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_scrolled_window_set_policy(
            GTK_SCROLLED_WINDOW(w),
            GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC
        );
        gtk_widget_show(w);
        parent2 = w;

        /* Create a vbox as the first child in the scrolled window, it
	 * will be used as a contained to neatly hold all subsequent
	 * widgets.
	 */
        w = gtk_vbox_new(FALSE, border_major);
        gtk_scrolled_window_add_with_viewport(
            GTK_SCROLLED_WINDOW(parent2), w
        );
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

#define DO_CREATE_PROMPT	\
{ \
 w = (GtkWidget *)GUIPromptBarWithBrowse( \
  NULL, label, \
  &label_rtn, &entry_rtn, &browse_rtn, \
  NULL, NULL \
 ); \
 gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0); \
 gtk_widget_show(w); \
 w = (GtkWidget *)browse_rtn; \
 if(w != NULL) \
  gtk_signal_connect( \
   GTK_OBJECT(w), "clicked", \
   GTK_SIGNAL_FUNC(EDVOptionsBrowseProgramCB), entry_rtn \
  ); \
 w = (GtkWidget *)entry_rtn; \
 EDVEntrySetDND(core_ptr, w); \
 wref = OptWinWRefAppend( \
  optwin, w, NULL, cfg_parm \
 ); \
}

        /* Terminals programs frame. */
        w = gtk_frame_new("Terminals");
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        label = "Terminal:";
        cfg_parm = EDV_CFG_PARM_PROG_TERMINAL;
        DO_CREATE_PROMPT

#ifdef PROG_LANGUAGE_ENGLISH
        label = "Terminal & Run Program:";
#endif
#ifdef PROG_LANGUAGE_SPANISH
        label = "Terminal & Corra Program:";
#endif
#ifdef PROG_LANGUAGE_FRENCH
        label = "Terminal & Courir Program:";
#endif
        cfg_parm = EDV_CFG_PARM_PROG_TERMINAL_RUN;
        DO_CREATE_PROMPT


        /* Archiver programs frame. */
        w = gtk_frame_new("Archivers");
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        label = "ARJ:";
        cfg_parm = EDV_CFG_PARM_PROG_ARJ;
        DO_CREATE_PROMPT

	label = "RPM:";
	cfg_parm = EDV_CFG_PARM_PROG_RPM;
	DO_CREATE_PROMPT

        label = "TAR:";
        cfg_parm = EDV_CFG_PARM_PROG_TAR;
        DO_CREATE_PROMPT

	label = "Zip:";
        cfg_parm = EDV_CFG_PARM_PROG_ZIP;
        DO_CREATE_PROMPT

        label = "UnZip:";
        cfg_parm = EDV_CFG_PARM_PROG_UNZIP;
        DO_CREATE_PROMPT

        label = "Compress:";
        cfg_parm = EDV_CFG_PARM_PROG_COMPRESS;
        DO_CREATE_PROMPT

        label = "UnCompress:";
        cfg_parm = EDV_CFG_PARM_PROG_UNCOMPRESS;
        DO_CREATE_PROMPT

        label = "GZip:";
        cfg_parm = EDV_CFG_PARM_PROG_GZIP;
        DO_CREATE_PROMPT

        label = "GUnZip:";
        cfg_parm = EDV_CFG_PARM_PROG_GUNZIP;
        DO_CREATE_PROMPT

        label = "BZip2:";
        cfg_parm = EDV_CFG_PARM_PROG_BZIP2;
        DO_CREATE_PROMPT

        label = "BUnZip2:";
        cfg_parm = EDV_CFG_PARM_PROG_BUNZIP2;
        DO_CREATE_PROMPT

        /* Network programs frame. */
        w = gtk_frame_new("Network");
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent3), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent3 = w;

        label = "Download:";
        cfg_parm = EDV_CFG_PARM_PROG_NET_DOWNLOAD;
        DO_CREATE_PROMPT



#undef DO_CREATE_PROMPT
}

/*
 *      Create display page on options window.
 */
static void EDVCreateOptionsDisplayPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
	GList *glist;
	gpointer combo_rtn;
        GtkWidget *w, *parent2;
        edv_cfg_wref_struct *wref;


        /* Image quality frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Quality"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Calidad"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "La Qualit"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;


        /* Create glist containing a list of image quality setting strings,
	 * enumerated to match the image quality values in the
	 * configuration list.
         */
        glist = NULL;
#ifdef PROG_LANGUAGE_ENGLISH
        glist = g_list_append(glist, "Poor/Fastest");
        glist = g_list_append(glist, "Medium/Optimal");
        glist = g_list_append(glist, "Best/Slowest");
#endif
#ifdef PROG_LANGUAGE_SPANISH
        glist = g_list_append(glist, "Pobre/Rapidamente");
        glist = g_list_append(glist, "El Medio/Optimul");
	glist = g_list_append(glist, "Mejor/Ms Lento");
#endif
#ifdef PROG_LANGUAGE_FRENCH
        glist = g_list_append(glist, "Pauvre/Jene");
        glist = g_list_append(glist, "Milieu/Optimul");
        glist = g_list_append(glist, "Mieux/Le Plus Lent");
#endif

        /* Image quality combo. */
        w = (GtkWidget *)GUIComboCreate(
	    NULL,
            (const gchar *)((glist != NULL) ? glist->data : ""),
            glist,
            3,		/* Maximum items. */
            &combo_rtn,
            NULL,
	    NULL,
            NULL
        );
        gtk_widget_set_usize(w, 250, -1);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

	w = (GtkWidget *)combo_rtn;
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_IMAGE_QUALITY
        );

	w = GTK_COMBO(w)->entry;
	gtk_entry_set_editable(GTK_ENTRY(w), FALSE);


        /* Lists frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Lists"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Lists"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Lists"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;


        /* Animate list items during updates. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Animate Updates"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Anime Actualice"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Animer Des Mises A Jour"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to animate list items during updates (where available)"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto animar artculos de lista durante actualiza (donde\
 disponible)"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour animer les articles de liste pendant les mises \
 jour (o disponible)"
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_LISTS_ANIMATE_UPDATES
        );


        /* Double buffer lists. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Double Buffer"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Memoria Intermedia Doble"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Tampon Double"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to use double buffers for lists, this will produce\
 smoother updates but slow down performance"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto usar las memorias intermedias dobles para listas,\
 esto producir ms liso actualiza pero va ms despacio el desempeo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour utiliser des tampons doubles pour les listes,\
 ceci produira des mises  jour plus lisses mais ralentit l'excution"
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_LISTS_DOUBLE_BUFFER
        );






}

/*
 *      Create general page on options window.
 */
static void EDVCreateOptionsGeneralPage(
        edv_core_struct *core_ptr, edv_optwin_struct *optwin,
        GtkWidget *parent
)
{
        gint border_minor = 2, border_major = 5;
        GtkWidget *w, *parent2, *parent3;
        edv_cfg_wref_struct *wref;
	GSList *gslist;


        /* Startup with frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Startup With"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Arranque Con"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Mettre En Route Avec"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;


	/* First row hbox. */
	w = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	gtk_widget_show(w);
	parent3 = w;

        /* `Start up with file browser' check button. */
	w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
	    (u_int8_t **)endeavour_48x48_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "File\nBrowser",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Examinador\nDe Archivo",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Browser\nDe Fichier",
#endif
	    NULL
	);
	gtk_widget_set_usize(w, 80, 80);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_STARTUP_BROWSER
        );

        /* `Start up with image browser' check button. */
        w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
            (u_int8_t **)image_browser_48x48_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Image\nBrowser",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Examinador\nDe Imagen",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Browser\nD'Image",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, 80, 80);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_STARTUP_IMBR
        );

        /* `Start up with archiver' check button. */
        w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
            (u_int8_t **)archiver_48x48_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Archiver",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Archiver",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Archiver",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, 80, 80);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_STARTUP_ARCHIVER
        );

        /* `Start up with recycle bin' check button. */
        w = (GtkWidget *)GUIToggleButtonPixmapLabelV(
            (u_int8_t **)icon_trash_empty_48x48_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Recycle\nBin",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Cajn De\nRecirculacin",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Recycle\nL'Huche",
#endif
	    NULL
        );
        gtk_widget_set_usize(w, 80, 80);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_STARTUP_RECBIN
        );


        /* Startup location frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Startup Location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Ubicacin De Startup"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Emplacement De Dmarrage"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

	/* Record start up directory check. */
        w = gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
            "Automatically Record Last Location"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Automticamente Registro Dura La Ubicacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Automatiquement Le Disque Dure L'Emplacement"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	GUISetWidgetTip(
	    w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to automatically update the start up location for\
 the next session based on the location that was last accessed\
 during this session.\
 You do not need to modify the start up location below\
 if this is checked."
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto actualizar automticamente el arranca la ubicacin\
 para la prxima sesin basada en la ubicacin que era ltima accesado.\
 Cundo esto se verifica, usted no necesita modificar el arranca el\
 valor de la ubicacin abajo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci automatiquement pour mettre  jour le met\
 en route l'emplacement pour la sance prochaine base sur\
 l'emplacement qui tait dernier accessed. Quand ceci est vrifi,\
 vous n'avez pas besoin de modifier le met en route la valeur\
 d'emplacement au dessous"
#endif
	);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECORD_START_UP_DIR
        );

	/* Start up directory entry. */
        w = gtk_entry_new();
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	EDVEntrySetDND(core_ptr, w);
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_DIR_START_UP
        );



        /* Delete method frame. */
        w = gtk_frame_new(
#ifdef PROG_LANGUAGE_ENGLISH
	    "Delete Objects By"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Borre Objetos Por"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Effacer Des Pbjets Pa"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
        gtk_frame_set_shadow_type(GTK_FRAME(w), GTK_SHADOW_ETCHED_IN);
        gtk_widget_show(w);
        parent2 = w;

        w = gtk_vbox_new(FALSE, border_minor);
        gtk_container_add(GTK_CONTAINER(parent2), w);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_widget_show(w);
        parent2 = w;

	/* Hbox for radio buttons. */
        w = gtk_hbox_new(FALSE, border_minor);
	gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        /* Moving to recycle bin radio button. */
        gslist = NULL;
        w = gtk_radio_button_new_with_label(
	    gslist,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Moving Them To The Recycle Bin"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "MoverLos Al Cajn De La Recirculacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Se Transfrer Les Au Recycler l'Huche"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to move the objects to the Recycle Bin when deleting them."
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto mover los objetos al Cajn de la Recirculacin cuando borrarles."
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour se transfrer les objets au Recycle l'Huche en effaant les."
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_DELETE_METHOD
        );
        wref->radio_value = EDV_DELETE_METHOD_MOVE_TO_RECBIN;
        gslist = gtk_radio_button_group(GTK_RADIO_BUTTON(w));

        w = gtk_radio_button_new_with_label(
	    gslist,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Permanently Purging Them"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Permanentemente Purging Ellos"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "D'une Faon permanente Purger Les"
#endif
	);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to permanently purge the objects when deleting them,\
 you will not have any chance to recover the objects once you\
 delete them!"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto a permanentemente purge los objetos cuando borrarlos,\
 usted no tendr fortuito recuperar los objetos una vez you los borra!"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci d'une faon permanente pour purger les objets en\
 effaant les, vous n'aurez pas d'hasard pour retrouver les objets\
 une fois you les efface!"
#endif
	);
        gtk_signal_connect(
            GTK_OBJECT(w), "toggled",
            GTK_SIGNAL_FUNC(EDVOptionsWarnDeleteMethodPurge),
	    core_ptr
        );
	gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_DELETE_METHOD
        );
        wref->radio_value = EDV_DELETE_METHOD_PURGE;

        /* "Warn when size exceeds". */
        w = gtk_hbox_new(FALSE, border_minor);
        gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
        gtk_widget_show(w);
        parent3 = w;

        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Warn When Total Size Exceeds:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Advierta Cundo Tamao De Suma Excede:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Avertir Quand La Taille Totale Dpasse:"
#endif
        );
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        w = gtk_entry_new();
        gtk_widget_set_usize(w, 150, -1);
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        EDVEntrySetDND(core_ptr, w);
        GUISetWidgetTip(
            w,
#ifdef PROG_LANGUAGE_ENGLISH
"When the total size of all recycled objects exceeds this many bytes,\
 a warning will be printed to the user at start up. You can also\
 specify a value of 0 to disable this feature"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Cundo el tamao total de todos objetos de recycled excede este\
 valor, una advertencia ser impresa al usuario en arranca. Usted puede\
 especificar tambin un valor de 0 en incapacitar este cheque"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Quand la taille totale de tous objets recycls dpasse cette valeur,\
 un avertissement sera imprim  l'utilisateur  met en route. Vous\
 pouvez spcifier aussi une valeur de 0 rendre infirme ce chque"
#endif
        );
        gtk_widget_show(w);
        wref = OptWinWRefAppend(
            optwin, w, NULL,
            EDV_CFG_PARM_RECBIN_SIZE_WARN
        );

        w = gtk_label_new("Bytes");
        gtk_box_pack_start(GTK_BOX(parent3), w, FALSE, FALSE, 0);
        gtk_widget_show(w);



}

/*
 *	Creates a new options window.
 */
edv_optwin_struct *EDVCreateOptionsWindow(
        gpointer core_ptr
)
{
        gint /* border_minor = 2, */ border_major = 5;
        GtkWidget *w, *parent, *parent2;
        edv_optwin_struct *optwin = OptWinNew(
            core_ptr,
#ifdef PROG_LANGUAGE_ENGLISH
            "Options",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Las Opciones",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Options",
#endif
	    (guint8 **)icon_options2_48x48_xpm);
        if(optwin == NULL)
            return(optwin);


        /* Begin creating general page. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "General"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "General"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Gnral"
#endif
	);
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;

            EDVCreateOptionsGeneralPage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
        }

        /* Begin creating display page. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Display"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Grfica"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Les Graphiques"
#endif
        );
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;

            EDVCreateOptionsDisplayPage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
        }

        /* Begin creating programs page. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Programs"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Los Programas"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Programmes"
#endif
	);
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;

            EDVCreateOptionsProgramsPage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
        }

        /* Begin creating confirmation page. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Confirmation"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Confirmacin"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Confirmation"
#endif
	);
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;

            EDVCreateOptionsConfirmationPage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
	}

        /* Begin creating date & time page. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Date & Time"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "La Fecha Y El Tiempo"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Date Et Temps"
#endif
	);
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
	    gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;

            EDVCreateOptionsDatePage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
        }

        /* Begin creating misc page. */
        w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
            "Misc"
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Otro"
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Autre"
#endif
	);
        parent = OptWinPageAppend(optwin, w);
        if(parent != NULL)
        {
            gtk_container_border_width(GTK_CONTAINER(parent), border_major);
            gtk_box_set_spacing(GTK_BOX(parent), border_major);
            parent2 = parent;

            EDVCreateOptionsMiscPage(
                (edv_core_struct *)core_ptr, optwin, parent2
            );
        }


        return(optwin);
}
