/*
                     Endeavour MIME Types File IO
 */

#ifndef EDVMIMETYPESFIO_H
#define EDVMIMETYPESFIO_H

#include <glib.h>
#include "edvtypes.h"
#include "edvmimetypes.h"
#include "endeavour.h"


/* Mailcap format reading and writing. */
extern void EDVMimeTypeListImportMailCap(
        const gchar *filename,
        edv_mimetype_struct ***list, gint *total,
        gint insert_index,
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer progress_client_data,
	void (*add_emit)(edv_core_struct *, gint, edv_mimetype_struct *),
        gpointer add_emit_core
);
extern void EDVMimeTypeListExportMailCap(
        const gchar *filename,
        edv_mimetype_struct **list, gint total,
        gbool include_read_only,
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);

/* Media Types format reading and writing. */
extern void EDVMimeTypeListImportMediaTypes(
        const gchar *filename,
        edv_mimetype_struct ***list, gint *total,
        gint insert_index,
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer progress_client_data,
        void (*add_emit)(edv_core_struct *, gint, edv_mimetype_struct *),
        gpointer add_emit_core
);
extern void EDVMimeTypeListExportMediaTypes(
        const gchar *filename,
        edv_mimetype_struct **list, gint total,
        gbool include_read_only,
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);

/* Endeavour MIME Types format reading and writing. */
extern void EDVMimeTypeListLoadFromFile(
        const gchar *filename,
        edv_mimetype_struct ***list, gint *total,
        gint insert_index,
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer progress_client_data,
        void (*add_emit)(edv_core_struct *, gint, edv_mimetype_struct *),
        gpointer add_emit_core,
	gbool mark_all_loaded_read_only
);
extern void EDVMimeTypeListSaveToFile(
        const gchar *filename,
        edv_mimetype_struct **list, gint total,
        gbool include_read_only,
        gint (*progress_cb)(gpointer, gulong, gulong),
        gpointer client_data
);


#endif	/* EDVMIMETYPESFIO_H */
