/*
              Endeavour Operation History Events List
 */

#ifndef EDVHISTORY_H
#define EDVHISTORY_H


#include <glib.h>


/*
 *	History types:
 */
#define EDV_HISTORY_NONE			0
#define EDV_HISTORY_DISK_OBJECT_CREATE		10
#define EDV_HISTORY_DISK_OBJECT_COPY		11
#define EDV_HISTORY_DISK_OBJECT_MOVE		12	/* Or rename. */
#define EDV_HISTORY_DISK_OBJECT_LINK		13
#define EDV_HISTORY_DISK_OBJECT_CHOWN		14
#define EDV_HISTORY_DISK_OBJECT_CHMOD		15
#define EDV_HISTORY_DISK_OBJECT_DOWNLOAD	16
#define EDV_HISTORY_DISK_OBJECT_DELETE		20
#define EDV_HISTORY_RECYCLED_OBJECT_RECOVER	21
#define EDV_HISTORY_RECYCLED_OBJECT_PURGE	22
#define EDV_HISTORY_RECYCLED_OBJECT_PURGE_ALL	23
#define EDV_HISTORY_ARCHIVE_OBJECT_ADD		30
#define EDV_HISTORY_ARCHIVE_OBJECT_EXTRACT	31
#define EDV_HISTORY_ARCHIVE_OBJECT_DELETE	32

/*
 *	History item structure:
 */
typedef struct {

	gint type;		/* One of EDV_HISTORY_*. */

	gulong time_start;	/* Time the operation first started. */
	gulong time_end;	/* Time the operation ended. */

	/* Result of operation, valid codes are:
	 *
	 *	0	Success
	 *	-1	General error
	 *	-2	Ambiguous, bad value, unable to interprite, etc
	 *	-3	Systems error
	 *	-4	Cancel, abort, or user response not available
	 *	-5	User responded with `No'
	 *	-6	Operation would cause re-entry
	 */
	gint status;

	/* Full path to source and target objects in most cases.
	 *
	 * If the object is a recycled object then one of these may be
	 * a string specifying an index number of the recycled object.
	 *
	 * If the object is an archive object then one of these may be
	 * a relative (but complete) path to the archive object within
	 * the archive.
 	 */
	gchar *src_path, *tar_path;

	gchar *comments;

} edv_history_struct;


extern edv_history_struct *EDVHistoryNew(void);
extern void EDVHistoryDelete(edv_history_struct *h);

extern void EDVHistoryDiskObjectSet(
	edv_history_struct *h,
	gint type,
	gulong time_start, gulong time_end,
        gint status,
	const gchar *src_path, const gchar *tar_path,
	const gchar *comments
);

extern edv_history_struct *EDVHistoryListAppendNew(
	edv_history_struct ***list, gint *total,
	gint *n, gint max
);


#endif	/* EDVHISTORY_H */
