#include <gtk/gtk.h>

#include "edvcursor.h"


/*
 *	Creates a new cursor based on the given GDK cursor type code.
 */
edv_cursor_struct *EDVCursorNewByGDKPreset(
        gint cursor_code, GdkCursorType gdk_cursor_type
)
{
	edv_cursor_struct *cur = (edv_cursor_struct *)g_malloc0(
	    sizeof(edv_cursor_struct)
	);
	if(cur == NULL)
	    return(cur);

	cur->code = cursor_code;
	cur->cursor = gdk_cursor_new(gdk_cursor_type);

	return(cur);
}

/*
 *	Destroys all resources for the given cursor and deallocates the
 *	structure itself.
 */
void EDVCursorDelete(edv_cursor_struct *cur)
{
	if(cur == NULL)
	    return;

	/* Unref the GDK cursor. */
	if(cur->cursor != NULL)
	{
	    gdk_cursor_destroy(cur->cursor);
	    cur->cursor = NULL;
	}

	/* Deallocate structure itself. */
	g_free(cur);
}
