/*
                             Desktop Icon
 */

#ifndef DESKICON_H
#define DESKICON_H

#include <gtk/gtk.h>

#ifndef gbool
# define gbool	gboolean
#endif


/*
 *	Desktop icon structure:
 */
typedef struct {

	gbool initialized;
	gbool map_state;

	GdkGC *gc;

	GtkWidget *icon_toplevel, *icon_da;
	GdkPixmap *icon_pixmap;
	GdkBitmap *icon_mask;

	GtkWidget *label_toplevel, *label;
	gchar *label_str;

	GtkWidget *menu;

	/* Size of icon_toplevel. */
	gint icon_width, icon_height;

	/* Determines which button is currently held down. */
	gint button_down;

	/* Last pointer event relative to the root window. */
	gint last_x, last_y;

	/* Map referenced window callback, called when this icon has
	 * been double clicked on. Arguments are deskicon_struct *di
	 * and gpointer client_data.
	 */
	void (*map_ref_cb)(gpointer, gpointer);
	gpointer map_ref_client_data;

        /* Moved callback, called when this icon has been moved to its
	 * final location. Arguments are deskicon_struct *, gint x,
         * gint y, and gpointer client_data.
	 * The x and y values are the upper left corner of the icon 
	 * relative to the root window.
         */
        void (*moved_cb)(gpointer, gint, gint, gpointer);
	gpointer moved_client_data;

} deskicon_struct;


extern void DeskIconGetPosition(
        deskicon_struct *di, gint *x, gint *y
);
extern void DeskIconSetPosition(
        deskicon_struct *di, gint x, gint y
);

extern deskicon_struct *DeskIconNew(
	gint x, gint y,
	guchar **icon_data, const gchar *label
);
extern void DeskIconSet(
	deskicon_struct *di,
        guchar **icon_data, const gchar *label
);
extern void DeskIconSetMapRefCB(
	deskicon_struct *di,
	void (*map_ref_cb)(gpointer, gpointer),
	gpointer client_data
);
extern void DeskIconSetMovedCB(
        deskicon_struct *di,
        void (*moved_cb)(gpointer, gint, gint, gpointer),
        gpointer client_data
);
extern void DeskIconSetMenu(deskicon_struct *di, GtkWidget *w);
extern GtkWidget *DeskIconGetMenu(deskicon_struct *di);
extern void DeskIconMap(deskicon_struct *di);
extern void DeskIconUnmap(deskicon_struct *di);
extern void DeskIconDelete(deskicon_struct *di);




#endif	/* DESKICON_H */
