#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>

#include "../include/string.h"
#include "../include/disk.h"

#include "guiutils.h"
#include "cdialog.h"
#include "progressdialog.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "edvobj.h"
#include "edvconfirm.h"
#include "edvrecbin.h"
#include "edvrecbinfio.h"
#include "edvrecbinfop.h"
#include "edvdevices.h"
#include "edvmount.h"
#include "fopdialog.h"
#include "browser.h"
#include "browsercb.h"
#include "browseropcb.h"
#include "browsercontents.h"
#include "browserdirtree.h"
#include "browsercontents.h"
#include "endeavour.h"
#include "edvfcreate.h"
#include "edvcb.h"
#include "edvop.h"
#include "edvutils.h"
#include "edvutilsgtk.h"
#include "edvcfglist.h"
#include "config.h"


void EDVBrowserMenuItemCB(GtkWidget *widget, gpointer data);
gint EDVBrowserMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
gint EDVBrowserMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
void EDVBrowserOPCB(gpointer data);
void EDVBrowserOPEnterCB(gpointer data);
void EDVBrowserOPLeaveCB(gpointer data);

void EDVBrowserMountBarMountCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);
void EDVBrowserMountBarEjectCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);
void EDVBrowserMountBarGoToCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
);

gchar *EDVBrowserFindBarLocationCB(gpointer fb, gpointer data);
void EDVBrowserFindBarStartCB(gpointer fb, gpointer data);
void EDVBrowserFindBarEndCB(
        gpointer fb, gint total_matches, gpointer data
);
void EDVBrowserFindBarMatchCB(
	const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
	gpointer data
);

void EDVBrowserBarStatusMessageCB(
        gpointer bar, const gchar *message, gpointer data
);
void EDVBrowserBarStatusProgressCB(
        gpointer bar, gfloat progress, gpointer data
);

void EDVBrowserOPSyncDisks(edv_browser_struct *browser);
void EDVBrowserOPWriteProtect(edv_browser_struct *browser);

void EDVBrowserOPClose(edv_browser_struct *browser);
void EDVBrowserOPExit(edv_browser_struct *browser);

void EDVBrowserOPNewFile(edv_browser_struct *browser);
void EDVBrowserOPNewDirectory(edv_browser_struct *browser);
void EDVBrowserOPNewLink(edv_browser_struct *browser);
void EDVBrowserOPNewFifo(edv_browser_struct *browser);
void EDVBrowserOPNewDeviceBlock(edv_browser_struct *browser);
void EDVBrowserOPNewDeviceCharacter(edv_browser_struct *browser);
void EDVBrowserOPNewSocket(edv_browser_struct *browser);

void EDVBrowserOPOpen(edv_browser_struct *browser);
void EDVBrowserOPOpenWith(edv_browser_struct *browser);

void EDVBrowserOPGoToParent(edv_browser_struct *browser);
void EDVBrowserOPExpand(edv_browser_struct *browser);
void EDVBrowserOPMount(edv_browser_struct *browser);
void EDVBrowserOPEject(edv_browser_struct *browser);

static edv_object_struct **EDVBrowserGetSelectedObjects(
        edv_browser_struct *browser, gint *total
);
void EDVBrowserOPMove(edv_browser_struct *browser);
void EDVBrowserOPCopy(edv_browser_struct *browser);
void EDVBrowserOPLink(edv_browser_struct *browser);
void EDVBrowserOPRename(edv_browser_struct *browser);
void EDVBrowserOPChMod(edv_browser_struct *browser);
void EDVBrowserOPChown(edv_browser_struct *browser);
void EDVBrowserOPDelete(edv_browser_struct *browser);
void EDVBrowserOPSelectAll(edv_browser_struct *browser);
void EDVBrowserOPUnselectAll(edv_browser_struct *browser);
void EDVBrowserOPInvertSelection(edv_browser_struct *browser);
void EDVBrowserOPProperties(edv_browser_struct *browser);

void EDVBrowserOPCopyPath(edv_browser_struct *browser);
void EDVBrowserOPCopyURL(edv_browser_struct *browser);

void EDVBrowserOPDownload(edv_browser_struct *browser);

void EDVBrowserOPRefresh(edv_browser_struct *browser);
void EDVBrowserOPRefreshAll(edv_browser_struct *browser);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))


/*
 *      Menu item activate callback.
 *
 *	The given client data must be a edv_browser_opid_struct *.
 */
void EDVBrowserMenuItemCB(GtkWidget *widget, gpointer data)
{
        EDVBrowserOPCB(data);
}

/*
 *      Menu item "enter_notify_event" signal callback.
 *
 *      The given client data must be a edv_browser_opid_struct *.
 */
gint EDVBrowserMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
        EDVBrowserOPEnterCB(data);
        return(TRUE);
}

/*
 *      Menu item "leave_notify_event" signal callback.
 *
 *      The given client data must be a edv_browser_opid_struct *.
 */
gint EDVBrowserMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
)
{
	EDVBrowserOPLeaveCB(data);
        return(TRUE);
}

/*
 *      Operation id callback nexus.
 *
 *      The given client data must be a edv_browser_opid_struct *.
 */
void EDVBrowserOPCB(gpointer data)
{
	static gbool reenterent = FALSE;
	gint dev_num;
	edv_device_struct *dev_ptr;
        edv_browser_struct *browser;
	edv_core_struct *core_ptr;
        edv_browser_opid_struct *opid = (edv_browser_opid_struct *)data;
        if(opid == NULL)
            return;

        browser = (edv_browser_struct *)opid->browser;
        if(browser == NULL)
            return;

	if(browser->processing)
	    return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get last selected device (if any). */
	dev_num = browser->selected_dev_num;
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;

	if(reenterent)
	    return;
	else
	    reenterent = TRUE;

	/* Handle by operation id code. */
	switch(opid->op)
	{
	  case EDV_BROWSER_OP_CLOSE:
	    EDVBrowserOPClose(browser);
	    break;

	  case EDV_BROWSER_OP_EXIT:
	    EDVBrowserOPExit(browser);
	    break;


          case EDV_BROWSER_OP_SYNC_DISKS:
            EDVBrowserOPSyncDisks(browser);
            break;

          case EDV_BROWSER_OP_WRITE_PROTECT:
	    EDVBrowserOPWriteProtect(browser);
	    break;

          case EDV_BROWSER_OP_RUN:
            EDVDoMapRunDlg(core_ptr);
            break;

          case EDV_BROWSER_OP_RUN_TERMINAL:
	    EDVDoRunTerminal(core_ptr, NULL);
            break;


	  case EDV_BROWSER_OP_NEW:
	    break;

          case EDV_BROWSER_OP_NEW_FILE:
            EDVBrowserOPNewFile(browser);
            break;

	  case EDV_BROWSER_OP_NEW_DIRECTORY:
	    EDVBrowserOPNewDirectory(browser);
	    break;

          case EDV_BROWSER_OP_NEW_LINK:
            EDVBrowserOPNewLink(browser);
            break;

          case EDV_BROWSER_OP_NEW_FIFO:
            EDVBrowserOPNewFifo(browser);
            break;

          case EDV_BROWSER_OP_NEW_DEVICE_BLOCK:
            EDVBrowserOPNewDeviceBlock(browser);
            break;

          case EDV_BROWSER_OP_NEW_DEVICE_CHARACTER:
            EDVBrowserOPNewDeviceCharacter(browser);
            break;

          case EDV_BROWSER_OP_NEW_SOCKET:
            EDVBrowserOPNewSocket(browser);
            break;


          case EDV_BROWSER_OP_OPEN:
            EDVBrowserOPOpen(browser);
            break;

          case EDV_BROWSER_OP_OPEN_WITH:
	    EDVBrowserOPOpenWith(browser);
	    break;


	  case EDV_BROWSER_OP_GOTO_PARENT:
            EDVBrowserOPGoToParent(browser);
            break;

	  case EDV_BROWSER_OP_EXPAND:
	    EDVBrowserOPExpand(browser);
	    break;

          case EDV_BROWSER_OP_MOUNT:
            EDVBrowserOPMount(browser);
            break;

          case EDV_BROWSER_OP_EJECT:
            EDVBrowserOPEject(browser);
            break;

          case EDV_BROWSER_OP_MOVE:
	    EDVBrowserOPMove(browser);
            break;

          case EDV_BROWSER_OP_COPY:
	    EDVBrowserOPCopy(browser);
            break;

	  case EDV_BROWSER_OP_LINK:
	    EDVBrowserOPLink(browser);
	    break;

	  case EDV_BROWSER_OP_RENAME:
	    EDVBrowserOPRename(browser);
	    break;

          case EDV_BROWSER_OP_CHMOD:
            EDVBrowserOPChMod(browser);
            break;

          case EDV_BROWSER_OP_CHOWN:
            EDVBrowserOPChown(browser);
            break;

	  case EDV_BROWSER_OP_DELETE:
	    EDVBrowserOPDelete(browser);
	    break;

	  case EDV_BROWSER_OP_SELECT_ALL:
	    EDVBrowserOPSelectAll(browser);
            break;

          case EDV_BROWSER_OP_UNSELECT_ALL:
	    EDVBrowserOPUnselectAll(browser);
            break;

          case EDV_BROWSER_OP_INVERT_SELECTION:
            EDVBrowserOPInvertSelection(browser);
            break;

	  case EDV_BROWSER_OP_PROPERTIES:
	    EDVBrowserOPProperties(browser);
            break;

	  case EDV_BROWSER_OP_FIND:
	    EDVDoMapBrowserFindWin(core_ptr, browser);
	    break;

	  case EDV_BROWSER_OP_HISTORY:
	    EDVDoMapHistoryListWin(core_ptr, browser->toplevel);
	    break;

	  case EDV_BROWSER_OP_COPY_PATH:
	    EDVBrowserOPCopyPath(browser);
            break;

          case EDV_BROWSER_OP_COPY_URL:
            EDVBrowserOPCopyURL(browser);
            break;


	  case EDV_BROWSER_OP_REFRESH:
	    EDVBrowserOPRefresh(browser);
	    break;

	  case EDV_BROWSER_OP_REFRESH_ALL:
            EDVBrowserOPRefreshAll(browser);
            break;


          case EDV_BROWSER_OP_DOWNLOAD:
            EDVBrowserOPDownload(browser);
            break;


          case EDV_BROWSER_OP_SHOW_TOOL_BAR:
	    if(core_ptr != NULL)
	    {
		gbool state = !EDVCFGItemListGetValueI(
		    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR
		);
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_TOOL_BAR,
		    state, FALSE
                );
		EDVReconfiguredEmit(core_ptr);
	    }
            break;

          case EDV_BROWSER_OP_SHOW_LOCATION_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_LOCATION_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

          case EDV_BROWSER_OP_SHOW_MOUNT_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_MOUNT_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

          case EDV_BROWSER_OP_SHOW_FIND_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_FIND_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

          case EDV_BROWSER_OP_SHOW_STATUS_BAR:
            if(core_ptr != NULL)
            {
                gbool state = !EDVCFGItemListGetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR
                );
                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_BROWSER_SHOW_STATUS_BAR,
                    state, FALSE
                );
                EDVReconfiguredEmit(core_ptr);
            }
            break;

	  case EDV_BROWSER_OP_MIME_TYPES:
	    EDVDoMapMIMETypesListWin(core_ptr, browser->toplevel);
	    break;

          case EDV_BROWSER_OP_DEVICES:
            EDVDoMapDevicesListWin(core_ptr, browser->toplevel);
            break;


	  case EDV_BROWSER_OP_NEW_BROWSER:
	    EDVDoNewBrowser(core_ptr);
	    break;

	  case EDV_BROWSER_OP_NEW_IMBR:
	    EDVDoNewImbr(core_ptr);
	    break;

          case EDV_BROWSER_OP_NEW_ARCHIVER:
            EDVDoNewArchiver(core_ptr);
            break;

          case EDV_BROWSER_OP_RECYCLE_BIN:
	    EDVDoMapRecBin(core_ptr);
            break;

	  case EDV_BROWSER_OP_OPTIONS:
	    EDVDoMapOptionsWin(core_ptr, browser->toplevel);
	    break;

	  case EDV_BROWSER_OP_CUSTOMIZE:
	    EDVDoMapCustomizeWin(core_ptr, browser->toplevel);
	    break;


          case EDV_BROWSER_OP_DEVICE_CHECK:
            EDVDoRunDeviceCheck(core_ptr, dev_ptr, browser->toplevel);
            break;

          case EDV_BROWSER_OP_DEVICE_TOOLS:
            EDVDoRunDeviceTools(core_ptr, dev_ptr, browser->toplevel);
            break;

          case EDV_BROWSER_OP_DEVICE_FORMAT:
            EDVDoRunDeviceFormat(core_ptr, dev_ptr, browser->toplevel);
            break;


          case EDV_BROWSER_OP_HELP_ABOUT:
            EDVDoHelpAbout(core_ptr, browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_CONTENTS:
            EDVDoHelp(core_ptr, "Contents", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_FILE_BROWSER:
            EDVDoHelp(core_ptr, "File Browser", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_IMAGE_BROWSER:
            EDVDoHelp(core_ptr, "Image Browser", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_ARCHIVER:
            EDVDoHelp(core_ptr, "Archiver", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_RECYCLE_BIN:
            EDVDoHelp(core_ptr, "Recycle Bin", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_KEYS_LIST:
            EDVDoHelp(core_ptr, "Keys List", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_MIME_TYPES:
            EDVDoHelp(core_ptr, "MIME Types", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_DEVICES:
            EDVDoHelp(core_ptr, "Devices", browser->toplevel);
            break;
          case EDV_BROWSER_OP_HELP_COMMON_OPERATIONS:
            EDVDoHelp(core_ptr, "Common Operations", browser->toplevel);
            break;


	  default:
	    if(1)
	    {
		gchar text[256];

		sprintf(
		    text,
		    "Unsupported browser operation `%i'\n",
		    opid->op
		);

		CDialogSetTransientFor(browser->toplevel);
		CDialogGetResponse(
		    "Operation Error",
		    text,
		    NULL,
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
	    }
	    break;
	}

	reenterent = FALSE;
}

/*
 *      Operation id enter notify callback nexus.
 *
 *      The given client data must be a edv_browser_opid_struct *.
 */
void EDVBrowserOPEnterCB(gpointer data)
{
        const gchar *tooltip;
        edv_browser_struct *browser;
        edv_browser_opid_struct *opid = (edv_browser_opid_struct *)data;
        if(opid == NULL)
            return;

        browser = (edv_browser_struct *)opid->browser;
        if(browser == NULL)
            return;

        tooltip = opid->tooltip;
        if(tooltip != NULL)
            EDVStatusBarMessage(browser->status_bar, tooltip, FALSE);
}

/*
 *      Operation id leave notify callback nexus.
 */
void EDVBrowserOPLeaveCB(gpointer data)
{
        edv_browser_struct *browser;
        edv_browser_opid_struct *opid = (edv_browser_opid_struct *)data;
        if(opid == NULL)
            return;

        browser = (edv_browser_struct *)opid->browser;
        if(browser == NULL)
            return;

	EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
}


/*
 *	Mount bar mount callback.
 */
void EDVBrowserMountBarMountCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
)
{
	static gbool reenterent = FALSE;
	gbool original_mount_state;
	gint status;
	edv_core_struct *core_ptr;
        edv_browser_struct *browser = (edv_browser_struct *)data;
	if((browser == NULL) || (dev_ptr == NULL))
	    return;

	if(browser->processing)
	    return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

	if(reenterent)
	    return;
	else
	    reenterent = TRUE;

        /* Record original mount state. */
        original_mount_state = dev_ptr->is_mounted;


        EDVBrowserSetBusy(browser, TRUE);


        /* Unmount or mount? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        else
            status = EDVMountDoMount(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        EDVBrowserSetBusy(browser, FALSE);


        /* Mount error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    original_mount_state ?
                        "Unmount Failed" : "Mount Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
            /* Report mount signal to all of endeavour's resources. */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }

	reenterent = FALSE;
}

/*
 *	Mount bar eject callback.
 */
void EDVBrowserMountBarEjectCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
)
{
        static gbool reenterent = FALSE;
        gbool original_mount_state;
        gint status;
        edv_core_struct *core_ptr;
        edv_browser_struct *browser = (edv_browser_struct *)data;
        if((browser == NULL) || (dev_ptr == NULL))
            return;

        if(browser->processing)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        /* Record original mount state. */
        original_mount_state = dev_ptr->is_mounted;


        EDVBrowserSetBusy(browser, TRUE);

        /* Need to unmount first? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
        /* So now eject. */
        status = EDVMountDoEject(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );

        EDVBrowserSetBusy(browser, FALSE);


        /* Mount error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
		    "Eject Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
	    /* Report eject (unmount) signal to all of endeavour's
	     * resources.
	     */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }

        reenterent = FALSE;
}

/*
 *	Mount bar go to mount path callback.
 */
extern void EDVBrowserMountBarGoToCB(
        gpointer mb, gint dev_num, edv_device_struct *dev_ptr,
        gpointer data
)
{
        static gbool reenterent = FALSE;
	gchar *path;
        edv_browser_struct *browser = (edv_browser_struct *)data;
        if((browser == NULL) || (dev_ptr == NULL))
            return;

        if(browser->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	/* Get copy of mount path. */
	path = (dev_ptr->mount_path != NULL) ?
	    g_strdup(dev_ptr->mount_path) : NULL;

	EDVBrowserSetBusy(browser, TRUE);

	/* Attempt to select the node who's disk object path matches the
	 * mount path, recurse and expand as needed.
	 *
	 * The ctree will be freeze'ed and thawed by the callbacks each
	 * time it is expanded so we do not need to freeze or thaw it here.
	 *
	 */
	EDVBrowserDirTreeDoSelectPath(browser, path);

	EDVBrowserSetBusy(browser, FALSE);

	/* Deallocate copy of mount path. */
	g_free(path);
	path = NULL;

        reenterent = FALSE;
}


/*
 *	Find bar get current location callback.
 */
gchar *EDVBrowserFindBarLocationCB(gpointer fb, gpointer data)
{
	return(EDVBrowserCurrentLocation(
	    (edv_browser_struct *)data
	));
}

/*
 *	Find bar start find callback.
 */
void EDVBrowserFindBarStartCB(gpointer fb, gpointer data)
{
        GtkCList *clist;
        edv_browser_struct *browser = (edv_browser_struct *)data;
        if(browser == NULL)
            return;

        clist = (GtkCList *)browser->contents_clist;
        if(clist == NULL)
            return;

	EDVBrowserSetBusy(browser, TRUE);
/*	GUIBlockInput(browser->toplevel, TRUE); */

	gtk_clist_freeze(clist);
	gtk_clist_unselect_all(clist);
	gtk_clist_thaw(clist);

	EDVBrowserUpdateMenus(browser);
}

/*
 *      Find bar end find callback.
 */
void EDVBrowserFindBarEndCB(
        gpointer fb, gint total_matches, gpointer data
)
{
        edv_browser_struct *browser = (edv_browser_struct *)data;
        if(browser == NULL)
            return;

/*	GUIBlockInput(browser->toplevel, FALSE); */
	EDVBrowserSetBusy(browser, FALSE);
}

/*
 *	Find bar match callback.
 */
void EDVBrowserFindBarMatchCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
	gpointer data
)
{
	gint row;
	GtkCList *clist;
	edv_browser_struct *browser = (edv_browser_struct *)data;
	if((path == NULL) || (lstat_buf == NULL) || (browser == NULL))
	    return;

	clist = (GtkCList *)browser->contents_clist;
	if(clist == NULL)
	    return;

	row = EDVBrowserContentsFindRowByPath(browser, path);
	if((row >= 0) && (row < clist->rows))
            gtk_clist_select_row(clist, row, 0);
}


/*
 *	Opaque status bar message update callback, the first argument
 *	bar is completely ignored.
 */
void EDVBrowserBarStatusMessageCB(
        gpointer bar, const gchar *message, gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_browser_struct *browser = (edv_browser_struct *)data;
        if(browser == NULL)
            return;

        if(browser->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

	EDVStatusBarMessage(browser->status_bar, message, FALSE);

        reenterent = FALSE;
}

/*
 *      Opaque status bar progress update callback, the first argument
 *      bar is completely ignored.
 */
void EDVBrowserBarStatusProgressCB(
        gpointer bar, gfloat progress, gpointer data
)
{
        static gbool reenterent = FALSE;
        edv_browser_struct *browser = (edv_browser_struct *)data;
        if(browser == NULL)
            return;

        if(browser->processing)
            return;

        if(reenterent)
            return;
        else
            reenterent = TRUE;

        EDVStatusBarProgress(browser->status_bar, progress, FALSE);

        reenterent = FALSE;
}


/*
 *	Flush data transfer output to disks.
 */
void EDVBrowserOPSyncDisks(edv_browser_struct *browser)
{
	if(browser == NULL)
	    return;

	EDVStatusBarMessage(
	    browser->status_bar,
	    "Flushing all write buffers to disk...",
	    TRUE
	);

	EDVBrowserSetBusy(browser, TRUE);

	EDVDoSyncDisks((edv_core_struct *)browser->core_ptr);

        EDVBrowserSetBusy(browser, FALSE);

	EDVStatusBarMessage(
            browser->status_bar,
            "Disk sync done",
            FALSE
        );
        EDVStatusBarProgress(browser->status_bar, 0.0, FALSE);
}

/*
 *	Write protect toggle.
 */
void EDVBrowserOPWriteProtect(edv_browser_struct *browser)
{
	gbool write_protect;
	edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

	/* Get new write protect state, changing from the previous one. */
	write_protect = EDVCFGItemListGetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_WRITE_PROTECT
	) ? FALSE : TRUE;

	/* Update write protect in the configuration list. */
	EDVCFGItemListSetValueI(
	    core_ptr->cfg_list, EDV_CFG_PARM_WRITE_PROTECT,
	    write_protect, FALSE
        );

	/* Notify all resources about change in write protect. */
	EDVWriteProtectChangedEmit(core_ptr, write_protect);
}


/*
 *	Close browser.
 */
void EDVBrowserOPClose(edv_browser_struct *browser)
{
        if(browser == NULL)
            return;

	if(browser->processing)
	    return;

        /* Set current properties of the browser to the configuration
         * list.
         */
        EDVBrowserSyncConfiguration(browser);

        /* Unmap the browser. */
        EDVBrowserUnmap(browser);
}

/*
 *      Close all windows.
 */
void EDVBrowserOPExit(edv_browser_struct *browser)
{
	edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

        /* Set current properties of the browser to the configuration
         * list.
         */
        EDVBrowserSyncConfiguration(browser);

        /* Unmap this browser. */
        EDVBrowserUnmap(browser);

	/* Mark need_close_all_windows on the core structure to TRUE, this
	 * will be checked during the management timeout. In which case
	 * all windows will be deleted.
	 */
	core_ptr->need_close_all_windows = TRUE;
}


/*
 *      Creates a new file object.
 */
void EDVBrowserOPNewFile(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
	gchar *new_path = NULL;
	const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

	/* Get current location as the path to create the new object
	 * at.
	 */
	cur_path = EDVBrowserCurrentLocation(browser);
	if(cur_path == NULL)
	{
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

	/* Create new file. */
	status = EDVFCreateFile(
	    core_ptr, cur_path, &new_path,
	    browser->toplevel,
	    TRUE, TRUE, &yes_to_all
	);

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

	/* Error creating new object? */
	if(status)
	{
	    error_mesg = EDVFCreateGetError();
	    if(error_mesg != NULL)
	    {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
		    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
	    }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
	}
	else
	{
            /* Successfully created new object. */
            struct stat lstat_buf;

            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint row;
                GtkCList *clist = (GtkCList *)browser->contents_clist;

                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new row on contents clist that is listing the
                 * new object.
                 */
                row = EDVBrowserContentsFindRowByPath(browser, new_path);
                if((row > -1) && (clist != NULL))
                {
                    gtk_clist_freeze(clist);
		    gtk_clist_unselect_all(clist);
                    gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
            }

            EDVStatusBarMessage(
		browser->status_bar,
		"Created new file",
		FALSE
	    );
        }

        EDVBrowserSetBusy(browser, FALSE);

	DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new directory object.
 */
void EDVBrowserOPNewDirectory(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVBrowserCurrentLocation(browser);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

        /* Create new directory. */
        status = EDVFCreateDirectory(
            core_ptr, cur_path, &new_path,
            browser->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
		gint row;
		GtkCList *clist = (GtkCList *)browser->contents_clist;

		/* Emit a disk object added signal to all of endeavour's
		 * resources.
		 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

		/* Select new row on contents clist that is listing the
		 * new object.
		 */
		row = EDVBrowserContentsFindRowByPath(browser, new_path);
		if((row > -1) && (clist != NULL))
		{
		    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
		    gtk_clist_select_row(clist, row, 0);
		    gtk_clist_thaw(clist);
		}
            }

            EDVStatusBarMessage(
                browser->status_bar,
                "Created new directory",
                FALSE
            );
        }

        EDVBrowserSetBusy(browser, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new symbolic link object.
 */
void EDVBrowserOPNewLink(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVBrowserCurrentLocation(browser);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

        /* Create new symbolic link. */
        status = EDVFCreateLink(
            core_ptr, cur_path, &new_path,
            browser->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint row;
                GtkCList *clist = (GtkCList *)browser->contents_clist;

                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new row on contents clist that is listing the
                 * new object.
                 */
                row = EDVBrowserContentsFindRowByPath(browser, new_path);
                if((row > -1) && (clist != NULL))
                {
                    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
                    gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
            }

            EDVStatusBarMessage(
                browser->status_bar,
                "Created new symbolic link",
                FALSE
            );
        }

        EDVBrowserSetBusy(browser, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *	Creates a new FIFO pipe object.
 */
void EDVBrowserOPNewFifo(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVBrowserCurrentLocation(browser);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

        /* Create new FIFO pipe. */
        status = EDVFCreateFifo(
            core_ptr, cur_path, &new_path,
            browser->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint row;
                GtkCList *clist = (GtkCList *)browser->contents_clist;

                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new row on contents clist that is listing the
                 * new object.
                 */
                row = EDVBrowserContentsFindRowByPath(browser, new_path);
                if((row > -1) && (clist != NULL))
                {
                    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
                    gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
            }

            EDVStatusBarMessage(
                browser->status_bar,
                "Created new FIFO pipe",
                FALSE
            );
        }

        EDVBrowserSetBusy(browser, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new block device object.
 */
void EDVBrowserOPNewDeviceBlock(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVBrowserCurrentLocation(browser);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

        /* Create new block device. */
        status = EDVFCreateDeviceBlock(
            core_ptr, cur_path, &new_path,
            browser->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint row;
                GtkCList *clist = (GtkCList *)browser->contents_clist;

                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new row on contents clist that is listing the
                 * new object.
                 */
                row = EDVBrowserContentsFindRowByPath(browser, new_path);
                if((row > -1) && (clist != NULL))
                {
                    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
                    gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
            }

            EDVStatusBarMessage(
                browser->status_bar,
                "Created new block device",
                FALSE
            );
        }

        EDVBrowserSetBusy(browser, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new character device object.
 */
void EDVBrowserOPNewDeviceCharacter(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVBrowserCurrentLocation(browser);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

        /* Create new character device. */
        status = EDVFCreateDeviceCharacter(
            core_ptr, cur_path, &new_path,
            browser->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint row;
                GtkCList *clist = (GtkCList *)browser->contents_clist;

                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new row on contents clist that is listing the
                 * new object.
                 */
                row = EDVBrowserContentsFindRowByPath(browser, new_path);
                if((row > -1) && (clist != NULL))
                {
                    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
                    gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
            }

            EDVStatusBarMessage(
                browser->status_bar,
                "Created new character device",
                FALSE
            );
        }

        EDVBrowserSetBusy(browser, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *      Creates a new socket object.
 */
void EDVBrowserOPNewSocket(edv_browser_struct *browser)
{
        gbool yes_to_all = FALSE;
        gint status;
        gchar *new_path = NULL;
        const gchar *cur_path, *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS  \
{ \
 g_free(new_path); \
 new_path = NULL; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
        {
            DO_FREE_LOCALS
            return;
        }

        /* Get current location as the path to create the new object
         * at.
         */
        cur_path = EDVBrowserCurrentLocation(browser);
        if(cur_path == NULL)
        {
            DO_FREE_LOCALS
            return;
        }

        EDVBrowserSetBusy(browser, TRUE);

        /* Create new socket. */
        status = EDVFCreateSocket(
            core_ptr, cur_path, &new_path,
            browser->toplevel,
            TRUE, TRUE, &yes_to_all
        );

        /* Unmap progress dialog, it may have been mapped if any
         * operations occured in the above call.
         */
        ProgressDialogBreakQuery(TRUE);
        ProgressDialogSetTransientFor(NULL);

        /* Error creating new object? */
        if(status)
        {
            error_mesg = EDVFCreateGetError();
            if(error_mesg != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
                    "Create Failed",
                    error_mesg,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }

            EDVStatusBarMessage(browser->status_bar, NULL, FALSE);
        }
        else
        {
            /* Successfully created new object. */
            struct stat lstat_buf;


            /* Get local stats of new object. */
            if(!lstat(new_path, &lstat_buf))
            {
                gint row;
                GtkCList *clist = (GtkCList *)browser->contents_clist;

                /* Emit a disk object added signal to all of endeavour's
                 * resources.
                 */
                EDVObjectAddedEmit(
                    core_ptr, new_path, &lstat_buf
                );

                /* Select new row on contents clist that is listing the
                 * new object.
                 */
                row = EDVBrowserContentsFindRowByPath(browser, new_path);
                if((row > -1) && (clist != NULL))
                {
                    gtk_clist_freeze(clist);
                    gtk_clist_unselect_all(clist);
                    gtk_clist_select_row(clist, row, 0);
                    gtk_clist_thaw(clist);
                }
            }

            EDVStatusBarMessage(
                browser->status_bar,
                "Created new socket",
                FALSE
            );
        }

        EDVBrowserSetBusy(browser, FALSE);

        DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}



/*
 *      Open the selected object on contents clist.
 */
void EDVBrowserOPOpen(edv_browser_struct *browser)
{
	gint row;
        GtkCList *clist;


        if(browser == NULL)
            return;

        clist = (GtkCList *)browser->contents_clist;
        if(clist == NULL)
            return;

	row = EDVCListGetSelectedLast(clist, NULL);
	if(row > -1)
	    EDVBrowserContentsDoOpenObject(
		browser, row, 0, 0
	    );
}

/*
 *      `Open with' the selected object on contents clist.
 */
void EDVBrowserOPOpenWith(edv_browser_struct *browser)
{
        gint row;
        GtkCList *clist;


        if(browser == NULL)
            return;

        clist = (GtkCList *)browser->contents_clist;
        if(clist == NULL)
            return;

        row = EDVCListGetSelectedLast(clist, NULL);
        if(row > -1)
            EDVBrowserContentsDoOpenWithObject(
                browser, row, 0
            );
}


/*
 *	Go to parent directory.
 */
void EDVBrowserOPGoToParent(edv_browser_struct *browser)
{
        GtkCTree *ctree;
        GtkCTreeNode *node, *parent_node;
        GtkCTreeRow *row_ptr;


        if(browser == NULL)
            return;

        ctree = (GtkCTree *)browser->directory_ctree;
        if(ctree == NULL)
            return;

	/* Get selected node. */
	node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
        if((node == NULL) || (row_ptr == NULL))
            return;

	/* Get parent node of selected node. */
	parent_node = row_ptr->parent;
	if(parent_node == NULL)
	    return;

	/* Select parent node. */
	gtk_ctree_select(ctree, parent_node);
}

/*
 *	Expands or collapses the selected node on the directory ctree.
 */
void EDVBrowserOPExpand(edv_browser_struct *browser)
{
	GtkCTree *ctree;
	GtkCTreeNode *node;
	GtkCTreeRow *row_ptr;


        if(browser == NULL)
            return;

	ctree = (GtkCTree *)browser->directory_ctree;
	if(ctree == NULL)
	    return;

	/* Get selected node. */
	node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
	if((node == NULL) || (row_ptr == NULL))
	    return;

	/* Collapse or expand node? Note that appropriate callbacks
	 * will be made when expanded or collapsed.
	 */
	if(row_ptr->expanded)
	    gtk_ctree_collapse(ctree, node);
	else
	    gtk_ctree_expand(ctree, node);
}


/*
 *	Mounts or unmounts the selected node on the directory ctree.
 */
void EDVBrowserOPMount(edv_browser_struct *browser)
{
	gbool original_mount_state;
	gint status, dev_num;
	edv_device_struct *dev_ptr;
	edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;

	/* Get number of last selected device index (if any). */
	dev_num = browser->selected_dev_num;
	if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
	    dev_ptr = core_ptr->device[dev_num];
	else
	    dev_ptr = NULL;
	if(dev_ptr == NULL)
	    return;

	/* Record original mount state. */
	original_mount_state = dev_ptr->is_mounted;


	EDVBrowserSetBusy(browser, TRUE);


	/* Unmount or mount? */
	if(dev_ptr->is_mounted)
	    status = EDVMountDoUnmount(dev_ptr);
	else
	    status = EDVMountDoMount(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        EDVBrowserSetBusy(browser, FALSE);


	/* Mount error? */
	if(status)
	{
	    const gchar *last_error = EDVMountGetError();
	    if(last_error != NULL)
	    {
		CDialogSetTransientFor(browser->toplevel);
		CDialogGetResponse(
		    original_mount_state ?
			"Unmount Failed" : "Mount Failed",
		    last_error,
		    NULL,
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
	    }
	}
	else
	{
	    /* Report un mount signal to all of endeavour's resources. */
	    EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
	}
}

/*
 *	Ejects the media from the selected device.
 *
 *	Device will be unmounted first as needed.
 */
void EDVBrowserOPEject(edv_browser_struct *browser)
{
        gbool original_mount_state;
        gint status, dev_num;
        edv_device_struct *dev_ptr;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get number of last selected device index (if any). */
        dev_num = browser->selected_dev_num;
        if((dev_num >= 0) && (dev_num < core_ptr->total_devices))
            dev_ptr = core_ptr->device[dev_num];
        else
            dev_ptr = NULL;
        if(dev_ptr == NULL)
            return;

        /* Record original mount state. */
        original_mount_state = dev_ptr->is_mounted;


        EDVBrowserSetBusy(browser, TRUE);


        /* Need to unmount first? */
        if(dev_ptr->is_mounted)
            status = EDVMountDoUnmount(dev_ptr);
	/* So now eject. */
	status = EDVMountDoEject(dev_ptr);

        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );

        EDVBrowserSetBusy(browser, FALSE);


        /* Eject error? */
        if(status)
        {
            const gchar *last_error = EDVMountGetError();
            if(last_error != NULL)
            {
                CDialogSetTransientFor(browser->toplevel);
                CDialogGetResponse(
		    "Eject Failed",
                    last_error,
                    NULL,
                    CDIALOG_ICON_ERROR,
                    CDIALOG_BTNFLAG_OK,
                    CDIALOG_BTNFLAG_OK
                );
                CDialogSetTransientFor(NULL);
            }
        }
        else
        {
            /* Report eject (unmount) signal to all of endeavour's
	     * resources.
	     */
            EDVObjectMountEmit(core_ptr, dev_num, dev_ptr, dev_ptr->is_mounted);
        }
}


/*
 *	Returns a list of selected disk object structures on the given
 *	browser.
 *
 *	Only the returned pointer array (not each object) needs to be
 *	deallocated by the calling function.
 */
static edv_object_struct **EDVBrowserGetSelectedObjects(
	edv_browser_struct *browser, gint *total
)
{
        edv_object_struct **sel_object = NULL, *obj;
        gint total_sel_objects = 0;


	if(total != NULL)
	    *total = 0;

	if(browser == NULL)
	    return(sel_object);

        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */

        /* Contents clist was last selected? */
        if(browser->contents_clist_selected_row > -1)
        {
            gint i, row;
            GList *glist;
            GtkCList *clist = (GtkCList *)browser->contents_clist;

            glist = (clist != NULL) ? clist->selection : NULL;
            while(glist != NULL)
            {
                row = (gint)glist->data;
                obj = (edv_object_struct *)gtk_clist_get_row_data(
                    clist, row
                );
                if(obj != NULL)
                {
                    i = total_sel_objects;
                    total_sel_objects = i + 1;
                    sel_object = (edv_object_struct **)g_realloc(
                        sel_object,
                        total_sel_objects * sizeof(edv_object_struct *)
                    );
                    if(sel_object == NULL)
                    {
                        total_sel_objects = 0;
                        break;
                    }

                    sel_object[i] = obj;
                }

                glist = glist->next;
            }
        }
        /* Directory ctree was last selected? */
        else if(browser->directory_ctree_selected_node != NULL)
        {
            gint i;
            GList *glist;
            GtkCList *clist = (GtkCList *)browser->directory_ctree;
            GtkCTree *ctree = (GtkCTree *)clist;
            GtkCTreeNode *node;

            glist = (clist != NULL) ? clist->selection : NULL;
            while(glist != NULL)
            {
                node = (GtkCTreeNode *)glist->data;
                obj = (edv_object_struct *)gtk_ctree_node_get_row_data(
                    ctree, node
                );
                if(obj != NULL)
                {
                    i = total_sel_objects;
                    total_sel_objects = i + 1;
                    sel_object = (edv_object_struct **)g_realloc(
                        sel_object,
                        total_sel_objects * sizeof(edv_object_struct *)
                    );
                    if(sel_object == NULL)
                    {
                        total_sel_objects = 0;
                        break;
                    }

                    sel_object[i] = obj;
                }

                glist = glist->next;
            }
        }

	/* Update returns. */
	if(total != NULL)
	    *total = total_sel_objects;

	return(sel_object);
}

/*
 *	Queries user to move selected disk objects.
 */
void EDVBrowserOPMove(edv_browser_struct *browser)
{
	edv_object_struct **sel_object;
	gint total_sel_objects;
        edv_core_struct *core_ptr;
	edv_fopdialog_struct *d;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

	/* Get pointer to file operation dialog and create it as needed. */
	d = browser->fopdialog;
	if(d == NULL)
	    browser->fopdialog = d = EDVFOPDialogNew(core_ptr);
	if(d == NULL)
	    return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


	/* Create a list of disk objects, each pointer in the array will
	 * reffer to a shared object structure pointer so it should not
	 * be deallocated.
	 *
	 * Check which list contains the last selected object, that will
	 * indicate the list to get selected object structures from.
	 */
	sel_object = EDVBrowserGetSelectedObjects(
	    browser, &total_sel_objects
	);
	if(sel_object == NULL)
	    return;

	/* Map dialog. */
	EDVFOPDialogMapValues(
	    d, EDV_FOPDIALOG_OP_MOVE,
	    sel_object, total_sel_objects,
	    EDVBrowserCurrentLocation(browser),
	    browser->toplevel
	);

	/* Deallocate selected disk objects pointer array but not each
	 * structure since they are shared.
	 */
	g_free(sel_object);
	sel_object = NULL;
	total_sel_objects = 0;
}

/*
 *      Queries user to move selected disk objects.
 */
void EDVBrowserOPCopy(edv_browser_struct *browser)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = browser->fopdialog;
        if(d == NULL)
            browser->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVBrowserGetSelectedObjects(
            browser, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog. */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_COPY,
            sel_object, total_sel_objects,
            EDVBrowserCurrentLocation(browser),
            browser->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *	Queries user to link selected disk objects.
 */
void EDVBrowserOPLink(edv_browser_struct *browser)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = browser->fopdialog;
        if(d == NULL)
            browser->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVBrowserGetSelectedObjects(
            browser, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog.
	 *
	 * Note that linking only allows one selected object, so always
	 * report total as no more than 1.
	 */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_LINK,
            sel_object, MIN(total_sel_objects, 1),
            EDVBrowserCurrentLocation(browser),
            browser->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *	Rename object callback.
 */
void EDVBrowserOPRename(edv_browser_struct *browser)
{
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

/* This will actually be checked again when the rename fprompt map call
 * but we check it first initially anyways.
 */
        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

	/* Check which list contains the last selected object, that will
	 * indicate the list to map the rename floating prompt for.
	 */

        /* Contents clist was last selected? */
        if(browser->contents_clist_selected_row > -1)
        {
            gint row;
            GtkCList *clist = (GtkCList *)browser->contents_clist;

	    row = EDVCListGetSelectedLast(clist, NULL);
	    if(row > -1)
		EDVBrowserContentsDoFPromptRename(
		    browser, row, -1
		);
	}
        /* Directory ctree was last selected? */
        else if(browser->directory_ctree_selected_node != NULL)
        {
            GtkCTreeNode *node;
	    GtkCTree *ctree = (GtkCTree *)browser->directory_ctree;

	    node = EDVCTreeGetSelectedLast(ctree, NULL);
	    if(node != NULL)
		EDVBrowserDirTreeDoFPromptRename(
		    browser, node
		);
	}
}

/*
 *	Change object permissions callback.
 */
void EDVBrowserOPChMod(edv_browser_struct *browser)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = browser->fopdialog;
        if(d == NULL)
            browser->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVBrowserGetSelectedObjects(
            browser, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog. */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_CHMOD,
            sel_object, total_sel_objects,
            EDVBrowserCurrentLocation(browser),
            browser->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *      Change object permissions callback.
 */
void EDVBrowserOPChown(edv_browser_struct *browser)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;
        edv_core_struct *core_ptr;
        edv_fopdialog_struct *d;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
            return;

        /* Get pointer to file operation dialog and create it as needed. */
        d = browser->fopdialog;
        if(d == NULL)
            browser->fopdialog = d = EDVFOPDialogNew(core_ptr);
        if(d == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVBrowserGetSelectedObjects(
            browser, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

        /* Map dialog. */
        EDVFOPDialogMapValues(
            d, EDV_FOPDIALOG_OP_CHOWN,
            sel_object, total_sel_objects,
            EDVBrowserCurrentLocation(browser),
            browser->toplevel
        );

        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}


/*
 *	Delete object callback.
 */
void EDVBrowserOPDelete(edv_browser_struct *browser)
{
	gbool yes_to_all = FALSE;
	gint i, status;
	const gchar *path_ptr;
	gchar **object_path = NULL;
	gint total_object_paths = 0, objects_deleted = 0;
	guint *index;
	gint total_indexes;
	const gchar *error_mesg;
        edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

#define DO_FREE_LOCALS	\
{ \
 /* Deallocate list of disk object paths. */ \
 for(i = 0; i < total_object_paths; i++) \
  g_free(object_path[i]); \
 g_free(object_path); \
 object_path = NULL; \
 total_object_paths = 0; \
}

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
	{
	    DO_FREE_LOCALS
            return;
	}

        /* Check and warn if write protect is enabled. */
        if(EDVCheckWriteProtect(core_ptr, TRUE))
	{
	    DO_FREE_LOCALS
            return;
	}


        /* Contents clist was last selected? */
        if(browser->contents_clist_selected_row > -1)
        {
	    edv_object_struct *obj;
            gint row;
            GList *glist;
            GtkCList *clist = (GtkCList *)browser->contents_clist;


            glist = (clist != NULL) ? clist->selection : NULL;
            while(glist != NULL)
            {
                row = (gint)glist->data;
		obj = (edv_object_struct *)gtk_clist_get_row_data(clist, row);
		if((obj != NULL) ? (obj->full_path != NULL) : FALSE)
		{
		    i = total_object_paths;
		    total_object_paths = i + 1;
		    object_path = (gchar **)g_realloc(
			object_path,
			total_object_paths * sizeof(gchar *)
		    );
		    if(object_path == NULL)
		    {
			total_object_paths = 0;
			break;
		    }
		    else
		    {
			object_path[i] = g_strdup(obj->full_path);
		    }
		}

		glist = glist->next;
            }
        }
        /* Directory ctree was last selected? */
        else if(browser->directory_ctree_selected_node != NULL)
        {
            GList *glist;
            GtkCList *clist = (GtkCList *)browser->directory_ctree;
	    GtkCTree *ctree = (GtkCTree *)clist;
            GtkCTreeNode *node;
	    edv_object_struct *obj;


            glist = (clist != NULL) ? clist->selection : NULL;
            while(glist != NULL)
            {
                node = (GtkCTreeNode *)glist->data;
                obj = (edv_object_struct *)gtk_ctree_node_get_row_data(
		    ctree, node
		);
                if((obj != NULL) ? (obj->full_path != NULL) : FALSE)
                {
                    i = total_object_paths;
                    total_object_paths = i + 1;
                    object_path = (gchar **)g_realloc(
                        object_path,
                        total_object_paths * sizeof(gchar *)
                    );
                    if(object_path == NULL)
                    {
                        total_object_paths = 0;
                        break;
                    }
                    else
                    {
                        object_path[i] = g_strdup(obj->full_path);
                    }
                }

		glist = glist->next;
	    }
        }

	/* No disk objects selected? */
	if(total_object_paths <= 0)
	{
	    DO_FREE_LOCALS
	    return;
	}

	/* Confirm delete. */
	status = EDVConfirmDelete(
	    core_ptr, browser->toplevel,
	    (total_object_paths == 1) ? object_path[0] : NULL,
	    total_object_paths
	);
	switch(status)
	{
	  case CDIALOG_RESPONSE_YES_TO_ALL:
	    yes_to_all = TRUE;
	  case CDIALOG_RESPONSE_YES:
	  case CDIALOG_RESPONSE_OK:
	    break;

	  default:
	    DO_FREE_LOCALS
	    return;
	    break;
	}


	EDVBrowserSetBusy(browser, TRUE);


	/* Iterate through list of disk object paths. */
	status = 0;
	for(i = 0; i < total_object_paths; i++)
	{
	    path_ptr = object_path[i];
	    if(path_ptr == NULL)
		continue;

	    index = NULL;
	    total_indexes = 0;

	    /* Delete disk object. */
	    status = EDVRecBinFOPDelete(
		core_ptr, path_ptr,
		&index, &total_indexes,
		browser->toplevel,
		TRUE, TRUE, &yes_to_all
	    );

	    /* Get error message (if any) that might have occured in the
	     * above operation.
	     */
	    error_mesg = EDVRecBinFOPGetError();
	    if(error_mesg != NULL)
	    {
		CDialogSetTransientFor(browser->toplevel);
		CDialogGetResponse(
		    "Operation Error",
		    error_mesg,
		    NULL,
		    CDIALOG_ICON_ERROR,
		    CDIALOG_BTNFLAG_OK,
		    CDIALOG_BTNFLAG_OK
		);
		CDialogSetTransientFor(NULL);
	    }

	    /* Object was delected successfully? */
	    if((index != NULL) && !status)
	    {
		gint n;
		struct stat lstat_buf;


		/* Report recycle object added for all non-zero indexes. */
		for(n = 0; n < total_indexes; n++)
		{
		    if(index[n] != 0)
			EDVRecycledObjectAddedEmit(core_ptr, index[n]);
		}

                /* Check if disk object no longer exists. */
                if(lstat(path_ptr, &lstat_buf))
		{
		    /* Report disk object removed. */
                    EDVObjectRemovedEmit(core_ptr, path_ptr);
		}

		/* Increment number of disk objects deleted. */
		objects_deleted += total_indexes;
	    }

	    /* Deallocate returned recycle objects index array. */
	    g_free(index);
	    index = NULL;
	    total_indexes = 0;

	    /* Error occured (not 0) and it was not a user `no' or
	     * `not available' (-5) response?
	     */
	    if(status && (status != -5))
	    {
		/* Skip rest of the disk object paths due to error. */
		break;
	    }
	}

	/* Update status bar. */
	if(1)
	{
            gchar *buf;

            switch(status)
            {
              case 0: case -5:
                buf = g_strdup_printf(
                    "Deleted %i object%s",
                    objects_deleted,
                    (objects_deleted == 1) ? "" : "s"
                );
                break;

              case -4:  /* Cancel. */
                buf = g_strdup_printf(
                    "Delete operation canceled"
                );
                break;

              default:  /* Error. */
                buf = g_strdup_printf(
                    "Unable to delete object%s",
                    (total_object_paths == 1) ? "" : "s"
                );
                break;
            }
	    EDVStatusBarMessage(browser->status_bar, buf, FALSE);
	    g_free(buf);
	}

        EDVBrowserSetBusy(browser, FALSE);


	/* Unmap progress dialog, it may have been mapped if any
	 * operations occured in the above loop.
	 */
	ProgressDialogBreakQuery(TRUE);
	ProgressDialogSetTransientFor(NULL);


	DO_FREE_LOCALS
#undef DO_FREE_LOCALS
}

/*
 *	Select all contents items callback.
 */
void EDVBrowserOPSelectAll(edv_browser_struct *browser)
{
        edv_core_struct *core_ptr;
        GtkCList *clist;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

	/* Get contents clist. */
        clist = (GtkCList *)browser->contents_clist;
        if(clist == NULL)
            return;

        EDVBrowserSetBusy(browser, TRUE);

	/* Select all rows on clist. */
        gtk_clist_freeze(clist);
        gtk_clist_select_all(clist);
        gtk_clist_thaw(clist);

	/* Mark node as unselected on directory ctree. */
	browser->directory_ctree_selected_node = NULL;

	/* Assume highest row index as the last selected row. */
        browser->contents_clist_selected_row = clist->rows - 1;

        EDVStatusBarMessage(
            browser->status_bar, "All objects selected", FALSE
        );

        EDVBrowserSetBusy(browser, FALSE);
}

/*
 *	Unselect all contents items callback.
 */
void EDVBrowserOPUnselectAll(edv_browser_struct *browser)
{
	edv_core_struct *core_ptr;
	GtkCList *clist;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get contents clist. */
	clist = (GtkCList *)browser->contents_clist;
	if(clist == NULL)
	    return;

        EDVBrowserSetBusy(browser, TRUE);

        /* Unselect all rows on clist. */
	gtk_clist_freeze(clist);
	gtk_clist_unselect_all(clist);
        gtk_clist_thaw(clist);

        /* Mark node as unselected on directory ctree. */
        browser->directory_ctree_selected_node = NULL;

        /* Mark contents clist's row as unselected. */
	browser->contents_clist_selected_row = -1;

	EDVStatusBarMessage(
	    browser->status_bar, "All objects unselected", FALSE
	);

	EDVBrowserSetBusy(browser, FALSE);
}

/*
 *	Invert selection callback.
 */
void EDVBrowserOPInvertSelection(edv_browser_struct *browser)
{
        edv_core_struct *core_ptr;
        GtkCList *clist;
	GList *glist, *selection;
	gint row, total_rows;


        if(browser == NULL)
            return;

        core_ptr = (edv_core_struct *)browser->core_ptr;
        if(core_ptr == NULL)
            return;

        /* Get contents clist. */
        clist = (GtkCList *)browser->contents_clist;
        if(clist == NULL)
            return;

        EDVBrowserSetBusy(browser, TRUE);
        gtk_clist_freeze(clist);

	/* Get copy of selected rows list from clist. */
	selection = (clist->selection != NULL) ?
	    g_list_copy(clist->selection) : NULL;

	for(row = 0, total_rows = clist->rows;
	    row < total_rows;
	    row++
	)
	{
	    for(glist = selection;
	        glist != NULL;
	        glist = glist->next
	    )
	    {
		if(row == (gint)glist->data)
		{
		    gtk_clist_unselect_row(clist, row, 0);
		    break;
		}
	    }
	    /* Row not selected? */
	    if(glist == NULL)
		gtk_clist_select_row(clist, row, 0);
	}

	g_list_free(selection);

        gtk_clist_thaw(clist);
        EDVStatusBarMessage(
            browser->status_bar, "Selection inverted", FALSE
        );
        EDVBrowserSetBusy(browser, FALSE);
}

/*
 *      Object properties callback.
 */
void EDVBrowserOPProperties(edv_browser_struct *browser)
{
	edv_object_struct *obj = NULL;


        if(browser == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


	/* Check which list contains the last selected object, that will
	 * indicate the list to get the selected objects and map the
	 * properties dialog for.
	 */

        /* Contents clist was last selected? */
        if(browser->contents_clist_selected_row > -1)
        {
            gint row;
            GList *glist;
            GtkCList *clist = (GtkCList *)browser->contents_clist;

            glist = (clist != NULL) ? clist->selection : NULL;
            while(glist != NULL)
            {
                row = (gint)glist->data;
		obj = (edv_object_struct *)gtk_clist_get_row_data(
		    clist, row
		);
                break;
            }
        }
        /* Directory ctree was last selected? */
        else if(browser->directory_ctree_selected_node != NULL)
        {
            GList *glist;
            GtkCList *clist = (GtkCList *)browser->directory_ctree;
	    GtkCTree *ctree = (GtkCTree *)clist;
            GtkCTreeNode *node;

            glist = (clist != NULL) ? clist->selection : NULL;
            while(glist != NULL)
            {
                node = (GtkCTreeNode *)glist->data;
		obj = (edv_object_struct *)gtk_ctree_node_get_row_data(
		    ctree, node
		);
                break;
            }
        }

	/* Got a disk object structure? */
	if(obj != NULL)
	{
	    EDVDoPropWin(
		(edv_core_struct *)browser->core_ptr,
		obj,
		browser->toplevel
	    );
	}
}

/*
 *	Copy location of selected objects to dde as space separated list
 *	of absolute paths.
 */
void EDVBrowserOPCopyPath(edv_browser_struct *browser)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;


        if(browser == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVBrowserGetSelectedObjects(
            browser, &total_sel_objects
        );
        if(sel_object == NULL)
            return;

	/* Copy the paths of the selected objects to the dde. */
	EDVCopyDiskObjectsToDDEPath(
	    (edv_core_struct *)browser->core_ptr,
	    sel_object, total_sel_objects
	);


        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *      Copy location of selected objects to dde as space separated list
 *      of absolute urls.
 */
void EDVBrowserOPCopyURL(edv_browser_struct *browser)
{
        edv_object_struct **sel_object;
        gint total_sel_objects;


        if(browser == NULL)
            return;


        /* Sync data on browser so as to ensure we have the most up to
         * date information to send out.
         */
        EDVBrowserSyncData(browser);


        /* Create a list of disk objects, each pointer in the array will
         * reffer to a shared object structure pointer so it should not
         * be deallocated.
         *
         * Check which list contains the last selected object, that will
         * indicate the list to get selected object structures from.
         */
        sel_object = EDVBrowserGetSelectedObjects(
            browser, &total_sel_objects
        );
        if(sel_object == NULL)
            return;


        /* Copy the urls of the selected objects to the dde. */
        EDVCopyDiskObjectsToDDEURL(
            (edv_core_struct *)browser->core_ptr,
            sel_object, total_sel_objects
        );


        /* Deallocate selected disk objects pointer array but not each
         * structure since they are shared.
         */
        g_free(sel_object);
        sel_object = NULL;
        total_sel_objects = 0;
}

/*
 *	Download callback.
 */
void EDVBrowserOPDownload(edv_browser_struct *browser)
{
	if(browser == NULL)
	    return;

	EDVDoInternetDownloadObject(
	    (edv_core_struct *)browser->core_ptr,
	    NULL,
	    EDVBrowserCurrentLocation(browser),
	    browser->toplevel
	);
}

/*
 *      Refresh callback.
 */
void EDVBrowserOPRefresh(edv_browser_struct *browser)
{
	const gchar *cstrptr;
	gchar *cur_path;
	GtkCList *clist;
	GtkCTree *ctree;
	GtkCTreeNode *node;
	GtkCTreeRow *row_ptr;


        if(browser == NULL)
            return;

	/* Get current location path and make a copy of it. */
	cstrptr = EDVBrowserCurrentLocation(browser);
	cur_path = (cstrptr != NULL) ? g_strdup(cstrptr) : NULL;


	EDVBrowserSetBusy(browser, TRUE);
        GUIBlockInput(browser->toplevel, TRUE);


	/* Update directory ctree. */
	clist = (GtkCList *)browser->directory_ctree;
	ctree = (GtkCTree *)clist;

	/* Get selected node. */
	node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
	if((clist != NULL) && (node != NULL) && (row_ptr != NULL))
	{
	    gbool was_expanded = row_ptr->expanded;
	    gfloat last_vpos, last_hpos;


	    /* Record last scroll position. */
	    last_hpos = (clist->hadjustment != NULL) ?
		clist->hadjustment->value : 0.0;
            last_vpos = (clist->vadjustment != NULL) ?
                clist->vadjustment->value : 0.0;

            /* Begin refreshing. */

	    gtk_clist_freeze(clist);

	    EDVBrowserDirTreeDoRefresh(browser, node, TRUE);

	    /* Reget selected node, since the refresh procedure might
	     * have deleted the node.
	     */
	    node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
	    if(node != NULL)
	    {
		if(was_expanded)
		    gtk_ctree_expand(ctree, node);

		EDVScrollCListToPosition(
		    clist, last_hpos, last_vpos
		);
	    }

            gtk_clist_thaw(clist);
	}

	/* Update contents clist. */
        clist = (GtkCList *)browser->contents_clist;
        if((clist != NULL) && (cur_path != NULL))
        {
            gfloat last_vpos, last_hpos;


            /* Record last scroll position. */
            last_hpos = (clist->hadjustment != NULL) ?
                clist->hadjustment->value : 0.0;
            last_vpos = (clist->vadjustment != NULL) ?
                clist->vadjustment->value : 0.0;

            gtk_clist_freeze(clist);
            EDVBrowserContentsDoUpdate(browser, cur_path, TRUE);
            gtk_clist_thaw(clist);

            /* Scroll back to original position. */
            EDVScrollCListToPosition(
                clist, last_hpos, last_vpos
            );
        }


        GUIBlockInput(browser->toplevel, FALSE);
        EDVBrowserSetBusy(browser, FALSE);


        EDVStatusBarMessage(
            browser->status_bar, "Refreshed contents listing", FALSE
        );

        EDVBrowserUpdateMenus(browser);


	/* Deallocate copy of current location path. */
	g_free(cur_path);
	cur_path = NULL;
}

/*
 *      Refresh all callback.
 */
void EDVBrowserOPRefreshAll(edv_browser_struct *browser)
{
        const gchar *cstrptr;
        gchar *cur_path;
        GtkCList *clist;
        GtkCTree *ctree;
        GtkCTreeNode *node;
        GtkCTreeRow *row_ptr;
	edv_core_struct *core_ptr;


        if(browser == NULL)
            return;

	core_ptr = (edv_core_struct *)browser->core_ptr;
	if(core_ptr == NULL)
	    return;


        /* Get current location path and make a copy of it. */
        cstrptr = EDVBrowserCurrentLocation(browser);
        cur_path = (cstrptr != NULL) ? g_strdup(cstrptr) : NULL;


        EDVBrowserSetBusy(browser, TRUE);
        GUIBlockInput(browser->toplevel, TRUE);


        /* Update all device mount states and stats. */
        EDVDevicesListUpdateMountStates(
            core_ptr->device, core_ptr->total_devices
        );
        EDVDevicesListUpdateStats(
            core_ptr->device, core_ptr->total_devices
        );


        /* Update directory ctree. */
        clist = (GtkCList *)browser->directory_ctree;
        ctree = (GtkCTree *)clist;

        /* Get selected node. */
        node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
        if((clist != NULL) && (node != NULL) && (row_ptr != NULL))
        {
            gbool was_expanded = row_ptr->expanded;
            gfloat last_vpos, last_hpos;


            /* Record last scroll position. */
            last_hpos = (clist->hadjustment != NULL) ?
                clist->hadjustment->value : 0.0;
            last_vpos = (clist->vadjustment != NULL) ?
                clist->vadjustment->value : 0.0;

	    /* Begin refreshing. */

            gtk_clist_freeze(clist);

	    /* Do refresh procedure. */
            EDVBrowserDirTreeDoRefresh(browser, node, TRUE);

            /* Reget selected node, since the refresh procedure might
             * have deleted the node.
             */
            node = EDVCTreeGetSelectedLast(ctree, &row_ptr);
            if(node != NULL)
            {
		if(was_expanded)
		    gtk_ctree_expand(ctree, node);

                EDVScrollCListToPosition(
                    clist, last_hpos, last_vpos
                );
            }

            gtk_clist_thaw(clist);
        }

        /* Update contents clist. */
        clist = (GtkCList *)browser->contents_clist;
        if((clist != NULL) && (cur_path != NULL))
        {
            gfloat last_vpos, last_hpos;


            /* Record last scroll position. */
            last_hpos = (clist->hadjustment != NULL) ?
                clist->hadjustment->value : 0.0;
            last_vpos = (clist->vadjustment != NULL) ?
                clist->vadjustment->value : 0.0;

            gtk_clist_freeze(clist);
            EDVBrowserContentsDoUpdate(browser, cur_path, TRUE);
            gtk_clist_thaw(clist);

	    /* Scroll back to original position. */
	    EDVScrollCListToPosition(
		clist, last_hpos, last_vpos
	    );
        }


        GUIBlockInput(browser->toplevel, FALSE);
        EDVBrowserSetBusy(browser, FALSE);


        EDVBrowserUpdateMenus(browser);

        EDVStatusBarMessage(
            browser->status_bar, "Refreshed all listings", FALSE
        );


        /* Deallocate copy of current location path. */
        g_free(cur_path);
        cur_path = NULL;
}
