/*
                 Endeavour Browser Directory CTree Handling
 */

#ifndef BROWSERDIRTREE_H
#define BROWSERDIRTREE_H

#include <sys/types.h>
#include <gtk/gtk.h>

#include "edvtypes.h"
#include "edvobj.h"
#include "edvdevices.h"
#include "browser.h"


extern gint EDVNodeDiskObjectLStat(
        GtkCTree *ctree, GtkCTreeNode *node,
        struct stat *stat_buf
);
extern gint EDVNodeDiskObjectStat(
        GtkCTree *ctree, GtkCTreeNode *node,
        struct stat *stat_buf
);
extern gchar *EDVNodeDiskObjectFullPath(
	GtkCTree *ctree, GtkCTreeNode *node
);
extern GtkCTreeNode *EDVBrowserDirTreeGetVFSToplevel(
        edv_browser_struct *browser
);

extern GtkCTreeNode *EDVBrowserDirTreeInsertNode(
        edv_browser_struct *browser,
        GtkCTreeNode *parent, GtkCTreeNode *sibling,
        edv_object_struct *object
);

extern void EDVBrowserDirTreeDoCreateToplevels(
        edv_browser_struct *browser
);

extern void EDVBrowserDirTreeDoRefresh(
        edv_browser_struct *browser, GtkCTreeNode *node,
        gbool update_progress
);
extern void EDVBrowserDirTreeDoExpand(
	edv_browser_struct *browser, GtkCTreeNode *node,
        gbool update_progress
);

extern void EDVBrowserDirTreeDoSync(
        edv_browser_struct *browser, GtkCTreeNode *node
);

extern void EDVBrowserDirTreeDoSelectPath(
        edv_browser_struct *browser, const gchar *path
);

extern GtkCTreeNode *EDVBrowserDirTreeFindNodeByPath(
        edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserDirTreeDoFPromptRename(
        edv_browser_struct *browser, GtkCTreeNode *node
);

extern void EDVBrowserDirTreeObjectAddedNotify(
        edv_browser_struct *browser, const gchar *path,
	const struct stat *lstat_buf
);
extern void EDVBrowserDirTreeObjectModifiedNotify(
        edv_browser_struct *browser, const gchar *path,
        const gchar *new_path,
        const struct stat *lstat_buf
);
extern void EDVBrowserDirTreeObjectRemovedNotify(
	edv_browser_struct *browser, const gchar *path
);

extern void EDVBrowserDirTreeMountNotify(
        edv_browser_struct *browser, edv_device_struct *dev_ptr,
        gbool is_mounted
);



#endif	/* BROWSERDIRTREE_H */
