/*
                  Endeavour Archiver Operation Callbacks
 */

#ifndef ARCHIVEROPCB_H
#define ARCHIVEROPCB_H


#include <gtk/gtk.h>
#include "archiver.h"


extern void EDVArchiverMenuItemCB(GtkWidget *widget, gpointer data);
extern gint EDVArchiverMenuItemEnterCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gint EDVArchiverMenuItemLeaveCB(
        GtkWidget *widget, GdkEventCrossing *crossing, gpointer data
);
extern gchar *EDVArchiverFindBarLocationCB(gpointer fb, gpointer data);
extern void EDVArchiverOPCB(gpointer data);
extern void EDVArchiverOPEnterCB(gpointer data);
extern void EDVArchiverOPLeaveCB(gpointer data);

extern void EDVArchiverFindBarStartCB(gpointer fb, gpointer data);
extern void EDVArchiverFindBarEndCB(
        gpointer fb, gint total_matches, gpointer data
);
extern void EDVArchiverFindBarMatchCB(
        const gchar *path, const struct stat *lstat_buf, const gchar *excerpt,
        gpointer data
);

extern void EDVArchiverBarStatusMessageCB(
        gpointer bar, const gchar *message, gpointer data
);
extern void EDVArchiverBarStatusProgressCB(
        gpointer bar, gfloat progress, gpointer data
);

extern void EDVArchiverOPSyncDisks(edv_archiver_struct *archiver);
extern void EDVArchiverOPWriteProtect(edv_archiver_struct *archiver);

extern void EDVArchiverOPClose(edv_archiver_struct *archiver);
extern void EDVArchiverOPExit(edv_archiver_struct *archiver);

extern void EDVArchiverOPAdd(edv_archiver_struct *archiver);
extern void EDVArchiverOPExtract(edv_archiver_struct *archiver);
extern void EDVArchiverOPExtractAll(edv_archiver_struct *archiver);
extern void EDVArchiverOPDelete(edv_archiver_struct *archiver);
extern void EDVArchiverOPSelectAll(edv_archiver_struct *archiver);
extern void EDVArchiverOPUnselectAll(edv_archiver_struct *archiver);

extern void EDVArchiverOPRefresh(edv_archiver_struct *archiver);
extern void EDVArchiverOPRefreshAll(edv_archiver_struct *archiver);


#endif	/* ARCHIVEROPCB_H */
