#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#ifdef __SOLARIS__
# include "../include/os.h"
#endif

#include "guiutils.h"

#include "edvtypes.h"
#include "edvcfg.h"
#include "archiveopts.h"
#include "endeavour.h"
#include "edvutils.h"
#include "edvcfglist.h"
#include "config.h"

#include "images/icon_archive_add_20x20.xpm"
#include "images/icon_archive_extract_20x20.xpm"
#include "images/icon_cancel_20x20.xpm"

#include "images/archiver_48x48.xpm"


static gint EDVArchiveOptionsCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
);
static void EDVArchiveOptionsDestroyCB(GtkObject *object, gpointer data);
static void EDVArchiveOptionsOKCB(GtkWidget *widget, gpointer data);
static void EDVArchiveOptionsCancelCB(GtkWidget *widget, gpointer data);
static void EDVArchiveOptionsCompressionValueChangedCB(
	GtkAdjustment *adj, gpointer data
);

static void EDVArchiveOptionsBuildDialog(
        gint width, gint height, const gchar *title,
        guchar **ok_btn_icon, const gchar *ok_btn_label,
        guchar **cancel_btn_icon, const gchar *cancel_btn_label,
        GtkWidget *ref_toplevel,
        GtkWidget **toplevel_rtn, GtkWidget **client_vbox_rtn,
        GtkAccelGroup **accelgrp_rtn
);

gbool EDVArchiveAddQueryOptions(
        edv_core_struct *core_ptr,
        GtkWidget *ref_toplevel,
        const gchar *arch_obj,
        gbool *recursive,
        gint *compression,		/* 0 to 100. */
        gbool *dereference_links
);
gbool EDVArchiveExtractQueryOptions(
	edv_core_struct *core_ptr,
        GtkWidget *ref_toplevel,
        const gchar *arch_obj,
        gbool *preserve_directories
);


#define MAX(a,b)        (((a) > (b)) ? (a) : (b))
#define MIN(a,b)        (((a) < (b)) ? (a) : (b))
#define CLIP(a,l,h)     (MIN(MAX((a),(l)),(h)))
#define ABSOLUTE(x)     (((x) < 0) ? ((x) * -1) : (x))


#define BTN_WIDTH	(100 + (2 * 3))
#define BTN_HEIGHT	(30 + (2 * 3))


static gbool got_response;


/*
 *	Closes the given toplevel window given by data and breaks
 *	the highest gtk_main level.
 */
static gint EDVArchiveOptionsCloseCB(
	GtkWidget *widget, GdkEvent *event, gpointer data
)
{
	EDVArchiveOptionsCancelCB(widget, data);
	return(TRUE);
}

/*
 *	Destroy callback.
 */
static void EDVArchiveOptionsDestroyCB(GtkObject *object, gpointer data)
{
	return;
}

/*
 *	OK button callback.
 */
static void EDVArchiveOptionsOKCB(GtkWidget *widget, gpointer data)
{
	got_response = TRUE;
        gtk_main_quit();
}

/*
 *	Cancel button callback.
 */
static void EDVArchiveOptionsCancelCB(GtkWidget *widget, gpointer data)
{
        got_response = FALSE;
        gtk_main_quit();
}


/*
 *	Compression scale adjustment "value_changed" signal callback.
 */
static void EDVArchiveOptionsCompressionValueChangedCB(
        GtkAdjustment *adj, gpointer data
)
{
	gchar num_str[80];
	GtkLabel *label = (GtkLabel *)data;
	if((adj == NULL) || (label == NULL))
	    return;

	sprintf(num_str, "%i%%", (gint)adj->value);
	gtk_label_set_text(label, num_str);
}

/*
 *	Builds a standard toplevel dialog and returns the pointers to
 *	the created widgets.
 */
static void EDVArchiveOptionsBuildDialog(
	gint width, gint height, const gchar *title,
	guchar **ok_btn_icon, const gchar *ok_btn_label,
	guchar **cancel_btn_icon, const gchar *cancel_btn_label,
	GtkWidget *ref_toplevel,
	GtkWidget **toplevel_rtn, GtkWidget **client_vbox_rtn,
	GtkAccelGroup **accelgrp_rtn
)
{
	gint	bw = BTN_WIDTH,
		bh = BTN_HEIGHT,
		border_major = 5;
	GdkWindow *window;
	GtkAccelGroup *accelgrp;
        GtkWidget *w, *parent, *parent2;
        GtkWidget *toplevel, *main_vbox;


        /* Create keyboard accelerator group. */
        accelgrp = gtk_accel_group_new();
	if(accelgrp_rtn != NULL)
	    (*accelgrp_rtn) = accelgrp;

        /* Create toplevel. */
        toplevel = parent = w = gtk_window_new(GTK_WINDOW_DIALOG);
        gtk_widget_set_usize(w, width, height);
        gtk_widget_realize(w);
        gtk_window_set_title(GTK_WINDOW(w), title);
        window = w->window;
        if(window != NULL)
        {
            gdk_window_set_decorations(
                window,
                GDK_DECOR_TITLE | GDK_DECOR_MENU | GDK_DECOR_MINIMIZE
            );
            gdk_window_set_functions(
                window,
                GDK_FUNC_MOVE | GDK_FUNC_MINIMIZE | GDK_FUNC_CLOSE
            );
	    GUISetWMIcon(window, (u_int8_t **)archiver_48x48_xpm);
        }
        gtk_signal_connect(
            GTK_OBJECT(w), "delete_event",
            GTK_SIGNAL_FUNC(EDVArchiveOptionsCloseCB), NULL
        );
        gtk_signal_connect(
            GTK_OBJECT(w), "destroy",
            GTK_SIGNAL_FUNC(EDVArchiveOptionsDestroyCB),
            (gpointer)toplevel
        );
        gtk_container_border_width(GTK_CONTAINER(w), 0);
        gtk_accel_group_attach(accelgrp, GTK_OBJECT(w));
        if((ref_toplevel != NULL) ? GTK_IS_WINDOW(GTK_OBJECT(ref_toplevel)) : 0)
        {
            gtk_window_set_modal(GTK_WINDOW(toplevel), TRUE);
            gtk_window_set_transient_for(
                GTK_WINDOW(toplevel), GTK_WINDOW(ref_toplevel)
            );
        }
	if(toplevel_rtn != NULL)
	    (*toplevel_rtn) = toplevel;

        main_vbox = w = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(parent), w);
        gtk_widget_show(w);
        parent = w;

        w = gtk_vbox_new(FALSE, border_major);
        gtk_container_border_width(GTK_CONTAINER(w), border_major);
        gtk_box_pack_start(GTK_BOX(parent), w, TRUE, TRUE, 0);
        gtk_widget_show(w);
        parent2 = w;
	if(client_vbox_rtn != NULL)
	    (*client_vbox_rtn) = w;

	w = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(main_vbox), w, FALSE, FALSE, 0);
        gtk_widget_show(w);

        /* Buttons. */
        w = gtk_hbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(main_vbox), w, FALSE, FALSE, border_major);
        gtk_widget_show(w);
        parent2 = w;

        /* OK button. */
        w = GUIButtonPixmapLabelH(
	    (u_int8_t **)ok_btn_icon, ok_btn_label, NULL
	);
        gtk_widget_set_usize(w, bw, bh);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT | GTK_HAS_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVArchiveOptionsOKCB), NULL
        );
        gtk_accel_group_add(
            accelgrp, GDK_Return, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_3270_Enter, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_KP_Enter, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_accel_group_add(
            accelgrp, GDK_ISO_Enter, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);

        /* Cancel button. */
        w = GUIButtonPixmapLabelH(
            (u_int8_t **)cancel_btn_icon, cancel_btn_label, NULL
        );
        gtk_widget_set_usize(w, bw, bh);
        GTK_WIDGET_SET_FLAGS(w, GTK_CAN_DEFAULT);
        gtk_box_pack_start(GTK_BOX(parent2), w, TRUE, FALSE, 0);
        gtk_signal_connect(
            GTK_OBJECT(w), "clicked",
            GTK_SIGNAL_FUNC(EDVArchiveOptionsCancelCB), NULL
        );
        gtk_accel_group_add(
            accelgrp, GDK_Escape, 0, GTK_ACCEL_VISIBLE,
            GTK_OBJECT(w), "clicked"
        );
        gtk_widget_show(w);
}


/*
 *      Blocks execution untill response is received, returns TRUE if the
 *      user clicked on OK and in which case the return values will be
 *      set.
 */
gbool EDVArchiveAddQueryOptions(
	edv_core_struct *core_ptr,
        GtkWidget *ref_toplevel,
        const gchar *arch_obj,
        gbool *recursive,
        gint *compression,		/* 0 to 100. */
        gbool *dereference_links
)
{
        gint    width = 320,
                height = -1,
		scale_width = 150,
                border_minor = 2;
        GtkAccelGroup *accelgrp = NULL;
        GtkWidget *toplevel = NULL, *client_vbox = NULL;

        GtkWidget *recursive_check = NULL;
	GtkAdjustment *compression_adj = NULL;
	GtkWidget *dereference_links_check = NULL;


        if(core_ptr == NULL)
            return(FALSE);


        /* Get configuration values. */
        if(recursive != NULL)
            *recursive = EDVCFGItemListGetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE
            );
        if(compression != NULL)
            *compression = EDVCFGItemListGetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION
            );
        if(dereference_links != NULL)
            *dereference_links = EDVCFGItemListGetValueI(
                core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS
            );


        /* Reset global got response flag. */
        got_response = FALSE;

        /* Create dialog base widgets. */
        EDVArchiveOptionsBuildDialog(
            width, height,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Add To Archive Options",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Aada A Archivo Las Opciones",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Ajouter A l'Archive Options",
#endif
            (guchar **)icon_archive_add_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Add",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Agregue",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Ajouter",
#endif
            (guchar **)icon_cancel_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Cancel",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Cancele",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Annuler",
#endif
            ref_toplevel,
            &toplevel, &client_vbox, &accelgrp
        );

        /* Create grab options widgets. */
        if(client_vbox != NULL)
        {
	    GtkAdjustment *adj;
            GtkWidget *w, *parent = client_vbox, *parent2;


            /* Recursive check. */
            w = gtk_hbox_new(FALSE, border_minor);
            gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
            parent2 = w;
            /* Check button. */
            recursive_check = w =
                gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Recurse Into Directories"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "Recurse En Guas"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Recurse Dans les Annuaires"
#endif
                );
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            if((recursive != NULL) ? *recursive : FALSE)
                GTK_TOGGLE_BUTTON(w)->active = TRUE;
	    GUISetWidgetTip(
		w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to include the adding of objects found in all subsequent\
 directories of the selected path(s). This value may not apply to all\
 archive formats"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto incluir el agregar de objetos encontr guas en total\
 subsiguientes del sendero (s) escogido. Este valor no puede aplicar a\
 todo archivo formatear"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour inclure l'addition d'objets fonde dans tous\
 annuaires subsquents du sentier choisi (s). Cette valeur ne peut pas\
 s'appliquer  tous formats d'archive"
#endif
	    );
            gtk_widget_show(w);

	    /* Compression scale. */
            w = gtk_hbox_new(FALSE, border_minor);
            gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
            parent2 = w;
	    /* Label. */
	    w = gtk_label_new(
#ifdef PROG_LANGUAGE_ENGLISH
		"Compression:"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                "La Compresin:"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                "Compression:"
#endif
	    );
	    gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
	    gtk_widget_show(w);
	    /* Adjustment and scale. */
	    compression_adj = adj = (GtkAdjustment *)gtk_adjustment_new(
		(compression != NULL) ? (gfloat)*compression : 0.0,
		0.0, 100.0,
		10.0, 25.0, 0.0
	    );
	    w = gtk_hscale_new(adj);
	    gtk_scale_set_draw_value(GTK_SCALE(w), FALSE);
	    gtk_widget_set_usize(w, scale_width, -1);
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            GUISetWidgetTip(
                w,
#ifdef PROG_LANGUAGE_ENGLISH
"Specifies the amount of compression; 0% means no compression,\
 50% means default/optimul compression, and 100% means maximum\
 compression. This value may not apply to all archive formats"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Especifica la cantidad de la compresin; 0% significa no compresin,\
 50% significa la rebelda/la compresin de optimul, y 100% significan\
 la compresin mxima. Este valor no puede aplicar a todo archivo\
 formatear"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Spcifie la quantit de compression; 0% ne signifie pas de compression,\
 50% signifie la compression d'implicite/optimul, et 100% signifie la\
 compression maximum. Cette valeur ne peut pas s'appliquer  tous\
 formats d'archive"
#endif
            );
            gtk_widget_show(w);
            /* Value label. */
            w = gtk_label_new("");
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
	    gtk_signal_connect(
		GTK_OBJECT(adj), "value_changed",
		GTK_SIGNAL_FUNC(EDVArchiveOptionsCompressionValueChangedCB),
		w
	    );
	    EDVArchiveOptionsCompressionValueChangedCB(adj, w);

            /* Dereference links check. */
            w = gtk_hbox_new(FALSE, border_minor);
            gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
            parent2 = w;
            /* Check button. */
            dereference_links_check = w =
                gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
                    "Dereference Links"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "Dereference Los Eslabones"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Dereference Liens"
#endif
                );
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            if((dereference_links != NULL) ? *dereference_links : FALSE)
                GTK_TOGGLE_BUTTON(w)->active = TRUE;
            GUISetWidgetTip(
                w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to add the destination of any link objects instead of the\
 link object itself. This value may not apply to all archive formats"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto agregar el destino de cualquier eslabn se opone en vez\
 del eslabn se opone. Este valor no puede aplicar a todo archivo\
 formatear"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour ajouter la destination de n'importe quels objets de\
 lien au lieu du lien lui-mme oppose. Cette valeur ne peut pas\
 s'appliquer  tous formats d'archive"
#endif
            );
            gtk_widget_show(w);


        }

        /* Map toplevel. */
        gtk_widget_show(toplevel);


        /* Enter blocking gtk_main loop. */
        gtk_main();


        /* Get values from widgets if user clicked on ok. */
        if(got_response)
        {
            if((recursive != NULL) && (recursive_check != NULL))
	    {
                (*recursive) = GTK_TOGGLE_BUTTON(
                    recursive_check)->active;

                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_RECURSIVE,
                    *recursive, FALSE
                );
	    }

	    if((compression != NULL) && (compression_adj != NULL))
	    {
		*compression = (gint)compression_adj->value;
		EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_COMPRESSION,
                    *compression, FALSE
                );
	    }

	    if((dereference_links != NULL) &&
	       (dereference_links_check != NULL)
	    )
            {
                (*dereference_links) = GTK_TOGGLE_BUTTON(
                    dereference_links_check)->active;

                EDVCFGItemListSetValueI(
                    core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_ADD_DEREFERENCE_LINKS,
                    *dereference_links, FALSE
                );
            }
        }


        /* Destroy widgets and related resources. */
        gtk_window_set_modal(GTK_WINDOW(toplevel), FALSE);
        gtk_window_set_transient_for(GTK_WINDOW(toplevel), NULL);
        gtk_widget_destroy(toplevel);
        gtk_accel_group_unref(accelgrp);


        /* Return user response. */
        return(got_response);
}


/*
 *      Blocks execution untill response is received, returns TRUE if the
 *	user clicked on OK and in which case the return values will be
 *	set.
 */
gbool EDVArchiveExtractQueryOptions(
	edv_core_struct *core_ptr,
        GtkWidget *ref_toplevel,
        const gchar *arch_obj,
        gbool *preserve_directories
)
{
        gint    width = 320,
                height = -1,
                border_minor = 2;
        GtkAccelGroup *accelgrp = NULL;
        GtkWidget *toplevel = NULL, *client_vbox = NULL;

	GtkWidget *preserve_directories_check = NULL;


	if(core_ptr == NULL)
	    return(FALSE);


	/* Get configuration values. */
	if(preserve_directories != NULL)
	    *preserve_directories = EDVCFGItemListGetValueI(
		core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR
	    );


        /* Reset global got response flag. */
        got_response = FALSE;

        /* Create dialog base widgets. */
        EDVArchiveOptionsBuildDialog(
            width, height,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Extract From Archive Options",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Extraiga Del Archivo Las Opciones",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Extraire De L'Archive Options",
#endif
	    (guchar **)icon_archive_extract_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
	    "Extract",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "El Extracto",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Extrait",
#endif
	    (guchar **)icon_cancel_20x20_xpm,
#ifdef PROG_LANGUAGE_ENGLISH
            "Cancel",
#endif
#ifdef PROG_LANGUAGE_SPANISH
            "Cancele",
#endif
#ifdef PROG_LANGUAGE_FRENCH
            "Annuler",
#endif
            ref_toplevel,
            &toplevel, &client_vbox, &accelgrp
        );

        /* Create grab options widgets. */
        if(client_vbox != NULL)
        {
            GtkWidget *w, *parent = client_vbox, *parent2;


            /* Preserve original directory paths check. */
            w = gtk_hbox_new(FALSE, border_minor);
            gtk_box_pack_start(GTK_BOX(parent), w, FALSE, FALSE, 0);
            gtk_widget_show(w);
            parent2 = w;
            /* Check button. */
	    preserve_directories_check = w =
		gtk_check_button_new_with_label(
#ifdef PROG_LANGUAGE_ENGLISH
		    "Preserve Original Directory Paths"
#endif
#ifdef PROG_LANGUAGE_SPANISH
                    "Preserve Senderos Originales De Gua"
#endif
#ifdef PROG_LANGUAGE_FRENCH
                    "Conserver Les Sentiers d'Annuaire Originaux"
#endif
		);
            gtk_box_pack_start(GTK_BOX(parent2), w, FALSE, FALSE, 0);
            if((preserve_directories != NULL) ? *preserve_directories : FALSE)
                GTK_TOGGLE_BUTTON(w)->active = TRUE;
	    GUISetWidgetTip(
		w,
#ifdef PROG_LANGUAGE_ENGLISH
"Check this to maintain the path prefixes of each archive object\
 to be relative to the specified target location during extracting"
#endif
#ifdef PROG_LANGUAGE_SPANISH
"Verifique esto mantener los prefijos de sendero de cada objeto de\
 archivo para ser el pariente a la ubicacin especificada del blanco\
 durante extraer"
#endif
#ifdef PROG_LANGUAGE_FRENCH
"Vrifier ceci pour maintenir les prfixes de sentier de chaque objet\
 d'archive pour tre relatifs  l'emplacement de cible spcifi pendant\
 extraire"
#endif
	    );
            gtk_widget_show(w);


        }


        /* Map toplevel. */
        gtk_widget_show_raise(toplevel);


        /* Enter blocking gtk_main loop. */
        gtk_main();


        /* Get values from widgets if user clicked on ok. */
        if(got_response)
        {
            if((preserve_directories != NULL) &&
	       (preserve_directories_check != NULL)
	    )
	    {
		(*preserve_directories) = GTK_TOGGLE_BUTTON(
		    preserve_directories_check)->active;

		EDVCFGItemListSetValueI(
		    core_ptr->cfg_list, EDV_CFG_PARM_ARCHIVE_EXTRACT_PRESERVE_DIR,
		    *preserve_directories, FALSE
		);
	    }



        }


        /* Destroy widgets and related resources. */
        gtk_window_set_modal(GTK_WINDOW(toplevel), FALSE);
        gtk_window_set_transient_for(GTK_WINDOW(toplevel), NULL);
        gtk_widget_destroy(toplevel);
        gtk_accel_group_unref(accelgrp);


        /* Return user response. */
        return(got_response);
}
