#include "encompass.h"
#include <gtkhtml/htmlengine-search.h>

struct _GtkHTMLSearchDialog {
  GtkWidget * dialog;
  GtkWidget * html;
  GtkWidget * entry;
  GtkWidget * backward;
  GtkWidget * casesense;
};

static void encompass_search_do (GtkWidget * widget,
				 GtkHTMLSearchDialog * dialog) {
  GtkWidget * mbox;
  gchar * sstring;

  sstring = g_strdup (gtk_entry_get_text (GTK_ENTRY (dialog->entry)));

  gnome_dialog_close (GNOME_DIALOG (dialog->dialog));
  if (!html_engine_search (GTK_HTML (dialog->html)->engine,
			   g_strdup (sstring),
			   GTK_TOGGLE_BUTTON (dialog->casesense)->active,
			   !GTK_TOGGLE_BUTTON (dialog->backward)->active,
			   FALSE)) {
    mbox = gnome_message_box_new (_("Text not found."),
				  GNOME_MESSAGE_BOX_INFO,
				  GNOME_STOCK_BUTTON_OK, NULL);
    gtk_widget_show (mbox);
  }
  g_free (sstring);
}

void encompass_search_page (GtkWidget * widget, BrowserWindow * window) {
  GtkHTMLSearchDialog * dialog;
  GtkWidget * hbox;

  dialog = g_new0 (GtkHTMLSearchDialog, 1);
  
  dialog->dialog= gnome_dialog_new (_("Find in Page"),
				    _("Search"), GNOME_STOCK_BUTTON_CANCEL,
				    NULL);
  dialog->entry = gtk_entry_new ();
  dialog->backward = gtk_check_button_new_with_label (_("Reverse Search"));
  dialog->casesense = gtk_check_button_new_with_label (_("Case Sensitive"));
  dialog->html = window->html;

  hbox = gtk_hbox_new (FALSE, 0);

  gtk_box_pack_start_defaults (GTK_BOX (hbox), dialog->backward);
  gtk_box_pack_start_defaults (GTK_BOX (hbox), dialog->casesense);

  gtk_box_pack_start_defaults (GTK_BOX (GNOME_DIALOG (dialog->dialog)->vbox),
			       dialog->entry);
  gtk_box_pack_start_defaults (GTK_BOX (GNOME_DIALOG (dialog->dialog)->vbox),
			       hbox);

  gnome_dialog_button_connect (GNOME_DIALOG (dialog->dialog), 0,
			       encompass_search_do, dialog);
  gnome_dialog_close_hides (GNOME_DIALOG (dialog->dialog), TRUE);
  gnome_dialog_set_close (GNOME_DIALOG (dialog->dialog), TRUE);

  gnome_dialog_set_default (GNOME_DIALOG (dialog->dialog), 0);
  gtk_widget_grab_focus (dialog->entry);

  gtk_signal_connect (GTK_OBJECT (dialog->entry), "activate",
		      GTK_SIGNAL_FUNC (encompass_search_do), dialog);
  
  gtk_widget_show_all (GTK_WIDGET (dialog->dialog));
}

void encompass_search_page_next (GtkWidget * widget, BrowserWindow * window) {
  GtkWidget * mbox;

  if (GTK_HTML (window->html)->engine->search_info) {
    if(!html_engine_search_next (GTK_HTML (window->html)->engine)) {
      mbox = gnome_message_box_new(_("End of page reached. "
				     "Continue from beginning?"),
				   GNOME_MESSAGE_BOX_QUESTION,
				   GNOME_STOCK_BUTTON_YES,
				   GNOME_STOCK_BUTTON_NO, NULL);
      gnome_dialog_button_connect(GNOME_DIALOG(mbox), 0,
				  encompass_search_page_next, window);
      gtk_widget_show(mbox);
    }
  } else {
    encompass_search_page (widget, window);
  }
}
