#include "encompass.h"

void encompass_history_go_back (GtkWidget * widget, BrowserWindow * window) {
  HistoryItem * item;
  gint tmp;

  window->go_position++;
  for (tmp = 0; tmp < g_list_length (window->go_list); tmp++) {
    item = g_list_nth_data (window->go_list, tmp);
    GTK_CHECK_MENU_ITEM (item->widget)->active = FALSE;
  }

  item = g_list_nth_data (window->go_list, window->go_position);
  if (item) {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item->widget), TRUE);
  } else {
    window->go_position--;
  }
}

void encompass_history_go_forward (GtkWidget * widget,
				   BrowserWindow * window) {
  HistoryItem * item;
  gint tmp;

  window->go_position--;
  for (tmp = 0; tmp < g_list_length (window->go_list); tmp++) {
    item = g_list_nth_data (window->go_list, tmp);
    GTK_CHECK_MENU_ITEM (item->widget)->active = FALSE;
  }

  item = g_list_nth_data (window->go_list, window->go_position);
  if (item != NULL) {
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item->widget), TRUE);
  } else {
    window->go_position++;
  }
}

void encompass_history_go_list (GtkWidget * widget, BrowserWindow * window) {
  HistoryItem * item;

  if(GTK_CHECK_MENU_ITEM(widget)->active) {
    window->go_position = g_slist_index (window->group, widget);
    item = g_list_nth_data (window->go_list, window->go_position);
    if (item != NULL) {
      encompass_goto_url (window, item->url, 1);
    }
  }
}

void encompass_history_save (BrowserWindow * window) {
}
