#include "encompass.h"
#include <libgnomevfs/gnome-vfs-mime.h>

typedef struct {
  BrowserWindow * window;
  const gchar * url;
  const EncompassURI * uri;
} BrowserContent;

static gchar * encompass_load_image (gchar * imgurl) {
  const gchar * header = g_strdup ("<html><head><title>Image: ");
  const gchar * body = g_strdup ("</title></head><body><img src=\"");
  const gchar * footer = g_strdup ("\" border=\"0\"></body></html>");

  return g_strdup_printf ("%s%s%s%s%s", header, g_basename (imgurl),
			  body, imgurl, footer);
}

static void encompass_content_type (BrowserContent * content,
				    const gchar * mime_type) {
  if (!strncmp (mime_type, "text/", strlen ("text/")) ||
      !strncmp (mime_type, "multipart/x-mixed-replace",
		strlen ("multipart/x-mixed-replace"))) {
    content->window->good_mime = E_CONTENT_TEXT;
  } else if (!strncmp (mime_type, "image/", strlen ("image/"))) {
    gchar * imgpage;
    gchar * newurl = encompass_parse_url (content->url, content->window->base);

    content->window->handle = gtk_html_begin (GTK_HTML (content->window->html));

    imgpage = encompass_load_image (newurl);
    encompass_set_base (GTK_HTML (content->window->html), newurl,
			content->window);
    gtk_html_write (GTK_HTML (content->window->html), content->window->handle,
		    imgpage, strlen (imgpage));
    gtk_html_end (GTK_HTML (content->window->html), content->window->handle,
		  GTK_HTML_STREAM_OK);
    g_free (newurl);
    g_free (imgpage);
    content->window->good_mime = E_CONTENT_IMAGE;
  } else {
    content->window->good_mime = E_CONTENT_OTHER;
  }
}

guint encompass_check_mime (BrowserWindow * window, const gchar * url) {
  BrowserContent * content;
  ne_session * session;
  ne_request * request;
  EncompassURI * uri;

  uri = encompass_uri_new (url);
  content = g_new0 (BrowserContent, 1);

  content->window = window;
  content->url = url;
  content->uri = uri;

  if (uri->port == 0) {
    if (!g_strcasecmp (uri->protocol, "https")) {
      uri->port = 443;
    } else {
      uri->port = 80;
    }
  }

  if (!g_strcasecmp (uri->protocol, "file")) {
    const gchar * type;
    type = gnome_vfs_get_mime_type_from_uri (gnome_vfs_uri_new (url));
    encompass_content_type (content, type);
  } else {
    session = ne_session_create (uri->protocol, uri->hostname, uri->port);
    ne_set_read_timeout (session, 5);
    ne_set_useragent (session,
		      "Mozilla/5 (compatible; Encompass/" VERSION ")");

    if (!g_strcasecmp ("https", uri->protocol)) {
      ne_ssl_set_verify (session, (void *) encompass_ssl_verify, window);
      ne_ssl_provide_ccert (session, (void *) encompass_ssl_provide_cert,
			    window);
      ne_ssl_load_default_ca (session);
    }
    if (window->prefs->use_proxy) {
      ne_session_proxy (session, window->prefs->proxy_host,
			window->prefs->proxy_port);
    }
    request = ne_request_create (session, "HEAD", uri->path);
    ne_add_response_header_handler (request, "Content-Type",
				    (void *) encompass_content_type, content);
    encompass_find_cookies (uri, request, window);
    ne_request_dispatch (request);

    ne_request_destroy (request);
    ne_session_destroy (session);
  }
  encompass_uri_destroy (uri);

  return window->good_mime;
}

gchar * encompass_parse_url (const gchar * url, EncompassURI * base) {
  EncompassURI * tmpurl;
  gchar * blah;

  g_return_val_if_fail (url != NULL, NULL);

  tmpurl = encompass_uri_dup (base, ENCOMPASS_URI_DUP_ALL);

  if (!strncmp (url, "//", strlen ("//"))) {
    blah = g_strconcat ("http:", url, NULL);
    if (tmpurl != NULL) {
      encompass_uri_destroy (tmpurl);
      tmpurl = encompass_uri_new (blah);
    } else {
      tmpurl = encompass_uri_new (blah);
    }
  } else if (*url == '/') {
    if (tmpurl) {
      encompass_uri_set_path (tmpurl, url);
    }
  } else if (!strncmp (url, "../", strlen ("../"))) {
    gchar * tmpblah;

    tmpblah = g_strndup (g_dirname (base->path),
			 strlen (g_dirname (base->path)) -
			 strlen (strrchr (g_dirname (base->path), '/')));
    blah = g_strdup_printf ("%s/%s", tmpblah, url + strlen ("../"));
    if (tmpurl != NULL) {
      encompass_uri_set_path (tmpurl, blah);
    }
  } else if (!strncmp (url, "./", strlen ("./"))) {
    blah = g_strdup_printf ("%s/%s", g_dirname (base->path),
			    url + strlen ("./"));
    if (tmpurl != NULL) {
      encompass_uri_set_path (tmpurl, blah);
    }
  } else if (strchr (url, ':')) {
    tmpurl = encompass_uri_new (url);
  } else if (*url == '#') {
    encompass_uri_set_reference (tmpurl, url + 1);
  } else if (*url == '?') {
    if (strchr (tmpurl->path, '?') != NULL) {
      blah = g_strndup (tmpurl->path, strlen (tmpurl->path) -
			strlen (strchr (tmpurl->path, '?')));
    } else {
      blah = g_strdup (tmpurl->path);
    }
    if (tmpurl != NULL) {
      encompass_uri_set_path (tmpurl, g_strconcat (blah, url, NULL));
    }
  } else if (!g_strcasecmp (g_dirname (base->path), "/")) {
    blah = g_strdup_printf ("/%s", url);
    if (tmpurl) {
      encompass_uri_set_path (tmpurl, blah);
    }
  } else {
    blah = g_strdup_printf ("%s/%s", g_dirname (base->path), url);
    if (tmpurl) {
      encompass_uri_set_path (tmpurl, blah);
    }
  }
  if (tmpurl) {
    return encompass_uri_to_string (tmpurl);
  } else {
    return g_strdup (url);
  }
}

gchar * encompass_validate_uri (gchar * url) {
  gchar * tmpurl = NULL;
  gchar * testlocal;

  if (url && *url) {
    if (strstr (url, "://")) {
      tmpurl = g_strdup (url);
    } else {
      testlocal = g_strconcat (g_get_current_dir (), "/", url, NULL);
      if (!strncmp (url, "ftp.", strlen ("ftp."))) {
	tmpurl = g_strdup_printf ("ftp://%s", url);
      } else if (!strncmp (url, "/", strlen ("/"))) {
	tmpurl = g_strdup_printf ("file://%s", url);
      } else if (g_file_exists (g_strdup (testlocal))) {
	tmpurl = g_strdup_printf ("file://%s", testlocal);
      } else {
	tmpurl = g_strdup_printf ("http://%s", url);
      }
      g_free (testlocal);
    }
  }
  if (strstr (tmpurl, ":/")) {
    if (!strrchr ((gchar *) strstr (tmpurl, ":/") + 3, '/') &&
	tmpurl[strlen (tmpurl)] != '/') {
      tmpurl = g_strdup_printf ("%s/", tmpurl);
    }
  }
  return tmpurl;
}

static void encompass_go_list_clear (gpointer data, gpointer udata) {
  HistoryItem * item = (HistoryItem *) data;
	
  if(item->widget) {
    gtk_widget_destroy(item->widget);
  }
  item->widget = NULL;
}

void encompass_goto_url (BrowserWindow * window, gchar * url,
			 int history) {
  EncompassURI * uri;
  HistoryItem * item;
  int tmp, i;
  gchar * real_url;

  real_url = encompass_parse_url (encompass_validate_uri (url), window->base);
  gtk_widget_set_sensitive (window->stop_tool_item, TRUE);
  if (real_url && *real_url) {
    uri = encompass_uri_new (real_url);

    gtk_widget_set_sensitive (window->stop_tool_item, TRUE);
    if ((*url == '#' && window->base != NULL)
	|| (window->base != NULL &&
	    (uri->protocol != NULL && window->base->protocol != NULL &&
	     *uri->protocol && *window->base->protocol &&
	     !strcmp (window->base->protocol, uri->protocol)) &&
	    (window->base->hostname != NULL &&
	     uri->hostname != NULL &&
	     !strcmp (window->base->hostname, uri->hostname)) &&
	    window->base->port == uri->port &&
	    !strcmp (window->base->path, uri->path) &&
	    uri->reference != NULL && *uri->reference)) {
      encompass_set_base (GTK_HTML (window->html), real_url, window);
      gtk_html_jump_to_anchor (GTK_HTML (window->html), uri->reference);
    } else if (!g_strcasecmp (uri->protocol, "file")) {
      switch (encompass_check_mime (window, real_url)) {
      case E_CONTENT_TEXT: {
	window->handle = gtk_html_begin (GTK_HTML (window->html));
	encompass_set_base (GTK_HTML (window->html), real_url, window);
	encompass_load_file (window, uri, window->handle);
	break;
      }
      case E_CONTENT_IMAGE: {
	break;
      }
      case E_CONTENT_OTHER: {
	CORBA_Environment ev;
	GNOME_Elysium_Download_Shell shell;

	CORBA_exception_init (&ev);
	shell =
	  bonobo_activation_activate_from_id ("OAFIID:GNOME_Elysium_Download_Shell",
					      0, NULL, &ev);
	if (ev._major != CORBA_NO_EXCEPTION || shell == CORBA_OBJECT_NIL) {
	} else {
	  GNOME_Elysium_Download_Shell_save_uri_as (shell, real_url, &ev);
	}
	CORBA_exception_free (&ev);  
	encompass_uri_destroy (uri);
	g_free (real_url);
	return;
      }
      }
    } else if (!g_strcasecmp (uri->protocol, "mailto")) {
      gtk_widget_set_sensitive (window->stop_tool_item, FALSE);
      gnome_url_show (encompass_uri_to_string (uri), NULL);
      encompass_uri_destroy (uri);
      g_free (real_url);
      return;
    } else if (!g_strcasecmp (uri->protocol, "http") ||
	       !g_strcasecmp (uri->protocol, "https")) {
      switch (encompass_check_mime (window, real_url)) {
      case E_CONTENT_TEXT: {
	window->handle = gtk_html_begin (GTK_HTML (window->html));
	encompass_set_base (GTK_HTML (window->html), real_url, window);
	encompass_http_load_url (window, uri, window->handle, FALSE, NULL);
	break;
      }
      case E_CONTENT_IMAGE: {
	break;
      }
      case E_CONTENT_OTHER: {
	CORBA_Environment ev;
	GNOME_Elysium_Download_Shell shell;

	CORBA_exception_init (&ev);
	shell =
	  bonobo_activation_activate_from_id ("OAFIID:GNOME_Elysium_Download_Shell",
					      0, NULL, &ev);
	if (ev._major != CORBA_NO_EXCEPTION || shell == CORBA_OBJECT_NIL) {
	} else {
	  GNOME_Elysium_Download_Shell_save_uri_as (shell, real_url, &ev);
	}
	CORBA_exception_free (&ev);  
	encompass_uri_destroy (uri);
	g_free (real_url);
	return;
      }
      }
    } else if (!g_strcasecmp (uri->protocol, "ftp")) {
      gtk_widget_set_sensitive (window->stop_tool_item, FALSE);
      gnome_url_show (encompass_uri_to_string (uri), NULL);
      encompass_uri_destroy (uri);
      g_free (real_url);
      return;
    }
    if (uri->reference && *(uri->reference)) {
      gtk_html_jump_to_anchor (GTK_HTML (window->html), uri->reference);
    }
    encompass_uri_destroy (uri);
    if (!history) {
      if(window->go_position) {
	tmp = window->go_position;
	while(tmp) {
	  item = g_list_nth_data(window->go_list, --tmp);
	  if (item) {
	    window->go_list = g_list_remove(window->go_list, item);
	    if(item->url)
	      g_free(item->url);
	    if(item->title)
	      g_free(item->title);
	    if(item->url)
	      gtk_widget_destroy(item->widget);
	    g_free(item);
	  }
	}
	window->go_position = 0;
      }
      tmp = g_list_length(window->go_list);
      while(tmp > MAX_GO_ENTRIES) {
	item = g_list_nth_data(window->go_list, MAX_GO_ENTRIES);
	
	if(item->url)
	  g_free(item->url);
	if(item->title)
	  g_free(item->title);
	if(item->url)
	  gtk_widget_destroy(item->widget);
	g_free(item);

	window->go_list = g_list_remove(window->go_list, item);
	tmp--;
      }
      item = NULL;
      item = g_new0 (HistoryItem, 1);
    
      item->url = g_strdup (real_url);
      item->title = g_strdup (gtk_html_get_title (GTK_HTML (window->html)));

      g_list_foreach (window->go_list, encompass_go_list_clear, NULL);
      window->go_list = g_list_prepend (window->go_list, item);

      tmp = g_list_length (window->go_list);
      window->group = NULL;

      for (i = 0; i < tmp; i++) {
	item = g_list_nth_data (window->go_list, i);
	if (item->title) {
	  if (strlen (item->title) > 32) {
	    gchar * tooltiped;

	    tooltiped = g_strconcat (g_strndup (item->title, 29), "...", NULL);
	    item->widget = gtk_radio_menu_item_new_with_label (window->group,
							       tooltiped);
	    gtk_tooltips_set_tip (window->tips, item->widget, item->title, NULL);
	    g_free (tooltiped);
	  } else {
	    item->widget = gtk_radio_menu_item_new_with_label (window->group,
							       item->title);
	  }
	} else {
	  item->widget = gtk_radio_menu_item_new_with_label (window->group,
							     item->url);
	}
	gtk_signal_connect (GTK_OBJECT (item->widget), "toggled",
			    GTK_SIGNAL_FUNC (encompass_history_go_list),
			    window);
	window->group =
	  gtk_radio_menu_item_group (GTK_RADIO_MENU_ITEM (item->widget));
	if (i == 0) {
	  gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item->widget),
					  TRUE);
	  window->go_position = 0;
	}
	encompass_go_menu_append (window, item->widget);
	gtk_widget_show (item->widget);
      }
      window->group = g_slist_reverse (window->group);
    }  else {
    item = g_list_nth_data (window->go_list, window->go_position);
    gtk_check_menu_item_set_active (GTK_CHECK_MENU_ITEM (item->widget), TRUE);
    }
  }
  tmp = g_list_length (window->go_list);
  if (window->go_position == 0 || tmp < 2) {
    encompass_set_fore_buttons (window, FALSE);
  } else {
    encompass_set_fore_buttons (window, TRUE);
  }
  if (window->go_position == (tmp - 1) || tmp < 2) {
    encompass_set_back_buttons (window, FALSE);
  } else {
    encompass_set_back_buttons (window, TRUE);
  }
  gtk_widget_set_sensitive (window->stop_tool_item, FALSE);
  gnome_appbar_set_status (GNOME_APPBAR (window->status), "");
  gnome_appbar_refresh (GNOME_APPBAR (window->status));
  gtk_widget_draw (window->html, NULL);
}

void encompass_entry_goto_url (GtkWidget * widget, BrowserWindow * window) {
  gchar * url;

  url = g_strdup (gtk_entry_get_text (GTK_ENTRY (window->entry)));
  encompass_goto_url (window, g_strdup (url), 0);
  if (url && *url) {
    g_free (url);
  }
}
