"use strict";

/*
 * This file contains OpenJPEG, compiled from C to JavaScript using Emscripten.
 * This file is released under OpenJPEG's license:
 *
 * Copyright (c) 2002-2007, Communications and Remote Sensing Laboratory, Universite catholique de Louvain (UCL), Belgium
 * Copyright (c) 2002-2007, Professor Benoit Macq
 * Copyright (c) 2001-2003, David Janssens
 * Copyright (c) 2002-2003, Yannick Verschueren
 * Copyright (c) 2003-2007, Francois-Olivier Devaux and Antonin Descampe
 * Copyright (c) 2005, Herve Drolon, FreeImage Team
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS `AS IS'
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

this.Module={};
var args=arguments,Runtime={stackAlloc:function(b){var f=STACKTOP;_memset(STACKTOP,0,b);STACKTOP+=b;STACKTOP=Math.ceil(STACKTOP/4)*4;return f},staticAlloc:function(b){var f=STATICTOP;STATICTOP+=b;STATICTOP=Math.ceil(STATICTOP/4)*4;return f},alignMemory:function(b,f){return Math.ceil(b/(f?f:4))*(f?f:4)},getFunctionIndex:function(b,f){var e=FUNCTION_TABLE.length;FUNCTION_TABLE[e]=b;FUNCTION_TABLE[e+1]=null;Module[f]=b;return e},isNumberType:function(b){return b in Runtime.INT_TYPES||b in Runtime.FLOAT_TYPES},
isPointerType:function(b){return pointingLevels(b)>0},isStructType:function(b){if(isPointerType(b))return false;if(RegExp(/^\[\d+\ x\ (.*)\]/g).test(b))return true;return!Runtime.isNumberType(b)&&b[0]=="%"},INT_TYPES:{i1:0,i8:0,i16:0,i32:0,i64:0},FLOAT_TYPES:{"float":0,"double":0},getNativeFieldSize:function(b,f){var e={_i1:1,_i8:1,_i16:2,_i32:4,_i64:8,_float:4,_double:8}["_"+b];e||(e=4);f||(e=Math.max(e,4));return e},dedup:function(b,f){var e={};return f?b.filter(function(c){if(e[c[f]])return false;
return e[c[f]]=true}):b.filter(function(c){if(e[c])return false;return e[c]=true})},set:function(){for(var b=typeof arguments[0]==="object"?arguments[0]:arguments,f={},e=0;e<b.length;e++)f[b[e]]=0;return f},calculateStructAlignment:function(b){b.flatSize=0;b.alignSize=0;var f=[],e=-1;b.flatIndexes=b.fields.map(function(c){var a,d;if(Runtime.isNumberType(c)||Runtime.isPointerType(c))d=a=Runtime.getNativeFieldSize(c,true);else if(Runtime.isStructType(c)){a=Types.types[c].flatSize;d=Types.types[c].alignSize}else{dprint("Unclear type in struct: "+
c+", in "+b.name_);assert(0)}d=Math.min(d,4);b.alignSize=Math.max(b.alignSize,d);c=Runtime.alignMemory(b.flatSize,d);b.flatSize=c+a;e>=0&&f.push(c-e);return e=c});b.flatSize=Runtime.alignMemory(b.flatSize,b.alignSize);if(f.length==0)b.flatFactor=b.flatSize;else if(Runtime.dedup(f).length==1)b.flatFactor=f[0];b.needsFlattening=b.flatFactor!=1;return b.flatIndexes},__dummy__:0},CorrectionsMonitor={MAX_ALLOWED:0,corrections:0,sigs:{},note:function(b){b=b+"|"+Error().stack;if(!this.sigs[b]){print("Correction: "+
b);this.sigs[b]=0}this.sigs[b]++;this.corrections++;this.corrections>=this.MAX_ALLOWED&&abort("\n\nToo many corrections!")}};function __globalConstructor__(){}var FUNCTION_TABLE=[],__THREW__=false,__ATEXIT__=[],ABORT=false,undef=0;function abort(b){print(b+":\n"+Error().stack);ABORT=true;throw"Assertion: "+b;}function assert(b,f){b||abort("Assertion failed: "+f)}var ALLOC_NORMAL=0,ALLOC_STACK=1,ALLOC_STATIC=2;
function Pointer_make(b,f,e){f=f?f:0;assert(f===0);if(b===HEAP)return f;f=b.length;var c;for(c=0;c<f;c++)if(b[c]===undefined)throw"Invalid element in slab at "+Error().stack;e=[_malloc,Runtime.stackAlloc,Runtime.staticAlloc][e?e:ALLOC_STATIC](Math.max(f,1));for(c=0;c<f;c++){var a=b[c];if(typeof a==="function")a=Runtime.getFunctionIndex(a);IHEAP[e+c]=a;FHEAP[e+c]=a}return e}Module.Pointer_make=Pointer_make;
function Pointer_stringify(b){for(var f="",e=0,c;;){c=String.fromCharCode(IHEAP[b+e]);if(c=="\u0000")break;f+=c;e+=1}return f}var PAGE_SIZE=4096;function alignMemoryPage(b){return Math.ceil(b/PAGE_SIZE)*PAGE_SIZE}var HEAP,IHEAP,FHEAP,STACK_ROOT,STACKTOP,STACK_MAX,STATICTOP,HAS_TYPED_ARRAYS=false,TOTAL_MEMORY=52428800;
function __initializeRuntime__(){HAS_TYPED_ARRAYS=false;try{HAS_TYPED_ARRAYS=false}catch(b){}if(HAS_TYPED_ARRAYS){HEAP=IHEAP=new Int32Array(TOTAL_MEMORY);FHEAP=new Float64Array(TOTAL_MEMORY)}else{var f=TOTAL_MEMORY/32;IHEAP=FHEAP=HEAP=Array(f);for(var e=0;e<f;e++)IHEAP[e]=FHEAP[e]=0}f=intArrayFromString("(null)").concat(0);for(e=0;e<f.length;e++)IHEAP[e]=f[e];Module.HEAP=HEAP;Module.IHEAP=IHEAP;Module.FHEAP=FHEAP;STACK_ROOT=STACKTOP=alignMemoryPage(10);e=1048576;try{e=TOTAL_STACK}catch(c){}STACK_MAX=
STACK_ROOT+e;STATICTOP=alignMemoryPage(STACK_MAX)}function __shutdownRuntime__(){for(;__ATEXIT__.length>0;){var b=__ATEXIT__.pop();if(typeof b==="number")b=FUNCTION_TABLE[b];b()}}function Array_copy(b,f){return HAS_TYPED_ARRAYS?Array.prototype.slice.call(IHEAP.subarray(b,b+f)):IHEAP.slice(b,b+f)}function String_len(b){for(var f=0;IHEAP[b+f];)f++;return f}function String_copy(b,f){var e=String_len(b);f&&e++;var c=Array_copy(b,e);if(f)c[e-1]=0;return c}var PRINTBUFFER="";
function __print__(b){if(b===null){print(PRINTBUFFER);PRINTBUFFER=""}else for(PRINTBUFFER+=b;(b=PRINTBUFFER.indexOf("\n"))!=-1;){print(PRINTBUFFER.substr(0,b));PRINTBUFFER=PRINTBUFFER.substr(b+1)}}function jrint(b,f){if(f)b+=" : ";else{f=b;b=""}print(b+JSON.stringify(f))}function intArrayFromString(b){for(var f=[],e=0;e<b.length;){f.push(b.charCodeAt(e));e+=1}f.push(0);return f}Module.intArrayFromString=intArrayFromString;
function intArrayToString(b){for(var f="",e=0;e<b.length;e++)f+=String.fromCharCode(b[e]);return f}function unSign(b,f){if(b>=0)return b;return f<=32?2*Math.abs(1<<f-1)+b:Math.pow(2,f)+b}function reSign(b,f){if(b<=0)return b;var e=f<=32?Math.abs(1<<f-1):Math.pow(2,f-1);if(b>=e)b=-2*e+b;return b}
var $0___SIZE=128,$1___SIZE=16,$2___SIZE=40,$2___FLATTENER=[0,4,8,12,14,16,20,24,28,32,36],$struct__IO_FILE___SIZE=148,$struct__IO_FILE___FLATTENER=[0,4,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,70,71,72,76,84,88,92,96,100,104,108],$struct__IO_marker___SIZE=12,$struct___dirstream___SIZE=0,$struct___dirstream___FLATTENER=[],$struct___jmp_buf_tag___SIZE=156,$struct___jmp_buf_tag___FLATTENER=[0,24,28],$struct_anon___SIZE=16,$struct_anon___FLATTENER=[0,4,8,10,12],$struct_dircnt___SIZE=8,$struct_dirent___SIZE=
268,$struct_dirent___FLATTENER=[0,4,8,10,11],$struct_dwt_local___SIZE=16,$struct_img_folder___SIZE=12,$struct_img_folder___FLATTENER=[0,4,8,9],$struct_internal_state___SIZE=4,$struct_j2k_prog_order___SIZE=8,$struct_opj_bio___SIZE=20,$struct_opj_cinfo___SIZE=28,$struct_opj_cio___SIZE=28,$struct_opj_codestream_info___SIZE=92,$struct_opj_codestream_info___FLATTENER=[0,8,12,16,20,24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,84,88],$struct_opj_cp___SIZE=116,$struct_opj_cp___FLATTENER=[0,4,8,12,16,17,20,
24,28,32,36,40,44,48,52,56,60,64,68,72,76,80,84,88,92,96,100,104,108,112],$struct_opj_cparameters___SIZE=18692,$struct_opj_cparameters___FLATTENER=[0,4,8,12,16,20,24,28,32,36,40,44,48,4784,4788,4792,5192,5592,5596,5600,5604,5608,5612,5616,5620,5624,5756,5888,9984,14080,14084,18180,18184,18188,18192,18196,18200,18204,18208,18212,18276,18340,18404,18468,18532,18536,18540,18544,18548,18612,18676,18680,18684,18688,18689,18690],$struct_opj_dec_mstabent___SIZE=12,$struct_opj_dparameters___SIZE=8224,$struct_opj_dparameters___FLATTENER=
[0,4,8,4104,8200,8204,8208,8212,8216,8220],$struct_opj_event_mgr___SIZE=12,$struct_opj_image___SIZE=36,$struct_opj_image_comp___SIZE=48,$struct_opj_image_comptparm___SIZE=36,$struct_opj_j2k___SIZE=76,$struct_opj_jp2___SIZE=80,$struct_opj_jp2_box___SIZE=12,$struct_opj_jp2_cdef___SIZE=8,$struct_opj_jp2_cdef_info___SIZE=6,$struct_opj_jp2_cmap_comp___SIZE=4,$struct_opj_jp2_cmap_comp___FLATTENER=[0,2,3],$struct_opj_jp2_color___SIZE=20,$struct_opj_jp2_pclr___SIZE=20,$struct_opj_jp2_pclr___FLATTENER=[0,
4,8,12,16,18],$struct_opj_jpt_msg_header___SIZE=28,$struct_opj_marker_info_t___SIZE=12,$struct_opj_mqc___SIZE=104,$struct_opj_mqc___FLATTENER=[0,4,8,12,16,20,24,100],$struct_opj_mqc_state___SIZE=16,$struct_opj_packet_info___SIZE=20,$struct_opj_pi_comp___SIZE=16,$struct_opj_pi_iterator___SIZE=232,$struct_opj_pi_iterator___FLATTENER=[0,4,8,12,16,20,24,28,32,36,40,44,192,196,200,204,208,212,216,220,224,228],$struct_opj_pi_resolution___SIZE=16,$struct_opj_poc___SIZE=148,$struct_opj_poc___FLATTENER=[0,
4,8,12,16,20,24,28,32,36,40,48,52,56,60,64,68,72,76,80,84,88,92,96,100,104,108,112,116,120,124,128,132,136,140,144],$struct_opj_raw___SIZE=28,$struct_opj_stepsize___SIZE=8,$struct_opj_t1___SIZE=40,$struct_opj_t2___SIZE=12,$struct_opj_tccp___SIZE=1076,$struct_opj_tccp___FLATTENER=[0,4,8,12,16,20,24,28,804,808,812,944],$struct_opj_tcd___SIZE=56,$struct_opj_tcd_band___SIZE=32,$struct_opj_tcd_cblk_dec___SIZE=44,$struct_opj_tcd_cblk_enc___SIZE=48,$struct_opj_tcd_image___SIZE=12,$struct_opj_tcd_layer___SIZE=
20,$struct_opj_tcd_layer___FLATTENER=[0,4,8,16],$struct_opj_tcd_pass___SIZE=20,$struct_opj_tcd_pass___FLATTENER=[0,4,12,16],$struct_opj_tcd_precinct___SIZE=36,$struct_opj_tcd_resolution___SIZE=124,$struct_opj_tcd_seg___SIZE=28,$struct_opj_tcd_tile___SIZE=840,$struct_opj_tcd_tile___FLATTENER=[0,4,8,12,16,20,24,28,36,836],$struct_opj_tcd_tilecomp___SIZE=32,$struct_opj_tcp___SIZE=5588,$struct_opj_tcp___FLATTENER=[0,4,8,12,16,20,420,424,428,5164,5168,5172,5176,5180,5184,5584],$struct_opj_tgt_node___SIZE=
16,$struct_opj_tgt_tree___SIZE=16,$struct_opj_tile_info___SIZE=572,$struct_opj_tile_info___FLATTENER=[0,4,8,12,16,20,152,284,416,548,552,556,564,568],$struct_opj_tp_info___SIZE=20,$struct_option___SIZE=16,$struct_png_color_16_struct___SIZE=10,$struct_png_color_8_struct___SIZE=5,$struct_png_color_struct___SIZE=3,$struct_png_info_struct___SIZE=288,$struct_png_info_struct___FLATTENER=[0,4,8,12,16,20,22,24,25,26,27,28,29,30,31,32,40,44,48,52,56,60,68,76,80,90,100,104,108,112,116,120,124,128,132,136,140,
144,148,152,156,160,164,168,172,176,180,181,184,188,192,196,200,204,208,212,216,220,224,232,240,244,248,252,256,260,264,268,272,276,280,284],$struct_png_row_info_struct___SIZE=12,$struct_png_row_info_struct___FLATTENER=[0,4,8,9,10,11],$struct_png_sPLT_entry_struct___SIZE=10,$struct_png_sPLT_struct___SIZE=16,$struct_png_struct_def___SIZE=744,$struct_png_struct_def___FLATTENER=[0,156,160,164,168,172,176,180,184,188,192,193,196,200,204,208,264,268,272,276,280,284,288,292,296,300,304,308,312,316,320,
324,328,332,336,340,344,348,360,364,368,372,374,376,381,382,383,384,385,386,387,388,389,390,391,392,394,396,400,404,414,424,428,432,436,440,444,448,452,456,460,464,468,472,477,484,488,500,504,508,512,516,520,524,528,532,536,540,544,548,552,556,560,564,568,572,576,580,584,588,592,596,597,600,604,608,612,616,620,624,628,632,636,640,644,646,648,650,652,656,660,661,664,668,672,676,680,684,688,692,696,700,704,708,712,732,736,740],$struct_png_text_struct___SIZE=16,$struct_png_time_struct___SIZE=8,$struct_png_time_struct___FLATTENER=
[0,2,3,4,5,6],$struct_png_unknown_chunk_t___SIZE=20,$struct_png_unknown_chunk_t___FLATTENER=[0,8,12,16],$struct_tga_header___SIZE=20,$struct_tga_header___FLATTENER=[0,1,2,4,6,8,10,12,14,16,18,19],$struct_tiff___SIZE=0,$struct_tiff___FLATTENER=[],$struct_tiff_infoheader___SIZE=20,$struct_tiff_infoheader___FLATTENER=[0,4,8,12,14,16,18],$struct_v4dwt_local___SIZE=16,$struct_z_stream_s___SIZE=56,$union_anon___SIZE=4,_stdout,__str,__str1,__str2,__str4,__str5,__str6,__str7,__str8,__str9,__str10,__str11,
__str12,__str13,__str14,__str15,__str16,__str17,__str18,__str19,__str20,__str21,__str22,__str23,__str24,__str25,__str26,__str27,__str28,__str29,__str30,__str31,__str32,__str33,_stderr,__str34,__str35,__str36,__str37,_get_file_format_extension,__str38,__str39,__str40,__str41,__str42,__str43,__str44,__str45,__str46,__str47,__str48,__str49,__str50,__str51,_get_file_format_format,__str52,__str53,__str54,__str55,__str56,__str57,_parse_cmdline_decoder_long_option,_parse_cmdline_decoder_optlist,__str58,
__str59,__str60,__str61,__str62,__str63,__str64,__str65,__str66,__str67,__str68,__str69,__str70,__str71,__str72,__str73,__str74,__str75,__str76,__str77,__str78,__str79,__str80,__str81,__str82,__str83,__str84,__str185,__str286,_dwt_norms,_dwt_norms_real,__str387,_j2k_prog_order_list,_j2k_dec_mstab,__str488,__str1589,__str2690,__str3791,__str4892,__str593,__str694,__str795,__str896,__str997,_opj_clock_last,__str1198,__str112,__str213,__str314,__str415,__str516,__str617,__str718,__str819,__str920,__str1099,
__str1121,__str12100,__str13101,__str14102,__str1522,__str16103,__str23104,_mct_norms,_mct_norms_real,_mqc_states,__str27105,__str128,__str29106,__str130,__str231,__str332,__str433,_t1_updateflags_mod,_lut_spb,_lut_ctxno_sc,_lut_ctxno_zc,_lut_nmsedec_sig,_lut_nmsedec_sig0,_lut_nmsedec_ref,_lut_nmsedec_ref0,__str41107,__str142,__str344,__str49108,__str150,__str251,__str352,__str453,__str554,__str655,__str756,__str857,__str958,__str1059,__str1160,__str1261,__str1362,__str1463,__str1564,__str1665,__str17109,
__str18110,__str19111,__str20112,__str21113,__str22114,__str2366,__str24115,__str25116,__str126,__str227,__str328,__str429,__str631,__str732,__str833,__str934,__str1035,__str1136,__str1237,__str1338,__str1439,__str1540,__str1641,__str1742,__str1843,__str1944,__str2045,__str2146,__str2247,__str2348,__str2449,__str2550,__str2651,__str2752,__str28117,__str2953,__str30118,__str31119,__str32120,__str33121,__str54122,__str155,__str357,__str458,__str559,__str660,__str761,__str862,__str963,__str1064,__str1165,
__str1266,__str1367,__str1468,__str1569,__str1670,__str1771,__str1973,__str2074,__str2175,__str2276,__str2377,__str2478,__str2579,__str2680,__str2781,__str2882,__str2983,__str3084,__str3185,__str3286,__str3387,__str34123,__str36125,__str3788,__str38126,__str39127,__str40128,__str4189,__str42129,__str43130,__str44131,__str45132,__str46133,__str47134,__str4890,__str4991,__str50135,__str51136,__str52137,__str53138,__str5492,__str55139,__str56140,__str57141,__str58142,__str59143,__str60144,__str61145,
__str62146,__str63147,__str96,__str197,_opterr,_optind,_getopt_place,__str98,_optreset,_optopt,__str199,_optarg,__str2100,_getopt_long_lastidx,_getopt_long_lastofs,__str3101,__str4102,__str5103,__str6104,__str7105,_str,_fprintf=function(){var b=arguments[0],f=Array.prototype.slice.call(arguments,1);f=__formatString.apply(null,f);_STDIO.write(b,f,String_len(f))},__formatString=function(){function b(m){return String.fromCharCode(m)in Runtime.set("f","e","g")}function f(m){var l;if(e){l=b(m)?FHEAP[a]:
IHEAP[a];a+=m==="l".charCodeAt(0)?8:4}else{l=d[a];a++}return l}var e=false,c=arguments[0],a=1;if(c<0){e=true;c=-c;a=arguments[1]}else var d=arguments;for(var g=[],h,i,j;;){h=IHEAP[c];if(h===0)break;i=IHEAP[c+1];if(h=="%".charCodeAt(0)){h=-1;if(i==".".charCodeAt(0)){c++;for(h=0;;){i=IHEAP[c+1];if(!(i>="0".charCodeAt(0)&&i<="9".charCodeAt(0)))break;h*=10;h+=i-"0".charCodeAt(0);c++}i=IHEAP[c+1]}if(i=="l".charCodeAt(0)){c++;i=IHEAP[c+1]}if(b(i))i="f".charCodeAt(0);if(["d","i","u","p","f"].indexOf(String.fromCharCode(i))!=
-1){var k;j=f(i);k=String(+j);k=i=="u".charCodeAt(0)?String(unSign(j,32)):i=="p".charCodeAt(0)?"0x"+j.toString(16):String(+j);if(h>=0)if(b(i)){j=k.indexOf(".");if(j==-1&&i=="f".charCodeAt(0)){j=k.length;k+="."}k+="00000000000";k=k.substr(0,j+1+h)}else for(;k.length<h;)k="0"+k;k.split("").forEach(function(m){g.push(m.charCodeAt(0))})}else if(i=="s".charCodeAt(0))g=g.concat(String_copy(f(i)));else if(i=="c".charCodeAt(0))g=g.concat(f(i));else g.push(i);c+=2}else{g.push(h);c+=1}}return Pointer_make(g.concat(0),
0,ALLOC_STACK)},_STDIO={streams:{},filenames:{},counter:1,SEEK_SET:0,SEEK_CUR:1,SEEK_END:2,init:function(){try{_stdin=Pointer_make([0],null,ALLOC_STATIC);IHEAP[_stdin]=this.prepare("<<stdin>>")}catch(b){}try{_stdout=Pointer_make([0],null,ALLOC_STATIC);IHEAP[_stdout]=this.prepare("<<stdout>>",null,true)}catch(f){}try{_stderr=Pointer_make([0],null,ALLOC_STATIC);IHEAP[_stderr]=this.prepare("<<stderr>>",null,true)}catch(e){}},prepare:function(b,f,e){var c=this.counter++;this.streams[c]={filename:b,data:f?
f:[],position:0,eof:0,error:0,print:e};return this.filenames[b]=c},open:function(b){b=_STDIO.filenames[b];if(!b)return-1;var f=_STDIO.streams[b];f.position=f.error=f.eof=0;return b},read:function(b,f,e){b=_STDIO.streams[b];if(!b)return-1;for(var c=0;c<e;c++){if(b.position>=b.data.length){b.eof=1;return 0}IHEAP[f]=b.data[b.position];b.position++;f++}return e},write:function(b,f,e){b=_STDIO.streams[b];if(!b)return-1;if(b.print)__print__(intArrayToString(Array_copy(f,e)));else for(var c=0;c<e;c++){b.data[b.position]=
IHEAP[f];b.position++;f++}return e}},_opendir=function(){return 0},_strcmp=function(b,f){return _strncmp(b,f,TOTAL_MEMORY)},_strncmp=function(b,f,e){for(var c=0;c<e;){var a=IHEAP[b+c],d=IHEAP[f+c];if(a==d&&a==0)break;if(a==0)return-1;if(d==0)return 1;if(a==d)c++;else return a>d?1:-1}return 0},_strcpy=function(b,f){var e=0;do{IHEAP[b+e]=IHEAP[f+e];e++}while(IHEAP[f+e-1]!=0)},_strrchr=function(b,f){var e=b+Pointer_stringify(b).length;do{if(IHEAP[e]==f)return e;e--}while(e>=b);return 0},_strncasecmp=
function(b,f,e){for(var c=0;c<e;){var a=_tolower(IHEAP[b+c]),d=_tolower(IHEAP[f+c]);if(a==d&&a==0)break;if(a==0)return-1;if(d==0)return 1;if(a==d)c++;else return a>d?1:-1}return 0},_tolower=function(b){if(b>="A".charCodeAt(0)&&b<="Z".charCodeAt(0))return b-"A".charCodeAt(0)+"a".charCodeAt(0);return b},_llvm_memset_p0i8_i32=function(b,f,e){for(var c=0;c<e;c++){IHEAP[b+c]=f;FHEAP[b+c]=f}},_sprintf=function(){var b=arguments[0],f=Array.prototype.slice.call(arguments,1);_strcpy(b,__formatString.apply(null,
f))},_strncpy=function(b,f,e){for(var c=false,a,d=0;d<e;d++){a=c?0:IHEAP[f+d];IHEAP[b+d]=a;c=c||IHEAP[f+d]==0}},_strcat=function(b,f){var e=Pointer_stringify(b).length,c=0;do{IHEAP[b+e+c]=IHEAP[f+c];c++}while(IHEAP[f+c-1]!=0);return b},_llvm_memcpy_p0i8_p0i8_i32=function(b,f,e){for(var c=0;c<e;c++){IHEAP[b+c]=IHEAP[f+c];FHEAP[b+c]=FHEAP[f+c]}},_malloc=function(b){var f=STATICTOP;STATICTOP+=b;STATICTOP=Math.ceil(STATICTOP/4)*4;return f},_strlen=function(b){return String_len(b)},_fopen=function(b,f){b=
Pointer_stringify(b);f=Pointer_stringify(f);return f.indexOf("r")>=0?_STDIO.open(b):f.indexOf("w")>=0?_STDIO.prepare(b):assert(false,"fopen with odd params: "+f)},_fseek=function(b,f,e){b=_STDIO.streams[b];if(e===_STDIO.SEEK_CUR)f+=b.position;else if(e===_STDIO.SEEK_END)f+=b.data.length;b.position=f;return b.eof=0},_ftell=function(b){return _STDIO.streams[b].position},_fread=function(b,f,e,c){for(var a=_STDIO.streams[c],d=0;d<e;d++){if(a.position+f>a.data.length){a.eof=1;return d}_STDIO.read(c,b,
f);b+=f}return e},_fclose=function(){return 0},_free=function(){},_floor=Math.floor,_memalign=function(b,f){var e=Runtime.staticAlloc(f+b);return e+b-e%b},_vsprintf=function(b,f,e){_strcpy(b,__formatString(-f,e))},_calloc=function(b,f){var e=_malloc(b*f);_memset(e,0,b*f);return e},_realloc=function(b,f){if(!f){b&&_free(b);return 0}var e=_malloc(f);if(b){_memcpy(e,b,f);_free(b)}return e},_memcpy=function(b,f,e){for(var c=0;c<e;c++){IHEAP[b+c]=IHEAP[f+c];FHEAP[b+c]=FHEAP[f+c]}},_gettimeofday=function(b){var f=
Runtime.calculateStructAlignment({fields:["i32","i32"]}),e=Date.now();IHEAP[b+f[0]]=Math.floor(e/1E3);IHEAP[b+f[1]]=Math.floor((e-1E3*Math.floor(e/1E3))*1E3);return 0},_printf=function(){__print__(Pointer_stringify(__formatString.apply(null,arguments)))},_llvm_pow_f64=Math.pow,_fwrite=function(b,f,e,c){_STDIO.write(c,b,f*e);return e},__IO_getc=function(){return-1},_memcmp=function(b,f,e){for(var c=0;c<e;c++){var a=IHEAP[b+c],d=IHEAP[f+c];if(a!=d)return a>d?1:-1}return 0},__setjmp=function(){print("WARNING: setjmp() not really implemented, will fail if longjmp() is actually called");
return 0},_strchr=function(b,f){b--;do{b++;var e=IHEAP[b];if(e==f)return b}while(e);return 0},_fputc=function b(f,e){if(!b.ptr)b.ptr=_malloc(1);IHEAP[b.ptr]=f;_STDIO.write(e,b.ptr,1)},_ldexp=function(b,f){return b*Math.pow(2,f)},_puts=function(b){__print__(Pointer_stringify(b)+"\n")},_memset=function(b,f,e){for(var c=0;c<e;c++){IHEAP[b+c]=f;FHEAP[b+c]=f}};
function _decode_help_display(){_fwrite(__str,28,1,IHEAP[_stdout]);_fwrite(__str1,58,1,IHEAP[_stdout]);_fwrite(__str2,46,1,IHEAP[_stdout]);_fputc(10,IHEAP[_stdout]);_fputc(10,IHEAP[_stdout]);_fwrite(__str4,11,1,IHEAP[_stdout]);_fwrite(__str5,28,1,IHEAP[_stdout]);_fwrite(__str6,11,1,IHEAP[_stdout]);_fwrite(__str7,37,1,IHEAP[_stdout]);_fwrite(__str8,56,1,IHEAP[_stdout]);_fwrite(__str9,77,1,IHEAP[_stdout]);_fwrite(__str10,23,1,IHEAP[_stdout]);_fwrite(__str11,60,1,IHEAP[_stdout]);_fwrite(__str12,72,1,
IHEAP[_stdout]);_fwrite(__str13,39,1,IHEAP[_stdout]);_fwrite(__str14,25,1,IHEAP[_stdout]);_fwrite(__str15,13,1,IHEAP[_stdout]);_fwrite(__str16,75,1,IHEAP[_stdout]);_fwrite(__str17,61,1,IHEAP[_stdout]);_fwrite(__str18,71,1,IHEAP[_stdout]);_fwrite(__str19,71,1,IHEAP[_stdout]);_fwrite(__str20,72,1,IHEAP[_stdout]);_fwrite(__str21,77,1,IHEAP[_stdout]);_fwrite(__str22,33,1,IHEAP[_stdout]);_fwrite(__str23,21,1,IHEAP[_stdout]);_fwrite(__str24,69,1,IHEAP[_stdout]);_fwrite(__str25,69,1,IHEAP[_stdout]);_fwrite(__str26,
68,1,IHEAP[_stdout]);_fwrite(__str27,63,1,IHEAP[_stdout]);_fwrite(__str28,42,1,IHEAP[_stdout]);_fwrite(__str29,69,1,IHEAP[_stdout]);_fwrite(__str30,74,1,IHEAP[_stdout]);_fwrite(__str31,17,1,IHEAP[_stdout]);_fwrite(__str32,7,1,IHEAP[_stdout]);_fwrite(__str33,52,1,IHEAP[_stdout]);_fputc(10,IHEAP[_stdout]);_fputc(10,IHEAP[_stdout])}_decode_help_display.__index__=Runtime.getFunctionIndex(_decode_help_display,"_decode_help_display");
function _get_num_images(b){var f=null,e,c;c=0;e=_opendir(b);if(e!=0){b=_readdir(e);if(b!=0){c=c;for(f=1;;){d=f==1?c:d;g=f==1?b:g;if(_strcmp(__str35,g+11)==0)f=2;else{var a=_strcmp(__str36,g+11);g=d+1;a=a==0?d:g;f=3}var d=f==2?d:a,g=_readdir(e);if(g!=0)f=5;else break}c=d}e=c}else{_fprintf(IHEAP[_stderr],__str34,b);e=0}return e}_get_num_images.__index__=Runtime.getFunctionIndex(_get_num_images,"_get_num_images");
function _load_images(b,f){var e=null,c;c=_opendir(f);e=IHEAP[_stderr];if(c!=0){_fwrite(__str37,27,1,e);var a=_readdir(c);if(a!=0){var d=b+4;e=1;a:for(;;){i=e==1?0:i;j=e==1?a:j;var g=_strcmp(__str35,j+11)==0;b:do if(g)e=2;else{if(_strcmp(__str36,j+11)==0){e=3;break b}_strcpy(IHEAP[IHEAP[d]+4*i],j+11);var h=i+1;e=5}while(0);var i=e==5?h:e==3?i:i,j=_readdir(c);if(j!=0)e=4;else break a}}c=0}else{_fprintf(e,__str34,f);c=1}return c}_load_images.__index__=Runtime.getFunctionIndex(_load_images,"_load_images");
function _get_file_format(b){var f,e=null;b=_strrchr(b,46);var c=b==0;a:do{if(!c){b+=1;if(b!=0){var a=b;for(e=1;;){f=e==6?i:0;var d=0+f,g=_get_file_format_extension+d*4,h=1+f;if(!((e==6?h:0)<14)){f=4;break}if(_strncasecmp(a,IHEAP[g],3)==0){f=5;break}var i=f+1;e=6;f=2}if(f!=4)if(f==5){e=IHEAP[_get_file_format_format+d*4];break a}}}e=-1}while(0);return e}_get_file_format.__index__=Runtime.getFunctionIndex(_get_file_format,"_get_file_format");
function _get_next_file(b,f,e,c){var a=STACKTOP;STACKTOP+=20480;_memset(a,0,20480);var d=null;d=a+4096;var g=a+8192,h=a+12288,i=a+16384;_llvm_memset_p0i8_i32(i,0,4096,1,0);_strcpy(a,IHEAP[IHEAP[f+4]+4*b]);_fprintf(IHEAP[_stderr],__str52,b,a);b=_get_file_format(a);IHEAP[c+8200]=b;if(IHEAP[c+8200]==-1)e=1;else{_sprintf(d,__str53,IHEAP[e],a);_strncpy(c+8,d,4096);b=_strtok(a,__str35);_strcpy(h,b);b=_strtok(0,__str35);if(b!=0)for(d=1;;){j=d==1?b:j;_strcat(h,i);_sprintf(i,__str54,j);var j=_strtok(0,__str35);
if(j!=0)d=2;else break}if(IHEAP[e+9]==1){_sprintf(g,__str55,IHEAP[e],h,IHEAP[e+4]);_strncpy(c+4104,g,4096)}e=0}e=e;STACKTOP=a;return e}_get_next_file.__index__=Runtime.getFunctionIndex(_get_next_file,"_get_next_file");
function _parse_cmdline_decoder(b,f,e,c,a){var d=STACKTOP;STACKTOP+=82;_memset(d,0,82);var g,h,i=d+32;_llvm_memcpy_p0i8_p0i8_i32(d,_parse_cmdline_decoder_long_option,32,4,0);IHEAP[c+9]=0;var j=e+8200,k=e+8200,m=e+8,l=e+8204,n=e+8204,o=e+4104,p=c+9,r=e+8204,q=e+8204,u=c+4,s=c+4,t=c+4,v=c+4,y=c+4,x=c+4,w=c+4,C=e+4,z=c+8;a:for(;;){var A=_getopt_long(b,f,_parse_cmdline_decoder_optlist,d,32);if(A==-1){g=21;break a}else if(A==105)g=22;else if(A==111)g=23;else if(A==79)g=24;else if(A==114)g=12;else if(A==
108)g=13;else if(A==104){g=25;break a}else g=A==121?14:A==120?15:16;if(g==16){_fprintf(IHEAP[_stderr],__str61,A,IHEAP[_optarg]);g=1}else if(g==22){var B=IHEAP[_optarg];g=_get_file_format(B);IHEAP[j]=g;g=IHEAP[k];if(g!=0)if(g!=1)if(g!=2){g=26;break a}_strncpy(m,B,4095);g=1}else if(g==23){var D=IHEAP[_optarg];g=_get_file_format(D);IHEAP[l]=g;g=IHEAP[n];if(g!=11)if(g!=10)if(g!=12)if(g!=14)if(g!=15)if(g!=16)if(g!=17){g=27;break a}_strncpy(o,D,4095);g=1}else if(g==24){_sprintf(i,__str54,IHEAP[_optarg]);
IHEAP[p]=1;g=_get_file_format(i);IHEAP[r]=g;g=IHEAP[q];if(g==11)g=5;else if(g==10)g=6;else if(g==12)g=7;else if(g==14)g=8;else if(g==15)g=9;else if(g==16)g=10;else if(g==17)g=11;else{g=28;break a}if(g==5){IHEAP[u]=__str38;g=1}else if(g==6){IHEAP[s]=__str41;g=1}else if(g==7){IHEAP[t]=__str42;g=1}else if(g==8){IHEAP[v]=__str43;g=1}else if(g==9){IHEAP[y]=__str44;g=1}else if(g==10){IHEAP[x]=__str44;g=1}else if(g==11){IHEAP[w]=__str46;g=1}}else if(g==12){___01__isoc99_sscanf_(IHEAP[_optarg],__str60,e);
g=1}else if(g==13){___01__isoc99_sscanf_(IHEAP[_optarg],__str60,C);g=1}else if(g==14){g=_strlen(IHEAP[_optarg])+1;g=_malloc(g);IHEAP[c]=g;_strcpy(IHEAP[c],IHEAP[_optarg]);g=IHEAP[z]=1}else if(g==15){_strncpy(a,IHEAP[_optarg],4096);g=1}}a:do if(g==21){b=IHEAP[c+8]==1;a=IHEAP[e+8]==0;b:do{if(b)if(a)if(IHEAP[c+9]==0){_fwrite(__str63,62,1,IHEAP[_stderr]);_fwrite(__str64,82,1,IHEAP[_stderr])}else{if(IHEAP[e+4104]==0){g=18;break b}_fwrite(__str65,57,1,IHEAP[_stderr])}else _fwrite(__str62,57,1,IHEAP[_stderr]);
else{if(!a)if(IHEAP[e+4104]!=0){g=18;break b}_fprintf(IHEAP[_stderr],__str66,IHEAP[f]);_fprintf(IHEAP[_stderr],__str67,IHEAP[f])}h=1;break a}while(0);h=0}else if(g==25){_decode_help_display();h=1}else if(g==26){b=B;_fprintf(IHEAP[_stderr],__str58,b);h=1}else if(g==27){b=D;_fprintf(IHEAP[_stderr],__str59,b);h=1}else if(g==28){_fprintf(IHEAP[_stderr],__str59,i);h=1}while(0);f=h;STACKTOP=d;return f}_parse_cmdline_decoder.__index__=Runtime.getFunctionIndex(_parse_cmdline_decoder,"_parse_cmdline_decoder");
function _error_callback(b,f){_fprintf(f,__str68,b)}_error_callback.__index__=Runtime.getFunctionIndex(_error_callback,"_error_callback");function _warning_callback(b,f){_fprintf(f,__str69,b)}_warning_callback.__index__=Runtime.getFunctionIndex(_warning_callback,"_warning_callback");function _info_callback(b){_fprintf(IHEAP[_stdout],__str70,b)}_info_callback.__index__=Runtime.getFunctionIndex(_info_callback,"_info_callback");
function _main(b,f){var e=STACKTOP;STACKTOP+=12436;_memset(e,0,12436);var c,a=null,d,g=e+8224,h=e+8236,i,j,k,m,l,n=e+8248,o=e+8340;l=m=d=0;_llvm_memset_p0i8_i32(h,0,12,1,0);IHEAP[h]=_error_callback.__index__;IHEAP[h+4]=_warning_callback.__index__;IHEAP[h+8]=_info_callback.__index__;if(e!=0){_llvm_memset_p0i8_i32(e,0,8224,1,0);IHEAP[e+4]=0;IHEAP[e]=0;IHEAP[e+8220]=0;IHEAP[e+8200]=-1;IHEAP[e+8204]=-1}IHEAP[o]=0;_llvm_memset_p0i8_i32(g,0,12,1,0);var p=_parse_cmdline_decoder(b,f,e,g,o)==1;a:do if(p)d=
1;else{var r=IHEAP[g+8]==1;b:do if(r){j=_get_num_images(IHEAP[g]);k=_malloc(8);c=k!=0;c:do if(c){r=_malloc(j*4096);IHEAP[k]=r;r=_malloc(j*4);IHEAP[k+4]=r;if(IHEAP[k]!=0){if(!(0<j))break c;r=k;var q=k+4,u=j;u=(u>1?u:1)-0;for(a=3;;){s=a==3?0:s;IHEAP[IHEAP[q]+4*(0+s)]=IHEAP[r]+(0+s*4096);var s=s+1;if(s!=u)a=5;else break}}else{d=1;break a}}while(0);if(_load_images(k,IHEAP[g])!=1){if(j!=0){c=9;break b}_fwrite(__str71,16,1,IHEAP[_stdout])}d=1;break a}else j=1;while(0);j=j;r=g+8;q=k;u=e+8;var t=e+8200,v=
o,y=o,x=o,w=e+8204,C=e+4104,z=o,A=e+4104,B=e+4104,D=e+4104,J=e+4104,E=e+4104,N=e+4104,Q=e+4104,S=e+4104,P=e+4104,G=e+4104,F=e+4104,L=e+4104,K=e+4104,H=e+4104,M=o,I=o,O=o,R=o,T=o,V=o,ba=l;a=9;b:for(;;){var fa=a==16?oa:ba,ca=a==16?pa:0;if(!(ca<j)){c=13;break b}i=0;_fputc(10,IHEAP[_stderr]);var U=IHEAP[r]==1;c:do if(U){if(_get_next_file(ca,q,g,e)==0){c=15;break c}_fwrite(__str72,17,1,IHEAP[_stderr]);a=14;c=16;break c}else c=15;while(0);c:do if(c==15){c=_fopen(u,__str73);if(c==0){c=18;break b}_fseek(c,
0,2);U=_ftell(c);_fseek(c,0,0);var $=_malloc(U);_fread($,1,U,c);_fclose(c);c=IHEAP[t];c=c==0?85:c==1?86:c==2?87:72;d:do if(c==72){_fwrite(__str77,16,1,IHEAP[_stderr]);a=72;break c}else if(c==85){var Y=m=_opj_create_decompress(0);i=IHEAP[_stderr];if(Y!=0){IHEAP[Y]=h;IHEAP[Y+4]=i}_opj_setup_decoder(m,e);Y=_opj_cio_open(m,$,U);i=m;if(IHEAP[v]!=0){var Z=_opj_decode_with_info(i,Y,n);i=Z;a=22}else{var W=_opj_decode_with_info(i,Y,0);i=W;a=24}if((a==24?W:Z)==0){c=26;break b}if(Y!=0){IHEAP[Y+4]==2&&_free(IHEAP[Y+
8]);_free(Y)}if(IHEAP[y]==0){a=33;break d}if((_write_index_file(n,x)&255)==0){a=34;break d}_fwrite(__str76,28,1,IHEAP[_stderr]);a=36}else if(c==86){var X=m=_opj_create_decompress(2);i=IHEAP[_stderr];if(X!=0){IHEAP[X]=h;IHEAP[X+4]=i}_opj_setup_decoder(m,e);X=_opj_cio_open(m,$,U);i=m;if(IHEAP[M]!=0){var aa=_opj_decode_with_info(i,X,n);i=aa;a=41}else{var ka=_opj_decode_with_info(i,X,0);i=ka;a=43}if((a==43?ka:aa)==0){c=45;break b}if(X!=0){IHEAP[X+4]==2&&_free(IHEAP[X+8]);_free(X)}if(IHEAP[I]==0){a=52;
break d}if((_write_index_file(n,O)&255)==0){a=53;break d}_fwrite(__str76,28,1,IHEAP[_stderr]);a=54}else if(c==87){var ga=m=_opj_create_decompress(1);i=IHEAP[_stderr];if(ga!=0){IHEAP[ga]=h;IHEAP[ga+4]=i}_opj_setup_decoder(m,e);ga=_opj_cio_open(m,$,U);i=m;if(IHEAP[R]!=0){var ja=_opj_decode_with_info(i,ga,n);i=ja;a=58}else{var ia=_opj_decode_with_info(i,ga,0);i=ia;a=60}if((a==60?ia:ja)==0){c=62;break b}if(ga!=0){IHEAP[ga+4]==2&&_free(IHEAP[ga+8]);_free(ga)}if(IHEAP[T]==0){a=69;break d}if((_write_index_file(n,
V)&255)==0){a=70;break d}_fwrite(__str76,28,1,IHEAP[_stderr]);a=71}while(0);var ea=a==69?ga:a==71?ga:a==70?ga:a==52?X:a==54?X:a==53?X:a==33?Y:a==36?Y:Y;_free($);IHEAP[i+20]==3&&_color_sycc_to_rgb(i);if(IHEAP[i+28]!=0){_free(IHEAP[i+28]);IHEAP[i+28]=0;IHEAP[i+32]=0}c=IHEAP[w];c=c==10?97:c==11?98:c==12?99:c==14?100:c==15?101:c==16?102:c==17?103:104;if(c==104)_fprintf(IHEAP[_stderr],__str78,C);else if(c==97){U=_imagetopnm(i,A)!=0;$=IHEAP[_stdout];U?_fprintf($,__str78,B):_fprintf($,__str79,B)}else if(c==
98){U=_imagetopgx(i,D)!=0;$=IHEAP[_stdout];U?_fprintf($,__str78,J):_fprintf($,__str79,J)}else if(c==99){U=_imagetobmp(i,E)!=0;$=IHEAP[_stdout];U?_fprintf($,__str78,N):_fprintf($,__str79,N)}else if(c==100){U=_imagetotif(i,Q)!=0;$=IHEAP[_stdout];U?_fprintf($,__str78,S):_fprintf($,__str79,S)}else if(c==101){U=_imagetoraw(i,P)!=0;$=IHEAP[_stdout];U?_fprintf($,__str80,G):_fprintf($,__str81,G)}else if(c==102){U=_imagetotga(i,F)!=0;$=IHEAP[_stdout];U?_fprintf($,__str82,L):_fprintf($,__str81,L)}else if(c==
103){U=_imagetopng(i,K)!=0;$=IHEAP[_stdout];U?_fprintf($,__str83,H):_fprintf($,__str81,H)}U=m!=0;d:do if(U){$=m;if($==0){c=78;break d}c=IHEAP[$+12];c=c==0?105:c==1?105:c==2?106:80;if(c==105)_j2k_destroy_decompress(IHEAP[$+16]);else c==106&&_jp2_destroy_decompress(IHEAP[$+20]);_free($)}while(0);IHEAP[z]!=0&&_opj_destroy_cstr_info(n);_opj_image_destroy(i);a=83}while(0);var oa=a==83?ea:a==72?fa:fa,pa=ca+1;a=16;c=11}if(c==13){l=fa;d=0}else if(c==18){l=fa;_fprintf(IHEAP[_stderr],__str74,e+8);d=1}else if(c==
26){l=Y;_fwrite(__str75,47,1,IHEAP[_stderr]);d=m;if(d!=0){c=IHEAP[d+12];c=c==0?88:c==1?88:c==2?89:90;if(c==88)_j2k_destroy_decompress(IHEAP[d+16]);else c==89&&_jp2_destroy_decompress(IHEAP[d+20]);_free(d)}d=j=l;if(j!=0){IHEAP[d+4]==2&&_free(IHEAP[d+8]);_free(d)}d=1}else if(c==45){l=X;_fwrite(__str75,47,1,IHEAP[_stderr]);d=m;if(d!=0){c=IHEAP[d+12];c=c==0?91:c==1?91:c==2?92:93;if(c==91)_j2k_destroy_decompress(IHEAP[d+16]);else c==92&&_jp2_destroy_decompress(IHEAP[d+20]);_free(d)}d=j=l;if(j!=0){IHEAP[d+
4]==2&&_free(IHEAP[d+8]);_free(d)}d=1}else if(c==62){l=ga;_fwrite(__str75,47,1,IHEAP[_stderr]);d=m;if(d!=0){c=IHEAP[d+12];c=c==0?94:c==1?94:c==2?95:96;if(c==94)_j2k_destroy_decompress(IHEAP[d+16]);else c==95&&_jp2_destroy_decompress(IHEAP[d+20]);_free(d)}d=j=l;if(j!=0){IHEAP[d+4]==2&&_free(IHEAP[d+8]);_free(d)}d=1}}while(0);g=d;STACKTOP=e;return g}_main.__index__=Runtime.getFunctionIndex(_main,"_main");function _bio_create(){return _malloc(20)}
_bio_create.__index__=Runtime.getFunctionIndex(_bio_create,"_bio_create");function _bio_destroy(b){b!=0&&_free(b)}_bio_destroy.__index__=Runtime.getFunctionIndex(_bio_destroy,"_bio_destroy");function _bio_numbytes(b){return IHEAP[b+8]-IHEAP[b]}_bio_numbytes.__index__=Runtime.getFunctionIndex(_bio_numbytes,"_bio_numbytes");function _bio_init_enc(b,f,e){IHEAP[b]=f;IHEAP[b+4]=f+e;IHEAP[b+8]=f;IHEAP[b+12]=0;IHEAP[b+16]=8}_bio_init_enc.__index__=Runtime.getFunctionIndex(_bio_init_enc,"_bio_init_enc");
function _bio_init_dec(b,f,e){IHEAP[b]=f;IHEAP[b+4]=f+e;IHEAP[b+8]=f;IHEAP[b+12]=0;IHEAP[b+16]=0}_bio_init_dec.__index__=Runtime.getFunctionIndex(_bio_init_dec,"_bio_init_dec");
function _bio_write(b,f,e){var c=null;e=e-1;if(e>=0){var a=0-e;a=e+(a>0?a:0)+1;for(c=0;;){i=c==0?0:i;c=f>>e+i*-1&1;if(IHEAP[b+16]==0){IHEAP[b+12]=IHEAP[b+12]<<8&65535;IHEAP[b+16]=IHEAP[b+12]==65280?7:8;if(!(IHEAP[b+8]>=IHEAP[b+4])){var d=IHEAP[b+12]>>>8&255,g=b+8,h=IHEAP[g];IHEAP[g]=h+1;IHEAP[h]=d}}IHEAP[b+16]+=-1;IHEAP[b+12]|=c<<IHEAP[b+16];var i=i+1;if(i!=a)c=5;else break}}}_bio_write.__index__=Runtime.getFunctionIndex(_bio_write,"_bio_write");
function _bio_read(b,f){var e=null,c;c=0;var a=f-1;if(a>=0){c=c;var d=0-a;d=a+(d>0?d:0)+1;for(e=0;;){j=e==0?0:j;i=e==0?c:i;e=a+j*-1;if(IHEAP[b+16]==0){IHEAP[b+12]=IHEAP[b+12]<<8&65535;IHEAP[b+16]=IHEAP[b+12]==65280?7:8;if(!(IHEAP[b+8]>=IHEAP[b+4])){var g=b+8,h=IHEAP[g];IHEAP[g]=h+1;IHEAP[b+12]|=IHEAP[h]}}IHEAP[b+16]+=-1;var i=((IHEAP[b+12]>>>IHEAP[b+16]&1)<<e)+i,j=j+1;if(j!=d)e=5;else break}c=i}return c}_bio_read.__index__=Runtime.getFunctionIndex(_bio_read,"_bio_read");
function _bio_flush(b){var f,e;IHEAP[b+16]=0;IHEAP[b+12]=IHEAP[b+12]<<8&65535;IHEAP[b+16]=IHEAP[b+12]==65280?7:8;var c=IHEAP[b+8]>=IHEAP[b+4];a:do if(c)e=1;else{e=IHEAP[b+12]>>>8&255;f=b+8;var a=IHEAP[f];IHEAP[f]=a+1;IHEAP[a]=e;if(IHEAP[b+16]==7){IHEAP[b+16]=0;f=b;IHEAP[f+12]=IHEAP[f+12]<<8&65535;IHEAP[f+16]=IHEAP[f+12]==65280?7:8;if(IHEAP[f+8]>=IHEAP[f+4]){e=1;break a}else{e=IHEAP[f+12]>>>8&255;f=f+8;a=IHEAP[f];IHEAP[f]=a+1;IHEAP[a]=e}}e=0}while(0);return e}
_bio_flush.__index__=Runtime.getFunctionIndex(_bio_flush,"_bio_flush");function _bio_inalign(b){var f,e;IHEAP[b+16]=0;var c=(IHEAP[b+12]&255)==255;a:do if(c){f=b;IHEAP[f+12]=IHEAP[f+12]<<8&65535;IHEAP[f+16]=IHEAP[f+12]==65280?7:8;if(IHEAP[f+8]>=IHEAP[f+4]){e=1;f=0}else{c=f+8;var a=IHEAP[c];IHEAP[c]=a+1;IHEAP[f+12]|=IHEAP[a];IHEAP[b+16]=0;f=1}break a}else f=1;while(0);if(f==1)e=0;return e}_bio_inalign.__index__=Runtime.getFunctionIndex(_bio_inalign,"_bio_inalign");
function _opj_cio_open(b,f,e){var c,a,d,g;d=0;g=_malloc(28);var h=g!=0;a:do if(h){IHEAP[g]=b;var i=f!=0;b:do if(i){if(e!=0){IHEAP[g+4]=1;IHEAP[g+8]=f;IHEAP[g+12]=e;c=1}else c=f!=0?2:3;break b}else c=3;while(0);b:do if(c==3){if(e!=0){c=2;break b}if(b==0){c=2;break b}IHEAP[g+4]=2;c=IHEAP[b+12];c=c==0?9:c==2?10:11;if(c==11){_free(g);a=0;break a}else if(c==9)d=IHEAP[IHEAP[b+16]+64];else if(c==10)d=IHEAP[IHEAP[IHEAP[b+20]+4]+64];IHEAP[g+12]=Math.floor(0.1625*IHEAP[d+8]+2E3);c=_malloc(IHEAP[g+12]);IHEAP[g+
8]=c;if(IHEAP[g+8]!=0){c=1;break b}_opj_event_msg(IHEAP[g],1,__str84);_free(g);a=0;break a}while(0);if(c==1){IHEAP[g+16]=IHEAP[g+8];IHEAP[g+20]=IHEAP[g+8]+IHEAP[g+12];IHEAP[g+24]=IHEAP[g+8];a=g}else if(c==2){_free(g);a=0}}else a=0;while(0);return a}_opj_cio_open.__index__=Runtime.getFunctionIndex(_opj_cio_open,"_opj_cio_open");function _opj_cio_close(b){if(b!=0){IHEAP[b+4]==2&&_free(IHEAP[b+8]);_free(b)}}_opj_cio_close.__index__=Runtime.getFunctionIndex(_opj_cio_close,"_opj_cio_close");
function _cio_tell(b){return IHEAP[b+24]-IHEAP[b+16]}_cio_tell.__index__=Runtime.getFunctionIndex(_cio_tell,"_cio_tell");function _cio_seek(b,f){IHEAP[b+24]=IHEAP[b+16]+f}_cio_seek.__index__=Runtime.getFunctionIndex(_cio_seek,"_cio_seek");function _cio_numbytesleft(b){return IHEAP[b+20]-IHEAP[b+24]}_cio_numbytesleft.__index__=Runtime.getFunctionIndex(_cio_numbytesleft,"_cio_numbytesleft");function _cio_getbp(b){return IHEAP[b+24]}_cio_getbp.__index__=Runtime.getFunctionIndex(_cio_getbp,"_cio_getbp");
function _cio_byteout(b,f){var e;if(IHEAP[b+24]>=IHEAP[b+20]){_opj_event_msg(IHEAP[b],1,__str185);e=0}else{e=b+24;var c=IHEAP[e];IHEAP[e]=c+1;IHEAP[c]=f;e=1}return e}_cio_byteout.__index__=Runtime.getFunctionIndex(_cio_byteout,"_cio_byteout");function _cio_bytein(b){if(IHEAP[b+24]>=IHEAP[b+20]){_opj_event_msg(IHEAP[b],1,__str286,Pointer_make([IHEAP[b+16],0,0,0,IHEAP[b+24],0,0,0,IHEAP[b+20],0,0,0],0,ALLOC_STACK));b=0}else{b=b+24;var f=IHEAP[b];IHEAP[b]=f+1;b=IHEAP[f]}return b}
_cio_bytein.__index__=Runtime.getFunctionIndex(_cio_bytein,"_cio_bytein");function _cio_write(b,f,e){var c,a=null,d,g=e-1,h=g*8,i=g+-1;for(a=0;;){c=a==5?k:0;k=h+c*-8;var j=i+c*-1;if(!((a==5?j:g)>=0)){c=3;break}a=f>>>k&255&255;if(IHEAP[b+24]>=IHEAP[b+20]){c=4;break}k=b+24;j=IHEAP[k];IHEAP[k]=j+1;IHEAP[j]=a;var k=c+1;a=5;c=1}if(c==3)d=e;else if(c==4){_opj_event_msg(IHEAP[b],1,__str185);d=0}return d}_cio_write.__index__=Runtime.getFunctionIndex(_cio_write,"_cio_write");
function _cio_read(b,f){var e=null,c;c=0;var a=f-1;if(a>=0){c=c;var d=0-a;d=a+(d>0?d:0)+1;a=a*8;for(e=0;;){j=e==0?0:j;i=e==0?c:i;var g=a+j*-8;if(IHEAP[b+24]>=IHEAP[b+20]){_opj_event_msg(IHEAP[b],1,__str286,Pointer_make([IHEAP[b+16],0,0,0,IHEAP[b+24],0,0,0,IHEAP[b+20],0,0,0],0,ALLOC_STACK));e=2}else{var h=b+24;e=IHEAP[h];IHEAP[h]=e+1;h=IHEAP[e];e=4}var i=((e==2?0:h)<<g)+i,j=j+1;if(j!=d)e=5;else break}c=i}return c}_cio_read.__index__=Runtime.getFunctionIndex(_cio_read,"_cio_read");
function _cio_skip(b,f){IHEAP[b+24]+=f}_cio_skip.__index__=Runtime.getFunctionIndex(_cio_skip,"_cio_skip");
function _dwt_encode(b){var f=null,e,c,a;c=IHEAP[b+8]-IHEAP[b];a=IHEAP[b+16]-1;e=IHEAP[b+24];if(0<a){var d=b+20,g=b+20,h=b+20,i=b+20,j=b+20,k=b+20,m=b+20,l=b+20,n=b+20;b=b+20;var o=(a>1?a:1)-0,p=a-0,r=a-0,q=a-0,u=a-0,s=a-0,t=a+-1-0,v=a-0,y=a-0,x=a-0;a=a-0;f=0;a:for(;;){V=f==0?0:V;f=V*-1;var w=IHEAP[IHEAP[d]+124*(p+f)+8],C=IHEAP[IHEAP[g]+124*(r+f)],z=w-C,A=IHEAP[IHEAP[h]+124*(q+f)+12],B=IHEAP[IHEAP[i]+124*(u+f)+4],D=A-B,J=IHEAP[IHEAP[j]+124*(s+f)+-116]-IHEAP[IHEAP[k]+124*(t+f)],E=IHEAP[IHEAP[m]+124*
(v+f)+-112]-IHEAP[IHEAP[l]+124*(y+f)+-120],N=IHEAP[IHEAP[n]+124*(x+f)]%2,Q=IHEAP[IHEAP[b]+124*(a+f)+4]%2,S=D-E,P=_malloc(D*4),G=P;if(0<z)if(0<D){var F=A-B,L=w-C;f=2;b:for(;;){M=f==2?0:M;var K=e+4*M;for(f=3;;){H=f==3?0:H;IHEAP[P+H*4]=IHEAP[e+4*(M+c*H)];var H=H+1;if(H!=F)f=4;else break}_dwt_encode_1(G,S,E,Q);_dwt_deinterleave_v(G,K,S,E,c,Q);var M=M+1;if(M!=L)f=5;else break b}}else{P=w-C;for(f=8;;){I=f==8?0:I;f=e+4*I;_dwt_encode_1(G,S,E,Q);_dwt_deinterleave_v(G,f,S,E,c,Q);var I=I+1;if(I!=P)f=9;else break}}_free(G);
E=z-J;Q=S=_malloc(z*4);if(0<D)if(0<z){w=w-C;A=A-B;f=12;b:for(;;){R=f==12?0:R;B=c*R;C=e+4*B;for(f=13;;){O=f==13?0:O;IHEAP[S+O*4]=IHEAP[e+4*(B+O)];var O=O+1;if(O!=w)f=14;else break}_dwt_encode_1(Q,E,J,N);_dwt_deinterleave_h(Q,C,E,J,N);var R=R+1;if(R!=A)f=15;else break b}}else{A=A-B;for(f=18;;){T=f==18?0:T;f=e+4*c*T;_dwt_encode_1(Q,E,J,N);_dwt_deinterleave_h(Q,f,E,J,N);var T=T+1;if(T!=A)f=19;else break}}_free(Q);var V=V+1;if(V!=o)f=23;else break a}}}
_dwt_encode.__index__=Runtime.getFunctionIndex(_dwt_encode,"_dwt_encode");
function _dwt_encode_1(b,f,e,c){var a=null,d;c=c!=0;a:do if(c){a=e!=0;b:do if(!a){if(f!=1)break b;IHEAP[b]*=2;return}while(0);d=0;var g=d<f;b:do if(g){var h=f,i=e,j=(e-1)*2+1,k=e,m=(e-1)*2+1,l=d;for(a=26;;){if((a==26?l:s)<0){var n=IHEAP[b+4];a=28}else if(d>=k){var o=IHEAP[b+4*m];a=30}else{var p=IHEAP[b+4*(d*2+1)];a=31}s=a==28?n:a==30?o:p;if(d-1<0){var r=IHEAP[b+4];a=32}else if(d-1>=i){var q=IHEAP[b+4*j];a=34}else{var u=IHEAP[b+4*((d-1)*2+1)];a=35}IHEAP[b+4*d*2]-=(a==32?r:a==34?q:u)+s>>1;d+=1;var s=
d;if(s<h)a=36;else break b}}while(0);d=0;if(!(d<e))break a;g=e;h=f;i=(f-1)*2;j=f;k=(f-1)*2;m=d;for(a=38;;){if((a==38?m:z)<0){var t=IHEAP[b];a=40}else if(d>=j){var v=IHEAP[b+4*k];a=42}else{var y=IHEAP[b+4*d*2];a=43}z=a==40?t:a==42?v:y;if(d+1<0){var x=IHEAP[b];a=44}else if(d+1>=h){var w=IHEAP[b+4*i];a=46}else{var C=IHEAP[b+4*(d+1)*2];a=47}IHEAP[b+4*(d*2+1)]+=z+2+(a==44?x:a==46?w:C)>>2;d+=1;var z=d;if(z<g)a=48;else break a}}else{if(!(f>0))if(!(e>1))break a;d=0;g=d<f;b:do if(g){h=f;i=e;j=(e-1)*2;k=e;
m=(e-1)*2;l=d;for(a=2;;){if((a==2?l:Q)<0){var A=IHEAP[b];a=4}else if(d>=k){var B=IHEAP[b+4*m];a=6}else{var D=IHEAP[b+4*d*2];a=7}Q=a==4?A:a==6?B:D;if(d+1<0){var J=IHEAP[b];a=8}else if(d+1>=i){var E=IHEAP[b+4*j];a=10}else{var N=IHEAP[b+4*(d+1)*2];a=11}IHEAP[b+4*(d*2+1)]-=(a==8?J:a==10?E:N)+Q>>1;d+=1;var Q=d;if(Q<h)a=12;else break b}}while(0);d=0;if(!(d<e))break a;g=e;h=f;i=(f-1)*2+1;j=f;for(k=(f-1)*2+1;;){if(d-1<0){var S=IHEAP[b+4];a=16}else if(d-1>=j){var P=IHEAP[b+4*k];a=18}else{var G=IHEAP[b+4*((d-
1)*2+1)];a=19}m=a==16?S:a==18?P:G;if(d<0){var F=IHEAP[b+4];a=20}else if(d>=h){var L=IHEAP[b+4*i];a=22}else{var K=IHEAP[b+4*(d*2+1)];a=23}IHEAP[b+4*d*2]+=m+2+(a==20?F:a==22?L:K)>>2;d+=1;if(!(d<g))break a}}while(0)}_dwt_encode_1.__index__=Runtime.getFunctionIndex(_dwt_encode_1,"_dwt_encode_1");
function _dwt_deinterleave_v(b,f,e,c,a,d){var g=null;g=0;if(g<c){g=g;var h=g+1;h=(c>h?c:h)-g;var i=g*a,j=d+g*2;for(g=0;;){g=g==0?0:k;IHEAP[f+4*(i+a*g)]=IHEAP[b+4*(j+g*2)];var k=g+1;if(k!=h)g=1;else break}}g=0;if(g<e){g=g;k=g+1;e=(e>k?e:k)-g;c=a*(g+c);d=g*2+1-d;for(g=4;;){m=g==4?0:m;IHEAP[f+4*(c+a*m)]=IHEAP[b+4*(d+m*2)];var m=m+1;if(m!=e)g=5;else break}}}_dwt_deinterleave_v.__index__=Runtime.getFunctionIndex(_dwt_deinterleave_v,"_dwt_deinterleave_v");
function _dwt_deinterleave_h(b,f,e,c,a){var d=null;d=0;if(d<c){var g=d;d=g+1;var h=(c>d?c:d)-g,i=a+g*2;for(d=0;;){d=d==0?0:j;IHEAP[f+4*(g+d)]=IHEAP[b+4*(i+d*2)];var j=d+1;if(j!=h)d=1;else break}}d=0;if(d<e){d=d;g=d+1;e=(e>g?e:g)-d;c=d+c;a=d*2+1-a;for(d=4;;){k=d==4?0:k;IHEAP[f+4*(c+k)]=IHEAP[b+4*(a+k*2)];var k=k+1;if(k!=e)d=5;else break}}}_dwt_deinterleave_h.__index__=Runtime.getFunctionIndex(_dwt_deinterleave_h,"_dwt_deinterleave_h");
function _dwt_decode(b,f){var e=STACKTOP;STACKTOP+=32;_memset(e,0,32);var c,a=null,d,g,h,i=e+16,j,k,m,l;g=f;h=_dwt_decode_1.__index__;j=IHEAP[b+20];k=IHEAP[j+8]-IHEAP[j];m=IHEAP[j+12]-IHEAP[j+4];l=IHEAP[b+8]-IHEAP[b];a=g;d=1;var n=a+-1;a=n;if(n!=0){d=d;n=a;for(a=0;;){r=a==0?0:r;p=a==0?d:p;a=r+1;var o=IHEAP[j+124*a+8]-IHEAP[j+124*a];p=p<o?o:p;a=IHEAP[j+124*a+12]-IHEAP[j+124*a+4];var p=p<a?a:p,r=r+1;if(r!=n)a=1;else break}d=p}a=_memalign(16,d*4);IHEAP[e]=a;IHEAP[i]=IHEAP[e];g=a=g+-1;if(a!=0){d=b+24;
n=e+8;r=i+8;p=e+8;o=e+4;var q=e+12,u=i+8,s=i+4,t=i+12;g=g;var v=e+12,y=e+8,x=e+8,w=e+12,C=e+4,z=i+12,A=i+8,B=i+8,D=i+12,J=i+4;a=8;a:for(;;){ea=a==8?0:ea;var E=a==8?m:L,N=ea+1,Q=j+124*N+8;L=j+124*N+12;c=j+124*N;var S=j+124*N+4;N=IHEAP[d];IHEAP[n]=a==8?k:P;IHEAP[r]=E;E=IHEAP[Q];Q=IHEAP[c];var P=E-Q,G=IHEAP[L],F=IHEAP[S],L=G-F;IHEAP[o]=P-IHEAP[p];IHEAP[q]=IHEAP[c]%2;if(0<L){var K=P*4,H=G-F;a=9;b:for(;;){Y=a==9?0:Y;var M=l*Y,I=N+4*l*Y,O=IHEAP[e],R=IHEAP[v],T=IHEAP[y];if(T!=0){a=10;c=11}else{a=10;c=12}c:for(;;)if(c==
11){V=a==11?V:0;IHEAP[O+4*(R+V*2)]=IHEAP[N+4*(M+V)];var V=V+1;if(V!=T)c=a=11;else{a=11;c=12}}else if(c==12){var ba=IHEAP[x],fa=IHEAP[e],ca=IHEAP[w],U=IHEAP[C];c=U!=0?13:14;break c}if(c==13){c=1-ca;M=ba+M;for(a=13;;){$=a==13?0:$;IHEAP[fa+4*(c+$*2)]=IHEAP[N+4*(M+$)];var $=$+1;if($!=U)a=15;else break}}FUNCTION_TABLE[h](e);_llvm_memcpy_p0i8_p0i8_i32(I,IHEAP[e],K,1,0);var Y=Y+1;if(Y!=H)a=14;else break b}}IHEAP[s]=L-IHEAP[u];IHEAP[t]=IHEAP[S]%2;if(0<P){S=0<L;G=G-F;E=E-Q;a=20;b:for(;;){Q=a==20?0:ia;F=IHEAP[i];
K=IHEAP[z];H=IHEAP[A];if(H!=0){a=21;c=22}else{a=21;c=23}c:for(;;)if(c==22){Z=a==22?Z:0;IHEAP[F+4*(K+Z*2)]=IHEAP[N+4*(Q+l*Z)];var Z=Z+1;if(Z!=H)c=a=22;else{a=22;c=23}}else if(c==23){var W=IHEAP[B],X=IHEAP[i],aa=IHEAP[D],ka=IHEAP[J];c=ka!=0?24:25;break c}if(c==24){c=1-aa;F=Q+l*W;for(a=24;;){ga=a==24?0:ga;IHEAP[X+4*(c+ga*2)]=IHEAP[N+4*(F+l*ga)];var ga=ga+1;if(ga!=ka)a=26;else break}}FUNCTION_TABLE[h](i);if(S){a=25;c=29}else{a=25;c=30}for(;;)if(c==29){ja=a==29?ja:0;IHEAP[N+4*(Q+l*ja)]=IHEAP[IHEAP[i]+
4*ja];var ja=ja+1;if(ja!=G)c=a=29;else{a=29;c=30}}else if(c==30){var ia=Q+1;if(ia!=E){a=30;continue b}else break b}}}var ea=ea+1;if(ea!=g)a=4;else break a}}_free(IHEAP[e]);STACKTOP=e}_dwt_decode.__index__=Runtime.getFunctionIndex(_dwt_decode,"_dwt_decode");
function _dwt_decode_1(b){var f=null,e,c=IHEAP[b+4],a=IHEAP[b+8];f=IHEAP[b+12];b=IHEAP[b];var d=f!=0;a:do if(d){f=a!=0;b:do if(!f){if(c!=1)break b;c=b;IHEAP[c]=IHEAP[c]/2|0;return}while(0);e=0;var g=e<a;b:do if(g){var h=a,i=c,j=(c-1)*2,k=c,m=(c-1)*2,l=e;for(f=25;;){if((f==25?l:s)<0){var n=IHEAP[b];f=27}else if(e>=k){var o=IHEAP[b+4*m];f=29}else{var p=IHEAP[b+4*e*2];f=30}s=f==27?n:f==29?o:p;if(e+1<0){var r=IHEAP[b];f=31}else if(e+1>=i){var q=IHEAP[b+4*j];f=33}else{var u=IHEAP[b+4*(e+1)*2];f=34}IHEAP[b+
4*(e*2+1)]-=s+2+(f==31?r:f==33?q:u)>>2;e+=1;var s=e;if(s<h)f=35;else break b}}while(0);e=0;if(!(e<c))break a;g=c;h=a;i=(a-1)*2+1;j=a;k=(a-1)*2+1;m=e;for(f=37;;){if((f==37?m:z)<0){var t=IHEAP[b+4];f=39}else if(e>=j){var v=IHEAP[b+4*k];f=41}else{var y=IHEAP[b+4*(e*2+1)];f=42}z=f==39?t:f==41?v:y;if(e-1<0){var x=IHEAP[b+4];f=43}else if(e-1>=h){var w=IHEAP[b+4*i];f=45}else{var C=IHEAP[b+4*((e-1)*2+1)];f=46}IHEAP[b+4*e*2]+=(f==43?x:f==45?w:C)+z>>1;e+=1;var z=e;if(z<g)f=47;else break a}}else{if(!(c>0))if(!(a>
1))break a;e=0;g=e<a;b:do if(g){h=a;i=c;j=(c-1)*2+1;k=c;for(m=(c-1)*2+1;;){if(e-1<0){var A=IHEAP[b+4];f=3}else if(e-1>=k){var B=IHEAP[b+4*m];f=5}else{var D=IHEAP[b+4*((e-1)*2+1)];f=6}l=f==3?A:f==5?B:D;if(e<0){var J=IHEAP[b+4];f=7}else if(e>=i){var E=IHEAP[b+4*j];f=9}else{var N=IHEAP[b+4*(e*2+1)];f=10}IHEAP[b+4*e*2]-=l+2+(f==7?J:f==9?E:N)>>2;e+=1;if(!(e<h))break b}}while(0);e=0;if(!(e<c))break a;g=c;h=a;i=(a-1)*2;j=a;k=(a-1)*2;m=e;for(f=12;;){if((f==12?m:K)<0){var Q=IHEAP[b];f=14}else if(e>=j){var S=
IHEAP[b+4*k];f=16}else{var P=IHEAP[b+4*e*2];f=17}K=f==14?Q:f==16?S:P;if(e+1<0){var G=IHEAP[b];f=18}else if(e+1>=h){var F=IHEAP[b+4*i];f=20}else{var L=IHEAP[b+4*(e+1)*2];f=21}IHEAP[b+4*(e*2+1)]+=(f==18?G:f==20?F:L)+K>>1;e+=1;var K=e;if(K<g)f=22;else break a}}while(0)}_dwt_decode_1.__index__=Runtime.getFunctionIndex(_dwt_decode_1,"_dwt_decode_1");function _dwt_getgain(b){return b==0?0:b==1|b==2?1:2}_dwt_getgain.__index__=Runtime.getFunctionIndex(_dwt_getgain,"_dwt_getgain");
function _dwt_getnorm(b,f){return FHEAP[_dwt_norms+f*80+b*8]}_dwt_getnorm.__index__=Runtime.getFunctionIndex(_dwt_getnorm,"_dwt_getnorm");
function _dwt_encode_real(b){var f=null,e,c,a;c=IHEAP[b+8]-IHEAP[b];a=IHEAP[b+16]-1;e=IHEAP[b+24];if(0<a){var d=b+20,g=b+20,h=b+20,i=b+20,j=b+20,k=b+20,m=b+20,l=b+20,n=b+20;b=b+20;var o=(a>1?a:1)-0,p=a-0,r=a-0,q=a-0,u=a-0,s=a-0,t=a+-1-0,v=a-0,y=a-0,x=a-0;a=a-0;f=0;a:for(;;){V=f==0?0:V;f=V*-1;var w=IHEAP[IHEAP[d]+124*(p+f)+8],C=IHEAP[IHEAP[g]+124*(r+f)],z=w-C,A=IHEAP[IHEAP[h]+124*(q+f)+12],B=IHEAP[IHEAP[i]+124*(u+f)+4],D=A-B,J=IHEAP[IHEAP[j]+124*(s+f)+-116]-IHEAP[IHEAP[k]+124*(t+f)],E=IHEAP[IHEAP[m]+
124*(v+f)+-112]-IHEAP[IHEAP[l]+124*(y+f)+-120],N=IHEAP[IHEAP[n]+124*(x+f)]%2,Q=IHEAP[IHEAP[b]+124*(a+f)+4]%2,S=D-E,P=_malloc(D*4),G=P;if(0<z)if(0<D){var F=A-B,L=w-C;f=2;b:for(;;){M=f==2?0:M;var K=e+4*M;for(f=3;;){H=f==3?0:H;IHEAP[P+H*4]=IHEAP[e+4*(M+c*H)];var H=H+1;if(H!=F)f=4;else break}_dwt_encode_1_real(G,S,E,Q);_dwt_deinterleave_v(G,K,S,E,c,Q);var M=M+1;if(M!=L)f=5;else break b}}else{P=w-C;for(f=8;;){I=f==8?0:I;f=e+4*I;_dwt_encode_1_real(G,S,E,Q);_dwt_deinterleave_v(G,f,S,E,c,Q);var I=I+1;if(I!=
P)f=9;else break}}_free(G);E=z-J;Q=S=_malloc(z*4);if(0<D)if(0<z){w=w-C;A=A-B;f=12;b:for(;;){R=f==12?0:R;B=c*R;C=e+4*B;for(f=13;;){O=f==13?0:O;IHEAP[S+O*4]=IHEAP[e+4*(B+O)];var O=O+1;if(O!=w)f=14;else break}_dwt_encode_1_real(Q,E,J,N);_dwt_deinterleave_h(Q,C,E,J,N);var R=R+1;if(R!=A)f=15;else break b}}else{A=A-B;for(f=18;;){T=f==18?0:T;f=e+4*c*T;_dwt_encode_1_real(Q,E,J,N);_dwt_deinterleave_h(Q,f,E,J,N);var T=T+1;if(T!=A)f=19;else break}}_free(Q);var V=V+1;if(V!=o)f=23;else break a}}}
_dwt_encode_real.__index__=Runtime.getFunctionIndex(_dwt_encode_real,"_dwt_encode_real");
function _dwt_encode_1_real(b,f,e,c){var a;a=null;var d=c!=0;a:do if(d){if(!(e>0))if(!(f>1))break a;c=0;if(c<f){var g=c;for(a=57;;){if((a==57?g:n)<0){var h=IHEAP[b+4];a=59}else if(c>=e){var i=IHEAP[b+4*((e-1)*2+1)];a=61}else{var j=IHEAP[b+4*(c*2+1)];a=62}n=a==59?h:a==61?i:j;if(c-1<0){var k=IHEAP[b+4];a=63}else if(c-1>=e){var m=IHEAP[b+4*((e-1)*2+1)];a=65}else{var l=IHEAP[b+4*((c-1)*2+1)];a=66}n=12993*((a==63?k:a==65?m:l)+n);IHEAP[b+4*c*2]-=n+(n&4096)>>13&4294967295;c+=1;var n=c;if(n<f)a=67;else break}}c=
0;if(c<e){g=c;for(a=70;;){if((a==70?g:t)<0){var o=IHEAP[b];a=72}else if(c>=f){var p=IHEAP[b+4*(f-1)*2];a=74}else{var r=IHEAP[b+4*c*2];a=75}t=a==72?o:a==74?p:r;if(c+1<0){var q=IHEAP[b];a=76}else if(c+1>=f){var u=IHEAP[b+4*(f-1)*2];a=78}else{var s=IHEAP[b+4*(c+1)*2];a=79}t=434*((a==76?q:a==78?u:s)+t);IHEAP[b+4*(c*2+1)]-=t+(t&4096)>>13&4294967295;c+=1;var t=c;if(t<e)a=80;else break}}c=0;if(c<f){g=c;for(a=83;;){if((a==83?g:A)<0){var v=IHEAP[b+4];a=85}else if(c>=e){var y=IHEAP[b+4*((e-1)*2+1)];a=87}else{var x=
IHEAP[b+4*(c*2+1)];a=88}A=a==85?v:a==87?y:x;if(c-1<0){var w=IHEAP[b+4];a=89}else if(c-1>=e){var C=IHEAP[b+4*((e-1)*2+1)];a=91}else{var z=IHEAP[b+4*((c-1)*2+1)];a=92}A=7233*((a==89?w:a==91?C:z)+A);IHEAP[b+4*c*2]+=A+(A&4096)>>13&4294967295;c+=1;var A=c;if(A<f)a=93;else break}}c=0;if(c<e){g=c;for(a=96;;){if((a==96?g:S)<0){var B=IHEAP[b];a=98}else if(c>=f){var D=IHEAP[b+4*(f-1)*2];a=100}else{var J=IHEAP[b+4*c*2];a=101}S=a==98?B:a==100?D:J;if(c+1<0){var E=IHEAP[b];a=102}else if(c+1>=f){var N=IHEAP[b+4*
(f-1)*2];a=104}else{var Q=IHEAP[b+4*(c+1)*2];a=105}S=3633*((a==102?E:a==104?N:Q)+S);IHEAP[b+4*(c*2+1)]+=S+(S&4096)>>13&4294967295;c+=1;var S=c;if(S<e)a=106;else break}}c=0;a=c<f?109:110;b:for(;;)if(a==109){a=5038*IHEAP[b+4*c*2];IHEAP[b+4*c*2]=a+(a&4096)>>13&4294967295;c+=1;if(c<f){a=109;continue b}a=110}else if(a==110){c=0;if(c<e)break b;else break a}for(;;){a=6659*IHEAP[b+4*(c*2+1)];IHEAP[b+4*(c*2+1)]=a+(a&4096)>>13&4294967295;c+=1;if(!(c<e))break}}else{if(!(f>0))if(!(e>1))break a;c=0;if(c<f){g=
c;for(a=2;;){if((a==2?g:M)<0){var P=IHEAP[b];a=4}else if(c>=e){var G=IHEAP[b+4*(e-1)*2];a=6}else{var F=IHEAP[b+4*c*2];a=7}M=a==4?P:a==6?G:F;if(c+1<0){var L=IHEAP[b];a=8}else if(c+1>=e){var K=IHEAP[b+4*(e-1)*2];a=10}else{var H=IHEAP[b+4*(c+1)*2];a=11}M=12993*((a==8?L:a==10?K:H)+M);IHEAP[b+4*(c*2+1)]-=M+(M&4096)>>13&4294967295;c+=1;var M=c;if(M<f)a=12;else break}}c=0;a=c<e?15:16;b:for(;;)if(a==15){if(c-1<0){var I=IHEAP[b+4];a=17}else if(c-1>=f){var O=IHEAP[b+4*((f-1)*2+1)];a=19}else{var R=IHEAP[b+4*
((c-1)*2+1)];a=20}g=a==17?I:a==19?O:R;if(c<0){var T=IHEAP[b+4];a=21}else if(c>=f){var V=IHEAP[b+4*((f-1)*2+1)];a=23}else{var ba=IHEAP[b+4*(c*2+1)];a=24}a=434*((a==21?T:a==23?V:ba)+g);IHEAP[b+4*c*2]-=a+(a&4096)>>13&4294967295;c+=1;if(c<e){a=15;continue b}a=16}else if(a==16){c=0;a=c<f?26:27;break b}if(a==26){g=c;for(a=26;;){if((a==26?g:W)<0){var fa=IHEAP[b];a=29}else if(c>=e){var ca=IHEAP[b+4*(e-1)*2];a=31}else{var U=IHEAP[b+4*c*2];a=32}W=a==29?fa:a==31?ca:U;if(c+1<0){var $=IHEAP[b];a=33}else if(c+
1>=e){var Y=IHEAP[b+4*(e-1)*2];a=35}else{var Z=IHEAP[b+4*(c+1)*2];a=36}W=7233*((a==33?$:a==35?Y:Z)+W);IHEAP[b+4*(c*2+1)]+=W+(W&4096)>>13&4294967295;c+=1;var W=c;if(W<f)a=37;else break}}c=0;a=c<e?40:41;b:for(;;)if(a==40){if(c-1<0){var X=IHEAP[b+4];a=42}else if(c-1>=f){var aa=IHEAP[b+4*((f-1)*2+1)];a=44}else{var ka=IHEAP[b+4*((c-1)*2+1)];a=45}g=a==42?X:a==44?aa:ka;if(c<0){var ga=IHEAP[b+4];a=46}else if(c>=f){var ja=IHEAP[b+4*((f-1)*2+1)];a=48}else{var ia=IHEAP[b+4*(c*2+1)];a=49}a=3633*((a==46?ga:a==
48?ja:ia)+g);IHEAP[b+4*c*2]+=a+(a&4096)>>13&4294967295;c+=1;if(c<e){a=40;continue b}a=41}else if(a==41){c=0;a=c<f?51:52;break b}b:for(;;)if(a==51){a=5038*IHEAP[b+4*(c*2+1)];IHEAP[b+4*(c*2+1)]=a+(a&4096)>>13&4294967295;c+=1;if(c<f){a=51;continue b}a=52}else if(a==52){c=0;if(c<e)break b;else break a}for(;;){a=6659*IHEAP[b+4*c*2];IHEAP[b+4*c*2]=a+(a&4096)>>13&4294967295;c+=1;if(!(c<e))break}}while(0)}_dwt_encode_1_real.__index__=Runtime.getFunctionIndex(_dwt_encode_1_real,"_dwt_encode_1_real");
function _dwt_getgain_real(){return 0}_dwt_getgain_real.__index__=Runtime.getFunctionIndex(_dwt_getgain_real,"_dwt_getgain_real");function _dwt_getnorm_real(b,f){return FHEAP[_dwt_norms_real+f*80+b*8]}_dwt_getnorm_real.__index__=Runtime.getFunctionIndex(_dwt_getnorm_real,"_dwt_getnorm_real");
function _dwt_calc_explicit_stepsizes(b,f){var e,c=null,a;a=IHEAP[b+4]*3-2;if(0<a){var d=b+4,g=b+20,h=b+24;a=(a>1?a:1)-0;c=0;a:for(;;){A=c==0?0:A;c=0+A;var i=-1+A,j=b+28+c*8+4,k=b+28+c*8;if(c==0)c=1;else{var m=(i/3|0)+1,l=i%3+1;c=2}i=c==2?l:0;var n=IHEAP[d]+-1+(0-(c==2?m:0));if(IHEAP[g]==0|i==0)c=18;else{var o=i==2;o=(i==1?1:o)?1:2;c=4}e=c==18?0:o;if(IHEAP[h]==0)c=19;else{var p=(1<<e)/FHEAP[_dwt_norms_real+i*80+n*8];c=6}i=_floor((c==6?p:1)*8192)|0;n=e+f;if(i>1){c=8;e=9}else{c=8;e=10}b:for(;;)if(e==
9){u=c==9?u:0;var r=u+1,q=(c==9?q:i)>>1,u=u+1;if(q>1){e=c=9;continue b}var s=r-13;if(i>1)c=11;else{c=11;e=10;continue b}for(;;){y=c==12?y:0;var t=y+1,v=(c==12?v:i)>>1,y=y+1;if(v>1)e=c=12;else{c=12;e=10;continue b}}}else if(e==10){var x=c==11?s:c==8?-13:s,w=11-(c==11?0:c==8?0:t);e=w<0?13:14;break b}if(e==13){var C=i>>0-w;c=13}else if(e==14){var z=i<<w;c=14}IHEAP[j]=(c==13?C:z)&2047;IHEAP[k]=n-x;var A=A+1;if(A!=a)c=16;else break a}}}
_dwt_calc_explicit_stepsizes.__index__=Runtime.getFunctionIndex(_dwt_calc_explicit_stepsizes,"_dwt_calc_explicit_stepsizes");
function _dwt_decode_real(b,f){var e=STACKTOP;STACKTOP+=32;_memset(e,0,32);var c,a=null,d,g,h,i,j=e+16,k,m,l,n,o,p,r;i=f;k=IHEAP[b+20];m=IHEAP[k+8]-IHEAP[k];l=IHEAP[k+12]-IHEAP[k+4];n=IHEAP[b+8]-IHEAP[b];h=i;d=k;g=h;h=1;var q=g+-1;g=q;if(q!=0){h=h;g=g;for(a=0;;){t=a==0?0:t;q=a==0?h:s;s=t+1;var u=IHEAP[d+124*s+8]-IHEAP[d+124*s];q=q<u?u:q;s=IHEAP[d+124*s+12]-IHEAP[d+124*s+4];var s=q<s?s:q,t=t+1;if(t!=g)a=1;else break}h=s}d=_memalign(16,(h+5)*16);IHEAP[e]=d;IHEAP[j]=IHEAP[e];d=e+8;h=j+8;g=e+8;t=e+4;
s=e+12;q=j+8;u=j+4;var v=j+12;a:for(;;){i=a=i+-1;if(a==0)break a;o=IHEAP[b+24];p=(IHEAP[b+12]-IHEAP[b+4])*(IHEAP[b+8]-IHEAP[b]);IHEAP[d]=m;IHEAP[h]=l;k+=124;m=IHEAP[k+8]-IHEAP[k];l=IHEAP[k+12]-IHEAP[k+4];IHEAP[t]=m-IHEAP[g];IHEAP[s]=IHEAP[k]%2;var y=l;a=y;if(y>3){y=n;var x=m,w=n,C=n,z=n,A=n,B=n;o=o;p=p;r=a;var D=x+-1>=0;b:do if(D){var J=x+-1,E=A*4,N=x+-1;c=N+w;var Q=N+C*2,S=N+z*3,P=r+-4,G=B*-4,F=p-B*4,L=A*4;a=7;for(;;){Y=a==10?Y:0;a=E*Y;var K=N+a,H=c+a,M=Q+a,I=S+a,O=P+Y*-4,R=G*Y,T=F+R,V=o+4*(L+a);
_v4dwt_interleave_h(e,o+4*a,y,p+R);_v4dwt_decode(e);for(a=8;;){$=a==8?0:$;a=$*-1;R=o+4*(H+a);var ba=o+4*(M+a),fa=o+4*(I+a),ca=$*-1,U=x+ca;FHEAP[o+4*(K+a)]=FHEAP[IHEAP[e]+16*(J+ca)];FHEAP[R]=FHEAP[IHEAP[e]+16*U+-12];FHEAP[ba]=FHEAP[IHEAP[e]+16*U+-8];FHEAP[fa]=FHEAP[IHEAP[e]+16*U+-4];var $=$+1;if($!=x)a=9;else break}var Y=Y+1;if(O>3)a=10;else{a=10;break b}}}else{J=A*4;E=r+-4;N=B*-4;c=p-B*4;Q=A*4;for(a=12;;){X=a==12?0:X;S=J*X;a=E+X*-4;P=N*X;var Z=c+P,W=o+4*(Q+S);_v4dwt_interleave_h(e,o+4*S,y,p+P);_v4dwt_decode(e);
var X=X+1;if(a>3)a=13;else{a=13;break b}}}while(0);y=a==10?V:W;p=a==10?T:Z;o=y}y=(l&3)!=0;b:do if(y){a=l&3;_v4dwt_interleave_h(e,o,n,p);_v4dwt_decode(e);r=m;r=x=r+-1;if(!(x>=0))break b;x=a;w=n;C=o;z=n;B=A=o;r=r;D=x==3;c:do if(D){a=r*-1;J=r+1+(a>0?a:0);E=r+w*2;N=r+z;for(a=17;;){aa=a==18?aa:0;a=aa*-1;c=r+a;Q=A+4*(N+a);S=B+4*c;FHEAP[C+4*(E+a)]=FHEAP[IHEAP[e]+16*c+8];FHEAP[Q]=FHEAP[IHEAP[e]+16*c+4];FHEAP[S]=FHEAP[IHEAP[e]+16*c];var aa=aa+1;if(aa!=J)a=18;else break}}else{J=r+-1;E=r+z;a=21;for(;;){ka=a==
21?0:ka;c=ka*-1;a=J+c;N=r+c;Q=A+4*(E+c);S=B+4*N;c=x==2?40:x==1?23:25;e:do if(c==40){FHEAP[Q]=FHEAP[IHEAP[e]+16*N+4];c=23;break e}while(0);if(c==23)FHEAP[S]=FHEAP[IHEAP[e]+16*N];var ka=ka+1;if(a>=0)a=25;else break c}}while(0)}while(0);IHEAP[u]=l-IHEAP[q];IHEAP[v]=IHEAP[k+4]%2;o=IHEAP[b+24];a=y=m;if(y>3){x=y=n;w=l;C=o;z=a;A=0<l;b:do if(A){B=w>1?w:1;o=z+-4;a=28;for(;;){ia=a==31?ia:0;r=ia*4;p=o+ia*-4;var ga=C+4*(r+4);_v4dwt_interleave_v(j,C+4*r,y);_v4dwt_decode(j);for(a=29;;){ja=a==29?0:ja;_llvm_memcpy_p0i8_p0i8_i32(C+
4*(r+x*ja),IHEAP[j]+16*ja,16,1,0);var ja=ja+1;if(ja!=B)a=30;else break}var ia=ia+1;if(p>3)a=31;else{a=31;break b}}}else{B=z+-4;for(a=33;;){oa=a==33?0:oa;o=oa*4;a=B+oa*-4;var ea=C+4*(o+4);_v4dwt_interleave_v(j,C+4*o,y);_v4dwt_decode(j);var oa=oa+1;if(a>3)a=34;else{a=34;break b}}}while(0);o=a==31?ga:ea}if((m&3)==0)continue a;a=m&3;_v4dwt_interleave_v(j,o,n);_v4dwt_decode(j);if(!(0<l))continue a;y=n;x=o;w=a*4;a=l;C=(a>1?a:1)-0;z=0*y;for(a=37;;){pa=a==37?0:pa;_llvm_memcpy_p0i8_p0i8_i32(x+4*(z+y*pa),IHEAP[j]+
16*(0+pa),w,1,0);var pa=pa+1;if(pa!=C)a=38;else break}}_free(IHEAP[e]);STACKTOP=e}_dwt_decode_real.__index__=Runtime.getFunctionIndex(_dwt_decode_real,"_dwt_decode_real");
function _v4dwt_interleave_h(b,f,e,c){var a,d=null,g,h;g=IHEAP[b]+16*IHEAP[b+12];h=IHEAP[b+8];var i=e*3,j=(e&15)==0,k=b+12,m=b+8,l=b+8,n=b+4,o=e+e,p=o+e,r=e+e,q=r+e;d=0;a:for(;;){N=d==0?0:N;J=d==0?c:J;E=d==0?h:E;B=d==0?g:B;D=d==0?f:D;d=i+E<J;b:do if(d){if((D&15)!=0){a=3;break b}if((B&15)==0^1|j^1){a=3;break b}if(0<E)d=4;else{a=6;break b}for(;;){x=d==5?x:0;d=D+4*(q+x);a=D+4*(r+x);var u=D+4*(e+x),s=x*8,t=B+4*(s+3),v=B+4*(s+2),y=B+4*(s+1);FHEAP[B+4*s]=FHEAP[D+4*x];FHEAP[y]=FHEAP[u];FHEAP[v]=FHEAP[a];
FHEAP[t]=FHEAP[d];var x=x+1;if(x!=E)d=5;else break}a=6;break b}else a=3;while(0);b:do if(a==3){if(0<E)d=3;else break b;c:for(;;){A=d==10?A:0;d=p+A;a=D+4*d;u=o+A;s=D+4*u;var w=e+A;t=D+4*w;var C=A*8;v=B+4*(C+1);y=B+4*(C+2);var z=B+4*(C+3);FHEAP[B+4*C]=FHEAP[D+4*A];w=w>J;d:do if(!w){FHEAP[v]=FHEAP[t];if(u>J)break d;FHEAP[y]=FHEAP[s];if(d>J)break d;FHEAP[z]=FHEAP[a]}while(0);var A=A+1;if(A!=E){d=10;a=8}else{a=14;break c}}}while(0);var B=IHEAP[b]+16+16*(0-IHEAP[k]),D=D+4*IHEAP[m],J=J-IHEAP[l],E=IHEAP[n],
N=N+1;if(N!=2)d=6;else break a}}_v4dwt_interleave_h.__index__=Runtime.getFunctionIndex(_v4dwt_interleave_h,"_v4dwt_interleave_h");
function _v4dwt_decode(b){var f,e,c,a=IHEAP[b+12]==0;a:do{if(a){if(!(IHEAP[b+4]>0))if(!(IHEAP[b+8]>1)){f=1;break a}e=0;c=1}else{if(!(IHEAP[b+8]>0))if(!(IHEAP[b+4]>1)){f=1;break a}e=1;c=0}f=2;break a}while(0);if(f==2){_v4dwt_decode_step1(IHEAP[b]+16*e,IHEAP[b+8],1.2301740646362305);_v4dwt_decode_step1(IHEAP[b]+16*c,IHEAP[b+4],1.625732421875);a=IHEAP[b]+16*c;var d=IHEAP[b]+16*e+16,g=IHEAP[b+8],h=IHEAP[b+4]-e;f=IHEAP[b+8];_v4dwt_decode_step2(a,d,g,f<h?f:h,-0.4435068666934967);a=IHEAP[b]+16*e;d=IHEAP[b]+
16*c+16;g=IHEAP[b+4];h=IHEAP[b+8]-c;f=IHEAP[b+4];_v4dwt_decode_step2(a,d,g,f<h?f:h,-0.8829110860824585);a=IHEAP[b]+16*c;d=IHEAP[b]+16*e+16;g=IHEAP[b+8];h=IHEAP[b+4]-e;f=IHEAP[b+8];_v4dwt_decode_step2(a,d,g,f<h?f:h,0.05298011749982834);e=IHEAP[b]+16*e;f=IHEAP[b]+16*c+16;a=IHEAP[b+4];c=IHEAP[b+8]-c;b=IHEAP[b+4];_v4dwt_decode_step2(e,f,a,b<c?b:c,1.5861343145370483)}}_v4dwt_decode.__index__=Runtime.getFunctionIndex(_v4dwt_decode,"_v4dwt_decode");
function _v4dwt_interleave_v(b,f,e){var c=null,a;f=f;a=IHEAP[b]+16*IHEAP[b+12];c=0;if(c<IHEAP[b+8]){a=a;var d=f,g=b+8;c=c;var h=c+1,i=c*e,j=c*2;for(c=0;;){k=c==0?0:k;c=h+k;_llvm_memcpy_p0i8_p0i8_i32(a+16*(j+k*2),d+4*(i+e*k),16,1,0);var k=k+1;if(c<IHEAP[g])c=1;else break}}f+=4*e*IHEAP[b+8];a=IHEAP[b]+16+16*(0-IHEAP[b+12]);c=0;if(c<IHEAP[b+4]){k=a;f=f;b=b+4;c=c;a=c+1;d=c*e;g=c*2;for(c=4;;){m=c==4?0:m;c=a+m;_llvm_memcpy_p0i8_p0i8_i32(k+16*(g+m*2),f+4*(d+e*m),16,1,0);var m=m+1;if(c<IHEAP[b])c=5;else break}}}
_v4dwt_interleave_v.__index__=Runtime.getFunctionIndex(_v4dwt_interleave_v,"_v4dwt_interleave_v");function _v4dwt_decode_step1(b,f,e){var c=null;if(0<f){f=(f>1?f:1)-0;for(c=0;;){c=c==0?0:k;k=c*8;var a=3+k,d=b+4*a,g=2+k,h=b+4*g,i=1+k,j=b+4*i;i=FHEAP[b+4*i];g=FHEAP[b+4*g];a=FHEAP[b+4*a];FHEAP[b+4*(0+k)]*=e;FHEAP[j]=i*e;FHEAP[h]=g*e;FHEAP[d]=a*e;var k=c+1;if(k!=f)c=1;else break}}}_v4dwt_decode_step1.__index__=Runtime.getFunctionIndex(_v4dwt_decode_step1,"_v4dwt_decode_step1");
function _v4dwt_decode_step2(b,f,e,c,a){var d=null,g,h,i;a=a;b=b;f=f;if(0<c){var j=a;i=h=g=a;b=b;var k=(c>1?c:1)-0;for(d=0;;){t=d==0?0:t;d=d==0?b:s;s=FHEAP[d+4];var m=FHEAP[d+8],l=FHEAP[d+12],n=FHEAP[f+-12],o=FHEAP[f+-8],p=FHEAP[f+-4],r=FHEAP[f+4],q=FHEAP[f+8],u=FHEAP[f+12];FHEAP[f+-16]+=(FHEAP[d]+FHEAP[f])*j;FHEAP[f+-12]=n+(s+r)*g;FHEAP[f+-8]=o+(m+q)*h;FHEAP[f+-4]=p+(l+u)*i;var s=f;f+=32;var t=t+1;if(t!=k)d=1;else break}b=s}j=c<e;a:do if(j){a+=a;g=FHEAP[b]*a;h=FHEAP[b+4]*a;i=FHEAP[b+8]*a;d=FHEAP[b+
12]*a;if(!(c<e))break a;g=g;h=h;i=i;k=d;d=e;t=c;s=t+1;t=(d>s?d:s)-t;for(d=4;;){v=d==4?0:v;d=FHEAP[f+-12];s=FHEAP[f+-8];m=FHEAP[f+-4];FHEAP[f+-16]+=g;FHEAP[f+-12]=d+h;FHEAP[f+-8]=s+i;FHEAP[f+-4]=m+k;f+=32;var v=v+1;if(v!=t)d=6;else break}}while(0)}_v4dwt_decode_step2.__index__=Runtime.getFunctionIndex(_v4dwt_decode_step2,"_v4dwt_decode_step2");function _opj_set_event_mgr(b,f,e){var c;if(b!=0){c=IHEAP[b];IHEAP[b]=f;IHEAP[b+4]=e;b=c}else b=0;return b}
_opj_set_event_mgr.__index__=Runtime.getFunctionIndex(_opj_set_event_mgr,"_opj_set_event_mgr");
function _opj_event_msg(b,f,e){var c=STACKTOP;STACKTOP+=516;_memset(c,0,516);var a,d=null,g,h,i=c+4;g=0;h=IHEAP[b];if(h!=0){a=f==1?0:f==2?2:f==4?3:4;if(a==4){var j=g;d=4}else if(a==0){var k=IHEAP[h];g=k;d=0}else if(a==2){var m=IHEAP[h+4];g=m;d=2}else if(a==3){var l=IHEAP[h+8];g=l;d=3}if((d==4?j:d==3?l:d==2?m:k)==0)g=0;else{a=e!=0;a:do if(a){if(h==0)break a;_llvm_memset_p0i8_i32(i,0,512,1,0);IHEAP[c]=arguments[_opj_event_msg.length];_strlen(e)>512||_strlen(e);_vsprintf(i,e,IHEAP[c]);FUNCTION_TABLE[g](i,
IHEAP[b+4])}while(0);g=1}}else g=0;g=g;STACKTOP=c;return g}_opj_event_msg.__index__=Runtime.getFunctionIndex(_opj_event_msg,"_opj_event_msg");function _opj_image_create0(){return _calloc(1,36)}_opj_image_create0.__index__=Runtime.getFunctionIndex(_opj_image_create0,"_opj_image_create0");
function _opj_image_create(b,f,e){var c,a=null,d,g;g=_calloc(1,36);var h=g!=0;a:do if(h){IHEAP[g+20]=e;IHEAP[g+16]=b;var i=_malloc(IHEAP[g+16]*48);IHEAP[g+24]=i;if(IHEAP[g+24]!=0){i=b;var j=g+24,k=f,m=f,l=f,n=f,o=f,p=f,r=f,q=f,u=f;for(a=1;;){c=a==5?D:0;a=0+c;var s=k+36*a,t=m+36*a+4,v=l+36*a+8,y=n+36*a+12,x=o+36*a+16,w=p+36*a+20,C=r+36*a+24,z=q+36*a+28,A=u+36*a+32;if(!(a<i)){c=4;break}var B=IHEAP[j];IHEAP[B+48*a]=IHEAP[s];IHEAP[B+48*a+4]=IHEAP[t];IHEAP[B+48*a+8]=IHEAP[v];IHEAP[B+48*a+12]=IHEAP[y];
IHEAP[B+48*a+16]=IHEAP[x];IHEAP[B+48*a+20]=IHEAP[w];IHEAP[B+48*a+24]=IHEAP[C];IHEAP[B+48*a+28]=IHEAP[z];IHEAP[B+48*a+32]=IHEAP[A];s=_calloc(IHEAP[B+48*a+12]*IHEAP[B+48*a+8],4);IHEAP[B+48*a+44]=s;if(IHEAP[B+48*a+44]==0){c=6;break}var D=c+1;a=5;c=2}if(c==4){c=7;break a}else if(c==6){_fwrite(__str387,37,1,IHEAP[_stderr]);_opj_image_destroy(g);c=d=0;break a}}else{_fwrite(__str387,37,1,IHEAP[_stderr]);_opj_image_destroy(g);c=d=0;break a}}else c=7;while(0);if(c==7)d=g;return d}
_opj_image_create.__index__=Runtime.getFunctionIndex(_opj_image_create,"_opj_image_create");function _opj_image_destroy(b){var f=null;if(b!=0){if(IHEAP[b+24]!=0){if(0<IHEAP[b+16]){var e=b+24,c=b+16;for(f=0;;){g=f==0?0:g;var a=0+g;f=1+g;var d=IHEAP[e];IHEAP[d+48*a+44]!=0&&_free(IHEAP[d+48*a+44]);var g=g+1;if(f<IHEAP[c])f=3;else break}}_free(IHEAP[b+24])}_free(b)}}_opj_image_destroy.__index__=Runtime.getFunctionIndex(_opj_image_destroy,"_opj_image_destroy");
function _j2k_convert_progression_order(b){var f=null,e;e=e=_j2k_prog_order_list;for(f=0;;){a=f==4?a:0;var c=e+8*a;f=c;if(IHEAP[f]==-1)break;if(IHEAP[f]==b)break;var a=a+1;f=4}e=c;return e+4}_j2k_convert_progression_order.__index__=Runtime.getFunctionIndex(_j2k_convert_progression_order,"_j2k_convert_progression_order");
function _j2k_calculate_tp(b,f,e,c){var a,d=null,g,h;h=0;f=_malloc(IHEAP[b+68]*4*IHEAP[b+72]);IHEAP[c+20]=f;f=b+68;var i=b+72,j=b+108,k=c+20,m=c+68,l=c+68;c=c+68;h=h;d=0;a:for(;;){a=d==11?t:0;var n=d==11?r:h;t=0+a;if(!(t<IHEAP[i]*IHEAP[f])){a=3;break a}var o=IHEAP[j]+5588*t+420;for(d=2;;){var p=d==7?u:0,r=d==7?q:n;d=d==7?s:0;if(!(d<=IHEAP[o]))break;s=_pi_initialise_encode(e,b,t,1);if(s==0){a=8;break a}u=_j2k_get_num_tp(b,d,t);var q=u+r,u=u+p;_pi_destroy(s,b,t);var s=d+1;d=7}IHEAP[IHEAP[k]+4*t]=p;
if(IHEAP[m]!=0){IHEAP[IHEAP[IHEAP[l]+88]+572*t+564]=p;d=_malloc(p*20);IHEAP[IHEAP[IHEAP[c]+88]+572*t+568]=d}var t=a+1;d=11;a=1}if(a==3)g=h=n;else if(a==8)g=-1;return g}_j2k_calculate_tp.__index__=Runtime.getFunctionIndex(_j2k_calculate_tp,"_j2k_calculate_tp");
function _j2k_get_num_tp(b,f,e){var c,a=null,d,g,h;g=1;h=IHEAP[b+108]+5588*e;e=IHEAP[h+8];var i=a=_j2k_prog_order_list;a=0;a:for(;;){a=a==4?j:0;j=d=i+8*a;if(IHEAP[j]==-1)break a;if(IHEAP[j]==e)break a;var j=a+1;a=4}a=d;d=a+4;if(IHEAP[b+16]==1){e=b+17;b=b+20;i=h+428+f*148+92;j=h+428+f*148+88;var k=h+428+f*148+96;f=h+428+f*148+84;g=g;a=5;a:for(;;){v=a==5?0:v;t=a==5?g:t;s=a==5?0:s;h=0+v;var m=d+h,l=d+h,n=s!=1;b:do if(n){if(IHEAP[e]==IHEAP[m]){IHEAP[b]=h;a=7}else a=18;var o=a==7?1:s;a=IHEAP[l];if(a==
67){a=17;c=9}else if(a==82){a=17;c=11}else if(a==80){a=17;c=12}else if(a==76){a=17;c=13}else{a=17;break b}if(c==9){var p=IHEAP[i]*t;a=9}else if(c==11){var r=IHEAP[j]*t;a=11}else if(c==12){var q=IHEAP[k]*t;a=12}else if(c==13){var u=IHEAP[f]*t;a=13}}else a=6;while(0);var s=a==6?1:a==13?o:a==12?o:a==11?o:a==9?o:o,t=a==6?t:a==13?u:a==12?q:a==11?r:a==9?p:t,v=v+1;if(v!=4)a=14;else break a}g=t}else g=1;return g}_j2k_get_num_tp.__index__=Runtime.getFunctionIndex(_j2k_get_num_tp,"_j2k_get_num_tp");
function _j2k_read_soc(b){var f;IHEAP[b+4]=2;if(IHEAP[b+68]!=0){f=IHEAP[b+72];IHEAP[IHEAP[b+68]+76]=IHEAP[f+24]+-2+(0-IHEAP[f+16]);f=IHEAP[b+72];IHEAP[IHEAP[b+68]+84]=IHEAP[f+20]+2+(0-IHEAP[f+24])+(0-IHEAP[IHEAP[b+68]+76])}}_j2k_read_soc.__index__=Runtime.getFunctionIndex(_j2k_read_soc,"_j2k_read_soc");
function _j2k_read_sot(b){var f=null,e,c,a,d,g,h,i;g=0;h=IHEAP[b+64];i=IHEAP[b+72];_cio_read(i,2);e=_cio_read(i,2);d=IHEAP[h+80]==0;a:do{if(!d){f=0;c=IHEAP[h+80];a=h+76;var j=e,k=f;g=g;for(f=1;;){var m=f==5?o:0,l=f==5?n:g;f=k+m;if(!(f<c))break;if(l!=0)break;var n=(IHEAP[IHEAP[a]+4*f]==j?1:0)&255,o=m+1;f=5}g=l;if(g!=0)break a}IHEAP[IHEAP[h+76]+4*IHEAP[h+80]]=e;IHEAP[h+80]+=1}while(0);f=d=_cio_read(i,4);if(d==0)f=IHEAP[i+20]+8+(0-IHEAP[i+24]);c=_cio_read(i,1);a=_cio_read(i,1);IHEAP[b+8]=e;IHEAP[b+16]=
c;IHEAP[b+32]=IHEAP[i+24]+-12+f;IHEAP[b+4]=16;d=IHEAP[h+108]+5588*IHEAP[b+8];if(IHEAP[b+68]!=0){if(IHEAP[d]!=0){if(e==0)IHEAP[IHEAP[b+68]+80]=IHEAP[i+24]+-13+(0-IHEAP[i+16]);IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+4]=e;IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+8]=IHEAP[i+24]+-12+(0-IHEAP[i+16]);IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+16]=IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+8]+-1+f;IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+564]=a;if(a!=0){a=_malloc(a*20);IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+568]=a}else{a=_malloc(200);IHEAP[IHEAP[IHEAP[b+
68]+88]+572*e+568]=a}}else IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+16]+=f;IHEAP[IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+568]+20*c]=IHEAP[i+24]+-12+(0-IHEAP[i+16]);IHEAP[IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+568]+20*c+8]=IHEAP[IHEAP[IHEAP[IHEAP[b+68]+88]+572*e+568]+20*c]+-1+f}if(IHEAP[d]==1){e=IHEAP[d+5584];_llvm_memcpy_p0i8_p0i8_i32(d,IHEAP[b+56],5588,1,0);IHEAP[d+5172]=0;IHEAP[d+5164]=0;IHEAP[d+5168]=0;IHEAP[d+5584]=e;f=0;if(f<IHEAP[IHEAP[b+60]+16]){e=d+5584;i=f;d=i+1;for(f=12;;){p=f==12?0:p;f=d+p;c=i+p;_llvm_memcpy_p0i8_p0i8_i32(IHEAP[e]+
1076*c,IHEAP[IHEAP[b+56]+5584]+1076*c,1076,4,0);var p=p+1;if(f<IHEAP[IHEAP[b+60]+16])f=13;else break}}IHEAP[IHEAP[h+108]+5588*IHEAP[b+8]]=0}}_j2k_read_sot.__index__=Runtime.getFunctionIndex(_j2k_read_sot,"_j2k_read_sot");
function _j2k_read_sod(b){var f=null,e,c,a,d,g,h;c=0;g=IHEAP[b+72];h=IHEAP[b+8];if(IHEAP[b+68]!=0){IHEAP[IHEAP[IHEAP[IHEAP[b+68]+88]+572*IHEAP[b+8]+568]+20*IHEAP[b+16]+4]=IHEAP[g+24]+-1+(0-IHEAP[g+16])+IHEAP[b+44];if(IHEAP[b+16]==0)IHEAP[IHEAP[IHEAP[b+68]+88]+572*IHEAP[b+8]+12]=IHEAP[g+24]+-1+(0-IHEAP[g+16])+IHEAP[b+44];IHEAP[IHEAP[b+68]+8]=0}a=IHEAP[g+20]+1+(0-IHEAP[g+24]);e=IHEAP[b+32]-IHEAP[g+24];e=e<a?e:a;if(e==IHEAP[g+20]+1+(0-IHEAP[g+24]))c=1;a=IHEAP[IHEAP[b+48]+4*h];a=_realloc(a,e+IHEAP[IHEAP[b+
52]+4*h]);d=a+IHEAP[IHEAP[b+52]+4*h];if(0<e){var i=(e>1?e:1)-0;for(f=3;;){k=f==3?0:k;f=d+(0+k);var j=_cio_read(g,1)&255;IHEAP[f]=j;var k=k+1;if(k!=i)f=4;else break}}IHEAP[IHEAP[b+52]+4*h]+=e;IHEAP[IHEAP[b+48]+4*h]=a;IHEAP[b+4]=c!=0?64:8;IHEAP[b+16]+=1}_j2k_read_sod.__index__=Runtime.getFunctionIndex(_j2k_read_sod,"_j2k_read_sod");
function _j2k_read_eoc(b){var f,e=null,c,a,d,g=IHEAP[IHEAP[b+64]+44]!=2;a:do if(g){c=_tcd_create(IHEAP[b]);_tcd_malloc_decode(c,IHEAP[b+60],IHEAP[b+64]);d=0;var h=a=c,i=c;d=d;for(e=0;;){f=e==5?m:0;e=d+f;if(!(e<IHEAP[IHEAP[b+64]+80])){f=3;break}_tcd_malloc_decode_tile(a,IHEAP[b+60],IHEAP[b+64],e,IHEAP[b+68]);var j=IHEAP[IHEAP[IHEAP[b+64]+76]+4*e],k=_tcd_decode_tile(h,IHEAP[IHEAP[b+48]+4*j],IHEAP[IHEAP[b+52]+4*j],j,IHEAP[b+68]);_free(IHEAP[IHEAP[b+48]+4*j]);IHEAP[IHEAP[b+48]+4*j]=0;_tcd_free_decode_tile(i,
e);if(k==0){f=4;break}var m=f+1;e=5;f=1}if(f!=3)if(f==4)IHEAP[b+4]|=128;a=c;a=IHEAP[a+24];_free(IHEAP[a+8]);c=a=c;if(a==0)break a;_free(IHEAP[c+24]);_free(c)}else{d=0;if(!(d<IHEAP[IHEAP[b+64]+80]))break a;c=d;a=c+1;for(e=10;;){l=e==10?0:l;f=a+l;h=IHEAP[IHEAP[IHEAP[b+64]+76]+4*(c+l)];_free(IHEAP[IHEAP[b+48]+4*h]);IHEAP[IHEAP[b+48]+4*h]=0;var l=l+1;if(f<IHEAP[IHEAP[b+64]+80])f=e=11;else{f=12;break}}}while(0);IHEAP[b+4]=(IHEAP[b+4]&128)!=0?160:32}
_j2k_read_eoc.__index__=Runtime.getFunctionIndex(_j2k_read_eoc,"_j2k_read_eoc");
function _j2k_read_siz(b){var f,e,c,a,d;c=IHEAP[b+72];a=IHEAP[b+60];d=IHEAP[b+64];_cio_read(c,2);_cio_read(c,2);var g=_cio_read(c,4);IHEAP[a+8]=g;g=_cio_read(c,4);IHEAP[a+12]=g;g=_cio_read(c,4);IHEAP[a]=g;g=_cio_read(c,4);IHEAP[a+4]=g;g=_cio_read(c,4);IHEAP[d+56]=g;g=_cio_read(c,4);IHEAP[d+60]=g;g=_cio_read(c,4);IHEAP[d+48]=g;g=_cio_read(c,4);IHEAP[d+52]=g;g=IHEAP[a]<0;a:do if(!g){if(IHEAP[a+8]<0)break a;if(IHEAP[a+4]<0)break a;if(IHEAP[a+12]<0)break a;e=_cio_read(c,2);IHEAP[a+16]=e;e=_calloc(IHEAP[a+
16],48);IHEAP[a+24]=e;e=0;if(e<IHEAP[a+16])for(var h=f=c,i=c;;){var j=_cio_read(f,1);IHEAP[IHEAP[a+24]+48*e+24]=(j&127)+1;IHEAP[IHEAP[a+24]+48*e+32]=j>>7;j=_cio_read(h,1);IHEAP[IHEAP[a+24]+48*e]=j;j=_cio_read(i,1);IHEAP[IHEAP[a+24]+48*e+4]=j;IHEAP[IHEAP[a+24]+48*e+36]=0;IHEAP[IHEAP[a+24]+48*e+40]=IHEAP[d+36];e+=1;if(!(e<IHEAP[a+16]))break}f=IHEAP[d+56];e=IHEAP[a+8]-IHEAP[d+48];f=f;IHEAP[d+68]=(e+-1+f)/f|0;f=IHEAP[d+60];e=IHEAP[a+12]-IHEAP[d+52];f=f;IHEAP[d+72]=(e+-1+f)/f|0;e=_calloc(IHEAP[d+72]*IHEAP[d+
68],5588);IHEAP[d+108]=e;e=_malloc(IHEAP[d+68]*4*IHEAP[d+72]);IHEAP[d+76]=e;e=IHEAP[d+80]=0;f=e<IHEAP[d+72]*IHEAP[d+68]?7:8;b:for(;;)if(f==7){IHEAP[IHEAP[d+108]+5588*e+424]=0;IHEAP[IHEAP[d+108]+5588*e+420]=0;IHEAP[IHEAP[d+108]+5588*e]=1;e+=1;f=e<IHEAP[d+72]*IHEAP[d+68]?7:8}else if(f==8){IHEAP[d+92]=0;IHEAP[d+84]=0;IHEAP[d+88]=0;IHEAP[d+100]=0;IHEAP[d+96]=0;e=_calloc(IHEAP[a+16],1076);IHEAP[IHEAP[b+56]+5584]=e;e=0;f=e<IHEAP[d+72]*IHEAP[d+68]?9:10;break b}for(;;)if(f==9){f=_malloc(IHEAP[a+16]*1076);
IHEAP[IHEAP[d+108]+5588*e+5584]=f;e+=1;f=e<IHEAP[d+72]*IHEAP[d+68]?9:10}else if(f==10){e=_calloc(IHEAP[d+72]*IHEAP[d+68],4);IHEAP[b+48]=e;e=_calloc(IHEAP[d+72]*IHEAP[d+68],4);IHEAP[b+52]=e;IHEAP[b+4]=4;f=IHEAP[b+68]!=0?11:12;break}if(f==11){b=IHEAP[b+68];IHEAP[b+16]=IHEAP[a+8]-IHEAP[a];IHEAP[b+20]=IHEAP[a+12]-IHEAP[a+4];IHEAP[b+52]=IHEAP[a+16];IHEAP[b+44]=IHEAP[d+68];IHEAP[b+48]=IHEAP[d+72];IHEAP[b+28]=IHEAP[d+56];IHEAP[b+32]=IHEAP[d+60];IHEAP[b+36]=IHEAP[d+48];IHEAP[b+40]=IHEAP[d+52];a=_calloc(IHEAP[d+
72]*IHEAP[d+68],572);IHEAP[b+88]=a;return}else if(f==12)return}while(0);_opj_event_msg(IHEAP[b],1,__str997,Pointer_make([IHEAP[a],0,0,0,IHEAP[a+8],0,0,0,IHEAP[a+4],0,0,0,IHEAP[a+12],0,0,0],0,ALLOC_STACK))}_j2k_read_siz.__index__=Runtime.getFunctionIndex(_j2k_read_siz,"_j2k_read_siz");
function _j2k_read_cod(b){var f=null,e,c,a,d;c=IHEAP[b+72];f=IHEAP[b+64];if(IHEAP[b+4]==16){a=IHEAP[f+108]+5588*IHEAP[b+8];f=0}else{d=IHEAP[b+56];f=2}a=f==0?a:d;d=IHEAP[b+60];_cio_read(c,2);f=_cio_read(c,1);IHEAP[a+4]=f;f=_cio_read(c,1);IHEAP[a+8]=f;f=_cio_read(c,2);IHEAP[a+12]=f;f=_cio_read(c,1);IHEAP[a+16]=f;e=IHEAP[c+24]-IHEAP[c+16];f=0;if(f<IHEAP[d+16]){var g=a+4,h=a+5584,i=d+16,j=f,k=j+1;for(f=3;;){l=f==3?0:l;f=k+l;var m=j+l;IHEAP[IHEAP[h]+1076*m]=IHEAP[g]&1;IHEAP[c+24]=IHEAP[c+16]+e;_j2k_read_cox(b,
m);var l=l+1;if(f<IHEAP[i])f=4;else break}}c=IHEAP[b+68]!=0;a:do if(c){e=IHEAP[b+68];IHEAP[e+24]=IHEAP[a+8];IHEAP[e+56]=IHEAP[a+12];l=_malloc(IHEAP[d+16]*4);IHEAP[e+60]=l;f=0;if(!(f<IHEAP[d+16]))break a;l=a+5584;e=e+60;g=d+16;h=f;i=h+1;for(f=7;;){n=f==7?0:n;f=i+n;j=h+n;IHEAP[IHEAP[e]+4*j]=IHEAP[IHEAP[l]+1076*j+4]-1;var n=n+1;if(f<IHEAP[g])f=9;else break}}while(0)}_j2k_read_cod.__index__=Runtime.getFunctionIndex(_j2k_read_cod,"_j2k_read_cod");
function _j2k_read_coc(b){var f=null,e,c;f=IHEAP[b+64];if(IHEAP[b+4]==16){c=IHEAP[f+108]+5588*IHEAP[b+8];f=0}else{e=IHEAP[b+56];f=2}c=f==0?c:e;e=IHEAP[b+60];f=IHEAP[b+72];_cio_read(f,2);e=_cio_read(f,IHEAP[e+16]<=256?1:2);f=_cio_read(f,1);IHEAP[IHEAP[c+5584]+1076*e]=f;_j2k_read_cox(b,e)}_j2k_read_coc.__index__=Runtime.getFunctionIndex(_j2k_read_coc,"_j2k_read_coc");
function _j2k_read_rgn(b){var f=null,e,c;f=IHEAP[b+64];if(IHEAP[b+4]==16){e=IHEAP[f+108]+5588*IHEAP[b+8];f=0}else{c=IHEAP[b+56];f=2}e=f==0?e:c;c=IHEAP[b+72];b=IHEAP[IHEAP[b+60]+16];_cio_read(c,2);b=_cio_read(c,b<=256?1:2);_cio_read(c,1);c=_cio_read(c,1);IHEAP[IHEAP[e+5584]+1076*b+808]=c}_j2k_read_rgn.__index__=Runtime.getFunctionIndex(_j2k_read_rgn,"_j2k_read_rgn");
function _j2k_read_qcd(b){var f=null,e,c,a,d;a=IHEAP[b+72];d=IHEAP[b+60];e=_cio_read(a,2);c=IHEAP[a+24]-IHEAP[a+16];if(0<IHEAP[d+16]){e=e-2;d=d+16;for(f=0;;){h=f==0?0:h;f=1+h;var g=0+h;IHEAP[a+24]=IHEAP[a+16]+c;_j2k_read_qcx(b,g,e);var h=h+1;if(f<IHEAP[d])f=1;else break}}}_j2k_read_qcd.__index__=Runtime.getFunctionIndex(_j2k_read_qcd,"_j2k_read_qcd");
function _j2k_read_qcc(b){var f,e,c;e=IHEAP[IHEAP[b+60]+16];c=IHEAP[b+72];f=_cio_read(c,2);c=_cio_read(c,e<=256?1:2);_j2k_read_qcx(b,c,f+-2+(0-(e<=256?1:2)))}_j2k_read_qcc.__index__=Runtime.getFunctionIndex(_j2k_read_qcc,"_j2k_read_qcc");
function _j2k_read_poc(b){var f=null,e,c,a,d,g;a=IHEAP[IHEAP[b+60]+16];d=IHEAP[b+64];if(IHEAP[b+4]==16){g=IHEAP[d+108]+5588*IHEAP[b+8];f=0}else{c=IHEAP[b+56];f=2}g=f==0?g:c;b=IHEAP[b+72];if(IHEAP[g+424]!=0){e=IHEAP[g+420]+1;f=3}else f=9;c=f==3?e:0;IHEAP[g+424]=1;e=(_cio_read(b,2)-2)/((a<=256?1:2)*2+5)|0;if(c<c+e){d=a<=256?1:2;var h=a<=256?1:2,i=c+e;f=c+1;i=(i>f?i:f)-c;for(f=5;;){p=f==5?0:p;var j=c+p;f=g+428+j*148+36;var k=g+428+j*148+16,m=g+428+j*148+12,l=g+428+j*148+8,n=g+428+j*148+4;j=g+428+j*148;
var o=_cio_read(b,1);IHEAP[j]=o;j=_cio_read(b,d);IHEAP[n]=j;n=_cio_read(b,2);IHEAP[l]=n;l=_cio_read(b,1);IHEAP[m]=l;m=_cio_read(b,h);IHEAP[k]=m<a?m:a;k=_cio_read(b,1);IHEAP[f]=k;var p=p+1;if(p!=i)f=6;else break}}IHEAP[g+420]=e+-1+c}_j2k_read_poc.__index__=Runtime.getFunctionIndex(_j2k_read_poc,"_j2k_read_poc");
function _j2k_read_tlm(b){var f=null,e,c,a;a=IHEAP[b+72];e=_cio_read(a,2);_cio_read(a,1);f=_cio_read(a,1);b=(f>>4&2)+(f>>4&1);f=f>>6&1;c=(e-4)/((f+1)*2+b)|0;if(0<c){e=f!=0?4:2;c=(c>1?c:1)-0;for(f=0;;){d=f==0?0:d;_cio_read(a,b);_cio_read(a,e);var d=d+1;if(d!=c)f=1;else break}}}_j2k_read_tlm.__index__=Runtime.getFunctionIndex(_j2k_read_tlm,"_j2k_read_tlm");
function _j2k_read_plm(b){var f=null,e;b=IHEAP[b+72];e=_cio_read(b,2);_cio_read(b,1);var c=e-3;e=c;if(c>0){e=e;f=3;a:for(;;){var a=f==3?e:h;c=_cio_read(b,4);var d=a+-4;a=a+-5;for(f=1;;){f=f==6?j:0;var g=f*-1,h=d+g,i=a+g;if(!(c+g>0))break;_cio_read(b,1);if(i<=0)break a;var j=f+1;f=6}if(h>0)f=0;else break a}}}_j2k_read_plm.__index__=Runtime.getFunctionIndex(_j2k_read_plm,"_j2k_read_plm");
function _j2k_read_plt(b){var f=null;b=IHEAP[b+72];f=_cio_read(b,2);_cio_read(b,1);f=f-3;if(f>0){var e=0-f;e=f+(e>-1?e:-1)+1;for(f=0;;){c=f==0?0:c;_cio_read(b,1);var c=c+1;if(c!=e)f=1;else break}}}_j2k_read_plt.__index__=Runtime.getFunctionIndex(_j2k_read_plt,"_j2k_read_plt");
function _j2k_read_ppm(b){var f=null,e,c,a;a=IHEAP[b+64];b=IHEAP[b+72];e=_cio_read(b,2);IHEAP[a+92]=1;c=_cio_read(b,1);var d=e-3;e=d;if(d>0){d=a+100;var g=a+96;c=c==0;var h=a+84,i=a+84,j=a+88,k=a+104,m=a+84,l=a+100,n=a+96,o=a+84,p=a+96,r=a+84,q=a+84,u=a+88,s=a+96,t=a+104;a=a+100;e=e;f=0;a:for(;;){var v=f==0?e:P;if(IHEAP[d]==0){var y=_cio_read(b,4),x=v-4;f=2}else{var w=IHEAP[a];f=4}P=f==4?w:y;var C=f==4?v:x;v=IHEAP[g];if(c){var z=_malloc(P);IHEAP[h]=z;IHEAP[j]=IHEAP[i];IHEAP[k]=P}else{z=_realloc(IHEAP[o],
IHEAP[p]+P);IHEAP[r]=z;IHEAP[u]=IHEAP[q];IHEAP[t]=IHEAP[s]+P}z=C*-1;var A=-1-P;A=-2-P-(A>-1?A:-1);var B=z>A?z:A;z=P+1+B;var D=C+B,J=C+1+B;A=v-B;B=v+-1-B;C=C+-1;for(f=6;;){f=f==10?S:0;var E=f*-1,N=C+E,Q=v+f;if(!(P+E>0)){f=7;break}E=_cio_read(b,1)&255;IHEAP[IHEAP[m]+Q]=E;if(N==0){f=8;break}var S=f+1;f=10}var P=f==8?D:J;v=f==8?A:B;IHEAP[l]=z-1;IHEAP[n]=v;if(P>0)f=9;else break a}}}_j2k_read_ppm.__index__=Runtime.getFunctionIndex(_j2k_read_ppm,"_j2k_read_ppm");
function _j2k_read_ppt(b){var f=null,e,c,a;a=IHEAP[IHEAP[b+64]+108]+5588*IHEAP[b+8];b=IHEAP[b+72];e=_cio_read(b,2);c=_cio_read(b,1);IHEAP[a+5172]=1;if(c==0){c=_malloc(e-3);IHEAP[a+5164]=c;IHEAP[a+5168]=IHEAP[a+5164];IHEAP[a+5176]=0;IHEAP[a+5180]=e-3}else{c=_realloc(IHEAP[a+5164],e+-3+IHEAP[a+5176]);IHEAP[a+5164]=c;IHEAP[a+5168]=IHEAP[a+5164];IHEAP[a+5180]=e+-3+IHEAP[a+5176]}c=IHEAP[a+5176];var d=e-3;if(d>0){e=a+5164;c=c;var g=0-d;f=g>-1?g:-1;g=d+c+f;d=d+f+1;for(f=1;;){i=f==1?0:i;f=c+i;var h=_cio_read(b,
1)&255;IHEAP[IHEAP[e]+f]=h;var i=i+1;if(i!=d)f=2;else break}c=g+1}IHEAP[a+5176]=c}_j2k_read_ppt.__index__=Runtime.getFunctionIndex(_j2k_read_ppt,"_j2k_read_ppt");function _j2k_read_crg(b){var f=null,e;e=IHEAP[b+72];f=IHEAP[IHEAP[b+60]+16];_cio_read(e,2);if(0<f){b=(f>1?f:1)-0;for(f=0;;){c=f==0?0:c;_cio_read(e,2);_cio_read(e,2);var c=c+1;if(c!=b)f=1;else break}}}_j2k_read_crg.__index__=Runtime.getFunctionIndex(_j2k_read_crg,"_j2k_read_crg");
function _j2k_read_com(b){b=IHEAP[b+72];var f=_cio_read(b,2)-2;IHEAP[b+24]+=f}_j2k_read_com.__index__=Runtime.getFunctionIndex(_j2k_read_com,"_j2k_read_com");function _j2k_read_unk(b){_opj_event_msg(IHEAP[b],2,__str795)}_j2k_read_unk.__index__=Runtime.getFunctionIndex(_j2k_read_unk,"_j2k_read_unk");function _j2k_create_decompress(b){var f;f=_calloc(1,76);if(f!=0){var e=_calloc(1,5588);IHEAP[f+56]=e;if(IHEAP[f+56]!=0){IHEAP[f]=b;IHEAP[f+48]=0;b=f}else{_free(f);b=0}}else b=0;return b}
_j2k_create_decompress.__index__=Runtime.getFunctionIndex(_j2k_create_decompress,"_j2k_create_decompress");
function _j2k_destroy_decompress(b){var f=null,e;IHEAP[b+52]!=0&&_free(IHEAP[b+52]);IHEAP[b+48]!=0&&_free(IHEAP[b+48]);if(IHEAP[b+56]!=0){e=IHEAP[b+56];IHEAP[e+5168]!=0&&_free(IHEAP[e+5168]);IHEAP[IHEAP[b+56]+5584]!=0&&_free(IHEAP[IHEAP[b+56]+5584]);_free(IHEAP[b+56])}if(IHEAP[b+64]!=0){e=IHEAP[b+64];if(IHEAP[e+108]!=0){if(0<IHEAP[e+72]*IHEAP[e+68]){var c=e+108,a=e+108,d=e+108,g=e+108,h=e+68,i=e+72;for(f=5;;){k=f==5?0:k;var j=0+k;f=1+k;IHEAP[IHEAP[c]+5588*j+5168]!=0&&_free(IHEAP[IHEAP[a]+5588*j+5168]);
IHEAP[IHEAP[d]+5588*j+5584]!=0&&_free(IHEAP[IHEAP[g]+5588*j+5584]);var k=k+1;if(f<IHEAP[i]*IHEAP[h])f=9;else break}}_free(IHEAP[e+108])}IHEAP[e+88]!=0&&_free(IHEAP[e+88]);IHEAP[e+76]!=0&&_free(IHEAP[e+76]);IHEAP[e+64]!=0&&_free(IHEAP[e+64]);_free(e)}_free(b)}_j2k_destroy_decompress.__index__=Runtime.getFunctionIndex(_j2k_destroy_decompress,"_j2k_destroy_decompress");
function _j2k_setup_decoder(b,f){var e,c=b!=0;a:do if(c){if(f==0)break a;e=_calloc(1,116);IHEAP[e+36]=IHEAP[f];IHEAP[e+40]=IHEAP[f+4];IHEAP[e+44]=IHEAP[f+8220];IHEAP[b+64]=e}while(0)}_j2k_setup_decoder.__index__=Runtime.getFunctionIndex(_j2k_setup_decoder,"_j2k_setup_decoder");
function _j2k_decode(b,f,e){var c,a=null,d,g;g=IHEAP[b];IHEAP[b+72]=f;IHEAP[b+68]=e;e!=0&&_llvm_memset_p0i8_i32(e,0,92,1,0);e=_calloc(1,36);IHEAP[b+60]=e;IHEAP[b+4]=1;var h=b+4,i=b+64,j=b+4,k=b+4,m=b+4;a:for(;;){var l=_cio_read(f,2);if(l>>8!=255){c=3;break a}else a=2;for(;;){c=a==8?o:0;var n=_j2k_dec_mstab+c*12;a=n;if(IHEAP[a]==0)break;if(IHEAP[a]==l)break;var o=c+1;a=8}if((IHEAP[n+4]&IHEAP[h])==0){c=10;break a}if(IHEAP[n]==65424)if(IHEAP[IHEAP[i]+44]==1){c=11;break a}IHEAP[n+8]!=0&&FUNCTION_TABLE[IHEAP[n+
8]](b);if((IHEAP[j]&128)!=0){c=14;break a}if(IHEAP[k]==32){c=16;break a}if(IHEAP[m]==64){c=16;break a}else c=2}if(c==3){b=l;_opj_image_destroy(e);_opj_event_msg(g,1,__str488,Pointer_make([IHEAP[f+24]+-2+(0-IHEAP[f+16]),0,0,0,b,0,0,0],0,ALLOC_STACK));d=0}else if(c==10){b=l;_opj_image_destroy(e);_opj_event_msg(g,1,__str1589,Pointer_make([IHEAP[f+24]+-2+(0-IHEAP[f+16]),0,0,0,b,0,0,0],0,ALLOC_STACK));d=0}else if(c==11){_opj_event_msg(g,4,__str2690);d=e}else if(c==14)d=0;else if(c==16){IHEAP[b+4]==64&&
_j2k_read_eoc(b);IHEAP[b+4]!=32&&_opj_event_msg(g,2,__str3791);d=e}return d}_j2k_decode.__index__=Runtime.getFunctionIndex(_j2k_decode,"_j2k_decode");
function _j2k_decode_jpt_stream(b,f){var e=STACKTOP;STACKTOP+=28;_memset(e,0,28);var c,a=null,d,g,h,i;i=IHEAP[b];IHEAP[b+72]=f;g=_calloc(1,36);IHEAP[b+60]=g;IHEAP[b+4]=1;IHEAP[e]=0;IHEAP[e+4]=0;IHEAP[e+8]=0;IHEAP[e+12]=0;IHEAP[e+16]=0;IHEAP[e+20]=0;IHEAP[e+24]=0;_jpt_read_msg_header(i,f,e);h=IHEAP[f+24]-IHEAP[f+16];if(IHEAP[e+8]!=6){_opj_image_destroy(g);_opj_event_msg(i,1,__str4892,Pointer_make([IHEAP[e+8],0,0,0],0,ALLOC_STACK));d=0}else{var j=e+20,k=e+8,m=b+4,l=b+4,n=b+4;a=0;a:for(;;){p=a==0?h:
p;if(IHEAP[f+20]-IHEAP[f+24]==0){c=4;break a}if(0-p+IHEAP[f+24]+(0-IHEAP[f+16])==IHEAP[j]){_jpt_read_msg_header(i,f,e);var o=IHEAP[f+24]-IHEAP[f+16];if(IHEAP[k]!=4){c=6;break a}else a=5}else a=3;var p=a==5?o:p,r=_cio_read(f,2);if(r>>8!=255){c=9;break a}else a=8;for(;;){a=a==13?u:0;var q=_j2k_dec_mstab+a*12;c=q;if(IHEAP[c]==0)break;if(IHEAP[c]==r)break;var u=a+1;a=13}if((IHEAP[q+4]&IHEAP[m])==0){c=15;break a}IHEAP[q+8]!=0&&FUNCTION_TABLE[IHEAP[q+8]](b);if(IHEAP[l]==32){c=17;break a}if(IHEAP[n]==64){c=
17;break a}else{a=18;c=1}}if(c==4){_j2k_read_eoc(b);d=g}else if(c==6){_opj_image_destroy(g);_opj_event_msg(i,1,__str593);d=0}else if(c==9){d=r;_opj_image_destroy(g);_opj_event_msg(i,1,__str488,Pointer_make([IHEAP[f+24]+-2+(0-IHEAP[f+16]),0,0,0,d,0,0,0],0,ALLOC_STACK));d=0}else if(c==15){d=r;_opj_image_destroy(g);_opj_event_msg(i,1,__str1589,Pointer_make([IHEAP[f+24]+-2+(0-IHEAP[f+16]),0,0,0,d,0,0,0],0,ALLOC_STACK));d=0}else if(c==17){IHEAP[b+4]==64&&_j2k_read_eoc(b);IHEAP[b+4]!=32&&_opj_event_msg(i,
2,__str3791);d=g}}g=d;STACKTOP=e;return g}_j2k_decode_jpt_stream.__index__=Runtime.getFunctionIndex(_j2k_decode_jpt_stream,"_j2k_decode_jpt_stream");function _j2k_create_compress(b){var f;f=_calloc(1,76);if(f!=0)IHEAP[f]=b;return f}_j2k_create_compress.__index__=Runtime.getFunctionIndex(_j2k_create_compress,"_j2k_create_compress");
function _j2k_destroy_compress(b){var f=null,e;if(b!=0){if(IHEAP[b+64]!=0){e=IHEAP[b+64];IHEAP[e+64]!=0&&_free(IHEAP[e+64]);IHEAP[e+112]!=0&&_free(IHEAP[e+112]);if(0<IHEAP[e+72]*IHEAP[e+68]){var c=e+108,a=e+68,d=e+72;for(f=2;;){g=f==2?0:g;f=1+g;_free(IHEAP[IHEAP[c]+5588*(0+g)+5584]);var g=g+1;if(f<IHEAP[d]*IHEAP[a])f=3;else break}}_free(IHEAP[e+108]);_free(e)}_free(b)}}_j2k_destroy_compress.__index__=Runtime.getFunctionIndex(_j2k_destroy_compress,"_j2k_destroy_compress");
function _j2k_setup_encoder(b,f,e){var c,a=null,d,g,h,i,j,k,m=b!=0;a:do if(m){if(f==0)break a;if(e==0)break a;j=_calloc(1,116);IHEAP[b+64]=j;IHEAP[j+68]=1;IHEAP[j+72]=1;IHEAP[j]=IHEAP[f+18676];IHEAP[j+4]=IHEAP[f+18680];IHEAP[j+12]=IHEAP[f+18684];IHEAP[j+24]=IHEAP[f+20];IHEAP[j+28]=IHEAP[f+24];IHEAP[j+32]=IHEAP[f+28];if(IHEAP[f+32]!=0){d=IHEAP[f+4788]*12*IHEAP[f+5592];g=_malloc(d);IHEAP[j+112]=g;_llvm_memcpy_p0i8_p0i8_i32(IHEAP[j+112],IHEAP[f+32],d,1,0)}IHEAP[j+56]=IHEAP[f+12];IHEAP[j+60]=IHEAP[f+
16];IHEAP[j+48]=IHEAP[f+4];IHEAP[j+52]=IHEAP[f+8];d=IHEAP[f+36]!=0;b:do if(d){g=_strlen(IHEAP[f+36])+1;g=_malloc(g);IHEAP[j+64]=g;if(IHEAP[j+64]==0)break b;_strcpy(IHEAP[j+64],IHEAP[f+36])}while(0);d=IHEAP[e+8]-IHEAP[j+48];g=j+56;if(IHEAP[f]!=0){g=IHEAP[g];d=d;g=g;IHEAP[j+68]=(d+-1+g)/g|0;g=IHEAP[j+60];d=IHEAP[e+12]-IHEAP[j+52];g=g;IHEAP[j+72]=(d+-1+g)/g|0}else{IHEAP[g]=d;IHEAP[j+60]=IHEAP[e+12]-IHEAP[j+52]}if(IHEAP[f+18688]!=0){IHEAP[j+17]=IHEAP[f+18689];IHEAP[j+16]=1}h=IHEAP[j+8]=0;d=h<IHEAP[e+
16];b:do if(d){g=e+24;for(var l=e+24,n=e+24,o=e+16;;){IHEAP[j+8]+=IHEAP[IHEAP[l]+48*h+12]*IHEAP[IHEAP[g]+48*h+8]*IHEAP[IHEAP[n]+48*h+24];h+=1;if(!(h<IHEAP[o]))break b}}while(0);d=_calloc(IHEAP[j+72]*IHEAP[j+68],5588);IHEAP[j+108]=d;if(!(0<IHEAP[j+72]*IHEAP[j+68]))break a;d=e+16;g=e+16;l=e+24;n=e+16;a=11;b:for(;;){V=a==11?0:V;k=0+V;o=1+V;var p=IHEAP[j+108];IHEAP[p+5588*k+12]=IHEAP[f+4788];i=0;h=i<IHEAP[p+5588*k+12];c:do if(h){a=p+5588*k+12;c=p+5588*k+5184;for(var r=p+5588*k+20,q=p+5588*k+5184,u=p+
5588*k+20;;){var s=IHEAP[j+32]!=0;if(IHEAP[j]!=0){if(s)FHEAP[c+4*i]=FHEAP[f+5192+i*4];FHEAP[r+4*i]=FHEAP[f+4792+i*4]}else{var t=i,v=f;if(s)FHEAP[q+4*i]=FHEAP[v+5192+t*4];else FHEAP[u+4*i]=FHEAP[v+4792+t*4]}i+=1;if(!(i<IHEAP[a]))break c}}while(0);IHEAP[p+5588*k+4]=IHEAP[f+40];IHEAP[p+5588*k+8]=IHEAP[f+44];IHEAP[p+5588*k+16]=IHEAP[f+18690];IHEAP[p+5588*k+424]=0;if(IHEAP[f+4784]!=0){IHEAP[p+5588*k+424]=1;h=0;i=h<IHEAP[f+4784];c:do if(i){r=p+5588*k+428+48;q=p+5588*k+428+32;u=p+5588*k+428+16;s=p+5588*
k+428+12;t=p+5588*k+428+8;v=p+5588*k+428+4;var y=p+5588*k+428;a=17;for(;;){C=a==17?0:C;var x=k==IHEAP[f+48+h*148+48]-1;e:do if(x)c=20;else{if(IHEAP[f+48+h*148+48]==-1){a=19;c=20}else{a=19;c=21}break e}while(0);if(c==20){IHEAP[y+148*C]=IHEAP[f+48+C*148];IHEAP[v+4*C*37]=IHEAP[f+48+C*148+4];IHEAP[t+4*C*37]=IHEAP[f+48+C*148+8];IHEAP[s+4*C*37]=IHEAP[f+48+C*148+12];IHEAP[u+4*C*37]=IHEAP[f+48+C*148+16];IHEAP[q+4*C*37]=IHEAP[f+48+C*148+32];IHEAP[r+4*C*37]=IHEAP[f+48+C*148+48];var w=C+1;a=20}var C=a==19?C:
w;h+=1;if(h<IHEAP[f+4784])a=21;else{a=21;break c}}}else a=68;while(0);IHEAP[p+5588*k+420]=(a==68?0:C)-1}else IHEAP[p+5588*k+420]=0;h=_calloc(IHEAP[d],1076);IHEAP[p+5588*k+5584]=h;h=0;if(h<IHEAP[g]){p=p+5588*k+5584;c:for(;;){k=IHEAP[p]+1076*h;IHEAP[k]=IHEAP[f+40]&1;IHEAP[k+4]=IHEAP[f+5592];i=IHEAP[f+5596];if(i>1){a=27;c=28}else{a=27;c=29}d:for(;;)if(c==28){B=a==28?B:0;var z=B+1,A=(a==28?A:i)>>1,B=B+1;if(A>1)c=a=28;else{a=28;c=29}}else if(c==29){IHEAP[k+8]=a==27?0:z;var D=IHEAP[f+5600];if(D>1){a=29;
c=30}else{a=29;c=31}break d}d:for(;;)if(c==30){N=a==30?N:0;var J=N+1,E=(a==30?E:D)>>1,N=N+1;if(E>1)c=a=30;else{a=30;c=31}}else if(c==31){IHEAP[k+12]=a==29?0:J;IHEAP[k+16]=IHEAP[f+5604];IHEAP[k+20]=IHEAP[f+5608]!=0?0:1;IHEAP[k+24]=IHEAP[f+5608]!=0?2:0;IHEAP[k+804]=2;c=h==IHEAP[f+5612]?32:33;break d}if(c==32)IHEAP[k+808]=IHEAP[f+5616];else if(c==33)IHEAP[k+808]=0;r=IHEAP[f+18676]!=0;d:do if(r){IHEAP[k+812]=7;IHEAP[k+944]=7;i=1;if(!(i<IHEAP[k+4]))break d;for(;;){IHEAP[k+812+i*4]=8;IHEAP[k+944+i*4]=8;
i+=1;if(!(i<IHEAP[k+4]))break d}}else if((IHEAP[f+40]&1)!=0){i=a=IHEAP[k+4]-1;if(a>=0)a=38;else break d;for(;;){T=a==51?T:0;q=T+1;u=T<IHEAP[f+5620];s=f;f:do if(u){t=IHEAP[s+5624+T*4]<1;g:do if(t)IHEAP[k+812+i*4]=1;else{v=IHEAP[f+5624+T*4];if(v>1){a=42;c=43}else{a=42;c=44}for(;;)if(c==43){P=a==43?P:0;var Q=P+1,S=(a==43?S:v)>>1,P=P+1;if(S>1)c=a=43;else{a=43;c=44}}else if(c==44){IHEAP[k+812+i*4]=a==42?0:Q;break g}}while(0);if(IHEAP[f+5756+T*4]<1)IHEAP[k+944+i*4]=1;else{t=IHEAP[f+5756+T*4];if(t>1){a=
48;c=49}else{a=48;c=50}for(;;)if(c==49){L=a==49?L:0;var G=L+1,F=(a==49?F:t)>>1,L=L+1;if(F>1)c=a=49;else{a=49;c=50}}else if(c==50){IHEAP[k+944+i*4]=a==48?0:G;break f}}}else{a=IHEAP[s+5620];t=IHEAP[f+5624+(a-1)*4]>>q-a;v=IHEAP[f+5756+(a-1)*4]>>q-a;y=t<1;g:do if(y)IHEAP[k+812+i*4]=1;else{if(t>1){a=54;c=55}else{a=54;c=56}for(;;)if(c==55){M=a==55?M:0;var K=M+1,H=(a==55?H:t)>>1,M=M+1;if(H>1)c=a=55;else{a=55;c=56}}else if(c==56){IHEAP[k+812+i*4]=a==54?0:K;break g}}while(0);if(v<1)IHEAP[k+944+i*4]=1;else{if(v>
1){a=59;c=60}else{a=59;c=61}for(;;)if(c==60){R=a==60?R:0;var I=R+1,O=(a==60?O:v)>>1,R=R+1;if(O>1)c=a=60;else{a=60;c=61}}else if(c==61){IHEAP[k+944+i*4]=a==59?0:I;break f}}}while(0);var T=T+1;i=a=i+-1;if(a>=0)a=51;else break d}}else{i=0;if(!(i<IHEAP[k+4]))break d;for(;;){IHEAP[k+812+i*4]=15;IHEAP[k+944+i*4]=15;i+=1;if(!(i<IHEAP[k+4]))break d}}while(0);_dwt_calc_explicit_stepsizes(k,IHEAP[IHEAP[l]+48*h+24]);h+=1;if(!(h<IHEAP[n]))break c}}var V=V+1;if(o<IHEAP[j+72]*IHEAP[j+68])a=66;else break b}}while(0)}
_j2k_setup_encoder.__index__=Runtime.getFunctionIndex(_j2k_setup_encoder,"_j2k_setup_encoder");
function _j2k_encode(b,f,e,c){var a,d=null,g,h,i,j,k,m,l,n,o,p,r,q;IHEAP[b+72]=f;IHEAP[b+60]=e;r=IHEAP[b+64];IHEAP[b+68]=c;if(c!=0){d=_malloc(IHEAP[r+68]*572*IHEAP[r+72]);IHEAP[c+88]=d;IHEAP[c+16]=IHEAP[e+8]-IHEAP[e];IHEAP[c+20]=IHEAP[e+12]-IHEAP[e+4];IHEAP[c+24]=IHEAP[IHEAP[r+108]+8];IHEAP[c+44]=IHEAP[r+68];IHEAP[c+48]=IHEAP[r+72];IHEAP[c+28]=IHEAP[r+56];IHEAP[c+32]=IHEAP[r+60];IHEAP[c+36]=IHEAP[r+48];IHEAP[c+40]=IHEAP[r+52];IHEAP[c+52]=IHEAP[e+16];IHEAP[c+56]=IHEAP[IHEAP[r+108]+12];d=_malloc(IHEAP[e+
16]*4);IHEAP[c+60]=d;if(0<IHEAP[e+16]){o=e+16;for(d=0;;){n=d==0?0:n;d=1+n;IHEAP[IHEAP[c+60]+4*(0+n)]=IHEAP[IHEAP[IHEAP[r+108]+5584]+4]-1;n=n+1;if(d<IHEAP[o])d=1;else break}}FHEAP[c]=0;IHEAP[c+76]=IHEAP[f+24]-IHEAP[f+16];IHEAP[c+72]=100;d=_malloc(IHEAP[c+72]*12);IHEAP[c+68]=d;IHEAP[c+64]=0}_cio_write(IHEAP[b+72],65359,2);o=IHEAP[b+72];d=IHEAP[b+60];p=IHEAP[b+64];_cio_write(o,65361,2);n=IHEAP[o+24]-IHEAP[o+16];IHEAP[o+24]+=2;_cio_write(o,IHEAP[p+12],2);_cio_write(o,IHEAP[d+8],4);_cio_write(o,IHEAP[d+
12],4);_cio_write(o,IHEAP[d],4);_cio_write(o,IHEAP[d+4],4);_cio_write(o,IHEAP[p+56],4);_cio_write(o,IHEAP[p+60],4);_cio_write(o,IHEAP[p+48],4);_cio_write(o,IHEAP[p+52],4);_cio_write(o,IHEAP[d+16],2);if(0<IHEAP[d+16]){p=d+24;var u=d+24,s=d+24;g=d+24;a=d+16;for(d=5;;){j=d==5?0:j;var t=0+j,v=1+j;_cio_write(d==5?o:k,IHEAP[IHEAP[p]+48*t+24]+-1+IHEAP[IHEAP[u]+48*t+32]*128,1);_cio_write(o,IHEAP[IHEAP[s]+48*t],1);_cio_write(o,IHEAP[IHEAP[g]+48*t+4],1);k=o;j=j+1;if(v<IHEAP[a])d=6;else break}d=7}else d=85;
d=d==7?k:o;d=0-IHEAP[d+16]+IHEAP[d+24]+(0-n);IHEAP[o+24]=IHEAP[o+16]+n;_cio_write(o,d,2);IHEAP[o+24]=IHEAP[o+16]+(d+n);k=IHEAP[b+72];_cio_write(k,65362,2);d=IHEAP[k+24]-IHEAP[k+16];IHEAP[k+24]+=2;j=IHEAP[IHEAP[b+64]+108]+5588*IHEAP[b+8];_cio_write(k,IHEAP[j+4],1);_cio_write(k,IHEAP[j+8],1);_cio_write(k,IHEAP[j+12],2);_cio_write(k,IHEAP[j+16],1);_j2k_write_cox(b,0);j=0-IHEAP[k+16]+IHEAP[k+24]+(0-d);IHEAP[k+24]=IHEAP[k+16]+d;_cio_write(k,j,2);IHEAP[k+24]=IHEAP[k+16]+(j+d);j=IHEAP[b+72];_cio_write(j,
65372,2);d=IHEAP[j+24]-IHEAP[j+16];IHEAP[j+24]+=2;_j2k_write_qcx(b,0);k=0-IHEAP[j+16]+IHEAP[j+24]+(0-d);IHEAP[j+24]=IHEAP[j+16]+d;_cio_write(j,k,2);IHEAP[j+24]=IHEAP[j+16]+(k+d);k=IHEAP[r]!=0;a:do if(k){d=1;if(!(d<IHEAP[e+16]))break a;j=e+16;n=d;o=n+1;for(d=9;;){l=d==9?0:l;d=o+l;p=n+l;_j2k_write_coc(b,p);_j2k_write_qcc(b,p);l=l+1;if(d<IHEAP[j])d=11;else break}}while(0);d=0;if(d<IHEAP[e+16]){l=e+16;k=d;j=k+1;for(d=14;;){m=d==14?0:m;o=k+m;n=j+m;if(IHEAP[IHEAP[IHEAP[(d==14?r:i)+108]+5584]+1076*o+808]!=
0){p=b;d=IHEAP[IHEAP[p+64]+108];i=IHEAP[p+72];p=IHEAP[IHEAP[p+60]+16];_cio_write(i,65374,2);_cio_write(i,p<=256?5:6,2);_cio_write(i,o,p<=256?1:2);_cio_write(i,0,1);_cio_write(i,IHEAP[IHEAP[d+5584]+1076*o+808],1)}i=r;m=m+1;if(n<IHEAP[l])d=18;else break}d=19}else d=10;i=IHEAP[(d==19?i:r)+64]!=0;a:do if(i){d=b;if(IHEAP[IHEAP[d+64]+64]==0)break a;m=IHEAP[d+72];d=IHEAP[IHEAP[d+64]+64];_cio_write(m,65380,2);l=m;l=IHEAP[l+24]-IHEAP[l+16];k=m;IHEAP[k+24]+=2;_cio_write(m,1,2);j=0<_strlen(d);k=m;if(j){n=j=
d;q=m;for(d=23;;){h=d==23?0:h;o=1+h;_cio_write(d==23?k:q,IHEAP[j+(0+h)],1);d=_strlen(n);h=h+1;if(o<d)d=24;else break}d=25}else d=21;d=d==25?q:k;k=0-IHEAP[d+16]+IHEAP[d+24]+(0-l);j=l;d=m;j=j;IHEAP[d+24]=IHEAP[d+16]+j;_cio_write(m,k,2);l=k+l;d=m;m=l;IHEAP[d+24]=IHEAP[d+16]+m}while(0);q=_j2k_calculate_tp(r,IHEAP[e+16],e,b);IHEAP[b+28]=q;q=IHEAP[r]!=0;a:do if(q){d=b;i=h=IHEAP[d+72];IHEAP[d+24]=IHEAP[i+24]-IHEAP[i+16];_cio_write(h,65365,2);i=IHEAP[d+28]*5+4;_cio_write(h,i,2);_cio_write(h,0,1);_cio_write(h,
80,1);d=IHEAP[d+28]*5;h=h;d=d;IHEAP[h+24]+=d;if(IHEAP[r]!=3)break a;_j2k_write_poc(b)}while(0);if(c!=0)IHEAP[c+80]=IHEAP[f+24]+-1+(0-IHEAP[f+16]);q=_tcd_create(IHEAP[b]);if(0<IHEAP[r+72]*IHEAP[r+68]){h=q+12;i=q+16;m=e+16;l=e+16;d=32;a:for(;;){M=d==32?0:M;j=0+M;k=1+M;d=IHEAP[r+108];_opj_event_msg(IHEAP[b],4,__str694,Pointer_make([k,0,0,0,IHEAP[r+72]*IHEAP[r+68],0,0,0],0,ALLOC_STACK));IHEAP[b+8]=j;IHEAP[b+16]=0;IHEAP[h]=IHEAP[IHEAP[b+20]+4*IHEAP[b+8]];n=r;o=IHEAP[b+8];j==0?_tcd_malloc_encode(q,e,n,
o):_tcd_init_encode(q,e,n,o);if(c!=0)IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+8]=0-IHEAP[f+16]+IHEAP[f+24]+IHEAP[b+44];if(0<=IHEAP[d+5588*j+420]){n=d+5588*j+420;d=37;b:for(;;){o=d==37?0:H;p=d==37?0:K;u=o+1;IHEAP[i]=o;s=_j2k_get_num_tp(r,o,j);IHEAP[q]=IHEAP[r+20];if(0<s){d=38;a=39}else{d=38;a=40}c:for(;;)if(a==39){F=d==72?F:p;L=d==72?L:0;IHEAP[b+12]=L;if(c!=0)IHEAP[IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+568]+20*IHEAP[b+16]]=0-IHEAP[f+16]+IHEAP[f+24]+IHEAP[b+44];a=b;d=IHEAP[a+72];IHEAP[a+36]=IHEAP[d+24]-IHEAP[d+
16];_cio_write(d,65424,2);g=IHEAP[d+24]-IHEAP[d+16];IHEAP[d+24]+=2;_cio_write(d,IHEAP[a+8],2);IHEAP[d+24]+=4;_cio_write(d,IHEAP[a+16],1);_cio_write(d,IHEAP[IHEAP[a+20]+4*IHEAP[a+8]],1);a=0-IHEAP[d+16]+IHEAP[d+24]+(0-g);IHEAP[d+24]=IHEAP[d+16]+g;_cio_write(d,a,2);IHEAP[d+24]=IHEAP[d+16]+(a+g);g=IHEAP[b+16]==0;d:do if(g){if(IHEAP[r]!=0)break d;if(1<IHEAP[m]){d=44;a=46}else{d=44;a=47}for(;;)if(a==46){y=d==46?y:0;d=y+2;a=y+1;_j2k_write_coc(b,a);_j2k_write_qcc(b,a);var y=y+1;if(d<IHEAP[l])a=d=46;else{d=
46;a=47}}else if(a==47)if(IHEAP[IHEAP[r+108]+5588*j+420]!=0)break;else break d;_j2k_write_poc(b)}while(0);if(c!=0)IHEAP[IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+568]+20*IHEAP[b+16]+4]=IHEAP[f+24]+1+(0-IHEAP[f+16])+IHEAP[b+44];g=b;t=q;a=IHEAP[g+64];v=IHEAP[g+72];IHEAP[t+4]=IHEAP[g+12];IHEAP[t+8]=IHEAP[g+16];_cio_write(v,65427,2);if(IHEAP[g+8]==0)IHEAP[g+40]=0-IHEAP[v+16]+IHEAP[v+24]+IHEAP[g+44];var x=IHEAP[g+68];d=x!=0;d:do if(d)if(IHEAP[g+16]!=0){if(!(IHEAP[IHEAP[IHEAP[x+88]+572*IHEAP[g+8]+548]+20*(IHEAP[x+
8]-1)+8]<IHEAP[v+24]-IHEAP[v+16]))break d;IHEAP[IHEAP[IHEAP[x+88]+572*IHEAP[g+8]+548]+20*IHEAP[x+8]]=IHEAP[v+24]-IHEAP[v+16]}else{IHEAP[IHEAP[x+88]+572*IHEAP[g+8]+12]=IHEAP[v+24]+-1+(0-IHEAP[v+16])+IHEAP[g+44];IHEAP[IHEAP[IHEAP[g+68]+88]+572*IHEAP[g+8]+4]=IHEAP[g+8]}while(0);var w=IHEAP[g+8],C=IHEAP[a+108],z=C+5588*w,A=0<IHEAP[z+12];d:do if(A){var B=a+72,D=a+68,J=a+72,E=a+68,N=z+12;d=59;for(;;){P=d==59?0:P;d=P+1;var Q=C+5588*w+20+P*4,S=FHEAP[Q]>(IHEAP[g+40]/(IHEAP[D]*IHEAP[B])|0);f:do if(S)FHEAP[Q]-=
IHEAP[g+40]/(IHEAP[E]*IHEAP[J])|0;else{if(FHEAP[Q]==0)break f;FHEAP[Q]=1}while(0);var P=P+1;if(d<IHEAP[N])d=63;else break d}}while(0);d=IHEAP[g+16]==0;d:do if(d){IHEAP[IHEAP[IHEAP[t+24]+8]+836]=0;if(x==0)break d;IHEAP[x+8]=0}while(0);d=_tcd_encode_tile(t,IHEAP[g+8],IHEAP[v+24],IHEAP[v+20]+-2+(0-IHEAP[v+24]),x);d=0-IHEAP[v+16]+IHEAP[v+24]+d+(0-IHEAP[g+36]);IHEAP[v+24]=IHEAP[v+16]+(IHEAP[g+36]+6);_cio_write(v,d,4);IHEAP[v+24]=IHEAP[v+16]+(d+IHEAP[g+36]);if(IHEAP[a]!=0){IHEAP[v+24]=IHEAP[v+16]+(IHEAP[g+
24]+6+IHEAP[g+16]*5);_cio_write(v,IHEAP[g+8],1);_cio_write(v,d,4)}IHEAP[v+24]=IHEAP[v+16]+(d+IHEAP[g+36]);if(c!=0){IHEAP[IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+568]+20*IHEAP[b+16]+8]=IHEAP[f+24]+-1+(0-IHEAP[f+16])+IHEAP[b+44];IHEAP[IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+568]+20*IHEAP[b+16]+12]=F;IHEAP[IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+568]+20*IHEAP[b+16]+16]=IHEAP[c+8]-F;var G=IHEAP[c+8];d=70}else d=105;var F=d==70?G:F;IHEAP[b+16]+=1;var L=L+1;if(L!=s){d=72;a=39;continue c}d=73;a=40}else if(a==40){var K=d==73?
F:p,H=o+1;if(u<=IHEAP[n]){d=40;continue b}else break b}}}if(c!=0)IHEAP[IHEAP[c+88]+572*IHEAP[b+8]+16]=IHEAP[f+24]+-1+(0-IHEAP[f+16])+IHEAP[b+44];var M=M+1;if(k<IHEAP[r+72]*IHEAP[r+68])d=78;else break a}}_tcd_free_encode(q);if(q!=0){_free(IHEAP[q+24]);_free(q)}_free(IHEAP[b+20]);_cio_write(IHEAP[b+72],65497,2);if(c!=0){IHEAP[c+84]=0-IHEAP[f+16]+IHEAP[f+24]+IHEAP[b+44];IHEAP[c+84]-=IHEAP[c+76]}return 1}_j2k_encode.__index__=Runtime.getFunctionIndex(_j2k_encode,"_j2k_encode");
function _j2k_write_coc(b,f){var e,c,a,d;c=IHEAP[IHEAP[b+64]+108]+5588*IHEAP[b+8];a=IHEAP[b+60];d=IHEAP[b+72];_cio_write(d,65363,2);e=IHEAP[d+24]-IHEAP[d+16];IHEAP[d+24]+=2;_cio_write(d,f,IHEAP[a+16]<=256?1:2);_cio_write(d,IHEAP[IHEAP[c+5584]+1076*f],1);_j2k_write_cox(b,f);c=0-e+IHEAP[d+24]+(0-IHEAP[d+16]);IHEAP[d+24]=IHEAP[d+16]+e;_cio_write(d,c,2);IHEAP[d+24]=IHEAP[d+16]+(c+e)}_j2k_write_coc.__index__=Runtime.getFunctionIndex(_j2k_write_coc,"_j2k_write_coc");
function _j2k_write_qcc(b,f){var e,c,a;a=IHEAP[b+72];_cio_write(a,65373,2);e=IHEAP[a+24]-IHEAP[a+16];IHEAP[a+24]+=2;_cio_write(a,f,IHEAP[IHEAP[b+60]+16]<=256?1:2);_j2k_write_qcx(b,f);c=0-e+IHEAP[a+24]+(0-IHEAP[a+16]);IHEAP[a+24]=IHEAP[a+16]+e;_cio_write(a,c,2);IHEAP[a+24]=IHEAP[a+16]+(c+e)}_j2k_write_qcc.__index__=Runtime.getFunctionIndex(_j2k_write_qcc,"_j2k_write_qcc");
function _j2k_write_poc(b){var f=null,e,c,a,d;c=IHEAP[IHEAP[b+60]+16];a=IHEAP[IHEAP[b+64]+108]+5588*IHEAP[b+8];d=IHEAP[a+5584];b=IHEAP[b+72];e=IHEAP[a+420]+1;_cio_write(b,65375,2);_cio_write(b,((c<=256?1:2)*2+5)*e+2,2);if(0<e){var g=c<=256?1:2,h=a+12;d=d+4;var i=c<=256?1:2;e=(e>1?e:1)-0;for(f=0;;){o=f==0?0:o;var j=0+o;f=a+428+j*148+36;var k=a+428+j*148+16,m=a+428+j*148+12,l=a+428+j*148+8,n=a+428+j*148+4;_cio_write(b,IHEAP[a+428+j*148],1);_cio_write(b,IHEAP[n],g);_cio_write(b,IHEAP[l],2);j=IHEAP[l];
n=IHEAP[h];IHEAP[l]=j<n?j:n;_cio_write(b,IHEAP[m],1);l=IHEAP[m];j=IHEAP[d];IHEAP[m]=l<j?l:j;_cio_write(b,IHEAP[k],i);m=IHEAP[k];IHEAP[k]=m<c?m:c;_cio_write(b,IHEAP[f],1);var o=o+1;if(o!=e)f=1;else break}}}_j2k_write_poc.__index__=Runtime.getFunctionIndex(_j2k_write_poc,"_j2k_write_poc");
function _j2k_write_qcx(b,f){var e=null,c,a,d;a=IHEAP[IHEAP[IHEAP[b+64]+108]+5588*IHEAP[b+8]+5584]+1076*f;d=IHEAP[b+72];_cio_write(d,IHEAP[a+804]*32+IHEAP[a+24],1);if(IHEAP[a+24]==1)e=7;else{var g=IHEAP[a+4]*3-2;e=0}c=e==0?g:1;if(0<c){g=a+24;c=(c>1?c:1)-0;for(e=2;;){i=e==2?0:i;var h=0+i;e=IHEAP[a+28+h*8];h=IHEAP[a+28+h*8+4];IHEAP[g]==0?_cio_write(d,e<<3,1):_cio_write(d,h+e*2048,2);var i=i+1;if(i!=c)e=5;else break}}}_j2k_write_qcx.__index__=Runtime.getFunctionIndex(_j2k_write_qcx,"_j2k_write_qcx");
function _j2k_write_cox(b,f){var e=null,c,a;c=IHEAP[IHEAP[IHEAP[b+64]+108]+5588*IHEAP[b+8]+5584]+1076*f;a=IHEAP[b+72];_cio_write(a,IHEAP[c+4]-1,1);_cio_write(a,IHEAP[c+8]-2,1);_cio_write(a,IHEAP[c+12]-2,1);_cio_write(a,IHEAP[c+16],1);_cio_write(a,IHEAP[c+20],1);var d=(IHEAP[c]&1)!=0;a:do if(d){if(!(0<IHEAP[c+4]))break a;var g=a,h=c,i=c,j=c+4;for(e=0;;){m=e==0?0:m;e=1+m;var k=0+m;_cio_write(g,IHEAP[i+944+k*4]*16+IHEAP[h+812+k*4],1);var m=m+1;if(e<IHEAP[j])e=2;else break}}while(0)}
_j2k_write_cox.__index__=Runtime.getFunctionIndex(_j2k_write_cox,"_j2k_write_cox");
function _j2k_read_qcx(b,f,e){var c=null,a;c=IHEAP[b+64];if(IHEAP[b+4]==16){a=IHEAP[c+108]+5588*IHEAP[b+8];c=0}else{var d=IHEAP[b+56];c=2}f=IHEAP[(c==0?a:d)+5584]+1076*f;b=IHEAP[b+72];c=_cio_read(b,1);IHEAP[f+24]=c&31;IHEAP[f+804]=c>>5;a=IHEAP[f+24]==1;a:do if(a)c=21;else{var g=e-1;if(IHEAP[f+24]==0){c=3;break a}var h=g/2|0;c=5}while(0);a=c==21?1:c==5?h:g;c=0;e=IHEAP[f+24];if(c<a){g=f+24;h=c;c=h+1;a=(a>c?a:c)-h;for(c=7;;){n=c==7?0:n;var i=h+n;d=f+28+i*8+4;i=f+28+i*8;if((c==7?e:l)==0){var j=_cio_read(b,
1)>>>3;c=9}else{c=_cio_read(b,2);var k=c>>11,m=c&2047;c=11}l=c==11?m:0;IHEAP[i]=c==11?k:j;IHEAP[d]=l;var l=IHEAP[g],n=n+1;if(n!=a)c=12;else break}c=13}else c=4;if((c==13?l:e)==1){c=1;j=f+28;k=f+28;m=f+28+4;l=c;b=97-l;n=l+-1;for(c=15;;){p=c==15?0:p;c=n+p;g=l+p;e=f+28+g*8+4;g=f+28+g*8;if(IHEAP[j]-(c/3|0)>0){var o=IHEAP[k]-(c/3|0);c=17}else c=16;IHEAP[g]=c==17?o:0;IHEAP[e]=IHEAP[m];var p=p+1;if(p!=b)c=19;else break}}}_j2k_read_qcx.__index__=Runtime.getFunctionIndex(_j2k_read_qcx,"_j2k_read_qcx");
function _j2k_read_cox(b,f){var e=null,c,a,d;c=IHEAP[b+64];if(IHEAP[b+4]==16){a=IHEAP[c+108]+5588*IHEAP[b+8];e=0}else{d=IHEAP[b+56];e=2}a=IHEAP[(e==0?a:d)+5584]+1076*f;d=IHEAP[b+72];e=_cio_read(d,1)+1;IHEAP[a+4]=e;if(IHEAP[c+36]>=IHEAP[a+4]){_opj_event_msg(IHEAP[b],1,__str896,Pointer_make([f,0,0,0],0,ALLOC_STACK));IHEAP[b+4]|=128}e=_cio_read(d,1)+2;IHEAP[a+8]=e;e=_cio_read(d,1)+2;IHEAP[a+12]=e;e=_cio_read(d,1);IHEAP[a+16]=e;e=_cio_read(d,1);IHEAP[a+20]=e;c=(IHEAP[a]&1)!=0;a:do if(c){e=0;if(!(e<IHEAP[a+
4]))break a;var g=d,h=a,i=a,j=a+4,k=e,m=k+1;for(e=4;;){p=e==4?0:p;e=m+p;var l=k+p,n=i+944+l*4;l=h+812+l*4;var o=_cio_read(g,1);IHEAP[l]=o&15;IHEAP[n]=o>>4;var p=p+1;if(e<IHEAP[j])e=6;else break}}while(0);d=IHEAP[b+68]!=0;a:do if(d){if(f!=0)break a;e=0;if(!(e<IHEAP[a+4]))break a;c=p=a;g=b+8;h=b+68;i=a;j=b+8;k=b+68;m=a+4;n=b+8;l=b+68;o=b+8;var r=b+68,q=e,u=q+1;for(e=11;;){y=e==11?0:y;var s=q+y,t=c+812+s*4,v=i+944+s*4;e=u+y;if((IHEAP[p]&1)!=0){IHEAP[IHEAP[IHEAP[h]+88]+572*IHEAP[g]+284+s*4]=IHEAP[t];
IHEAP[IHEAP[IHEAP[k]+88]+572*IHEAP[j]+416+s*4]=IHEAP[v]}else{IHEAP[IHEAP[IHEAP[l]+88]+572*IHEAP[n]+284+s*4]=15;IHEAP[IHEAP[IHEAP[r]+88]+572*IHEAP[o]+284+s*4]=15}var y=y+1;if(e<IHEAP[m])e=14;else break}}while(0)}_j2k_read_cox.__index__=Runtime.getFunctionIndex(_j2k_read_cox,"_j2k_read_cox");
function _opj_clock(){var b=STACKTOP;STACKTOP+=8;_memset(b,0,8);var f,e;_gettimeofday(b,0);f=IHEAP[b]+IHEAP[b+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=f;e=f-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=f;STACKTOP=b;return e}_opj_clock.__index__=Runtime.getFunctionIndex(_opj_clock,"_opj_clock");
function _jp2_read_jp2h(b,f,e){var c=STACKTOP;STACKTOP+=36;_memset(c,0,36);var a,d=null,g,h,i,j,k,m,l,n,o,p,r,q,u,s=c+12,t,v=c+24,y;y=IHEAP[b];_jp2_read_boxhdr(y,f,v);t=v+4;u=v+4;p=v+4;a:for(;;){if(1785737832!=IHEAP[t]){if(IHEAP[u]==1785737827){a=2;break a}IHEAP[f+24]+=IHEAP[v]-8;if(IHEAP[f+24]>=IHEAP[f+20]){a=5;break a}_jp2_read_boxhdr(y,f,v)}if(1785737832!=IHEAP[p])a=1;else{a=9;break a}}a:do if(a==2){_opj_event_msg(y,1,__str1198);q=0}else if(a==5)q=0;else if(a==9){t=f;q=b;u=t;t=IHEAP[q];_jp2_read_boxhdr(t,
u,s);if(1768449138!=IHEAP[s+4])_opj_event_msg(t,1,__str14102);else{p=_cio_read(u,4);IHEAP[q+12]=p;p=_cio_read(u,4);IHEAP[q+8]=p;p=_cio_read(u,2);IHEAP[q+16]=p;p=_malloc(IHEAP[q+16]*12);IHEAP[q+68]=p;p=_cio_read(u,1);IHEAP[q+20]=p;p=_cio_read(u,1);IHEAP[q+24]=p;p=_cio_read(u,1);IHEAP[q+28]=p;p=_cio_read(u,1);IHEAP[q+32]=p;q=u;if(0-IHEAP[q+16]+IHEAP[q+24]+(0-IHEAP[s+8])!=IHEAP[s])_opj_event_msg(t,1,__str1522);else{s=IHEAP[v]+IHEAP[v+8];q=IHEAP[b+20]==255;b:do if(q){q=f;p=b;r=q;q=IHEAP[p];_jp2_read_boxhdr(q,
r,c);if(1651532643!=IHEAP[c+4])_opj_event_msg(q,1,__str12100);else{t=r;if(0<IHEAP[p+16]){u=p+68;p=p+16;o=r;for(d=12;;){C=d==12?0:C;var x=0+C;r=1+C;var w=_cio_read(d==12?t:o,1);IHEAP[IHEAP[u]+12*x+8]=w;var C=C+1;if(r<IHEAP[p])d=13;else break}d=14}else d=70;o=d==14?o:t;if(0-IHEAP[o+16]+IHEAP[o+24]+(0-IHEAP[c+8])!=IHEAP[c])_opj_event_msg(q,1,__str13101);else break b}q=0;break a}while(0);_jp2_read_boxhdr(y,f,v);d=f;if(IHEAP[d+24]-IHEAP[d+16]<s){o=v+4;C=v+8;q=v;t=v+4;u=v+8;p=v;r=v+4;x=v+8;w=v;var z=v+
4,A=v+8,B=v,D=v+8,J=v;b:for(;;){if(IHEAP[o]==1668246642){g=f;a=e;d=b;h=g;g=v;n=a;k=IHEAP[n+16]!=0;c:do{if(k)a=20;else{a=IHEAP[d];k=_cio_read(h,1);IHEAP[d+36]=k;k=_cio_read(h,1);IHEAP[d+48]=k;k=_cio_read(h,1);IHEAP[d+40]=k;k=IHEAP[d+36]==1;d:do if(k){i=_cio_read(h,4);IHEAP[d+44]=i}else{j=IHEAP[g+8];l=IHEAP[g];i=h;i=l+j+(0-IHEAP[i+24])+(0-(0-IHEAP[i+16]));if(i<0){_opj_event_msg(a,1,__str1099);a=20;break c}else{if(!(i>0))break d;j=h;j=IHEAP[j+24];l=_malloc(i);IHEAP[n]=l;IHEAP[n+4]=i;l=h;var E=IHEAP[g+
8],N=IHEAP[g];m=h;m=N+E+(0-IHEAP[m+24])+(0-(0-IHEAP[m+16]));l=l;m=m;IHEAP[l+24]+=m;_llvm_memcpy_p0i8_p0i8_i32(IHEAP[n],j,i,1,0)}}while(0);d=h;if(0-IHEAP[d+16]+IHEAP[d+24]+(0-IHEAP[g+8])!=IHEAP[g]){_opj_event_msg(a,1,__str1121);a=20}else{IHEAP[n+16]=1;a=24}}break c}while(0);if(a==20){a=IHEAP[C]+8;d=f;a=a;IHEAP[d+24]=IHEAP[d+16]+a;a=IHEAP[q]-8;d=f;a=a;IHEAP[d+24]+=a}}else if(IHEAP[t]==1667523942){d=e;g=f;d=d;h=IHEAP[d+8]!=0;c:do{if(h)a=31;else{h=_cio_read(g,2)&65535;if(h==0)a=31;else{a=_malloc(h*6);
n=_malloc(8);IHEAP[d+8]=n;IHEAP[IHEAP[d+8]]=a;IHEAP[IHEAP[d+8]+4]=h;n=0<h;d:do if(n){k=g;i=a;j=g;l=a;m=g;E=a;N=h;for(d=33;;){S=d==33?0:S;d=S+1;var Q=_cio_read(k,2)&65535;IHEAP[i+6*S]=Q;Q=_cio_read(j,2)&65535;IHEAP[l+6*S+2]=Q;Q=_cio_read(m,2)&65535;IHEAP[E+6*S+4]=Q;var S=S+1;if(d<N)d=34;else break d}}while(0);a=36}}break c}while(0);if(a==31){a=IHEAP[u]+8;d=f;a=a;IHEAP[d+24]=IHEAP[d+16]+a;a=IHEAP[p]-8;d=f;a=a;IHEAP[d+24]+=a}}else if(IHEAP[r]==1885564018){d=e;a=f;i=d;if(IHEAP[i+12]!=0){a=IHEAP[x]+8;
d=f;a=a;IHEAP[d+24]=IHEAP[d+16]+a;a=IHEAP[w]-8;d=f;a=a;IHEAP[d+24]+=a}else{h=_cio_read(a,2)&65535;n=_cio_read(a,1)&65535;k=_malloc(n*4*h);g=_malloc(n);d=_malloc(n);j=_malloc(20);IHEAP[j+4]=d;IHEAP[j+8]=g;IHEAP[j]=k;IHEAP[j+16]=h;IHEAP[j+18]=n;IHEAP[j+12]=0;IHEAP[i+12]=j;if(0<n){i=a;j=g;l=d;m=n;for(d=38;;){P=d==38?0:P;d=P+1;E=_cio_read(i,1)&255;IHEAP[j+P]=(E&127)+1&255;IHEAP[l+P]=((E&128)!=0?1:0)&255;var P=P+1;if(d<m)d=39;else break}}i=0<h;c:do if(i){l=n;j=h;if(0<n){m=a;E=g;k=k;d=42;d:for(;;){N=d==
45?G:k;H=d==45?H:0;Q=H+1;for(d=43;;){K=d==43?0:K;G=K+1;d=G&65535;var G=N+4*G,F=N+4*K,L=_cio_read(m,IHEAP[E+(K&65535)]>>3);IHEAP[F]=L;var K=K+1;if(d<l)d=44;else break}var H=H+1;if(Q<j)d=45;else break d}k=G}else for(d=89;;){d=d==47?M:0;var M=d+1;if(d+1<j)d=47;else break c}}while(0)}}else if(IHEAP[z]==1668112752){d=e;g=f;h=d;d=IHEAP[h+12]==0;c:do{if(d)a=53;else if(IHEAP[IHEAP[h+12]+12]!=0)a=53;else{n=IHEAP[IHEAP[h+12]+18];a=_malloc(n*4);k=0<n;d:do if(k){i=g;j=a;l=g;m=a;E=g;N=a;Q=n;for(d=54;;){I=d==54?
0:I;d=I+1;F=_cio_read(i,2)&65535;IHEAP[j+4*I]=F;F=_cio_read(l,1)&255;IHEAP[m+4*I+2]=F;F=_cio_read(E,1)&255;IHEAP[N+4*I+3]=F;var I=I+1;if(d<Q)d=55;else break d}}while(0);IHEAP[IHEAP[h+12]+12]=a;a=57}break c}while(0);if(a==53){a=IHEAP[A]+8;d=f;a=a;IHEAP[d+24]=IHEAP[d+16]+a;a=IHEAP[B]-8;d=f;a=a;IHEAP[d+24]+=a}}else{a=IHEAP[D]+8;d=f;a=a;IHEAP[d+24]=IHEAP[d+16]+a;a=IHEAP[J]-8;d=f;a=a;IHEAP[d+24]+=a}_jp2_read_boxhdr(y,f,v);d=f;if(!(IHEAP[d+24]-IHEAP[d+16]<s))break b}}b=s;f=f;b=b;IHEAP[f+24]=IHEAP[f+16]+
b;q=IHEAP[e+16]==1;break a}}q=0}while(0);e=q;STACKTOP=c;return e}_jp2_read_jp2h.__index__=Runtime.getFunctionIndex(_jp2_read_jp2h,"_jp2_read_jp2h");
function _jp2_read_boxhdr(b,f,e){var c;IHEAP[e+8]=IHEAP[f+24]-IHEAP[f+16];var a=_cio_read(f,4);IHEAP[e]=a;a=_cio_read(f,4);IHEAP[e+4]=a;a=IHEAP[e]==1;a:do if(a)if(_cio_read(f,4)!=0)_opj_event_msg(b,1,__str16103);else{c=_cio_read(f,4);IHEAP[e]=c;if(IHEAP[e]!=0)break a;c=f;IHEAP[e]=IHEAP[c+20]+12+(0-IHEAP[c+24])}else{if(IHEAP[e]!=0)break a;c=f;IHEAP[e]=IHEAP[c+20]+8+(0-IHEAP[c+24])}while(0)}_jp2_read_boxhdr.__index__=Runtime.getFunctionIndex(_jp2_read_boxhdr,"_jp2_read_boxhdr");
function _jp2_decode(b,f,e){var c=STACKTOP;STACKTOP+=104;_memset(c,0,104);var a,d=null,g,h,i,j,k,m,l,n,o,p;h=c+48;var r;n=c+60;var q,u;d=c+72;var s,t=c+84;s=b!=0;a:do if(s){if(f==0){a=1;break a}_llvm_memset_p0i8_i32(t,0,20,1,0);l=IHEAP[b];s=f;a=b;s=s;k=t;q=s;u=a;q=q;u=IHEAP[u];_jp2_read_boxhdr(u,q,d);var v=1783636E3!=IHEAP[d+4];b:do{if(v)_opj_event_msg(u,1,__str718);else if(218793738!=_cio_read(q,4))_opj_event_msg(u,1,__str819);else{q=q;if(0-IHEAP[d+8]+IHEAP[q+24]+(0-IHEAP[q+16])!=IHEAP[d])_opj_event_msg(u,
1,__str920);else{q=s;d=a;r=q;q=IHEAP[d];_jp2_read_boxhdr(q,r,n);if(1718909296!=IHEAP[n+4])_opj_event_msg(q,1,__str516);else{u=_cio_read(r,4);IHEAP[d+52]=u;u=_cio_read(r,4);IHEAP[d+56]=u;IHEAP[d+60]=(IHEAP[n]-16)/4|0;u=_malloc(IHEAP[d+60]*4);IHEAP[d+64]=u;u=r;if(0<IHEAP[d+60]){v=d+64;var y=d+60;p=r;for(d=6;;){x=d==6?0:x;r=1+x;i=0+x;d=_cio_read(d==6?u:p,4);IHEAP[IHEAP[v]+4*i]=d;var x=x+1;if(r<IHEAP[y])d=7;else break}d=8}else d=57;d=d==8?p:u;if(0-IHEAP[n+8]+IHEAP[d+24]+(0-IHEAP[d+16])!=IHEAP[n])_opj_event_msg(q,
1,__str617);else if(_jp2_read_jp2h(a,s,k)!=0){d=s;n=a+76;s=a+72;p=a;d=d;n=n;a=s;k=IHEAP[p];_jp2_read_boxhdr(k,d,h);p=h+4;s=h;k=k;x=d;q=h+4;u=d+24;c:for(;;){if(1785737827!=IHEAP[p]){IHEAP[u]+=IHEAP[s]-8;_jp2_read_boxhdr(k,x,h)}if(1785737827==IHEAP[q])break c}d=d;IHEAP[a]=IHEAP[d+24]-IHEAP[d+16];IHEAP[n]=IHEAP[h]-8;f=_j2k_decode(IHEAP[b+4],f,e);if(f!=0){IHEAP[f+20]=IHEAP[b+44]==16?1:IHEAP[b+44]==17?2:IHEAP[b+44]==18?3:-1;if(IHEAP[t+8]!=0){k=f;b=t;d=IHEAP[IHEAP[b+8]];h=IHEAP[IHEAP[b+8]+4];if(0<h){e=
d;h=h;l=d;n=c;a=k+24;p=k+24;s=k+24;k=k+24;x=c;v=u=q=d;d=16;c:for(;;){g=d==16?0:g;d=1+g;y=0+g;r=IHEAP[e+6*y+4];i=r==0;d:do if(!i){o=IHEAP[l+6*y];j=r-1&65535;if(o==j)break d;_llvm_memcpy_p0i8_p0i8_i32(n,IHEAP[a]+48*o,48,1,0);_llvm_memcpy_p0i8_p0i8_i32(IHEAP[p]+48*o,IHEAP[s]+48*j,48,1,0);_llvm_memcpy_p0i8_p0i8_i32(IHEAP[k]+48*j,x,48,1,0);IHEAP[q+6*y+4]=o+1&65535;IHEAP[v+6*j+4]=IHEAP[u+6*j]+1&65535}while(0);g=g+1;if(d<h)d=20;else break c}}IHEAP[IHEAP[b+8]]!=0&&_free(IHEAP[IHEAP[b+8]]);_free(IHEAP[b+8]);
IHEAP[b+8]=0}if(IHEAP[t+12]!=0)if(IHEAP[IHEAP[t+12]+12]!=0){d=f;g=t;b=d;i=IHEAP[IHEAP[g+12]+8];j=IHEAP[IHEAP[g+12]+4];d=IHEAP[IHEAP[g+12]];k=IHEAP[IHEAP[g+12]+12];n=IHEAP[IHEAP[g+12]+18];e=IHEAP[b+24];h=_malloc(n*48);l=0;if(l<n){p=a=k;s=h;x=e;q=k;u=e;v=n;y=e;r=h;i=i;o=h;j=j;for(var w=h;;){var C=IHEAP[a+4*l+3],z=IHEAP[p+4*l];_llvm_memcpy_p0i8_p0i8_i32(s+48*C,x+48*z,48,4,0);var A=u+48*z;if(IHEAP[q+4*l+2]==0)IHEAP[A+44]=0;else{z=_malloc(IHEAP[A+8]*4*IHEAP[y+48*z+12]);IHEAP[r+48*C+44]=z;IHEAP[o+48*C+
24]=IHEAP[i+l];IHEAP[w+48*C+32]=IHEAP[j+l]}l+=1;if(!(l<v))break}}o=IHEAP[IHEAP[g+12]+16]-1;l=0;if(l<n){a=k;p=n;k=s=k;x=e;v=u=q=h;y=n;r=d;o=i=o;c:for(;;){j=IHEAP[a+4*l+2]==0;d:do if(!j){z=IHEAP[k+4*l+3];w=IHEAP[x+48*IHEAP[s+4*l]+44];C=IHEAP[q+48*z+44];d=IHEAP[u+48*z+8];A=IHEAP[v+48*z+12];if(!(0<A*d))break d;z=z;A=A*d;d=34;e:for(;;){m=d==34?0:m;var B=C+4*m,D=IHEAP[w+4*m],J=D<0;f:do if(J)d=36;else{if(!(D>i)){d=37;break f}d=38}while(0);IHEAP[B]=IHEAP[r+4*((d==37?D:d==38?o:0)*y+z)];m=m+1;if(m!=A)d=39;
else break e}}while(0);l+=1;if(!(l<p))break c}}m=IHEAP[b+16];l=0;d=l<m;c:do if(d){p=a=e;for(s=m;;){IHEAP[a+48*l+44]!=0&&_free(IHEAP[p+48*l+44]);l+=1;if(!(l<s))break c}}while(0);_free(e);IHEAP[b+24]=h;IHEAP[b+16]=n;_jp2_free_pclr(g)}else _jp2_free_pclr(t);if(IHEAP[t]!=0){IHEAP[f+28]=IHEAP[t];IHEAP[t]=0;IHEAP[f+32]=IHEAP[t+4]}l=f}else{_free_color_data(t);_opj_event_msg(l,1,__str213);l=0}a=14;break a}else break b}}}break b}while(0);_free_color_data(t);_opj_event_msg(l,1,__str112);l=0;a=14;break a}else a=
1;while(0);if(a==1)l=0;t=l;STACKTOP=c;return t}_jp2_decode.__index__=Runtime.getFunctionIndex(_jp2_decode,"_jp2_decode");function _free_color_data(b){IHEAP[b+12]!=0&&_jp2_free_pclr(b);if(IHEAP[b+8]!=0){IHEAP[IHEAP[b+8]]!=0&&_free(IHEAP[IHEAP[b+8]]);_free(IHEAP[b+8])}IHEAP[b]!=0&&_free(IHEAP[b])}_free_color_data.__index__=Runtime.getFunctionIndex(_free_color_data,"_free_color_data");
function _jp2_free_pclr(b){_free(IHEAP[IHEAP[b+12]+4]);_free(IHEAP[IHEAP[b+12]+8]);_free(IHEAP[IHEAP[b+12]]);IHEAP[IHEAP[b+12]+12]!=0&&_free(IHEAP[IHEAP[b+12]+12]);_free(IHEAP[b+12]);IHEAP[b+12]=0}_jp2_free_pclr.__index__=Runtime.getFunctionIndex(_jp2_free_pclr,"_jp2_free_pclr");
function _jp2_write_jp2h(b,f){var e=STACKTOP;STACKTOP+=48;_memset(e,0,48);var c=null,a;c=e+12;var d=e+24,g=e+36;IHEAP[g+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1785737832,4);IHEAP[c+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1768449138,4);_cio_write(f,IHEAP[b+12],4);_cio_write(f,IHEAP[b+8],4);_cio_write(f,IHEAP[b+16],2);_cio_write(f,IHEAP[b+20],1);_cio_write(f,IHEAP[b+24],1);_cio_write(f,IHEAP[b+28],1);_cio_write(f,IHEAP[b+32],1);IHEAP[c]=0-IHEAP[f+16]+IHEAP[f+24]+(0-IHEAP[c+
8]);IHEAP[f+24]=IHEAP[f+16]+IHEAP[c+8];_cio_write(f,IHEAP[c],4);IHEAP[f+24]=IHEAP[f+16]+(IHEAP[c]+IHEAP[c+8]);if(IHEAP[b+20]==255){IHEAP[e+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1651532643,4);if(0<IHEAP[b+16]){var h=b+68,i=b+16;a=f;for(c=0;;){k=c==0?0:k;var j=1+k;_cio_write(c==0?f:a,IHEAP[IHEAP[h]+12*(0+k)+8],1);var k=k+1;if(j<IHEAP[i])c=1;else break}c=2}else c=6;a=c==2?a:f;IHEAP[e]=0-IHEAP[a+16]+IHEAP[a+24]+(0-IHEAP[e+8]);a=IHEAP[e+8];IHEAP[f+24]=IHEAP[f+16]+a;_cio_write(f,IHEAP[e],
4);a=IHEAP[e]+IHEAP[e+8];IHEAP[f+24]=IHEAP[f+16]+a}IHEAP[d+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1668246642,4);_cio_write(f,IHEAP[b+36],1);_cio_write(f,IHEAP[b+48],1);_cio_write(f,IHEAP[b+40],1);IHEAP[b+36]==1?_cio_write(f,IHEAP[b+44],4):_cio_write(f,0,1);IHEAP[d]=0-IHEAP[f+16]+IHEAP[f+24]+(0-IHEAP[d+8]);IHEAP[f+24]=IHEAP[f+16]+IHEAP[d+8];_cio_write(f,IHEAP[d],4);IHEAP[f+24]=IHEAP[f+16]+(IHEAP[d]+IHEAP[d+8]);IHEAP[g]=0-IHEAP[g+8]+IHEAP[f+24]+(0-IHEAP[f+16]);IHEAP[f+24]=IHEAP[f+16]+
IHEAP[g+8];_cio_write(f,IHEAP[g],4);IHEAP[f+24]=IHEAP[f+16]+(IHEAP[g]+IHEAP[g+8]);STACKTOP=e}_jp2_write_jp2h.__index__=Runtime.getFunctionIndex(_jp2_write_jp2h,"_jp2_write_jp2h");function _jp2_create_decompress(b){var f,e,c;c=_calloc(1,80);var a=c!=0;a:do if(a){IHEAP[c]=b;b=_j2k_create_decompress(b);IHEAP[c+4]=b;if(IHEAP[c+4]!=0){f=1;break a}_jp2_destroy_decompress(c);e=0;f=2;break a}else f=1;while(0);if(f==1)e=c;return e}
_jp2_create_decompress.__index__=Runtime.getFunctionIndex(_jp2_create_decompress,"_jp2_create_decompress");function _jp2_destroy_decompress(b){if(b!=0){_j2k_destroy_decompress(IHEAP[b+4]);IHEAP[b+68]!=0&&_free(IHEAP[b+68]);IHEAP[b+64]!=0&&_free(IHEAP[b+64]);_free(b)}}_jp2_destroy_decompress.__index__=Runtime.getFunctionIndex(_jp2_destroy_decompress,"_jp2_destroy_decompress");
function _jp2_setup_decoder(b,f){var e,c;e=IHEAP[b+4];var a=e!=0;a:do if(a){if(f==0)break a;c=_calloc(1,116);IHEAP[c+36]=IHEAP[f];IHEAP[c+40]=IHEAP[f+4];IHEAP[c+44]=IHEAP[f+8220];IHEAP[e+64]=c}while(0)}_jp2_setup_decoder.__index__=Runtime.getFunctionIndex(_jp2_setup_decoder,"_jp2_setup_decoder");
function _jp2_create_compress(b){var f,e,c;c=_malloc(80);var a=c!=0;a:do if(a){b=IHEAP[c]=b;f=_calloc(1,76);if(f!=0)IHEAP[f]=b;IHEAP[c+4]=f;if(IHEAP[c+4]!=0){f=2;break a}_jp2_destroy_compress(c);e=0;f=3;break a}else f=2;while(0);if(f==2)e=c;return e}_jp2_create_compress.__index__=Runtime.getFunctionIndex(_jp2_create_compress,"_jp2_create_compress");
function _jp2_destroy_compress(b){if(b!=0){_j2k_destroy_compress(IHEAP[b+4]);IHEAP[b+68]!=0&&_free(IHEAP[b+68]);IHEAP[b+64]!=0&&_free(IHEAP[b+64]);_free(b)}}_jp2_destroy_compress.__index__=Runtime.getFunctionIndex(_jp2_destroy_compress,"_jp2_destroy_compress");
function _jp2_setup_encoder(b,f,e){var c,a=null;a=b!=0;a:do if(a){if(f==0)break a;if(e==0)break a;var d=IHEAP[e+16]<1;b:do if(!d){if(IHEAP[e+16]>16384)break b;_j2k_setup_encoder(IHEAP[b+4],f,e);IHEAP[b+52]=1785737760;IHEAP[b+56]=0;IHEAP[b+60]=1;a=_malloc(IHEAP[b+60]*4);IHEAP[b+64]=a;IHEAP[IHEAP[b+64]]=1785737760;IHEAP[b+16]=IHEAP[e+16];a=_malloc(IHEAP[b+16]*12);IHEAP[b+68]=a;IHEAP[b+12]=IHEAP[e+12]-IHEAP[e+4];IHEAP[b+8]=IHEAP[e+8]-IHEAP[e];f=IHEAP[IHEAP[e+24]+24]-1;a=IHEAP[IHEAP[e+24]+32];IHEAP[b+
20]=a*128+f;a=1;if(a<IHEAP[e+16]){f=f;d=a;var g=d+1;for(a=5;;){h=a==5?0:h;a=g+h;if(f!=IHEAP[IHEAP[e+24]+48*(d+h)+24]-1)IHEAP[b+20]=255;var h=h+1;if(a<IHEAP[e+16])a=8;else break}}IHEAP[b+24]=7;IHEAP[b+28]=0;a=IHEAP[b+32]=0;if(a<IHEAP[e+16]){h=a;f=h+1;for(a=11;;){c=a==11?0:c;a=f+c;d=h+c;IHEAP[IHEAP[b+68]+12*d+8]=IHEAP[IHEAP[e+24]+48*d+24]+-1+IHEAP[IHEAP[e+24]+48*d+32]*128;c=c+1;if(a<IHEAP[e+16])a=12;else break}}h=IHEAP[e+16]==1;c:do if(h)c=15;else{c=IHEAP[e+16]==3?15:16;break c}while(0);c:do if(c==
15){if(IHEAP[b+20]==255){c=16;break c}IHEAP[b+36]=1;c=18;break c}while(0);if(c==16)IHEAP[b+36]=2;c=IHEAP[b+36]==1;c:do if(c)if(IHEAP[e+20]==1)IHEAP[b+44]=16;else if(IHEAP[e+20]==2)IHEAP[b+44]=17;else{if(IHEAP[e+20]!=3)break c;IHEAP[b+44]=18}else IHEAP[b+44]=0;while(0);IHEAP[b+48]=0;IHEAP[b+40]=0;return}while(0);_opj_event_msg(IHEAP[b],1,__str314)}while(0)}_jp2_setup_encoder.__index__=Runtime.getFunctionIndex(_jp2_setup_encoder,"_jp2_setup_encoder");
function _jp2_encode(b,f,e,c){var a=STACKTOP;STACKTOP+=36;_memset(a,0,36);var d=null,g,h;g=a+12;d=a+24;IHEAP[d+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1783636E3,4);_cio_write(f,218793738,4);IHEAP[d]=0-IHEAP[f+16]+IHEAP[f+24]+(0-IHEAP[d+8]);IHEAP[f+24]=IHEAP[f+16]+IHEAP[d+8];_cio_write(f,IHEAP[d],4);IHEAP[f+24]=IHEAP[f+16]+(IHEAP[d]+IHEAP[d+8]);IHEAP[g+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1718909296,4);_cio_write(f,IHEAP[b+52],4);_cio_write(f,IHEAP[b+56],4);if(0<IHEAP[b+
60]){var i=b+64,j=b+60;h=f;for(d=0;;){m=d==0?0:m;var k=1+m;_cio_write(d==0?f:h,IHEAP[IHEAP[i]+4*(0+m)],4);var m=m+1;if(k<IHEAP[j])d=1;else break}d=2}else d=5;h=d==2?h:f;IHEAP[g]=0-IHEAP[h+16]+IHEAP[h+24]+(0-IHEAP[g+8]);IHEAP[f+24]=IHEAP[f+16]+IHEAP[g+8];_cio_write(f,IHEAP[g],4);IHEAP[f+24]=IHEAP[f+16]+(IHEAP[g]+IHEAP[g+8]);_jp2_write_jp2h(b,f);h=IHEAP[b+4];IHEAP[a+8]=IHEAP[f+24]-IHEAP[f+16];IHEAP[f+24]+=4;_cio_write(f,1785737827,4);g=IHEAP[f+24]-IHEAP[f+16];_j2k_encode(h,f,e,c);e=0-IHEAP[f+16]+IHEAP[f+
24]+(0-g);IHEAP[b+72]=g;IHEAP[b+76]=e;IHEAP[a]=IHEAP[b+76]+8;IHEAP[f+24]=IHEAP[f+16]+IHEAP[a+8];_cio_write(f,IHEAP[a],4);IHEAP[f+24]=IHEAP[f+16]+(IHEAP[a]+IHEAP[a+8]);if(IHEAP[a]!=0)b=1;else{_opj_event_msg(IHEAP[b],1,__str415);b=0}b=b;STACKTOP=a;return b}_jp2_encode.__index__=Runtime.getFunctionIndex(_jp2_encode,"_jp2_encode");
function _jpt_read_VBAS_info(b,f){var e=null,c;c=f;e=_cio_read(b,1)&255;var a=e>>7==1;c<<=7;c=e&127|c;if(a){c=c;for(e=0;;){d=e==0?c:d;e=_cio_read(b,1)&255;var d=e&127|d<<7;if(e>>7==1)e=1;else break}c=d}return c}_jpt_read_VBAS_info.__index__=Runtime.getFunctionIndex(_jpt_read_VBAS_info,"_jpt_read_VBAS_info");function _jpt_init_msg_header(b){IHEAP[b]=0;IHEAP[b+4]=0;IHEAP[b+8]=0;IHEAP[b+12]=0;IHEAP[b+16]=0;IHEAP[b+20]=0;IHEAP[b+24]=0}
_jpt_init_msg_header.__index__=Runtime.getFunctionIndex(_jpt_init_msg_header,"_jpt_init_msg_header");function _jpt_reinit_msg_header(b){IHEAP[b]=0;IHEAP[b+4]=0;IHEAP[b+16]=0;IHEAP[b+20]=0}_jpt_reinit_msg_header.__index__=Runtime.getFunctionIndex(_jpt_reinit_msg_header,"_jpt_reinit_msg_header");
function _jpt_read_msg_header(b,f,e){var c,a,d,g;g=d=0;IHEAP[e]=0;IHEAP[e+4]=0;IHEAP[e+16]=0;IHEAP[e+20]=0;a=_cio_read(f,1)&255;c=a>>5&3;c=c==0?5:c==1?6:c==2?7:c==3?8:9;if(c==5)_opj_event_msg(b,1,__str23104);else if(c==6)g=d=0;else if(c==7){d=1;g=0}else if(c==8)g=d=1;if((a>>4&1)==1)IHEAP[e+4]=1;IHEAP[e]|=a&15;if(a>>7==1){b=_jpt_read_VBAS_info(f,IHEAP[e]);IHEAP[e]=b}if(d==1){IHEAP[e+8]=0;d=_jpt_read_VBAS_info(f,IHEAP[e+8]);IHEAP[e+8]=d}if(g==1){IHEAP[e+12]=0;g=_jpt_read_VBAS_info(f,IHEAP[e+12]);IHEAP[e+
12]=g}g=_jpt_read_VBAS_info(f,IHEAP[e+16]);IHEAP[e+16]=g;g=_jpt_read_VBAS_info(f,IHEAP[e+20]);IHEAP[e+20]=g;if((IHEAP[e+8]&1)==1){IHEAP[e+24]=0;f=_jpt_read_VBAS_info(f,IHEAP[e+24]);IHEAP[e+24]=f}}_jpt_read_msg_header.__index__=Runtime.getFunctionIndex(_jpt_read_msg_header,"_jpt_read_msg_header");
function _mct_encode(b,f,e,c){var a=null;if(0<c){c=(c>1?c:1)-0;for(a=0;;){a=a==0?0:l;l=0+a;var d=e+4*l,g=f+4*l,h=IHEAP[b+4*l],i=IHEAP[f+4*l],j=IHEAP[e+4*l],k=j-i,m=h-i;IHEAP[b+4*l]=j+h+i*2>>2;IHEAP[g]=k;IHEAP[d]=m;var l=a+1;if(l!=c)a=1;else break}}}_mct_encode.__index__=Runtime.getFunctionIndex(_mct_encode,"_mct_encode");
function _mct_decode(b,f,e,c){var a=null;if(0<c){c=(c>1?c:1)-0;for(a=0;;){a=a==0?0:k;k=0+a;var d=e+4*k,g=f+4*k,h=IHEAP[f+4*k],i=IHEAP[e+4*k],j=IHEAP[b+4*k]-(i+h>>2);h=j+h;IHEAP[b+4*k]=j+i;IHEAP[g]=j;IHEAP[d]=h;var k=a+1;if(k!=c)a=1;else break}}}_mct_decode.__index__=Runtime.getFunctionIndex(_mct_decode,"_mct_decode");function _mct_getnorm(b){return FHEAP[_mct_norms+b*8]}_mct_getnorm.__index__=Runtime.getFunctionIndex(_mct_getnorm,"_mct_getnorm");
function _mct_encode_real(b,f,e,c){var a=null;if(0<c){c=(c>1?c:1)-0;for(a=0;;){a=a==0?0:r;r=0+a;var d=e+4*r,g=f+4*r,h=IHEAP[b+4*r],i=IHEAP[f+4*r],j=IHEAP[e+4*r],k=2449*h,m=4809*i,l=934*j,n=1382*h,o=2714*i,p=4096*j;n=0-(o+(o&4096)>>13&4294967295)+(0-(n+(n&4096)>>13&4294967295))+(p+(p&4096)>>13&4294967295);h=4096*h;i=3430*i;j=666*j;j=0-(i+(i&4096)>>13&4294967295)+(h+(h&4096)>>13&4294967295)+(0-(j+(j&4096)>>13&4294967295));IHEAP[b+4*r]=(m+(m&4096)>>13&4294967295)+(k+(k&4096)>>13&4294967295)+(l+(l&4096)>>
13&4294967295);IHEAP[g]=n;IHEAP[d]=j;var r=a+1;if(r!=c)a=1;else break}}}_mct_encode_real.__index__=Runtime.getFunctionIndex(_mct_encode_real,"_mct_encode_real");function _mct_decode_real(b,f,e,c){var a=null;if(0<c){c=(c>1?c:1)-0;for(a=0;;){a=a==0?0:m;m=0+a;var d=e+4*m,g=f+4*m,h=FHEAP[b+4*m],i=FHEAP[f+4*m],j=FHEAP[e+4*m],k=h-i*0.3441300094127655-j*0.714139997959137;i=h+i*1.7719999551773071;FHEAP[b+4*m]=h+j*1.4019999504089355;FHEAP[g]=k;FHEAP[d]=i;var m=a+1;if(m!=c)a=1;else break}}}
_mct_decode_real.__index__=Runtime.getFunctionIndex(_mct_decode_real,"_mct_decode_real");function _mct_getnorm_real(b){return FHEAP[_mct_norms_real+b*8]}_mct_getnorm_real.__index__=Runtime.getFunctionIndex(_mct_getnorm_real,"_mct_getnorm_real");function _mqc_create(){return _malloc(104)}_mqc_create.__index__=Runtime.getFunctionIndex(_mqc_create,"_mqc_create");function _mqc_destroy(b){b!=0&&_free(b)}_mqc_destroy.__index__=Runtime.getFunctionIndex(_mqc_destroy,"_mqc_destroy");
function _mqc_numbytes(b){return IHEAP[b+12]-IHEAP[b+16]}_mqc_numbytes.__index__=Runtime.getFunctionIndex(_mqc_numbytes,"_mqc_numbytes");function _mqc_init_enc(b,f){IHEAP[b+100]=b+24;IHEAP[b+4]=32768;IHEAP[b]=0;IHEAP[b+12]=f+-1;IHEAP[b+8]=12;if(IHEAP[IHEAP[b+12]]==255)IHEAP[b+8]=13;IHEAP[b+16]=f}_mqc_init_enc.__index__=Runtime.getFunctionIndex(_mqc_init_enc,"_mqc_init_enc");
function _mqc_encode(b,f){var e,c,a=IHEAP[IHEAP[IHEAP[b+100]]+4]==f;a:do if(a){c=b;IHEAP[c+4]-=IHEAP[IHEAP[IHEAP[c+100]]];var d=c;if((IHEAP[c+4]&32768)==0){var g=IHEAP[IHEAP[IHEAP[c+100]]],h=c;if(IHEAP[d+4]<IHEAP[IHEAP[IHEAP[c+100]]])IHEAP[h+4]=g;else IHEAP[h]+=g;IHEAP[IHEAP[c+100]]=IHEAP[IHEAP[IHEAP[c+100]]+8];e=c;c=e+4;d=e;g=e+8;h=e+8;var i=e;for(e=e+4;;){IHEAP[c]<<=1;IHEAP[d]<<=1;IHEAP[g]+=-1;IHEAP[h]==0&&_mqc_byteout(i);if((IHEAP[e]&32768)!=0)break a}}else IHEAP[c]+=IHEAP[IHEAP[IHEAP[d+100]]]}else{c=
b;IHEAP[c+4]-=IHEAP[IHEAP[IHEAP[c+100]]];d=IHEAP[IHEAP[IHEAP[c+100]]];g=c;if(IHEAP[c+4]<IHEAP[IHEAP[IHEAP[c+100]]])IHEAP[g]+=d;else IHEAP[g+4]=d;IHEAP[IHEAP[c+100]]=IHEAP[IHEAP[IHEAP[c+100]]+12];e=c;c=e+4;d=e;g=e+8;h=e+8;i=e;for(e=e+4;;){IHEAP[c]<<=1;IHEAP[d]<<=1;IHEAP[g]+=-1;IHEAP[h]==0&&_mqc_byteout(i);if((IHEAP[e]&32768)!=0)break a}}while(0)}_mqc_encode.__index__=Runtime.getFunctionIndex(_mqc_encode,"_mqc_encode");
function _mqc_flush(b){var f;f=IHEAP[b+4]+IHEAP[b];IHEAP[b]|=65535;if(IHEAP[b]>=f)IHEAP[b]-=32768;IHEAP[b]<<=IHEAP[b+8];_mqc_byteout(b);IHEAP[b]<<=IHEAP[b+8];_mqc_byteout(b);if(IHEAP[IHEAP[b+12]]!=255)IHEAP[b+12]+=1}_mqc_flush.__index__=Runtime.getFunctionIndex(_mqc_flush,"_mqc_flush");
function _mqc_byteout(b){if(IHEAP[IHEAP[b+12]]==255){IHEAP[b+12]+=1;IHEAP[IHEAP[b+12]]=IHEAP[b]>>>20&255;IHEAP[b]&=1048575;IHEAP[b+8]=7}else{var f=b+12,e=IHEAP[f];if((IHEAP[b]&134217728)==0){IHEAP[f]=e+1;IHEAP[IHEAP[b+12]]=IHEAP[b]>>>19&255;IHEAP[b]&=524287;IHEAP[b+8]=8}else{IHEAP[e]+=1;if(IHEAP[IHEAP[b+12]]==255){IHEAP[b]&=134217727;IHEAP[b+12]+=1;IHEAP[IHEAP[b+12]]=IHEAP[b]>>>20&255;IHEAP[b]&=1048575;IHEAP[b+8]=7}else{IHEAP[b+12]+=1;IHEAP[IHEAP[b+12]]=IHEAP[b]>>>19&255;IHEAP[b]&=524287;IHEAP[b+
8]=8}}}}_mqc_byteout.__index__=Runtime.getFunctionIndex(_mqc_byteout,"_mqc_byteout");function _mqc_bypass_init_enc(b){IHEAP[b]=0;IHEAP[b+8]=8}_mqc_bypass_init_enc.__index__=Runtime.getFunctionIndex(_mqc_bypass_init_enc,"_mqc_bypass_init_enc");function _mqc_bypass_enc(b,f){IHEAP[b+8]+=-1;IHEAP[b]=(f<<IHEAP[b+8])+IHEAP[b];if(IHEAP[b+8]==0){IHEAP[b+12]+=1;IHEAP[IHEAP[b+12]]=IHEAP[b]&255;IHEAP[b+8]=8;if(IHEAP[IHEAP[b+12]]==255)IHEAP[b+8]=7;IHEAP[b]=0}}
_mqc_bypass_enc.__index__=Runtime.getFunctionIndex(_mqc_bypass_enc,"_mqc_bypass_enc");function _mqc_bypass_flush_enc(b){var f=null;if(IHEAP[b+8]!=0){if(IHEAP[b+8]>0){var e=b+8,c=b+8,a=b;for(f=0;;){d=f==0?0:d;IHEAP[(f==0?b:a)+8]+=-1;IHEAP[b]+=d<<IHEAP[e];var d=d+1&1&255;if(IHEAP[c]>0)f=1;else break}f=2}else f=4;IHEAP[(f==2?a:b)+12]+=1;IHEAP[IHEAP[b+12]]=IHEAP[b]&255;IHEAP[b+8]=8;IHEAP[b]=0}return 1}_mqc_bypass_flush_enc.__index__=Runtime.getFunctionIndex(_mqc_bypass_flush_enc,"_mqc_bypass_flush_enc");
function _mqc_reset_enc(b){var f=null;for(f=0;;){f=f==0?0:e;IHEAP[b+24+(0+f)*4]=_mqc_states;var e=f+1;if(e!=19)f=1;else break}IHEAP[b+24+72]=_mqc_states+1472;IHEAP[b+24+68]=_mqc_states+96;IHEAP[b+24+0]=_mqc_states+128}_mqc_reset_enc.__index__=Runtime.getFunctionIndex(_mqc_reset_enc,"_mqc_reset_enc");function _mqc_resetstates(b){var f=null;for(f=0;;){f=f==0?0:e;IHEAP[b+24+(0+f)*4]=_mqc_states;var e=f+1;if(e!=19)f=1;else break}}_mqc_resetstates.__index__=Runtime.getFunctionIndex(_mqc_resetstates,"_mqc_resetstates");
function _mqc_setstate(b,f,e,c){IHEAP[b+24+f*4]=_mqc_states+(c*2+e)*16}_mqc_setstate.__index__=Runtime.getFunctionIndex(_mqc_setstate,"_mqc_setstate");function _mqc_restart_enc(b){var f=null,e;e=12-IHEAP[b+8];IHEAP[b]<<=IHEAP[b+8];var c=e>0;_mqc_byteout(b);if(c){c=b+8;var a=b+8;for(f=0;;){var d=(f==0?e:d)-IHEAP[c];IHEAP[b]<<=IHEAP[a];f=d>0;_mqc_byteout(b);if(f)f=1;else break}}return 1}_mqc_restart_enc.__index__=Runtime.getFunctionIndex(_mqc_restart_enc,"_mqc_restart_enc");
function _mqc_restart_init_enc(b){IHEAP[b+100]=b+24;IHEAP[b+4]=32768;IHEAP[b]=0;IHEAP[b+8]=12;IHEAP[b+12]+=-1;if(IHEAP[IHEAP[b+12]]==255)IHEAP[b+8]=13}_mqc_restart_init_enc.__index__=Runtime.getFunctionIndex(_mqc_restart_init_enc,"_mqc_restart_init_enc");
function _mqc_erterm_enc(b){var f=null,e=11-IHEAP[b+8]+1;if(e>0){var c=b+8,a=b+8,d=b;for(f=0;;){g=f==0?e:g;IHEAP[b]<<=IHEAP[(f==0?b:d)+8];IHEAP[c]=0;_mqc_byteout(b);var g=g-IHEAP[a];if(g>0)f=1;else break}f=2}else f=4;if(IHEAP[IHEAP[(f==2?d:b)+12]]!=255)_mqc_byteout(b)}_mqc_erterm_enc.__index__=Runtime.getFunctionIndex(_mqc_erterm_enc,"_mqc_erterm_enc");function _mqc_segmark_enc(b){var f=null;IHEAP[b+100]=b+24+72;for(f=0;;){f=f==0?0:e;_mqc_encode(b,(1+f)%2);var e=f+1;if(e!=4)f=1;else break}}
_mqc_segmark_enc.__index__=Runtime.getFunctionIndex(_mqc_segmark_enc,"_mqc_segmark_enc");function _mqc_init_dec(b,f,e){IHEAP[b+100]=b+24;IHEAP[b+16]=f;IHEAP[b+20]=f+e;IHEAP[b+12]=f;IHEAP[b]=e==0?16711680:IHEAP[IHEAP[b+12]]<<16;_mqc_bytein(b);IHEAP[b]<<=7;IHEAP[b+8]-=7;IHEAP[b+4]=32768}_mqc_init_dec.__index__=Runtime.getFunctionIndex(_mqc_init_dec,"_mqc_init_dec");
function _mqc_bytein(b){var f;if(IHEAP[b+12]!=IHEAP[b+20]){f=IHEAP[b+12]+1!=IHEAP[b+20]?IHEAP[IHEAP[b+12]+1]:255;if(IHEAP[IHEAP[b+12]]==255)if(f>143){IHEAP[b]+=65280;IHEAP[b+8]=8}else{IHEAP[b+12]+=1;IHEAP[b]+=f*512;IHEAP[b+8]=7}else{IHEAP[b+12]+=1;IHEAP[b]+=f*256;IHEAP[b+8]=8}}else{IHEAP[b]+=65280;IHEAP[b+8]=8}}_mqc_bytein.__index__=Runtime.getFunctionIndex(_mqc_bytein,"_mqc_bytein");
function _mqc_decode(b){var f,e,c;IHEAP[b+4]-=IHEAP[IHEAP[IHEAP[b+100]]];var a=unSign(IHEAP[b],32,true)>>>unSign(16,32,true);f=IHEAP[IHEAP[IHEAP[b+100]]];a=unSign(a,32,true)<unSign(f,32,true);a:do if(a){f=b;e=IHEAP[f+4]<IHEAP[IHEAP[IHEAP[f+100]]];IHEAP[f+4]=IHEAP[IHEAP[IHEAP[f+100]]];var d=IHEAP[IHEAP[IHEAP[f+100]]+4];if(e){e=d;IHEAP[IHEAP[f+100]]=IHEAP[IHEAP[IHEAP[f+100]]+8]}else{e=1-d;IHEAP[IHEAP[f+100]]=IHEAP[IHEAP[IHEAP[f+100]]+12]}f=e;c=b;e=c+8;d=c;var g=c+4,h=c,i=c+8;for(c=c+4;;){IHEAP[e]==
0&&_mqc_bytein(d);IHEAP[g]<<=1;IHEAP[h]<<=1;IHEAP[i]+=-1;if(!(IHEAP[c]<32768))break a}}else{IHEAP[b]-=IHEAP[IHEAP[IHEAP[b+100]]]<<16;f=b;if((IHEAP[b+4]&32768)==0){f=f;e=IHEAP[IHEAP[IHEAP[f+100]]+4];if(IHEAP[f+4]<IHEAP[IHEAP[IHEAP[f+100]]]){e=1-e;IHEAP[IHEAP[f+100]]=IHEAP[IHEAP[IHEAP[f+100]]+12]}else{e=e;IHEAP[IHEAP[f+100]]=IHEAP[IHEAP[IHEAP[f+100]]+8]}f=e;c=b;e=c+8;d=c;g=c+4;h=c;i=c+8;for(c=c+4;;){IHEAP[e]==0&&_mqc_bytein(d);IHEAP[g]<<=1;IHEAP[h]<<=1;IHEAP[i]+=-1;if(!(IHEAP[c]<32768))break a}}else f=
IHEAP[IHEAP[IHEAP[f+100]]+4]}while(0);return f}_mqc_decode.__index__=Runtime.getFunctionIndex(_mqc_decode,"_mqc_decode");function _opj_version(){return __str27105}_opj_version.__index__=Runtime.getFunctionIndex(_opj_version,"_opj_version");
function _opj_create_decompress(b){var f,e;e=_calloc(1,28);var c=e!=0;a:do if(c){IHEAP[e+8]=1;f=b;f=f==0?5:f==1?5:f==2?6:7;b:do if(f==7){_free(e);f=0;break a}else if(f==5){f=_j2k_create_decompress(e);IHEAP[e+16]=f;if(IHEAP[e+16]!=0)break b;_free(e);f=0;break a}else if(f==6){f=_jp2_create_decompress(e);IHEAP[e+20]=f;if(IHEAP[e+20]!=0)break b;_free(e);f=0;break a}while(0);IHEAP[e+12]=b;f=e}else f=0;while(0);return f}_opj_create_decompress.__index__=Runtime.getFunctionIndex(_opj_create_decompress,"_opj_create_decompress");
function _opj_destroy_decompress(b){var f;if(b!=0){f=IHEAP[b+12];f=f==0?1:f==1?1:f==2?2:3;if(f==1)_j2k_destroy_decompress(IHEAP[b+16]);else f==2&&_jp2_destroy_decompress(IHEAP[b+20]);_free(b)}}_opj_destroy_decompress.__index__=Runtime.getFunctionIndex(_opj_destroy_decompress,"_opj_destroy_decompress");function _opj_set_default_decoder_parameters(b){if(b!=0){_llvm_memset_p0i8_i32(b,0,8224,1,0);IHEAP[b+4]=0;IHEAP[b]=0;IHEAP[b+8220]=0;IHEAP[b+8200]=-1;IHEAP[b+8204]=-1}}
_opj_set_default_decoder_parameters.__index__=Runtime.getFunctionIndex(_opj_set_default_decoder_parameters,"_opj_set_default_decoder_parameters");
function _opj_setup_decoder(b,f){var e,c,a,d=b!=0;a:do if(d){if(f==0)break a;e=IHEAP[b+12];if(e==0)e=6;else if(e==1)e=6;else if(e==2)e=7;else break a;if(e==6){a=IHEAP[b+16];c=f;e=a;c=c;if(a==0)break a;if(c==0)break a;a=_calloc(1,116);IHEAP[a+36]=IHEAP[c];IHEAP[a+40]=IHEAP[c+4];IHEAP[a+44]=IHEAP[c+8220];IHEAP[e+64]=a}else if(e==7){c=f;e=IHEAP[b+20];c=c=c;e=IHEAP[e+4];c=c;if(e==0)break a;if(c==0)break a;a=_calloc(1,116);IHEAP[a+36]=IHEAP[c];IHEAP[a+40]=IHEAP[c+4];IHEAP[a+44]=IHEAP[c+8220];IHEAP[e+64]=
a}}while(0)}_opj_setup_decoder.__index__=Runtime.getFunctionIndex(_opj_setup_decoder,"_opj_setup_decoder");function _opj_decode(b,f){return _opj_decode_with_info(b,f,0)}_opj_decode.__index__=Runtime.getFunctionIndex(_opj_decode,"_opj_decode");
function _opj_decode_with_info(b,f,e){var c,a,d=b!=0;a:do if(d){if(f==0){c=1;break a}c=IHEAP[b+12];if(c==0)c=4;else if(c==1)c=5;else if(c==2)c=6;else{c=1;break a}if(c==4){a=_j2k_decode(IHEAP[b+16],f,e);c=2;break a}else if(c==5){a=_j2k_decode_jpt_stream(IHEAP[b+16],f,e);c=2;break a}else if(c==6){a=_jp2_decode(IHEAP[b+20],f,e);c=2;break a}}else c=1;while(0);if(c==1)a=0;return a}_opj_decode_with_info.__index__=Runtime.getFunctionIndex(_opj_decode_with_info,"_opj_decode_with_info");
function _opj_create_compress(b){var f,e,c;c=_calloc(1,28);var a=c!=0;a:do if(a){IHEAP[c+8]=0;f=b;f=f==0?6:f==2?7:8;b:do if(f==8){_free(c);f=0;break a}else if(f==6){f=c;e=_calloc(1,76);if(e!=0)IHEAP[e]=f;IHEAP[c+16]=e;if(IHEAP[c+16]!=0)break b;_free(c);f=0;break a}else if(f==7){f=_jp2_create_compress(c);IHEAP[c+20]=f;if(IHEAP[c+20]!=0)break b;_free(c);f=0;break a}while(0);IHEAP[c+12]=b;f=c}else f=0;while(0);return f}_opj_create_compress.__index__=Runtime.getFunctionIndex(_opj_create_compress,"_opj_create_compress");
function _opj_destroy_compress(b){var f;if(b!=0){f=IHEAP[b+12];f=f==0?1:f==2?2:3;if(f==1)_j2k_destroy_compress(IHEAP[b+16]);else f==2&&_jp2_destroy_compress(IHEAP[b+20]);_free(b)}}_opj_destroy_compress.__index__=Runtime.getFunctionIndex(_opj_destroy_compress,"_opj_destroy_compress");
function _opj_set_default_encoder_parameters(b){if(b!=0){_llvm_memset_p0i8_i32(b,0,18692,1,0);IHEAP[b+18676]=0;IHEAP[b+18680]=0;IHEAP[b+5592]=6;IHEAP[b+18684]=0;IHEAP[b+5596]=64;IHEAP[b+5600]=64;IHEAP[b+44]=0;IHEAP[b+5612]=-1;IHEAP[b+18188]=1;IHEAP[b+18192]=1;IHEAP[b+18688]=0;IHEAP[b+18196]=-1;IHEAP[b+18200]=-1;FHEAP[b+4792]=0;IHEAP[b+4788]=0;IHEAP[b+20]=0;IHEAP[b+24]=0;IHEAP[b+28]=0}}_opj_set_default_encoder_parameters.__index__=Runtime.getFunctionIndex(_opj_set_default_encoder_parameters,"_opj_set_default_encoder_parameters");
function _opj_setup_encoder(b,f,e){var c,a=b!=0;a:do if(a){if(f==0)break a;if(e==0)break a;c=IHEAP[b+12];if(c==0)c=3;else if(c==2)c=4;else break a;if(c==3)_j2k_setup_encoder(IHEAP[b+16],f,e);else c==4&&_jp2_setup_encoder(IHEAP[b+20],f,e)}while(0)}_opj_setup_encoder.__index__=Runtime.getFunctionIndex(_opj_setup_encoder,"_opj_setup_encoder");function _opj_encode(b,f,e,c){c!=0&&_opj_event_msg(b,2,__str128);return _opj_encode_with_info(b,f,e,0)}
_opj_encode.__index__=Runtime.getFunctionIndex(_opj_encode,"_opj_encode");function _opj_encode_with_info(b,f,e,c){var a,d,g=b!=0;a:do if(g){if(f==0){a=1;break a}if(e==0){a=1;break a}a=IHEAP[b+12];if(a==0)a=5;else if(a==2)a=6;else{a=1;break a}if(a==5){_j2k_encode(IHEAP[b+16],f,e,c);d=1;a=3;break a}else if(a==6){d=_jp2_encode(IHEAP[b+20],f,e,c);a=3;break a}}else a=1;while(0);if(a==1)d=0;return d}_opj_encode_with_info.__index__=Runtime.getFunctionIndex(_opj_encode_with_info,"_opj_encode_with_info");
function _opj_destroy_cstr_info(b){var f=null;if(b!=0){if(0<IHEAP[b+48]*IHEAP[b+44]){var e=b+88,c=b+44,a=b+48;for(f=0;;){h=f==0?0:h;f=1+h;var d=0+h,g=IHEAP[e];_free(IHEAP[g+572*d]);_free(IHEAP[g+572*d+548]);_free(IHEAP[g+572*d+568]);var h=h+1;if(f<IHEAP[a]*IHEAP[c])f=1;else break}}_free(IHEAP[b+88]);_free(IHEAP[b+68]);_free(IHEAP[b+60])}}_opj_destroy_cstr_info.__index__=Runtime.getFunctionIndex(_opj_destroy_cstr_info,"_opj_destroy_cstr_info");
function _pi_create_decode(b,f,e){var c,a=null,d,g,h,i,j;i=IHEAP[f+108]+5588*e;h=_calloc(IHEAP[i+420]+1,232);if(h!=0){g=0;var k=i+420,m=f+68,l=f+68,n=f+48,o=f+56,p=f+52,r=f+60,q=b+4,u=f+48,s=f+56,t=b+8,v=f+52,y=f+60,x=b+12,w=b+16,C=b+16,z=i+5584,A=b+24,B=b+24,D=b+16,J=b+16,E=i+12,N=i+424,Q=i+12,S=b+16,P=i+8,G=i+428,F=i+428,L=i+428,K=i+428,H=i+428;i=i+428;a:for(;;){if(!(g<IHEAP[k]+1)){c=4;break a}var M=e%IHEAP[m];c=e/IHEAP[l]|0;var I=IHEAP[o]*M+IHEAP[n],O=IHEAP[b];IHEAP[h+232*g+200]=I>O?I:O;I=IHEAP[r]*
c+IHEAP[p];O=IHEAP[q];IHEAP[h+232*g+204]=I>O?I:O;M=IHEAP[s]*(M+1)+IHEAP[u];I=IHEAP[t];IHEAP[h+232*g+208]=M<I?M:I;c=IHEAP[y]*(c+1)+IHEAP[v];M=IHEAP[x];IHEAP[h+232*g+212]=c<M?c:M;IHEAP[h+232*g+192]=IHEAP[w];c=_calloc(IHEAP[C],16);IHEAP[h+232*g+196]=c;if(IHEAP[h+232*g+196]!=0)a=3;else{c=6;break a}b:for(;;){var R=a==25?ca:0;c=a==25?qa:0;var T=a==25?ha:0;if(!(c<IHEAP[h+192]))break b;var V=IHEAP[h+232*g+196];ha=IHEAP[z];IHEAP[V+16*c]=IHEAP[IHEAP[A]+48*c];IHEAP[V+16*c+4]=IHEAP[IHEAP[B]+48*c+4];IHEAP[V+16*
c+8]=IHEAP[ha+1076*c+4];var ba=_calloc(IHEAP[V+16*c+8],16);IHEAP[V+16*c+12]=ba;ba=h;if(IHEAP[V+16*c+12]==0){c=10;break a}ca=IHEAP[V+16*c];I=(IHEAP[ba+200]+-1+ca)/ca|0;ca=IHEAP[V+16*c+4];M=(IHEAP[h+204]+-1+ca)/ca|0;ca=IHEAP[V+16*c];qa=(IHEAP[h+208]+-1+ca)/ca|0;ca=IHEAP[V+16*c+4];O=(IHEAP[h+212]+-1+ca)/ca|0;if(IHEAP[V+16*c+8]>R){var fa=IHEAP[V+16*c+8];a=11}else a=9;var ca=a==11?fa:R;if(0<IHEAP[V+16*c+8]){M=M+-1;I=I+-1;O=O+-1;var U=V+16*c+8;V=V+16*c+12;var $=ha+1076*c;for(a=13;;){pa=a==13?T:pa;da=a==
13?0:da;a=ha+1076*c+944+da*4;var Y=ha+1076*c+812+da*4,Z=da*-1+-1,W=da+1;j=IHEAP[V]+16*da;if((IHEAP[$]&1)!=0){IHEAP[j]=IHEAP[Y];IHEAP[j+4]=IHEAP[a]}else{IHEAP[j]=15;IHEAP[j+4]=15}var X=IHEAP[U];a=I+(1<<X+Z)>>X+Z;Y=M+(1<<X+Z)>>X+Z;var aa=qa+-1+(1<<X+Z)>>X+Z;Z=O+(1<<X+Z)>>X+Z;var ka=a>>IHEAP[j]<<IHEAP[j];X=Y>>IHEAP[j+4]<<IHEAP[j+4];var ga=IHEAP[j];ga=aa+-1+(1<<ga)>>ga<<IHEAP[j];var ja=IHEAP[j+4];ja=Z+-1+(1<<ja)>>ja<<IHEAP[j+4];if(a==aa)a=34;else{var ia=ga-ka>>IHEAP[j];a=16}IHEAP[j+8]=a==16?ia:0;if(Y==
Z)a=35;else{var ea=ja-X>>IHEAP[j+4];a=18}IHEAP[j+12]=a==18?ea:0;if(IHEAP[j+12]*IHEAP[j+8]>pa){var oa=IHEAP[j+12]*IHEAP[j+8];a=20}else a=30;var pa=a==30?pa:oa,da=da+1;if(W<IHEAP[U])a=22;else break}a=23}else a=31;var ha=a==23?pa:T,qa=c+1;a=25}IHEAP[h+232*g+20]=1;IHEAP[h+232*g+16]=IHEAP[h+232*g+20]*T;IHEAP[h+232*g+12]=IHEAP[h+232*g+16]*IHEAP[D];IHEAP[h+232*g+8]=IHEAP[h+232*g+12]*R;if(g==0){c=_calloc(R*IHEAP[J]*IHEAP[E]*T,2);IHEAP[h+232*g+4]=c;if(IHEAP[h+232*g+4]==0){c=27;break a}}else IHEAP[h+232*g+
4]=IHEAP[h+232*(g-1)+4];c=IHEAP[N]==0;IHEAP[h+232*g+40]=1;M=g;if(c){IHEAP[h+232*M+44]=0;IHEAP[h+232*g+44+4]=0;IHEAP[h+232*g+44+8]=IHEAP[Q];IHEAP[h+232*g+44+12]=R;IHEAP[h+232*g+44+16]=IHEAP[S];IHEAP[h+232*g+44+36]=IHEAP[P]}else{IHEAP[h+232*g+44]=IHEAP[G+M*148];IHEAP[h+232*g+44+4]=IHEAP[F+g*148+4];IHEAP[h+232*g+44+8]=IHEAP[L+g*148+8];IHEAP[h+232*g+44+12]=IHEAP[K+g*148+12];IHEAP[h+232*g+44+16]=IHEAP[H+g*148+16];IHEAP[h+232*g+44+36]=IHEAP[i+g*148+36]}IHEAP[h+232*g+44+20]=0;IHEAP[h+232*g+44+24]=0;IHEAP[h+
232*g+44+28]=T;g+=1;c=2}if(c==4)d=h;else if(c==6){_pi_destroy(h,f,e);d=0}else if(c==10){_pi_destroy(ba,f,e);d=0}else if(c==27){_pi_destroy(h,f,e);d=0}}else d=0;return d}_pi_create_decode.__index__=Runtime.getFunctionIndex(_pi_create_decode,"_pi_create_decode");
function _pi_destroy(b,f,e){var c,a=null,d;d=IHEAP[f+108]+5588*e;if(b!=0){if(0<IHEAP[d+420]+1){f=b+192;e=b+192;d=d+420;a=0;a:for(;;){m=a==0?0:m;a=0+m;var g=b+232*a+196,h=b+232*a+196,i=1+m,j=IHEAP[b+232*a+196]!=0;b:do if(j){if(0<IHEAP[f]){a=2;c=3}else{a=2;c=4}for(;;)if(c==3){k=a==6?k:0;a=k+1;c=IHEAP[g];IHEAP[c+16*k+12]!=0&&_free(IHEAP[c+16*k+12]);var k=k+1;if(a<IHEAP[e]){a=6;c=3}else{a=7;c=4}}else if(c==4){_free(IHEAP[h]);break b}}while(0);var m=m+1;if(i<IHEAP[d]+1)a=8;else break a}}IHEAP[b+4]!=0&&
_free(IHEAP[b+4]);_free(b)}}_pi_destroy.__index__=Runtime.getFunctionIndex(_pi_destroy,"_pi_destroy");
function _pi_initialise_encode(b,f,e,c){var a,d=null,g,h,i,j,k;j=IHEAP[f+108]+5588*e;i=_calloc(IHEAP[j+420]+1,232);if(i!=0){IHEAP[i]=IHEAP[f+16];h=0;var m=f+68,l=f+68,n=f+48,o=f+56,p=f+52,r=f+60,q=b+4,u=f+48,s=f+56,t=b+8,v=f+52,y=f+60,x=b+12,w=b+16,C=b+16,z=b+24,A=b+24,B=b+16;c=c==1;var D=b+16;d=1;a:for(;;){a=d==46?S:0;var J=d==46?P:0;if(!(h<IHEAP[j+420]+1)){a=4;break a}d=e%IHEAP[m];var E=e/IHEAP[l]|0,N=IHEAP[o]*d+IHEAP[n],Q=IHEAP[b];IHEAP[i+232*h+200]=N>Q?N:Q;N=IHEAP[r]*E+IHEAP[p];Q=IHEAP[q];IHEAP[i+
232*h+204]=N>Q?N:Q;d=IHEAP[s]*(d+1)+IHEAP[u];N=IHEAP[t];IHEAP[i+232*h+208]=d<N?d:N;E=IHEAP[y]*(E+1)+IHEAP[v];d=IHEAP[x];IHEAP[i+232*h+212]=E<d?E:d;IHEAP[i+232*h+192]=IHEAP[w];E=_calloc(IHEAP[C],16);IHEAP[i+232*h+196]=E;if(IHEAP[i+232*h+196]!=0)d=3;else{a=6;break a}b:for(;;){var S=d==25?K:a;E=d==25?aa:0;var P=d==25?X:J;if(!(E<IHEAP[i+232*h+192]))break b;var G=IHEAP[i+232*h+196];X=IHEAP[j+5584];IHEAP[G+16*E]=IHEAP[IHEAP[z]+48*E];IHEAP[G+16*E+4]=IHEAP[IHEAP[A]+48*E+4];IHEAP[G+16*E+8]=IHEAP[X+1076*E+
4];K=_malloc(IHEAP[G+16*E+8]*16);IHEAP[G+16*E+12]=K;if(IHEAP[G+16*E+12]==0){a=10;break a}K=IHEAP[G+16*E];Q=(IHEAP[i+232*h+200]+-1+K)/K|0;K=IHEAP[G+16*E+4];N=(IHEAP[i+232*h+204]+-1+K)/K|0;K=IHEAP[G+16*E];aa=(IHEAP[i+232*h+208]+-1+K)/K|0;K=IHEAP[G+16*E+4];var F=(IHEAP[i+232*h+212]+-1+K)/K|0;if(IHEAP[G+16*E+8]>S){var L=IHEAP[G+16*E+8];d=11}else d=9;var K=d==11?L:S;if(0<IHEAP[G+16*E+8]){N=N+-1;Q=Q+-1;F=F+-1;var H=G+16*E+8;G=G+16*E+12;var M=X+1076*E;for(d=13;;){Z=d==13?P:Z;W=d==13?0:W;d=X+1076*E+944+W*
4;var I=X+1076*E+812+W*4,O=W*-1+-1,R=W+1;k=IHEAP[G]+16*W;if((IHEAP[M]&1)!=0){IHEAP[k]=IHEAP[I];IHEAP[k+4]=IHEAP[d]}else{IHEAP[k]=15;IHEAP[k+4]=15}var T=IHEAP[H];d=Q+(1<<T+O)>>T+O;I=N+(1<<T+O)>>T+O;var V=aa+-1+(1<<T+O)>>T+O;O=F+(1<<T+O)>>T+O;var ba=d>>IHEAP[k]<<IHEAP[k];T=I>>IHEAP[k+4]<<IHEAP[k+4];var fa=IHEAP[k];fa=V+-1+(1<<fa)>>fa<<IHEAP[k];var ca=IHEAP[k+4];ca=O+-1+(1<<ca)>>ca<<IHEAP[k+4];if(d==V)d=54;else{var U=fa-ba>>IHEAP[k];d=16}IHEAP[k+8]=d==16?U:0;if(I==O)d=55;else{var $=ca-T>>IHEAP[k+4];
d=18}IHEAP[k+12]=d==18?$:0;if(IHEAP[k+12]*IHEAP[k+8]>Z){var Y=IHEAP[k+12]*IHEAP[k+8];d=20}else d=50;var Z=d==50?Z:Y,W=W+1;if(R<IHEAP[H])d=22;else break}d=23}else d=51;var X=d==23?Z:P,aa=E+1;d=25}IHEAP[i+232*h+20]=1;IHEAP[i+232*h+16]=IHEAP[i+232*h+20]*P;IHEAP[i+232*h+12]=IHEAP[i+232*h+16]*IHEAP[B];IHEAP[i+232*h+8]=IHEAP[i+232*h+12]*S;if(0<IHEAP[i+192]){d=8;a=26}else{d=8;a=27}b:for(;;)if(a==26){ia=d==37?ia:0;a=ia+1;d=IHEAP[i+196];if(0<IHEAP[d+16*ia+8]){J=d+16*ia+8;E=d+16*ia+12;N=d+16*ia;Q=d+16*ia+4;
for(d=28;;){ja=d==28?0:ja;d=ja*-1+-1;F=ja+1;G=IHEAP[E];H=(1<<IHEAP[G+16*ja]+IHEAP[J]+d)*IHEAP[N];G=(1<<IHEAP[G+16*ja+4]+IHEAP[J]+d)*IHEAP[Q];if(IHEAP[i+224]!=0){var ka=IHEAP[i+224];ka=ka<H?ka:H;d=30}else d=29;IHEAP[i+232*h+224]=d==30?ka:H;if(IHEAP[i+228]!=0){var ga=IHEAP[i+228];ga=ga<G?ga:G;d=32}else d=56;IHEAP[i+232*h+228]=d==32?ga:G;var ja=ja+1;if(F<IHEAP[J])d=34;else break}}var ia=ia+1;if(a<IHEAP[i+192]){d=37;a=26;continue b}d=38;a=27}else if(a==27){a=h==0?39:40;break b}if(a==39){a=_calloc(IHEAP[i+
232*h+8]*IHEAP[j+12],2);IHEAP[i+232*h+4]=a;if(IHEAP[i+232*h+4]==0){a=42;break a}}else if(a==40)IHEAP[i+232*h+4]=IHEAP[i+232*(h-1)+4];J=IHEAP[j+424]!=0;b:do if(J){if(IHEAP[f]==0)if(IHEAP[f]!=0|c^1){a=43;break b}IHEAP[j+428+h*148+76]=IHEAP[j+428+h*148+4];IHEAP[j+428+h*148+92]=IHEAP[j+428+h*148+16];IHEAP[j+428+h*148+72]=IHEAP[j+428+h*148];IHEAP[j+428+h*148+88]=IHEAP[j+428+h*148+12];IHEAP[j+428+h*148+84]=IHEAP[j+428+h*148+8];IHEAP[j+428+h*148+36]=IHEAP[j+428+h*148+32];if(!(h>0)){a=46;break b}if(IHEAP[j+
428+h*148+84]>IHEAP[j+428+(h-1)*148+84]){var ea=IHEAP[j+428+(h-1)*148+84];d=47}else d=45;IHEAP[j+428+h*148+68]=d==47?ea:0;a=46;break b}else a=43;while(0);if(a==43){IHEAP[j+428+h*148+76]=0;IHEAP[j+428+h*148+92]=IHEAP[D];IHEAP[j+428+h*148+72]=0;IHEAP[j+428+h*148+88]=S;IHEAP[j+428+h*148+68]=0;IHEAP[j+428+h*148+84]=IHEAP[j+12];IHEAP[j+428+h*148+36]=IHEAP[j+8]}IHEAP[j+428+h*148+80]=0;IHEAP[j+428+h*148+96]=P;IHEAP[j+428+h*148+100]=IHEAP[i+232*h+200];IHEAP[j+428+h*148+104]=IHEAP[i+232*h+208];IHEAP[j+428+
h*148+108]=IHEAP[i+232*h+204];IHEAP[j+428+h*148+112]=IHEAP[i+232*h+212];IHEAP[j+428+h*148+116]=IHEAP[i+232*h+224];IHEAP[j+428+h*148+120]=IHEAP[i+232*h+228];h+=1;d=46;a=2}if(a==4)g=i;else if(a==6){_pi_destroy(i,f,e);g=0}else if(a==10){_pi_destroy(i,f,e);g=0}else if(a==42){_pi_destroy(i,f,e);g=0}}else g=0;return g}_pi_initialise_encode.__index__=Runtime.getFunctionIndex(_pi_initialise_encode,"_pi_initialise_encode");
function _pi_next(b){var f,e=null,c,a,d,g,h,i,j,k,m,l,n,o,p,r,q,u,s,t,v,y,x;e=IHEAP[b+44+36];f=e==0?144:e==1?145:e==2?146:e==3?147:e==4?148:e==-1?149:150;if(f==150)x=0;else if(f==144){g=a=0;d=IHEAP[b+40]!=0;a:do{if(d){IHEAP[b+40]=0;IHEAP[b+36]=IHEAP[b+44+20];f=1}else{a=IHEAP[b+196]+16*IHEAP[b+24];f=0}break a}while(0);a:for(;;){b:do if(f==1){if(!(IHEAP[b+36]<IHEAP[b+44+8])){f=3;break a}IHEAP[b+28]=IHEAP[b+44];f=4;break b}else if(f==0){IHEAP[b+32]+=1;f=13;break b}while(0);b:for(;;){c:do if(f==4){var w=
b;if(!(IHEAP[b+28]<IHEAP[b+44+12])){f=6;break b}IHEAP[b+24]=IHEAP[w+44+4];f=7;break c}else if(f==13)if(IHEAP[b+32]<IHEAP[b+44+28]){f=14;break b}else{f=10;break c}while(0);for(;;)if(f==7){var C=b;if(!(IHEAP[b+24]<IHEAP[b+44+16])){f=9;break}a=IHEAP[b+196]+16*IHEAP[C+24];if(IHEAP[b+28]>=IHEAP[a+8])f=10;else{f=11;break}}else if(f==10){IHEAP[b+24]+=1;f=7}if(f==9){IHEAP[C+28]+=1;f=4}else if(f==11){d=IHEAP[a+12]+16*IHEAP[b+28];if(IHEAP[b]==0)IHEAP[b+44+28]=IHEAP[d+12]*IHEAP[d+8];IHEAP[b+32]=IHEAP[b+44+24];
f=13}}if(f==6){IHEAP[w+36]+=1;f=1}else if(f==14){g=IHEAP[b+12]*IHEAP[b+28]+IHEAP[b+8]*IHEAP[b+36]+IHEAP[b+16]*IHEAP[b+24]+IHEAP[b+20]*IHEAP[b+32];if(IHEAP[IHEAP[b+4]+2*g]!=0)f=0;else{f=15;break a}}}if(f==3)y=0;else if(f==15)y=IHEAP[IHEAP[b+4]+2*g]=1;x=y}else if(f==145){g=a=0;d=IHEAP[b+40]!=0;a:do{if(d){IHEAP[b+40]=0;IHEAP[b+28]=IHEAP[b+44];f=19}else{a=IHEAP[b+196]+16*IHEAP[b+24];f=18}break a}while(0);a:for(;;){b:do if(f==19){if(!(IHEAP[b+28]<IHEAP[b+44+12])){f=21;break a}IHEAP[b+36]=IHEAP[b+44+20];
f=22;break b}else if(f==18){IHEAP[b+32]+=1;f=31;break b}while(0);b:for(;;){c:do if(f==22){var z=b;if(!(IHEAP[b+36]<IHEAP[b+44+8])){f=24;break b}IHEAP[b+24]=IHEAP[z+44+4];f=25;break c}else if(f==31)if(IHEAP[b+32]<IHEAP[b+44+28]){f=32;break b}else{f=28;break c}while(0);for(;;)if(f==25){var A=b;if(!(IHEAP[b+24]<IHEAP[b+44+16])){f=27;break}a=IHEAP[b+196]+16*IHEAP[A+24];if(IHEAP[b+28]>=IHEAP[a+8])f=28;else{f=29;break}}else if(f==28){IHEAP[b+24]+=1;f=25}if(f==27){IHEAP[A+36]+=1;f=22}else if(f==29){d=IHEAP[a+
12]+16*IHEAP[b+28];if(IHEAP[b]==0)IHEAP[b+44+28]=IHEAP[d+12]*IHEAP[d+8];IHEAP[b+32]=IHEAP[b+44+24];f=31}}if(f==24){IHEAP[z+28]+=1;f=19}else if(f==32){g=IHEAP[b+12]*IHEAP[b+28]+IHEAP[b+8]*IHEAP[b+36]+IHEAP[b+16]*IHEAP[b+24]+IHEAP[b+20]*IHEAP[b+32];if(IHEAP[IHEAP[b+4]+2*g]!=0)f=18;else{f=33;break a}}}if(f==21)c=0;else if(f==33)c=IHEAP[IHEAP[b+4]+2*g]=1;x=c}else if(f==146){d=g=a=0;h=IHEAP[b+40]!=0;a:do if(h){IHEAP[b+40]=0;IHEAP[b+224]=0;IHEAP[b+228]=0;if(0<IHEAP[b+192]){e=35;b:for(;;){h=e==35?0:E;i=
1+h;a=IHEAP[b+196]+16*(0+h);if(0<IHEAP[a+8]){e=36;f=37}else{e=36;f=38}for(;;)if(f==37){k=e==43?J:0;j=k+1;u=k*-1+-1;p=IHEAP[a+12];q=(1<<IHEAP[p+16*k]+IHEAP[a+8]+u)*IHEAP[a];u=(1<<IHEAP[p+16*k+4]+IHEAP[a+8]+u)*IHEAP[a+4];if(IHEAP[b+224]!=0){r=IHEAP[b+224];var B=r<q?r:q;e=39}else e=37;IHEAP[b+224]=e==39?B:q;if(IHEAP[b+228]!=0){q=IHEAP[b+228];var D=q<u?q:u;e=41}else e=160;IHEAP[b+228]=e==41?D:u;var J=k+1;k=p+16*k;if(j<IHEAP[a+8]){e=43;f=37}else{g=k;e=44;f=38}}else if(f==38){var E=h+1;if(i<IHEAP[b+192]){e=
38;continue b}else break b}}}if(IHEAP[b]==0){IHEAP[b+44+60]=IHEAP[b+204];IHEAP[b+44+52]=IHEAP[b+200];IHEAP[b+44+64]=IHEAP[b+212];IHEAP[b+44+56]=IHEAP[b+208]}IHEAP[b+28]=IHEAP[b+44];f=48;break a}else f=70;while(0);a:for(;;){b:do if(f==48){if(!(IHEAP[b+28]<IHEAP[b+44+12])){f=50;break a}IHEAP[b+220]=IHEAP[b+44+60];f=51;break b}else if(f==70){IHEAP[b+36]+=1;f=68;break b}while(0);b:for(;;){c:do if(f==51){var N=b;if(!(IHEAP[b+220]<IHEAP[b+44+64])){f=53;break b}IHEAP[b+216]=IHEAP[N+44+52];f=54;break c}else if(f==
68)if(IHEAP[b+36]<IHEAP[b+44+8]){f=69;break b}else{f=58;break c}while(0);for(;;){if(f==54){var Q=b;if(!(IHEAP[b+216]<IHEAP[b+44+56])){f=56;break}IHEAP[b+24]=IHEAP[Q+44+4]}else if(f==58)IHEAP[b+24]+=1;h=b;if(IHEAP[b+24]<IHEAP[b+44+16]){a=IHEAP[b+196]+16*IHEAP[h+24];if(IHEAP[b+28]>=IHEAP[a+8])f=58;else{g=IHEAP[a+12]+16*IHEAP[b+28];l=IHEAP[a+8]+-1+(0-IHEAP[b+28]);i=IHEAP[a]<<l;h=IHEAP[b+200];i=i;n=(h+-1+i)/i|0;i=IHEAP[a+4]<<l;h=IHEAP[b+204];i=i;o=(h+-1+i)/i|0;i=IHEAP[a]<<l;h=IHEAP[b+208];i=i;h=(h+-1+
i)/i|0;j=IHEAP[a+4]<<l;i=IHEAP[b+212];j=j;i=(i+-1+j)/j|0;j=l+IHEAP[g];k=l+IHEAP[g+4];if(IHEAP[b+220]%(IHEAP[a+4]<<k)!=0){if(IHEAP[b+220]!=IHEAP[b+204]){f=58;continue}if((o<<l)%(1<<k)==0){f=58;continue}}if(IHEAP[b+216]%(IHEAP[a]<<j)!=0){if(IHEAP[b+216]!=IHEAP[b+200]){f=58;continue}if((n<<l)%(1<<j)==0){f=58;continue}}if(IHEAP[g+8]==0)f=58;else if(IHEAP[g+12]==0)f=58;else if(n==h)f=58;else if(o==i)f=58;else{f=67;break}}}else{i=b+216;IHEAP[i]=0-IHEAP[b+216]%IHEAP[b+224]+IHEAP[h+224]+IHEAP[i];f=54}}if(f==
56){h=b+220;IHEAP[h]=0-IHEAP[b+220]%IHEAP[b+228]+IHEAP[Q+228]+IHEAP[h];f=51}else if(f==67){i=IHEAP[a]<<l;h=IHEAP[b+216];j=i;i=IHEAP[g];h=(h+-1+j)/j|0;i=i;i=h>>i;j=IHEAP[g];h=n;j=j;h=i-(h>>j);j=IHEAP[a+4]<<l;i=IHEAP[b+220];k=j;j=IHEAP[g+4];i=(i+-1+k)/k|0;j=j;j=i>>j;k=IHEAP[g+4];i=o;k=k;i=j-(i>>k);IHEAP[b+32]=IHEAP[g+8]*i+h;IHEAP[b+36]=IHEAP[b+44+20];f=68}}if(f==53){IHEAP[N+28]+=1;f=48}else if(f==69){d=IHEAP[b+12]*IHEAP[b+28]+IHEAP[b+8]*IHEAP[b+36]+IHEAP[b+16]*IHEAP[b+24]+IHEAP[b+20]*IHEAP[b+32];if(IHEAP[IHEAP[b+
4]+2*d]!=0)f=70;else{f=71;break a}}}if(f==50)m=0;else if(f==71)m=IHEAP[IHEAP[b+4]+2*d]=1;x=m}else if(f==147){k=j=i=0;p=IHEAP[b+40]!=0;a:do{if(p){IHEAP[b+40]=0;IHEAP[b+224]=0;IHEAP[b+228]=0;if(0<IHEAP[b+192]){e=74;b:for(;;){p=e==74?0:F;u=1+p;i=IHEAP[b+196]+16*(0+p);if(0<IHEAP[i+8]){e=75;f=76}else{e=75;f=77}for(;;)if(f==76){s=e==82?G:0;r=s+1;N=s*-1+-1;m=IHEAP[i+12];l=(1<<IHEAP[m+16*s]+IHEAP[i+8]+N)*IHEAP[i];N=(1<<IHEAP[m+16*s+4]+IHEAP[i+8]+N)*IHEAP[i+4];if(IHEAP[b+224]!=0){Q=IHEAP[b+224];var S=Q<l?
Q:l;e=78}else e=76;IHEAP[b+224]=e==78?S:l;if(IHEAP[b+228]!=0){l=IHEAP[b+228];var P=l<N?l:N;e=80}else e=171;IHEAP[b+228]=e==80?P:N;var G=s+1;s=m+16*s;if(r<IHEAP[i+8]){e=82;f=76}else{j=s;e=83;f=77}}else if(f==77){var F=p+1;if(u<IHEAP[b+192]){e=77;continue b}else break b}}}if(IHEAP[b]==0){IHEAP[b+44+60]=IHEAP[b+204];IHEAP[b+44+52]=IHEAP[b+200];IHEAP[b+44+64]=IHEAP[b+212];IHEAP[b+44+56]=IHEAP[b+208]}IHEAP[b+220]=IHEAP[b+44+60];f=87}else{i=IHEAP[b+196]+16*IHEAP[b+24];f=73}break a}while(0);a:for(;;){b:do if(f==
87){if(!(IHEAP[b+220]<IHEAP[b+44+64])){f=89;break a}IHEAP[b+216]=IHEAP[b+44+52];f=90;break b}else if(f==73){IHEAP[b+36]+=1;f=106;break b}while(0);b:for(;;){c:do if(f==90){d=b;if(!(IHEAP[b+216]<IHEAP[b+44+56])){f=92;break b}IHEAP[b+24]=IHEAP[d+44+4];f=93;break c}else if(f==106)if(IHEAP[b+36]<IHEAP[b+44+8]){f=107;break b}else{f=98;break c}while(0);for(;;){if(f==93){h=b;if(!(IHEAP[b+24]<IHEAP[b+44+16])){f=95;break}i=IHEAP[b+196]+16*IHEAP[h+24];IHEAP[b+28]=IHEAP[b+44]}else if(f==98)IHEAP[b+28]+=1;u=IHEAP[b+
28];r=IHEAP[i+8];p=IHEAP[b+44+12];r=r;s=p;m=r;l=b;if(u<(p<r?s:m)){j=IHEAP[i+12]+16*IHEAP[l+28];g=IHEAP[i+8]+-1+(0-IHEAP[b+28]);q=IHEAP[i]<<g;p=IHEAP[b+200];q=q;q=(p+-1+q)/q|0;u=IHEAP[i+4]<<g;p=IHEAP[b+204];u=u;t=(p+-1+u)/u|0;u=IHEAP[i]<<g;p=IHEAP[b+208];u=u;p=(p+-1+u)/u|0;r=IHEAP[i+4]<<g;u=IHEAP[b+212];r=r;u=(u+-1+r)/r|0;r=g+IHEAP[j];s=g+IHEAP[j+4];if(IHEAP[b+220]%(IHEAP[i+4]<<s)!=0){if(IHEAP[b+220]!=IHEAP[b+204]){f=98;continue}if((t<<g)%(1<<s)==0){f=98;continue}}if(IHEAP[b+216]%(IHEAP[i]<<r)!=0){if(IHEAP[b+
216]!=IHEAP[b+200]){f=98;continue}if((q<<g)%(1<<r)==0){f=98;continue}}if(IHEAP[j+8]==0)f=98;else if(IHEAP[j+12]==0)f=98;else if(q==p)f=98;else if(t==u)f=98;else{f=105;break}}else{IHEAP[l+24]+=1;f=93}}if(f==95){p=b+216;IHEAP[p]=0-IHEAP[b+216]%IHEAP[b+224]+IHEAP[h+224]+IHEAP[p];f=90}else if(f==105){u=IHEAP[i]<<g;p=IHEAP[b+216];r=u;u=IHEAP[j];p=(p+-1+r)/r|0;u=u;u=p>>u;r=IHEAP[j];p=q;r=r;p=u-(p>>r);r=IHEAP[i+4]<<g;u=IHEAP[b+220];s=r;r=IHEAP[j+4];u=(u+-1+s)/s|0;r=r;r=u>>r;s=IHEAP[j+4];u=t;s=s;u=r-(u>>
s);IHEAP[b+32]=IHEAP[j+8]*u+p;IHEAP[b+36]=IHEAP[b+44+20];f=106}}if(f==92){p=b+220;IHEAP[p]=0-IHEAP[b+220]%IHEAP[b+228]+IHEAP[d+228]+IHEAP[p];f=87}else if(f==107){k=IHEAP[b+12]*IHEAP[b+28]+IHEAP[b+8]*IHEAP[b+36]+IHEAP[b+16]*IHEAP[b+24]+IHEAP[b+20]*IHEAP[b+32];if(IHEAP[IHEAP[b+4]+2*k]!=0)f=73;else{f=108;break a}}}if(f==89)a=0;else if(f==108)a=IHEAP[IHEAP[b+4]+2*k]=1;x=a}else if(f==148){g=d=a=0;h=IHEAP[b+40]!=0;a:do{if(h){IHEAP[b+40]=0;IHEAP[b+24]=IHEAP[b+44+4];f=111}else{a=IHEAP[b+196]+16*IHEAP[b+24];
f=110}break a}while(0);a:for(;;){b:do if(f==111){if(!(IHEAP[b+24]<IHEAP[b+44+16])){f=113;break a}a=IHEAP[b+196]+16*IHEAP[b+24];IHEAP[b+224]=0;IHEAP[b+228]=0;if(0<IHEAP[a+8]){for(e=114;;){m=e==114?0:L;d=1+m;t=-1+m*-1;h=0+m;q=IHEAP[a+12];l=(1<<IHEAP[q+16*h]+IHEAP[a+8]+t)*IHEAP[a];t=(1<<IHEAP[q+16*h+4]+IHEAP[a+8]+t)*IHEAP[a+4];if(IHEAP[b+224]!=0){u=IHEAP[b+224];u=u<l?u:l;e=116}else e=115;IHEAP[b+224]=e==116?u:l;if(IHEAP[b+228]!=0){r=IHEAP[b+228];r=r<t?r:t;e=118}else e=184;IHEAP[b+228]=e==118?r:t;var L=
m+1,K=q+16*h;if(d<IHEAP[a+8])e=120;else break}d=K}if(IHEAP[b]==0){IHEAP[b+44+60]=IHEAP[b+204];IHEAP[b+44+52]=IHEAP[b+200];IHEAP[b+44+64]=IHEAP[b+212];IHEAP[b+44+56]=IHEAP[b+208]}IHEAP[b+220]=IHEAP[b+44+60];f=124;break b}else if(f==110){IHEAP[b+36]+=1;f=140;break b}while(0);b:for(;;){c:do if(f==124){k=b;if(!(IHEAP[b+220]<IHEAP[b+44+64])){f=126;break b}IHEAP[b+216]=IHEAP[k+44+52];f=127;break c}else if(f==140)if(IHEAP[b+36]<IHEAP[b+44+8]){f=141;break b}else{f=132;break c}while(0);for(;;){if(f==127){p=
b;if(!(IHEAP[b+216]<IHEAP[b+44+56])){f=129;break}IHEAP[b+28]=IHEAP[p+44]}else if(f==132)IHEAP[b+28]+=1;q=IHEAP[b+28];m=IHEAP[a+8];h=IHEAP[b+44+12];l=m;t=h;N=l;m=b;if(q<(h<l?t:N)){d=IHEAP[a+12]+16*IHEAP[m+28];j=IHEAP[a+8]+-1+(0-IHEAP[b+28]);q=IHEAP[a]<<j;h=IHEAP[b+200];q=q;s=(h+-1+q)/q|0;q=IHEAP[a+4]<<j;h=IHEAP[b+204];q=q;v=(h+-1+q)/q|0;q=IHEAP[a]<<j;h=IHEAP[b+208];q=q;h=(h+-1+q)/q|0;m=IHEAP[a+4]<<j;q=IHEAP[b+212];m=m;q=(q+-1+m)/m|0;m=j+IHEAP[d];l=j+IHEAP[d+4];if(IHEAP[b+220]%(IHEAP[a+4]<<l)!=0){if(IHEAP[b+
220]!=IHEAP[b+204]){f=132;continue}if((v<<j)%(1<<l)==0){f=132;continue}}if(IHEAP[b+216]%(IHEAP[a]<<m)!=0){if(IHEAP[b+216]!=IHEAP[b+200]){f=132;continue}if((s<<j)%(1<<m)==0){f=132;continue}}if(IHEAP[d+8]==0)f=132;else if(IHEAP[d+12]==0)f=132;else if(s==h)f=132;else if(v==q)f=132;else{f=139;break}}else{h=b+216;IHEAP[h]=0-IHEAP[b+216]%IHEAP[b+224]+IHEAP[m+224]+IHEAP[h];f=127}}if(f==129){h=b+220;IHEAP[h]=0-IHEAP[b+220]%IHEAP[b+228]+IHEAP[p+228]+IHEAP[h];f=124}else if(f==139){q=IHEAP[a]<<j;h=IHEAP[b+216];
m=q;q=IHEAP[d];h=(h+-1+m)/m|0;q=q;q=h>>q;m=IHEAP[d];h=s;m=m;h=q-(h>>m);m=IHEAP[a+4]<<j;q=IHEAP[b+220];l=m;m=IHEAP[d+4];q=(q+-1+l)/l|0;m=m;m=q>>m;l=IHEAP[d+4];q=v;l=l;q=m-(q>>l);IHEAP[b+32]=IHEAP[d+8]*q+h;IHEAP[b+36]=IHEAP[b+44+20];f=140}}if(f==126){IHEAP[k+24]+=1;f=111}else if(f==141){g=IHEAP[b+12]*IHEAP[b+28]+IHEAP[b+8]*IHEAP[b+36]+IHEAP[b+16]*IHEAP[b+24]+IHEAP[b+20]*IHEAP[b+32];if(IHEAP[IHEAP[b+4]+2*g]!=0)f=110;else{f=142;break a}}}if(f==113)i=0;else if(f==142)i=IHEAP[IHEAP[b+4]+2*g]=1;x=i}else if(f==
149)x=0;return x}_pi_next.__index__=Runtime.getFunctionIndex(_pi_next,"_pi_next");
function _pi_create_encode(b,f,e,c,a,d,g,h){var i=STACKTOP;STACKTOP+=4;_memset(i,0,4);var j,k=null,m;e=IHEAP[f+108]+5588*e+428+c*148;IHEAP[b+232*c+40]=1;IHEAP[b+232*c+44+36]=IHEAP[e+36];var l=IHEAP[e+36];j=l==4?42:l==0?43:l==3?44:l==1?45:l==2?46:l==-1?47:0;a:do if(j==42){_llvm_memcpy_p0i8_p0i8_i32(i,__str29106,4,1,0);j=0;break a}else if(j==43){_llvm_memcpy_p0i8_p0i8_i32(i,__str130,4,1,0);j=0;break a}else if(j==44){_llvm_memcpy_p0i8_p0i8_i32(i,__str231,4,1,0);j=0;break a}else if(j==45){_llvm_memcpy_p0i8_p0i8_i32(i,
__str332,4,1,0);j=0;break a}else if(j==46){_llvm_memcpy_p0i8_p0i8_i32(i,__str433,4,1,0);j=0;break a}else if(j==47){j=m=1;break a}while(0);if(j==0){m=IHEAP[f+16]!=0;a:do if(m){m=IHEAP[f]!=0;b:do if(m)j=3;else{j=g==1?2:3;break b}while(0);if(j==3)if(IHEAP[f]==0){j=5;break a}if(!(a<h)){j=8;break a}f=d;g=a==0;h=d;m=a==0;l=d;var n=a==0,o=d,p=a==0;d=d;a=a==0;for(k=7;;){s=k==7?0:s;u=k==7?1:u;var r=3+s*-1;j=IHEAP[i+r];if(j==67){k=9;j=48}else if(j==82){k=9;j=49}else if(j==76){k=9;j=50}else if(j==80){k=9;j=
51}else{k=9;j=39}if(j==48)if(r>f){IHEAP[b+232*c+44+4]=IHEAP[e+76];IHEAP[b+232*c+44+16]=IHEAP[e+92];k=10}else if(g){IHEAP[e+132]=IHEAP[e+76];IHEAP[b+232*c+44+4]=IHEAP[e+132];IHEAP[b+232*c+44+16]=IHEAP[e+132]+1;IHEAP[e+132]+=1;k=12}else{j=IHEAP[e+132];if(u==1){k=e;if(j==IHEAP[e+92]){IHEAP[e+132]=IHEAP[k+76];IHEAP[b+232*c+44+4]=IHEAP[e+132];IHEAP[b+232*c+44+16]=IHEAP[e+132]+1;IHEAP[e+132]+=1;k=13}else{IHEAP[b+232*c+44+4]=IHEAP[k+132];IHEAP[b+232*c+44+16]=IHEAP[e+132]+1;IHEAP[e+132]+=1;k=14}}else{IHEAP[b+
232*c+44+4]=j-1;IHEAP[b+232*c+44+16]=IHEAP[e+132];k=15}}else if(j==49)if(r>h){IHEAP[b+232*c+44]=IHEAP[e+72];IHEAP[b+232*c+44+12]=IHEAP[e+88];k=16}else if(m){IHEAP[e+128]=IHEAP[e+72];IHEAP[b+232*c+44]=IHEAP[e+128];IHEAP[b+232*c+44+12]=IHEAP[e+128]+1;IHEAP[e+128]+=1;k=17}else{j=IHEAP[e+128];if(u==1){k=e;if(j==IHEAP[e+88]){IHEAP[e+128]=IHEAP[k+72];IHEAP[b+232*c+44]=IHEAP[e+128];IHEAP[b+232*c+44+12]=IHEAP[e+128]+1;IHEAP[e+128]+=1;k=18}else{IHEAP[b+232*c+44]=IHEAP[k+128];IHEAP[b+232*c+44+12]=IHEAP[e+128]+
1;IHEAP[e+128]+=1;k=19}}else{IHEAP[b+232*c+44]=j-1;IHEAP[b+232*c+44+12]=IHEAP[e+128];k=20}}else if(j==50)if(r>l){IHEAP[b+232*c+44+20]=IHEAP[e+68];IHEAP[b+232*c+44+8]=IHEAP[e+84];k=21}else if(n){IHEAP[e+124]=IHEAP[e+68];IHEAP[b+232*c+44+20]=IHEAP[e+124];IHEAP[b+232*c+44+8]=IHEAP[e+124]+1;IHEAP[e+124]+=1;k=22}else{j=IHEAP[e+124];if(u==1){k=e;if(j==IHEAP[e+84]){IHEAP[e+124]=IHEAP[k+68];IHEAP[b+232*c+44+20]=IHEAP[e+124];IHEAP[b+232*c+44+8]=IHEAP[e+124]+1;IHEAP[e+124]+=1;k=23}else{IHEAP[b+232*c+44+20]=
IHEAP[k+124];IHEAP[b+232*c+44+8]=IHEAP[e+124]+1;IHEAP[e+124]+=1;k=24}}else{IHEAP[b+232*c+44+20]=j-1;IHEAP[b+232*c+44+8]=IHEAP[e+124];k=25}}else if(j==51){j=IHEAP[e+36];j=j==0?52:j==1?52:53;if(j==53)if(r>o){IHEAP[b+232*c+44+52]=IHEAP[e+100];IHEAP[b+232*c+44+60]=IHEAP[e+108];IHEAP[b+232*c+44+56]=IHEAP[e+104];IHEAP[b+232*c+44+64]=IHEAP[e+112];k=31}else if(p){IHEAP[e+140]=IHEAP[e+100];IHEAP[e+144]=IHEAP[e+108];IHEAP[b+232*c+44+52]=IHEAP[e+140];IHEAP[b+232*c+44+56]=IHEAP[e+116]+IHEAP[e+140]+(0-IHEAP[e+
140]%IHEAP[e+116]);IHEAP[b+232*c+44+60]=IHEAP[e+144];IHEAP[b+232*c+44+64]=IHEAP[e+120]+IHEAP[e+144]+(0-IHEAP[e+144]%IHEAP[e+120]);IHEAP[e+140]=IHEAP[b+232*c+44+56];IHEAP[e+144]=IHEAP[b+232*c+44+64];k=32}else{k=IHEAP[e+140];r=e;if(u==1){j=e;if(k>=IHEAP[r+104]){var q=e;if(IHEAP[j+144]>=IHEAP[e+112]){IHEAP[e+144]=IHEAP[q+108];IHEAP[b+232*c+44+60]=IHEAP[e+144];IHEAP[b+232*c+44+64]=IHEAP[e+120]+IHEAP[e+144]+(0-IHEAP[e+144]%IHEAP[e+120]);IHEAP[e+144]=IHEAP[b+232*c+44+64];k=33}else{IHEAP[b+232*c+44+60]=
IHEAP[q+144];IHEAP[b+232*c+44+64]=IHEAP[e+120]+IHEAP[e+144]+(0-IHEAP[e+144]%IHEAP[e+120]);IHEAP[e+144]=IHEAP[b+232*c+44+64];k=35}q=k==35?0:1;IHEAP[e+140]=IHEAP[e+100];IHEAP[b+232*c+44+52]=IHEAP[e+140];IHEAP[b+232*c+44+56]=IHEAP[e+116]+IHEAP[e+140]+(0-IHEAP[e+140]%IHEAP[e+116]);IHEAP[e+140]=IHEAP[b+232*c+44+56];k=36}else{IHEAP[b+232*c+44+52]=IHEAP[j+140];IHEAP[b+232*c+44+56]=IHEAP[e+116]+IHEAP[e+140]+(0-IHEAP[e+140]%IHEAP[e+116]);IHEAP[e+140]=IHEAP[b+232*c+44+56];IHEAP[b+232*c+44+60]=0-IHEAP[e+120]+
IHEAP[e+144]+(0-IHEAP[e+144]%IHEAP[e+120]);IHEAP[b+232*c+44+64]=IHEAP[e+144];k=37}}else{IHEAP[b+232*c+44+52]=0-IHEAP[r+116]+k+(0-IHEAP[e+140]%IHEAP[e+116]);IHEAP[b+232*c+44+56]=IHEAP[e+140];IHEAP[b+232*c+44+60]=0-IHEAP[e+120]+IHEAP[e+144]+(0-IHEAP[e+144]%IHEAP[e+120]);IHEAP[b+232*c+44+64]=IHEAP[e+144];k=38}}else if(j==52)if(r>d){IHEAP[b+232*c+44+24]=IHEAP[e+80];IHEAP[b+232*c+44+28]=IHEAP[e+96];k=26}else if(a){IHEAP[e+136]=IHEAP[e+80];IHEAP[b+232*c+44+24]=IHEAP[e+136];IHEAP[b+232*c+44+28]=IHEAP[e+
136]+1;IHEAP[e+136]+=1;k=27}else{j=IHEAP[e+136];if(u==1){k=e;if(j==IHEAP[e+96]){IHEAP[e+136]=IHEAP[k+80];IHEAP[b+232*c+44+24]=IHEAP[e+136];IHEAP[b+232*c+44+28]=IHEAP[e+136]+1;IHEAP[e+136]+=1;k=28}else{IHEAP[b+232*c+44+24]=IHEAP[k+136];IHEAP[b+232*c+44+28]=IHEAP[e+136]+1;IHEAP[e+136]+=1;k=29}}else{IHEAP[b+232*c+44+24]=j-1;IHEAP[b+232*c+44+28]=IHEAP[e+136];k=30}}}var u=k==9?u:k==12?u:k==13?1:k==14?0:k==15?u:k==10?u:k==17?u:k==18?1:k==19?0:k==20?u:k==16?u:k==22?u:k==23?1:k==24?0:k==25?u:k==21?u:k==31?
u:k==38?u:k==36?q:k==37?0:k==32?u:k==26?u:k==30?u:k==29?0:k==28?1:u,s=s+1;if(s!=4)k=39;else break}j=8;break a}else j=5;while(0);if(j==5){IHEAP[b+232*c+44]=IHEAP[e+72];IHEAP[b+232*c+44+12]=IHEAP[e+88];IHEAP[b+232*c+44+4]=IHEAP[e+76];IHEAP[b+232*c+44+16]=IHEAP[e+92];IHEAP[b+232*c+44+20]=IHEAP[e+68];IHEAP[b+232*c+44+8]=IHEAP[e+84];IHEAP[b+232*c+44+24]=IHEAP[e+80];IHEAP[b+232*c+44+28]=IHEAP[e+96];IHEAP[b+232*c+44+52]=IHEAP[e+100];IHEAP[b+232*c+44+60]=IHEAP[e+108];IHEAP[b+232*c+44+56]=IHEAP[e+104];IHEAP[b+
232*c+44+64]=IHEAP[e+112]}m=0}b=m;STACKTOP=i;return b}_pi_create_encode.__index__=Runtime.getFunctionIndex(_pi_create_encode,"_pi_create_encode");function _raw_create(){return _malloc(28)}_raw_create.__index__=Runtime.getFunctionIndex(_raw_create,"_raw_create");function _raw_destroy(b){b!=0&&_free(b)}_raw_destroy.__index__=Runtime.getFunctionIndex(_raw_destroy,"_raw_destroy");function _raw_numbytes(b){return IHEAP[b+16]-IHEAP[b+20]}_raw_numbytes.__index__=Runtime.getFunctionIndex(_raw_numbytes,"_raw_numbytes");
function _raw_init_dec(b,f,e){IHEAP[b+20]=f;IHEAP[b+8]=e;IHEAP[b+12]=0;IHEAP[b]=0;IHEAP[b+4]=0}_raw_init_dec.__index__=Runtime.getFunctionIndex(_raw_init_dec,"_raw_init_dec");function _raw_decode(b){if(IHEAP[b+4]==0){IHEAP[b+4]=8;if(IHEAP[b+12]==IHEAP[b+8])IHEAP[b]=-1;else{if(IHEAP[b]==255)IHEAP[b+4]=7;IHEAP[b]=IHEAP[IHEAP[b+20]+IHEAP[b+12]];IHEAP[b+12]+=1}}IHEAP[b+4]+=-1;return IHEAP[b]>>IHEAP[b+4]&1}_raw_decode.__index__=Runtime.getFunctionIndex(_raw_decode,"_raw_decode");
function _t1_create(b){var f;f=_malloc(40);if(f!=0){IHEAP[f]=b;b=_malloc(104);IHEAP[f+4]=b;b=_malloc(28);IHEAP[f+8]=b;IHEAP[f+12]=0;IHEAP[f+16]=0;IHEAP[f+28]=0;IHEAP[f+32]=0;f=f}else f=0;return f}_t1_create.__index__=Runtime.getFunctionIndex(_t1_create,"_t1_create");function _t1_destroy(b){var f;if(b!=0){f=IHEAP[b+4];f!=0&&_free(f);f=IHEAP[b+8];f!=0&&_free(f);_free(IHEAP[b+12]);_free(IHEAP[b+16]);_free(b)}}_t1_destroy.__index__=Runtime.getFunctionIndex(_t1_destroy,"_t1_destroy");
function _t1_encode_cblks(b,f,e){var c=STACKTOP;STACKTOP+=4;_memset(c,0,4);var a,d=null,g;FHEAP[f+28]=0;var h=f+16,i=f+20,j=e+5584,k=b+12,m=b+20,l=b+24,n=f+16;e=e+16;d=0;a:for(;;){Tb=d==6?Tb:0;var o=0+Tb,p=_mct_norms_real+o*8,r=_mct_norms+o*8;if(!(o<IHEAP[h])){a=3;break a}var q=IHEAP[i],u=IHEAP[j],s=IHEAP[q+32*o+8]-IHEAP[q+32*o],t=q+32*o+16,v=q+32*o+24;q=q+32*o+20;var y=u+1076*o+16;o=u+1076*o+20;d=2;b:for(;;){u=d==9?lb:0;var x=u+-1,w=u*-1+-1;if(!(u<IHEAP[t]))break b;lb=IHEAP[q];var C=lb+124*u+20,
z=lb+124*u+16,A=lb+124*u+24;d=5;c:for(;;){var B=d==11?zb:0,D=lb+124*u+28+B*32+20,J=lb+124*u+28+B*32+4,E=lb+124*u+28+B*32+16,N=lb+124*u+28+B*32+28,Q=lb+124*u+28+B*32;if(B<IHEAP[A])d=7;else break c;d:for(;;){zb=d==14?Xb:0;if(!(zb<IHEAP[C]*IHEAP[z]))break d;var S=IHEAP[D];Xb=S+36*zb+24;var P=S+36*zb+20;S=S+36*zb+16;d=10;e:for(;;){var G=d==200?Xa:0;if(!(G<IHEAP[P]*IHEAP[S]))break e;Xa=IHEAP[Xb];var F=IHEAP[Xa+48*G+12]-IHEAP[Q],L=IHEAP[Xa+48*G+16]-IHEAP[J];if((IHEAP[E]&1)!=0){var K=IHEAP[q];K=0-IHEAP[K+
124*x]+IHEAP[K+124*u+-116]+F;d=15}else d=13;F=d==15?K:F;if((IHEAP[E]&2)!=0){var H=IHEAP[q];H=0-IHEAP[H+124*u+-120]+IHEAP[H+124*u+-112]+L;d=17}else d=204;L=d==17?H:L;if(_allocate_buffers(b,IHEAP[Xa+48*G+20]-IHEAP[Xa+48*G+12],IHEAP[Xa+48*G+24]-IHEAP[Xa+48*G+16])==0){a=20;break a}var M=IHEAP[k],I=IHEAP[m],O=IHEAP[l],R=IHEAP[v],T=IHEAP[o]==1,V=0<O;f:do if(T){if(!V)break f;if(0<I){d=22;a=26}else{d=22;a=27}g:for(;;)if(a==26){U=d==29?U:0;var ba=I*U,fa=F+s*(L+U);for(d=26;;){ca=d==26?0:ca;IHEAP[M+4*(ba+ca)]=
IHEAP[R+4*(fa+ca)]<<6;var ca=ca+1;if(ca!=I)d=28;else break}var U=U+1;if(U<O){d=29;a=26}else break g}else if(a==27){var $=(d==27?$:0)+1;if($<O)a=d=27;else break g}}else{if(!V)break f;if(0<I){d=25;a=32}else{d=25;a=33}g:for(;;)if(a==32){W=d==35?W:0;ba=I*W;fa=F+s*(L+W);for(d=32;;){Z=d==32?0:Z;d=M+4*(ba+Z);var Y=IHEAP[R+4*(fa+Z)];Y=(67108864/(_floorf(FHEAP[N]*8192)|0)|0)*Y;IHEAP[d]=(Y+(Y&4096)>>13&4294967295)>>5;var Z=Z+1;if(Z!=I)d=34;else break}var W=W+1;if(W<O){d=35;a=32}else break g}else if(a==33){var X=
(d==33?X:0)+1;if(X<O)a=d=33;else break g}}while(0);var aa=IHEAP[E],ka=IHEAP[t];R=IHEAP[o];M=FHEAP[N];L=IHEAP[y];var ga=IHEAP[n],ja=IHEAP[e];F=IHEAP[b+4];IHEAP[c]=0;I=0<IHEAP[b+24]*IHEAP[b+20];f:do if(I){O=IHEAP[b+12];d=IHEAP[b+24]*IHEAP[b+20];T=d>1?d:1;d=37;g:for(;;){ea=d==37?0:ea;ia=d==37?0:ia;d=IHEAP[O+4*ea];V=0-d;d=d>-1?d:V;var ia=ia>d?ia:d,ea=ea+1;if(ea!=T)d=38;else break g}if(ia==0){d=39;break f}if(ia>1){d=40;a=42}else{d=40;a=43}for(;;)if(a==42){da=d==42?da:0;var oa=da+1,pa=(d==42?pa:ia)>>1,
da=da+1;if(pa>1)a=d=42;else{d=42;a=43}}else if(a==43){var ha=(d==40?0:oa)+-5;d=43;break f}}else d=23;while(0);IHEAP[Xa+48*G+28]=d==43?ha:d==39?0:0;d=IHEAP[Xa+48*G+28];IHEAP[F+24+4]=_mqc_states;IHEAP[F+24+8]=_mqc_states;IHEAP[F+24+12]=_mqc_states;IHEAP[F+24+16]=_mqc_states;IHEAP[F+24+20]=_mqc_states;IHEAP[F+24+24]=_mqc_states;IHEAP[F+24+28]=_mqc_states;IHEAP[F+24+32]=_mqc_states;IHEAP[F+24+36]=_mqc_states;IHEAP[F+24+40]=_mqc_states;IHEAP[F+24+44]=_mqc_states;IHEAP[F+24+48]=_mqc_states;IHEAP[F+24+52]=
_mqc_states;IHEAP[F+24+56]=_mqc_states;IHEAP[F+24+60]=_mqc_states;IHEAP[F+24+64]=_mqc_states;I=d-1;IHEAP[F+24+72]=_mqc_states+1472;IHEAP[F+24+68]=_mqc_states+96;IHEAP[F+24]=_mqc_states+128;d=IHEAP[Xa+48*G];IHEAP[F+100]=F+24;IHEAP[F+4]=32768;IHEAP[F]=0;IHEAP[F+12]=d+-1;IHEAP[F+8]=12;if(IHEAP[IHEAP[F+12]]==255)IHEAP[F+8]=13;IHEAP[F+16]=d;if(I>=0){O=(L&1)!=0;R=R==1;T=f+28;V=(L&4)!=0;ba=(L&1)!=0;fa=(L&1)!=0;Y=(L&2)!=0;var qa=(L&32)!=0,wa=(L&8)!=0,la=(L&8)!=0,ma=(L&8)!=0,ua=(L&8)!=0;d=ja!=0^1;ja=d|ga==
3^1;var ra=_dwt_norms+aa*80+(w+ka)*8,ta=ba^1,va=F,na=F+8,ya=F+24,Ba=F+100,Na=F+4,Pa=F,Ja=F+8,xa=F+12,Ya=F+12,$a=F+8,db=F+12,Ta=F+16;ga=d|ga==3^1;ka=_dwt_norms_real+aa*80+(w+ka)*8;var Ma=b+24,Ga=b+20,Ca=b+24,Ka=b+24,Ra=b+36,Oa=b+16,Ia=b+20,Sa=b+12,Aa=b+20,La=b+4,Ea=aa<<8,Ha=b+36,Qa=b+24,Da=b+24,eb=b+20,za=b+24,Wa=b+24,Ua=b+36,ab=b+16,tb=b+20,Ab=b+12,jb=b+20,Db=b+4,ub=b+24;aa=aa<<8;var Eb=F+24+72,Ub=F+100,ob=Xa+48*G+28,Bb=Xa+48*G+8;d=45;f:for(;;){mb=d==45?0:mb;fb=d==45?2:fb;Vb=d==45?0:Vb;bb=d==45?I:
bb;var vb=mb+1,hb=IHEAP[Bb],Za=bb<IHEAP[ob]-4;g:do if(Za){if(fb<2){d=47;a=48}else{d=47;a=49}break g}else{d=46;a=48}while(0);if(a==48){var wb=d==46?0:O;d=48}Za=((d==47?0:wb)?1:0)&255;a=fb==0?51:fb==1?89:fb==2?201:53;g:do if(a==51){IHEAP[c]=0;g=1<<bb+6;if(!(0<IHEAP[Ma]))break g;var cb=Za==1,pb=Za==1;d=bb+6;var kb=d>6,Fb=d-6;d=52;h:for(;;){var qb=d==56?ac:0,xb=qb*4,Lb=xb+1,Gb=xb+3,rb=xb+4;if(0<IHEAP[Ga]){d=54;a=55}else{d=54;a=56}i:for(;;)if(a==55){Mb=d==59?Mb:0;a=Mb+1;d=55;j:for(;;){var Fa=d==85?Hb:
0,Va=Lb+Fa,sa=xb+Fa;if(!(sa<rb))break j;if(!(sa<IHEAP[Ca]))break j;k:do if(ma){if(sa==Gb){d=61;break k}var bc=sa==IHEAP[Ka]-1;d=63}else d=60;while(0);Hb=IHEAP[Oa]+2*(a+IHEAP[Ra]*Va);var gb=IHEAP[Sa]+4*(Mb+IHEAP[Ia]*sa);sa=IHEAP[La];Va=IHEAP[Hb];var nb=Va&-1095;Va=((d==60?0:d==61?1:bc)?1:0)!=0?nb:Va;if(!((Va&255)!=0^1|(Va&20480)!=0)){d=IHEAP[gb];nb=0-d;d=((d<0?nb:d)&g)!=0?1:0;IHEAP[sa+100]=sa+24+IHEAP[_lut_ctxno_zc+(Va&255|Ea)]*4;k:do if(cb){IHEAP[sa+8]+=-1;IHEAP[sa]=(d<<IHEAP[sa+8])+IHEAP[sa];if(IHEAP[sa+
8]!=0)break k;IHEAP[sa+12]+=1;IHEAP[IHEAP[sa+12]]=IHEAP[sa]&255;IHEAP[sa+8]=8;if(IHEAP[IHEAP[sa+12]]==255)IHEAP[sa+8]=7;IHEAP[sa]=0}else _mqc_encode(sa,d);while(0);if(d!=0){nb=IHEAP[gb]<0?1:0;d=IHEAP[gb];gb=0-d;d=d<0?gb:d;if(kb){var cc=IHEAP[_lut_nmsedec_sig+(d>>Fb&127)*2];d=72}else{var dc=IHEAP[_lut_nmsedec_sig0+(d&127)*2];d=74}IHEAP[c]+=d==74?dc:cc;IHEAP[sa+100]=sa+24+IHEAP[_lut_ctxno_sc+((Va&4080)>>4)]*4;k:do if(pb){IHEAP[sa+8]+=-1;IHEAP[sa]=(nb<<IHEAP[sa+8])+IHEAP[sa];if(IHEAP[sa+8]!=0)break k;
IHEAP[sa+12]+=1;IHEAP[IHEAP[sa+12]]=IHEAP[sa]&255;IHEAP[sa+8]=8;if(IHEAP[IHEAP[sa+12]]==255)IHEAP[sa+8]=7;IHEAP[sa]=0}else _mqc_encode(sa,IHEAP[_lut_spb+((Va&4080)>>4)]^nb);while(0);_t1_updateflags(Hb,nb,IHEAP[Ha])}IHEAP[Hb]=(IHEAP[Hb]|16384)&65535}var Hb=Fa+1;d=85}var Mb=Mb+1;if(a<IHEAP[Aa]){d=59;a=55;continue i}d=86;a=56}else if(a==56){var ac=qb+1;if(rb<IHEAP[Qa]){d=56;a=54;continue h}else{a=87;break h}}}}else if(a==89){IHEAP[c]=0;g=1<<bb+6;if(!(0<IHEAP[Da]))break g;cb=Za==1;d=bb+6;pb=d>6;kb=d-
6;d=90;h:for(;;){Fb=d==93?ec:0;qb=Fb*4;xb=qb+1;Lb=qb+3;Gb=qb+4;if(0<IHEAP[eb]){d=91;a=92}else{d=91;a=93}i:for(;;)if(a==92){Nb=d==96?Nb:0;a=Nb+1;d=92;j:for(;;){rb=d==113?Ob:0;sa=xb+rb;Fa=qb+rb;if(!(Fa<Gb))break j;if(!(Fa<IHEAP[za]))break j;k:do if(ua){if(Fa==Lb){d=98;break k}var fc=Fa==IHEAP[Wa]-1;d=100}else d=97;while(0);Ob=IHEAP[ab]+2*(a+IHEAP[Ua]*sa);Va=IHEAP[Ab]+4*(Nb+IHEAP[tb]*Fa);Fa=IHEAP[Db];sa=IHEAP[Ob];gb=sa&-1095;sa=((d==97?0:d==98?1:fc)?1:0)!=0?gb:sa;if((sa&20480)==4096){d=IHEAP[Va];gb=
0-d;d=d<0?gb:d;if(pb){var gc=IHEAP[_lut_nmsedec_ref+(d>>kb&127)*2];d=102}else{var hc=IHEAP[_lut_nmsedec_ref0+(d&127)*2];d=104}IHEAP[c]+=d==104?hc:gc;d=IHEAP[Va];Va=0-d;d=((d<0?Va:d)&g)!=0?1:0;Va=(sa&255)!=0?15:14;IHEAP[Fa+100]=Fa+24+((sa&8192)!=0?16:Va)*4;k:do if(cb){IHEAP[Fa+8]+=-1;IHEAP[Fa]=(d<<IHEAP[Fa+8])+IHEAP[Fa];if(IHEAP[Fa+8]!=0)break k;IHEAP[Fa+12]+=1;IHEAP[IHEAP[Fa+12]]=IHEAP[Fa]&255;IHEAP[Fa+8]=8;if(IHEAP[IHEAP[Fa+12]]==255)IHEAP[Fa+8]=7;IHEAP[Fa]=0}else _mqc_encode(Fa,d);while(0);IHEAP[Ob]=
(IHEAP[Ob]|8192)&65535}var Ob=rb+1;d=113}var Nb=Nb+1;if(a<IHEAP[jb]){d=96;a=92;continue i}d=114;a=93}else if(a==93){var ec=Fb+1;if(Gb<IHEAP[ub]){d=93;a=91;continue h}else{a=115;break h}}}}else if(a==201){g=b;cb=IHEAP[g+4];IHEAP[c]=0;pb=1<<bb+6;if(0<IHEAP[g+24]){kb=cb+24+68;Fb=cb+100;qb=cb+24+72;xb=cb+100;d=bb+6;Lb=d>6;Gb=d-6;d=116;h:for(;;){rb=d==116?0:ic;Fa=rb*4;sa=Fa+2;Va=Fa+3;gb=Fa+4;nb=Fa+1;if(0<IHEAP[g+20]){d=117;a=118}else{d=117;a=119}i:for(;;)if(a==118){Ib=d==138?Ib:0;var sb=Ib+1,Pb=Va<IHEAP[g+
24];j:do if(Pb){var Qb=(IHEAP[IHEAP[g+16]+2*(sb+nb*IHEAP[g+36])]&20735)!=0;if(wa){k:do if(Qb)d=202;else{if((IHEAP[IHEAP[g+16]+2*(sb+sa*IHEAP[g+36])]&20735)!=0){d=120;break k}if((IHEAP[IHEAP[g+16]+2*(sb+Va*IHEAP[g+36])]&20735)!=0){d=122;break k}var jc=(IHEAP[IHEAP[g+16]+2*(sb+gb*IHEAP[g+36])]&20665)!=0;d=123}while(0);var kc=(d==122?1:d==120?1:d==202?1:jc)^1;d=121}else{k:do if(Qb)d=203;else{if((IHEAP[IHEAP[g+16]+2*(sb+sa*IHEAP[g+36])]&20735)!=0){d=126;break k}if((IHEAP[IHEAP[g+16]+2*(sb+Va*IHEAP[g+
36])]&20735)!=0){d=128;break k}var lc=(IHEAP[IHEAP[g+16]+2*(sb+gb*IHEAP[g+36])]&20735)!=0;d=129}while(0);var mc=(d==128?1:d==126?1:d==203?1:lc)^1;d=127}Qb=d==121?kc:mc;if(Qb==0){d=131;a=133;break j}a=g+20;Pb=g+12;for(d=132;;){var yb=d==137?nc:0;if(!(yb<4))break;d=IHEAP[IHEAP[Pb]+4*(Ib+IHEAP[a]*(Fa+yb))];var Yb=0-d;if(((d<0?Yb:d)&pb)!=0)break;var nc=yb+1;d=137}IHEAP[Fb]=kb;_mqc_encode(cb,yb!=4);if(yb==4){d=136;a=138;break j}IHEAP[xb]=qb;_mqc_encode(cb,yb>>1);_mqc_encode(cb,yb&1);d=139;a=133;break j}else{d=
118;a=133}while(0);j:do if(a==133){var Rb=d==131?0:d==139?yb:0;Pb=(d==131?0:d==139?Qb:0)!=0;Yb=nb+Rb;Rb=Fa+Rb;d=133;for(;;){var Zb=d==148?Wb:0,Cb=Yb+Zb;a=Rb+Zb;if(!(a<gb))break j;if(!(a<IHEAP[g+24]))break j;l:do if(la){if(a==Va){d=143;break l}var oc=a==IHEAP[g+24]-1;d=145}else d=142;while(0);Wb=g;Cb=IHEAP[g+16]+2*(sb+IHEAP[g+36]*Cb);var $b=IHEAP[g+12]+4*(Ib+IHEAP[g+20]*a);a=a==Rb;var Jb=IHEAP[Wb+4],Kb=IHEAP[Cb],pc=Kb&-1095;Kb=((d==142?0:d==143?1:oc)?1:0)!=0?pc:Kb;d=(Pb?a:0)!=0;l:do if(d)a=150;else{if((IHEAP[Cb]&
20480)!=0){a=148;break l}IHEAP[Jb+100]=Jb+24+IHEAP[_lut_ctxno_zc+(Kb&255|aa)]*4;d=IHEAP[$b];a=0-d;d=((d<0?a:d)&pb)!=0?1:0;_mqc_encode(Jb,d);a=d!=0?150:148;break l}while(0);if(a==150){d=IHEAP[$b];a=0-d;d=d<0?a:d;if(Lb){var qc=IHEAP[_lut_nmsedec_sig+(d>>Gb&127)*2];d=151}else{var rc=IHEAP[_lut_nmsedec_sig0+(d&127)*2];d=153}IHEAP[c]+=d==153?rc:qc;IHEAP[Jb+100]=Jb+24+IHEAP[_lut_ctxno_sc+((Kb&4080)>>4)]*4;d=IHEAP[$b]<0?1:0;_mqc_encode(Jb,IHEAP[_lut_spb+((Kb&4080)>>4)]^d);_t1_updateflags(Cb,d,IHEAP[Wb+36])}IHEAP[Cb]=
IHEAP[Cb]&-16385&65535;var Wb=Zb+1;d=148;a=140}}while(0);var Ib=Ib+1;if(sb<IHEAP[g+20]){d=138;a=118;continue i}d=156;a=119}else if(a==119){var ic=rb+1;if(gb<IHEAP[g+24]){d=119;a=117;continue h}else{a=157;break h}}}}if(!qa)break g;IHEAP[Ub]=Eb;for(d=160;;){Sb=d==160?0:Sb;_mqc_encode(F,(Sb+1)%2);var Sb=Sb+1;if(Sb!=4)a=d=161;else break g}}while(0);Za=IHEAP[c];if(R){if(ja)d=215;else{var sc=FHEAP[r];d=162}var tc=d==162?sc:1,uc=FHEAP[ra];d=164}else{if(ga)d=216;else{var vc=FHEAP[p];d=166}var wc=d==166?vc:
1,xc=FHEAP[ka];d=168}a=(d==164?tc:wc)*(d==164?uc:xc)*M*(1<<bb);Za=a*(a*Za/8192);var Vb=Vb+Za;FHEAP[T]+=Za;g:do if(V){if(fb==2)if(bb-1<0){a=169;break g}_mqc_flush(F);IHEAP[hb+20*mb+12]=1;d=171;a=172;break g}else a=169;while(0);if(a==169){Za=bb<IHEAP[ob]-4&fb>0;g:do{a=Za?ba?174:173:bb==IHEAP[ob]-4&fb==2^1|ta?173:174;break g}while(0);if(a==174){_mqc_flush(F);IHEAP[hb+20*mb+12]=1;d=174}else if(a==173){IHEAP[hb+20*mb+12]=0;d=173}}d=d==174?1:d==173?3:1;fb=fb+1;a=bb+-1;var bb=(Za=fb==3)?a:bb,fb=Za?0:fb;
Za=IHEAP[hb+20*mb+12]!=0&bb>0;g:do if(Za)if((((bb<IHEAP[ob]-4&fb<2?fa:0)?1:0)&255)==1){IHEAP[va]=0;IHEAP[na]=8}else{IHEAP[Ba]=ya;IHEAP[Na]=32768;IHEAP[Pa]=0;IHEAP[Ja]=12;IHEAP[xa]+=-1;if(IHEAP[IHEAP[Ya]]!=255)break g;IHEAP[$a]=13}while(0);FHEAP[hb+20*mb+4]=Vb;IHEAP[hb+20*mb]=IHEAP[db]+d+(0-IHEAP[Ta]);Y&&_mqc_reset_enc(F);var mb=mb+1;if(bb>=0)d=182;else break f}d=183}else d=207;M=d==183?vb:0;d=(L&16)!=0;f:do if(d)_mqc_erterm_enc(F);else{if((L&1)!=0)break f;_mqc_flush(F)}while(0);IHEAP[Xa+48*G+44]=
M;if(0<IHEAP[Xa+48*G+44]){L=F+12;M=F+16;I=F+12;F=F+16;O=Xa+48*G+8;R=Xa+48*G+44;Xa=Xa+48*G;d=188;f:for(;;){ib=d==188?0:ib;T=ib+1;d=ib+-1;V=IHEAP[O];if(IHEAP[V+20*ib]>IHEAP[L]-IHEAP[M])IHEAP[V+20*ib]=IHEAP[I]-IHEAP[F];ba=IHEAP[V+20*ib]>1;g:do if(ba){if(IHEAP[IHEAP[Xa]+(IHEAP[V+20*ib]-1)]!=255)break g;IHEAP[V+20*ib]+=-1}while(0);ba=IHEAP[V+20*ib];if(ib==0)d=193;else{var yc=IHEAP[IHEAP[O]+20*d];d=195}IHEAP[V+20*ib+16]=ba-(d==195?yc:0);var ib=ib+1;if(T<IHEAP[R])d=197;else break f}}var Xa=G+1;d=200}var Xb=
zb+1;d=14}var zb=B+1;d=11}var lb=u+1;d=9}var Tb=Tb+1;d=6;a=1}if(a==3)STACKTOP=c;else if(a==20)STACKTOP=c}_t1_encode_cblks.__index__=Runtime.getFunctionIndex(_t1_encode_cblks,"_t1_encode_cblks");
function _allocate_buffers(b,f,e){var c,a,d;d=e*f;var g=d>IHEAP[b+28];a:do if(g){_free(IHEAP[b+12]);c=_memalign(16,d*4);IHEAP[b+12]=c;if(IHEAP[b+12]!=0){IHEAP[b+28]=d;c=1}else c=a=0;break a}else c=1;while(0);a:do if(c==1){_llvm_memset_p0i8_i32(IHEAP[b+12],0,d*4,1,0);IHEAP[b+36]=f+2;a=(e+2)*IHEAP[b+36];if(a>IHEAP[b+32]){_free(IHEAP[b+16]);g=_memalign(16,a*2);IHEAP[b+16]=g;if(IHEAP[b+16]!=0)IHEAP[b+32]=a;else{a=0;break a}}_llvm_memset_p0i8_i32(IHEAP[b+16],0,a*2,1,0);IHEAP[b+20]=f;IHEAP[b+24]=e;a=1}while(0);
return a}_allocate_buffers.__index__=Runtime.getFunctionIndex(_allocate_buffers,"_allocate_buffers");
function _t1_decode_cblks(b,f,e){var c,a=null,d,g,h,i,j,k,m,l,n,o,p,r,q,u,s,t,v,y,x,w,C,z,A,B,D,J,E,N,Q,S,P,G,F,L,K,H,M,I,O,R;K=IHEAP[f+8]-IHEAP[f];P=0;c=P<IHEAP[f+16]?0:1;a:for(;;)if(c==0){H=IHEAP[f+20]+124*P;G=0;c=G<IHEAP[H+24]?2:3;b:for(;;)if(c==2){M=H+28+G*32;F=0;c=F<IHEAP[H+20]*IHEAP[H+16]?4:5;c:for(;;)if(c==4){I=IHEAP[M+20]+36*F;L=0;c=L<IHEAP[I+20]*IHEAP[I+16]?6:7;d:for(;;)if(c==6){z=O=IHEAP[I+24]+44*L;A=IHEAP[M+16];B=IHEAP[e+808];D=IHEAP[e+16];C=b;z=z;A=A;B=B;D=D;J=IHEAP[C+8];E=IHEAP[C+4];
R=_allocate_buffers(C,IHEAP[z+16]-IHEAP[z+8],IHEAP[z+20]-IHEAP[z+12])!=0;e:do if(R){N=B+-1+IHEAP[z+24];Q=2;u=u=E;a=8;f:for(;;){T=a==8?0:T;IHEAP[u+24+(0+T)*4]=_mqc_states;var T=T+1;if(T!=19)a=9;else break f}u=E;IHEAP[u+24+72]=_mqc_states+1472;u=E;IHEAP[u+24+68]=_mqc_states+96;u=E;IHEAP[u+24+0]=_mqc_states+128;u=0;if(!(u<IHEAP[z+40]))break e;for(;;){S=IHEAP[z+4]+28*u;var V=N<=IHEAP[z+24]+-5;g:do if(V){if(!(Q<2)){a=13;break g}var ba=(D&1)!=0;a=14}else a=11;while(0);V=((a==13?0:a==11?0:ba)?1:0)&255;var fa=
IHEAP[S]==0;g:do if(!fa){if(V==1){r=IHEAP[IHEAP[S]]+IHEAP[S+4];q=IHEAP[S+12];p=J;r=r;q=q;IHEAP[p+20]=r;IHEAP[p+8]=q;IHEAP[p+12]=0;IHEAP[p]=0;IHEAP[p+4]=0}else _mqc_init_dec(E,IHEAP[IHEAP[S]]+IHEAP[S+4],IHEAP[S+12]);p=0;if(!(p<IHEAP[S+8]))break g;r=V==1;q=V==1;var ca=V==0^1;for(;;){a=Q;c=a==0?214:a==1?215:a==2?216:22;i:do if(c==214)if(r){d=N+1;h=D;a=C;d=d;i=h;d=1<<d;h=d>>1;n=h|d;if(!(0<IHEAP[a+24]))break i;d=a+20;h=a+24;i=(i&8)!=0;y=a+24;l=a;s=a+36;t=a+16;m=a+20;var U=a+12;n=n;x=a+20;o=l+8;j=0-n;l=
l+36;k=a+24;a=21;j:for(;;){g=a==21?0:oa;a=g*4;var $=1+a,Y=0+a,Z=3+a;w=4+a;if(0<IHEAP[d]){a=23;c=24}else{a=23;c=25}k:for(;;)if(c==24){ea=a==28?ea:0;c=ea+1;a=24;l:for(;;){var W=a==38?ia:0,X=$+W,aa=Y+W;if(!(aa<w))break l;if(!(aa<IHEAP[h]))break l;m:do if(i){if(aa==Z){a=30;break m}var ka=aa==IHEAP[y]-1;a=32}else a=29;while(0);ia=IHEAP[t]+2*(c+IHEAP[s]*X);aa=IHEAP[U]+4*(ea+IHEAP[m]*aa);X=IHEAP[o];var ga=IHEAP[ia],ja=ga&-1095;a=((a==29?0:a==30?1:ka)?1:0)!=0?ja:ga;if(!((a&255)!=0^1|(a&20480)!=0)){if(_raw_decode(X)!=
0){a=_raw_decode(X);IHEAP[aa]=a!=0?j:n;_t1_updateflags(ia,a,IHEAP[l])}IHEAP[ia]=(IHEAP[ia]|16384)&65535}var ia=W+1;a=38}var ea=ea+1;if(c<IHEAP[x]){a=28;c=24;continue k}a=39;c=25}else if(c==25){var oa=g+1;if(w<IHEAP[k]){a=25;c=23;continue j}else{c=40;break j}}}}else{a=C;i=N+1;h=A;if((D&8)!=0){a=a;d=i;o=h;d=1<<d;h=d>>1;m=h|d;if(!(0<IHEAP[a+24]))break i;d=a+20;h=a+24;l=a;i=a+36;y=a+16;s=a+20;t=a+12;m=m;U=a+24;n=a+20;x=l+4;o=o<<8;j=0-m;l=l+36;k=a+24;a=41;j:for(;;){g=a==41?0:qa;a=g*4;$=1+a;Y=0+a;Z=3+a;
w=4+a;if(0<IHEAP[d]){a=42;c=43}else{a=42;c=44}k:for(;;)if(c==43){ha=a==47?ha:0;c=ha+1;for(a=43;;){W=a==55?da:0;X=$+W;aa=Y+W;if(!(aa<w))break;if(!(aa<IHEAP[h]))break;if(aa==Z)a=48;else{var pa=aa==IHEAP[U]-1;a=49}da=IHEAP[y]+2*(c+IHEAP[i]*X);aa=IHEAP[t]+4*(ha+IHEAP[s]*aa);X=IHEAP[x];ga=IHEAP[da];ja=ga&-1095;a=((a==48?1:pa)?1:0)!=0?ja:ga;if(!((a&255)!=0^1|(a&20480)!=0)){IHEAP[X+100]=X+24+IHEAP[_lut_ctxno_zc+(a&255|o)]*4;if(_mqc_decode(X)!=0){IHEAP[X+100]=X+24+IHEAP[_lut_ctxno_sc+((a&4080)>>4)]*4;X=_mqc_decode(X);
a=IHEAP[_lut_spb+((a&4080)>>4)]^X;IHEAP[aa]=a!=0?j:m;_t1_updateflags(da,a,IHEAP[l])}IHEAP[da]=(IHEAP[da]|16384)&65535}var da=W+1;a=55}var ha=ha+1;if(c<IHEAP[n]){a=47;c=43;continue k}a=56;c=44}else if(c==44){var qa=g+1;if(w<IHEAP[k]){a=44;c=42;continue j}else{c=57;break j}}}}else{d=a;a=i;h=h;j=IHEAP[d+12];k=IHEAP[d+16]+2;a=1<<a;i=a>>1;i=i|a;g=0;y=g<(IHEAP[d+24]&-4);a=0;if(y){y=h;s=i;t=h;m=i;U=h;n=i;x=h;o=i;j=j;l=a;k=k;g=g+4;a=58;j:for(;;){ra=a==58?0:ra;ua=a==58?k:ua;c=a==58?l:0;ma=a==58?j:ma;var wa=
g+ra*4;if(c<IHEAP[d+20]){$=c+1;for(a=61;;){la=a==61?0:la;a=$+la;Z=c+la;Y=ua+2*Z;Z=ma+4*Z;w=IHEAP[d+36];_t1_dec_sigpass_step_mqc(d,Y+2*w,Z,y,s);W=IHEAP[d+20];aa=IHEAP[d+36];_t1_dec_sigpass_step_mqc(d,Y+2*(aa+w),Z+4*W,t,m);X=IHEAP[d+20];ga=IHEAP[d+36];_t1_dec_sigpass_step_mqc(d,Y+2*(aa+w+ga),Z+4*(X+W),U,n);_t1_dec_sigpass_step_mqc(d,Y+2*(aa+w+ga+IHEAP[d+36]),Z+4*(X+W+IHEAP[d+20]),x,o);var la=la+1;if(a<IHEAP[d+20])a=62;else break}}var ma=ma+4*(IHEAP[d+20]<<2),ua=ua+2*(IHEAP[d+36]<<2),ra=ra+1;if(wa<(IHEAP[d+
24]&-4)){a=65;c=59}else{c=66;break j}}g=wa;k=ua;a=0;j=ma}if(!(a<IHEAP[d+20]))break i;y=j;s=k;t=g;h=h;i=i;m=a;U=m+1;n=t+1;a=60;j:for(;;){x=a==60?0:ya;a=m+x;o=y+4*a;j=s+2*a;l=U+x;if(t<IHEAP[d+24]){a=68;c=69}else{a=68;c=70}for(;;)if(c==69){na=a==69?na:0;va=a==69?va:o;c=n+na;var ta=(a==69?ta:j)+2*IHEAP[d+36];_t1_dec_sigpass_step_mqc(d,ta,va,h,i);var va=va+4*IHEAP[d+20],na=na+1;if(c<IHEAP[d+24])c=a=69;else{a=69;c=70}}else if(c==70){var ya=x+1;if(l<IHEAP[d+20]){a=70;c=68;continue j}else{c=71;break j}}}}}else if(c==
215)if(q){a=N+1;d=D;l=C;a=a;i=d;d=1<<a;n=d>>1;if(a>0){var Ba=0-n;a=73}else a=231;a=a==73?Ba:-1;if(!(0<IHEAP[l+24]))break i;d=l+20;h=l+24;i=(i&8)!=0;y=l+24;s=l+36;t=l+16;m=l+20;U=l+12;n=n;x=a;o=l+20;j=l+8;l=l+24;a=75;j:for(;;){k=a==75?0:xa;a=k*4;g=1+a;$=0+a;Y=3+a;Z=4+a;if(0<IHEAP[d]){a=76;c=77}else{a=76;c=78}k:for(;;)if(c==77){Ja=a==81?Ja:0;c=Ja+1;a=77;l:for(;;){w=a==89?Pa:0;aa=g+w;W=$+w;if(!(W<Z))break l;if(!(W<IHEAP[h]))break l;m:do if(i){if(W==Y){a=83;break m}var Na=W==IHEAP[y]-1;a=85}else a=82;
while(0);Pa=IHEAP[t]+2*(c+IHEAP[s]*aa);W=IHEAP[U]+4*(Ja+IHEAP[m]*W);aa=IHEAP[j];X=IHEAP[Pa];ga=X&-1095;if(((((a==82?0:a==83?1:Na)?1:0)!=0?ga:X)&20480)==4096){a=_raw_decode(aa)!=0?n:x;aa=0-a;IHEAP[W]=(IHEAP[W]<0?aa:a)+IHEAP[W];IHEAP[Pa]=(IHEAP[Pa]|8192)&65535}var Pa=w+1;a=89}var Ja=Ja+1;if(c<IHEAP[o]){a=81;c=77;continue k}a=90;c=78}else if(c==78){var xa=k+1;if(Z<IHEAP[l]){a=78;c=76;continue j}else{c=91;break j}}}}else{d=C;a=N+1;if((D&8)!=0){j=d;a=a;d=1<<a;m=d>>1;if(a>0){var Ya=0-m;a=92}else a=234;
a=a==92?Ya:-1;if(!(0<IHEAP[j+24]))break i;d=j+20;h=j+24;i=j+36;y=j+16;s=j+20;t=j+12;m=m;U=a;n=j+24;x=j+20;o=j+4;j=j+24;a=94;j:for(;;){l=a==94?0:Ma;a=l*4;k=1+a;g=0+a;$=3+a;Y=4+a;if(0<IHEAP[d]){a=95;c=96}else{a=95;c=97}k:for(;;)if(c==96){Ta=a==100?Ta:0;c=Ta+1;for(a=96;;){Z=a==106?db:0;W=k+Z;w=g+Z;if(!(w<Y))break;if(!(w<IHEAP[h]))break;if(w==$)a=101;else{var $a=w==IHEAP[n]-1;a=102}db=IHEAP[y]+2*(c+IHEAP[i]*W);w=IHEAP[t]+4*(Ta+IHEAP[s]*w);W=IHEAP[o];aa=IHEAP[db];X=aa&-1095;a=((a==101?1:$a)?1:0)!=0?X:
aa;if((a&20480)==4096){aa=(a&255)!=0?15:14;IHEAP[W+100]=W+24+((a&8192)!=0?16:aa)*4;a=_mqc_decode(W)!=0?m:U;W=0-a;IHEAP[w]=(IHEAP[w]<0?W:a)+IHEAP[w];IHEAP[db]=(IHEAP[db]|8192)&65535}var db=Z+1;a=106}var Ta=Ta+1;if(c<IHEAP[x]){a=100;c=96;continue k}a=107;c=97}else if(c==97){var Ma=l+1;if(Y<IHEAP[j]){a=97;c=95;continue j}else{c=108;break j}}}}else{d=d;a=a;j=IHEAP[d+12];k=IHEAP[d+16]+2;h=1<<a;h=h>>1;if(a>0){var Ga=0-h;a=109}else a=236;i=a==109?Ga:-1;g=0;y=g<(IHEAP[d+24]&-4);a=0;if(y){y=h;s=i;t=h;m=i;
U=h;n=i;x=h;o=i;j=j;l=a;k=k;g=g+4;a=111;j:for(;;){Ia=a==111?0:Ia;Oa=a==111?k:Oa;c=a==111?l:0;Ra=a==111?j:Ra;var Ca=g+Ia*4;if(c<IHEAP[d+20]){$=c+1;for(a=114;;){Ka=a==114?0:Ka;a=$+Ka;Z=c+Ka;Y=Oa+2*Z;Z=Ra+4*Z;w=IHEAP[d+36];_t1_dec_refpass_step_mqc(d,Y+2*w,Z,y,s);W=IHEAP[d+20];aa=IHEAP[d+36];_t1_dec_refpass_step_mqc(d,Y+2*(aa+w),Z+4*W,t,m);X=IHEAP[d+20];ga=IHEAP[d+36];_t1_dec_refpass_step_mqc(d,Y+2*(aa+w+ga),Z+4*(X+W),U,n);_t1_dec_refpass_step_mqc(d,Y+2*(aa+w+ga+IHEAP[d+36]),Z+4*(X+W+IHEAP[d+20]),x,o);
var Ka=Ka+1;if(a<IHEAP[d+20])a=115;else break}}var Ra=Ra+4*(IHEAP[d+20]<<2),Oa=Oa+2*(IHEAP[d+36]<<2),Ia=Ia+1;if(Ca<(IHEAP[d+24]&-4)){a=118;c=112}else{c=119;break j}}g=Ca;k=Oa;a=0;j=Ra}if(!(a<IHEAP[d+20]))break i;y=j;s=k;t=g;h=h;i=i;m=a;U=m+1;n=t+1;a=113;j:for(;;){x=a==113?0:Ea;a=m+x;o=y+4*a;j=s+2*a;l=U+x;if(t<IHEAP[d+24]){a=121;c=122}else{a=121;c=123}for(;;)if(c==122){La=a==122?La:0;Aa=a==122?Aa:o;c=n+La;var Sa=(a==122?Sa:j)+2*IHEAP[d+36];_t1_dec_refpass_step_mqc(d,Sa,Aa,h,i);var Aa=Aa+4*IHEAP[d+
20],La=La+1;if(c<IHEAP[d+24])c=a=122;else{a=122;c=123}}else if(c==123){var Ea=x+1;if(l<IHEAP[d+20]){a=123;c=121;continue j}else{c=124;break j}}}}}else if(c==216){i=N+1;h=A;a=D;d=C;s=i;h=h;a=a;i=a&32;y=IHEAP[d+4];s=1<<s;t=s>>1;s=t|s;U=(a&8)!=0;j:do if(U){m=0;if(!(m<IHEAP[d+24])){c=126;break j}x=s;o=0-x;j=h<<8;v=v;a=125;k:for(;;){l=a==125?v:tb;t=0;k=m;if(t<IHEAP[d+20]){a=127;c=128}else{a=127;c=129}l:for(;;)if(c==128){Ua=a==138?Ua:l;ab=(a==138?ab:k)+3<IHEAP[d+24];m:do if(ab){var Ha=(IHEAP[IHEAP[d+16]+
2*(IHEAP[d+36]*(m+1)+1+t)]&20735)!=0;n:do if(Ha)a=219;else{if((IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+2)+1+t)]&20735)!=0){a=130;break n}if((IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+3)+1+t)]&20735)!=0){a=132;break n}var Qa=(IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+4)+1+t)]&20665)!=0;a=133}while(0);Ha=(a==132?1:a==130?1:a==219?1:Qa)^1;if(Ha==0){a=131;c=136;break m}IHEAP[y+100]=y+24+68;if(_mqc_decode(y)==0){a=135;c=138;break m}IHEAP[y+100]=y+24+72;var Da=_mqc_decode(y)<<1;Da=_mqc_decode(y)|Da;a=137;c=136;break m}else{a=
128;c=136}while(0);m:do if(c==136){var eb=a==137?Da:a==128?0:0;ab=a==137?Ha:a==131?0:0;n=m+eb;ab=ab!=0;a=136;for(;;){if(!(n<m+4)){a=139;break m}if(!(n<IHEAP[d+24])){a=140;break m}if(n==m+3)a=141;else{var za=n==IHEAP[d+24]-1;a=142}c=(a==141?1:za)?1:0;g=d;$=IHEAP[d+16]+2*(t+1+IHEAP[d+36]*(n+1));Y=IHEAP[d+12]+4*(IHEAP[d+20]*n+t);if(ab){var Wa=n==m+eb;a=144}else a=220;Z=IHEAP[g+4];w=IHEAP[$];W=w&-1095;w=c!=0?W:w;a=(a==220?0:Wa)!=0;o:do if(a)c=149;else{if((w&20480)!=0){c=147;break o}IHEAP[Z+100]=Z+24+
IHEAP[_lut_ctxno_zc+(w&255|j)]*4;c=_mqc_decode(Z)!=0?149:147;break o}while(0);if(c==149){IHEAP[Z+100]=Z+24+IHEAP[_lut_ctxno_sc+((w&4080)>>4)]*4;a=_mqc_decode(Z);a=IHEAP[_lut_spb+((w&4080)>>4)]^a;IHEAP[Y]=a!=0?o:x;_t1_updateflags($,a,IHEAP[g+36])}IHEAP[$]=IHEAP[$]&-16385&65535;n+=1;a=147;c=139}}while(0);var Ua=a==135?Ua:a==139?eb:eb;t+=1;var ab=m;if(t<IHEAP[d+20]){a=138;c=128;continue l}a=151;c=129}else if(c==129){var tb=a==151?Ua:l;m=(a==151?ab:k)+4;if(m<IHEAP[d+24]){a=129;c=127;continue k}else{c=
152;break k}}}v=tb}else{o=IHEAP[d+12];x=IHEAP[d+16]+2;m=0;a=m<(IHEAP[d+24]&-4);t=0;c=a?153:154;k:for(;;)if(c==153){c=t<IHEAP[d+20]?155:156;for(;;)if(c==155){w=o+4*t;c=x+2*t;n=(IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+1)+1+t)]&20735)!=0;m:do if(n)a=155;else{if((IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+2)+1+t)]&20735)!=0){a=158;break m}if((IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+3)+1+t)]&20735)!=0){a=160;break m}var Ab=(IHEAP[IHEAP[d+16]+2*(IHEAP[d+36]*(m+4)+1+t)]&20735)!=0;a=161}while(0);j=a=(a==160?1:a==158?1:
a==155?1:Ab)^1;l=a!=0;m:do if(l){IHEAP[y+100]=y+24+68;if(_mqc_decode(y)==0)break m;IHEAP[y+100]=y+24+72;v=_mqc_decode(y);v=v<<1;v=_mqc_decode(y)|v;c+=2*IHEAP[d+36]*v;w+=4*IHEAP[d+20]*v;n=v+m;k=j!=0;g=v;$=s;Y=h;Z=s;w=w;W=c;aa=0-$;a=163;n:for(;;){var jb=a==171?ub:W,Db=a==171?Eb:w;if(!(n<m+4))break n;if(!(n<IHEAP[d+24]))break n;var ub=jb+2*IHEAP[d+36];o:do if(k){if(n!=m+g){c=170;break o}Eb=d;c=IHEAP[Eb+4];a=IHEAP[ub];IHEAP[c+100]=c+24+IHEAP[_lut_ctxno_sc+((a&4080)>>4)]*4;c=_mqc_decode(c);a=IHEAP[_lut_spb+
((a&4080)>>4)]^c;IHEAP[Db]=a!=0?aa:$;_t1_updateflags(ub,a,IHEAP[Eb+36]);IHEAP[ub]=IHEAP[ub]&-16385&65535;c=171;break o}else c=170;while(0);c==170&&_t1_dec_clnpass_step(d,ub,Db,Y,Z);var Eb=Db+4*IHEAP[d+20];n+=1;a=171}c=jb;w=Db}else{c+=2*IHEAP[d+36];_t1_dec_clnpass_step(d,c,w,h,s);w+=4*IHEAP[d+20];c+=2*IHEAP[d+36];_t1_dec_clnpass_step(d,c,w,h,s);w+=4*IHEAP[d+20];c+=2*IHEAP[d+36];_t1_dec_clnpass_step(d,c,w,h,s);w+=4*IHEAP[d+20];c+=2*IHEAP[d+36];_t1_dec_clnpass_step(d,c,w,h,s);w+=4*IHEAP[d+20]}while(0);
t+=1;c=t<IHEAP[d+20]?155:156}else if(c==156){o+=4*(IHEAP[d+20]<<2);x+=2*(IHEAP[d+36]<<2);m+=4;a=m<(IHEAP[d+24]&-4);t=0;c=a?153:154;continue k}}else if(c==154)if(t<IHEAP[d+20]){c=157;break k}else{c=126;break j}o=o;x=x;j=h;l=s;k:for(;;){k=o+4*t;g=x+2*t;n=m;if(n<IHEAP[d+24]){a=174;c=175}else{a=174;c=176}for(;;)if(c==175){ob=a==175?ob:k;var Ub=(a==175?Ub:g)+2*IHEAP[d+36];_t1_dec_clnpass_step(d,Ub,ob,j,l);var ob=ob+4*IHEAP[d+20];n+=1;if(n<IHEAP[d+24])c=a=175;else{a=175;c=176}}else if(c==176){t+=1;if(t<
IHEAP[d+20]){c=174;continue k}else{c=177;break k}}}}while(0);if(i==0)break i;IHEAP[y+100]=y+24+72;_mqc_decode(y);_mqc_decode(y);_mqc_decode(y);_mqc_decode(y)}while(0);if(!((D&2)!=0^1|ca)){c=a=E;for(a=180;;){Bb=a==180?0:Bb;IHEAP[c+24+(0+Bb)*4]=_mqc_states;var Bb=Bb+1;if(Bb!=19)a=181;else break}a=E;IHEAP[a+24+72]=_mqc_states+1472;a=E;IHEAP[a+24+68]=_mqc_states+96;a=E;IHEAP[a+24+0]=_mqc_states+128}Q=a=Q+1;if(a==3){Q=0;N+=-1}p+=1;if(!(p<IHEAP[S+8]))break g}}while(0);u+=1;if(!(u<IHEAP[z+40]))break e}}while(0);
D=IHEAP[O+8]-IHEAP[M];J=IHEAP[O+12]-IHEAP[M+4];if((IHEAP[M+16]&1)!=0){C=IHEAP[f+20]+124*(P-1);D=0-IHEAP[C]+IHEAP[C+8]+D}if((IHEAP[M+16]&2)!=0){C=IHEAP[f+20]+124*(P-1);J=0-IHEAP[C+4]+IHEAP[C+12]+J}A=IHEAP[b+12];C=IHEAP[b+20];z=IHEAP[b+24];E=IHEAP[e+808]!=0;e:do if(E){R=1<<IHEAP[e+808];B=0;if(!(B<z))break e;N=C;Q=A;R=R;u=e+808;S=C;V=A;fa=C;p=z;B=B;r=0<C;f:do if(r){q=fa>1?fa:1;a=189;for(;;){hb=a==189?B:hb;ca=S*hb;c=N*hb;for(a=190;;){vb=a==190?0:vb;a=V+4*(ca+vb);d=IHEAP[Q+4*(c+vb)];h=0-d;h=d>-1?d:h;if(h>=
R){h=h>>IHEAP[u];i=0-h;IHEAP[a]=d<0?i:h}var vb=vb+1;if(vb!=q)a=191;else break}var hb=hb+1;if(hb<p)a=193;else break f}}else for(a=187;;){var Za=(a==197?Za:B)+1;if(Za<p)a=197;else break f}while(0)}while(0);E=IHEAP[e+20]==1;D=IHEAP[f+24]+4*(K*J+D);e:do if(E){R=D;B=0;if(!(B<z))break e;J=C;N=A;Q=K;R=R;u=C;S=z;B=B;V=0<C;f:do if(V){fa=u>1?u:1;a=201;for(;;){cb=a==201?B:cb;p=Q*cb;r=J*cb;for(a=202;;){wb=a==202?0:wb;IHEAP[R+4*(p+wb)]=IHEAP[N+4*(r+wb)]/2|0;var wb=wb+1;if(wb!=fa)a=203;else break}var cb=cb+1;if(cb<
S)a=204;else break f}}else for(a=199;;){var pb=(a==206?pb:B)+1;if(pb<S)a=206;else break f}while(0)}else{J=D;B=0;if(!(B<z))break e;for(;;){Q=J;if(0<C){N=M+28;R=C;A=A;Q=Q;R=(R>1?R:1)-0;for(a=209;;){kb=a==209?0:kb;FHEAP[Q+4*kb]=IHEAP[A+4*kb]*FHEAP[N];var kb=kb+1;if(kb!=R)a=210;else break}A=A+4*R}J+=4*K;B+=1;if(!(B<z))break e}}while(0);_free(IHEAP[O]);_free(IHEAP[O+4]);L+=1;if(L<IHEAP[I+20]*IHEAP[I+16]){c=6;continue d}c=7}else if(c==7){_free(IHEAP[I+24]);F+=1;c=F<IHEAP[H+20]*IHEAP[H+16]?4:5;continue c}}else if(c==
5){G+=1;c=G<IHEAP[H+24]?2:3;continue b}}else if(c==3){P+=1;c=P<IHEAP[f+16]?0:1;continue a}}else if(c==1)break}_t1_decode_cblks.__index__=Runtime.getFunctionIndex(_t1_decode_cblks,"_t1_decode_cblks");
function _t1_dec_clnpass_step(b,f,e,c,a){var d,g,h,i;i=IHEAP[b+4];h=IHEAP[f];var j=(h&20480)!=0;a:do if(!j){g=c;d=h;g=g;IHEAP[i+100]=i+24+IHEAP[_lut_ctxno_zc+(d&255|g<<8)]*4;if(_mqc_decode(i)==0)break a;d=h;IHEAP[i+100]=i+24+IHEAP[_lut_ctxno_sc+((d&4080)>>4)]*4;g=_mqc_decode(i);d=h;d=IHEAP[_lut_spb+((d&4080)>>4)]^g;g=a;var k=0-g;IHEAP[e]=d!=0?k:g;_t1_updateflags(f,d,IHEAP[b+36])}while(0);IHEAP[f]=IHEAP[f]&-16385&65535}_t1_dec_clnpass_step.__index__=Runtime.getFunctionIndex(_t1_dec_clnpass_step,"_t1_dec_clnpass_step");
function _t1_updateflags(b,f,e){var c;c=b+2*(0-e);e=b+2*e;var a=c+-2;IHEAP[a]=(IHEAP[a]|2)&65535;IHEAP[c]=(IHEAP[c]|IHEAP[_t1_updateflags_mod+f*2])&65535;c=c+2;IHEAP[c]=(IHEAP[c]|4)&65535;c=b+-2;IHEAP[c]=(IHEAP[c]|IHEAP[_t1_updateflags_mod+(f+2)*2])&65535;IHEAP[b]=(IHEAP[b]|4096)&65535;b=b+2;IHEAP[b]=(IHEAP[b]|IHEAP[_t1_updateflags_mod+(f+4)*2])&65535;b=e+-2;IHEAP[b]=(IHEAP[b]|1)&65535;IHEAP[e]=(IHEAP[e]|IHEAP[_t1_updateflags_mod+(f+6)*2])&65535;f=e+2;IHEAP[f]=(IHEAP[f]|8)&65535}
_t1_updateflags.__index__=Runtime.getFunctionIndex(_t1_updateflags,"_t1_updateflags");function _t1_dec_refpass_step_mqc(b,f,e,c,a){var d,g;b=IHEAP[b+4];g=IHEAP[f];if((g&20480)==4096){d=(g&255)!=0?15:14;d=(g&8192)!=0?16:d;IHEAP[b+100]=b+24+d*4;b=_mqc_decode(b);c=b!=0?c:a;a=0-c;IHEAP[e]+=IHEAP[e]<0?a:c;IHEAP[f]=(IHEAP[f]|8192)&65535}}_t1_dec_refpass_step_mqc.__index__=Runtime.getFunctionIndex(_t1_dec_refpass_step_mqc,"_t1_dec_refpass_step_mqc");
function _t1_dec_sigpass_step_mqc(b,f,e,c,a){var d,g,h,i;i=IHEAP[b+4];h=IHEAP[f];var j=(h&255)!=0;a:do if(j){if((h&20480)!=0)break a;g=c;d=h;g=g;IHEAP[i+100]=i+24+IHEAP[_lut_ctxno_zc+(d&255|g<<8)]*4;if(_mqc_decode(i)!=0){d=h;IHEAP[i+100]=i+24+IHEAP[_lut_ctxno_sc+((d&4080)>>4)]*4;g=_mqc_decode(i);d=h;d=IHEAP[_lut_spb+((d&4080)>>4)]^g;g=a;var k=0-g;IHEAP[e]=d!=0?k:g;_t1_updateflags(f,d,IHEAP[b+36])}d=f;IHEAP[d]=(IHEAP[d]|16384)&65535}while(0)}
_t1_dec_sigpass_step_mqc.__index__=Runtime.getFunctionIndex(_t1_dec_sigpass_step_mqc,"_t1_dec_sigpass_step_mqc");
function _t2_encode_packets(b,f,e,c,a,d,g,h,i,j,k,m){var l,n=null,o,p,r,q,u,s,t;o=a;p=0;r=IHEAP[b+4];q=IHEAP[b+8];u=IHEAP[q+108]+5588*f;s=IHEAP[q]==3?2:1;if(IHEAP[q+4]>0){t=IHEAP[r+16];n=0}else n=40;t=n==0?t:1;r=_pi_initialise_encode(r,q,f,k);var v=r!=0;a:do if(v){if(k==0){var y=t,x=s,w=r,C=q,z=f,A=i,B=k,D=m,J=r,E=r,N=c,Q=e,S=f,P=q+108,G=r,F=a+d,L=g,K=f,H=q+4,M=q+4,I=p,O=o;n=3;b:for(;;){l=n==23?ia:0;var R=n==23?ba:O,T=n==23?fa:I,V=0+l;if(V<y)n=4;else{n=4;l=6;break b}c:for(;;){var ba=n==22?W:R,fa=
n==22?X:T,ca=n==22?ja:0,U=J+232*ca,$=E+232*ca+36,Y=G+232*ca;if(!(ca<x))break c;if(_pi_create_encode(w,C,z,ca,V,A,B,D)!=0){n=7;l=9;break b}else n=7;for(;;){var Z=n==7?0:n==16?ka:Z,W=n==7?ba:n==16?ga:W,X=n==7?fa:n==16?aa:X;if(_pi_next(U)==0)break;if(IHEAP[$]<N){n=12;var aa=_t2_encode_packet(Q,IHEAP[P]+5588*S,Y,W,F-W,L,K),ka=aa+Z;if(aa==-999){l=15;break b}var ga=W+aa;n=16}else n=12}if(X==-999){l=17;break b}if(IHEAP[H]!=0)if(Z>IHEAP[M]){l=19;break b}var ja=ca+1;n=22}if(fa==-999){n=8;l=6;break b}var ia=
l+1;n=23;l=4}if(l==6){p=n==8?-999:T;o=n==8?ba:R;p=p}else if(l==9){_opj_event_msg(IHEAP[b],1,__str41107);_pi_destroy(r,q,f);n=-999;break a}else if(l==15){o=W;p=-999}else if(l==17){o=W;p=-999}else if(l==19){o=W;p=-999}}else{_pi_create_encode(r,q,f,j,h,i,k,m);y=r+232*j;x=r+232*j+36;w=c;C=e;z=f;A=q+108;B=r+232*j;D=a+d;J=g;E=f;N=g!=0;Q=g+12;S=f;P=g+88;G=g+8;F=g+8;L=q+16;K=u+424;H=g+8;M=g+8;I=e+836;p=p;o=o;n=24;b:for(;;){var ea=n==24?o:n==39?da:ea,oa=n==24?p:n==39?pa:oa;if(_pi_next(y)==0){n=25;l=27;break b}if(!(IHEAP[x]<
w)){n=26;l=25;continue b}var pa=_t2_encode_packet(C,IHEAP[A]+5588*z,B,ea,D-ea,J,E);if(pa==-999){n=28;l=27;break b}var da=ea+pa;if(N){if(IHEAP[Q]!=0){n=44;V=IHEAP[P]+572*S;O=IHEAP[V+548]+20*IHEAP[G];if(IHEAP[F]!=0){ca=(IHEAP[K]|IHEAP[L])!=0;c:do if(ca){if(IHEAP[O]==0){l=32;break c}var ha=IHEAP[O];n=31;l=33;break c}else l=32;while(0);if(l==32){var qa=IHEAP[IHEAP[V+548]+20*(IHEAP[H]-1)+8]+1;n=32}IHEAP[O]=n==31?ha:qa}else IHEAP[O]=IHEAP[V+12]+1;IHEAP[O+8]=IHEAP[O]+-1+pa;n=O+4;IHEAP[n]=IHEAP[O]+-1+IHEAP[n]}IHEAP[M]+=
1}IHEAP[I]+=1;n=39;l=25}n=n==28?-999:oa;o=ea;p=n}_pi_destroy(r,q,f);n=p==-999?p:o-a}else n=-999;while(0);return n}_t2_encode_packets.__index__=Runtime.getFunctionIndex(_t2_encode_packets,"_t2_encode_packets");
function _t2_encode_packet(b,f,e,c,a,d,g){var h,i=null,j,k,m,l,n;k=c;m=IHEAP[e+24];i=IHEAP[e+28];l=IHEAP[e+32];e=IHEAP[e+36];m=IHEAP[IHEAP[b+20]+32*m+20]+124*i;if((IHEAP[f+4]&2)!=0){IHEAP[k]=-1;IHEAP[k+1]=-111;IHEAP[k+2]=0;IHEAP[k+3]=4;IHEAP[k+4]=(IHEAP[b+836]%65536/256|0)&255;IHEAP[k+5]=IHEAP[b+836]%65536%256&255;k+=6}var o=e!=0;a:do if(!o){b=0;if(!(b<IHEAP[m+24])){h=2;break a}var p=m,r=l,q=m+24,u=b,s=u+1;i=1;b:for(;;){D=i==1?0:D;b=u+D;var t=p+28+b*32+24;h=s+D;var v=IHEAP[p+28+b*32+20]+36*r;b=IHEAP[v+
28];var y=0==b;c:do if(!y){if(!(0<IHEAP[b+8]))break c;var x=b+12,w=b+12,C=b+12,z=b+8;for(i=5;;){A=i==5?0:A;i=A+1;IHEAP[IHEAP[x]+16*A+4]=999;IHEAP[IHEAP[w]+16*A+8]=0;IHEAP[IHEAP[C]+16*A+12]=0;var A=A+1;if(i<IHEAP[z])i=7;else break c}}while(0);b=IHEAP[v+32];y=0==b;c:do if(!y){if(!(0<IHEAP[b+8]))break c;x=b+12;w=b+12;C=b+12;z=b+8;for(i=9;;){B=i==9?0:B;i=B+1;IHEAP[IHEAP[x]+16*B+4]=999;IHEAP[IHEAP[w]+16*B+8]=0;IHEAP[IHEAP[C]+16*B+12]=0;var B=B+1;if(i<IHEAP[z])i=11;else break c}}while(0);b=0;if(b<IHEAP[v+
20]*IHEAP[v+16]){y=v+24;x=v+32;w=v+16;v=v+20;c:for(;;){i=IHEAP[y]+48*b;IHEAP[i+36]=0;C=IHEAP[t]-IHEAP[i+28];z=IHEAP[IHEAP[x]+12]+16*b;for(i=12;;){i=i==16?n:z;if(i==0)break;if(!(IHEAP[i+4]>C))break;IHEAP[i+4]=C;n=IHEAP[i];i=16}b+=1;if(!(b<IHEAP[v]*IHEAP[w]))break c}}var D=D+1;if(h<IHEAP[q]){i=19;h=3}else{h=20;break b}}}while(0);n=_malloc(20);b=k;IHEAP[n]=b;IHEAP[n+4]=b+a;IHEAP[n+8]=b;IHEAP[n+12]=0;IHEAP[n+16]=8;_bio_write(n,1,1);b=0;if(b<IHEAP[m+24]){A=e+1;B=m+24;o=b;p=o+1;i=22;a:for(;;){ea=i==22?
0:ea;r=p+ea;h=IHEAP[m+28+(o+ea)*32+20]+36*l;b=0;if(b<IHEAP[h+20]*IHEAP[h+16]){q=h+24;u=h+16;s=h+20;D=h+28;b:for(;;){i=IHEAP[q]+48*b;t=IHEAP[i+4]+20*e;v=IHEAP[i+36]!=0;c:do if(!v){if(IHEAP[t]==0)break c;y=IHEAP[IHEAP[D]+12]+16*b;for(i=27;;){i=i==31?J:y;if(i==0)break c;if(!(IHEAP[i+4]>e))break c;IHEAP[i+4]=e;var J=IHEAP[i];i=31}}while(0);b+=1;if(!(b<IHEAP[s]*IHEAP[u]))break b}}b=0;if(b<IHEAP[h+20]*IHEAP[h+16]){q=h+24;u=h+32;s=h+16;D=h+20;t=h+28;b:for(;;){v=IHEAP[q]+48*b;y=IHEAP[v+4]+20*e;IHEAP[v+36]!=
0?_bio_write(n,IHEAP[y]!=0,1):_tgt_encode(n,IHEAP[t],b,A);x=IHEAP[y]!=0;c:do if(x){if(IHEAP[v+36]==0){IHEAP[v+32]=3;_tgt_encode(n,IHEAP[u],b,999)}i=IHEAP[y];h=i==1?91:i==2?92:93;d:do if(h==93)if(i<=5)_bio_write(n,i-3|12,4);else if(i<=36)_bio_write(n,i-6|480,9);else{if(!(i<=164))break d;_bio_write(n,i-37|65408,16)}else if(h==91)_bio_write(n,0,1);else h==92&&_bio_write(n,2,2);while(0);w=IHEAP[v+36];C=w<IHEAP[y]+IHEAP[v+36];d:do if(C){z=IHEAP[v+8];var E=v+32;i=IHEAP[y]+IHEAP[v+36];var N=v+36,Q=y;h=w+
1;var S=(i>h?i:h)-w;i=41;e:for(;;){ca=i==41?0:ca;fa=i==41?0:fa;var P=w+ca;V=(i==41?0:V)+1;ba=(i==41?0:ba)+IHEAP[z+20*P+16];var G=IHEAP[z+20*P+12]!=0;f:do if(G)h=44;else{if(P==IHEAP[N]+-1+IHEAP[Q]){i=43;h=44}else{i=43;h=45}break f}while(0);f:do if(h==44){if(ba>1){i=44;h=46}else{i=44;h=47}g:for(;;)if(h==46){K=i==46?K:0;var F=K+1,L=(i==46?L:ba)>>1,K=K+1;if(L>1)h=i=46;else{i=46;h=47}}else if(h==47){var H=i==44?0:F,M=IHEAP[E];if(V>1){i=47;h=48}else{i=47;h=49}break g}for(;;)if(h==48){R=i==48?R:0;var I=
R+1,O=(i==48?O:V)>>1,R=R+1;if(O>1)h=i=48;else{i=48;h=49}}else if(h==49){var T=H+1+(0-M)+(0-(i==47?0:I));T=fa>T?fa:T;i=49;break f}}while(0);var V=i==43?V:0,ba=i==43?ba:0,fa=i==43?fa:T,ca=ca+1;if(ca!=S)i=45;else break e}if(!(fa+-1>=0)){i=50;break d}i=1-fa;h=fa+(i>0?i:0);for(i=51;;){U=i==51?0:U;_bio_write(n,1,1);var U=U+1;if(U!=h)i=53;else break}i=54}else i=40;while(0);w=i==54?V:i==50?V:0;C=i==54?ba:i==50?ba:0;i=i==54?fa:i==50?fa:0;_bio_write(n,0,1);IHEAP[v+32]+=i;z=IHEAP[v+36];if(!(z<IHEAP[y]+IHEAP[v+
36]))break c;E=v+8;N=v+32;Q=v+36;S=y;P=v+36;G=y;var $=z+1;i=56;d:for(;;){ia=i==56?0:ia;var Y=z+ia,Z=$+ia;h=IHEAP[E];ga=(i==56?w:ga)+1;ja=(i==56?C:ja)+IHEAP[h+20*Y+16];var W=IHEAP[h+20*Y+12]!=0;e:do if(W)h=60;else{if(Y==IHEAP[P]+-1+IHEAP[G]){i=59;h=60}else{i=59;h=61}break e}while(0);e:do if(h==60){Y=IHEAP[N];if(ga>1){i=60;h=62}else{i=60;h=63}for(;;)if(h==62){ka=i==62?ka:0;var X=ka+1,aa=(i==62?aa:ga)>>1,ka=ka+1;if(aa>1)h=i=62;else{i=62;h=63}}else if(h==63){_bio_write(n,ja,(i==60?0:X)+Y);i=63;break e}}while(0);
var ga=i==59?ga:0,ja=i==59?ja:0,ia=ia+1;if(Z<IHEAP[S]+IHEAP[Q])i=61;else break d}}while(0);b+=1;if(!(b<IHEAP[D]*IHEAP[s]))break b}}var ea=ea+1;if(r<IHEAP[B]){i=68;h=23}else{h=69;break a}}}if(_bio_flush(n)!=0){n!=0&&_free(n);j=-999}else{k+=IHEAP[n+8]-IHEAP[n];n!=0&&_free(n);if((IHEAP[f+4]&4)!=0){IHEAP[k]=-1;IHEAP[k+1]=-110;k+=2}J=d!=0;a:do if(J){if(IHEAP[d+12]==0){h=76;break a}f=IHEAP[IHEAP[d+88]+572*g+548]+20*IHEAP[d+8];IHEAP[f+4]=k-c}while(0);b=0;f=m+24;a=c+a;J=d!=0;F=d+12;L=d+8;H=d+88;M=b;i=76;
a:for(;;){oa=i==83?oa:0;I=M+oa;O=m+28+I*32+20;if(!(I<IHEAP[f])){h=80;break a}X=IHEAP[O]+36*l;b=0;I=X+16;O=X+20;X=X+24;b:for(;;){if(!(b<IHEAP[O]*IHEAP[I]))break b;aa=IHEAP[X]+48*b;K=IHEAP[aa+4]+20*e;R=IHEAP[K]!=0;c:do if(R){if(k+IHEAP[K+4]>a){h=84;break a}_llvm_memcpy_p0i8_p0i8_i32(k,IHEAP[K+16],IHEAP[K+4],1,0);IHEAP[aa+36]+=IHEAP[K];k+=IHEAP[K+4];if(!J)break c;if(IHEAP[F]==0)break c;T=IHEAP[IHEAP[H]+572*g+548]+20*IHEAP[L];FHEAP[T+12]+=FHEAP[K+8];if(!(FHEAP[d]<FHEAP[T+12]))break c;FHEAP[d]=FHEAP[T+
12]}while(0);b+=1}var oa=oa+1;i=83;h=78}if(h==80)j=k-c;else if(h==84)j=-999}return j}_t2_encode_packet.__index__=Runtime.getFunctionIndex(_t2_encode_packet,"_t2_encode_packet");
function _t2_decode_packets(b,f,e,c,a,d){var g,h=null,i,j,k,m,l,n,o,p,r,q,u,s,t,v,y,x,w,C,z,A,B,D,J,E,N,Q,S,P;J=f;N=k=0;S=IHEAP[b+4];P=IHEAP[b+8];E=_pi_create_decode(S,P,c);var G=E!=0;a:do{if(G){o=Q=0;b:for(;;){if(!(o<=IHEAP[IHEAP[P+108]+5588*c+420])){g=3;break b}c:for(;;){if(_pi_next(E+232*o)==0)break c;j=IHEAP[P+40]==0;d:do if(j)g=6;else{if(IHEAP[P+40]>=IHEAP[E+232*o+36]+1){g=6;break d}var F=k=0;h=7;g=111;break d}while(0);if(g==6){u=d!=0?IHEAP[IHEAP[d+88]+572*c+548]+20*IHEAP[d+8]:0;j=J;s=f+e-J;
t=a;v=IHEAP[P+108]+5588*c;C=E+232*o;B=u;u=b;j=j;s=s;t=t;v=v;r=C;y=B;C=j;z=IHEAP[u+8];A=IHEAP[r+24];q=IHEAP[r+28];B=IHEAP[r+32];p=IHEAP[r+36];t=IHEAP[IHEAP[t+20]+32*A+20]+124*q;r=p==0;d:do if(r){x=0;if(!(x<IHEAP[t+24]))break d;q=t;m=B;l=t+24;w=w;n=x;var L=n+1;h=9;e:for(;;){W=h==9?0:W;Z=h==9?w:Z;var K=L+W;h=n+W;var H=q+28+h*32+4,M=q+28+h*32+12,I=IHEAP[q+28+h*32+20]+36*m,O=IHEAP[q+28+h*32+8]-IHEAP[q+28+h*32]==0;f:do if(O)h=11;else{if(IHEAP[M]-IHEAP[H]==0){h=12;break f}var R=IHEAP[I+28],T=0==R;g:do if(!T){if(!(0<
IHEAP[R+8]))break g;var V=R+12,ba=R+12;x=R+12;var fa=R+8;for(h=16;;){ca=h==16?0:ca;h=ca+1;IHEAP[IHEAP[V]+16*ca+4]=999;IHEAP[IHEAP[ba]+16*ca+8]=0;IHEAP[IHEAP[x]+16*ca+12]=0;var ca=ca+1;if(h<IHEAP[fa])h=18;else break g}}while(0);R=IHEAP[I+32];T=0==R;g:do if(!T){if(!(0<IHEAP[R+8]))break g;V=R+12;ba=R+12;x=R+12;fa=R+8;for(h=20;;){U=h==20?0:U;h=U+1;IHEAP[IHEAP[V]+16*U+4]=999;IHEAP[IHEAP[ba]+16*U+8]=0;IHEAP[IHEAP[x]+16*U+12]=0;var U=U+1;if(h<IHEAP[fa])h=22;else break g}}while(0);if(!(0<IHEAP[I+20]*IHEAP[I+
16])){h=21;break f}R=I+24;T=I+16;V=I+20;for(h=23;;){Y=h==23?0:Y;var $=Y+1;IHEAP[IHEAP[R]+44*Y+40]=0;var Y=Y+1;if($<IHEAP[V]*IHEAP[T])h=24;else break}h=25}while(0);var Z=h==11?Z:h==12?Z:h==25?$:0,W=W+1;if(K<IHEAP[l])h=13;else{h=13;break e}}w=Z}while(0);r=(IHEAP[v+4]&2)!=0;d:do if(r){q=IHEAP[C]!=255;e:do if(!q){if(IHEAP[C+1]!=145)break e;C+=6;break d}while(0);_opj_event_msg(IHEAP[u],2,__str142)}while(0);q=r=_malloc(20);if(IHEAP[z+92]==1){l=r=IHEAP[z+84];n=IHEAP[z+104];m=q;l=l;n=n;IHEAP[m]=l;IHEAP[m+
4]=l+n;IHEAP[m+8]=l;IHEAP[m+12]=0;IHEAP[m+16]=0}else if(IHEAP[v+5172]==1){l=r=IHEAP[v+5164];n=IHEAP[v+5180];m=q;l=l;n=n;IHEAP[m]=l;IHEAP[m+4]=l+n;IHEAP[m+8]=l;IHEAP[m+12]=0;IHEAP[m+16]=0}else{l=r=C;n=j+s-r;m=q;l=l;n=n;IHEAP[m]=l;IHEAP[m+4]=l+n;IHEAP[m+8]=l;IHEAP[m+12]=0;IHEAP[m+16]=0}if(_bio_read(q,1)!=0){x=0;if(x<IHEAP[t+24]){var X=t;m=B;l=t+24;K=L=n=q;H=A;M=v+5584;I=q;O=A;R=v+5584;A=A;T=v+5584;ba=V=q;p=p+1;w=w;x=x;fa=x+1;h=44;d:for(;;){Qa=h==44?0:Qa;Ha=h==44?w:Ha;var aa=fa+Qa;h=x+Qa;var ka=X+28+
h*32+24,ga=X+28+h*32+4,ja=X+28+h*32+12,ia=IHEAP[X+28+h*32+20]+36*m,ea=IHEAP[X+28+h*32+8]-IHEAP[X+28+h*32]==0;e:do if(ea)h=45;else{if(IHEAP[ja]-IHEAP[ga]==0){h=46;break e}if(!(0<IHEAP[ia+20]*IHEAP[ia+16])){h=48;break e}var oa=ia+24,pa=ia+32,da=ia+32,ha=ia+16,qa=ia+20,wa=ia+28;h=49;for(;;){var la=h==49?0:D,ma=la+1;D=IHEAP[oa]+44*la;if(IHEAP[D+40]!=0){var ua=_bio_read(n,1);h=53}else{var ra=_tgt_decode(n,IHEAP[wa],la,p);h=51}g=D;if((h==53?ua:ra)!=0){var ta=IHEAP[g+40]!=0;g:do if(!ta){if(_tgt_decode(V,
IHEAP[pa],la,0)!=0^1){h=56;g=57}else{h=56;g=58}for(;;)if(g==57){na=h==57?na:0;var va=na+1,na=na+1;if(_tgt_decode(ba,IHEAP[da],la,va)!=0^1)g=h=57;else{h=57;g=58}}else if(g==58){IHEAP[D+24]=IHEAP[ka]-((h==56?0:va)-1);IHEAP[D+28]=3;break g}}while(0);g=_bio_read(L,1)!=0;g:do if(g){if(_bio_read(L,1)==0){h=60;break g}h=_bio_read(L,2);if(h!=3){var ya=h+3;h=63}else{h=_bio_read(L,5);if(h!=31){var Ba=h+6;h=65}else{var Na=_bio_read(L,7)+37;h=66}}}else h=59;while(0);IHEAP[D+36]=h==63?ya:h==65?Ba:h==66?Na:h==
59?1:2;if(_bio_read(K,1)!=0){h=62;g=67}else{h=62;g=68}g:for(;;)if(g==67){Ja=h==67?Ja:0;var Pa=Ja+1;h=_bio_read(K,1)!=0;var Ja=Ja+1;if(h)g=h=67;else{h=67;g=68}}else if(g==68){IHEAP[D+28]+=h==62?0:Pa;var xa=D;g=IHEAP[D+40]!=0?69:70;break g}g:do if(g==69){var Ya=IHEAP[xa+40]-1;if(IHEAP[IHEAP[D+4]+28*Ya+8]!=IHEAP[IHEAP[D+4]+28*Ya+16]){h=69;break g}var $a=Ya+1;_t2_init_seg(D,$a,IHEAP[IHEAP[M]+1076*H+16],0);h=72}else if(g==70){_t2_init_seg(xa,0,IHEAP[IHEAP[T]+1076*A+16],1);h=70}while(0);ta=h==69?Ya:h==
72?$a:0;var db=IHEAP[D+36],Ta=ta+1;h=73;g:for(;;){var Ma=h==77?Ea:0,Ga=h==77?La:db,Ca=Ta+Ma,Ka=ta+Ma;h=IHEAP[IHEAP[D+4]+28*Ka+16]-IHEAP[IHEAP[D+4]+28*Ka+8];IHEAP[IHEAP[D+4]+28*Ka+20]=h<Ga?h:Ga;var Ra=IHEAP[D+28],Oa=IHEAP[IHEAP[D+4]+28*Ka+20];if(Oa>1){h=74;g=75}else{h=74;g=76}for(;;)if(g==75){Aa=h==75?Aa:0;var Ia=Aa+1,Sa=(h==75?Sa:Oa)>>1,Aa=Aa+1;if(Sa>1)g=h=75;else{h=75;g=76}}else if(g==76){La=_bio_read(I,(h==74?0:Ia)+Ra);IHEAP[IHEAP[D+4]+28*Ka+24]=La;var La=Ga-IHEAP[IHEAP[D+4]+28*Ka+20];if(La>0)break;
else break g}_t2_init_seg(D,Ca,IHEAP[IHEAP[R]+1076*O+16],0);var Ea=Ma+1;h=77}}else IHEAP[g+36]=0;D=la+1;if(ma<IHEAP[qa]*IHEAP[ha])h=79;else{h=79;break e}}}while(0);var Ha=h==45?Ha:h==46?Ha:h==48?0:ma,Qa=Qa+1;if(aa<IHEAP[l])h=47;else{h=47;break d}}w=Ha}p=_bio_inalign(q)!=0;X=q;if(p){g=82;break b}p=X;r+=IHEAP[p+8]-IHEAP[p];q=q;q!=0&&_free(q);if((IHEAP[v+4]&4)!=0){if(IHEAP[r]!=255){g=87;break b}if(IHEAP[r+1]!=146){g=87;break b}r+=2}if(y!=0)IHEAP[y+4]=r-j;if(IHEAP[z+92]==1){h=z+104;IHEAP[h]=0-r+IHEAP[z+
84]+IHEAP[h];IHEAP[z+84]=r}else if(IHEAP[v+5172]==1){h=v+5180;IHEAP[h]=0-r+IHEAP[v+5164]+IHEAP[h];IHEAP[v+5164]=r}else C=r;x=0;d:for(;;){if(!(x<IHEAP[t+24]))break d;v=t+28+x*32;z=IHEAP[v+20]+36*B;r=IHEAP[v+8]-IHEAP[v]==0;e:do if(!r){if(IHEAP[v+12]-IHEAP[v+4]==0)break e;w=0;for(;;){if(!(w<IHEAP[z+20]*IHEAP[z+16]))break e;h=IHEAP[z+24]+44*w;if(IHEAP[h+36]!=0){q=IHEAP[h+40]!=0;p=h;g:do if(q){y=IHEAP[h+4]+28*(IHEAP[p+40]-1);if(IHEAP[y+8]!=IHEAP[y+16])break g;y+=28;IHEAP[h+40]+=1}else{y=IHEAP[p+4];IHEAP[h+
40]+=1;IHEAP[h+32]=0}while(0);q=j+s;p=h;A=h+32;l=m=h;n=h+32;L=h;K=h+32;H=h+32;M=h+36;I=h+36;O=h+40;R=h+36;C=C;for(h=102;;){T=h==102?C:Da;if(T+IHEAP[y+24]>q){g=104;break b}Da=_realloc(IHEAP[p],(IHEAP[y+24]+IHEAP[A])*4);IHEAP[m]=Da;_llvm_memcpy_p0i8_p0i8_i32(IHEAP[l]+IHEAP[n],T,IHEAP[y+24],1,0);if(IHEAP[y+8]==0){IHEAP[y]=L;IHEAP[y+4]=IHEAP[K]}var Da=T+IHEAP[y+24];IHEAP[H]+=IHEAP[y+24];IHEAP[y+12]+=IHEAP[y+24];IHEAP[y+8]+=IHEAP[y+20];IHEAP[M]-=IHEAP[y+20];if(IHEAP[I]>0){y+=28;IHEAP[O]+=1}if(IHEAP[R]>
0)h=108;else break}C=Da}w+=1}}while(0);x+=1}var eb=C-j;h=95}else{_bio_inalign(q);k=q;r+=IHEAP[k+8]-IHEAP[k];k=q;k!=0&&_free(k);k=(IHEAP[v+4]&4)!=0;d:do if(k){var za=IHEAP[r]!=255;e:do if(!za){if(IHEAP[r+1]!=146)break e;r+=2;break d}while(0);_puts(_str)}while(0);if(y!=0)IHEAP[y+4]=C-j;if(IHEAP[z+92]==1){var Wa=z+104;IHEAP[Wa]=0-r+IHEAP[z+84]+IHEAP[Wa];IHEAP[z+84]=r;Wa=C-j;h=40}else if(IHEAP[v+5172]==1){var Ua=v+5180;IHEAP[Ua]=0-r+IHEAP[v+5164]+IHEAP[Ua];IHEAP[v+5164]=r;Ua=C-j;h=42}else{var ab=r-j;
h=43}}k=za=h==95?eb:h==43?ab:h==42?Ua:Wa;if(za==-999){h=113;g=114;break b}else h=113}j=E+232*o;if((h==7?F:za)>0){s=IHEAP[IHEAP[S+24]+48*IHEAP[E+232*o+24]+36];i=IHEAP[j+28];j=s;s=i;C=j;i=i>j?s:C;h=116}else{var tb=IHEAP[IHEAP[S+24]+48*IHEAP[j+24]+36];h=118}IHEAP[IHEAP[S+24]+48*IHEAP[E+232*o+24]+36]=h==116?i:tb;if(d!=0){s=IHEAP[d+88]+572*c;j=IHEAP[s+548]+20*IHEAP[d+8];if(IHEAP[d+8]!=0)if(IHEAP[IHEAP[s+548]+20*(IHEAP[d+8]-1)+8]>=IHEAP[IHEAP[IHEAP[d+88]+572*c+568]+20*N+8]){IHEAP[IHEAP[s+568]+20*N+16]=
IHEAP[d+8]-Q;Q=IHEAP[d+8];N+=1;IHEAP[j]=IHEAP[IHEAP[IHEAP[d+88]+572*c+568]+20*N+4]+1}else{C=IHEAP[P+16]!=0;d:do if(C){if(IHEAP[j]==0){g=121;break d}var Ab=IHEAP[j];h=120;g=122;break d}else g=121;while(0);if(g==121){var jb=IHEAP[IHEAP[s+548]+20*(IHEAP[d+8]-1)+8]+1;h=121}IHEAP[j]=h==120?Ab:jb}else IHEAP[j]=IHEAP[s+12]+1;IHEAP[j+8]=IHEAP[j]+-1+k;s=j+4;IHEAP[s]=IHEAP[j]+-1+IHEAP[s];IHEAP[d+8]+=1}if(k==-999)break c;J+=k}o+=1;g=1}b:do if(g==3){if(d!=0)IHEAP[IHEAP[IHEAP[d+88]+572*c+568]+20*N+16]=IHEAP[d+
8]-Q;_pi_destroy(E,P,c);o=k==-999?k:J-f;break a}else if(g==82){o=X;o!=0&&_free(o);g=85;break b}else if(g==87){_opj_event_msg(IHEAP[u],1,__str344);g=85;break b}else if(g==104){g=85;break b}while(0);if(g==85)k=-999}o=-999}while(0);return o}_t2_decode_packets.__index__=Runtime.getFunctionIndex(_t2_decode_packets,"_t2_decode_packets");function _t2_create(b,f,e){var c;c=_malloc(12);if(c!=0){IHEAP[c]=b;IHEAP[c+4]=f;IHEAP[c+8]=e;b=c}else b=0;return b}
_t2_create.__index__=Runtime.getFunctionIndex(_t2_create,"_t2_create");function _t2_destroy(b){b!=0&&_free(b)}_t2_destroy.__index__=Runtime.getFunctionIndex(_t2_destroy,"_t2_destroy");
function _t2_init_seg(b,f,e,c){var a=null;a=_realloc(IHEAP[b+4],(f+1)*28);IHEAP[b+4]=a;b=IHEAP[b+4]+28*f;IHEAP[b]=0;IHEAP[b+4]=0;IHEAP[b+8]=0;IHEAP[b+12]=0;if((e&4)!=0)IHEAP[b+16]=1;else if((e&1)!=0)if(c!=0)IHEAP[b+16]=10;else{if(IHEAP[b+-28+16]==1)a=2;else{var d=IHEAP[b+-28+16]==10;a=0}IHEAP[b+16]=(a==2?1:d)?2:1}else IHEAP[b+16]=109}_t2_init_seg.__index__=Runtime.getFunctionIndex(_t2_init_seg,"_t2_init_seg");
function _tcd_dump(b,f,e){var c,a=null;_fwrite(__str49108,8,1,b);_fprintf(b,__str150,IHEAP[e],IHEAP[e+4],IHEAP[IHEAP[f+28]],IHEAP[IHEAP[f+28]+8],IHEAP[IHEAP[f+28]+4],IHEAP[IHEAP[f+28]+12]);if(0<IHEAP[e]*IHEAP[e+4]){f=f+24;var d=e+4;a=0;a:for(;;){B=a==0?0:B;var g=0+B,h=1+B,i=IHEAP[IHEAP[f]+8];_fwrite(__str251,9,1,b);_fprintf(b,__str352,IHEAP[i+840*g],IHEAP[i+840*g+4],IHEAP[i+840*g+8],IHEAP[i+840*g+12],IHEAP[i+840*g+16]);if(0<IHEAP[i+840*g+16]){var j=i+840*g+16;g=i+840*g+20;a=2;b:for(;;){A=a==2?0:A;
i=A+1;var k=IHEAP[g];_fwrite(__str453,12,1,b);_fprintf(b,__str554,IHEAP[k+32*A],IHEAP[k+32*A+4],IHEAP[k+32*A+8],IHEAP[k+32*A+12],IHEAP[k+32*A+16]);if(0<IHEAP[k+32*A+16]){var m=k+32*A+16;k=k+32*A+20;a=4;c:for(;;){z=a==4?0:z;var l=z+1,n=IHEAP[k];_fwrite(__str655,10,1,b);_fprintf(b,__str756,IHEAP[n+124*z],IHEAP[n+124*z+4],IHEAP[n+124*z+8],IHEAP[n+124*z+12],IHEAP[n+124*z+16],IHEAP[n+124*z+20],IHEAP[n+124*z+24]);if(0<IHEAP[n+124*z+24]){var o=n+124*z+24,p=n+124*z+16,r=n+124*z+20;a=6;d:for(;;){var q=a==
6?0:C;a=n+124*z+28+q*32+4;c=n+124*z+28+q*32+8;var u=n+124*z+28+q*32+12,s=n+124*z+28+q*32+28,t=n+124*z+28+q*32+24,v=n+124*z+28+q*32+20,y=n+124*z+28+q*32,x=q+1;_fwrite(__str857,15,1,b);_fprintf(b,__str958,IHEAP[y],IHEAP[a],IHEAP[c],IHEAP[u],FHEAP[s],IHEAP[t]);if(0<IHEAP[r]*IHEAP[p]){a=7;c=8}else{a=7;c=9}for(;;)if(c==8){w=a==8?w:0;a=w+1;c=IHEAP[v];_fwrite(__str1059,17,1,b);_fprintf(b,__str1160,IHEAP[c+36*w],IHEAP[c+36*w+4],IHEAP[c+36*w+8],IHEAP[c+36*w+12],IHEAP[c+36*w+16],IHEAP[c+36*w+20]);_fwrite(__str1261,
12,1,b);var w=w+1;if(a<IHEAP[r]*IHEAP[p])c=a=8;else{a=10;c=9}}else if(c==9){_fwrite(__str1362,10,1,b);var C=q+1;if(x<IHEAP[o]){a=9;continue d}else break d}}}_fwrite(__str1463,8,1,b);var z=z+1;if(l<IHEAP[m])a=13;else break c}}_fwrite(__str1564,6,1,b);var A=A+1;if(i<IHEAP[j])a=16;else break b}}_fwrite(__str1665,4,1,b);var B=B+1;if(h<IHEAP[e]*IHEAP[d])a=19;else break a}}_fwrite(__str17109,2,1,b)}_tcd_dump.__index__=Runtime.getFunctionIndex(_tcd_dump,"_tcd_dump");
function _tcd_create(b){var f;f=_malloc(56);if(f!=0){IHEAP[f+20]=b;b=_malloc(12);IHEAP[f+24]=b;if(IHEAP[f+24]!=0)f=f;else{_free(f);f=0}}else f=0;return f}_tcd_create.__index__=Runtime.getFunctionIndex(_tcd_create,"_tcd_create");function _tcd_destroy(b){if(b!=0){_free(IHEAP[b+24]);_free(b)}}_tcd_destroy.__index__=Runtime.getFunctionIndex(_tcd_destroy,"_tcd_destroy");
function _tcd_malloc_encode(b,f,e,c){var a,d=null,g,h,i,j;IHEAP[b+28]=f;IHEAP[b+32]=e;IHEAP[IHEAP[b+24]]=IHEAP[e+68];IHEAP[IHEAP[b+24]+4]=IHEAP[e+72];var k=_malloc(840);IHEAP[IHEAP[b+24]+8]=k;k=e+108;var m=e+68,l=e+68,n=b+24,o=e+48,p=e+56,r=e+52,q=e+60,u=f+4,s=e+48,t=e+56,v=f+8,y=e+52,x=e+60,w=f+12,C=f+16;e=e+16;var z=f+24,A=f+24,B=f+24;b=b+12;var D=f+16,J=f+24,E=f+24,N=f+24,Q=f+24,S=f+24;d=0;a:for(;;){Wa=d==0?0:Wa;var P=IHEAP[k],G=P+5588*c,F=c%IHEAP[m],L=c/IHEAP[l]|0,K=IHEAP[IHEAP[n]+8],H=IHEAP[p]*
F+IHEAP[o],M=IHEAP[f];IHEAP[K]=H>M?H:M;H=IHEAP[q]*L+IHEAP[r];M=IHEAP[u];IHEAP[K+4]=H>M?H:M;F=IHEAP[t]*(F+1)+IHEAP[s];H=IHEAP[v];IHEAP[K+8]=F<H?F:H;L=IHEAP[x]*(L+1)+IHEAP[y];F=IHEAP[w];IHEAP[K+12]=L<F?L:F;IHEAP[K+16]=IHEAP[C];L=0<IHEAP[G+12];b:do if(L){F=K+16;H=K+8;M=K;var I=K+12,O=K+4,R=G+12,T=G+12,V=G+12,ba=P+5588*c+16;d=2;for(;;){X=d==2?0:X;var fa=P+5588*c+20+X*4,ca=ba+4*X,U=X+1,$=FHEAP[fa]!=0;d:do if($){var Y=(IHEAP[H]-IHEAP[M])*IHEAP[F]*(IHEAP[I]-IHEAP[O])*IHEAP[IHEAP[z]+24]/(FHEAP[fa]*8*IHEAP[IHEAP[A]]*
IHEAP[IHEAP[B]+4]);if(IHEAP[e]!=0){var Z=Y-((IHEAP[b]-1)*14/IHEAP[R]|0);d=5}else d=55;Y=d==5?Z:Y;FHEAP[fa]=Y;if(Y==0)break d;Y=X!=0;var W=FHEAP[fa];e:do if(Y){if(!(W<FHEAP[ca]+10))break e;FHEAP[fa]=FHEAP[ca]+20}else{if(!(W<30))break e;FHEAP[fa]=30}while(0);if(X!=IHEAP[T]-1)break d;FHEAP[fa]-=2}else FHEAP[fa]=0;while(0);var X=X+1;if(U<IHEAP[V])d=8;else break b}}while(0);P=_malloc(IHEAP[D]*32);IHEAP[K+20]=P;if(0<IHEAP[K+16]){G=G+5584;P=K+20;L=K;F=K+4;H=K+8;M=K+12;K=K+16;d=15;b:for(;;){O=d==15?0:g;I=
O+1;R=IHEAP[G];g=IHEAP[P]+32*O;T=IHEAP[IHEAP[J]+48*O];IHEAP[g]=(IHEAP[L]+-1+T)/T|0;T=IHEAP[IHEAP[E]+48*O+4];IHEAP[g+4]=(IHEAP[F]+-1+T)/T|0;T=IHEAP[IHEAP[N]+48*O];IHEAP[g+8]=(IHEAP[H]+-1+T)/T|0;T=IHEAP[IHEAP[Q]+48*O+4];IHEAP[g+12]=(IHEAP[M]+-1+T)/T|0;T=_memalign(16,(IHEAP[g+8]-IHEAP[g])*4*(IHEAP[g+12]-IHEAP[g+4]));IHEAP[g+24]=T;IHEAP[g+16]=IHEAP[R+1076*O+4];T=_malloc(IHEAP[g+16]*124);IHEAP[g+20]=T;if(0<IHEAP[g+16]){T=R+1076*O;V=R+1076*O+8;ba=R+1076*O+12;U=R+1076*O+28+4;fa=R+1076*O+28;ca=R+1076*O+28;
$=R+1076*O+20;Y=R+1076*O+804;d=17;c:for(;;){var aa=d==17?0:h,ka=R+1076*O+944+aa*4,ga=R+1076*O+812+aa*4,ja=aa*3+-2;i=aa*-1;var ia=i+-1;W=aa+1;var ea=IHEAP[g+16];h=IHEAP[g+20]+124*aa;IHEAP[h]=IHEAP[g]+-1+(1<<ea+ia)>>ea+ia;IHEAP[h+4]=IHEAP[g+4]+-1+(1<<ea+ia)>>ea+ia;IHEAP[h+8]=IHEAP[g+8]+-1+(1<<ea+ia)>>ea+ia;IHEAP[h+12]=IHEAP[g+12]+-1+(1<<ea+ia)>>ea+ia;IHEAP[h+24]=aa==0?1:3;if((IHEAP[T]&1)!=0){var oa=IHEAP[ga],pa=IHEAP[ka];d=19}else d=18;var da=d==19?pa:15,ha=d==19?oa:15;ga=IHEAP[h]>>ha<<ha;ka=IHEAP[h+
4]>>da<<da;var qa=IHEAP[h+12]+-1+(1<<da)>>da<<da;IHEAP[h+16]=(IHEAP[h+8]+-1+(1<<ha)>>ha<<ha)-ga>>ha;IHEAP[h+20]=qa-ka>>da;if(aa==0)d=21;else{var wa=ga+-1+2>>1,la=ka+-1+2>>1,ma=ha-1,ua=da-1;d=23}var ra=d==23?ua:da;ka=d==23?la:ka;var ta=d==23?ma:ha;ga=d==23?wa:ga;ha=IHEAP[V];ha=ha<ta?ha:ta;da=IHEAP[ba];da=da<ra?da:ra;if(0<IHEAP[h+24]){qa=aa==0;var va=aa==0,na=1<<ta,ya=1<<ra;ta=1<<ta;ra=1<<ra;var Ba=1<<ha,Na=1<<da,Pa=1<<ha,Ja=1<<da,xa=ea+ia,Ya=1<<xa,$a=1<<xa;xa=1<<xa;var db=1<<ea+ia;ia=ea+ia;ea=ea+i;
d=24;d:for(;;){var Ta=d==24?0:za;j=ja+Ta;var Ma=Ta+1;i=h+28+Ta*32;IHEAP[i+16]=qa?0:Ma;if(IHEAP[i+16]==1)d=25;else{var Ga=IHEAP[i+16]==3;d=26}var Ca=(d==25?1:Ga)?1:0;if(IHEAP[i+16]==2)d=53;else{var Ka=IHEAP[i+16]==3;d=28}d=(d==53?1:Ka)?1:0;var Ra=IHEAP[g];if(IHEAP[i+16]==0){IHEAP[i]=Ra+-1+(1<<ia)>>ia;IHEAP[i+4]=IHEAP[g+4]+-1+(1<<ia)>>ia;IHEAP[i+8]=IHEAP[g+8]+-1+(1<<ia)>>ia;IHEAP[i+12]=IHEAP[g+12]+-1+(1<<ia)>>ia}else{IHEAP[i]=Ra-Ca*Ya+-1+(1<<ea)>>ea;IHEAP[i+4]=IHEAP[g+4]-$a*d+-1+(1<<ea)>>ea;IHEAP[i+
8]=IHEAP[g+8]-xa*Ca+-1+(1<<ea)>>ea;IHEAP[i+12]=IHEAP[g+12]-db*d+-1+(1<<ea)>>ea}j=va?0:j;Ca=IHEAP[i+16];Ra=IHEAP[$]==0|Ca==0;e:do if(Ra)d=54;else{if(Ca==1){d=52;break e}else if(Ca==2){d=52;break e}d=31}while(0);Ca=1+IHEAP[U+4*j*2]/2048;d=_ldexp(1,(d==54?0:d==31?2:d==52?1:1)+IHEAP[IHEAP[S]+48*O+24]-IHEAP[fa+8*j]);FHEAP[i+28]=Ca*d;IHEAP[i+24]=IHEAP[ca+8*j]+-1+IHEAP[Y];d=_malloc(IHEAP[h+16]*108*IHEAP[h+20]);IHEAP[i+20]=d;if(0<IHEAP[h+16]*3*IHEAP[h+20]){d=33;a=34}else{d=33;a=35}e:for(;;)if(a==34){Oa=d==
34?Oa:0;d=Oa+1;IHEAP[IHEAP[i+20]+36*Oa+32]=0;IHEAP[IHEAP[i+20]+36*Oa+28]=0;var Oa=Oa+1;if(d<IHEAP[h+16]*3*IHEAP[h+20])a=d=34;else{d=34;a=35}}else if(a==35){if(0<IHEAP[h+20]*IHEAP[h+16]){d=35;a=36}else{d=35;a=37}break e}e:for(;;)if(a==36){Ca=d==39?eb:0;Ra=Ca+1;a=na*(Ca%IHEAP[h+16])+ga;var Ia=ya*(Ca/IHEAP[h+16]|0)+ka,Sa=ta+a;d=ra+Ia;j=IHEAP[i+20]+36*Ca;var Aa=IHEAP[i];IHEAP[j]=a>Aa?a:Aa;a=IHEAP[i+4];IHEAP[j+4]=Ia>a?Ia:a;Ia=IHEAP[i+8];IHEAP[j+8]=Sa<Ia?Sa:Ia;Sa=IHEAP[i+12];IHEAP[j+12]=d<Sa?d:Sa;Sa=IHEAP[j]>>
ha<<ha;Ia=IHEAP[j+4]>>da<<da;d=IHEAP[j+12]+-1+(1<<da)>>da<<da;IHEAP[j+16]=(IHEAP[j+8]+-1+(1<<ha)>>ha<<ha)-Sa>>ha;IHEAP[j+20]=d-Ia>>da;d=_calloc(IHEAP[j+20]*IHEAP[j+16],48);IHEAP[j+24]=d;d=_tgt_create(IHEAP[j+16],IHEAP[j+20]);IHEAP[j+28]=d;d=_tgt_create(IHEAP[j+16],IHEAP[j+20]);IHEAP[j+32]=d;if(0<IHEAP[j+20]*IHEAP[j+16]){d=36;a=38}else{d=36;a=39}for(;;)if(a==38){Da=d==38?Da:0;d=Da+1;var La=Ba*(Da%IHEAP[j+16])+Sa,Ea=Na*(Da/IHEAP[j+16]|0)+Ia,Ha=Pa+La;Aa=Ja+Ea;a=IHEAP[j+24];var Qa=IHEAP[j];IHEAP[a+48*
Da+12]=La>Qa?La:Qa;La=IHEAP[j+4];IHEAP[a+48*Da+16]=Ea>La?Ea:La;Ea=IHEAP[j+8];IHEAP[a+48*Da+20]=Ha<Ea?Ha:Ea;Ha=IHEAP[j+12];IHEAP[a+48*Da+24]=Aa<Ha?Aa:Ha;Aa=_calloc(8194,1);IHEAP[a+48*Da]=Aa;IHEAP[a+48*Da]+=2;Aa=_calloc(100,20);IHEAP[a+48*Da+4]=Aa;Aa=_calloc(100,20);IHEAP[a+48*Da+8]=Aa;var Da=Da+1;if(d<IHEAP[j+20]*IHEAP[j+16])a=d=38;else{d=40;a=39}}else if(a==39){var eb=Ca+1;if(Ra<IHEAP[h+20]*IHEAP[h+16]){d=39;a=36;continue e}else break}d=41;a=37}else if(a==37){var za=Ta+1;if(Ma<IHEAP[h+24]){d=37;continue d}else break d}}}h=
aa+1;if(W<IHEAP[g+16])d=44;else break c}}g=O+1;if(I<IHEAP[K])d=47;else break b}}var Wa=Wa+1;if(Wa!=1)d=50;else break a}}_tcd_malloc_encode.__index__=Runtime.getFunctionIndex(_tcd_malloc_encode,"_tcd_malloc_encode");
function _tcd_free_encode(b){var f,e=null,c=IHEAP[IHEAP[b+24]+8],a=b+24;e=0;a:for(;;){J=e==0?0:J;D=e==0?c:D;if(0<IHEAP[D+16]){var d=D+20,g=D+16;e=2;b:for(;;){B=e==2?0:B;var h=B+1,i=IHEAP[d];if(0<IHEAP[i+32*B+16]){var j=i+32*B+16,k=i+32*B+20;e=4;c:for(;;){A=e==4?0:A;var m=A+1,l=IHEAP[k];if(0<IHEAP[l+124*A+24]){var n=l+124*A+24,o=l+124*A+16,p=l+124*A+20;e=6;d:for(;;){var r=e==6?0:z,q=l+124*A+28+r*32+20,u=r+1;if(0<IHEAP[p]*IHEAP[o]){e=7;f=8}else{e=7;f=9}e:for(;;)if(f==8){C=e==14?C:0;f=C+1;var s=IHEAP[q];
if(IHEAP[s+36*C+28]!=0){e=IHEAP[s+36*C+28];_free(IHEAP[e+12]);_free(e);IHEAP[s+36*C+28]=0}if(IHEAP[s+36*C+32]!=0){e=IHEAP[s+36*C+32];_free(IHEAP[e+12]);_free(e);IHEAP[s+36*C+32]=0}var t=0<IHEAP[s+36*C+20]*IHEAP[s+36*C+16];f:do if(t){var v=s+36*C+16,y=s+36*C+20,x=s+36*C+24;for(e=12;;){w=e==12?0:w;e=w+1;_free(IHEAP[IHEAP[x]+48*w]+-2);_free(IHEAP[IHEAP[x]+48*w+4]);_free(IHEAP[IHEAP[x]+48*w+8]);var w=w+1;if(e<IHEAP[y]*IHEAP[v])e=13;else break f}}while(0);_free(IHEAP[s+36*C+24]);var C=C+1;if(f<IHEAP[p]*
IHEAP[o]){e=14;f=8;continue e}e=15;f=9}else if(f==9){_free(IHEAP[q]);IHEAP[q]=0;var z=r+1;if(u<IHEAP[n]){e=9;continue d}else break d}}}var A=A+1;if(m<IHEAP[j])e=18;else break c}}_free(IHEAP[i+32*B+20]);IHEAP[i+32*B+20]=0;var B=B+1;if(h<IHEAP[g])e=21;else break b}}_free(IHEAP[D+20]);IHEAP[D+20]=0;var D=IHEAP[IHEAP[a]+8],J=J+1;if(J!=1)e=24;else break a}_free(D);IHEAP[IHEAP[b+24]+8]=0}_tcd_free_encode.__index__=Runtime.getFunctionIndex(_tcd_free_encode,"_tcd_free_encode");
function _tcd_init_encode(b,f,e,c){var a,d=null,g,h,i,j,k=e+108,m=e+68,l=e+68,n=b+24,o=e+48,p=e+56,r=e+52,q=e+60,u=f+4,s=e+48,t=e+56,v=f+8,y=e+52,x=e+60,w=f+12,C=f+16;e=e+16;var z=f+24,A=f+24,B=f+24;b=b+12;var D=f+24,J=f+24,E=f+24,N=f+24,Q=f+24;d=0;a:for(;;){Ua=d==0?0:Ua;var S=IHEAP[k],P=S+5588*c,G=c%IHEAP[m],F=c/IHEAP[l]|0,L=IHEAP[IHEAP[n]+8],K=IHEAP[p]*G+IHEAP[o],H=IHEAP[f];IHEAP[L]=K>H?K:H;K=IHEAP[q]*F+IHEAP[r];H=IHEAP[u];IHEAP[L+4]=K>H?K:H;G=IHEAP[t]*(G+1)+IHEAP[s];K=IHEAP[v];IHEAP[L+8]=G<K?G:
K;F=IHEAP[x]*(F+1)+IHEAP[y];G=IHEAP[w];IHEAP[L+12]=F<G?F:G;IHEAP[L+16]=IHEAP[C];F=0<IHEAP[P+12];b:do if(F){G=L+16;K=L+8;H=L;var M=L+12,I=L+4,O=P+12,R=P+12,T=S+5588*c+16;d=2;for(;;){Y=d==2?0:Y;var V=S+5588*c+20+Y*4,ba=T+4*Y,fa=Y+1,ca=FHEAP[V]!=0;d:do if(ca){var U=(IHEAP[K]-IHEAP[H])*IHEAP[G]*(IHEAP[M]-IHEAP[I])*IHEAP[IHEAP[z]+24]/(FHEAP[V]*8*IHEAP[IHEAP[A]]*IHEAP[IHEAP[B]+4]);if(IHEAP[e]!=0){var $=U-((IHEAP[b]-1)*14/IHEAP[O]|0);d=5}else d=55;U=d==5?$:U;FHEAP[V]=U;if(U==0)break d;U=FHEAP[V];if(Y!=0){if(!(U<
FHEAP[ba]+10))break d;FHEAP[V]=FHEAP[ba]+20}else{if(!(U<30))break d;FHEAP[V]=30}}else FHEAP[V]=0;while(0);var Y=Y+1;if(fa<IHEAP[R])d=8;else break b}}while(0);if(0<IHEAP[L+16]){S=P+5584;P=L+20;F=L;G=L+4;K=L+8;H=L+12;L=L+16;d=12;b:for(;;){I=d==12?0:g;M=I+1;O=IHEAP[S];g=IHEAP[P]+32*I;R=IHEAP[IHEAP[D]+48*I];IHEAP[g]=(IHEAP[F]+-1+R)/R|0;R=IHEAP[IHEAP[J]+48*I+4];IHEAP[g+4]=(IHEAP[G]+-1+R)/R|0;R=IHEAP[IHEAP[E]+48*I];IHEAP[g+8]=(IHEAP[K]+-1+R)/R|0;R=IHEAP[IHEAP[N]+48*I+4];IHEAP[g+12]=(IHEAP[H]+-1+R)/R|0;
R=_memalign(16,(IHEAP[g+8]-IHEAP[g])*4*(IHEAP[g+12]-IHEAP[g+4]));IHEAP[g+24]=R;IHEAP[g+16]=IHEAP[O+1076*I+4];if(0<IHEAP[g+16]){R=O+1076*I;T=O+1076*I+8;fa=O+1076*I+12;V=O+1076*I+28+4;ba=O+1076*I+28;ca=O+1076*I+28;U=O+1076*I+20;var Z=O+1076*I+804;d=14;c:for(;;){var W=d==14?0:h,X=O+1076*I+944+W*4,aa=O+1076*I+812+W*4,ka=W*3+-2,ga=W*-1,ja=ga+-1,ia=W+1,ea=IHEAP[g+16];h=IHEAP[g+20]+124*W;IHEAP[h]=IHEAP[g]+-1+(1<<ea+ja)>>ea+ja;IHEAP[h+4]=IHEAP[g+4]+-1+(1<<ea+ja)>>ea+ja;IHEAP[h+8]=IHEAP[g+8]+-1+(1<<ea+ja)>>
ea+ja;IHEAP[h+12]=IHEAP[g+12]+-1+(1<<ea+ja)>>ea+ja;IHEAP[h+24]=W==0?1:3;if((IHEAP[R]&1)!=0){var oa=IHEAP[aa],pa=IHEAP[X];d=16}else d=15;var da=d==16?pa:15,ha=d==16?oa:15;aa=IHEAP[h]>>ha<<ha;X=IHEAP[h+4]>>da<<da;var qa=IHEAP[h+12]+-1+(1<<da)>>da<<da;IHEAP[h+16]=(IHEAP[h+8]+-1+(1<<ha)>>ha<<ha)-aa>>ha;IHEAP[h+20]=qa-X>>da;if(W==0)d=18;else{var wa=aa+-1+2>>1,la=X+-1+2>>1,ma=ha-1,ua=da-1;d=20}var ra=d==20?ua:da;X=d==20?la:X;var ta=d==20?ma:ha;aa=d==20?wa:aa;ha=IHEAP[T];ha=ha<ta?ha:ta;da=IHEAP[fa];da=da<
ra?da:ra;if(0<IHEAP[h+24]){qa=W==0;var va=W==0,na=1<<ta,ya=1<<ra;ta=1<<ta;ra=1<<ra;var Ba=1<<ha,Na=1<<da,Pa=1<<ha,Ja=1<<da,xa=ea+ja,Ya=1<<xa,$a=1<<xa;xa=1<<xa;var db=1<<ea+ja;ja=ea+ja;ga=ea+ga;d=21;d:for(;;){var Ta=d==21?0:i;j=ka+Ta;ea=Ta+1;i=h+28+Ta*32;IHEAP[i+16]=qa?0:ea;if(IHEAP[i+16]==1)d=22;else{var Ma=IHEAP[i+16]==3;d=23}var Ga=(d==22?1:Ma)?1:0;if(IHEAP[i+16]==2)d=53;else{var Ca=IHEAP[i+16]==3;d=25}d=(d==53?1:Ca)?1:0;var Ka=IHEAP[g];if(IHEAP[i+16]==0){IHEAP[i]=Ka+-1+(1<<ja)>>ja;IHEAP[i+4]=IHEAP[g+
4]+-1+(1<<ja)>>ja;IHEAP[i+8]=IHEAP[g+8]+-1+(1<<ja)>>ja;IHEAP[i+12]=IHEAP[g+12]+-1+(1<<ja)>>ja}else{IHEAP[i]=Ka-Ga*Ya+-1+(1<<ga)>>ga;IHEAP[i+4]=IHEAP[g+4]-$a*d+-1+(1<<ga)>>ga;IHEAP[i+8]=IHEAP[g+8]-xa*Ga+-1+(1<<ga)>>ga;IHEAP[i+12]=IHEAP[g+12]-db*d+-1+(1<<ga)>>ga}j=va?0:j;Ga=IHEAP[i+16];Ka=IHEAP[U]==0|Ga==0;e:do if(Ka)d=54;else{if(Ga==1){d=51;break e}else if(Ga==2){d=51;break e}d=28}while(0);Ga=1+IHEAP[V+4*j*2]/2048;d=_ldexp(1,(d==54?0:d==28?2:d==51?1:1)+IHEAP[IHEAP[Q]+48*I+24]-IHEAP[ba+8*j]);FHEAP[i+
28]=Ga*d;IHEAP[i+24]=IHEAP[ca+8*j]+-1+IHEAP[Z];if(0<IHEAP[h+20]*IHEAP[h+16]){Ga=h+16;Ka=h+16;var Ra=h+16,Oa=h+20;d=30;e:for(;;){var Ia=d==30?0:Wa,Sa=Ia+1;a=na*(Ia%IHEAP[Ga])+aa;var Aa=ya*(Ia/IHEAP[Ka]|0)+X,La=ta+a;d=ra+Aa;j=IHEAP[i+20]+36*Ia;var Ea=IHEAP[i];IHEAP[j]=a>Ea?a:Ea;a=IHEAP[i+4];IHEAP[j+4]=Aa>a?Aa:a;Aa=IHEAP[i+8];IHEAP[j+8]=La<Aa?La:Aa;La=IHEAP[i+12];IHEAP[j+12]=d<La?d:La;La=IHEAP[j]>>ha<<ha;Aa=IHEAP[j+4]>>da<<da;d=IHEAP[j+12]+-1+(1<<da)>>da<<da;IHEAP[j+16]=(IHEAP[j+8]+-1+(1<<ha)>>ha<<ha)-
La>>ha;IHEAP[j+20]=d-Aa>>da;_free(IHEAP[j+24]);d=_calloc(IHEAP[j+20]*IHEAP[j+16],48);IHEAP[j+24]=d;if(IHEAP[j+28]!=0){d=IHEAP[j+28];_free(IHEAP[d+12]);_free(d)}if(IHEAP[j+32]!=0){d=IHEAP[j+32];_free(IHEAP[d+12]);_free(d)}d=_tgt_create(IHEAP[j+16],IHEAP[j+20]);IHEAP[j+28]=d;d=_tgt_create(IHEAP[j+16],IHEAP[j+20]);IHEAP[j+32]=d;if(0<IHEAP[j+20]*IHEAP[j+16]){d=34;a=35}else{d=34;a=36}for(;;)if(a==35){za=d==35?za:0;d=za+1;var Ha=Ba*(za%IHEAP[j+16])+La,Qa=Na*(za/IHEAP[j+16]|0)+Aa,Da=Pa+Ha;Ea=Ja+Qa;a=IHEAP[j+
24];var eb=IHEAP[j];IHEAP[a+48*za+12]=Ha>eb?Ha:eb;Ha=IHEAP[j+4];IHEAP[a+48*za+16]=Qa>Ha?Qa:Ha;Qa=IHEAP[j+8];IHEAP[a+48*za+20]=Da<Qa?Da:Qa;Da=IHEAP[j+12];IHEAP[a+48*za+24]=Ea<Da?Ea:Da;Ea=_calloc(8194,1);IHEAP[a+48*za]=Ea;IHEAP[a+48*za]+=2;Ea=_calloc(100,20);IHEAP[a+48*za+4]=Ea;Ea=_calloc(100,20);IHEAP[a+48*za+8]=Ea;var za=za+1;if(d<IHEAP[j+20]*IHEAP[j+16])a=d=35;else{d=37;a=36}}else if(a==36){var Wa=Ia+1;if(Sa<IHEAP[Oa]*IHEAP[Ra]){d=36;continue e}else break e}}}i=Ta+1;if(ea<IHEAP[h+24])d=40;else break d}}h=
W+1;if(ia<IHEAP[g+16])d=43;else break c}}g=I+1;if(M<IHEAP[L])d=46;else break b}}var Ua=Ua+1;if(Ua!=1)d=49;else break a}}_tcd_init_encode.__index__=Runtime.getFunctionIndex(_tcd_init_encode,"_tcd_init_encode");
function _tcd_malloc_decode(b,f,e){var c,a=null;IHEAP[b+28]=f;IHEAP[IHEAP[b+24]]=IHEAP[e+68];IHEAP[IHEAP[b+24]+4]=IHEAP[e+72];var d=_malloc(IHEAP[e+68]*840*IHEAP[e+72]);IHEAP[IHEAP[b+24]+8]=d;if(0<IHEAP[e+80]){d=b+24;var g=f+16,h=f+16;for(a=0;;){m=a==0?0:m;var i=1+m,j=IHEAP[IHEAP[d]+8]+840*IHEAP[IHEAP[e+76]+4*IHEAP[IHEAP[e+76]+4*(0+m)]];IHEAP[j+16]=IHEAP[g];var k=_calloc(IHEAP[h],32);IHEAP[j+20]=k;var m=m+1;if(i<IHEAP[e+80])a=1;else break}}if(0<IHEAP[f+16]){b=b+24;d=f+4;g=f+8;h=f+12;i=f+24;m=f+24;
j=f+24;k=f+24;var l=f+24,n=f+24,o=f+24,p=f+24,r=f+24,q=f+24,u=f+16;a=4;a:for(;;){var s=a==4?0:ba,t=a==4?0:O,v=a==4?0:R,y=a==4?0:T,x=a==4?0:V,w=0+s,C=1+s;if(0<IHEAP[e+80]){a=5;c=6}else{a=5;c=7}for(;;)if(c==6){K=a==11?K:t;H=a==11?H:v;L=a==11?L:y;M=a==11?M:x;I=a==11?I:0;c=I+1;var z=IHEAP[IHEAP[e+76]+4*I],A=IHEAP[IHEAP[b]+8]+840*IHEAP[IHEAP[e+76]+4*z];a=IHEAP[A+20];var B=z%IHEAP[e+68];z=z/IHEAP[e+68]|0;var D=IHEAP[e+56]*B+IHEAP[e+48],J=IHEAP[f];IHEAP[A]=D>J?D:J;D=IHEAP[e+60]*z+IHEAP[e+52];J=IHEAP[d];
IHEAP[A+4]=D>J?D:J;B=IHEAP[e+56]*(B+1)+IHEAP[e+48];D=IHEAP[g];IHEAP[A+8]=B<D?B:D;z=IHEAP[e+60]*(z+1)+IHEAP[e+52];B=IHEAP[h];IHEAP[A+12]=z<B?z:B;z=IHEAP[IHEAP[i]+48*w];IHEAP[a+32*w]=(IHEAP[A]+-1+z)/z|0;z=IHEAP[IHEAP[m]+48*w+4];IHEAP[a+32*w+4]=(IHEAP[A+4]+-1+z)/z|0;z=IHEAP[IHEAP[j]+48*w];IHEAP[a+32*w+8]=(IHEAP[A+8]+-1+z)/z|0;z=IHEAP[IHEAP[k]+48*w+4];IHEAP[a+32*w+12]=(IHEAP[A+12]+-1+z)/z|0;A=IHEAP[a+32*w];if(I==0){var E=IHEAP[a+32*w+4],N=IHEAP[a+32*w+8],Q=IHEAP[a+32*w+12];a=8}else{var S=K<A?K:A,P=IHEAP[a+
32*w];P=H<P?H:P;var G=IHEAP[a+32*w+8];G=L>G?L:G;var F=IHEAP[a+32*w+12];F=M>F?M:F;a=10}var L=a==8?N:G,K=a==8?A:S,H=a==8?E:P,M=a==8?Q:F,I=I+1;if(c<IHEAP[e+80]){a=11;c=6}else{a=12;c=7}}else if(c==7){var O=a==12?K:t,R=a==12?H:v,T=a==12?L:y,V=a==12?M:x;ba=IHEAP[IHEAP[l]+48*w+40];t=IHEAP[IHEAP[n]+48*w+40];t=V-R+-1+(1<<t)>>t;IHEAP[IHEAP[o]+48*w+8]=T-O+-1+(1<<ba)>>ba;IHEAP[IHEAP[p]+48*w+12]=t;IHEAP[IHEAP[r]+48*w+16]=O;IHEAP[IHEAP[q]+48*w+20]=R;var ba=s+1;if(C<IHEAP[u]){a=7;continue a}else break a}}}}
_tcd_malloc_decode.__index__=Runtime.getFunctionIndex(_tcd_malloc_decode,"_tcd_malloc_decode");
function _tcd_malloc_decode_tile(b,f,e,c){var a,d=null,g,h,i,j,k;IHEAP[b+32]=e;g=IHEAP[e+108]+5588*IHEAP[IHEAP[e+76]+4*c];b=IHEAP[IHEAP[b+24]+8]+840*IHEAP[IHEAP[e+76]+4*c];if(0<IHEAP[b+16]){e=g+5584;c=b+20;g=f+24;var m=b+4,l=f+24,n=b+8,o=f+24,p=b+12,r=f+24;f=f+24;var q=b+16;d=0;a:for(;;){var u=d==0?0:h,s=0+u,t=1+u,v=IHEAP[e];h=IHEAP[c]+32*s;var y=IHEAP[IHEAP[g]+48*s];IHEAP[h]=(IHEAP[b]+-1+y)/y|0;y=IHEAP[IHEAP[l]+48*s+4];IHEAP[h+4]=(IHEAP[m]+-1+y)/y|0;y=IHEAP[IHEAP[o]+48*s];IHEAP[h+8]=(IHEAP[n]+-1+
y)/y|0;y=IHEAP[IHEAP[r]+48*s+4];IHEAP[h+12]=(IHEAP[p]+-1+y)/y|0;IHEAP[h+16]=IHEAP[v+1076*s+4];y=_malloc(IHEAP[h+16]*124);IHEAP[h+20]=y;if(0<IHEAP[h+16]){y=v+1076*s;var x=v+1076*s+8,w=v+1076*s+12,C=v+1076*s+28+4,z=v+1076*s+28,A=v+1076*s+28,B=v+1076*s+20,D=v+1076*s+804;d=2;b:for(;;){var J=d==2?0:i,E=v+1076*s+944+J*4,N=v+1076*s+812+J*4,Q=J*3+-2;j=J*-1;var S=j+-1,P=J+1,G=IHEAP[h+16];i=IHEAP[h+20]+124*J;IHEAP[i]=IHEAP[h]+-1+(1<<G+S)>>G+S;IHEAP[i+4]=IHEAP[h+4]+-1+(1<<G+S)>>G+S;IHEAP[i+8]=IHEAP[h+8]+-1+
(1<<G+S)>>G+S;IHEAP[i+12]=IHEAP[h+12]+-1+(1<<G+S)>>G+S;IHEAP[i+24]=J==0?1:3;if((IHEAP[y]&1)!=0){var F=IHEAP[N],L=IHEAP[E];d=4}else d=3;var K=d==4?L:15,H=d==4?F:15;N=IHEAP[i]>>H<<H;E=IHEAP[i+4]>>K<<K;var M=IHEAP[i+8]+-1+(1<<H)>>H<<H,I=IHEAP[i+12]+-1+(1<<K)>>K<<K;if(IHEAP[i]==IHEAP[i+8])d=42;else{var O=M-N>>H;d=6}IHEAP[i+16]=d==6?O:0;if(IHEAP[i+4]==IHEAP[i+12])d=43;else{var R=I-E>>K;d=8}IHEAP[i+20]=d==8?R:0;if(J==0)d=10;else{var T=N+-1+2>>1,V=E+-1+2>>1,ba=H-1,fa=K-1;d=12}var ca=d==12?fa:K;E=d==12?V:
E;var U=d==12?ba:H;N=d==12?T:N;H=IHEAP[x];H=H<U?H:U;K=IHEAP[w];K=K<ca?K:ca;if(0<IHEAP[i+24]){I=J==0;M=J==0;var $=1<<U,Y=1<<ca;U=1<<U;ca=1<<ca;var Z=1<<H,W=1<<K,X=1<<H,aa=1<<K,ka=G+S,ga=1<<ka,ja=1<<ka;ka=1<<ka;var ia=1<<G+S;S=G+S;G=G+j;d=13;c:for(;;){var ea=d==13?0:Ba;k=Q+ea;var oa=ea+1;j=i+28+ea*32;IHEAP[j+16]=I?0:oa;if(IHEAP[j+16]==1)d=14;else{var pa=IHEAP[j+16]==3;d=15}var da=(d==14?1:pa)?1:0;if(IHEAP[j+16]==2)d=40;else{var ha=IHEAP[j+16]==3;d=17}var qa=(d==40?1:ha)?1:0;d=IHEAP[h];if(IHEAP[j+16]==
0){IHEAP[j]=d+-1+(1<<S)>>S;IHEAP[j+4]=IHEAP[h+4]+-1+(1<<S)>>S;IHEAP[j+8]=IHEAP[h+8]+-1+(1<<S)>>S;IHEAP[j+12]=IHEAP[h+12]+-1+(1<<S)>>S}else{IHEAP[j]=d-da*ga+-1+(1<<G)>>G;IHEAP[j+4]=IHEAP[h+4]-ja*qa+-1+(1<<G)>>G;IHEAP[j+8]=IHEAP[h+8]-ka*da+-1+(1<<G)>>G;IHEAP[j+12]=IHEAP[h+12]-ia*qa+-1+(1<<G)>>G}k=M?0:k;da=IHEAP[B]==0;qa=IHEAP[j+16];d:do if(da)d=41;else{if(qa==0){d=22;break d}if(qa==1){d=24;break d}else if(qa==2){d=24;break d}d=25}while(0);da=1+IHEAP[C+4*k*2]/2048;qa=_ldexp(1,(d==41?0:d==25?2:d==22?
0:d==24?1:1)+IHEAP[IHEAP[f]+48*s+24]-IHEAP[z+8*k]);FHEAP[j+28]=da*qa*0.5;IHEAP[j+24]=IHEAP[A+8*k]+-1+IHEAP[D];k=_malloc(IHEAP[i+16]*36*IHEAP[i+20]);IHEAP[j+20]=k;if(0<IHEAP[i+20]*IHEAP[i+16]){d=23;a=27}else{d=23;a=28}d:for(;;)if(a==27){da=d==30?ya:0;qa=da+1;a=$*(da%IHEAP[i+16])+N;var wa=Y*(da/IHEAP[i+16]|0)+E,la=U+a;d=ca+wa;k=IHEAP[j+20]+36*da;var ma=IHEAP[j];IHEAP[k]=a>ma?a:ma;a=IHEAP[j+4];IHEAP[k+4]=wa>a?wa:a;wa=IHEAP[j+8];IHEAP[k+8]=la<wa?la:wa;la=IHEAP[j+12];IHEAP[k+12]=d<la?d:la;la=IHEAP[k]>>
H<<H;wa=IHEAP[k+4]>>K<<K;d=IHEAP[k+12]+-1+(1<<K)>>K<<K;IHEAP[k+16]=(IHEAP[k+8]+-1+(1<<H)>>H<<H)-la>>H;IHEAP[k+20]=d-wa>>K;d=_malloc(IHEAP[k+16]*44*IHEAP[k+20]);IHEAP[k+24]=d;d=_tgt_create(IHEAP[k+16],IHEAP[k+20]);IHEAP[k+28]=d;d=_tgt_create(IHEAP[k+16],IHEAP[k+20]);IHEAP[k+32]=d;if(0<IHEAP[k+20]*IHEAP[k+16]){d=27;a=29}else{d=27;a=30}for(;;)if(a==29){na=d==29?na:0;d=na+1;var ua=Z*(na%IHEAP[k+16])+la,ra=W*(na/IHEAP[k+16]|0)+wa,ta=X+ua;a=aa+ra;ma=IHEAP[k+24];IHEAP[ma+44*na]=0;IHEAP[ma+44*na+4]=0;var va=
IHEAP[k];IHEAP[ma+44*na+8]=ua>va?ua:va;ua=IHEAP[k+4];IHEAP[ma+44*na+12]=ra>ua?ra:ua;ra=IHEAP[k+8];IHEAP[ma+44*na+16]=ta<ra?ta:ra;ta=IHEAP[k+12];IHEAP[ma+44*na+20]=a<ta?a:ta;IHEAP[ma+44*na+40]=0;IHEAP[ma+44*na+24]=0;var na=na+1;if(d<IHEAP[k+20]*IHEAP[k+16])a=d=29;else{d=31;a=30}}else if(a==30){var ya=da+1;if(qa<IHEAP[i+20]*IHEAP[i+16]){d=30;a=27;continue d}else break}d=32;a=28}else if(a==28){var Ba=ea+1;if(oa<IHEAP[i+24]){d=28;continue c}else break c}}}i=J+1;if(P<IHEAP[h+16])d=35;else break b}}h=u+
1;if(t<IHEAP[q])d=38;else break a}}}_tcd_malloc_decode_tile.__index__=Runtime.getFunctionIndex(_tcd_malloc_decode_tile,"_tcd_malloc_decode_tile");
function _tcd_makelayer_fixed(b,f,e){var c=STACKTOP;STACKTOP+=1200;_memset(c,0,1200);var a,d=null,g,h,i;g=IHEAP[b+32];h=IHEAP[b+36];i=IHEAP[b+40];if(0<IHEAP[h+16]){var j=h+20,k=i+12;g=g+112;var m=b+28;i=i+12;b=b+28;var l=f==0,n=f==0;e=e!=0;h=h+16;var o=f+-1,p=f+-1,r=f+-1;d=0;a:for(;;){W=d==0?0:W;var q=0+W,u=1+W,s=IHEAP[j];if(0<IHEAP[k]){d=IHEAP[i];var t=0<IHEAP[s+32*q+16],v=d>1?d:1,y=s+32*q+16;d=2;b:for(;;){D=d==2?0:D;if(t){d=IHEAP[y];var x=d>1?d:1;for(d=4;;){B=d==4?0:B;d=c+D*120+B*12+4;var w=c+D*
120+B*12+8,C=IHEAP[g],z=IHEAP[IHEAP[IHEAP[m]+24]+48*q+24]/16,A=(B+D*IHEAP[y])*3;IHEAP[c+D*120+B*12]=IHEAP[C+4*(A+0)]*z|0;IHEAP[d]=IHEAP[C+4*(A+1)]*z|0;IHEAP[w]=IHEAP[C+4*(A+2)]*z|0;var B=B+1;if(B!=x)d=5;else break}}var D=D+1;if(D!=v)d=8;else break b}}if(0<IHEAP[s+32*q+16]){t=s+32*q+16;s=s+32*q+20;d=11;b:for(;;){Z=d==11?0:Z;v=Z+1;y=IHEAP[s];if(0<IHEAP[y+124*Z+24]){x=y+124*Z+24;w=y+124*Z+16;C=y+124*Z+20;d=13;c:for(;;){z=d==13?0:Y;A=c+r*120+Z*12+z*4;var J=c+p*120+Z*12+z*4,E=c+o*120+Z*12+z*4,N=c+f*120+
Z*12+z*4,Q=y+124*Z+28+z*32+20,S=z+1;if(0<IHEAP[C]*IHEAP[w]){d=14;a=15}else{d=14;a=16}d:for(;;)if(a==15){$=d==36?$:0;a=$+1;d=IHEAP[Q];if(0<IHEAP[d+36*$+20]*IHEAP[d+36*$+16]){var P=IHEAP[N],G=d+36*$+16,F=d+36*$+20,L=d+36*$+24;d=17;e:for(;;){U=d==17?0:U;var K=U+1,H=IHEAP[L],M=IHEAP[H+48*U+4]+20*f,I=IHEAP[IHEAP[IHEAP[b]+24]+48*q+24]-IHEAP[H+48*U+28];f:do if(l){var O=P-I;O=I>=P?0:O;d=19}else{var R=P-IHEAP[E];if(!(I>=IHEAP[J])){d=21;break f}var T=0-(0-IHEAP[A])+(0-I)+R;if(!(T<0)){d=22;break f}d=24}while(0);
d=d==21?R:d==24?0:d==22?T:O;if(n)IHEAP[H+48*U+40]=0;if(IHEAP[H+48*U+40]==0)if(d!=0){var V=d*3+-2+IHEAP[H+48*U+40];d=26}else{var ba=IHEAP[H+48*U+40];d=28}else{var fa=IHEAP[H+48*U+40]+d*3;d=29}d=d==26?V:d==28?ba:fa;IHEAP[M]=d-IHEAP[H+48*U+40];I=IHEAP[M]!=0;f:do if(I){var ca=IHEAP[IHEAP[H+48*U+8]+20*(d-1)];if(IHEAP[H+48*U+40]==0){IHEAP[M+4]=ca;IHEAP[M+16]=IHEAP[H+48*U]}else{IHEAP[M+4]=ca-IHEAP[IHEAP[H+48*U+8]+20*(IHEAP[H+48*U+40]-1)];IHEAP[M+16]=IHEAP[H+48*U]+IHEAP[IHEAP[H+48*U+8]+20*(IHEAP[H+48*U+40]-
1)]}if(!e)break f;IHEAP[H+48*U+40]=d}while(0);var U=U+1;if(K<IHEAP[F]*IHEAP[G])d=32;else break e}}var $=$+1;if(a<IHEAP[C]*IHEAP[w]){d=36;a=15;continue d}d=37;a=16}else if(a==16){var Y=z+1;if(S<IHEAP[x]){d=16;continue c}else break c}}}var Z=Z+1;if(v<IHEAP[t])d=40;else break b}}var W=W+1;if(u<IHEAP[h])d=43;else break a}}STACKTOP=c}_tcd_makelayer_fixed.__index__=Runtime.getFunctionIndex(_tcd_makelayer_fixed,"_tcd_makelayer_fixed");
function _tcd_rateallocate_fixed(b){var f=null;if(0<IHEAP[IHEAP[b+40]+12]){var e=b+40;for(f=0;;){c=f==0?0:c;f=1+c;_tcd_makelayer_fixed(b,0+c,1);var c=c+1;if(f<IHEAP[IHEAP[e]+12])f=1;else break}}}_tcd_rateallocate_fixed.__index__=Runtime.getFunctionIndex(_tcd_rateallocate_fixed,"_tcd_rateallocate_fixed");
function _tcd_makelayer(b,f,e,c){var a,d=null,g,h;g=IHEAP[b+36];FHEAP[g+36+f*8]=0;if(0<IHEAP[g+16]){b=g+20;var i=f==0,j=g+36+f*8;c=c!=0;g=g+16;d=0;a:for(;;){fa=d==0?0:fa;var k=0+fa,m=1+fa,l=IHEAP[b];if(0<IHEAP[l+32*k+16]){var n=l+32*k+16;k=l+32*k+20;d=2;b:for(;;){ba=d==2?0:ba;l=ba+1;var o=IHEAP[k];if(0<IHEAP[o+124*ba+24]){var p=o+124*ba+24,r=o+124*ba+16,q=o+124*ba+20;d=4;c:for(;;){var u=d==4?0:V,s=o+124*ba+28+u*32+20,t=u+1;if(0<IHEAP[q]*IHEAP[r]){d=5;a=6}else{d=5;a=7}d:for(;;)if(a==6){T=d==30?T:0;
a=T+1;d=IHEAP[s];if(0<IHEAP[d+36*T+20]*IHEAP[d+36*T+16]){var v=d+36*T+16,y=d+36*T+20,x=d+36*T+24;d=8;e:for(;;){var w=d==8?0:h,C=w+1;h=IHEAP[x]+48*w;var z=IHEAP[h+4]+20*f;if(i)IHEAP[h+40]=0;var A=IHEAP[h+40],B=IHEAP[h+40];if(B<IHEAP[h+44]){var D=IHEAP[h+8];d=IHEAP[h+44];var J=h+8,E=h+8,N=B+1,Q=(d>N?d:N)-B;d=11;f:for(;;){R=d==11?0:R;I=d==11?A:I;O=d==11?B:O;var S=B+R;d=D+20*S+4;var P=N+R,G=IHEAP[D+20*S];if(I==0){var F=FHEAP[d];d=13}else{var L=G-IHEAP[IHEAP[J]+20*(I-1)],K=FHEAP[d]-FHEAP[IHEAP[E]+20*(I-
1)+4];d=15}S=d==15?K:F;G=d==15?L:G;var H=G!=0;g:do if(H){if(!(S/G>=e)){d=20;break g}var M=O+1;d=21}else{if(S==0){d=16;break g}d=17}while(0);var I=d==20?I:d==21?M:d==16?I:P,O=O+1,R=R+1;if(R!=Q)d=18;else break f}d=22}else d=40;d=d==22?I:A;IHEAP[z]=d-IHEAP[h+40];A=IHEAP[z]!=0;f:do if(A){B=IHEAP[IHEAP[h+8]+20*(d-1)];if(IHEAP[h+40]==0){IHEAP[z+4]=B;IHEAP[z+16]=IHEAP[h];FHEAP[z+8]=FHEAP[IHEAP[h+8]+20*(d-1)+4]}else{IHEAP[z+4]=B-IHEAP[IHEAP[h+8]+20*(IHEAP[h+40]-1)];IHEAP[z+16]=IHEAP[h]+IHEAP[IHEAP[h+8]+20*
(IHEAP[h+40]-1)];FHEAP[z+8]=FHEAP[IHEAP[h+8]+20*(d-1)+4]-FHEAP[IHEAP[h+8]+20*(IHEAP[h+40]-1)+4]}FHEAP[j]+=FHEAP[z+8];if(!c)break f;IHEAP[h+40]=d}else FHEAP[z+8]=0;while(0);h=w+1;if(C<IHEAP[y]*IHEAP[v])d=27;else break e}}var T=T+1;if(a<IHEAP[q]*IHEAP[r]){d=30;a=6;continue d}d=31;a=7}else if(a==7){var V=u+1;if(t<IHEAP[p]){d=7;continue c}else break c}}}var ba=ba+1;if(l<IHEAP[n])d=34;else break b}}var fa=fa+1;if(m<IHEAP[g])d=37;else break a}}}
_tcd_makelayer.__index__=Runtime.getFunctionIndex(_tcd_makelayer,"_tcd_makelayer");
function _tcd_rateallocate(b,f,e,c){var a=STACKTOP;STACKTOP+=800;_memset(a,0,800);var d,g=null,h,i,j,k,m,l;j=0;k=IHEAP[b+32];m=IHEAP[b+36];l=IHEAP[b+40];g=1.7976931348623157E308;i=0;IHEAP[m+24]=0;if(0<IHEAP[m+16]){h=m+20;var n=m+24,o=m+16;i=i;var p=g;j=j;g=0;a:for(;;){qa=g==0?0:qa;ha=g==0?j:ha;pa=g==0?p:pa;da=g==0?i:da;var r=0+qa,q=1+qa,u=IHEAP[h];IHEAP[u+32*r+28]=0;if(0<IHEAP[u+32*r+16]){var s=u+32*r+16,t=u+32*r+20,v=u+32*r+28;g=2;b:for(;;){oa=g==2?0:oa;var y=g==2?pa:d;ea=g==2?da:ea;var x=oa+1,w=
IHEAP[t];if(0<IHEAP[w+124*oa+24]){var C=w+124*oa+24,z=w+124*oa+16,A=w+124*oa+20;g=4;c:for(;;){var B=g==4?0:ia,D=g==4?y:ga,J=g==4?ea:ja,E=w+124*oa+28+B*32+20,N=B+1;if(0<IHEAP[A]*IHEAP[z]){g=5;d=6}else{g=5;d=7}d:for(;;)if(d==6){ka=g==24?ka:0;X=g==24?X:D;aa=g==24?aa:J;d=ka+1;g=IHEAP[E];if(0<IHEAP[g+36*ka+20]*IHEAP[g+36*ka+16]){var Q=g+36*ka+16,S=g+36*ka+20,P=g+36*ka+24;g=8;e:for(;;){W=g==8?0:W;Y=g==8?X:Y;Z=g==8?aa:Z;var G=W+1,F=IHEAP[P];if(0<IHEAP[F+48*W+44]){var L=IHEAP[F+48*W+8];g=IHEAP[F+48*W+44];
var K=g>1?g:1,H=F+48*W+8;g=10;f:for(;;){ca=g==10?Y:ca;U=g==10?Z:U;$=g==10?0:$;g=L+20*$+4;var M=$+-1,I=IHEAP[L+20*$];if($==0){var O=FHEAP[g];g=12}else{var R=I-IHEAP[IHEAP[H]+20*M],T=FHEAP[g]-FHEAP[IHEAP[H]+20*$+-16];g=14}M=g==14?T:O;I=g==14?R:I;var V=I==0;g:do if(V)g=71;else{var ba=M/I,fa=ba<ca?ba:ca;if(!(ba>U)){g=15;break g}g=16}while(0);var ca=g==15?fa:g==16?fa:ca,U=g==15?U:g==16?ba:U,$=$+1;if($!=K)g=17;else break f}g=19}else g=9;var Y=g==19?ca:Y,Z=g==19?U:Z;IHEAP[n]+=(IHEAP[F+48*W+24]-IHEAP[F+48*
W+16])*(IHEAP[F+48*W+20]-IHEAP[F+48*W+12]);IHEAP[v]+=(IHEAP[F+48*W+24]-IHEAP[F+48*W+16])*(IHEAP[F+48*W+20]-IHEAP[F+48*W+12]);var W=W+1;if(G<IHEAP[S]*IHEAP[Q])g=21;else break e}g=22}else g=6;var X=g==22?Y:X,aa=g==22?Z:aa,ka=ka+1;if(d<IHEAP[A]*IHEAP[z]){g=24;d=6;continue d}g=25;d=7}else if(d==7){var ga=g==25?X:D,ja=g==25?aa:J,ia=B+1;if(N<IHEAP[C]){g=7;continue c}else break c}}g=26}else g=3;d=g==26?ga:y;var ea=g==26?ja:ea,oa=oa+1;if(x<IHEAP[s])g=28;else break b}g=29}else g=1;var pa=g==29?d:pa,da=g==
29?ea:da,ha=ha+((1<<IHEAP[IHEAP[IHEAP[b+28]+24]+48*r+24])-1)*((1<<IHEAP[IHEAP[IHEAP[b+28]+24]+48*r+24])-1)*IHEAP[u+32*r+28],qa=qa+1;if(q<IHEAP[o])g=31;else break a}j=ha;g=pa;i=da}if(c!=0){h=IHEAP[c+88]+572*IHEAP[b+44];IHEAP[h+552]=IHEAP[m+24];FHEAP[h+556]=FHEAP[m+28];n=_malloc(IHEAP[l+12]*8);IHEAP[h]=n}h=0;n=l+12;o=g;O=i;R=l+20;T=l+20;ba=m+28;fa=1*j;ga=l+5184;ja=k+24;ia=l+20;i=k+32;p=m+36;j=m+36;q=m+36;qa=m+36;ha=c!=0;r=c+88;u=m+36;pa=m+36;da=k+32;l=l+5184;s=g;a:for(;;){if(!(h<IHEAP[n]))break a;if(FHEAP[R+
h*4]!=0){var wa=_ceilf(FHEAP[T+h*4])|0;wa=wa<e?wa:e;g=38}else g=36;t=g==38?wa:e;d=FHEAP[ba];v=_llvm_pow_f64(10,FHEAP[ga+h*4]/10);v=d-fa/v;x=IHEAP[ja]==1;b:do if(x){d=FHEAP[ia+h*4]>0?40:41;break b}else d=41;while(0);b:do if(d==41){if(IHEAP[da]!=1){g=41;d=43;break b}if(FHEAP[l+h*4]>0){g=42;d=40}else{g=42;d=43}break b}while(0);b:do if(d==40){g=IHEAP[b+20];x=IHEAP[b+28];var la=_malloc(12);if(la!=0){IHEAP[la]=g;IHEAP[la+4]=x;IHEAP[la+8]=k;g=44}else g=40;x=g==44?la:0;g=46;c:for(;;){na=g==46?0:na;Na=g==
46?0:Na;ya=g==46?O:ya;Ba=g==46?o:Ba;var ma=(Ba+ya)/2;_tcd_makelayer(b,h,ma,0);la=IHEAP[i]!=0;d:do if(la)if(IHEAP[k]!=0){if(_t2_encode_packets(x,IHEAP[b+44],m,h+1,f,t,c,IHEAP[b+8],IHEAP[b],IHEAP[b+16],0,IHEAP[b+12])==-999){g=48;break d}if(h==0){var ua=FHEAP[p];g=51}else{var ra=FHEAP[a+(h-1)*8]+FHEAP[j+h*8];g=53}if((g==51?ua:ra)<v){g=54;break d}g=55}else{if(h==0){var ta=FHEAP[q];g=57}else{var va=FHEAP[a+(h-1)*8]+FHEAP[qa+h*8];g=59}if((g==57?ta:va)<v){g=60;break d}g=61}else{if(_t2_encode_packets(x,IHEAP[b+
44],m,h+1,f,t,c,IHEAP[b+8],IHEAP[b],IHEAP[b+16],0,IHEAP[b+12])==-999){g=62;break d}g=63}while(0);var na=g==63?ma:g==55?na:g==61?na:g==48?na:g==54?ma:g==60?ma:na,ya=g==63?ma:g==55?ya:g==61?ya:g==48?ya:g==54?ma:g==60?ma:ya,Ba=g==63?Ba:g==55?ma:g==61?ma:g==48?ma:g==54?Ba:g==60?Ba:ma,Na=Na+1;if(Na!=128){g=49;d=47}else{d=64;break c}}la=na==0?ma:na;if(x==0){g=64;break b}_free(x);g=65}while(0);g=g==41?s:g==42?s:g==65?la:la;if(ha)FHEAP[IHEAP[IHEAP[r]+572*IHEAP[b+44]]+8*h]=g;_tcd_makelayer(b,h,g,1);if(h==
0){var Pa=FHEAP[u];g=68}else{var Ja=FHEAP[a+(h-1)*8]+FHEAP[pa+h*8];g=70}FHEAP[a+h*8]=g==68?Pa:Ja;h+=1}STACKTOP=a;return 1}_tcd_rateallocate.__index__=Runtime.getFunctionIndex(_tcd_rateallocate,"_tcd_rateallocate");
function _tcd_encode_tile(b,f,e,c,a){var d=STACKTOP;STACKTOP+=16;_memset(d,0,16);var g,h=null,i,j,k,m,l,n,o=d+8,p,r,q,u,s,t,v,y,x,w;r=0;k=IHEAP[IHEAP[IHEAP[b+32]+108]+5584];s=IHEAP[b+28];IHEAP[b+44]=f;IHEAP[b+36]=IHEAP[IHEAP[b+24]+8];IHEAP[b+40]=IHEAP[IHEAP[b+32]+108]+5588*f;q=IHEAP[b+36];u=IHEAP[b+40];i=IHEAP[b+32];var C=IHEAP[b+8]==0;a:do if(C){_gettimeofday(o,0);p=IHEAP[o]+IHEAP[o+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=p;g=p-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=p;FHEAP[b+
48]=g;if(a!=0){h=IHEAP[q+20];if(0<IHEAP[h+16]){p=h+20;g=f;n=a+88;l=f;t=a+88;v=k;m=f;y=a+88;var z=k,A=f,B=a+88;x=h+16;r=r;for(h=1;;){Q=h==1?0:Q;N=h==1?r:N;h=1+Q;w=0+Q;var D=z+944+w*4,J=v+812+w*4,E=IHEAP[p];IHEAP[IHEAP[n]+572*g+20+w*4]=IHEAP[E+124*w+16];IHEAP[IHEAP[t]+572*l+152+w*4]=IHEAP[E+124*w+20];var N=N+IHEAP[E+124*w+20]*IHEAP[E+124*w+16];IHEAP[IHEAP[y]+572*m+284+w*4]=IHEAP[J];IHEAP[IHEAP[B]+572*A+416+w*4]=IHEAP[D];var Q=Q+1;if(h<IHEAP[x])h=2;else break}r=N}p=_calloc(IHEAP[a+56]*IHEAP[a+52]*r,
20);IHEAP[IHEAP[a+88]+572*f+548]=p}p=0;g=p<IHEAP[q+16]?6:7;b:for(;;)if(g==6){if(IHEAP[IHEAP[s+24]+48*p+32]!=0)h=6;else{var S=1<<IHEAP[IHEAP[s+24]+48*p+24]-1;h=8}g=h==8?S:0;n=IHEAP[IHEAP[s+24]+48*p];h=IHEAP[s];n=n;n=(h+-1+n)/n|0;l=IHEAP[IHEAP[s+24]+48*p+4];h=IHEAP[s+4];l=l;l=(h+-1+l)/l|0;t=IHEAP[q+20]+32*p;v=IHEAP[t+8]-IHEAP[t];m=IHEAP[IHEAP[s+24]+48*p];h=IHEAP[s+8]-IHEAP[s];m=m;y=(h+-1+m)/m|0;z=IHEAP[IHEAP[u+5584]+1076*p+20]==1;c:do if(z){m=IHEAP[t+4];if(!(m<IHEAP[t+12]))break c;for(;;){x=IHEAP[IHEAP[s+
24]+48*p+44]+4*(0-n+IHEAP[t]+(m-l)*y);w=IHEAP[t+24]+4*(m-IHEAP[t+4])*v;h=IHEAP[t];if(h<IHEAP[t+8]){A=g;B=t+8;x=x;w=w;D=h+1;for(h=12;;){P=h==12?0:P;h=D+P;IHEAP[w+4*P]=IHEAP[x+4*P]-A;var P=P+1;if(h<IHEAP[B])h=13;else break}}m+=1;if(!(m<IHEAP[t+12]))break c}}else{if(IHEAP[IHEAP[u+5584]+1076*p+20]!=0)break c;m=IHEAP[t+4];if(!(m<IHEAP[t+12]))break c;for(;;){x=IHEAP[IHEAP[s+24]+48*p+44]+4*(0-n+IHEAP[t]+(m-l)*y);w=IHEAP[t+24]+4*(m-IHEAP[t+4])*v;h=IHEAP[t];if(h<IHEAP[t+8]){A=g;B=t+8;x=x;w=w;D=h+1;for(h=18;;){G=
h==18?0:G;h=D+G;IHEAP[w+4*G]=IHEAP[x+4*G]-A<<11;var G=G+1;if(h<IHEAP[B])h=19;else break}}m+=1;if(!(m<IHEAP[t+12]))break c}}while(0);p+=1;g=p<IHEAP[q+16]?6:7}else if(g==7){g=IHEAP[u+16]!=0?22:23;break b}if(g==22){n=(IHEAP[IHEAP[q+20]+12]-IHEAP[IHEAP[q+20]+4])*(IHEAP[IHEAP[q+20]+8]-IHEAP[IHEAP[q+20]]);p=IHEAP[IHEAP[q+20]+24];g=IHEAP[IHEAP[q+20]+32+24];h=IHEAP[IHEAP[q+20]+64+24];n=n;IHEAP[IHEAP[u+5584]+20]==0?_mct_encode_real(p,g,h,n):_mct_encode(p,g,h,n)}p=0;if(p<IHEAP[q+16]){g=q+20;h=u+5584;n=q+16;
l=u+5584;b:for(;;){t=IHEAP[g]+32*p;v=IHEAP[IHEAP[h]+1076*p+20]==1;c:do if(v)_dwt_encode(t);else{if(IHEAP[IHEAP[l]+1076*p+20]!=0)break c;_dwt_encode_real(t)}while(0);p+=1;if(!(p<IHEAP[n]))break b}}p=_t1_create(IHEAP[b+20]);_t1_encode_cblks(p,q,u);_t1_destroy(p);if(a!=0)IHEAP[a+12]=0;p=IHEAP[i+24]!=0;b:do if(!p){if(IHEAP[i+32]!=0)break b;k=b;if(!(0<IHEAP[IHEAP[k+40]+12]))break a;o=k;k=k+40;for(h=35;;){j=h==35?0:j;C=1+j;_tcd_makelayer_fixed(o,0+j,1);j=j+1;if(C<IHEAP[IHEAP[k]+12])h=37;else break}break a}while(0);
_tcd_rateallocate(b,e,c,a)}while(0);if(a!=0)IHEAP[a+12]=1;j=IHEAP[b+20];o=_malloc(12);if(o!=0){IHEAP[o]=j;IHEAP[o+4]=s;IHEAP[o+8]=i;i=o}else i=0;i=i;f=_t2_encode_packets(i,f,q,IHEAP[u+12],e,c,a,IHEAP[b+4],IHEAP[b],IHEAP[b+16],1,IHEAP[b+12]);i!=0&&_free(i);e=IHEAP[b+8]==IHEAP[b+12]-1;a:do if(e){_gettimeofday(d,0);c=IHEAP[d]+IHEAP[d+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=c;a=c-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=c;FHEAP[b+48]=a-FHEAP[b+48];_opj_event_msg(IHEAP[b+20],4,__str18110,
Pointer_make([FHEAP[b+48],0,0,0,0,0,0,0],0,ALLOC_STACK));p=0;if(!(p<IHEAP[q+16]))break a;c=q+20;for(a=q+16;;){_free(IHEAP[IHEAP[c]+32*p+24]);p+=1;if(!(p<IHEAP[a]))break}}while(0);STACKTOP=d;return f}_tcd_encode_tile.__index__=Runtime.getFunctionIndex(_tcd_encode_tile,"_tcd_encode_tile");
function _tcd_decode_tile(b,f,e,c,a){var d=STACKTOP;STACKTOP+=48;_memset(d,0,48);var g,h=null,i,j,k=d+8,m,l=d+16,n=d+24;m=d+32;var o=d+40,p,r,q;r=0;IHEAP[b+44]=c;IHEAP[b+36]=IHEAP[IHEAP[b+24]+8]+840*c;IHEAP[b+40]=IHEAP[IHEAP[b+32]+108]+5588*c;j=IHEAP[b+36];_gettimeofday(o,0);o=IHEAP[o]+IHEAP[o+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=o;h=o-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=o;o=h;_opj_event_msg(IHEAP[b+20],4,__str19111,Pointer_make([c+1,0,0,0,IHEAP[IHEAP[b+32]+72]*IHEAP[IHEAP[b+
32]+68],0,0,0],0,ALLOC_STACK));if(a!=0){h=0;if(0<IHEAP[a+52]){var u=a+88,s=a+88,t=a+88,v=a+88,y=a+88,x=a+88,w=a+52,C=h;h=1;a:for(;;){F=h==1?0:F;G=h==1?C:G;var z=0+F;g=1+F;var A=IHEAP[IHEAP[IHEAP[b+32]+108]+5584];h=IHEAP[j+20];if(0<IHEAP[h+32*z+16]){var B=A+1076*z,D=h+32*z+16,J=h+32*z+20;for(h=3;;){S=h==3?G:S;P=h==3?0:P;var E=A+1076*z+944+P*4,N=A+1076*z+812+P*4;h=P+1;var Q=IHEAP[J];IHEAP[IHEAP[u]+572*c+20+P*4]=IHEAP[Q+124*P+16];IHEAP[IHEAP[s]+572*c+152+P*4]=IHEAP[Q+124*P+20];var S=S+IHEAP[Q+124*P+
20]*IHEAP[Q+124*P+16];if((IHEAP[B]&1)!=0){IHEAP[IHEAP[t]+572*c+284+P*4]=IHEAP[N];IHEAP[IHEAP[v]+572*c+416+P*4]=IHEAP[E]}else{IHEAP[IHEAP[y]+572*c+284+P*4]=15;IHEAP[IHEAP[x]+572*c+284+P*4]=15}var P=P+1;if(h<IHEAP[D])h=6;else break}h=7}else h=2;var G=h==7?S:G,F=F+1;if(g<IHEAP[w]){h=9;g=2}else{g=10;break a}}h=G}h=_malloc(IHEAP[a+56]*20*h);IHEAP[IHEAP[a+88]+572*c+548]=h;IHEAP[a+8]=0}S=IHEAP[b+28];u=IHEAP[b+32];h=IHEAP[b+20];s=_malloc(12);if(s!=0){IHEAP[s]=h;IHEAP[s+4]=S;IHEAP[s+8]=u;h=s}else h=0;h=h;
f=_t2_decode_packets(h,f,e,c,j,a);if(h!=0){_free(h);q=f;h=14}else h=76;if((h==76?f:q)==-999){r=1;_opj_event_msg(IHEAP[b+20],1,__str20112)}_gettimeofday(m,0);h=IHEAP[m]+IHEAP[m+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=h;m=h-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=h;h=m;q=_t1_create(IHEAP[b+20]);m=0;if(m<IHEAP[j+16])for(;;){f=IHEAP[j+20]+32*m;e=_memalign(16,((IHEAP[f+12]-IHEAP[f+4])*(IHEAP[f+8]-IHEAP[f])+3)*4);IHEAP[f+24]=e;_t1_decode_cblks(q,f,IHEAP[IHEAP[b+40]+5584]+1076*m);
m+=1;if(m<IHEAP[j+16])g=18;else{g=19;break}}_t1_destroy(q);_gettimeofday(n,0);m=IHEAP[n]+IHEAP[n+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=m;n=m-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=m;h=n-h;_opj_event_msg(IHEAP[b+20],4,__str21113,Pointer_make([h,0,0,0,0,0,0,0],0,ALLOC_STACK));_gettimeofday(l,0);h=IHEAP[l]+IHEAP[l+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=h;m=h-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=h;h=m;m=0;a:for(;;){if(!(m<IHEAP[j+16])){g=26;break a}l=
IHEAP[j+20]+32*m;if(IHEAP[IHEAP[b+32]+36]!=0){IHEAP[IHEAP[IHEAP[b+28]+24]+48*m+36]=IHEAP[IHEAP[j+20]+32*m+16]+-1+(0-IHEAP[IHEAP[b+32]+36]);if(IHEAP[IHEAP[IHEAP[b+28]+24]+48*m+36]<0){g=27;break a}}n=IHEAP[IHEAP[IHEAP[b+28]+24]+48*m+36]+1;if(n>0)IHEAP[IHEAP[IHEAP[b+40]+5584]+1076*m+20]==1?_dwt_decode(l,n):_dwt_decode_real(l,n);m+=1;g=24}if(g==26){_gettimeofday(k,0);m=IHEAP[k]+IHEAP[k+4]/1E6;if(FHEAP[_opj_clock_last]<0)FHEAP[_opj_clock_last]=m;k=m-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=m;h=k-
h;_opj_event_msg(IHEAP[b+20],4,__str2366,Pointer_make([h,0,0,0,0,0,0,0],0,ALLOC_STACK));if(IHEAP[IHEAP[b+40]+16]!=0){h=(IHEAP[IHEAP[j+20]+12]-IHEAP[IHEAP[j+20]+4])*(IHEAP[IHEAP[j+20]+8]-IHEAP[IHEAP[j+20]]);m=IHEAP[IHEAP[j+20]+24];IHEAP[IHEAP[IHEAP[b+40]+5584]+20]==1?_mct_decode(m,IHEAP[IHEAP[j+20]+32+24],IHEAP[IHEAP[j+20]+64+24],h):_mct_decode_real(m,IHEAP[IHEAP[j+20]+32+24],IHEAP[IHEAP[j+20]+64+24],h)}m=0;g=m<IHEAP[j+16]?34:35;a:for(;;)if(g==34){k=IHEAP[j+20]+32*m;p=IHEAP[IHEAP[b+28]+24]+48*m;l=
IHEAP[k+20]+124*IHEAP[p+36];if(IHEAP[p+32]!=0)h=34;else{var L=1<<IHEAP[p+24]-1;h=36}n=h==36?L:0;if(IHEAP[p+32]!=0){var K=0-(1<<IHEAP[p+24]-1);h=38}else h=107;q=h==38?K:0;h=IHEAP[p+24];if(IHEAP[p+32]!=0){var H=(1<<h-1)-1;h=40}else{var M=(1<<h)-1;h=42}f=h==40?H:M;e=IHEAP[k+8];c=IHEAP[k];a=IHEAP[p+8];h=IHEAP[p+40];g=IHEAP[p+16]+-1+(1<<h)>>h;h=IHEAP[p+40];S=IHEAP[p+20]+-1+(1<<h)>>h;if(IHEAP[p+44]==0){h=_malloc(IHEAP[p+8]*4*IHEAP[p+12]);IHEAP[p+44]=h}u=IHEAP[IHEAP[IHEAP[b+40]+5584]+1076*m+20]==1;s=IHEAP[l+
4];t=s<IHEAP[l+12];b:do if(u){if(!t)break b;v=l;y=l+8;x=l;w=l+4;C=k+24;P=p+44;F=l+8;G=l+12;z=e-c;A=a*(s-S)-g;B=s+1;h=45;c:for(;;){ba=h==45?0:ba;h=A+a*ba;J=s+ba;D=B+ba;E=IHEAP[v];if(E<IHEAP[y]){N=E+1;Q=E+h;h=50;d:for(;;){V=h==50?0:V;var I=Q+V,O=N+V,R=IHEAP[IHEAP[C]+4*(E+V+z*(J-IHEAP[w])-IHEAP[x])]+n,T=R<q;e:do if(T)h=51;else{if(R>f){h=52;break e}h=54}while(0);IHEAP[IHEAP[P]+4*I]=h==54?R:h==51?q:f;var V=V+1;if(O<IHEAP[F])h=53;else break d}}var ba=ba+1;if(D<IHEAP[G])h=58;else break c}}else{if(!t)break b;
v=l;y=l+8;x=l;w=l+4;C=k+24;P=p+44;F=l+8;G=l+12;z=e-c;A=a*(s-S)-g;B=s+1;h=48;c:for(;;){ca=h==48?0:ca;h=A+a*ca;J=s+ca;D=B+ca;E=IHEAP[v];if(E<IHEAP[y]){N=E+1;Q=E+h;h=62;d:for(;;){fa=h==62?0:fa;I=Q+fa;O=N+fa;R=_lrintf(FHEAP[IHEAP[C]+4*(E+fa+z*(J-IHEAP[w])-IHEAP[x])])+n;T=R<q;e:do if(T)h=63;else{if(R>f){h=64;break e}h=66}while(0);IHEAP[IHEAP[P]+4*I]=h==66?R:h==63?q:f;var fa=fa+1;if(O<IHEAP[F])h=65;else break d}}var ca=ca+1;if(D<IHEAP[G])h=70;else break c}}while(0);_free(IHEAP[k+24]);m+=1;if(m<IHEAP[j+
16]){g=34;continue a}g=35}else if(g==35){_gettimeofday(d,0);i=IHEAP[d]+IHEAP[d+4]/1E6;g=FHEAP[_opj_clock_last]<0?73:74;break a}if(g==73)FHEAP[_opj_clock_last]=i;j=i-FHEAP[_opj_clock_last];FHEAP[_opj_clock_last]=i;o=j-o;_opj_event_msg(IHEAP[b+20],4,__str24115,Pointer_make([o,0,0,0,0,0,0,0],0,ALLOC_STACK));p=r!=0?0:1}else if(g==27){_opj_event_msg(IHEAP[b+20],1,__str22114,Pointer_make([IHEAP[IHEAP[b+32]+36],0,0,0,IHEAP[IHEAP[j+20]+32*m+16],0,0,0],0,ALLOC_STACK));p=0}b=p;STACKTOP=d;return b}
_tcd_decode_tile.__index__=Runtime.getFunctionIndex(_tcd_decode_tile,"_tcd_decode_tile");function _tcd_free_decode(b){_free(IHEAP[IHEAP[b+24]+8])}_tcd_free_decode.__index__=Runtime.getFunctionIndex(_tcd_free_decode,"_tcd_free_decode");
function _tcd_free_decode_tile(b,f){var e,c=null,a;a=IHEAP[IHEAP[b+24]+8]+840*f;if(0<IHEAP[a+16]){var d=a+20,g=a+16;c=0;a:for(;;){w=c==0?0:w;var h=0+w,i=1+w,j=IHEAP[d];if(0<IHEAP[j+32*h+16]){var k=j+32*h+16,m=j+32*h+20;c=2;b:for(;;){x=c==2?0:x;var l=x+1,n=IHEAP[m];if(0<IHEAP[n+124*x+24]){var o=n+124*x+24,p=n+124*x+20,r=n+124*x+16;c=4;c:for(;;){var q=c==4?0:y,u=n+124*x+28+q*32+20,s=q+1;if(0<IHEAP[r]*IHEAP[p]){c=5;e=6}else{c=5;e=7}for(;;)if(e==6){v=c==12?v:0;c=v+1;e=IHEAP[u];if(IHEAP[e+36*v+32]!=0){var t=
IHEAP[e+36*v+32];_free(IHEAP[t+12]);_free(t)}if(IHEAP[e+36*v+28]!=0){e=IHEAP[e+36*v+28];_free(IHEAP[e+12]);_free(e)}var v=v+1;if(c<IHEAP[r]*IHEAP[p]){c=12;e=6}else{c=13;e=7}}else if(e==7){_free(IHEAP[u]);var y=q+1;if(s<IHEAP[o]){c=7;continue c}else break c}}}var x=x+1;if(l<IHEAP[k])c=16;else break b}}_free(IHEAP[j+32*h+20]);var w=w+1;if(i<IHEAP[g])c=19;else break a}}_free(IHEAP[a+20])}_tcd_free_decode_tile.__index__=Runtime.getFunctionIndex(_tcd_free_decode_tile,"_tcd_free_decode_tile");
function _tgt_create(b,f){var e=STACKTOP;STACKTOP+=256;_memset(e,0,256);var c,a=null,d,g=e+128,h,i,j,k,m,l,n;k=_malloc(16);if(k!=0){IHEAP[k]=b;IHEAP[k+4]=f;n=0;IHEAP[e]=b;IHEAP[g]=f;IHEAP[k+8]=0;j=k+8;n=n;l=IHEAP[j];var o=n+1;a=1;a:for(;;){c=a==2?c:0;h=a==2?h:l;m=o+c;i=g+m*4;a=n+c;var p=g+a*4,r=e+a*4;a=IHEAP[p]*IHEAP[r];IHEAP[e+m*4]=(IHEAP[r]+1)/2|0;IHEAP[i]=(IHEAP[p]+1)/2|0;h=h+a;c=c+1;if(a>1)a=2;else break a}IHEAP[j]=h;n=m;if(IHEAP[k+8]==0){_free(k);d=0}else{a=_calloc(IHEAP[k+8],16);IHEAP[k+12]=
a;if(IHEAP[k+12]!=0){h=IHEAP[k+12];j=i=IHEAP[k+12]+16*IHEAP[k+4]*IHEAP[k];m=0;c=m<n-1?4:5;a:for(;;)if(c==4){l=0;o=m;if(l<IHEAP[g+m*4]){a=4;c=6}else{a=4;c=7}for(;;)if(c==6){a=IHEAP[e+(a==18?v:o)*4];a=v=a+-1;if(v>=0){v=i;c=h;a=a;h=a+-2;i=a+-1;for(a=8;;){t=a==8?0:t;s=a==8?c:s;var q=t*-2;p=h+q;a=i+q;r=v+16*t;q=v+16*(t+1);IHEAP[s]=r;s=s+16;if(a>=0){IHEAP[s]=r;var u=s+16;a=10}else a=9;var s=a==10?u:s,t=t+1;if(p>=0)a=12;else break}h=s;i=q}a=(l&1)!=0;c:do if(a)c=15;else{if(l==IHEAP[g+m*4]-1){c=15;break c}i=
j;j+=16*IHEAP[e+m*4];c=18;break c}while(0);if(c==15)j=i;l+=1;var v=m;if(l<IHEAP[g+m*4]){a=18;c=6}else{a=18;c=7}}else if(c==7){m=(a==4?o:v)+1;c=m<n-1?4:5;continue a}}else if(c==5){IHEAP[h]=0;d=k;c=0==d?19:20;break a}a:do if(c==20){if(!(0<IHEAP[d+8]))break a;g=d+12;u=d+12;q=d+12;s=d+8;for(a=21;;){y=a==21?0:y;n=0+y;t=1+y;IHEAP[IHEAP[g]+16*n+4]=999;IHEAP[IHEAP[u]+16*n+8]=0;IHEAP[IHEAP[q]+16*n+12]=0;var y=y+1;if(t<IHEAP[s])c=a=22;else{c=23;break}}}while(0);d=k}else{_free(k);d=0}}}else d=0;d=d;STACKTOP=
e;return d}_tgt_create.__index__=Runtime.getFunctionIndex(_tgt_create,"_tgt_create");function _tgt_reset(b){var f=null,e=0==b;a:do if(!e){if(!(0<IHEAP[b+8]))break a;var c=b+12,a=b+12,d=b+12,g=b+8;for(f=0;;){i=f==0?0:i;f=1+i;var h=0+i;IHEAP[IHEAP[c]+16*h+4]=999;IHEAP[IHEAP[a]+16*h+8]=0;IHEAP[IHEAP[d]+16*h+12]=0;var i=i+1;if(f<IHEAP[g])f=2;else break}}while(0)}_tgt_reset.__index__=Runtime.getFunctionIndex(_tgt_reset,"_tgt_reset");function _tgt_destroy(b){_free(IHEAP[b+12]);_free(b)}
_tgt_destroy.__index__=Runtime.getFunctionIndex(_tgt_destroy,"_tgt_destroy");function _tgt_setvalue(b,f,e){var c=null;b=IHEAP[b+12]+16*f;for(c=0;;){f=c==4?a:b;if((c==4?a:b)==0)break;if(!(IHEAP[f+4]>e))break;IHEAP[f+4]=e;var a=IHEAP[f];c=4}}_tgt_setvalue.__index__=Runtime.getFunctionIndex(_tgt_setvalue,"_tgt_setvalue");
function _tgt_encode(b,f,e,c){var a=STACKTOP;STACKTOP+=124;_memset(a,0,124);var d,g=null;g=a;f=IHEAP[f+12]+16*e;if(IHEAP[f]!=0){f=f;e=g;for(g=0;;){d=g==0?0:j;g=g==0?f:i;var h=e+4*(d+1);IHEAP[e+4*d]=g;var i=IHEAP[g],j=d+1;if(IHEAP[i]!=0)d=g=1;else{d=2;break}}g=h;f=i}h=f;i=g;g=4;a:for(;;){p=g==18?p:0;o=g==18?o:h;e=g==18?l:0;g=p*-1;j=i+4*g;f=i+4*(g+-1);g=o+8;if(e>IHEAP[o+8]){IHEAP[g]=e;g=6}else{var k=IHEAP[g];g=8}e=g==8?k:e;var m=o+4;g=9;b:for(;;){d=g==9?0:n;var l=e+d;if(!(l<c)){d=12;break b}if(l>=IHEAP[m]){d=
13;break b}_bio_write(b,0,1);var n=d+1;g=14;d=10}b:do if(d==13){if(IHEAP[o+12]!=0)break b;_bio_write(b,1,1);IHEAP[o+12]=1}while(0);IHEAP[o+8]=l;if(j==a)break a;var o=IHEAP[f],p=p+1;g=18;d=5}STACKTOP=a}_tgt_encode.__index__=Runtime.getFunctionIndex(_tgt_encode,"_tgt_encode");
function _tgt_decode(b,f,e,c){var a=STACKTOP;STACKTOP+=124;_memset(a,0,124);var d=null;d=a;f=IHEAP[f+12]+16*e;if(IHEAP[f]!=0){f=f;e=d;for(d=0;;){i=d==0?0:i;d=d==0?f:h;var g=e+4*(i+1);IHEAP[e+4*i]=d;var h=IHEAP[d],i=i+1;if(IHEAP[h]!=0)d=1;else break}d=g;f=h}g=f;h=d;d=4;a:for(;;){p=d==17?p:0;var j=d==17?o:g;f=d==17?l:0;d=p*-1;o=h+4*d;i=h+4*(d+-1);d=j+8;if(f>IHEAP[j+8]){IHEAP[d]=f;d=6}else{var k=IHEAP[d];d=8}f=d==8?k:f;e=j+4;var m=j+4;for(d=9;;){var l=d==9?f:d==15?n:l;if(!(l<c))break;if(!(l<IHEAP[e]))break;
if(_bio_read(b,1)!=0){IHEAP[m]=l;d=14}else{var n=l+1;d=15}}IHEAP[j+8]=l;if(o==a)break a;var o=IHEAP[i],p=p+1;d=17}f=j;b=IHEAP[f+4]<c?1:0;STACKTOP=a;return b}_tgt_decode.__index__=Runtime.getFunctionIndex(_tgt_decode,"_tgt_decode");
function _write_index_file(b,f){var e,c=null,a,d,g,h,i,j,k,m,l,n;m=0;if(b!=0){a=_fopen(f,__str25116);if(a!=0){l=FHEAP[IHEAP[b+88]+556]!=0?1:0;n=IHEAP[IHEAP[b+88]+552]!=0?1:0;_fprintf(a,__str227,IHEAP[b+16],IHEAP[b+20]);_fprintf(a,__str328,IHEAP[b+24]);_fprintf(a,__str227,IHEAP[b+28],IHEAP[b+32]);_fprintf(a,__str227,IHEAP[b+44],IHEAP[b+48]);_fprintf(a,__str328,IHEAP[b+52]);_fprintf(a,__str328,IHEAP[b+56]);_fprintf(a,__str328,IHEAP[IHEAP[b+60]]);var o=IHEAP[IHEAP[b+60]];i=o;if(o>=0){c=3;e=4}else{c=
3;e=5}a:for(;;)if(e==4){_fprintf(c==4?d:a,__str429,1<<IHEAP[IHEAP[b+88]+284+i*4],1<<IHEAP[IHEAP[b+88]+284+i*4]);i=o=i+-1;d=a;if(o>=0)e=c=4;else{c=4;e=5}}else if(e==5){_fputc(10,c==3?a:d);_fprintf(a,__str328,IHEAP[b+76]);_fprintf(a,__str328,IHEAP[b+80]);_fprintf(a,__str328,IHEAP[b+84]);_fwrite(__str631,15,1,a);_fwrite(__str732,44,1,a);e=l!=0?6:7;break a}e==6&&_fwrite(__str833,14,1,a);n!=0&&_fwrite(__str934,10,1,a);d=l!=0;a:do if(d){if(n==0)break a;_fwrite(__str1035,13,1,a)}while(0);_fputc(10,a);d=
0;o=d<IHEAP[b+48]*IHEAP[b+44];a:do if(o)for(var p=l!=0,r=n!=0,q=l!=0,u=n!=0;;){_fprintf(a,__str1136,IHEAP[IHEAP[b+88]+572*d+4],IHEAP[IHEAP[b+88]+572*d+8],IHEAP[IHEAP[b+88]+572*d+12],IHEAP[IHEAP[b+88]+572*d+16],IHEAP[IHEAP[b+88]+572*d+564]);p&&_fprintf(a,__str1237,FHEAP[IHEAP[b+88]+572*d+556]);r&&_fprintf(a,__str1338,IHEAP[IHEAP[b+88]+572*d+552]);q^1|u^1||_fprintf(a,__str1237,FHEAP[IHEAP[b+88]+572*d+556]/IHEAP[IHEAP[b+88]+572*d+552]);_fputc(10,a);d+=1;if(!(d<IHEAP[b+48]*IHEAP[b+44]))break a}while(0);
d=0;if(d<IHEAP[b+48]*IHEAP[b+44]){n=l!=0;o=l!=0;p=l!=0;r=l!=0;q=l!=0;u=l!=0;var s=l!=0,t=l!=0,v=l!=0,y=l!=0;m=m;c=18;a:for(;;){var x=c==18?m:k;g=k=0;if(g<IHEAP[b+52]){c=19;e=20}else{c=19;e=21}b:for(;;)if(e==20){C=c==24?C:0;if(C<IHEAP[IHEAP[b+60]+4*g]){var w=IHEAP[IHEAP[b+60]+4*g];c=22}else c=20;var C=c==20?C:w;g+=1;if(g<IHEAP[b+52]){c=24;e=20}else{c=24;e=21}}else if(e==21){var z=c==19?0:C;_fprintf(a,__str1439,d);_fwrite(__str1540,70,1,a);if(0<IHEAP[IHEAP[b+88]+572*d+564]){c=21;e=25}else{c=21;e=26}break b}b:for(;;)if(e==
25){A=c==25?A:0;i=A+1;_fprintf(a,__str1641,A,d,IHEAP[IHEAP[IHEAP[b+88]+572*d+568]+20*A+12],IHEAP[IHEAP[IHEAP[b+88]+572*d+568]+20*A+16],IHEAP[IHEAP[IHEAP[b+88]+572*d+568]+20*A],IHEAP[IHEAP[IHEAP[b+88]+572*d+568]+20*A+4],IHEAP[IHEAP[IHEAP[b+88]+572*d+568]+20*A+8]);var A=A+1;if(i<IHEAP[IHEAP[b+88]+572*d+564])e=c=25;else{c=25;e=26}}else if(e==26){e=IHEAP[b+24]==0?27:28;break b}b:do if(e==27){_fwrite(__str1742,74,1,a);n&&_fwrite(__str1843,6,1,a);_fputc(10,a);h=0;if(!(h<IHEAP[b+56])){c=30;break b}var B=
z+1,D=z+1;c=31;c:for(;;){var J=c==31?x:G;i=0;if(i<B){c=33;e=34}else{c=33;e=35}for(;;)if(e==34){var E=c==38?N:J;g=0;c=34;e:for(;;){var N=c==41?P:E;if(!(g<IHEAP[b+52]))break e;if(i>IHEAP[IHEAP[b+60]+4*g])break e;var Q=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*d+20+i*4];j=0;if(j<Q){c=39;e=40}else{c=39;e=41}for(;;)if(e==40){S=c==43?S:N;c=FHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+12];_fprintf(a,__str1944,k,d,h,i,g,j,IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+
20*k+4],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+8]);o&&_fprintf(a,__str2045,c);_fputc(10,a);var S=S+c;k+=1;j+=1;if(j<Q){c=43;e=40}else{c=44;e=41}}else if(e==41){var P=c==44?S:N;g+=1;c=41;continue e}}i+=1;if(i<D){c=38;e=34}else{c=38;e=35}}else if(e==35){var G=c==33?J:N;h+=1;if(h<IHEAP[b+56]){c=35;e=33;continue c}else{c=35;break b}}}}else if(e==28)if(IHEAP[b+24]==1){_fwrite(__str2146,75,1,a);p&&_fwrite(__str1843,6,1,a);_fputc(10,a);i=0;if(!(i<z+1)){c=46;break b}B=z+1;c=47;c:for(;;){D=c==47?x:H;h=0;
if(h<IHEAP[b+56]){c=48;e=49}else{c=48;e=50}for(;;)if(e==49){J=c==53?F:D;g=0;c=49;e:for(;;){var F=c==56?K:J;if(!(g<IHEAP[b+52]))break e;if(i>IHEAP[IHEAP[b+60]+4*g])break e;E=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*d+20+i*4];j=0;if(j<E){c=54;e=55}else{c=54;e=56}for(;;)if(e==55){L=c==58?L:F;c=FHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+12];_fprintf(a,__str2247,k,d,i,h,g,j,IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+4],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+
20*k+8]);r&&_fprintf(a,__str2045,c);_fputc(10,a);var L=L+c;k+=1;j+=1;if(j<E){c=58;e=55}else{c=59;e=56}}else if(e==56){var K=c==59?L:F;g+=1;c=56;continue e}}h+=1;if(h<IHEAP[b+56]){c=53;e=49}else{c=53;e=50}}else if(e==50){var H=c==48?D:F;i+=1;if(i<B){c=50;e=48;continue c}else{c=50;break b}}}}else if(IHEAP[b+24]==2){_fwrite(__str2348,74,1,a);q&&_fwrite(__str1843,6,1,a);_fputc(10,a);i=0;if(!(i<z+1)){c=61;break b}B=z+1;c=62;c:for(;;){D=c==62?x:ga;J=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*
d+20+i*4];j=0;if(j<J){c=63;e=64}else{c=63;e=65}d:for(;;)if(e==64){E=c==68?T:D;g=IHEAP[b+36];c=d;h=_floorf(d/IHEAP[b+44])|0;Q=c+g+(0-h*IHEAP[b+44]*IHEAP[b+28]);c=IHEAP[b+36];h=_floorf(d/IHEAP[b+44])|0;e=IHEAP[b+32];var M=h*e+c,I=IHEAP[b+28]+Q,O=IHEAP[b+32],R=O+M;g=0;M=M<R;R=c+h*e;c=64;e:for(;;){var T=c==82?ka:E;if(!(g<IHEAP[b+52]))break e;c=IHEAP[IHEAP[b+88]+572*d+20+i*4];var V=_ldexp(1,IHEAP[IHEAP[b+60]+4*g]+IHEAP[IHEAP[b+88]+572*d+284+i*4]+(0-i))|0,ba=_ldexp(1,IHEAP[IHEAP[b+60]+4*g]+IHEAP[IHEAP[b+
88]+572*d+416+i*4]+(0-i))|0;h=j;e=(_floorf(j/c)|0)*c;var fa=h-e,ca=_floorf(j/c)|0;if(i>IHEAP[IHEAP[b+60]+4*g])break e;f:do if(M){ka=ba*ca;var U=V*fa;c=70;for(;;){aa=c==70?0:aa;X=c==70?T:X;var $=ka==R+aa;h:do if($){e=Q;if(e<I)c=72;else{c=72;break h}for(;;){W=c==77?W:X;var Y=U==e;j:do if(Y){h=0;if(h<IHEAP[b+56])c=75;else{c=75;break j}for(;;){Z=c==79?Z:W;c=FHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+12];_fprintf(a,__str2449,k,d,i,j,g,h,IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k],IHEAP[IHEAP[IHEAP[b+88]+572*
d+548]+20*k+4],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+8]);u&&_fprintf(a,__str2045,c);_fputc(10,a);var Z=Z+c;k+=1;h+=1;if(h<IHEAP[b+56])c=79;else break}c=80}else c=73;while(0);var W=c==73?W:c==80?Z:W;e+=1;if(e<I)c=77;else{c=77;break h}}}else c=71;while(0);var X=c==71?X:c==72?X:W,aa=aa+1;if(aa!=O)c=74;else{c=74;break f}}}else c=69;while(0);var ka=c==69?T:X;g+=1;c=82}j+=1;if(j<J){c=68;e=64;continue d}c=83;e=65}else if(e==65){var ga=c==83?T:D;i+=1;if(i<B){c=65;e=63;continue c}else{e=84;break c}}}c=84}else if(IHEAP[b+
24]==3){i=IHEAP[b+36];j=d;g=_floorf(d/IHEAP[b+44])|0;B=j+i+(0-g*IHEAP[b+44]*IHEAP[b+28]);g=IHEAP[b+36];h=_floorf(d/IHEAP[b+44])|0;I=IHEAP[b+32];Q=h*I+g;D=IHEAP[b+28]+B;J=IHEAP[b+32];O=J+Q;i=0;if(i<z+1){j=z+1;for(c=86;;){ja=c==86?0:ja;c=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*d+20+i*4];var ja=c>ja?c:ja;i+=1;if(i<j)e=c=87;else{e=88;break}}c=88}else c=170;E=c==88?ja:0;_fwrite(__str2550,74,1,a);s&&_fwrite(__str1843,6,1,a);_fputc(10,a);j=0;if(!(j<E)){c=91;break b}Q=Q<O;I=g+h*I;c=92;c:for(;;){O=
c==92?x:wa;g=0;if(g<IHEAP[b+52]){c=93;e=94}else{c=93;e=95}d:for(;;)if(e==94){M=c==97?qa:O;i=0;if(i<IHEAP[IHEAP[b+60]+4*g]+1){c=94;e=96}else{c=94;e=97}e:for(;;)if(e==96){ha=c==110?ha:M;c=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*d+20+i*4];h=IHEAP[IHEAP[b+88]+572*d+20+i*4];R=_ldexp(1,IHEAP[IHEAP[b+60]+4*g]+IHEAP[IHEAP[b+88]+572*d+284+i*4]+(0-i))|0;V=_ldexp(1,IHEAP[IHEAP[b+60]+4*g]+IHEAP[IHEAP[b+88]+572*d+416+i*4]+(0-i))|0;e=j;ba=(_floorf(j/h)|0)*h;ba=e-ba;fa=_floorf(j/h)|0;ca=j>=c|Q^1;
f:do if(ca)c=96;else{U=V*fa;$=R*ba;c=98;for(;;){da=c==98?0:da;pa=c==98?ha:pa;Y=U==I+da;h:do if(Y){e=B;if(e<D)c=100;else{c=100;break h}for(;;){oa=c==105?oa:pa;var ia=$==e;j:do if(ia){h=0;if(h<IHEAP[b+56])c=103;else{c=103;break j}for(;;){ea=c==107?ea:oa;c=FHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+12];_fprintf(a,__str2651,k,d,j,g,i,h,IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+4],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+8]);t&&_fprintf(a,__str2045,c);_fputc(10,a);var ea=
ea+c;k+=1;h+=1;if(h<IHEAP[b+56])c=107;else break}c=108}else c=101;while(0);var oa=c==101?oa:c==108?ea:oa;e+=1;if(e<D)c=105;else{c=105;break h}}}else c=99;while(0);var pa=c==99?pa:c==100?pa:oa,da=da+1;if(da!=J)c=102;else{c=102;break f}}}while(0);var ha=c==96?ha:pa;i+=1;if(i<IHEAP[IHEAP[b+60]+4*g]+1){c=110;e=96;continue e}c=111;e=97}else if(e==97){var qa=c==111?ha:M;g+=1;if(g<IHEAP[b+52]){c=97;e=94}else{c=97;e=95}continue d}}else if(e==95){var wa=c==93?O:qa;j+=1;if(j<E){c=95;e=93;continue c}else{c=
95;break b}}}}else{i=0;if(i<z+1){j=z+1;for(c=112;;){la=c==112?0:la;g=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*d+20+i*4];var la=g>la?g:la;i+=1;if(i<j)e=c=113;else{e=114;break}}c=114}else c=174;B=c==114?la:0;_fwrite(__str2752,74,1,a);v&&_fwrite(__str1843,6,1,a);_fputc(10,a);g=0;if(g<IHEAP[b+52])c=117;else{c=117;break b}c:for(;;){xa=c==137?xa:x;i=IHEAP[b+36];j=d;c=_floorf(d/IHEAP[b+44])|0;D=j+i+(0-c*IHEAP[b+44]*IHEAP[b+28]);J=IHEAP[b+36];E=_floorf(d/IHEAP[b+44])|0;Q=IHEAP[b+32];I=E*Q+J;
O=IHEAP[b+28]+D;M=IHEAP[b+32];R=M+I;j=0;V=j<B;d:do if(V){ba=I<R;fa=J+E*Q;c=119;e:for(;;){ca=c==119?xa:Ja;i=0;if(i<IHEAP[IHEAP[b+60]+4*g]+1){c=120;e=121}else{c=120;e=122}f:for(;;)if(e==121){Pa=c==135?Pa:ca;c=IHEAP[IHEAP[b+88]+572*d+152+i*4]*IHEAP[IHEAP[b+88]+572*d+20+i*4];h=IHEAP[IHEAP[b+88]+572*d+20+i*4];U=_ldexp(1,IHEAP[IHEAP[b+60]+4*g]+IHEAP[IHEAP[b+88]+572*d+284+i*4]+(0-i))|0;$=_ldexp(1,IHEAP[IHEAP[b+60]+4*g]+IHEAP[IHEAP[b+88]+572*d+416+i*4]+(0-i))|0;e=j;Y=(_floorf(j/h)|0)*h;Y=e-Y;ia=_floorf(j/
h)|0;var ma=j>=c|ba^1;g:do if(ma)c=121;else{var ua=$*ia,ra=U*Y;c=123;for(;;){Na=c==123?0:Na;Ba=c==123?Pa:Ba;var ta=ua==fa+Na;i:do if(ta){e=D;if(e<O)c=125;else{c=125;break i}for(;;){ya=c==130?ya:Ba;var va=ra==e;k:do if(va){h=0;if(h<IHEAP[b+56])c=128;else{c=128;break k}for(;;){na=c==132?na:ya;c=FHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+12];_fprintf(a,__str2651,k,d,g,j,i,h,IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+4],IHEAP[IHEAP[IHEAP[b+88]+572*d+548]+20*k+8]);y&&
_fprintf(a,__str2045,c);_fputc(10,a);var na=na+c;k+=1;h+=1;if(h<IHEAP[b+56])c=132;else break}c=133}else c=126;while(0);var ya=c==126?ya:c==133?na:ya;e+=1;if(e<O)c=130;else{c=130;break i}}}else c=124;while(0);var Ba=c==124?Ba:c==125?Ba:ya,Na=Na+1;if(Na!=M)c=127;else{c=127;break g}}}while(0);var Pa=c==121?Pa:Ba;i+=1;if(i<IHEAP[IHEAP[b+60]+4*g]+1){c=135;e=121;continue f}c=136;e=122}else if(e==122){var Ja=c==136?Pa:ca;j+=1;if(j<B){c=122;continue e}else{c=122;break d}}}}else c=118;while(0);var xa=c==118?
xa:Ja;g+=1;if(g<IHEAP[b+52]){c=137;e=118}else{e=138;break c}}c=138}while(0);k=c==30?x:c==35?G:c==84?ga:c==61?x:c==138?xa:c==117?x:c==91?x:c==95?wa:c==46?x:H;d+=1;if(d<IHEAP[b+48]*IHEAP[b+44])c=32;else break a}m=k}if(l!=0){_fprintf(a,__str28117,FHEAP[b]);_fprintf(a,__str2953,m)}l=IHEAP[b+64]!=0;a:do if(l){_fwrite(__str30118,13,1,a);_fprintf(a,__str328,IHEAP[b+64]);_fwrite(__str31119,25,1,a);e=0;if(!(e<IHEAP[b+64]))break a;for(;;){_fprintf(a,__str32120,IHEAP[IHEAP[b+68]+12*e],IHEAP[IHEAP[b+68]+12*e+
4],IHEAP[IHEAP[b+68]+12*e+8]);e+=1;if(!(e<IHEAP[b+64]))break a}}while(0);_fclose(a);_fprintf(IHEAP[_stderr],__str33121,f);a=0}else{_fprintf(IHEAP[_stderr],__str126,f);a=1}}else a=1;return a}_write_index_file.__index__=Runtime.getFunctionIndex(_write_index_file,"_write_index_file");
function _tga_readheader(b,f,e,c,a){var d=STACKTOP;STACKTOP+=20;_memset(d,0,20);var g,h,i=f!=0;a:do if(i){if(e==0){g=1;break a}if(c==0){g=1;break a}if(a==0){g=1;break a}_fread(d,18,1,b);IHEAP[f]=IHEAP[d+18];IHEAP[e]=IHEAP[d+14];IHEAP[c]=IHEAP[d+16];if(IHEAP[d]!=0){f=_malloc(IHEAP[d]);_fread(f,IHEAP[d],1,b);_free(f)}if(IHEAP[d+2]>8){_fwrite(__str54122,57,1,IHEAP[_stderr]);h=0}else{IHEAP[a]=(IHEAP[d+19]&32)!=0^1;a=(IHEAP[d+8]/8|0)*IHEAP[d+6];if(a>0){_fwrite(__str155,44,1,IHEAP[_stderr]);_fseek(b,a,
1)}h=1}g=6;break a}else g=1;while(0);if(g==1)h=0;b=h;STACKTOP=d;return b}_tga_readheader.__index__=Runtime.getFunctionIndex(_tga_readheader,"_tga_readheader");
function _tga_writeheader(b,f,e,c,a){var d=STACKTOP;STACKTOP+=20;_memset(d,0,20);var g,h,i=f!=0;a:do if(i){if(e==0){g=1;break a}if(c==0){g=1;break a}_llvm_memset_p0i8_i32(d,0,18,1,0);IHEAP[d+18]=f&255;IHEAP[d+14]=e&65535;IHEAP[d+16]=c&65535;IHEAP[d+2]=2;IHEAP[d+19]=8;if(a!=0){f=d+19;IHEAP[f]=(IHEAP[f]|32)&255}_fwrite(d,18,1,b);h=1;g=5;break a}else g=1;while(0);if(g==1)h=0;b=h;STACKTOP=d;return b}_tga_writeheader.__index__=Runtime.getFunctionIndex(_tga_writeheader,"_tga_writeheader");
function _tgatoimage(b,f){var e=STACKTOP;STACKTOP+=167;_memset(e,0,167);var c,a=null,d,g=e+4,h=e+8,i=e+12,j=e+16,k,m,l,n=e+160,o=e+161,p=e+162,r=e+163,q=e+164,u=e+165,s=e+166;IHEAP[i]=0;d=_fopen(b,__str73);if(d!=0)if(_tga_readheader(d,h,e,g,i)!=0)if(IHEAP[h]==24|IHEAP[h]==32){_llvm_memset_p0i8_i32(j,0,144,1,0);var t=IHEAP[h]==8;a:do{if(t)c=m=1;else{a=IHEAP[h];m=l=a==16;if(a==16){a=2;c=3}else{a=2;c=1}}break a}while(0);if(c==1){k=IHEAP[h]==32;var v=m;a=1}h=a==1?v:l;a=a==2?1:k;if(h!=0){h=2;k=a!=0?2:
1}else{k=a!=0?4:3;h=1}m=IHEAP[f+18188];l=IHEAP[f+18192];if(0<k){v=IHEAP[e];c=IHEAP[g];a=k;t=(a>1?a:1)-0;for(a=6;;){a=a==6?0:B;B=0+a;var y=j+B*36+12,x=j+B*36+8,w=j+B*36+4,C=j+B*36,z=j+B*36+32,A=j+B*36+28;IHEAP[j+B*36+24]=8;IHEAP[A]=8;IHEAP[z]=0;IHEAP[C]=m;IHEAP[w]=l;IHEAP[x]=v;IHEAP[y]=c;var B=a+1;if(B!=t)a=7;else break}}j=_opj_image_create(k,j,h);if(j!=0){IHEAP[j]=IHEAP[f+18180];IHEAP[j+4]=IHEAP[f+18184];if(IHEAP[j]!=0){var D=IHEAP[j]+1+(IHEAP[e]-1)*m;a=12}else{var J=(IHEAP[e]-1)*m+1;a=10}IHEAP[j+
8]=a==10?J:D;if(IHEAP[j+4]!=0){var E=IHEAP[j+4]+1+(IHEAP[g]-1)*l;a=15}else{var N=(IHEAP[g]-1)*l+1;a=13}IHEAP[j+12]=a==13?N:E;if(0<IHEAP[g]){D=k==3;J=j+24;E=j+24;N=j+24;k=k==4;B=j+24;h=j+24;m=j+24;l=j+24;a=16;a:for(;;){F=a==16?0:F;a=-1+F*-1;c=0+F;v=1+F;if(IHEAP[i]!=0){var Q=(IHEAP[g]+a)*IHEAP[e];a=18}else{var S=IHEAP[e]*c;a=20}c=a==20?S:Q;b:do if(D){if(!(0<IHEAP[e]))break b;for(a=22;;){P=a==22?0:P;a=P+1;t=c+P;_fread(p,1,1,d);_fread(o,1,1,d);_fread(n,1,1,d);IHEAP[IHEAP[IHEAP[J]+44]+4*t]=IHEAP[n];IHEAP[IHEAP[IHEAP[E]+
48+44]+4*t]=IHEAP[o];IHEAP[IHEAP[IHEAP[N]+96+44]+4*t]=IHEAP[p];var P=P+1;if(a<IHEAP[e])a=24;else break b}}else if(k){if(!(0<IHEAP[e]))break b;for(a=26;;){G=a==26?0:G;a=G+1;t=c+G;_fread(u,1,1,d);_fread(q,1,1,d);_fread(r,1,1,d);_fread(s,1,1,d);IHEAP[IHEAP[IHEAP[B]+44]+4*t]=IHEAP[r];IHEAP[IHEAP[IHEAP[h]+48+44]+4*t]=IHEAP[q];IHEAP[IHEAP[IHEAP[m]+96+44]+4*t]=IHEAP[u];IHEAP[IHEAP[IHEAP[l]+144+44]+4*t]=IHEAP[s];var G=G+1;if(a<IHEAP[e])a=27;else break b}}else _fprintf(IHEAP[_stderr],__str458,b);while(0);
var F=F+1;if(v<IHEAP[g])a=23;else break a}}d=j}else d=0}else d=0;else d=0;else{_fprintf(IHEAP[_stderr],__str357,b);d=0}d=d;STACKTOP=e;return d}_tgatoimage.__index__=Runtime.getFunctionIndex(_tgatoimage,"_tgatoimage");
function _imagetotga(b,f){var e,c=null,a,d,g,h;h=_fopen(f,__str559);if(h!=0){g=IHEAP[b+16]-1;var i=IHEAP[b+24],j=b+24,k=b+24,m=b+24,l=b+24,n=b+24;c=1;a:for(;;){c=c==8?o:0;e=1+c;if(!(0+c<g)){e=4;break a}if(IHEAP[i]!=IHEAP[IHEAP[j]+48*e]){e=5;break a}if(IHEAP[IHEAP[k]+4]!=IHEAP[IHEAP[m]+48*e+4]){e=5;break a}if(IHEAP[IHEAP[l]+24]!=IHEAP[IHEAP[n]+48*e+24]){e=5;break a}var o=c+1;c=8;e=2}if(e==4){a=IHEAP[i+8];e=IHEAP[IHEAP[b+24]+12];if(IHEAP[b+16]==2)c=4;else{d=IHEAP[b+16]==4;c=9}c=c==4?1:d;d=c!=0?32:24;
if(_tga_writeheader(h,d,a,e,1)!=0){d=IHEAP[b+16]-1;g=255/((1<<IHEAP[IHEAP[b+24]+24])-1);if(0<e){i=b+24;j=b+16;k=b+24;m=b+24;l=c!=0;n=b+24;o=0<a;var p=a>1?a:1,r=0*a,q=(e>1?e:1)-0;c=11;a:for(;;){var u=c==11?0:C,s=r+a*u;if(o){c=12;e=13}else{c=12;e=14}for(;;)if(e==13){w=c==19?w:0;e=s+w;var t=IHEAP[IHEAP[IHEAP[i]+44]+4*e];if(IHEAP[j]>2){var v=IHEAP[IHEAP[IHEAP[k]+48+44]+4*e],y=IHEAP[IHEAP[IHEAP[m]+96+44]+4*e];c=15}else c=13;var x=c==15?v:t;_fputc(Math.floor((c==15?y:t)*g),h);_fputc(Math.floor(x*g),h);
_fputc(Math.floor(t*g),h);l&&_fputc(Math.floor(IHEAP[IHEAP[IHEAP[n]+48*d+44]+4*e]*g),h);var w=w+1;if(w!=p){c=19;e=13}else{c=20;e=14}}else if(e==14){var C=u+1;if(C!=q){c=14;continue a}else break a}}}a=0}else a=1}else if(e==5){_fwrite(__str761,63,1,IHEAP[_stderr]);a=1}}else{_fprintf(IHEAP[_stderr],__str660,f);a=1}return a}_imagetotga.__index__=Runtime.getFunctionIndex(_imagetotga,"_imagetotga");
function _bmptoimage(b,f){var e=STACKTOP;STACKTOP+=164;_memset(e,0,164);var c,a=null,d,g,h,i,j,k,m,l,n=e+108,o=e+124,p,r,q,u,s,t,v,y,x,w;g=IHEAP[f+18188];h=IHEAP[f+18192];j=0;t=s=1;y=v=0;l=_fopen(b,__str73);var C=l!=0;a:do if(C){d=__IO_getc(l)&65535;IHEAP[n]=d;d=__IO_getc(l)*256;IHEAP[n]=IHEAP[n]+d&65535;if(IHEAP[n]!=19778){_fwrite(__str862,23,1,IHEAP[_stderr]);d=0}else{d=__IO_getc(l);IHEAP[n+4]=d;d=__IO_getc(l)*256;IHEAP[n+4]=d+IHEAP[n+4];d=__IO_getc(l)*65536;IHEAP[n+4]=d+IHEAP[n+4];d=__IO_getc(l)*
16777216;IHEAP[n+4]=d+IHEAP[n+4];d=__IO_getc(l)&65535;IHEAP[n+8]=d;d=__IO_getc(l)*256;IHEAP[n+8]=IHEAP[n+8]+d&65535;d=__IO_getc(l)&65535;IHEAP[n+10]=d;d=__IO_getc(l)*256;IHEAP[n+10]=IHEAP[n+10]+d&65535;d=__IO_getc(l);IHEAP[n+12]=d;d=__IO_getc(l)*256;IHEAP[n+12]=d+IHEAP[n+12];d=__IO_getc(l)*65536;IHEAP[n+12]=d+IHEAP[n+12];d=__IO_getc(l)*16777216;IHEAP[n+12]=d+IHEAP[n+12];d=__IO_getc(l);IHEAP[o]=d;d=__IO_getc(l)*256;IHEAP[o]=d+IHEAP[o];d=__IO_getc(l)*65536;IHEAP[o]=d+IHEAP[o];d=__IO_getc(l)*16777216;
IHEAP[o]=d+IHEAP[o];d=__IO_getc(l);IHEAP[o+4]=d;d=__IO_getc(l)*256;IHEAP[o+4]=d+IHEAP[o+4];d=__IO_getc(l)*65536;IHEAP[o+4]=d+IHEAP[o+4];d=__IO_getc(l)*16777216;IHEAP[o+4]=d+IHEAP[o+4];d=IHEAP[o+4];k=__IO_getc(l);IHEAP[o+8]=k;k=__IO_getc(l)*256;IHEAP[o+8]=k+IHEAP[o+8];k=__IO_getc(l)*65536;IHEAP[o+8]=k+IHEAP[o+8];k=__IO_getc(l)*16777216;IHEAP[o+8]=k+IHEAP[o+8];k=IHEAP[o+8];p=__IO_getc(l)&65535;IHEAP[o+12]=p;p=__IO_getc(l)*256;IHEAP[o+12]=IHEAP[o+12]+p&65535;p=__IO_getc(l)&65535;IHEAP[o+14]=p;p=__IO_getc(l)*
256;IHEAP[o+14]=IHEAP[o+14]+p&65535;p=__IO_getc(l);IHEAP[o+16]=p;p=__IO_getc(l)*256;IHEAP[o+16]=p+IHEAP[o+16];p=__IO_getc(l)*65536;IHEAP[o+16]=p+IHEAP[o+16];p=__IO_getc(l)*16777216;IHEAP[o+16]=p+IHEAP[o+16];p=__IO_getc(l);IHEAP[o+20]=p;p=__IO_getc(l)*256;IHEAP[o+20]=p+IHEAP[o+20];p=__IO_getc(l)*65536;IHEAP[o+20]=p+IHEAP[o+20];p=__IO_getc(l)*16777216;IHEAP[o+20]=p+IHEAP[o+20];p=__IO_getc(l);IHEAP[o+24]=p;p=__IO_getc(l)*256;IHEAP[o+24]=p+IHEAP[o+24];p=__IO_getc(l)*65536;IHEAP[o+24]=p+IHEAP[o+24];p=
__IO_getc(l)*16777216;IHEAP[o+24]=p+IHEAP[o+24];p=__IO_getc(l);IHEAP[o+28]=p;p=__IO_getc(l)*256;IHEAP[o+28]=p+IHEAP[o+28];p=__IO_getc(l)*65536;IHEAP[o+28]=p+IHEAP[o+28];p=__IO_getc(l)*16777216;IHEAP[o+28]=p+IHEAP[o+28];p=__IO_getc(l);IHEAP[o+32]=p;p=__IO_getc(l)*256;IHEAP[o+32]=p+IHEAP[o+32];p=__IO_getc(l)*65536;IHEAP[o+32]=p+IHEAP[o+32];p=__IO_getc(l)*16777216;IHEAP[o+32]=p+IHEAP[o+32];p=__IO_getc(l);IHEAP[o+36]=p;p=__IO_getc(l)*256;IHEAP[o+36]=p+IHEAP[o+36];p=__IO_getc(l)*65536;IHEAP[o+36]=p+IHEAP[o+
36];p=__IO_getc(l)*16777216;IHEAP[o+36]=p+IHEAP[o+36];var z=IHEAP[o+14]==24;b:do if(z){j=3;m=1;_llvm_memset_p0i8_i32(e,0,108,1,0);i=0;if(i<j){p=g;r=h;q=d;u=k;a=j;x=i;i=x+1;i=(a>i?a:i)-x;for(a=1;;){E=a==1?0:E;c=x+E;a=e+c*36+12;w=e+c*36+8;var A=e+c*36+4,B=e+c*36,D=e+c*36+32,J=e+c*36+28;IHEAP[e+c*36+24]=8;IHEAP[J]=8;IHEAP[D]=0;IHEAP[B]=p;IHEAP[A]=r;IHEAP[w]=q;IHEAP[a]=u;var E=E+1;if(E!=i)c=a=2;else{c=3;break}}}j=p=_opj_image_create(j,e,m);if(p!=0){IHEAP[j]=IHEAP[f+18180];IHEAP[j+4]=IHEAP[f+18184];if(IHEAP[j]!=
0){var N=IHEAP[j]+1+(d-1)*g;a=8}else{var Q=(d-1)*g+1;a=6}IHEAP[j+8]=a==6?Q:N;if(IHEAP[j+4]!=0){var S=IHEAP[j+4]+1+(k-1)*h;a=11}else{var P=(k-1)*h+1;a=9}IHEAP[j+12]=a==9?P:S;_fseek(l,0,0);_fseek(l,IHEAP[n+12],0);x=IHEAP[o+4];w=IHEAP[o+8];if(x*3%4!=0){var G=4-x*3%4;a=12}else a=114;r=a==12?G:0;m=_malloc((x*3+r)*w);_fread(m,1,(x*3+r)*w,l);u=0;p=m;if(0<w){r=r;q=w;var F=m;q=(q>1?q:1)-0;m=w+-1-0;a=14;c:for(;;){K=a==14?0:K;c=a==14?p:F;a=m+K*-1;i=x;if(0<x){i=a*(r+i*3);w=i+1;A=i+2;for(a=16;;){L=a==16?0:L;a=
L+1;B=L*3;D=c+(i+B);J=c+(w+B);IHEAP[IHEAP[IHEAP[j+24]+44]+4*u]=IHEAP[c+(A+B)];IHEAP[IHEAP[IHEAP[j+24]+48+44]+4*u]=IHEAP[J];IHEAP[IHEAP[IHEAP[j+24]+96+44]+4*u]=IHEAP[D];u+=1;var L=L+1;if(a<x)a=17;else break}}var K=K+1;if(K!=q){a=20;c=15}else{c=21;break c}}a=21}else a=115;_free(a==21?F:p)}else{_fclose(l);d=0;break a}}else{p=IHEAP[o+14]==8;c:do if(p){if(IHEAP[o+16]!=0){c=25;break c}p=_malloc(256);r=_malloc(256);q=_malloc(256);i=0;c=i<IHEAP[o+32];j=l;d:do if(c){z=q;m=r;x=u=p;w=r;A=p;B=q;D=r;J=q;var H=
o+32;a=26;for(;;){M=__IO_getc(a==26?j:M)&255;IHEAP[z+i]=M;M=__IO_getc(l)&255;IHEAP[m+i]=M;M=__IO_getc(l)&255;IHEAP[u+i]=M;__IO_getc(l);M=IHEAP[x+i]!=IHEAP[w+i];f:do if(M){if(IHEAP[A+i]==IHEAP[B+i])break f;if(IHEAP[D+i]==IHEAP[J+i])break f;s=0}while(0);i+=1;var M=l;if(i<IHEAP[H])a=29;else{a=29;break d}}}else a=24;while(0);_fseek(a==24?j:M,0,0);_fseek(l,IHEAP[n+12],0);x=IHEAP[o+4];w=IHEAP[o+8];if(IHEAP[o+4]%2!=0)x+=1;j=s!=0?1:3;m=s!=0?2:1;_llvm_memset_p0i8_i32(e,0,108,1,0);i=0;if(i<j){c=g;z=h;u=d;A=
k;a=j;i=i;B=i+1;B=(a>B?a:B)-i;for(a=34;;){T=a==34?0:T;a=i+T;D=e+a*36+12;J=e+a*36+8;H=e+a*36+4;var I=e+a*36,O=e+a*36+32,R=e+a*36+28;IHEAP[e+a*36+24]=8;IHEAP[R]=8;IHEAP[O]=0;IHEAP[I]=c;IHEAP[H]=z;IHEAP[J]=u;IHEAP[D]=A;var T=T+1;if(T!=B)a=35;else break}}j=c=_opj_image_create(j,e,m);if(c!=0){IHEAP[j]=IHEAP[f+18180];IHEAP[j+4]=IHEAP[f+18184];if(IHEAP[j]!=0){var V=IHEAP[j]+1+(d-1)*g;a=40}else{var ba=(d-1)*g+1;a=38}IHEAP[j+8]=a==38?ba:V;if(IHEAP[j+4]!=0){var fa=IHEAP[j+4]+1+(k-1)*h;a=43}else{var ca=(k-1)*
h+1;a=41}IHEAP[j+12]=a==41?ca:fa;m=_malloc(w*x);_fread(m,1,w*x,l);d=s!=0;i=u=0;k=i<w*x;d:do if(d){if(!k)break d;z=o+4;a=w;A=m;B=p;D=w;J=o+4;for(;;){H=i%x<x-1;f:do if(H){c=IHEAP[z]%2!=0?48:49;break f}else c=49;while(0);f:do if(c==49){c=IHEAP[J]%2!=0?50:48;break f}while(0);if(c==48){IHEAP[IHEAP[IHEAP[j+24]+44]+4*u]=IHEAP[B+IHEAP[A+(0-(Math.floor(i/x)+1)*x+a*x+i%x)]];u+=1}i+=1;if(!(i<D*x))break d}}else{if(!k)break d;z=o+4;a=w;A=m;B=p;D=r;J=q;H=w;I=o+4;e:for(;;){O=i%x<x-1;f:do if(O){c=IHEAP[z]%2!=0?53:
54;break f}else c=54;while(0);f:do if(c==54){c=IHEAP[I]%2!=0?55:53;break f}while(0);if(c==53){c=IHEAP[A+(0-(Math.floor(i/x)+1)*x+a*x+i%x)];IHEAP[IHEAP[IHEAP[j+24]+44]+4*u]=IHEAP[B+c];IHEAP[IHEAP[IHEAP[j+24]+48+44]+4*u]=IHEAP[D+c];IHEAP[IHEAP[IHEAP[j+24]+96+44]+4*u]=IHEAP[J+c];u+=1}i+=1;if(!(i<H*x))break e}}while(0);_free(m);_free(p);_free(r);_free(q);c=59;break b}else{_fclose(l);d=0;break a}}while(0);u=IHEAP[o+14]==8;c:do if(u){if(IHEAP[o+16]!=1){c=61;break c}p=_malloc(256);r=_malloc(256);q=_malloc(256);
i=0;j=i<IHEAP[o+32];d:do if(j){a=q;m=r;w=x=p;A=r;B=p;D=q;J=r;H=q;I=o+32;for(;;){c=__IO_getc(l)&255;IHEAP[a+i]=c;c=__IO_getc(l)&255;IHEAP[m+i]=c;c=__IO_getc(l)&255;IHEAP[x+i]=c;__IO_getc(l);c=IHEAP[w+i]!=IHEAP[A+i];f:do if(c){if(IHEAP[B+i]==IHEAP[D+i])break f;if(IHEAP[J+i]==IHEAP[H+i])break f;s=0}while(0);i+=1;if(i<IHEAP[I])c=62;else{c=67;break d}}}while(0);j=s!=0?1:3;m=s!=0?2:1;_llvm_memset_p0i8_i32(e,0,108,1,0);i=0;if(i<j){x=g;w=h;A=d;B=k;a=j;i=i;D=i+1;D=(a>D?a:D)-i;for(a=68;;){U=a==68?0:U;c=i+U;
a=e+c*36+12;J=e+c*36+8;H=e+c*36+4;I=e+c*36;O=e+c*36+32;R=e+c*36+28;IHEAP[e+c*36+24]=8;IHEAP[R]=8;IHEAP[O]=0;IHEAP[I]=x;IHEAP[H]=w;IHEAP[J]=A;IHEAP[a]=B;var U=U+1;if(U!=D)c=a=69;else{c=70;break}}}j=a=_opj_image_create(j,e,m);if(a!=0){IHEAP[j]=IHEAP[f+18180];IHEAP[j+4]=IHEAP[f+18184];if(IHEAP[j]!=0){var $=IHEAP[j]+1+(d-1)*g;a=74}else{var Y=(d-1)*g+1;a=72}IHEAP[j+8]=a==72?Y:$;if(IHEAP[j+4]!=0){var Z=IHEAP[j+4]+1+(k-1)*h;a=77}else{var W=(k-1)*h+1;a=75}IHEAP[j+12]=a==75?W:Z;_fseek(l,0,0);_fseek(l,IHEAP[n+
12],0);m=_malloc(IHEAP[o+8]*IHEAP[o+4]);x=o+4;w=m;A=o+4;B=m;D=v;J=y;H=t;a=78;d:for(;;){i=a==78?H:a==91?aa:a==92?aa:a==87?aa:a==83?aa:aa;var X=a==78?J:a==91?ha:a==92?ha:a==87?0:a==83?X:ea;I=a==78?D:a==91?ka:a==92?ka:a==87?qa:a==83?ka:ka;a=79;e:for(;;){c=a==79?0:ia;var aa=a==79?i:0,ka=I+c;if(aa==0){c=82;break d}var ga=__IO_getc(l)&255;O=ga!=0;var ja=__IO_getc(l)&255;if(O){c=83;break e}O=ja;if(O==0){c=87;break e}else if(O!=1)if(O==2){c=106;break d}else{c=107;break e}var ia=c+1;a=88;c=80}if(c==83){i=
0;if(!(i<ga)){a=83;c=79;continue d}I=ga;O=X+1;for(a=85;;){oa=a==85?0:oa;var ea=O+oa;IHEAP[w+(X+oa)+ka*IHEAP[x]]=ja;i+=1;var oa=oa+1;if(i<I)c=a=86;else{a=86;c=79;continue d}}}else if(c==107){i=0;ha=i<ja;e:do if(ha){c=ja;I=X+1;for(a=89;;){da=a==89?0:da;var pa=I+da;a=B+(X+da);O=__IO_getc(l)&255;IHEAP[a+ka*IHEAP[A]]=O;i+=1;var da=da+1;if(i<c)a=90;else{a=90;break e}}}else a=107;while(0);var ha=a==107?X:pa;if(ja%2==0){a=91;c=79;continue d}__IO_getc(l);a=92;c=79}else if(c==87){var qa=ka+1;a=87;c=79}}if(c==
82){t=aa;y=X;d=s!=0;v=u=0;k=v<IHEAP[o+8];d:do if(d){if(!k)break d;y=o+4;z=o+8;x=o+4;i=m;w=p;A=o+4;B=o+8;c=v;v=-1-c;D=c+1;a=93;e:for(;;){J=a==93?0:ra;H=v+J*-1;var wa=D+J;if(0<IHEAP[y]){a=96;c=97}else{a=96;c=98}for(;;)if(c==97){ma=a==97?ma:0;var la=ma+1;IHEAP[IHEAP[IHEAP[j+24]+44]+4*u]=IHEAP[w+IHEAP[i+ma+IHEAP[x]*(H+IHEAP[z])]];u+=1;var ma=ma+1;if(la<IHEAP[A])c=a=97;else{a=97;c=98}}else if(c==98){var ua=a==96?0:la,ra=J+1;if(wa<IHEAP[B]){a=98;continue e}else break e}}y=ua;v=wa}else{if(!k)break d;y=o+
4;z=o+8;x=o+4;i=m;w=p;A=r;B=q;D=o+4;J=o+8;c=v;v=-1-c;H=c+1;a=95;e:for(;;){I=a==95?0:Ba;O=v+I*-1;var ta=H+I;if(0<IHEAP[y]){a=101;c=102}else{a=101;c=103}for(;;)if(c==102){na=a==102?na:0;var va=na+1;c=IHEAP[i+na+IHEAP[x]*(O+IHEAP[z])]&255;IHEAP[IHEAP[IHEAP[j+24]+44]+4*u]=IHEAP[w+c];IHEAP[IHEAP[IHEAP[j+24]+48+44]+4*u]=IHEAP[A+c];IHEAP[IHEAP[IHEAP[j+24]+96+44]+4*u]=IHEAP[B+c];u+=1;var na=na+1;if(va<IHEAP[D])c=a=102;else{a=104;c=103}}else if(c==103){var ya=a==104?va:0,Ba=I+1;if(ta<IHEAP[J]){a=103;continue e}else break e}}y=
ya;v=ta}while(0);_free(m);_free(p);_free(r);_free(q);c=59;break b}else if(c==106){_fwrite(__str963,19,1,IHEAP[_stderr]);_opj_image_destroy(j);_fclose(l);d=0;break a}}else{_fclose(l);d=0;break a}}while(0);_fprintf(IHEAP[_stderr],__str1064,IHEAP[o+14])}while(0);_fclose(l);d=j}}else{_fprintf(IHEAP[_stderr],__str357,b);d=0}while(0);g=d;STACKTOP=e;return g}_bmptoimage.__index__=Runtime.getFunctionIndex(_bmptoimage,"_bmptoimage");
function _imagetobmp(b,f){var e,c=null,a,d,g,h,i,j;d=IHEAP[b+16]==3;a:do if(d){if(IHEAP[IHEAP[b+24]]!=IHEAP[IHEAP[b+24]+48]){e=1;break a}if(IHEAP[IHEAP[b+24]+48]!=IHEAP[IHEAP[b+24]+96]){e=1;break a}if(IHEAP[IHEAP[b+24]+4]!=IHEAP[IHEAP[b+24]+48+4]){e=1;break a}if(IHEAP[IHEAP[b+24]+48+4]!=IHEAP[IHEAP[b+24]+96+4]){e=1;break a}if(IHEAP[IHEAP[b+24]+24]!=IHEAP[IHEAP[b+24]+48+24]){e=1;break a}if(IHEAP[IHEAP[b+24]+48+24]!=IHEAP[IHEAP[b+24]+96+24]){e=1;break a}h=_fopen(f,__str559);if(h!=0){e=IHEAP[IHEAP[b+
24]+8];d=IHEAP[IHEAP[b+24]+12];_fwrite(__str1165,2,1,h);_fprintf(h,__str1266,(d*(e%2)+d*e)*3+54&255&255,(d*(e%2)+d*e)*3+54>>8&255&255,(d*(e%2)+d*e)*3+54>>16&255&255,(d*(e%2)+d*e)*3+54>>24&255&255);_fprintf(h,__str1266,0,0,0,0);_fprintf(h,__str1266,54,0,0,0);_fprintf(h,__str1266,40,0,0,0);_fprintf(h,__str1266,e&255&255,e>>8&255&255,e>>16&255&255,e>>24&255&255);_fprintf(h,__str1266,d&255&255,d>>8&255&255,d>>16&255&255,d>>24&255&255);_fprintf(h,__str1367,1,0);_fprintf(h,__str1367,24,0);_fprintf(h,__str1266,
0,0,0,0);_fprintf(h,__str1266,(d*(e%2)+d*e)*3&255&255,(d*(e%2)+d*e)*3>>8&255&255,(d*(e%2)+d*e)*3>>16&255&255,(d*(e%2)+d*e)*3>>24&255&255);_fprintf(h,__str1266,154,30,0,0);_fprintf(h,__str1266,154,30,0,0);_fprintf(h,__str1266,0,0,0,0);_fprintf(h,__str1266,0,0,0,0);if(IHEAP[IHEAP[b+24]+24]>8){i=IHEAP[IHEAP[b+24]+24]-8;_printf(__str1468,IHEAP[IHEAP[b+24]+24])}else i=0;if(IHEAP[IHEAP[b+24]+48+24]>8){j=IHEAP[IHEAP[b+24]+48+24]-8;_printf(__str1569,IHEAP[IHEAP[b+24]+48+24])}else j=0;if(IHEAP[IHEAP[b+24]+
96+24]>8){c=IHEAP[IHEAP[b+24]+96+24]-8;_printf(__str1670,IHEAP[IHEAP[b+24]+96+24])}else c=0;g=0;if(g<d*e){var k=i;i=i-1;var m=j;j=j-1;var l=c,n=c-1;b:for(;;){var o=IHEAP[IHEAP[IHEAP[b+24]+44]+4*(0-((g/e|0)+1)*e+d*e+g%e)];if(IHEAP[IHEAP[b+24]+32]!=0){var p=1<<IHEAP[IHEAP[b+24]+24]-1;c=13}else c=12;c=o+(c==13?p:0);o=(c>>i)%2+(c>>k)&255;var r=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*(0-((g/e|0)+1)*e+d*e+g%e)];if(IHEAP[IHEAP[b+24]+48+32]!=0){var q=1<<IHEAP[IHEAP[b+24]+48+24]-1;c=15}else c=50;c=r+(c==15?q:0);
r=(c>>j)%2+(c>>m)&255;var u=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*(0-((g/e|0)+1)*e+d*e+g%e)];if(IHEAP[IHEAP[b+24]+96+32]!=0){var s=1<<IHEAP[IHEAP[b+24]+96+24]-1;c=17}else c=51;c=u+(c==17?s:0);_fprintf(h,__str1771,(c>>n)%2+(c>>l)&255,r,o);o=(g+1)%e==0;c:do if(o){if(e*3%4==0)break c;r=4-e*3%4;if(r>0)c=20;else break c;for(;;){t=c==22?t:0;_fputc(0,h);var t=t+1;if(t!=r)c=22;else break c}}while(0);g+=1;if(!(g<d*e))break b}}_fclose(h);e=25}else{_fprintf(IHEAP[_stderr],__str660,f);a=1;e=7}break a}else e=1;while(0);
a:do if(e==1){h=_fopen(f,__str559);e=IHEAP[IHEAP[b+24]+8];d=IHEAP[IHEAP[b+24]+12];_fwrite(__str1165,2,1,h);_fprintf(h,__str1266,e*d+1078+e%2*d&255&255,e*d+1078+e%2*d>>8&255&255,e*d+1078+e%2*d>>16&255&255,e*d+1078+e%2*e>>24&255&255);_fprintf(h,__str1266,0,0,0,0);_fprintf(h,__str1266,54,4,0,0);_fprintf(h,__str1266,40,0,0,0);_fprintf(h,__str1266,e&255&255,e>>8&255&255,e>>16&255&255,e>>24&255&255);_fprintf(h,__str1266,d&255&255,d>>8&255&255,d>>16&255&255,d>>24&255&255);_fprintf(h,__str1367,1,0);_fprintf(h,
__str1367,8,0);_fprintf(h,__str1266,0,0,0,0);_fprintf(h,__str1266,e%2*d+e*d&255&255,e%2*d+e*d>>8&255&255,e%2*d+e*d>>16&255&255,e%2*d+e*d>>24&255&255);_fprintf(h,__str1266,154,30,0,0);_fprintf(h,__str1266,154,30,0,0);_fprintf(h,__str1266,0,1,0,0);_fprintf(h,__str1266,0,1,0,0);if(IHEAP[IHEAP[b+24]+24]>8){i=IHEAP[IHEAP[b+24]+24]-8;_printf(__str1468,IHEAP[IHEAP[b+24]+24])}else i=0;g=0;b:for(;;){_fprintf(h,__str1266,g,g,g,0);g=p=g+1;if(!(p<256))break b}g=0;if(g<d*e){p=i;q=i-1;b:for(;;){s=IHEAP[IHEAP[IHEAP[b+
24]+44]+4*(0-((g/e|0)+1)*e+d*e+g%e)];if(IHEAP[IHEAP[b+24]+32]!=0){var v=1<<IHEAP[IHEAP[b+24]+24]-1;c=31}else c=30;s=s+(c==31?v:0);_fputc((s>>q)%2+(s>>p)&255,h);s=(g+1)%e==0;c:do if(s){if(e%4==0)break c;t=4-e%4;if(t>0)c=34;else break c;for(;;){y=c==36?y:0;_fputc(0,h);var y=y+1;if(y!=t)c=36;else break c}}while(0);g+=1;if(!(g<d*e))break b}}_fclose(h);e=25;break a}while(0);if(e==25)a=0;return a}_imagetobmp.__index__=Runtime.getFunctionIndex(_imagetobmp,"_imagetobmp");
function _readuchar(b){var f=STACKTOP;STACKTOP+=1;_memset(f,0,1);_fread(f,1,1,b);b=IHEAP[f];STACKTOP=f;return b}_readuchar.__index__=Runtime.getFunctionIndex(_readuchar,"_readuchar");function _readushort(b,f){var e=STACKTOP;STACKTOP+=2;_memset(e,0,2);var c=e+1;_fread(e,1,1,b);_fread(c,1,1,b);c=f!=0?IHEAP[e]*256+IHEAP[c]&65535:IHEAP[c]*256+IHEAP[e]&65535;STACKTOP=e;return c}_readushort.__index__=Runtime.getFunctionIndex(_readushort,"_readushort");
function _readuint(b,f){var e=STACKTOP;STACKTOP+=4;_memset(e,0,4);var c=e+1,a=e+2,d=e+3;_fread(e,1,1,b);_fread(c,1,1,b);_fread(a,1,1,b);_fread(d,1,1,b);c=f!=0?IHEAP[c]*65536+IHEAP[e]*16777216+IHEAP[d]+IHEAP[a]*256:IHEAP[a]*65536+IHEAP[d]*16777216+IHEAP[e]+IHEAP[c]*256;STACKTOP=e;return c}_readuint.__index__=Runtime.getFunctionIndex(_readuint,"_readuint");
function _pgxtoimage(b,f){var e=STACKTOP;STACKTOP+=115;_memset(e,0,115);var c,a=null,d,g,h,i,j=e+1,k=e+5,m=e+9,l,n=e+13,o=e+49,p=e+50,r=e+51,q=e+83,u;_llvm_memset_p0i8_i32(n,0,36,1,0);l=0;i=_fopen(b,__str73);var s=i!=0;a:do if(s){_fseek(i,0,0);___01__isoc99_fscanf_(i,__str2074,q,o,p,r,m,q,j,q,k);a=0;h=43;if(IHEAP[r+a]!=0){c=a;d=c+1;for(a=1;;){t=a==1?0:t;g=r+(d+t);if(IHEAP[r+(c+t)]==45)h=45;var t=t+1;if(IHEAP[g]!=0)a=4;else break}}_fgetc(i);d=IHEAP[o]==77;b:do if(d){if(IHEAP[p]!=76){c=8;break b}u=
1;c=9;break b}else c=8;while(0);b:do if(c==8){u=IHEAP[p]==77;c:do if(u){if(IHEAP[o]!=76)break c;u=0;break b}while(0);_fwrite(__str2175,40,1,IHEAP[_stderr]);h=0;break a}while(0);IHEAP[n+16]=IHEAP[f+18180];IHEAP[n+20]=IHEAP[f+18184];if(IHEAP[n+16]!=0){var v=IHEAP[n+16]+1+IHEAP[f+18188]*(IHEAP[j]-1);a=15}else{var y=IHEAP[f+18188]*(IHEAP[j]-1)+1;a=13}IHEAP[n+8]=a==13?y:v;if(IHEAP[n+20]!=0){var x=IHEAP[n+20]+1+IHEAP[f+18192]*(IHEAP[k]-1);a=18}else{var w=IHEAP[f+18192]*(IHEAP[k]-1)+1;a=16}IHEAP[n+12]=a==
16?w:x;IHEAP[n+32]=h==45?1:0;IHEAP[n+24]=IHEAP[m];IHEAP[n+28]=IHEAP[m];IHEAP[n]=IHEAP[f+18188];IHEAP[n+4]=IHEAP[f+18192];h=c=_opj_image_create(1,n,2);if(c!=0){IHEAP[h]=IHEAP[n+16];IHEAP[h+4]=IHEAP[n+16];IHEAP[h+8]=IHEAP[n+8];IHEAP[h+12]=IHEAP[n+12];c=IHEAP[h+24];a=0;if(a<IHEAP[k]*IHEAP[j]){d=c+24;var C=c;g=C+32;var z=i,A=c+44;C=C+24;var B=c+32,D=i,J=u,E=a;l=l;var N=E+1;for(a=20;;){I=a==20?0:I;M=a==20?l:M;var Q=N+I,S=E+I;if(IHEAP[d]<=8){a=IHEAP[g]!=0;_fread(e,1,1,z);var P=IHEAP[e];if(a){var G=P;a=
24}else{var F=P;a=22}}else{a=IHEAP[B]!=0;if(IHEAP[C]<=16){P=_readushort(D,J);if(a){var L=P;a=26}else{var K=P;a=25}}else{var H=_readuint(D,J);a=27}}a=a==26?L:a==25?K:a==27?H:a==22?F:G;var M=a>M?a:M;IHEAP[IHEAP[A]+4*S]=a;var I=I+1;if(Q<IHEAP[k]*IHEAP[j])a=28;else break}l=M}_fclose(i);d=z=l;g=0;if(z>1){d=d;g=g+1;for(a=31;;){T=a==31?0:T;var O=g+T,R=(a==31?d:R)>>1,T=T+1;if(R>1)a=32;else break}g=O}IHEAP[c+28]=g+1;h=h}else{_fclose(i);h=0}}else{_fprintf(IHEAP[_stderr],__str1973,b);h=0}while(0);i=h;STACKTOP=
e;return i}_pgxtoimage.__index__=Runtime.getFunctionIndex(_pgxtoimage,"_pgxtoimage");
function _imagetopgx(b,f){var e=STACKTOP;STACKTOP+=256;_memset(e,0,256);var c,a=null,d,g=b+16,h=b+24,i=b+16,j=b+24,k=b+24,m=b+24;a=0;a:for(;;){c=a==25?C:0;C=0+c;if(!(C<IHEAP[g])){c=3;break a}var l=IHEAP[h],n=_strlen(f)-4,o=n+6;if(IHEAP[f+n]!=46){c=4;break a}if(o>256){var p=_malloc(o+1);a=7}else a=5;var r=a==7?p:e;_strncpy(r,f,n);a=r+n;IHEAP[i]>1?_sprintf(a,__str2377,C):_llvm_memcpy_p0i8_p0i8_i32(a,__str2478,5,1,0);n=_fopen(r,__str559);if(n==0){c=11;break a}o>256&&_free(r);o=IHEAP[IHEAP[j]+48*C+8];
var q=IHEAP[IHEAP[k]+48*C+12];_fprintf(n,__str2579,IHEAP[l+48*C+32]!=0?45:43,IHEAP[l+48*C+24],o,q);var u=IHEAP[l+48*C+24]<=8;b:do if(u)a=26;else{if(IHEAP[l+48*C+24]<=16){a=13;break b}a=15}while(0);l=a==15?4:a==26?1:2;if(0<q*o){u=l-1>=0;b:do if(u){var s=l*8+-8,t=q*o;a=17;for(;;){x=a==17?0:x;var v=IHEAP[IHEAP[IHEAP[m]+48*C+44]+4*x];for(a=18;;){y=a==18?0:y;_fputc(v>>s+y*-8&255,n);var y=y+1;if(y!=l)a=19;else break}var x=x+1;if(x!=t)a=20;else break b}}else{s=q*o;for(a=22;;){var w=(a==22?0:w)+1;if(w!=s)a=
23;else break b}}while(0)}_fclose(n);var C=c+1;a=25;c=1}if(c==3)d=0;else if(c==4){_fwrite(__str2276,27,1,IHEAP[_stderr]);d=1}else if(c==11){d=r;_fprintf(IHEAP[_stderr],__str660,d);d=1}d=d;STACKTOP=e;return d}_imagetopgx.__index__=Runtime.getFunctionIndex(_imagetopgx,"_imagetopgx");
function _pnmtoimage(b,f){var e=STACKTOP;STACKTOP+=121;_memset(e,0,121);var c,a=null,d,g,h,i,j,k,m=e+4,l,n=e+8,o,p=e+116,r=e+120;g=IHEAP[f+18188];h=IHEAP[f+18192];i=_fopen(b,__str73);var q=i!=0;a:do if(q)if(_fgetc(i)!=80)d=0;else{j=d=_fgetc(i)&255;c=j==50?27:j==53?27:j==51?28:j==54?28:29;if(c==29){_fclose(i);d=0;break a}else if(c==27){k=1;l=2}else if(c==28){k=3;l=1}_fgetc(i);j=_fgetc(i)==35;b:do if(j)for(o=a=i;;)if(_fgetc(a)==10)if(_fgetc(o)!=35)break b;while(0);_fseek(i,-1,1);___01__isoc99_fscanf_(i,
__str2680,e,m);_fgetc(i);_llvm_memset_p0i8_i32(n,0,108,1,0);j=0;if(j<k){o=g;c=h;var u=IHEAP[e],s=IHEAP[m];a=k;j=j;var t=j+1;t=(a>t?a:t)-j;for(a=6;;){A=a==6?0:A;a=j+A;var v=n+a*36+12,y=n+a*36+8,x=n+a*36+4,w=n+a*36,C=n+a*36+32,z=n+a*36+28;IHEAP[n+a*36+24]=8;IHEAP[z]=8;IHEAP[C]=0;IHEAP[w]=o;IHEAP[x]=c;IHEAP[y]=u;IHEAP[v]=s;var A=A+1;if(A!=t)a=7;else break}}o=j=_opj_image_create(k,n,l);if(j!=0){IHEAP[o]=IHEAP[f+18180];IHEAP[o+4]=IHEAP[f+18184];IHEAP[o+8]=IHEAP[f+18180]+1+(IHEAP[e]-1)*g;IHEAP[o+12]=IHEAP[f+
18184]+1+(IHEAP[m]-1)*h;j=d==50;b:do if(j)c=10;else{if(d==51){c=10;break b}if(d!=53)if(d!=54){c=13;break b}j=0;if(!(j<IHEAP[m]*IHEAP[e])){c=13;break b}d=i;c=o+24;u=k;s=0<k;c:do if(s){t=u>1?u:1;for(a=22;;){B=a==23?B:a==22?0:0;IHEAP[r]=0;_fread(r,1,1,d);IHEAP[IHEAP[IHEAP[c]+48*B+44]+4*j]=IHEAP[r];var B=B+1;if(B!=t)a=23;else{j+=1;if(j<IHEAP[m]*IHEAP[e])a=24;else break c}}}else for(;;){j+=1;if(!(j<IHEAP[m]*IHEAP[e]))break c}while(0);c=13;break b}while(0);b:do if(c==10){j=0;if(!(j<IHEAP[m]*IHEAP[e]))break b;
d=i;u=o+24;s=k;t=0<k;c:do if(t){v=s>1?s:1;for(a=14;;){D=a==15?D:a==14?0:0;IHEAP[p]=0;___01__isoc99_fscanf_(d,__str2781,p);IHEAP[IHEAP[IHEAP[u]+48*D+44]+4*j]=IHEAP[p];var D=D+1;if(D!=v)c=a=15;else{j+=1;if(j<IHEAP[m]*IHEAP[e]){a=16;c=15}else{c=17;break c}}}}else for(;;){j+=1;if(j<IHEAP[m]*IHEAP[e])c=18;else{c=17;break c}}while(0)}while(0);_fclose(i);d=o}else{_fclose(i);d=0}}else{_fprintf(IHEAP[_stderr],__str357,b);d=0}while(0);g=d;STACKTOP=e;return g}
_pnmtoimage.__index__=Runtime.getFunctionIndex(_pnmtoimage,"_pnmtoimage");
function _imagetopnm(b,f){var e=STACKTOP;STACKTOP+=256;_memset(e,0,256);var c,a=null,d,g,h,i,j,k,m,l,n;m=a=f;if(IHEAP[a]!=0){a=0;c=1}else{a=0;c=2}a:for(;;)if(c==1){a=a==1?j:0;i=m+(a+1);j=a+1;if(IHEAP[i]!=0){c=a=1;continue a}a=3;c=2}else if(c==2){a=(a==3?i:m)+-1;a+=-1;l=IHEAP[a];c=IHEAP[b+16]==3?4:5;break a}a:do if(c==4){if(IHEAP[IHEAP[b+24]]!=IHEAP[IHEAP[b+24]+48]){c=5;break a}if(IHEAP[IHEAP[b+24]+48]!=IHEAP[IHEAP[b+24]+96]){c=5;break a}if(IHEAP[IHEAP[b+24]+4]!=IHEAP[IHEAP[b+24]+48+4]){c=5;break a}if(IHEAP[IHEAP[b+
24]+48+4]!=IHEAP[IHEAP[b+24]+96+4]){c=5;break a}if(IHEAP[IHEAP[b+24]+24]!=IHEAP[IHEAP[b+24]+48+24]){c=5;break a}if(IHEAP[IHEAP[b+24]+48+24]!=IHEAP[IHEAP[b+24]+96+24]){c=5;break a}if(l==103){c=5;break a}if(l==71){c=5;break a}m=_fopen(f,__str559);if(m!=0){i=IHEAP[IHEAP[b+24]+8];j=IHEAP[IHEAP[b+24]+12];if(IHEAP[IHEAP[b+24]+24]>8)a=58;else{g=(1<<IHEAP[IHEAP[b+24]+24])-1;a=15}a=a==15?g:255;g=IHEAP[IHEAP[b+24]+16];var o=IHEAP[IHEAP[b+24]];c=IHEAP[b];d=o;o=IHEAP[IHEAP[b+24]+40];c=g-((c+-1+d)/d|0);g=o;IHEAP[IHEAP[b+
24]+16]=c+-1+(1<<g)>>g;g=IHEAP[IHEAP[b+24]+20];o=IHEAP[IHEAP[b+24]+4];c=IHEAP[b+4];d=o;o=IHEAP[IHEAP[b+24]+40];c=g-((c+-1+d)/d|0);g=o;IHEAP[IHEAP[b+24]+20]=c+-1+(1<<g)>>g;_fprintf(m,__str2882,i,j,a);if(IHEAP[IHEAP[b+24]+24]>8){g=IHEAP[IHEAP[b+24]+24]-8;_printf(__str2983,IHEAP[IHEAP[b+24]+24])}else g=0;if(IHEAP[IHEAP[b+24]+48+24]>8){d=IHEAP[IHEAP[b+24]+48+24]-8;_printf(__str3084,IHEAP[IHEAP[b+24]+48+24])}else d=0;if(IHEAP[IHEAP[b+24]+96+24]>8){a=IHEAP[IHEAP[b+24]+96+24]-8;_printf(__str3185,IHEAP[IHEAP[b+
24]+96+24])}else a=0;if(0<j*i){c=g;g=g-1;o=d;d=d-1;var p=a,r=a-1,q=m;a=j*i;i=(a>1?a:1)-0;for(a=20;;){v=a==20?0:v;j=0+v;var u=IHEAP[IHEAP[IHEAP[b+24]+44]+4*j];if(IHEAP[IHEAP[b+24]+32]!=0){k=1<<IHEAP[IHEAP[b+24]+24]-1;a=22}else a=21;a=u+(a==22?k:0);u=(a>>g)%2+(a>>c)&255;var s=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*j];if(IHEAP[IHEAP[b+24]+48+32]!=0){n=1<<IHEAP[IHEAP[b+24]+48+24]-1;a=24}else a=66;a=s+(a==24?n:0);s=(a>>d)%2+(a>>o)&255;j=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*j];if(IHEAP[IHEAP[b+24]+96+32]!=0){var t=
1<<IHEAP[IHEAP[b+24]+96+24]-1;a=26}else a=67;a=j+(a==26?t:0);_fprintf(q,__str1771,u,s,(a>>r)%2+(a>>p)&255);var v=v+1;if(v!=i)a=28;else break}}_fclose(m);c=31}else{_fprintf(IHEAP[_stderr],__str660,f);h=1;c=14}break a}while(0);a:do if(c==5){k=l==103;b:do if(k)a=5;else{if(l==71){a=32;c=33;break b}var y=IHEAP[b+16];a=34}while(0);k=n=a==34?y:a==32?1:1;if(IHEAP[b+16]>k){_fwrite(__str3286,48,1,IHEAP[_stderr]);_fwrite(__str3387,34,1,IHEAP[_stderr]);var x=n;a=36}else a=33;n=a==36?x:k;k=0;t=n>1;m=e;v=f;i=e;
j=f;b:for(;;){if(!(k<n)){c=41;break b}if(t)_sprintf(m,__str34123,k,v);else{a=_strlen(j)+1;_llvm_memcpy_p0i8_p0i8_i32(m,j,a,1,0)}c=_fopen(i,__str559);if(c==0){c=44;break b}g=IHEAP[IHEAP[b+24]+48*k+8];o=IHEAP[IHEAP[b+24]+48*k+12];if(IHEAP[IHEAP[b+24]+48*k+24]>8)a=43;else{var w=(1<<IHEAP[IHEAP[b+24]+48*k+24])-1;a=45}a=a==45?w:255;d=IHEAP[IHEAP[b+24]+48*k];p=IHEAP[IHEAP[b+24]+48*k+40];IHEAP[IHEAP[b+24]+48*k+16]=IHEAP[IHEAP[b+24]+48*k+16]-((IHEAP[b]+-1+d)/d|0)+-1+(1<<p)>>p;d=IHEAP[IHEAP[b+24]+48*k+4];
p=IHEAP[IHEAP[b+24]+48*k+40];IHEAP[IHEAP[b+24]+48*k+20]=IHEAP[IHEAP[b+24]+48*k+20]-((IHEAP[b+4]+-1+d)/d|0)+-1+(1<<p)>>p;_fprintf(c,__str36125,g,o,a);if(IHEAP[IHEAP[b+24]+48*k+24]>8){var C=IHEAP[IHEAP[b+24]+24]-8;_printf(__str3788,k,IHEAP[IHEAP[b+24]+48*k+24]);a=47}else a=72;d=a==47?C:0;if(0<o*g){p=d-1;g=o*g;for(a=49;;){A=a==49?0:A;o=IHEAP[IHEAP[IHEAP[b+24]+48*k+44]+4*A];if(IHEAP[IHEAP[b+24]+48*k+32]!=0){var z=1<<IHEAP[IHEAP[b+24]+48*k+24]-1;a=51}else a=50;a=o+(a==51?z:0);_fputc((a>>p)%2+(a>>d)&255,
c);var A=A+1;if(A!=g)a=53;else break}}_fclose(c);k+=1;c=39}if(c==41){c=31;break a}else if(c==44){_fprintf(IHEAP[_stderr],__str660,e);h=1;c=14;break a}}while(0);if(c==31)h=0;h=h;STACKTOP=e;return h}_imagetopnm.__index__=Runtime.getFunctionIndex(_imagetopnm,"_imagetopnm");
function _imagetotif(b,f){var e,c=null,a,d,g,h,i,j,k,m,l,n;i=0;var o=IHEAP[b+16]==3;a:do if(o){if(IHEAP[IHEAP[b+24]]!=IHEAP[IHEAP[b+24]+48]){e=1;break a}if(IHEAP[IHEAP[b+24]+48]!=IHEAP[IHEAP[b+24]+96]){e=1;break a}if(IHEAP[IHEAP[b+24]+4]!=IHEAP[IHEAP[b+24]+48+4]){e=1;break a}if(IHEAP[IHEAP[b+24]+48+4]!=IHEAP[IHEAP[b+24]+96+4]){e=1;break a}if(IHEAP[IHEAP[b+24]+24]!=IHEAP[IHEAP[b+24]+48+24]){e=1;break a}if(IHEAP[IHEAP[b+24]+48+24]!=IHEAP[IHEAP[b+24]+96+24]){e=1;break a}j=_TIFFOpen(f,__str559);if(j!=
0){d=IHEAP[IHEAP[b+24]+8];c=IHEAP[IHEAP[b+24]+12];g=c*d;h=IHEAP[IHEAP[b+24]+24];_TIFFSetField(j,256,d);_TIFFSetField(j,257,c);_TIFFSetField(j,277,3);_TIFFSetField(j,258,h);_TIFFSetField(j,274,1);_TIFFSetField(j,284,1);_TIFFSetField(j,262,2);_TIFFSetField(j,278,1);k=_TIFFStripSize(j);h=__TIFFmalloc(k);d=0;if(IHEAP[IHEAP[b+24]+32]!=0){var p=1<<IHEAP[IHEAP[b+24]+24]-1;c=8}else c=104;i=c==8?p:0;c=0;var r=h,q=g,u=g,s=h;k=k;var t=g,v=g,y=g,x=g,w=g;g=g;var C=c;c=10;b:for(;;){e=c==23?qa:0;var z=c==23?ha:
0,A=C+e;c=_TIFFNumberOfStrips(j);if(!(A<c)){e=13;break b}n=_TIFFStripSize(j);m=r;var B=IHEAP[IHEAP[b+24]+24]==8;c:do if(B){l=0;c=14;d:for(;;){var D=c==21?P:z;if(!(l<n-2))break d;if(!(d<q))break d;P=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];var J=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*d],E=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*d];if(IHEAP[IHEAP[b+24]+32]!=0){var N=P+i,Q=J+i,S=E+i;c=19}else c=18;E=c==19?S:E;J=c==19?Q:J;IHEAP[m+l]=(c==19?N:P)&255;IHEAP[m+(l+1)]=J&255;IHEAP[m+(l+2)]=E&255;d+=1;var P=l+3;l+=3;c=21}if(!(D<
n)){c=17;break c}l=D;for(c=22;;){if(!(l<n)){c=24;break c}if(!(d<u)){c=25;break c}J=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];var G=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*d];E=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*d];if(IHEAP[IHEAP[b+24]+32]!=0){var F=J+i,L=G+i,K=E+i;c=27}else c=26;G=c==27?L:G;E=c==27?K:E;IHEAP[m+l]=(c==27?F:J)&255;if(!(l+1<n)){c=29;break c}IHEAP[m+(l+1)]=G&255;if(!(l+2<n)){c=30;break c}IHEAP[m+(l+2)]=E&255;d+=1;l+=3;c=31}}else if(IHEAP[IHEAP[b+24]+24]==12){l=0;c=32;d:for(;;){var H=c==39?ca:z;if(!(l<
n-8))break d;if((d+1<v&d<t)==0)break d;ca=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];E=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*d];var M=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*d],I=IHEAP[IHEAP[IHEAP[b+24]+44]+4*(d+1)];G=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*(d+1)];J=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*(d+1)];if(IHEAP[IHEAP[b+24]+32]!=0){var O=ca+i,R=E+i,T=M+i,V=I+i,ba=G+i,fa=J+i;c=37}else c=36;J=c==37?fa:J;G=c==37?ba:G;I=c==37?V:I;M=c==37?T:M;E=c==37?R:E;c=c==37?O:ca;IHEAP[m+l]=c>>4&255;IHEAP[m+(l+1)]=(E>>8&15|(c&15)<<4)&255;IHEAP[m+
(l+2)]=E&255;IHEAP[m+(l+3)]=M>>4&255;IHEAP[m+(l+4)]=(I>>8&15|(M&15)<<4)&255;IHEAP[m+(l+5)]=I&255;IHEAP[m+(l+6)]=G>>4&255;IHEAP[m+(l+7)]=(J>>8&15|(G&15)<<4)&255;IHEAP[m+(l+8)]=J&255;d+=2;var ca=l+9;l+=9;c=39}if(!(H<n)){c=35;break c}l=H;for(c=40;;){if(!(l<n)){c=41;break c}if((d+1<x&d<y)==0){c=42;break c}E=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];M=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*d];var U=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*d];I=IHEAP[IHEAP[IHEAP[b+24]+44]+4*(d+1)];G=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*(d+1)];J=
IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*(d+1)];if(IHEAP[IHEAP[b+24]+32]!=0){var $=E+i,Y=M+i,Z=U+i,W=I+i,X=G+i,aa=J+i;c=44}else c=43;E=c==44?$:E;M=c==44?Y:M;U=c==44?Z:U;I=c==44?W:I;G=c==44?X:G;c=c==44?aa:J;IHEAP[m+l]=E>>4&255;if(!(l+1<n)){c=46;break c}IHEAP[m+(l+1)]=(M>>8&15|(E&15)<<4)&255;if(!(l+2<n)){c=47;break c}IHEAP[m+(l+2)]=M&255;if(!(l+3<n)){c=48;break c}IHEAP[m+(l+3)]=U>>4&255;if(!(l+4<n)){c=49;break c}IHEAP[m+(l+4)]=(I>>8&15|(U&15)<<4)&255;if(!(l+5<n)){c=50;break c}IHEAP[m+(l+5)]=I&255;if(!(l+6<
n)){c=51;break c}IHEAP[m+(l+6)]=G>>4&255;if(!(l+7<n)){c=52;break c}IHEAP[m+(l+7)]=(c>>8&15|(G&15)<<4)&255;if(!(l+8<n)){c=53;break c}IHEAP[m+(l+8)]=c&255;d+=2;l+=9;c=54}}else{if(IHEAP[IHEAP[b+24]+24]!=16){e=56;break b}l=0;c=55;d:for(;;){var ka=c==63?ea:z;if(!(l<n-5))break d;if(!(d<w))break d;ea=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];E=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*d];J=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*d];if(IHEAP[IHEAP[b+24]+32]!=0){var ga=ea+i,ja=E+i,ia=J+i;c=61}else c=60;J=c==61?ia:J;E=c==61?ja:E;c=
c==61?ga:ea;IHEAP[m+l]=c&255;IHEAP[m+(l+1)]=c>>8&255;IHEAP[m+(l+2)]=E&255;IHEAP[m+(l+3)]=E>>8&255;IHEAP[m+(l+4)]=J&255;IHEAP[m+(l+5)]=J>>8&255;d+=1;var ea=l+6;l+=6;c=63}if(!(ka<n)){c=59;break c}l=0;for(c=64;;){if(!(l<n)){c=65;break c}if(!(d<g)){c=66;break c}E=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];G=IHEAP[IHEAP[IHEAP[b+24]+48+44]+4*d];J=IHEAP[IHEAP[IHEAP[b+24]+96+44]+4*d];if(IHEAP[IHEAP[b+24]+32]!=0){var oa=E+i,pa=G+i,da=J+i;c=68}else c=67;E=c==68?oa:E;G=c==68?pa:G;c=c==68?da:J;IHEAP[m+l]=E&255;if(!(l+
1<n)){c=70;break c}IHEAP[m+(l+1)]=E>>8&255;if(!(l+2<n)){c=71;break c}IHEAP[m+(l+2)]=G&255;if(!(l+3<n)){c=72;break c}IHEAP[m+(l+3)]=G>>8&255;if(!(l+4<n)){c=73;break c}IHEAP[m+(l+4)]=c&255;if(!(l+5<n)){c=74;break c}IHEAP[m+(l+5)]=c>>8&255;d+=1;l+=6;c=75}}while(0);var ha=c==35?H:c==59?ka:c==17?D:c==42?H:c==53?H:c==52?H:c==51?H:c==50?H:c==49?H:c==48?H:c==47?H:c==46?H:c==41?H:c==65?ka:c==70?ka:c==71?ka:c==72?ka:c==73?ka:c==74?ka:c==66?ka:c==24?D:c==29?D:c==30?D:D;_TIFFWriteEncodedStrip(j,A,s,k);var qa=
e+1;c=23;e=11}if(e==13){__TIFFfree(h);_TIFFClose(j);e=76;break a}else if(e==56){_fprintf(IHEAP[_stderr],__str38126,IHEAP[IHEAP[b+24]+24]);_fwrite(__str39127,9,1,IHEAP[_stderr]);a=1;e=7;break a}}else{_fprintf(IHEAP[_stderr],__str660,f);a=1;e=7;break a}}else e=1;while(0);a:do if(e==1)if(IHEAP[b+16]==1){j=_TIFFOpen(f,__str559);if(j!=0){d=IHEAP[IHEAP[b+24]+8];c=IHEAP[IHEAP[b+24]+12];g=c*d;h=IHEAP[IHEAP[b+24]+24];_TIFFSetField(j,256,d);_TIFFSetField(j,257,c);_TIFFSetField(j,277,1);_TIFFSetField(j,258,
h);_TIFFSetField(j,274,1);_TIFFSetField(j,284,1);_TIFFSetField(j,262,1);_TIFFSetField(j,278,1);k=_TIFFStripSize(j);h=__TIFFmalloc(k);c=d=0;o=h;p=g;D=h;N=k;S=Q=g;F=c;c=77;b:for(;;){L=c==83?na:0;K=F+L;c=_TIFFNumberOfStrips(j);if(!(K<c)){e=80;break b}H=IHEAP[IHEAP[b+24]+24]==8;c:do if(H)for(c=79;;){O=c==87?la:0;R=o+O;c=_TIFFStripSize(j);if(!(O<c))break c;if(!(d<p))break c;la=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];if(IHEAP[IHEAP[b+24]+32]!=0){var wa=la+i;c=85}else c=84;IHEAP[R]=(c==85?wa:la)&255;d+=1;var la=
O+1;c=87}else if(IHEAP[IHEAP[b+24]+24]==12)for(c=109;;){O=c==93?ra:0;c=O*3;R=o+(c+2);T=o+(c+1);V=o+c;ba=_TIFFStripSize(j);if(!(c<ba))break c;if(!(d<Q))break c;ra=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];ba=IHEAP[IHEAP[IHEAP[b+24]+44]+4*(d+1)];if(IHEAP[IHEAP[b+24]+32]!=0){var ma=ra+i,ua=ba+i;c=91}else c=90;ba=c==91?ua:ba;ra=c==91?ma:ra;IHEAP[V]=ra>>4&255;IHEAP[T]=(ba>>8&15|(ra&15)<<4)&255;IHEAP[R]=ba&255;d+=2;var ra=O+1;c=93}else{if(IHEAP[IHEAP[b+24]+24]==16)c=94;else{e=96;break b}for(;;){O=c==101?va:0;c=
O*2;R=o+(c+1);T=o+c;V=_TIFFStripSize(j);if(!(c<V))break c;if(!(d<S))break c;va=IHEAP[IHEAP[IHEAP[b+24]+44]+4*d];if(IHEAP[IHEAP[b+24]+32]!=0){var ta=va+i;c=99}else c=98;va=c==99?ta:va;IHEAP[T]=va&255;IHEAP[R]=va>>8&255;d+=1;var va=O+1;c=101}}while(0);_TIFFWriteEncodedStrip(j,K,D,N);var na=L+1;c=83;e=78}if(e==80){__TIFFfree(o);_TIFFClose(j);e=76;break a}else if(e==96){_fprintf(IHEAP[_stderr],__str40128,IHEAP[IHEAP[b+24]+24]);_fwrite(__str39127,9,1,IHEAP[_stderr]);a=1;e=7;break a}}else{_fprintf(IHEAP[_stderr],
__str660,f);a=1;e=7;break a}}else{_fwrite(__str4189,80,1,IHEAP[_stderr]);_fwrite(__str39127,9,1,IHEAP[_stderr]);a=1;e=7;break a}while(0);if(e==76)a=0;return a}_imagetotif.__index__=Runtime.getFunctionIndex(_imagetotif,"_imagetotif");
function _tiftoimage(b,f){var e=STACKTOP;STACKTOP+=128;_memset(e,0,128);var c,a=null,d,g,h,i,j,k,m,l,n=e+20,o,p;g=IHEAP[f+18188];h=IHEAP[f+18192];i=_TIFFOpen(b,__str42129);var r=i!=0;a:do if(r){_TIFFGetField(i,256,e);_TIFFGetField(i,257,e+4);_TIFFGetField(i,258,e+12);_TIFFGetField(i,339,e+14);_TIFFGetField(i,277,e+16);IHEAP[e+8]=0;_TIFFGetField(i,262,e+8);_TIFFGetField(i,284,e+18);j=IHEAP[e];m=IHEAP[e+4];if(IHEAP[e+8]==2){d=3;l=1;_llvm_memset_p0i8_i32(n,0,108,1,0);if(0<d){k=f+18676;var q=g,u=h,s=
j,t=m;a=d;var v=e+12,y=e+12,x=(a>1?a:1)-0;for(a=1;;){A=a==1?0:A;p=0+A;c=n+p*36+24;a=n+p*36+28;var w=n+p*36+12;o=n+p*36+8;var C=n+p*36+4,z=n+p*36;p=n+p*36+32;if(IHEAP[k]!=0){IHEAP[c]=12;IHEAP[a]=12}else{IHEAP[c]=IHEAP[v];IHEAP[a]=IHEAP[y]}IHEAP[p]=0;IHEAP[z]=q;IHEAP[C]=u;IHEAP[o]=s;IHEAP[w]=t;var A=A+1;if(A!=x){a=4;c=2}else{c=5;break}}}d=a=_opj_image_create(d,n,l);if(a!=0){IHEAP[d]=IHEAP[f+18180];IHEAP[d+4]=IHEAP[f+18184];if(IHEAP[d]!=0){var B=IHEAP[d]+1+(j-1)*g;a=10}else{var D=(j-1)*g+1;a=8}IHEAP[d+
8]=a==8?D:B;if(IHEAP[d+4]!=0){var J=IHEAP[d+4]+1+(m-1)*h;a=13}else{var E=(m-1)*h+1;a=11}IHEAP[d+12]=a==11?E:J;j=_TIFFStripSize(i);j=__TIFFmalloc(j);k=_TIFFStripSize(i);m=0;o=IHEAP[IHEAP[d+24]+12]*IHEAP[IHEAP[d+24]+8];a=0;l=j;k=k;q=j;u=e+12;t=s=o;v=e+12;y=o;x=f+18676;w=e+12;o=o;C=f+18676;z=a;a=14;b:for(;;){c=a==20?S:0;a=z+c;p=_TIFFNumberOfStrips(i);if(!(a<p)){c=17;break b}var N=_TIFFReadEncodedStrip(i,a,l,k);a=q;var Q=IHEAP[u]==12;c:do if(Q)for(p=0;;){if(!(p<N))break c;if((m+1<t&m<s)==0)break c;IHEAP[IHEAP[IHEAP[d+
24]+44]+4*m]=IHEAP[a+(p+1)]>>4|IHEAP[a+p]<<4;IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*m]=IHEAP[a+(p+2)]|(IHEAP[a+(p+1)]&15)<<8;IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*m]=IHEAP[a+(p+4)]>>4|IHEAP[a+(p+3)]<<4;IHEAP[IHEAP[IHEAP[d+24]+44]+4*(m+1)]=IHEAP[a+(p+5)]|(IHEAP[a+(p+4)]&15)<<8;IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*(m+1)]=IHEAP[a+(p+7)]>>4|IHEAP[a+(p+6)]<<4;IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*(m+1)]=IHEAP[a+(p+8)]|(IHEAP[a+(p+7)]&15)<<8;m+=2;p+=9}else if(IHEAP[v]==16)for(p=0;;){if(!(p<N))break c;if(!(m<y))break c;IHEAP[IHEAP[IHEAP[d+
24]+44]+4*m]=IHEAP[a+p]|IHEAP[a+(p+1)]<<8;IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*m]=IHEAP[a+(p+2)]|IHEAP[a+(p+3)]<<8;IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*m]=IHEAP[a+(p+4)]|IHEAP[a+(p+5)]<<8;if(IHEAP[x]!=0){IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]=IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]+8>>4;IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*m]=IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*m]+8>>4;IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*m]=IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*m]+8>>4}m+=1;p+=6}else{if(IHEAP[w]!=8){c=27;break b}for(p=0;;){if(!(p<N))break c;if(!(m<
o))break c;IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]=IHEAP[a+p];IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*m]=IHEAP[a+(p+1)];IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*m]=IHEAP[a+(p+2)];if(IHEAP[C]!=0){IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]<<=4;IHEAP[IHEAP[IHEAP[d+24]+48+44]+4*m]<<=4;IHEAP[IHEAP[IHEAP[d+24]+96+44]+4*m]<<=4}m+=1;p+=3}}while(0);var S=c+1;a=20;c=15}if(c==17){__TIFFfree(j);_TIFFClose(i)}else if(c==27){_fprintf(IHEAP[_stderr],__str40128,IHEAP[e+12]);_fwrite(__str39127,9,1,IHEAP[_stderr]);d=0;break a}}else{_TIFFClose(i);
d=0;break a}}else if(IHEAP[e+8]==1){d=1;l=2;_llvm_memset_p0i8_i32(n,0,36,1,0);IHEAP[n+24]=IHEAP[e+12];IHEAP[n+28]=IHEAP[e+12];IHEAP[n+32]=0;IHEAP[n]=g;IHEAP[n+4]=h;IHEAP[n+8]=j;IHEAP[n+12]=m;d=_opj_image_create(d,n,l);if(d!=0){IHEAP[d]=IHEAP[f+18180];IHEAP[d+4]=IHEAP[f+18184];if(IHEAP[d]!=0){var P=IHEAP[d]+1+(j-1)*g;a=35}else{var G=(j-1)*g+1;a=33}IHEAP[d+8]=a==33?G:P;if(IHEAP[d+4]!=0){var F=IHEAP[d+4]+1+(m-1)*h;a=38}else{var L=(m-1)*h+1;a=36}IHEAP[d+12]=a==36?L:F;j=_TIFFStripSize(i);j=__TIFFmalloc(j);
k=_TIFFStripSize(i);m=0;o=IHEAP[IHEAP[d+24]+12]*IHEAP[IHEAP[d+24]+8];a=0;l=j;k=k;q=j;u=e+12;s=o;t=e+12;v=o;y=e+12;x=o;w=a;a=39;b:for(;;){c=a==45?I:0;a=w+c;o=_TIFFNumberOfStrips(i);if(!(a<o)){c=42;break b}o=_TIFFReadEncodedStrip(i,a,l,k);C=IHEAP[u]==12;c:do if(C)for(a=41;;){a=a==46?K:0;z=a*3;p=q+(z+2);N=q+(z+1);if(!(z<o))break c;if(!(m<s))break c;IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]=IHEAP[N]>>4|IHEAP[q+z]<<4;IHEAP[IHEAP[IHEAP[d+24]+44]+4*(m+1)]=IHEAP[p]|(IHEAP[N]&15)<<8;m+=2;var K=a+1;a=46}else if(IHEAP[t]==
16)for(a=73;;){a=a==49?H:0;z=a*2;if(!(z<o))break c;if(!(m<v))break c;IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]=IHEAP[q+z]|IHEAP[q+(z+1)]<<8;m+=1;var H=a+1;a=49}else{if(IHEAP[y]==8)a=50;else{c=52;break b}for(;;){a=a==54?M:0;if(!(a<o))break c;if(!(m<x))break c;IHEAP[IHEAP[IHEAP[d+24]+44]+4*m]=IHEAP[q+a];m+=1;var M=a+1;a=54}}while(0);var I=c+1;a=45;c=40}if(c==42){__TIFFfree(j);_TIFFClose(i)}else if(c==52){_fprintf(IHEAP[_stderr],__str40128,IHEAP[e+12]);_fwrite(__str39127,9,1,IHEAP[_stderr]);d=0;break a}}else{_TIFFClose(i);
d=0;break a}}else{_fwrite(__str4189,80,1,IHEAP[_stderr]);_fwrite(__str39127,9,1,IHEAP[_stderr]);d=0;break a}d=d}else{_fprintf(IHEAP[_stderr],__str43130,b);d=0}while(0);g=d;STACKTOP=e;return g}_tiftoimage.__index__=Runtime.getFunctionIndex(_tiftoimage,"_tiftoimage");
function _rawtoimage(b,f,e){var c=STACKTOP;STACKTOP+=4;_memset(c,0,4);var a,d=null,g,h,i,j,k,m,l,n=c+2,o=c+3;h=IHEAP[f+18188];i=IHEAP[f+18192];var p=((IHEAP[e+4]&IHEAP[e]&IHEAP[e+8]&IHEAP[e+12])!=0^1)==0;a:do if(p){_fwrite(__str44131,37,1,IHEAP[_stderr]);_fwrite(__str45132,33,1,IHEAP[_stderr]);_fwrite(__str46133,64,1,IHEAP[_stderr]);_fwrite(__str47134,50,1,IHEAP[_stderr]);_fwrite(__str39127,9,1,IHEAP[_stderr]);g=0}else{g=_fopen(b,__str73);if(g!=0){k=IHEAP[e+8];d=IHEAP[e];m=IHEAP[e+4];l=_malloc(k*
36);_llvm_memset_p0i8_i32(l,0,k*36,1,0);j=0;var r=j<k;b:do if(r)for(var q=e+12,u=l,s=e+12,t=l,v=e+16,y=l,x=h,w=l,C=i,z=l,A=d,B=l,D=m,J=l,E=k;;){IHEAP[u+36*j+24]=IHEAP[q];IHEAP[t+36*j+28]=IHEAP[s];IHEAP[y+36*j+32]=IHEAP[v];IHEAP[w+36*j]=x;IHEAP[z+36*j+4]=C;IHEAP[B+36*j+8]=A;IHEAP[J+36*j+12]=D;j+=1;if(j<E)a=1;else{a=2;break b}}while(0);l=j=_opj_image_create(k,l,1);if(j!=0){IHEAP[l]=IHEAP[f+18180];IHEAP[l+4]=IHEAP[f+18184];IHEAP[l+8]=IHEAP[f+18180]+1+(d-1)*h;IHEAP[l+12]=IHEAP[f+18184]+1+(m-1)*i;if(IHEAP[e+
12]<=8){j=IHEAP[n]=0;k=k;m=m*d;r=g;q=e+16;u=l+24;s=j;d=3;b:for(;;){a=d==9?S:0;t=s+a;if(!(t<k)){a=6;break b}for(j=0;;){if(!(j<m))break;if(_fread(n,1,1,r)==0){a=11;break b}d=IHEAP[n];if(IHEAP[q]!=0){var N=d;d=13}else{var Q=d;d=15}IHEAP[IHEAP[IHEAP[u]+48*t+44]+4*j]=d==13?N:Q;j+=1}var S=a+1;d=9;a=4}if(a!=6)if(a==11){_fwrite(__str4890,54,1,IHEAP[_stderr]);g=0;break a}}else if(IHEAP[e+12]<=16){j=0;k=k;m=m*d;q=r=g;u=e+16;s=l+24;t=j;d=16;b:for(;;){a=d==22?F:0;v=t+a;if(!(v<k)){a=19;break b}for(j=0;;){if(!(j<
m))break;if(_fread(o,1,1,r)==0){a=24;break b}d=IHEAP[o]<<8&65535;if(_fread(o,1,1,q)==0){a=26;break b}d=d+IHEAP[o]&65535;if(IHEAP[u]!=0){var P=d;d=27}else{var G=d;d=29}IHEAP[IHEAP[IHEAP[s]+48*v+44]+4*j]=d==27?P:G;j+=1}var F=a+1;d=22;a=17}if(a!=19)if(a==24){_fwrite(__str4890,54,1,IHEAP[_stderr]);g=0;break a}else if(a==26){_fwrite(__str4890,54,1,IHEAP[_stderr]);g=0;break a}}else{_fwrite(__str4991,74,1,IHEAP[_stderr]);g=0;break a}_fread(c,1,1,g)!=0&&_fwrite(__str50135,58,1,IHEAP[_stderr]);_fclose(g);
g=l}else{_fclose(g);g=0}}else{_fprintf(IHEAP[_stderr],__str357,b);_fwrite(__str39127,9,1,IHEAP[_stderr]);g=0}}while(0);b=g;STACKTOP=c;return b}_rawtoimage.__index__=Runtime.getFunctionIndex(_rawtoimage,"_rawtoimage");
function _imagetoraw(b,f){var e,c=null,a,d,g,h,i,j,k;if(IHEAP[b+8]*IHEAP[b+16]*IHEAP[b+12]==0){_fwrite(__str44131,37,1,IHEAP[_stderr]);a=1}else{d=_fopen(f,__str559);if(d!=0){_fprintf(IHEAP[_stdout],__str52137,IHEAP[b+16]);g=0;a:for(;;){if(!(g<IHEAP[b+16])){e=3;break a}_fprintf(IHEAP[_stdout],__str53138,g,IHEAP[IHEAP[b+24]+48*g+8],IHEAP[IHEAP[b+24]+48*g+12],IHEAP[IHEAP[b+24]+48*g+24],IHEAP[IHEAP[b+24]+48*g+32]==1?__str5492:__str55139);e=IHEAP[IHEAP[b+24]+48*g+8];h=IHEAP[IHEAP[b+24]+48*g+12];var m=
IHEAP[IHEAP[b+24]+48*g+24]<=8,l=IHEAP[b+24]+48*g;b:do if(m){i=IHEAP[b+24]+48*g;if(IHEAP[l+32]==1){k=(1<<IHEAP[i+24])-1;j=IHEAP[IHEAP[b+24]+48*g+44];i=0;if(!(i<h))break b;for(;;){c=0;if(c<e){var n=k,o=d,p=e;j=j;c=c;var r=c+1;p=(p>r?p:r)-c;for(c=6;;){q=c==6?0:q;_fputc(n&IHEAP[j+4*q]&255,o);var q=q+1;if(q!=p)c=7;else break}j=j+4*p}i+=1;if(!(i<h))break b}}else{if(IHEAP[i+32]!=0)break b;k=(1<<IHEAP[IHEAP[b+24]+48*g+24])-1;j=IHEAP[IHEAP[b+24]+48*g+44];i=0;if(!(i<h))break b;for(;;){c=0;if(c<e){n=k;o=d;p=
e;j=j;c=c;r=c+1;p=(p>r?p:r)-c;for(c=12;;){u=c==12?0:u;_fputc(n&IHEAP[j+4*u]&255,o);var u=u+1;if(u!=p)c=13;else break}j=j+4*p}i+=1;if(!(i<h))break b}}}else{var s=IHEAP[b+24]+48*g;if(!(IHEAP[l+24]<=16)){e=17;break a}i=IHEAP[b+24]+48*g;if(IHEAP[s+32]==1){k=(1<<IHEAP[i+24])-1;j=IHEAP[IHEAP[b+24]+48*g+44];i=0;if(!(i<h))break b;for(;;){c=0;if(c<e){n=k;p=o=d;r=e;j=j;c=c;var t=c+1;r=(r>t?r:t)-c;for(c=19;;){v=c==19?0:v;c=n&IHEAP[j+4*v]&65535;_fputc(c>>8&255,o);_fputc(c&255,p);var v=v+1;if(v!=r)c=20;else break}j=
j+4*r}i+=1;if(!(i<h))break b}}else{if(IHEAP[i+32]!=0)break b;k=(1<<IHEAP[IHEAP[b+24]+48*g+24])-1;j=IHEAP[IHEAP[b+24]+48*g+44];i=0;if(!(i<h))break b;for(;;){c=0;if(c<e){n=k;p=o=d;r=e;j=j;c=c;t=c+1;r=(r>t?r:t)-c;for(c=25;;){y=c==25?0:y;c=n&IHEAP[j+4*y]&65535;_fputc(c>>8&255,o);_fputc(c&255,p);var y=y+1;if(y!=r)c=26;else break}j=j+4*r}i+=1;if(!(i<h))break b}}}while(0);g+=1;e=1}if(e==3){_fclose(d);a=0}else if(e==17){a=IHEAP[_stderr];IHEAP[s+24]<=32?_fwrite(__str56140,47,1,a):_fprintf(a,__str57141,IHEAP[IHEAP[b+
24]+48*g+24]);a=1}}else{_fprintf(IHEAP[_stderr],__str51136,f);a=1}}return a}_imagetoraw.__index__=Runtime.getFunctionIndex(_imagetoraw,"_imagetoraw");
function _pngtoimage(b,f){var e=STACKTOP;STACKTOP+=208;_memset(e,0,208);var c,a=null,d;d=e+4;var g=e+8,h=e+16,i=e+20,j=e+24,k=e+28,m=e+32,l=e+36,n=e+40,o,p=e+44,r=e+48,q=e+52,u,s,t,v,y=e+56,x,w,C,z,A,B=e+200,D=_fopen(b,__str73);if(D==0){_fprintf(IHEAP[_stderr],__str58142,b);d=0}else{v=0;t=IHEAP[e]=0;var J=_fread(B,1,8,D)!=8;a:do if(J)c=1;else{if(_memcmp(B,__str59143,8)!=0){c=1;break a}s=_png_create_read_struct(__str61145,0,0,0);IHEAP[e]=s;if(s==0){c=4;break a}s=_png_create_info_struct(IHEAP[e]);IHEAP[d]=
s;if(s==0){c=4;break a}if(__setjmp(IHEAP[e])!=0){c=4;break a}_png_init_io(IHEAP[e],D);_png_set_sig_bytes(IHEAP[e],8);_png_read_info(IHEAP[e],IHEAP[d]);if(_png_get_IHDR(IHEAP[e],IHEAP[d],p,r,h,q,i,j,k)==0){c=4;break a}t=IHEAP[q]==3;b:do{if(!t){if(IHEAP[q]!=0){c=11;break b}if(!(IHEAP[h]<8)){c=11;break b}}_png_set_expand(IHEAP[e])}while(0);_png_get_valid(IHEAP[e],IHEAP[d],16)!=0&&_png_set_expand(IHEAP[e]);s=IHEAP[h]==16;if(IHEAP[q]==0|IHEAP[q]==4){_png_set_gray_to_rgb(IHEAP[e]);IHEAP[q]=IHEAP[q]==0?
2:6}_png_get_gAMA(IHEAP[e],IHEAP[d],g)!=0||(FHEAP[g]=0.45455);_png_set_gamma(IHEAP[e],2.2,FHEAP[g]);_png_read_update_info(IHEAP[e],IHEAP[d]);_png_get_pHYs(IHEAP[e],IHEAP[d],l,n,m);t=_png_get_color_type(IHEAP[e],IHEAP[d]);IHEAP[q]=t;u=IHEAP[q]==6;v=u+3;t=_png_get_bit_depth(IHEAP[e],IHEAP[d]);IHEAP[h]=t;t=_calloc(IHEAP[r]+1,4);o=0;x=o<IHEAP[r];w=IHEAP[e];b:do if(x){var E=t;for(a=16;;){N=_png_get_rowbytes(a==16?w:N,IHEAP[d]);N=_malloc(N);IHEAP[E+4*o]=N;o+=1;var N=IHEAP[e];if(o<IHEAP[r])c=a=17;else{a=
17;c=18;break b}}}else a=39;while(0);_png_read_image(a==39?w:N,t);_llvm_memset_p0i8_i32(y,0,144,1,0);x=IHEAP[f+18188];w=IHEAP[f+18192];o=0;if(o<v){E=IHEAP[h];A=IHEAP[h];C=x;z=w;var Q=IHEAP[p],S=IHEAP[r];a=v;o=o;var P=o+1;P=(a>P?a:P)-o;for(a=19;;){M=a==19?0:M;a=o+M;c=y+a*36+12;var G=y+a*36+8,F=y+a*36+4,L=y+a*36,K=y+a*36+32,H=y+a*36+28;IHEAP[y+a*36+24]=E;IHEAP[H]=A;IHEAP[K]=0;IHEAP[L]=C;IHEAP[F]=z;IHEAP[G]=Q;IHEAP[c]=S;var M=M+1;if(M!=P)c=a=20;else{c=21;break}}}v=o=_opj_image_create(v,y,1);if(o==0){c=
4;break a}IHEAP[v]=IHEAP[f+18180];IHEAP[v+4]=IHEAP[f+18184];IHEAP[v+8]=IHEAP[v]+1+(IHEAP[p]-1)*x+IHEAP[v];IHEAP[v+12]=IHEAP[v+4]+1+(IHEAP[r]-1)*w+IHEAP[v+4];C=IHEAP[IHEAP[v+24]+44];z=IHEAP[IHEAP[v+24]+48+44];a=IHEAP[IHEAP[v+24]+96+44];A=IHEAP[IHEAP[v+24]+144+44];o=0;if(!(o<IHEAP[r])){c=4;break a}for(;;){c=IHEAP[t+4*o];if(0<IHEAP[p]){x=s!=0;w=u!=0;E=u!=0;A=A;C=C;z=z;Q=a;a=25;c:for(;;){W=a==25?0:W;Z=a==25?Q:Z;Y=a==25?z:Y;$=a==25?C:$;U=a==25?A:U;S=1+W;P=c;d:do if(x){var I=$+4;IHEAP[$]=IHEAP[c+1]|IHEAP[P]<<
8;c+=2;var O=Y+4;IHEAP[Y]=IHEAP[c+1]|IHEAP[c]<<8;c+=2;var R=Z+4;IHEAP[Z]=IHEAP[c+1]|IHEAP[c]<<8;c+=2;if(!w){a=27;break d}var T=U+4;IHEAP[U]=IHEAP[c+1]|IHEAP[c]<<8;c+=2;a=28}else{c=P+1;var V=$+4;IHEAP[$]=IHEAP[P];var ba=c;c=ba+1;var fa=Y+4;IHEAP[Y]=IHEAP[ba];a=c;c=a+1;ba=Z+4;IHEAP[Z]=IHEAP[a];if(!E){a=31;break d}a=c;c=a+1;var ca=U+4;IHEAP[U]=IHEAP[a];a=32}while(0);var U=a==31?U:a==32?ca:a==27?U:T,$=a==31?V:a==32?V:a==27?I:I,Y=a==31?fa:a==32?fa:a==27?O:O,Z=a==31?ba:a==32?ba:a==27?R:R,W=W+1;if(S<IHEAP[p])a=
29;else break c}a=Z;z=Y;C=$;A=U}o+=1;if(o<IHEAP[r])c=24;else{c=4;break a}}}while(0);c==1&&_fprintf(IHEAP[_stderr],__str60144,b);if(t!=0){o=0;g=o<IHEAP[r];a:do if(g)for(h=t;;){_free(IHEAP[h+4*o]);o+=1;if(!(o<IHEAP[r]))break a}while(0);_free(t)}IHEAP[e]!=0&&_png_destroy_read_struct(e,d,0);_fclose(D);d=v}d=d;STACKTOP=e;return d}_pngtoimage.__index__=Runtime.getFunctionIndex(_pngtoimage,"_pngtoimage");
function _imagetopng(b,f){var e=STACKTOP;STACKTOP+=13;_memset(e,0,13);var c,a=null,d,g=e+4,h,i,j,k,m,l,n,o,p,r,q,u,s,t,v,y,x,w,C,z,A,B=e+8;A=-1;x=C=z=0;v=1;var D=IHEAP[IHEAP[b+24]+24];w=D;if(w>8&w<16){w=16;x=1}if(w!=1&w!=2&w!=4&w!=8&w!=16)_fprintf(IHEAP[_stderr],__str62146,f,w);else{d=_fopen(f,__str559);if(d!=0){n=IHEAP[g]=0;var J=_png_create_write_struct(__str61145,0,0,0);IHEAP[e]=J;J=IHEAP[e]==0;a:do if(!J){var E=_png_create_info_struct(IHEAP[e]);IHEAP[g]=E;E=IHEAP[g]==0;b:do if(!E){if(__setjmp(IHEAP[e])!=
0)break b;_png_init_io(IHEAP[e],d);_png_set_compression_level(IHEAP[e],9);r=w==16;c:do if(r)A=-1;else if(w==8)A=255;else if(w==4)A=15;else if(w==2)A=3;else{if(w!=1)break c;A=1}while(0);var N=IHEAP[b+16];r=N;o=N>=3;c:do if(o){o=IHEAP[IHEAP[b+24]]==IHEAP[IHEAP[b+24]+48];d:do if(o){if(IHEAP[IHEAP[b+24]+48]!=IHEAP[IHEAP[b+24]+96])break d;if(IHEAP[IHEAP[b+24]+4]!=IHEAP[IHEAP[b+24]+48+4])break d;if(IHEAP[IHEAP[b+24]+48+4]!=IHEAP[IHEAP[b+24]+96+4])break d;if(IHEAP[IHEAP[b+24]+24]!=IHEAP[IHEAP[b+24]+48+24])break d;
if(IHEAP[IHEAP[b+24]+48+24]!=IHEAP[IHEAP[b+24]+96+24])break d;n=r>3;y=w==16;o=IHEAP[IHEAP[b+24]+8];p=IHEAP[IHEAP[b+24]+12];h=IHEAP[IHEAP[b+24]+44];i=IHEAP[IHEAP[b+24]+48+44];j=IHEAP[IHEAP[b+24]+96+44];q=w&255;IHEAP[B+2]=q;IHEAP[B+1]=q;IHEAP[B]=q;if(n!=0){IHEAP[B+4]=w&255;k=IHEAP[IHEAP[b+24]+144+44];q=6}else{k=IHEAP[B+4]=0;q=2}_png_set_sBIT(IHEAP[e],IHEAP[g],B);_png_set_IHDR(IHEAP[e],IHEAP[g],o,p,w,q,0,0,0);_png_write_info(IHEAP[e],IHEAP[g]);D<8&&_png_set_packing(IHEAP[e]);if(x!=0){C=16-D;z=D-C}if(IHEAP[IHEAP[b+
24]+32]!=0){var Q=1<<IHEAP[IHEAP[b+24]+24]-1;a=16}else a=121;q=a==16?Q:0;if(IHEAP[IHEAP[b+24]+48+32]!=0){var S=1<<IHEAP[IHEAP[b+24]+48+24]-1;a=18}else a=122;u=a==18?S:0;if(IHEAP[IHEAP[b+24]+96+32]!=0){var P=1<<IHEAP[IHEAP[b+24]+96+24]-1;a=20}else a=123;s=a==20?P:0;m=_malloc(o*2*r);t=0;var G=t<p,F=m;e:do if(G){var L=A,K=A,H=A;c=A;a=22;for(;;){l=a==22?F:Na;a=0;if(a<o){Na=y!=0;var M=q,I=x!=0,O=C,R=z,T=u,V=x!=0,ba=C,fa=z,ca=s,U=x!=0,$=C,Y=z,Z=n!=0,W=x!=0,X=C,aa=z,ka=o,ga=u,ja=s,ia=n!=0;h=h;a=a;k=k;j=
j;i=i;var ea=a+1;ka=(ka>ea?ka:ea)-a;a=24;g:for(;;){Ba=a==24?0:Ba;ya=a==24?i:ya;na=a==24?j:na;va=a==24?k:va;ta=a==24?h:ta;ea=M+IHEAP[ta];h:do if(Na){a=ea;var oa=ta+4;if(I)a=(a>>R)+(a<<O);var pa=a>>8&255,da=l;l=da+1;IHEAP[da]=pa;pa=a&255;da=l;l=da+1;IHEAP[da]=pa;a=T+IHEAP[ya];pa=ya+4;if(V)a=(a>>fa)+(a<<ba);da=a>>8&255;var ha=l;l=ha+1;IHEAP[ha]=da;da=a&255;a=l;l=a+1;IHEAP[a]=da;a=ca+IHEAP[na];da=na+4;if(U)a=(a>>Y)+(a<<$);ha=a>>8&255;var qa=l;l=qa+1;IHEAP[qa]=ha;a=a&255;ha=l;l=ha+1;IHEAP[ha]=a;if(!Z){a=
29;break h}var wa=va+4;a=IHEAP[va];if(W)a=(a>>aa)+(a<<X);ha=a>>8&255;qa=l;l=qa+1;IHEAP[qa]=ha;a=a&255;ha=l;l=ha+1;IHEAP[ha]=a;a=33}else{var la=L&ea&255,ma=l;l=ma+1;IHEAP[ma]=la;la=ta+4;ma=K&ga+IHEAP[ya]&255;var ua=l;l=ua+1;IHEAP[ua]=ma;ma=ya+4;ua=H&ja+IHEAP[na]&255;a=l;l=a+1;IHEAP[a]=ua;ua=na+4;if(!ia){a=35;break h}var ra=c&IHEAP[va]&255;a=l;l=a+1;IHEAP[a]=ra;ra=va+4;a=36}while(0);var ta=a==35?la:a==36?la:a==29?oa:oa,va=a==35?va:a==36?ra:a==29?va:wa,na=a==35?ua:a==36?ua:a==29?da:da,ya=a==35?ma:a==
36?ma:a==29?pa:pa,Ba=Ba+1;if(Ba!=ka)a=31;else break g}i=ya;j=na;k=va;h=ta}_png_write_row(IHEAP[e],m);t+=1;var Na=m;if(t<p)a=39;else{a=39;break e}}}else a=96;while(0);_free(a==96?F:Na);c=41;break c}while(0);var Pa=r;a=8;c=42;break c}else{a=6;c=42}while(0);c:do if(c==42){o=(a==8?Pa:N)==1;d:do if(!o){o=r==2;e:do if(o){if(IHEAP[IHEAP[b+24]]!=IHEAP[IHEAP[b+24]+48])break e;if(IHEAP[IHEAP[b+24]+4]!=IHEAP[IHEAP[b+24]+48+4])break e;if(IHEAP[IHEAP[b+24]+24]==IHEAP[IHEAP[b+24]+48+24]){c=46;break d}}while(0);
_fprintf(IHEAP[_stderr],__str63147,f);break b}while(0);h=IHEAP[IHEAP[b+24]+44];if(x!=0){C=16-D;z=D-C}IHEAP[B+3]=w&255;IHEAP[B+4]=0;IHEAP[B+2]=0;IHEAP[B+1]=0;q=k=IHEAP[B]=0;if(r==2){n=1;IHEAP[B+4]=w&255;k=IHEAP[IHEAP[b+24]+48+44];q=4}o=IHEAP[IHEAP[b+24]+8];p=IHEAP[IHEAP[b+24]+12];_png_set_IHDR(IHEAP[e],IHEAP[g],o,p,IHEAP[B+3],q,0,0,0);_png_set_sBIT(IHEAP[e],IHEAP[g],B);_png_write_info(IHEAP[e],IHEAP[g]);if(IHEAP[IHEAP[b+24]+32]!=0){var Ja=1<<IHEAP[IHEAP[b+24]+24]-1;a=50}else a=136;q=a==50?Ja:0;D<8&&
_png_set_packing(IHEAP[e]);m=o;t=r;if(w>8){m=_malloc(m*2*t);t=0;y=m;if(t<p){a=53;c=54}else{a=53;c=55}for(;;)if(c==54){l=a==78?za:y;a=0;if(a<o){za=q;F=C;L=z;c=n!=0;M=x!=0;K=C;H=z;G=o;u=h;I=a;s=k;O=I+1;G=(G>O?G:O)-I;if(x!=0)if(M){if(c){a=56;c=57}else{a=56;c=58}for(;;)if(c==57){Ya=a==57?Ya:0;c=a==57?xa:s;xa=za+IHEAP[u+4*Ya];xa=(xa>>L)+(xa<<F);M=xa>>8&255;I=l;l=I+1;IHEAP[I]=M;xa=xa&255&255;M=l;l=M+1;IHEAP[M]=xa;var xa=c+4;c=IHEAP[c];c=(c>>H)+(c<<K);M=c>>8&255;I=l;l=I+1;IHEAP[I]=M;c=c&255&255;M=l;l=M+
1;IHEAP[M]=c;var Ya=Ya+1;if(Ya!=G)c=a=57;else{a=57;c=59;break}}else if(c==58){$a=a==58?$a:0;c=za+IHEAP[u+4*$a];c=(c>>L)+(c<<F);M=c>>8&255;I=l;l=I+1;IHEAP[I]=M;c=c&255&255;M=l;l=M+1;IHEAP[M]=c;var $a=$a+1;if($a!=G)c=a=58;else{a=58;c=61;break}}if(c==59){var db=u+4*G;a=59}else if(c==61){var Ta=u+4*G;a=61}}else{if(c){a=62;c=63}else{a=62;c=64}for(;;)if(c==63){Ga=a==63?Ga:0;K=a==63?Ma:s;Ma=za+IHEAP[u+4*Ga];Ma=(Ma>>L)+(Ma<<F);H=Ma>>8&255;c=l;l=c+1;IHEAP[c]=H;Ma=Ma&255&255;H=l;l=H+1;IHEAP[H]=Ma;var Ma=K+
4;K=IHEAP[K];H=K>>8&255;c=l;l=c+1;IHEAP[c]=H;K=K&255&255;H=l;l=H+1;IHEAP[H]=K;var Ga=Ga+1;if(Ga!=G)c=a=63;else{a=63;c=65;break}}else if(c==64){Ca=a==64?Ca:0;K=za+IHEAP[u+4*Ca];K=(K>>L)+(K<<F);H=K>>8&255;c=l;l=c+1;IHEAP[c]=H;K=K&255&255;H=l;l=H+1;IHEAP[H]=K;var Ca=Ca+1;if(Ca!=G)c=a=64;else{a=64;c=66;break}}if(c==65){var Ka=u+4*G;a=65}else if(c==66){var Ra=u+4*G;a=66}}else if(M){if(c){a=67;c=68}else{a=67;c=69}for(;;)if(c==68){Ia=a==68?Ia:0;F=a==68?Oa:s;Oa=za+IHEAP[u+4*Ia];L=Oa>>8&255;c=l;l=c+1;IHEAP[c]=
L;Oa=Oa&255&255;L=l;l=L+1;IHEAP[L]=Oa;var Oa=F+4;F=IHEAP[F];F=(F>>H)+(F<<K);L=F>>8&255;c=l;l=c+1;IHEAP[c]=L;F=F&255&255;L=l;l=L+1;IHEAP[L]=F;var Ia=Ia+1;if(Ia!=G)c=a=68;else{a=68;c=70;break}}else if(c==69){Sa=a==69?Sa:0;F=za+IHEAP[u+4*Sa];L=F>>8&255;c=l;l=c+1;IHEAP[c]=L;F=F&255&255;L=l;l=L+1;IHEAP[L]=F;var Sa=Sa+1;if(Sa!=G)c=a=69;else{a=69;c=71;break}}if(c==70){var Aa=u+4*G;a=70}else if(c==71){var La=u+4*G;a=71}}else{if(c){a=72;c=73}else{a=72;c=74}for(;;)if(c==73){Ha=a==73?Ha:0;F=a==73?Ea:s;Ea=za+
IHEAP[u+4*Ha];L=Ea>>8&255;K=l;l=K+1;IHEAP[K]=L;Ea=Ea&255&255;L=l;l=L+1;IHEAP[L]=Ea;var Ea=F+4;F=IHEAP[F];L=F>>8&255;K=l;l=K+1;IHEAP[K]=L;F=F&255&255;L=l;l=L+1;IHEAP[L]=F;var Ha=Ha+1;if(Ha!=G)c=a=73;else{a=73;c=75;break}}else if(c==74){Qa=a==74?Qa:0;F=za+IHEAP[u+4*Qa];L=F>>8&255;K=l;l=K+1;IHEAP[K]=L;F=F&255&255;L=l;l=L+1;IHEAP[L]=F;var Qa=Qa+1;if(Qa!=G)c=a=74;else{a=74;c=76;break}}if(c==75){var Da=u+4*G;a=75}else if(c==76){var eb=u+4*G;a=76}}l=a==61?Ta:a==59?db:a==66?Ra:a==65?Ka:a==71?La:a==70?Aa:
a==76?eb:Da;k=a==61?s:a==59?xa:a==66?s:a==65?Ma:a==71?s:a==70?Oa:a==76?s:Ea;h=l}_png_write_row(IHEAP[e],m);t+=1;var za=m;if(t<p){a=78;c=54}else{a=78;c=55}}else if(c==55){_free(a==53?y:za);break c}}else{m=_calloc(m,t*2);t=0;y=t<p;u=m;d:do if(y){G=s=A;a=79;for(;;){l=a==79?u:jb;a=0;if(a<o){jb=q;K=o;F=h;H=a;L=k;c=H+1;K=(K>c?K:c)-H;if(n!=0){a=81;c=82}else{a=81;c=83}for(;;)if(c==82){Ua=a==82?Ua:0;Wa=a==82?Wa:L;H=s&jb+IHEAP[F+4*Ua]&255;c=l;l=c+1;IHEAP[c]=H;H=G&IHEAP[Wa]&255;c=l;l=c+1;IHEAP[c]=H;var Wa=Wa+
4,Ua=Ua+1;if(Ua!=K)c=a=82;else{a=82;c=84;break}}else if(c==83){ab=a==83?ab:0;H=s&jb+IHEAP[F+4*ab]&255;c=l;l=c+1;IHEAP[c]=H;var ab=ab+1;if(ab!=K)c=a=83;else{a=83;c=86;break}}if(c==84){var tb=F+4*K;a=84}else if(c==86){var Ab=F+4*K;a=86}l=a==86?Ab:tb;k=a==86?L:Wa;h=l}_png_write_row(IHEAP[e],m);t+=1;var jb=m;if(t<p){a=88;c=80}else{a=88;c=89;break d}}}else a=97;while(0);_free(a==97?u:jb)}}while(0);_png_write_end(IHEAP[e],IHEAP[g]);v=0}while(0);if(IHEAP[e]==0)break a;_png_destroy_write_struct(e,g)}while(0);
_fclose(d);v!=0&&_remove(f)}}d=v;STACKTOP=e;return d}_imagetopng.__index__=Runtime.getFunctionIndex(_imagetopng,"_imagetopng");
function _color_sycc_to_rgb(b){var f,e=null,c,a,d,g,h,i,j,k,m,l,n,o,p,r,q,u,s,t,v,y,x,w,C,z,A,B,D,J,E,N,Q,S,P,G,F,L,K,H;if(IHEAP[b+16]<3)IHEAP[b+20]=2;else{e=IHEAP[IHEAP[b+24]]==1;a:do if(e){if(IHEAP[IHEAP[b+24]+48]!=2){f=1;break a}if(IHEAP[IHEAP[b+24]+96]!=2){f=1;break a}if(IHEAP[IHEAP[b+24]+4]!=1){f=1;break a}if(IHEAP[IHEAP[b+24]+48+4]!=2){f=1;break a}if(IHEAP[IHEAP[b+24]+96+4]!=2){f=1;break a}D=b;e=IHEAP[IHEAP[D+24]+24];K=1<<e-1;H=(1<<e)-1;L=IHEAP[IHEAP[D+24]+8];x=IHEAP[IHEAP[D+24]+12];e=x*L;G=
IHEAP[IHEAP[D+24]+44];f=IHEAP[IHEAP[D+24]+48+44];F=IHEAP[IHEAP[D+24]+96+44];v=Q=v=_malloc(e*4);E=S=E=_malloc(e*4);N=P=e=_malloc(e*4);e=0;if(e<x){var M=L,I=L,O=L,R=L,T=K,V=H,ba=K,fa=H,ca=K,U=H;K=K;H=H;var $=L,Y=L,Z=L,W=L,X=L,aa=x;G=G;Q=Q;S=S;P=P;F=F;var ka=f,ga=0<L,ja=M+1,ia=I+1,ea=O+1,oa=R+1,pa=e+2;e=6;b:for(;;){var da=e==6?0:B,ha=e==6?ka:A,qa=e==6?F:u,wa=e==6?P:Ra,la=e==6?S:Ka,ma=e==6?Q:t,ua=e==6?G:s,ra=pa+da*2;if(ga){e=7;f=8}else{e=7;f=9}for(;;)if(f==8){e=e==8?Ca:0;y=e+1;z=ha+4*y;y=qa+4*y;f=e*2;
C=f+1;Ca=ua+4*C;var ta=ma+4*C,va=la+4*C,na=wa+4*C,ya=ua+4*(ja+f),Ba=ma+4*(ia+f),Na=la+4*(ea+f),Pa=wa+4*(oa+f),Ja=f+2;C=ua+4*Ja;w=ma+4*Ja;J=la+4*Ja;var xa=wa+4*Ja,Ya=ua+4*(M+f),$a=ma+4*(I+f),db=la+4*(O+f),Ta=wa+4*(R+f),Ma=ha+4*e,Ga=qa+4*e;_sycc_to_rgb(T,V,IHEAP[ua+4*f],IHEAP[Ma],IHEAP[Ga],ma+4*f,la+4*f,wa+4*f);_sycc_to_rgb(ba,fa,IHEAP[Ca],IHEAP[Ma],IHEAP[Ga],ta,va,na);_sycc_to_rgb(ca,U,IHEAP[Ya],IHEAP[Ma],IHEAP[Ga],$a,db,Ta);_sycc_to_rgb(K,H,IHEAP[ya],IHEAP[Ma],IHEAP[Ga],Ba,Na,Pa);var Ca=e+1;if(Ja<
$)f=e=8;else{e=8;f=9}}else if(f==9){A=e==7?ha:z;u=e==7?qa:y;s=(e==7?ua:C)+4*Y;t=(e==7?ma:w)+4*Z;var Ka=(e==7?la:J)+4*W,Ra=(e==7?wa:xa)+4*X;B=da+1;if(ra<aa){e=9;continue b}else break b}}}_free(IHEAP[IHEAP[D+24]+44]);IHEAP[IHEAP[D+24]+44]=v;_free(IHEAP[IHEAP[D+24]+48+44]);IHEAP[IHEAP[D+24]+48+44]=E;_free(IHEAP[IHEAP[D+24]+96+44]);IHEAP[IHEAP[D+24]+96+44]=N;IHEAP[IHEAP[D+24]+48+8]=L;IHEAP[IHEAP[D+24]+48+12]=x;IHEAP[IHEAP[D+24]+96+8]=L;IHEAP[IHEAP[D+24]+96+12]=x;IHEAP[IHEAP[D+24]+48]=IHEAP[IHEAP[D+24]];
IHEAP[IHEAP[D+24]+96]=IHEAP[IHEAP[D+24]];IHEAP[IHEAP[D+24]+48+4]=IHEAP[IHEAP[D+24]+4];IHEAP[IHEAP[D+24]+96+4]=IHEAP[IHEAP[D+24]+4];f=12;break a}else f=1;while(0);a:do if(f==1){e=IHEAP[IHEAP[b+24]]==1;b:do if(e){if(IHEAP[IHEAP[b+24]+48]!=2)break b;if(IHEAP[IHEAP[b+24]+96]!=2)break b;if(IHEAP[IHEAP[b+24]+4]!=1)break b;if(IHEAP[IHEAP[b+24]+48+4]!=1)break b;if(IHEAP[IHEAP[b+24]+96+4]!=1)break b;q=b;J=IHEAP[IHEAP[q+24]+24];B=1<<J-1;D=(1<<J)-1;z=IHEAP[IHEAP[q+24]+8];A=IHEAP[IHEAP[q+24]+12];t=A*z;e=IHEAP[IHEAP[q+
24]+44];w=IHEAP[IHEAP[q+24]+48+44];C=IHEAP[IHEAP[q+24]+96+44];u=v=u=_malloc(t*4);s=y=s=_malloc(t*4);t=x=t=_malloc(t*4);J=0;if(J<A){Ka=B;Ra=D;B=B;D=D;L=z;E=A;N=J;x=x;y=y;v=v;C=C;w=w;J=e;xa=0<z;e=N+1;E=(E>e?E:e)-N;e=19;c:for(;;){N=e==19?0:h;M=e==19?J:a;I=e==19?w:d;O=e==19?C:g;R=e==19?v:p;T=e==19?y:r;V=e==19?x:k;if(xa){e=20;f=21}else{e=20;f=22}for(;;)if(f==21){n=e==21?n:0;i=n+1;c=I+4*i;i=O+4*i;e=n*2;j=e+1;ba=M+4*j;fa=R+4*j;ca=T+4*j;f=V+4*j;U=e+2;j=M+4*U;o=R+4*U;m=T+4*U;l=V+4*U;K=I+4*n;H=O+4*n;_sycc_to_rgb(Ka,
Ra,IHEAP[M+4*e],IHEAP[K],IHEAP[H],R+4*e,T+4*e,V+4*e);_sycc_to_rgb(B,D,IHEAP[ba],IHEAP[K],IHEAP[H],fa,ca,f);n=n+1;if(U<L)f=e=21;else{e=21;f=22}}else if(f==22){a=e==20?M:j;d=e==20?I:c;g=e==20?O:i;p=e==20?R:o;r=e==20?T:m;k=e==20?V:l;h=N+1;if(h!=E){e=22;continue c}else break c}}}_free(IHEAP[IHEAP[q+24]+44]);IHEAP[IHEAP[q+24]+44]=u;_free(IHEAP[IHEAP[q+24]+48+44]);IHEAP[IHEAP[q+24]+48+44]=s;_free(IHEAP[IHEAP[q+24]+96+44]);IHEAP[IHEAP[q+24]+96+44]=t;IHEAP[IHEAP[q+24]+48+8]=z;IHEAP[IHEAP[q+24]+48+12]=A;IHEAP[IHEAP[q+
24]+96+8]=z;IHEAP[IHEAP[q+24]+96+12]=A;IHEAP[IHEAP[q+24]+48]=IHEAP[IHEAP[q+24]];IHEAP[IHEAP[q+24]+96]=IHEAP[IHEAP[q+24]];IHEAP[IHEAP[q+24]+48+4]=IHEAP[IHEAP[q+24]+4];IHEAP[IHEAP[q+24]+96+4]=IHEAP[IHEAP[q+24]+4];break a}while(0);c=IHEAP[IHEAP[b+24]]==1;b:do if(c){if(IHEAP[IHEAP[b+24]+48]!=1)break b;if(IHEAP[IHEAP[b+24]+96]!=1)break b;if(IHEAP[IHEAP[b+24]+4]!=1)break b;if(IHEAP[IHEAP[b+24]+48+4]!=1)break b;if(IHEAP[IHEAP[b+24]+96+4]!=1)break b;c=b;o=IHEAP[IHEAP[c+24]+24];p=1<<o-1;r=(1<<o)-1;a=IHEAP[IHEAP[c+
24]+8];d=IHEAP[IHEAP[c+24]+12];n=d*a;k=IHEAP[IHEAP[c+24]+44];m=IHEAP[IHEAP[c+24]+48+44];l=IHEAP[IHEAP[c+24]+96+44];a=h=a=_malloc(n*4);d=i=d=_malloc(n*4);g=j=g=_malloc(n*4);o=0;if(o<n){p=p;r=r;n=n;k=k;m=m;l=l;h=h;i=i;j=j;o=o;e=o+1;o=(n>e?n:e)-o;for(e=31;;){n=e==31?0:q;_sycc_to_rgb(p,r,IHEAP[k+4*n],IHEAP[m+4*n],IHEAP[l+4*n],h+4*n,i+4*n,j+4*n);q=n+1;if(q!=o)e=32;else break}}_free(IHEAP[IHEAP[c+24]+44]);IHEAP[IHEAP[c+24]+44]=a;_free(IHEAP[IHEAP[c+24]+48+44]);IHEAP[IHEAP[c+24]+48+44]=d;_free(IHEAP[IHEAP[c+
24]+96+44]);IHEAP[IHEAP[c+24]+96+44]=g;break a}while(0);_fprintf(IHEAP[_stderr],__str96,__str197,256);return}while(0);IHEAP[b+20]=1}}_color_sycc_to_rgb.__index__=Runtime.getFunctionIndex(_color_sycc_to_rgb,"_color_sycc_to_rgb");
function _sycc_to_rgb(b,f,e,c,a,d,g,h){c=c;a=a;c-=b;a-=b;b=(1.402*a|0)+e;var i=b<0;a:do if(i)b=0;else{if(!(b>f))break a;b=f}while(0);IHEAP[d]=b;d=b=e-(0.344*c+0.714*a|0);b=b<0;a:do if(b)d=0;else{if(!(d>f))break a;d=f}while(0);IHEAP[g]=d;e=g=(1.772*c|0)+e;g=g<0;a:do if(g)e=0;else{if(!(e>f))break a;e=f}while(0);IHEAP[h]=e}_sycc_to_rgb.__index__=Runtime.getFunctionIndex(_sycc_to_rgb,"_sycc_to_rgb");function _reset_options_reading(){IHEAP[_opterr]=1;IHEAP[_optind]=1}
_reset_options_reading.__index__=Runtime.getFunctionIndex(_reset_options_reading,"_reset_options_reading");
function _getopt(b,f,e){var c,a,d,g=IHEAP[_optreset]!=0;a:do if(g)c=1;else{c=IHEAP[IHEAP[_getopt_place]]!=0?0:1;break a}while(0);a:do if(c==1){IHEAP[_optreset]=0;c=IHEAP[_optind]>=b;b:do if(!c){c=IHEAP[f+4*IHEAP[_optind]];IHEAP[_getopt_place]=c;if(IHEAP[c]!=45)break b;if(IHEAP[IHEAP[_getopt_place]+1]==0){c=0;break a}c=IHEAP[_getopt_place]+1;IHEAP[_getopt_place]=c;if(IHEAP[c]!=45){c=0;break a}IHEAP[_optind]+=1;IHEAP[_getopt_place]=__str98;a=-1;c=4;break a}while(0);IHEAP[_getopt_place]=__str98;a=-1;
c=4;break a}while(0);a:do if(c==0){c=IHEAP[_getopt_place];IHEAP[_getopt_place]=c+1;c=IHEAP[c];IHEAP[_optopt]=c;a=c==58;b:do if(a)c=10;else{c=IHEAP[_optopt];d=a=_strchr(e,c);if(a!=0){c=7;break b}if(c!=45){c=10;break b}a=-1;break a}while(0);b:do if(c==10){if(IHEAP[IHEAP[_getopt_place]]==0)IHEAP[_optind]+=1;if(IHEAP[_opterr]==0){c=7;break b}if(IHEAP[e]==58){c=7;break b}_fprintf(IHEAP[_stderr],__str199,IHEAP[f],IHEAP[_optopt]);a=63;break a}while(0);d=a=d+1;a=IHEAP[a]!=58;b:do{if(a){IHEAP[_optarg]=0;if(IHEAP[IHEAP[_getopt_place]]!=
0){c=14;break b}}else{g=IHEAP[IHEAP[_getopt_place]]!=0;c:do if(g)IHEAP[_optarg]=IHEAP[_getopt_place];else{var h=b,i=IHEAP[_optind]+1;IHEAP[_optind]=i;if(h<=i){IHEAP[_getopt_place]=__str98;if(IHEAP[e]==58)a=58;else{if(IHEAP[_opterr]==0){c=19;break c}_fprintf(IHEAP[_stderr],__str2100,IHEAP[f],IHEAP[_optopt]);a=63}break a}else IHEAP[_optarg]=IHEAP[f+4*IHEAP[_optind]]}while(0);IHEAP[_getopt_place]=__str98}IHEAP[_optind]+=1}while(0);a=IHEAP[_optopt]}while(0);return a}
_getopt.__index__=Runtime.getFunctionIndex(_getopt,"_getopt");
function _getopt_long(b,f,e,c,a){var d,g=null,h,i,j,k=b-1;g=0;a:for(;;){d=g==40?l:1;if(IHEAP[_optind]>=b){d=2;break a}if(IHEAP[f+4*IHEAP[_optind]]==0){d=2;break a}if(IHEAP[IHEAP[f+4*IHEAP[_optind]]]!=45){d=2;break a}var m=IHEAP[IHEAP[f+4*IHEAP[_optind]]]==45;b:do if(m){if(IHEAP[IHEAP[f+4*IHEAP[_optind]]+1]!=0){g=7;break b}if(IHEAP[_optind]>=k){g=8;break b}if(IHEAP[IHEAP[f+4*(IHEAP[_optind]+1)]]==45){g=10;break b}g=11}else g=5;while(0);var l=g==11?2:g==7?d:g==5?d:g==8?0:0;m=IHEAP[_optind];if(l==0){d=
13;break a}if(IHEAP[IHEAP[f+4*m]]!=45){d=16;break a}j=c;i=16;var n=IHEAP[_optind];if(l>1){var o=IHEAP[f+4*(n+1)];IHEAP[_optind]+=1;g=17}else{var p=IHEAP[f+4*n]+1;g=19}n=g==19?p:o;if(_strlen(n)>1){d=20;break a}if(IHEAP[e]==58){d=35;break a}if(IHEAP[_getopt_long_lastidx]!=IHEAP[_optind]){IHEAP[_getopt_long_lastidx]=IHEAP[_optind];IHEAP[_getopt_long_lastofs]=0}IHEAP[_optopt]=IHEAP[IHEAP[f+4*IHEAP[_optind]]+(IHEAP[_getopt_long_lastofs]+1)];var r=_strchr(e,IHEAP[_optopt]);if(r==0){d=39;break a}if(IHEAP[r]!=
0){d=41;break a}IHEAP[_optind]+=1;g=40;d=1}a:do if(d==2)h=-1;else if(d==13){IHEAP[_optind]=m+1;h=63}else if(d==16){_fwrite(__str7105,15,1,IHEAP[_stderr]);IHEAP[_optind]+=1;h=63}else if(d==20){b=n;e=a;c=b;k=i;o=j;g=20;b:for(;;){d=g==25?u:0;var q=o+16*d;g=q;if(!(0+k*d<e)){d=24;break b}if(_strcmp(IHEAP[g],c)==0){d=26;break b}var u=d+1;g=25;d=22}if(d==24){j=q;_fprintf(IHEAP[_stderr],__str6104,b);IHEAP[_optind]+=1;h=63}else if(d==26){j=q;h=IHEAP[j+4]==0;g=IHEAP[f+4*(IHEAP[_optind]+1)];b:do{if(h){if(g==
0){d=28;break b}if(IHEAP[IHEAP[f+4*(IHEAP[_optind]+1)]]==45){d=28;break b}_fprintf(IHEAP[_stderr],__str3101,b,IHEAP[f+4*(IHEAP[_optind]+1)])}else{IHEAP[_optarg]=g;e=IHEAP[_optarg]!=0;c:do if(e)if(IHEAP[IHEAP[_optarg]]==45&IHEAP[_opterr]!=0){_fprintf(IHEAP[_stderr],__str4102,b);h=63;break a}else{d=IHEAP[_optarg]!=0?32:33;break c}else d=33;while(0);c:do if(d==33){if(!(IHEAP[j+4]==1&IHEAP[_opterr]!=0)){d=32;break c}_fprintf(IHEAP[_stderr],__str5103,b);h=63;break a}while(0)}IHEAP[_optind]+=1}while(0);
IHEAP[_optind]+=1;h=IHEAP[j+12];if(IHEAP[j+8]!=0){IHEAP[IHEAP[j+8]]=h;h=0}else h=h}}else if(d==35)h=58;else if(d==39){b=n;_fprintf(IHEAP[_stderr],__str6104,b);IHEAP[_optind]+=1;h=63}else if(d==41){b=n;h=r;if(IHEAP[h+1]==58){h=IHEAP[h+2]==58;b:do if(h)d=42;else{if(IHEAP[IHEAP[f+4*IHEAP[_optind]]+(IHEAP[_getopt_long_lastofs]+2)]!=0){d=42;break b}IHEAP[_optarg]=IHEAP[f+4*(IHEAP[_optind]+1)];d=IHEAP[_optarg]!=0;c:do if(d){if(!(IHEAP[IHEAP[_optarg]]==45&IHEAP[_opterr]!=0))break c;_fprintf(IHEAP[_stderr],
__str4102,b);h=63;break a}while(0);if((IHEAP[_optarg]!=0^1)&IHEAP[_opterr]!=0){_fprintf(IHEAP[_stderr],__str4102,b);h=63;break a}else{IHEAP[_optind]+=1;d=44;break b}}while(0);b:do if(d==42){h=IHEAP[f+4*IHEAP[_optind]]+IHEAP[_getopt_long_lastofs]+2;IHEAP[_optarg]=h;if(IHEAP[h]!=0){d=44;break b}IHEAP[_optarg]=0}while(0);IHEAP[_optind]+=1}else IHEAP[_getopt_long_lastofs]+=1;h=IHEAP[_optopt]}while(0);return h}_getopt_long.__index__=Runtime.getFunctionIndex(_getopt_long,"_getopt_long");
function callMain(b){function f(){for(var d=0;d<3;d++)c.push(0)}var e=b.length+1,c=[Pointer_make(intArrayFromString("/bin/this.program"),null)];f();for(var a=0;a<e-1;a+=1){c.push(Pointer_make(intArrayFromString(b[a]),null));f()}c.push(0);c=Pointer_make(c,null);Module._main(e,c)}Module.callMain=callMain;
function run(){__initializeRuntime__();__str=Pointer_make([72,69,76,80,32,102,111,114,32,106,50,107,95,116,111,95,105,109,97,103,101,10,45,45,45,45,10,10,0],0,ALLOC_STATIC);__str1=Pointer_make([45,32,116,104,101,32,45,104,32,111,112,116,105,111,110,32,100,105,115,112,108,97,121,115,32,116,104,105,115,32,104,101,108,112,32,105,110,102,111,114,109,97,116,105,111,110,32,111,110,32,115,99,114,101,101,110,10,10,0],0,ALLOC_STATIC);__str2=Pointer_make([76,105,115,116,32,111,102,32,112,97,114,97,109,101,
116,101,114,115,32,102,111,114,32,116,104,101,32,74,80,69,71,32,50,48,48,48,32,100,101,99,111,100,101,114,58,10,0],0,ALLOC_STATIC);__str4=Pointer_make([32,32,45,73,109,103,68,105,114,32,10,0],0,ALLOC_STATIC);__str5=Pointer_make([9,73,109,97,103,101,32,102,105,108,101,32,68,105,114,101,99,116,111,114,121,32,112,97,116,104,32,10,0],0,ALLOC_STATIC);__str6=Pointer_make([32,32,45,79,117,116,70,111,114,32,10,0],0,ALLOC_STATIC);__str7=Pointer_make([32,32,32,32,82,69,81,85,73,82,69,68,32,111,110,108,121,
32,105,102,32,45,73,109,103,68,105,114,32,105,115,32,117,115,101,100,10,0],0,ALLOC_STATIC);__str8=Pointer_make([9,32,32,78,101,101,100,32,116,111,32,115,112,101,99,105,102,121,32,111,110,108,121,32,102,111,114,109,97,116,32,119,105,116,104,111,117,116,32,102,105,108,101,110,97,109,101,32,60,66,77,80,62,32,32,10,0],0,ALLOC_STATIC);__str9=Pointer_make([32,32,32,32,67,117,114,114,101,110,116,108,121,32,97,99,99,101,112,116,115,32,80,71,77,44,32,80,80,77,44,32,80,78,77,44,32,80,71,88,44,32,80,78,71,44,
32,66,77,80,44,32,84,73,70,44,32,82,65,87,32,97,110,100,32,84,71,65,32,102,111,114,109,97,116,115,10,0],0,ALLOC_STATIC);__str10=Pointer_make([32,32,45,105,32,60,99,111,109,112,114,101,115,115,101,100,32,102,105,108,101,62,10,0],0,ALLOC_STATIC);__str11=Pointer_make([32,32,32,32,82,69,81,85,73,82,69,68,32,111,110,108,121,32,105,102,32,97,110,32,73,110,112,117,116,32,105,109,97,103,101,32,100,105,114,101,99,116,111,114,121,32,110,111,116,32,115,112,101,99,105,102,105,101,100,10,0],0,ALLOC_STATIC);__str12=
Pointer_make([32,32,32,32,67,117,114,114,101,110,116,108,121,32,97,99,99,101,112,116,115,32,74,50,75,45,102,105,108,101,115,44,32,74,80,50,45,102,105,108,101,115,32,97,110,100,32,74,80,84,45,102,105,108,101,115,46,32,84,104,101,32,102,105,108,101,32,116,121,112,101,10,0],0,ALLOC_STATIC);__str13=Pointer_make([32,32,32,32,105,115,32,105,100,101,110,116,105,102,105,101,100,32,98,97,115,101,100,32,111,110,32,105,116,115,32,115,117,102,102,105,120,46,10,0],0,ALLOC_STATIC);__str14=Pointer_make([32,32,45,
111,32,60,100,101,99,111,109,112,114,101,115,115,101,100,32,102,105,108,101,62,10,0],0,ALLOC_STATIC);__str15=Pointer_make([32,32,32,32,82,69,81,85,73,82,69,68,10,0],0,ALLOC_STATIC);__str16=Pointer_make([32,32,32,32,67,117,114,114,101,110,116,108,121,32,97,99,99,101,112,116,115,32,80,71,77,44,32,80,80,77,44,32,80,78,77,44,32,80,71,88,44,32,80,78,71,44,32,66,77,80,44,32,84,73,70,44,32,82,65,87,32,97,110,100,32,84,71,65,32,102,105,108,101,115,10,0],0,ALLOC_STATIC);__str17=Pointer_make([32,32,32,32,66,
105,110,97,114,121,32,100,97,116,97,32,105,115,32,119,114,105,116,116,101,110,32,116,111,32,116,104,101,32,102,105,108,101,32,40,110,111,116,32,97,115,99,105,105,41,46,32,73,102,32,97,32,80,71,88,10,0],0,ALLOC_STATIC);__str18=Pointer_make([32,32,32,32,102,105,108,101,110,97,109,101,32,105,115,32,103,105,118,101,110,44,32,116,104,101,114,101,32,119,105,108,108,32,98,101,32,97,115,32,109,97,110,121,32,111,117,116,112,117,116,32,102,105,108,101,115,32,97,115,32,116,104,101,114,101,32,97,114,101,10,0],
0,ALLOC_STATIC);__str19=Pointer_make([32,32,32,32,99,111,109,112,111,110,101,110,116,115,58,32,97,110,32,105,110,100,105,99,101,32,115,116,97,114,116,105,110,103,32,102,114,111,109,32,48,32,119,105,108,108,32,116,104,101,110,32,98,101,32,97,112,112,101,110,100,101,100,32,116,111,32,116,104,101,10,0],0,ALLOC_STATIC);__str20=Pointer_make([32,32,32,32,111,117,116,112,117,116,32,102,105,108,101,110,97,109,101,44,32,106,117,115,116,32,98,101,102,111,114,101,32,116,104,101,32,34,112,103,120,34,32,101,120,
116,101,110,115,105,111,110,46,32,73,102,32,97,32,80,71,77,32,102,105,108,101,110,97,109,101,10,0],0,ALLOC_STATIC);__str21=Pointer_make([32,32,32,32,105,115,32,103,105,118,101,110,32,97,110,100,32,116,104,101,114,101,32,97,114,101,32,109,111,114,101,32,116,104,97,110,32,111,110,101,32,99,111,109,112,111,110,101,110,116,44,32,111,110,108,121,32,116,104,101,32,102,105,114,115,116,32,99,111,109,112,111,110,101,110,116,10,0],0,ALLOC_STATIC);__str22=Pointer_make([32,32,32,32,119,105,108,108,32,98,101,
32,119,114,105,116,116,101,110,32,116,111,32,116,104,101,32,102,105,108,101,46,10,0],0,ALLOC_STATIC);__str23=Pointer_make([32,32,45,114,32,60,114,101,100,117,99,101,32,102,97,99,116,111,114,62,10,0],0,ALLOC_STATIC);__str24=Pointer_make([32,32,32,32,83,101,116,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,104,105,103,104,101,115,116,32,114,101,115,111,108,117,116,105,111,110,32,108,101,118,101,108,115,32,116,111,32,98,101,32,100,105,115,99,97,114,100,101,100,46,32,84,104,101,10,0],0,ALLOC_STATIC);
__str25=Pointer_make([32,32,32,32,105,109,97,103,101,32,114,101,115,111,108,117,116,105,111,110,32,105,115,32,101,102,102,101,99,116,105,118,101,108,121,32,100,105,118,105,100,101,100,32,98,121,32,50,32,116,111,32,116,104,101,32,112,111,119,101,114,32,111,102,32,116,104,101,10,0],0,ALLOC_STATIC);__str26=Pointer_make([32,32,32,32,110,117,109,98,101,114,32,111,102,32,100,105,115,99,97,114,100,101,100,32,108,101,118,101,108,115,46,32,84,104,101,32,114,101,100,117,99,101,32,102,97,99,116,111,114,32,105,
115,32,108,105,109,105,116,101,100,32,98,121,32,116,104,101,10,0],0,ALLOC_STATIC);__str27=Pointer_make([32,32,32,32,115,109,97,108,108,101,115,116,32,116,111,116,97,108,32,110,117,109,98,101,114,32,111,102,32,100,101,99,111,109,112,111,115,105,116,105,111,110,32,108,101,118,101,108,115,32,97,109,111,110,103,32,116,105,108,101,115,46,10,0],0,ALLOC_STATIC);__str28=Pointer_make([32,32,45,108,32,60,110,117,109,98,101,114,32,111,102,32,113,117,97,108,105,116,121,32,108,97,121,101,114,115,32,116,111,32,
100,101,99,111,100,101,62,10,0],0,ALLOC_STATIC);__str29=Pointer_make([32,32,32,32,83,101,116,32,116,104,101,32,109,97,120,105,109,117,109,32,110,117,109,98,101,114,32,111,102,32,113,117,97,108,105,116,121,32,108,97,121,101,114,115,32,116,111,32,100,101,99,111,100,101,46,32,73,102,32,116,104,101,114,101,32,97,114,101,10,0],0,ALLOC_STATIC);__str30=Pointer_make([32,32,32,32,108,101,115,115,32,113,117,97,108,105,116,121,32,108,97,121,101,114,115,32,116,104,97,110,32,116,104,101,32,115,112,101,99,105,
102,105,101,100,32,110,117,109,98,101,114,44,32,97,108,108,32,116,104,101,32,113,117,97,108,105,116,121,32,108,97,121,101,114,115,10,0],0,ALLOC_STATIC);__str31=Pointer_make([32,32,32,32,97,114,101,32,100,101,99,111,100,101,100,46,10,0],0,ALLOC_STATIC);__str32=Pointer_make([32,32,45,120,32,32,10,0],0,ALLOC_STATIC);__str33=Pointer_make([32,32,32,32,67,114,101,97,116,101,32,97,110,32,105,110,100,101,120,32,102,105,108,101,32,42,46,73,100,120,32,40,45,120,32,105,110,100,101,120,95,110,97,109,101,46,73,
100,120,41,32,10,0],0,ALLOC_STATIC);__str34=Pointer_make([67,111,117,108,100,32,110,111,116,32,111,112,101,110,32,70,111,108,100,101,114,32,37,115,10,0],0,ALLOC_STATIC);__str35=Pointer_make([46,0],0,ALLOC_STATIC);__str36=Pointer_make([46,46,0],0,ALLOC_STATIC);__str37=Pointer_make([70,111,108,100,101,114,32,111,112,101,110,101,100,32,115,117,99,99,101,115,115,102,117,108,108,121,10,0],0,ALLOC_STATIC);_get_file_format_extension=Pointer_make([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],0,ALLOC_STATIC);__str38=Pointer_make([112,103,120,0],0,ALLOC_STATIC);__str39=Pointer_make([112,110,109,0],0,ALLOC_STATIC);__str40=Pointer_make([112,103,109,0],0,ALLOC_STATIC);__str41=Pointer_make([112,112,109,0],0,ALLOC_STATIC);__str42=Pointer_make([98,109,112,0],0,ALLOC_STATIC);__str43=Pointer_make([116,105,102,0],0,ALLOC_STATIC);__str44=Pointer_make([114,97,119,0],0,ALLOC_STATIC);__str45=Pointer_make([116,103,97,0],0,ALLOC_STATIC);__str46=Pointer_make([112,
110,103,0],0,ALLOC_STATIC);__str47=Pointer_make([106,50,107,0],0,ALLOC_STATIC);__str48=Pointer_make([106,112,50,0],0,ALLOC_STATIC);__str49=Pointer_make([106,112,116,0],0,ALLOC_STATIC);__str50=Pointer_make([106,50,99,0],0,ALLOC_STATIC);__str51=Pointer_make([106,112,99,0],0,ALLOC_STATIC);_get_file_format_format=Pointer_make([11,0,0,0,10,0,0,0,10,0,0,0,10,0,0,0,12,0,0,0,14,0,0,0,15,0,0,0,16,0,0,0,17,0,0,0,0,0,0,0,1,0,0,0,2,0,0,0,0,0,0,0,0,0,0,0],0,ALLOC_STATIC);__str52=Pointer_make([70,105,108,101,32,
78,117,109,98,101,114,32,37,100,32,34,37,115,34,10,0],0,ALLOC_STATIC);__str53=Pointer_make([37,115,47,37,115,0],0,ALLOC_STATIC);__str54=Pointer_make([46,37,115,0],0,ALLOC_STATIC);__str55=Pointer_make([37,115,47,37,115,46,37,115,0],0,ALLOC_STATIC);__str56=Pointer_make([73,109,103,68,105,114,0],0,ALLOC_STATIC);__str57=Pointer_make([79,117,116,70,111,114,0],0,ALLOC_STATIC);_parse_cmdline_decoder_long_option=Pointer_make([0,0,0,0,1,0,0,0,0,0,0,0,121,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,79,0,0,0],0,ALLOC_STATIC);
_parse_cmdline_decoder_optlist=Pointer_make([105,58,111,58,114,58,108,58,120,58,104,0],0,ALLOC_STATIC);__str58=Pointer_make([33,33,32,85,110,114,101,99,111,103,110,105,122,101,100,32,102,111,114,109,97,116,32,102,111,114,32,105,110,102,105,108,101,32,58,32,37,115,32,91,97,99,99,101,112,116,32,111,110,108,121,32,42,46,106,50,107,44,32,42,46,106,112,50,44,32,42,46,106,112,99,32,111,114,32,42,46,106,112,116,93,32,33,33,10,10,0],0,ALLOC_STATIC);__str59=Pointer_make([85,110,107,110,111,119,110,32,111,
117,116,112,117,116,32,102,111,114,109,97,116,32,105,109,97,103,101,32,37,115,32,91,111,110,108,121,32,42,46,112,110,109,44,32,42,46,112,103,109,44,32,42,46,112,112,109,44,32,42,46,112,103,120,44,32,42,46,98,109,112,44,32,42,46,116,105,102,44,32,42,46,114,97,119,32,111,114,32,42,46,116,103,97,93,33,33,32,10,0],0,ALLOC_STATIC);__str60=Pointer_make([37,100,0],0,ALLOC_STATIC);__str61=Pointer_make([87,65,82,78,73,78,71,32,45,62,32,116,104,105,115,32,111,112,116,105,111,110,32,105,115,32,110,111,116,32,
118,97,108,105,100,32,34,45,37,99,32,37,115,34,10,0],0,ALLOC_STATIC);__str62=Pointer_make([69,114,114,111,114,58,32,111,112,116,105,111,110,115,32,45,73,109,103,68,105,114,32,97,110,100,32,45,105,32,99,97,110,110,111,116,32,98,101,32,117,115,101,100,32,116,111,103,101,116,104,101,114,32,33,33,10,0],0,ALLOC_STATIC);__str63=Pointer_make([69,114,114,111,114,58,32,87,104,101,110,32,45,73,109,103,68,105,114,32,105,115,32,117,115,101,100,44,32,45,79,117,116,70,111,114,32,60,70,79,82,77,65,84,62,32,109,
117,115,116,32,98,101,32,117,115,101,100,32,33,33,10,0],0,ALLOC_STATIC);__str64=Pointer_make([79,110,108,121,32,111,110,101,32,102,111,114,109,97,116,32,97,108,108,111,119,101,100,33,32,86,97,108,105,100,32,102,111,114,109,97,116,32,80,71,77,44,32,80,80,77,44,32,80,78,77,44,32,80,71,88,44,32,66,77,80,44,32,84,73,70,44,32,82,65,87,32,97,110,100,32,84,71,65,33,33,10,0],0,ALLOC_STATIC);__str65=Pointer_make([69,114,114,111,114,58,32,111,112,116,105,111,110,115,32,45,73,109,103,68,105,114,32,97,110,100,
32,45,111,32,99,97,110,110,111,116,32,98,101,32,117,115,101,100,32,116,111,103,101,116,104,101,114,32,33,33,10,0],0,ALLOC_STATIC);__str66=Pointer_make([69,120,97,109,112,108,101,58,32,37,115,32,45,105,32,105,109,97,103,101,46,106,50,107,32,45,111,32,105,109,97,103,101,46,112,103,109,10,0],0,ALLOC_STATIC);__str67=Pointer_make([32,32,32,32,84,114,121,58,32,37,115,32,45,104,10,0],0,ALLOC_STATIC);__str68=Pointer_make([91,69,82,82,79,82,93,32,37,115,0],0,ALLOC_STATIC);__str69=Pointer_make([91,87,65,82,
78,73,78,71,93,32,37,115,0],0,ALLOC_STATIC);__str70=Pointer_make([91,73,78,70,79,93,32,37,115,0],0,ALLOC_STATIC);__str71=Pointer_make([70,111,108,100,101,114,32,105,115,32,101,109,112,116,121,10,0],0,ALLOC_STATIC);__str72=Pointer_make([115,107,105,112,112,105,110,103,32,102,105,108,101,46,46,46,10,0],0,ALLOC_STATIC);__str73=Pointer_make([114,98,0],0,ALLOC_STATIC);__str74=Pointer_make([69,82,82,79,82,32,45,62,32,102,97,105,108,101,100,32,116,111,32,111,112,101,110,32,37,115,32,102,111,114,32,114,101,
97,100,105,110,103,10,0],0,ALLOC_STATIC);__str75=Pointer_make([69,82,82,79,82,32,45,62,32,106,50,107,95,116,111,95,105,109,97,103,101,58,32,102,97,105,108,101,100,32,116,111,32,100,101,99,111,100,101,32,105,109,97,103,101,33,10,0],0,ALLOC_STATIC);__str76=Pointer_make([70,97,105,108,101,100,32,116,111,32,111,117,116,112,117,116,32,105,110,100,101,120,32,102,105,108,101,10,0],0,ALLOC_STATIC);__str77=Pointer_make([115,107,105,112,112,105,110,103,32,102,105,108,101,46,46,10,0],0,ALLOC_STATIC);__str78=
Pointer_make([79,117,116,102,105,108,101,32,37,115,32,110,111,116,32,103,101,110,101,114,97,116,101,100,10,0],0,ALLOC_STATIC);__str79=Pointer_make([71,101,110,101,114,97,116,101,100,32,79,117,116,102,105,108,101,32,37,115,10,0],0,ALLOC_STATIC);__str80=Pointer_make([69,114,114,111,114,32,103,101,110,101,114,97,116,105,110,103,32,114,97,119,32,102,105,108,101,46,32,79,117,116,102,105,108,101,32,37,115,32,110,111,116,32,103,101,110,101,114,97,116,101,100,10,0],0,ALLOC_STATIC);__str81=Pointer_make([83,
117,99,99,101,115,115,102,117,108,108,121,32,103,101,110,101,114,97,116,101,100,32,79,117,116,102,105,108,101,32,37,115,10,0],0,ALLOC_STATIC);__str82=Pointer_make([69,114,114,111,114,32,103,101,110,101,114,97,116,105,110,103,32,116,103,97,32,102,105,108,101,46,32,79,117,116,102,105,108,101,32,37,115,32,110,111,116,32,103,101,110,101,114,97,116,101,100,10,0],0,ALLOC_STATIC);__str83=Pointer_make([69,114,114,111,114,32,103,101,110,101,114,97,116,105,110,103,32,112,110,103,32,102,105,108,101,46,32,79,
117,116,102,105,108,101,32,37,115,32,110,111,116,32,103,101,110,101,114,97,116,101,100,10,0],0,ALLOC_STATIC);__str84=Pointer_make([69,114,114,111,114,32,97,108,108,111,99,97,116,105,110,103,32,109,101,109,111,114,121,32,102,111,114,32,99,111,109,112,114,101,115,115,101,100,32,98,105,116,115,116,114,101,97,109,10,0],0,ALLOC_STATIC);__str185=Pointer_make([119,114,105,116,101,32,101,114,114,111,114,10,0],0,ALLOC_STATIC);__str286=Pointer_make([114,101,97,100,32,101,114,114,111,114,58,32,112,97,115,115,
101,100,32,116,104,101,32,101,110,100,32,111,102,32,116,104,101,32,99,111,100,101,115,116,114,101,97,109,32,40,115,116,97,114,116,32,61,32,37,100,44,32,99,117,114,114,101,110,116,32,61,32,37,100,44,32,101,110,100,32,61,32,37,100,10,0],0,ALLOC_STATIC);_dwt_norms=Pointer_make([1,0,0,0,0,0,0,0,1.5,0,0,0,0,0,0,0,2.75,0,0,0,0,0,0,0,5.375,0,0,0,0,0,0,0,10.68,0,0,0,0,0,0,0,21.34,0,0,0,0,0,0,0,42.67,0,0,0,0,0,0,0,85.33,0,0,0,0,0,0,0,170.7,0,0,0,0,0,0,0,341.3,0,0,0,0,0,0,0,1.038,0,0,0,0,0,0,0,1.592,0,0,0,
0,0,0,0,2.919,0,0,0,0,0,0,0,5.703,0,0,0,0,0,0,0,11.33,0,0,0,0,0,0,0,22.64,0,0,0,0,0,0,0,45.25,0,0,0,0,0,0,0,90.48,0,0,0,0,0,0,0,180.9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1.038,0,0,0,0,0,0,0,1.592,0,0,0,0,0,0,0,2.919,0,0,0,0,0,0,0,5.703,0,0,0,0,0,0,0,11.33,0,0,0,0,0,0,0,22.64,0,0,0,0,0,0,0,45.25,0,0,0,0,0,0,0,90.48,0,0,0,0,0,0,0,180.9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.7186,0,0,0,0,0,0,0,0.9218,0,0,0,0,0,0,0,1.586,0,0,0,0,0,0,0,3.043,0,0,0,0,0,0,0,6.019,0,0,0,0,0,0,0,12.01,0,0,0,0,0,0,0,24,0,0,0,0,0,0,0,47.97,
0,0,0,0,0,0,0,95.93,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],0,ALLOC_STATIC);_dwt_norms_real=Pointer_make([1,0,0,0,0,0,0,0,1.965,0,0,0,0,0,0,0,4.177,0,0,0,0,0,0,0,8.403,0,0,0,0,0,0,0,16.9,0,0,0,0,0,0,0,33.84,0,0,0,0,0,0,0,67.69,0,0,0,0,0,0,0,135.3,0,0,0,0,0,0,0,270.6,0,0,0,0,0,0,0,540.9,0,0,0,0,0,0,0,2.022,0,0,0,0,0,0,0,3.989,0,0,0,0,0,0,0,8.355,0,0,0,0,0,0,0,17.04,0,0,0,0,0,0,0,34.27,0,0,0,0,0,0,0,68.63,0,0,0,0,0,0,0,137.3,0,0,0,0,0,0,0,274.6,0,0,0,0,0,0,0,549,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.022,0,0,0,0,0,
0,0,3.989,0,0,0,0,0,0,0,8.355,0,0,0,0,0,0,0,17.04,0,0,0,0,0,0,0,34.27,0,0,0,0,0,0,0,68.63,0,0,0,0,0,0,0,137.3,0,0,0,0,0,0,0,274.6,0,0,0,0,0,0,0,549,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2.08,0,0,0,0,0,0,0,3.865,0,0,0,0,0,0,0,8.307,0,0,0,0,0,0,0,17.18,0,0,0,0,0,0,0,34.71,0,0,0,0,0,0,0,69.59,0,0,0,0,0,0,0,139.3,0,0,0,0,0,0,0,278.6,0,0,0,0,0,0,0,557.2,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],0,ALLOC_STATIC);__str387=Pointer_make([85,110,97,98,108,101,32,116,111,32,97,108,108,111,99,97,116,101,32,109,101,109,111,114,121,
32,102,111,114,32,105,109,97,103,101,46,10,0],0,ALLOC_STATIC);_j2k_prog_order_list=Pointer_make([4,0,0,0,67,80,82,76,0,0,0,0,76,82,67,80,3,0,0,0,80,67,82,76,1,0,0,0,82,76,67,80,2,0,0,0,82,80,67,76,-1,0,0,0,0,0,0,0],0,ALLOC_STATIC);_j2k_dec_mstab=Pointer_make([65359,0,0,0,1,0,0,0,0,0,0,0,65424,0,0,0,12,0,0,0,0,0,0,0,65427,0,0,0,16,0,0,0,0,0,0,0,65497,0,0,0,8,0,0,0,0,0,0,0,65361,0,0,0,2,0,0,0,0,0,0,0,65362,0,0,0,20,0,0,0,0,0,0,0,65363,0,0,0,20,0,0,0,0,0,0,0,65374,0,0,0,20,0,0,0,0,0,0,0,65372,0,0,0,
20,0,0,0,0,0,0,0,65373,0,0,0,20,0,0,0,0,0,0,0,65375,0,0,0,20,0,0,0,0,0,0,0,65365,0,0,0,4,0,0,0,0,0,0,0,65367,0,0,0,4,0,0,0,0,0,0,0,65368,0,0,0,16,0,0,0,0,0,0,0,65376,0,0,0,4,0,0,0,0,0,0,0,65377,0,0,0,16,0,0,0,0,0,0,0,65425,0,0,0,0,0,0,0,0,0,0,0,65379,0,0,0,4,0,0,0,0,0,0,0,65380,0,0,0,20,0,0,0,0,0,0,0,0,0,0,0,20,0,0,0,0,0,0,0],0,ALLOC_STATIC);__str488=Pointer_make([37,46,56,120,58,32,101,120,112,101,99,116,101,100,32,97,32,109,97,114,107,101,114,32,105,110,115,116,101,97,100,32,111,102,32,37,120,10,
0],0,ALLOC_STATIC);__str1589=Pointer_make([37,46,56,120,58,32,117,110,101,120,112,101,99,116,101,100,32,109,97,114,107,101,114,32,37,120,10,0],0,ALLOC_STATIC);__str2690=Pointer_make([77,97,105,110,32,72,101,97,100,101,114,32,100,101,99,111,100,101,100,46,10,0],0,ALLOC_STATIC);__str3791=Pointer_make([73,110,99,111,109,112,108,101,116,101,32,98,105,116,115,116,114,101,97,109,10,0],0,ALLOC_STATIC);__str4892=Pointer_make([91,74,80,84,45,115,116,114,101,97,109,93,32,58,32,69,120,112,101,99,116,105,110,
103,32,77,97,105,110,32,104,101,97,100,101,114,32,102,105,114,115,116,32,91,99,108,97,115,115,95,73,100,32,37,100,93,32,33,10,0],0,ALLOC_STATIC);__str593=Pointer_make([91,74,80,84,45,115,116,114,101,97,109,93,32,58,32,69,120,112,101,99,116,105,110,103,32,84,105,108,101,32,105,110,102,111,32,33,10,0],0,ALLOC_STATIC);__str694=Pointer_make([116,105,108,101,32,110,117,109,98,101,114,32,37,100,32,47,32,37,100,10,0],0,ALLOC_STATIC);__str795=Pointer_make([85,110,107,110,111,119,110,32,109,97,114,107,101,
114,10,0],0,ALLOC_STATIC);__str896=Pointer_make([69,114,114,111,114,32,100,101,99,111,100,105,110,103,32,99,111,109,112,111,110,101,110,116,32,37,100,46,10,84,104,101,32,110,117,109,98,101,114,32,111,102,32,114,101,115,111,108,117,116,105,111,110,115,32,116,111,32,114,101,109,111,118,101,32,105,115,32,104,105,103,104,101,114,32,116,104,97,110,32,116,104,101,32,110,117,109,98,101,114,32,111,102,32,114,101,115,111,108,117,116,105,111,110,115,32,111,102,32,116,104,105,115,32,99,111,109,112,111,110,101,
110,116,10,77,111,100,105,102,121,32,116,104,101,32,99,112,95,114,101,100,117,99,101,32,112,97,114,97,109,101,116,101,114,46,10,10,0],0,ALLOC_STATIC);__str997=Pointer_make([37,115,58,32,105,110,118,97,108,105,100,32,105,109,97,103,101,32,115,105,122,101,32,40,120,48,58,37,100,44,32,120,49,58,37,100,44,32,121,48,58,37,100,44,32,121,49,58,37,100,41,10,0],0,ALLOC_STATIC);_opj_clock_last=Pointer_make([-1],0,ALLOC_STATIC);__str1198=Pointer_make([69,120,112,101,99,116,101,100,32,74,80,50,72,32,77,97,114,
107,101,114,10,0],0,ALLOC_STATIC);__str112=Pointer_make([70,97,105,108,101,100,32,116,111,32,100,101,99,111,100,101,32,106,112,50,32,115,116,114,117,99,116,117,114,101,10,0],0,ALLOC_STATIC);__str213=Pointer_make([70,97,105,108,101,100,32,116,111,32,100,101,99,111,100,101,32,74,50,75,32,105,109,97,103,101,10,0],0,ALLOC_STATIC);__str314=Pointer_make([73,110,118,97,108,105,100,32,110,117,109,98,101,114,32,111,102,32,99,111,109,112,111,110,101,110,116,115,32,115,112,101,99,105,102,105,101,100,32,119,
104,105,108,101,32,115,101,116,116,105,110,103,32,117,112,32,74,80,50,32,101,110,99,111,100,101,114,10,0],0,ALLOC_STATIC);__str415=Pointer_make([70,97,105,108,101,100,32,116,111,32,101,110,99,111,100,101,32,105,109,97,103,101,10,0],0,ALLOC_STATIC);__str516=Pointer_make([69,120,112,101,99,116,101,100,32,70,84,89,80,32,77,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str617=Pointer_make([69,114,114,111,114,32,119,105,116,104,32,70,84,89,80,32,66,111,120,10,0],0,ALLOC_STATIC);__str718=Pointer_make([69,
120,112,101,99,116,101,100,32,74,80,32,77,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str819=Pointer_make([69,114,114,111,114,32,119,105,116,104,32,74,80,32,77,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str920=Pointer_make([69,114,114,111,114,32,119,105,116,104,32,74,80,32,66,111,120,32,115,105,122,101,10,0],0,ALLOC_STATIC);__str1099=Pointer_make([69,114,114,111,114,32,119,105,116,104,32,67,79,76,82,32,98,111,120,32,115,105,122,101,10,0],0,ALLOC_STATIC);__str1121=Pointer_make([69,114,114,111,114,32,
119,105,116,104,32,67,79,76,82,32,66,111,120,10,0],0,ALLOC_STATIC);__str12100=Pointer_make([69,120,112,101,99,116,101,100,32,66,80,67,67,32,77,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str13101=Pointer_make([69,114,114,111,114,32,119,105,116,104,32,66,80,67,67,32,66,111,120,10,0],0,ALLOC_STATIC);__str14102=Pointer_make([69,120,112,101,99,116,101,100,32,73,72,68,82,32,77,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str1522=Pointer_make([69,114,114,111,114,32,119,105,116,104,32,73,72,68,82,32,66,111,
120,10,0],0,ALLOC_STATIC);__str16103=Pointer_make([67,97,110,110,111,116,32,104,97,110,100,108,101,32,98,111,120,32,115,105,122,101,115,32,104,105,103,104,101,114,32,116,104,97,110,32,50,94,51,50,10,0],0,ALLOC_STATIC);__str23104=Pointer_make([70,111,114,98,105,100,100,101,110,32,118,97,108,117,101,32,101,110,99,111,117,110,116,101,114,32,105,110,32,109,101,115,115,97,103,101,32,104,101,97,100,101,114,32,33,33,10,0],0,ALLOC_STATIC);_mct_norms=Pointer_make([1.732,0,0,0,0,0,0,0,0.8292,0,0,0,0,0,0,0,
0.8292,0,0,0,0,0,0,0],0,ALLOC_STATIC);_mct_norms_real=Pointer_make([1.732,0,0,0,0,0,0,0,1.805,0,0,0,0,0,0,0,1.573,0,0,0,0,0,0,0],0,ALLOC_STATIC);_mqc_states=Pointer_make([22017,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,13313,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13313,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,6145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6145,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2753,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2753,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1313,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1313,0,0,0,
1,0,0,0,0,0,0,0,0,0,0,0,545,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,545,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,21505,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21505,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,18433,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18433,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,14337,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14337,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,12289,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12289,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,9217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9217,0,0,0,1,0,
0,0,0,0,0,0,0,0,0,0,7169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7169,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,5633,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5633,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,21505,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21505,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,20737,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,20737,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,18433,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,18433,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,14337,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,14337,0,0,0,1,0,0,
0,0,0,0,0,0,0,0,0,13313,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,13313,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,12289,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12289,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,10241,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10241,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,9217,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9217,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,8705,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,8705,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,7169,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,7169,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,6145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,6145,0,0,0,1,0,0,0,0,0,
0,0,0,0,0,0,5633,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5633,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,5121,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5121,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4609,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4609,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,4353,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4353,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2753,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2753,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2497,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2497,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,2209,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2209,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,
1313,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1313,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1089,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1089,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,673,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,673,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,545,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,545,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,321,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,321,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,273,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,273,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,133,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,133,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,73,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,73,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,37,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,21,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,9,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,22017,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0],0,ALLOC_STATIC);__str27105=Pointer_make([49,46,52,46,48,0],
0,ALLOC_STATIC);__str128=Pointer_make([83,101,116,32,105,110,100,101,120,32,116,111,32,78,85,76,76,32,119,104,101,110,32,99,97,108,108,105,110,103,32,116,104,101,32,111,112,106,95,101,110,99,111,100,101,32,102,117,110,99,116,105,111,110,46,10,84,111,32,101,120,116,114,97,99,116,32,116,104,101,32,105,110,100,101,120,44,32,117,115,101,32,116,104,101,32,111,112,106,95,101,110,99,111,100,101,95,119,105,116,104,95,105,110,102,111,40,41,32,102,117,110,99,116,105,111,110,46,10,78,111,32,105,110,100,101,
120,32,119,105,108,108,32,98,101,32,103,101,110,101,114,97,116,101,100,32,100,117,114,105,110,103,32,116,104,105,115,32,101,110,99,111,100,105,110,103,10,0],0,ALLOC_STATIC);__str29106=Pointer_make([67,80,82,76,0],0,ALLOC_STATIC);__str130=Pointer_make([76,82,67,80,0],0,ALLOC_STATIC);__str231=Pointer_make([80,67,82,76,0],0,ALLOC_STATIC);__str332=Pointer_make([82,76,67,80,0],0,ALLOC_STATIC);__str433=Pointer_make([82,80,67,76,0],0,ALLOC_STATIC);_t1_updateflags_mod=Pointer_make([64,0,1088,0,32,0,544,0,
128,0,2176,0,16,0,272,0],0,ALLOC_STATIC);_lut_spb=Pointer_make([0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,0,0,0,0,0,0,1,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,1,1,0,0,0,0,0,0,1,0,0,1,1,1,1,1,1,1,0,0,0,1,0,0,1,1,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0,0,1,0,0,0,0,0,0,1,1,0,1,1,1,0,0,0,0,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,0,1,1,1,1,1,1,1,1,1,1,0,0,0,0,1,0,0,0,1,1,0,0,1,1,1,0,0,1,0,0,1,1,0,0,1,1,0,
1,1,1,1,1,0,0,1,1,1,0,1,1,1,1,1,1,1,1,1,1,0,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1],0,ALLOC_STATIC);_lut_ctxno_sc=Pointer_make([9,10,12,13,10,10,13,13,12,13,12,13,13,13,13,13,9,10,12,11,10,9,13,12,12,11,12,11,13,12,13,12,9,10,12,11,10,10,11,11,12,13,9,10,13,13,10,10,9,10,12,13,10,9,11,12,12,11,9,10,13,12,10,9,9,10,12,13,10,9,11,12,12,13,12,13,11,12,11,12,9,10,12,11,10,10,11,11,12,11,12,11,11,11,11,11,9,10,12,11,10,9,13,12,12,13,9,10,11,12,10,9,9,10,12,13,10,10,13,13,12,11,9,10,11,11,10,10,9,10,12,13,10,10,
13,13,12,11,9,10,11,11,10,10,9,10,12,11,10,9,13,12,12,13,9,10,11,12,10,9,9,10,12,11,10,10,11,11,12,11,12,11,11,11,11,11,9,10,12,13,10,9,11,12,12,13,12,13,11,12,11,12,9,10,12,13,10,9,11,12,12,11,9,10,13,12,10,9,9,10,12,11,10,10,11,11,12,13,9,10,13,13,10,10,9,10,12,11,10,9,13,12,12,11,12,11,13,12,13,12,9,10,12,13,10,10,13,13,12,13,12,13,13,13,13,13],0,ALLOC_STATIC);_lut_ctxno_zc=Pointer_make([0,1,1,2,1,2,2,2,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,
7,7,7,7,7,7,7,7,7,7,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,1,1,2,1,2,2,2,1,2,2,2,2,2,2,2,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,7,
7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,1,1,2,1,2,2,2,1,2,2,2,2,2,2,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,6,6,6,6,6,6,6,6,6,6,6,
6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,5,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,0,3,3,6,3,6,6,8,3,6,6,8,6,8,8,8,1,4,4,7,4,7,7,8,4,7,7,8,7,8,8,8,1,4,4,7,4,7,7,
8,4,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,1,4,4,7,4,7,7,8,4,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,1,4,4,7,4,7,7,8,4,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8,2,5,5,7,5,7,7,8,5,7,7,8,7,8,8,8],0,ALLOC_STATIC);_lut_nmsedec_sig=Pointer_make([0,0,0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,384,0,768,0,1152,0,1536,0,1920,0,2304,0,2688,0,3072,0,3456,0,3840,0,4224,0,4608,0,4992,0,5376,0,5760,0,6144,0,6528,0,6912,0,7296,0,7680,0,8064,0,8448,0,8832,0,9216,0,9600,0,9984,0,10368,0,10752,0,11136,0,11520,0,11904,0,12288,0,12672,0,13056,0,13440,0,13824,0,14208,0,14592,0,14976,0,15360,0,15744,0,16128,0,16512,0,16896,0,17280,
0,17664,0,18048,0,18432,0,18816,0,19200,0,19584,0,19968,0,20352,0,20736,0,21120,0,21504,0,21888,0,22272,0,22656,0,23040,0,23424,0,23808,0,24192,0,24576,0,24960,0,25344,0,25728,0,26112,0,26496,0,26880,0,27264,0,27648,0,28032,0,28416,0,28800,0,29184,0,29568,0,29952,0,30336,0],0,ALLOC_STATIC);_lut_nmsedec_sig0=Pointer_make([0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,256,0,256,0,256,0,384,0,384,0,512,0,512,0,640,0,640,0,768,0,768,0,896,0,1024,0,1024,0,1152,0,1280,0,1408,0,1408,0,1536,0,1664,0,1792,
0,1920,0,2048,0,2176,0,2304,0,2432,0,2560,0,2688,0,2944,0,3072,0,3200,0,3328,0,3584,0,3712,0,3840,0,4096,0,4224,0,4480,0,4608,0,4864,0,4992,0,5248,0,5376,0,5632,0,5888,0,6016,0,6272,0,6528,0,6784,0,6912,0,7168,0,7424,0,7680,0,7936,0,8192,0,8448,0,8704,0,8960,0,9216,0,9472,0,9856,0,10112,0,10368,0,10624,0,11008,0,11264,0,11520,0,11904,0,12160,0,12544,0,12800,0,13184,0,13440,0,13824,0,14080,0,14464,0,14848,0,15104,0,15488,0,15872,0,16256,0,16512,0,16896,0,17280,0,17664,0,18048,0,18432,0,18816,0,19200,
0,19584,0,19968,0,20352,0,20864,0,21248,0,21632,0,22016,0,22528,0,22912,0,23296,0,23808,0,24192,0,24704,0,25088,0,25600,0,25984,0,26496,0,26880,0,27392,0,27904,0,28288,0,28800,0,29312,0,29824,0,30208,0,30720,0,31232,0,31744,0,32256,0],0,ALLOC_STATIC);_lut_nmsedec_ref=Pointer_make([6144,0,6016,0,5888,0,5760,0,5632,0,5504,0,5376,0,5248,0,5120,0,4992,0,4864,0,4736,0,4608,0,4480,0,4352,0,4224,0,4096,0,3968,0,3840,0,3712,0,3584,0,3456,0,3328,0,3200,0,3072,0,2944,0,2816,0,2688,0,2560,0,2432,0,2304,0,2176,
0,2048,0,1920,0,1792,0,1664,0,1536,0,1408,0,1280,0,1152,0,1024,0,896,0,768,0,640,0,512,0,384,0,256,0,128,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,256,0,384,0,512,0,640,0,768,0,896,0,1024,0,1152,0,1280,0,1408,0,1536,0,1664,0,1792,0,1920,0,2048,0,2176,0,2304,0,2432,0,2560,0,2688,0,2816,0,2944,0,3072,0,3200,0,3328,0,3456,0,3584,0,3712,0,3840,0,3968,0,4096,0,4224,0,4352,0,4480,0,4608,0,4736,0,4864,0,4992,
0,5120,0,5248,0,5376,0,5504,0,5632,0,5760,0,5888,0,6016,0],0,ALLOC_STATIC);_lut_nmsedec_ref0=Pointer_make([8192,0,7936,0,7680,0,7424,0,7168,0,6912,0,6784,0,6528,0,6272,0,6016,0,5888,0,5632,0,5376,0,5248,0,4992,0,4864,0,4608,0,4480,0,4224,0,4096,0,3840,0,3712,0,3584,0,3328,0,3200,0,3072,0,2944,0,2688,0,2560,0,2432,0,2304,0,2176,0,2048,0,1920,0,1792,0,1664,0,1536,0,1408,0,1408,0,1280,0,1152,0,1024,0,1024,0,896,0,768,0,768,0,640,0,640,0,512,0,512,0,384,0,384,0,256,0,256,0,256,0,128,0,128,0,128,0,128,
0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,128,0,128,0,128,0,128,0,256,0,256,0,256,0,384,0,384,0,512,0,512,0,640,0,640,0,768,0,768,0,896,0,1024,0,1024,0,1152,0,1280,0,1408,0,1408,0,1536,0,1664,0,1792,0,1920,0,2048,0,2176,0,2304,0,2432,0,2560,0,2688,0,2944,0,3072,0,3200,0,3328,0,3584,0,3712,0,3840,0,4096,0,4224,0,4480,0,4608,0,4864,0,4992,0,5248,0,5376,0,5632,0,5888,0,6016,0,6272,0,6528,0,6784,0,6912,0,7168,0,7424,0,7680,0,7936,0],0,ALLOC_STATIC);__str41107=Pointer_make([69,114,114,111,114,32,105,
110,105,116,105,97,108,105,122,105,110,103,32,80,97,99,107,101,116,32,73,116,101,114,97,116,111,114,10,0],0,ALLOC_STATIC);__str142=Pointer_make([69,120,112,101,99,116,101,100,32,83,79,80,32,109,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str344=Pointer_make([69,120,112,101,99,116,101,100,32,69,80,72,32,109,97,114,107,101,114,10,0],0,ALLOC_STATIC);__str49108=Pointer_make([105,109,97,103,101,32,123,10,0],0,ALLOC_STATIC);__str150=Pointer_make([32,32,116,119,61,37,100,44,32,116,104,61,37,100,32,120,48,
61,37,100,32,120,49,61,37,100,32,121,48,61,37,100,32,121,49,61,37,100,10,0],0,ALLOC_STATIC);__str251=Pointer_make([32,32,116,105,108,101,32,123,10,0],0,ALLOC_STATIC);__str352=Pointer_make([32,32,32,32,120,48,61,37,100,44,32,121,48,61,37,100,44,32,120,49,61,37,100,44,32,121,49,61,37,100,44,32,110,117,109,99,111,109,112,115,61,37,100,10,0],0,ALLOC_STATIC);__str453=Pointer_make([32,32,32,32,116,105,108,101,99,32,123,10,0],0,ALLOC_STATIC);__str554=Pointer_make([32,32,32,32,32,32,120,48,61,37,100,44,32,
121,48,61,37,100,44,32,120,49,61,37,100,44,32,121,49,61,37,100,44,32,110,117,109,114,101,115,111,108,117,116,105,111,110,115,61,37,100,10,0],0,ALLOC_STATIC);__str655=Pointer_make([10,32,32,32,114,101,115,32,123,10,0],0,ALLOC_STATIC);__str756=Pointer_make([32,32,32,32,32,32,32,32,32,32,120,48,61,37,100,44,32,121,48,61,37,100,44,32,120,49,61,37,100,44,32,121,49,61,37,100,44,32,112,119,61,37,100,44,32,112,104,61,37,100,44,32,110,117,109,98,97,110,100,115,61,37,100,10,0],0,ALLOC_STATIC);__str857=Pointer_make([32,
32,32,32,32,32,32,32,98,97,110,100,32,123,10,0],0,ALLOC_STATIC);__str958=Pointer_make([32,32,32,32,32,32,32,32,32,32,120,48,61,37,100,44,32,121,48,61,37,100,44,32,120,49,61,37,100,44,32,121,49,61,37,100,44,32,115,116,101,112,115,105,122,101,61,37,102,44,32,110,117,109,98,112,115,61,37,100,10,0],0,ALLOC_STATIC);__str1059=Pointer_make([32,32,32,32,32,32,32,32,32,32,112,114,101,99,32,123,10,0],0,ALLOC_STATIC);__str1160=Pointer_make([32,32,32,32,32,32,32,32,32,32,32,32,120,48,61,37,100,44,32,121,48,61,
37,100,44,32,120,49,61,37,100,44,32,121,49,61,37,100,44,32,99,119,61,37,100,44,32,99,104,61,37,100,10,0],0,ALLOC_STATIC);__str1261=Pointer_make([32,32,32,32,32,32,32,32,32,32,125,10,0],0,ALLOC_STATIC);__str1362=Pointer_make([32,32,32,32,32,32,32,32,125,10,0],0,ALLOC_STATIC);__str1463=Pointer_make([32,32,32,32,32,32,125,10,0],0,ALLOC_STATIC);__str1564=Pointer_make([32,32,32,32,125,10,0],0,ALLOC_STATIC);__str1665=Pointer_make([32,32,125,10,0],0,ALLOC_STATIC);__str17109=Pointer_make([125,10,0],0,ALLOC_STATIC);
__str18110=Pointer_make([45,32,116,105,108,101,32,101,110,99,111,100,101,100,32,105,110,32,37,102,32,115,10,0],0,ALLOC_STATIC);__str19111=Pointer_make([116,105,108,101,32,37,100,32,111,102,32,37,100,10,0],0,ALLOC_STATIC);__str20112=Pointer_make([116,99,100,95,100,101,99,111,100,101,58,32,105,110,99,111,109,112,108,101,116,101,32,98,105,115,116,114,101,97,109,10,0],0,ALLOC_STATIC);__str21113=Pointer_make([45,32,116,105,101,114,115,45,49,32,116,111,111,107,32,37,102,32,115,10,0],0,ALLOC_STATIC);__str22114=
Pointer_make([69,114,114,111,114,32,100,101,99,111,100,105,110,103,32,116,105,108,101,46,32,84,104,101,32,110,117,109,98,101,114,32,111,102,32,114,101,115,111,108,117,116,105,111,110,115,32,116,111,32,114,101,109,111,118,101,32,91,37,100,43,49,93,32,105,115,32,104,105,103,104,101,114,32,116,104,97,110,32,116,104,101,32,110,117,109,98,101,114,32,32,111,102,32,114,101,115,111,108,117,116,105,111,110,115,32,105,110,32,116,104,101,32,111,114,105,103,105,110,97,108,32,99,111,100,101,115,116,114,101,97,
109,32,91,37,100,93,10,77,111,100,105,102,121,32,116,104,101,32,99,112,95,114,101,100,117,99,101,32,112,97,114,97,109,101,116,101,114,46,10,0],0,ALLOC_STATIC);__str2366=Pointer_make([45,32,100,119,116,32,116,111,111,107,32,37,102,32,115,10,0],0,ALLOC_STATIC);__str24115=Pointer_make([45,32,116,105,108,101,32,100,101,99,111,100,101,100,32,105,110,32,37,102,32,115,10,0],0,ALLOC_STATIC);__str25116=Pointer_make([119,0],0,ALLOC_STATIC);__str126=Pointer_make([102,97,105,108,101,100,32,116,111,32,111,112,
101,110,32,105,110,100,101,120,32,102,105,108,101,32,91,37,115,93,32,102,111,114,32,119,114,105,116,105,110,103,10,0],0,ALLOC_STATIC);__str227=Pointer_make([37,100,32,37,100,10,0],0,ALLOC_STATIC);__str328=Pointer_make([37,100,10,0],0,ALLOC_STATIC);__str429=Pointer_make([91,37,100,44,37,100,93,32,0],0,ALLOC_STATIC);__str631=Pointer_make([10,73,78,70,79,32,79,78,32,84,73,76,69,83,10,0],0,ALLOC_STATIC);__str732=Pointer_make([116,105,108,101,110,111,32,115,116,97,114,116,95,112,111,115,32,32,101,110,
100,95,104,100,32,32,101,110,100,95,116,105,108,101,32,32,32,110,98,112,97,114,116,115,0],0,ALLOC_STATIC);__str833=Pointer_make([32,32,32,32,32,32,32,32,32,100,105,115,116,111,0],0,ALLOC_STATIC);__str934=Pointer_make([32,32,32,32,32,110,98,112,105,120,0],0,ALLOC_STATIC);__str1035=Pointer_make([32,32,100,105,115,116,111,47,110,98,112,105,120,0],0,ALLOC_STATIC);__str1136=Pointer_make([37,52,100,32,37,57,100,32,37,57,100,32,37,57,100,32,37,57,100,0],0,ALLOC_STATIC);__str1237=Pointer_make([32,37,57,101,
0],0,ALLOC_STATIC);__str1338=Pointer_make([32,37,57,100,0],0,ALLOC_STATIC);__str1439=Pointer_make([10,84,73,76,69,32,37,100,32,68,69,84,65,73,76,83,10,0],0,ALLOC_STATIC);__str1540=Pointer_make([112,97,114,116,95,110,98,32,116,105,108,101,110,111,32,32,115,116,97,114,116,95,112,97,99,107,32,110,117,109,95,112,97,99,107,115,32,32,115,116,97,114,116,95,112,111,115,32,101,110,100,95,116,112,104,95,112,111,115,32,32,32,101,110,100,95,112,111,115,10,0],0,ALLOC_STATIC);__str1641=Pointer_make([37,52,100,
32,37,57,100,32,32,32,37,57,100,32,37,57,100,32,32,37,57,100,32,37,49,49,100,32,37,57,100,10,0],0,ALLOC_STATIC);__str1742=Pointer_make([76,82,67,80,10,112,97,99,107,95,110,98,32,116,105,108,101,110,111,32,108,97,121,110,111,32,114,101,115,110,111,32,99,111,109,112,110,111,32,112,114,101,99,110,111,32,115,116,97,114,116,95,112,111,115,32,101,110,100,95,112,104,95,112,111,115,32,101,110,100,95,112,111,115,0],0,ALLOC_STATIC);__str1843=Pointer_make([32,100,105,115,116,111,0],0,ALLOC_STATIC);__str1944=
Pointer_make([37,52,100,32,37,54,100,32,37,55,100,32,37,53,100,32,37,54,100,32,32,37,54,100,32,32,32,32,37,54,100,32,32,32,32,32,37,54,100,32,37,55,100,0],0,ALLOC_STATIC);__str2045=Pointer_make([32,37,56,101,0],0,ALLOC_STATIC);__str2146=Pointer_make([82,76,67,80,10,112,97,99,107,95,110,98,32,116,105,108,101,110,111,32,114,101,115,110,111,32,108,97,121,110,111,32,99,111,109,112,110,111,32,112,114,101,99,110,111,32,115,116,97,114,116,95,112,111,115,32,101,110,100,95,112,104,95,112,111,115,32,101,110,
100,95,112,111,115,10,0],0,ALLOC_STATIC);__str2247=Pointer_make([37,52,100,32,37,54,100,32,37,53,100,32,37,55,100,32,37,54,100,32,37,54,100,32,37,57,100,32,32,32,37,57,100,32,37,55,100,0],0,ALLOC_STATIC);__str2348=Pointer_make([82,80,67,76,10,112,97,99,107,95,110,98,32,116,105,108,101,110,111,32,114,101,115,110,111,32,112,114,101,99,110,111,32,99,111,109,112,110,111,32,108,97,121,110,111,32,115,116,97,114,116,95,112,111,115,32,101,110,100,95,112,104,95,112,111,115,32,101,110,100,95,112,111,115,0],
0,ALLOC_STATIC);__str2449=Pointer_make([37,52,100,32,37,54,100,32,37,53,100,32,37,54,100,32,37,54,100,32,37,55,100,32,37,57,100,32,32,32,37,57,100,32,37,55,100,0],0,ALLOC_STATIC);__str2550=Pointer_make([80,67,82,76,10,112,97,99,107,95,110,98,32,116,105,108,101,110,111,32,112,114,101,99,110,111,32,99,111,109,112,110,111,32,114,101,115,110,111,32,108,97,121,110,111,32,115,116,97,114,116,95,112,111,115,32,101,110,100,95,112,104,95,112,111,115,32,101,110,100,95,112,111,115,0],0,ALLOC_STATIC);__str2651=
Pointer_make([37,52,100,32,37,54,100,32,37,54,100,32,37,54,100,32,37,53,100,32,37,55,100,32,37,57,100,32,32,32,37,57,100,32,37,55,100,0],0,ALLOC_STATIC);__str2752=Pointer_make([67,80,82,76,10,112,97,99,107,95,110,98,32,116,105,108,101,110,111,32,99,111,109,112,110,111,32,112,114,101,99,110,111,32,114,101,115,110,111,32,108,97,121,110,111,32,115,116,97,114,116,95,112,111,115,32,101,110,100,95,112,104,95,112,111,115,32,101,110,100,95,112,111,115,0],0,ALLOC_STATIC);__str28117=Pointer_make([37,56,101,
10,0],0,ALLOC_STATIC);__str2953=Pointer_make([37,46,56,101,10,0],0,ALLOC_STATIC);__str30118=Pointer_make([10,77,65,82,75,69,82,32,76,73,83,84,10,0],0,ALLOC_STATIC);__str31119=Pointer_make([116,121,112,101,9,115,116,97,114,116,95,112,111,115,32,32,32,32,108,101,110,103,116,104,10,0],0,ALLOC_STATIC);__str32120=Pointer_make([37,88,9,37,57,100,32,37,57,100,10,0],0,ALLOC_STATIC);__str33121=Pointer_make([71,101,110,101,114,97,116,101,100,32,105,110,100,101,120,32,102,105,108,101,32,37,115,10,0],0,ALLOC_STATIC);
__str54122=Pointer_make([83,111,114,114,121,44,32,99,111,109,112,114,101,115,115,101,100,32,116,103,97,32,102,105,108,101,115,32,97,114,101,32,110,111,116,32,99,117,114,114,101,110,116,108,121,32,115,117,112,112,111,114,116,101,100,46,10,0],0,ALLOC_STATIC);__str155=Pointer_make([70,105,108,101,32,99,111,110,116,97,105,110,115,32,97,32,112,97,108,101,116,116,101,32,45,32,110,111,116,32,121,101,116,32,115,117,112,112,111,114,116,101,100,46,0],0,ALLOC_STATIC);__str357=Pointer_make([70,97,105,108,101,
100,32,116,111,32,111,112,101,110,32,37,115,32,102,111,114,32,114,101,97,100,105,110,103,32,33,33,10,0],0,ALLOC_STATIC);__str458=Pointer_make([67,117,114,114,101,110,116,108,121,32,117,110,115,117,112,112,111,114,116,101,100,32,98,105,116,32,100,101,112,116,104,32,58,32,37,115,10,0],0,ALLOC_STATIC);__str559=Pointer_make([119,98,0],0,ALLOC_STATIC);__str660=Pointer_make([69,82,82,79,82,32,45,62,32,102,97,105,108,101,100,32,116,111,32,111,112,101,110,32,37,115,32,102,111,114,32,119,114,105,116,105,110,
103,10,0],0,ALLOC_STATIC);__str761=Pointer_make([85,110,97,98,108,101,32,116,111,32,99,114,101,97,116,101,32,97,32,116,103,97,32,102,105,108,101,32,119,105,116,104,32,115,117,99,104,32,74,50,75,32,105,109,97,103,101,32,99,104,97,114,97,116,101,114,105,115,116,105,99,115,46,0],0,ALLOC_STATIC);__str862=Pointer_make([69,114,114,111,114,44,32,110,111,116,32,97,32,66,77,80,32,102,105,108,101,33,10,0],0,ALLOC_STATIC);__str963=Pointer_make([78,111,32,68,101,108,116,97,32,115,117,112,112,111,114,116,101,
100,10,0],0,ALLOC_STATIC);__str1064=Pointer_make([79,116,104,101,114,32,115,121,115,116,101,109,32,116,104,97,110,32,50,52,32,98,105,116,115,47,112,105,120,101,108,115,32,111,114,32,56,32,98,105,116,115,32,40,110,111,32,82,76,69,32,99,111,100,105,110,103,41,32,105,115,32,110,111,116,32,121,101,116,32,105,109,112,108,101,109,101,110,116,101,100,32,91,37,100,93,10,0],0,ALLOC_STATIC);__str1165=Pointer_make([66,77,0],0,ALLOC_STATIC);__str1266=Pointer_make([37,99,37,99,37,99,37,99,0],0,ALLOC_STATIC);__str1367=
Pointer_make([37,99,37,99,0],0,ALLOC_STATIC);__str1468=Pointer_make([66,77,80,32,67,79,78,86,69,82,83,73,79,78,58,32,84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,48,32,102,114,111,109,32,37,100,32,98,105,116,115,32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str1569=Pointer_make([66,77,80,32,67,79,78,86,69,82,83,73,79,78,58,32,84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,49,32,102,114,111,109,32,37,100,32,98,105,116,115,
32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str1670=Pointer_make([66,77,80,32,67,79,78,86,69,82,83,73,79,78,58,32,84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,50,32,102,114,111,109,32,37,100,32,98,105,116,115,32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str1771=Pointer_make([37,99,37,99,37,99,0],0,ALLOC_STATIC);__str1973=Pointer_make([70,97,105,108,101,100,32,116,111,32,111,112,101,110,32,37,115,32,102,111,114,32,114,101,97,100,105,110,
103,32,33,10,0],0,ALLOC_STATIC);__str2074=Pointer_make([80,71,37,91,32,9,93,37,99,37,99,37,91,32,9,43,45,93,37,100,37,91,32,9,93,37,100,37,91,32,9,93,37,100,0],0,ALLOC_STATIC);__str2175=Pointer_make([66,97,100,32,112,103,120,32,104,101,97,100,101,114,44,32,112,108,101,97,115,101,32,99,104,101,99,107,32,105,110,112,117,116,32,102,105,108,101,10,0],0,ALLOC_STATIC);__str2276=Pointer_make([69,82,82,79,82,32,45,62,32,73,109,112,111,115,115,105,98,108,101,32,104,97,112,112,101,110,46,0],0,ALLOC_STATIC);
__str2377=Pointer_make([45,37,100,46,112,103,120,0],0,ALLOC_STATIC);__str2478=Pointer_make([46,112,103,120,0],0,ALLOC_STATIC);__str2579=Pointer_make([80,71,32,77,76,32,37,99,32,37,100,32,37,100,32,37,100,10,0],0,ALLOC_STATIC);__str2680=Pointer_make([37,100,32,37,100,10,50,53,53,0],0,ALLOC_STATIC);__str2781=Pointer_make([37,117,0],0,ALLOC_STATIC);__str2882=Pointer_make([80,54,10,37,100,32,37,100,10,37,100,10,0],0,ALLOC_STATIC);__str2983=Pointer_make([80,78,77,32,67,79,78,86,69,82,83,73,79,78,58,32,
84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,48,32,102,114,111,109,32,37,100,32,98,105,116,115,32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str3084=Pointer_make([80,78,77,32,67,79,78,86,69,82,83,73,79,78,58,32,84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,49,32,102,114,111,109,32,37,100,32,98,105,116,115,32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str3185=Pointer_make([80,78,77,32,67,79,78,86,69,82,83,73,
79,78,58,32,84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,50,32,102,114,111,109,32,37,100,32,98,105,116,115,32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str3286=Pointer_make([87,65,82,78,73,78,71,32,45,62,32,91,80,71,77,32,102,105,108,101,115,93,32,79,110,108,121,32,116,104,101,32,102,105,114,115,116,32,99,111,109,112,111,110,101,110,116,10,0],0,ALLOC_STATIC);__str3387=Pointer_make([32,32,32,32,32,32,32,32,32,32,32,105,115,32,119,114,105,116,116,101,110,
32,116,111,32,116,104,101,32,102,105,108,101,10,0],0,ALLOC_STATIC);__str34123=Pointer_make([37,100,46,37,115,0],0,ALLOC_STATIC);__str36125=Pointer_make([80,53,10,37,100,32,37,100,10,37,100,10,0],0,ALLOC_STATIC);__str3788=Pointer_make([80,78,77,32,67,79,78,86,69,82,83,73,79,78,58,32,84,114,117,110,99,97,116,105,110,103,32,99,111,109,112,111,110,101,110,116,32,37,100,32,102,114,111,109,32,37,100,32,98,105,116,115,32,116,111,32,56,32,98,105,116,115,10,0],0,ALLOC_STATIC);__str38126=Pointer_make([66,105,
116,115,61,37,100,44,32,79,110,108,121,32,56,44,49,50,44,49,54,32,98,105,116,115,32,105,109,112,108,101,109,101,110,116,101,100,10,0],0,ALLOC_STATIC);__str39127=Pointer_make([65,98,111,114,116,105,110,103,10,0],0,ALLOC_STATIC);__str40128=Pointer_make([84,73,70,70,32,102,105,108,101,32,99,114,101,97,116,105,111,110,46,32,66,105,116,115,61,37,100,44,32,79,110,108,121,32,56,44,49,50,44,49,54,32,98,105,116,115,32,105,109,112,108,101,109,101,110,116,101,100,10,0],0,ALLOC_STATIC);__str4189=Pointer_make([84,
73,70,70,32,102,105,108,101,32,99,114,101,97,116,105,111,110,46,32,66,97,100,32,99,111,108,111,114,32,102,111,114,109,97,116,46,32,79,110,108,121,32,82,71,66,32,38,32,71,114,97,121,115,99,97,108,101,32,104,97,115,32,98,101,101,110,32,105,109,112,108,101,109,101,110,116,101,100,10,0],0,ALLOC_STATIC);__str42129=Pointer_make([114,0],0,ALLOC_STATIC);__str43130=Pointer_make([70,97,105,108,101,100,32,116,111,32,111,112,101,110,32,37,115,32,102,111,114,32,114,101,97,100,105,110,103,10,0],0,ALLOC_STATIC);
__str44131=Pointer_make([10,69,114,114,111,114,58,32,105,110,118,97,108,105,100,32,114,97,119,32,105,109,97,103,101,32,112,97,114,97,109,101,116,101,114,115,10,0],0,ALLOC_STATIC);__str45132=Pointer_make([80,108,101,97,115,101,32,117,115,101,32,116,104,101,32,70,111,114,109,97,116,32,111,112,116,105,111,110,32,45,70,58,10,0],0,ALLOC_STATIC);__str46133=Pointer_make([45,70,32,114,97,119,87,105,100,116,104,44,114,97,119,72,101,105,103,104,116,44,114,97,119,67,111,109,112,44,114,97,119,66,105,116,68,101,
112,116,104,44,115,47,117,32,40,83,105,103,110,101,100,47,85,110,115,105,103,110,101,100,41,10,0],0,ALLOC_STATIC);__str47134=Pointer_make([69,120,97,109,112,108,101,58,32,45,105,32,108,101,110,97,46,114,97,119,32,45,111,32,108,101,110,97,46,106,50,107,32,45,70,32,53,49,50,44,53,49,50,44,51,44,56,44,117,10,0],0,ALLOC_STATIC);__str4890=Pointer_make([69,114,114,111,114,32,114,101,97,100,105,110,103,32,114,97,119,32,102,105,108,101,46,32,69,110,100,32,111,102,32,102,105,108,101,32,112,114,111,98,97,98,
108,121,32,114,101,97,99,104,101,100,46,10,0],0,ALLOC_STATIC);__str4991=Pointer_make([79,112,101,110,74,80,69,71,32,99,97,110,110,111,116,32,101,110,99,111,100,101,32,114,97,119,32,99,111,109,112,111,110,101,110,116,115,32,119,105,116,104,32,98,105,116,32,100,101,112,116,104,32,104,105,103,104,101,114,32,116,104,97,110,32,49,54,32,98,105,116,115,46,10,0],0,ALLOC_STATIC);__str50135=Pointer_make([87,97,114,110,105,110,103,46,32,69,110,100,32,111,102,32,114,97,119,32,102,105,108,101,32,110,111,116,32,
114,101,97,99,104,101,100,46,46,46,32,112,114,111,99,101,115,115,105,110,103,32,97,110,121,119,97,121,10,0],0,ALLOC_STATIC);__str51136=Pointer_make([70,97,105,108,101,100,32,116,111,32,111,112,101,110,32,37,115,32,102,111,114,32,119,114,105,116,105,110,103,32,33,33,10,0],0,ALLOC_STATIC);__str52137=Pointer_make([82,97,119,32,105,109,97,103,101,32,99,104,97,114,97,99,116,101,114,105,115,116,105,99,115,58,32,37,100,32,99,111,109,112,111,110,101,110,116,115,10,0],0,ALLOC_STATIC);__str53138=Pointer_make([67,
111,109,112,111,110,101,110,116,32,37,100,32,99,104,97,114,97,99,116,101,114,105,115,116,105,99,115,58,32,37,100,120,37,100,120,37,100,32,37,115,10,0],0,ALLOC_STATIC);__str5492=Pointer_make([115,105,103,110,101,100,0],0,ALLOC_STATIC);__str55139=Pointer_make([117,110,115,105,103,110,101,100,0],0,ALLOC_STATIC);__str56140=Pointer_make([77,111,114,101,32,116,104,97,110,32,49,54,32,98,105,116,115,32,112,101,114,32,99,111,109,112,111,110,101,110,116,32,110,111,32,104,97,110,100,108,101,100,32,121,101,116,
10,0],0,ALLOC_STATIC);__str57141=Pointer_make([69,114,114,111,114,58,32,105,110,118,97,108,105,100,32,112,114,101,99,105,115,105,111,110,58,32,37,100,10,0],0,ALLOC_STATIC);__str58142=Pointer_make([112,110,103,116,111,105,109,97,103,101,58,32,99,97,110,32,110,111,116,32,111,112,101,110,32,37,115,10,0],0,ALLOC_STATIC);__str59143=Pointer_make([137,80,78,71,13,10,26,10,0],0,ALLOC_STATIC);__str60144=Pointer_make([112,110,103,116,111,105,109,97,103,101,58,32,37,115,32,105,115,32,110,111,32,118,97,108,105,
100,32,80,78,71,32,102,105,108,101,10,0],0,ALLOC_STATIC);__str61145=Pointer_make([49,46,50,46,52,52,0],0,ALLOC_STATIC);__str62146=Pointer_make([105,109,97,103,101,116,111,112,110,103,58,32,99,97,110,32,110,111,116,32,99,114,101,97,116,101,32,37,115,10,9,119,114,111,110,103,32,98,105,116,95,100,101,112,116,104,32,37,100,10,0],0,ALLOC_STATIC);__str63147=Pointer_make([105,109,97,103,101,116,111,112,110,103,58,32,99,97,110,32,110,111,116,32,99,114,101,97,116,101,32,37,115,10,0],0,ALLOC_STATIC);__str96=
Pointer_make([37,115,58,37,100,58,99,111,108,111,114,95,115,121,99,99,95,116,111,95,114,103,98,10,9,67,65,78,32,78,79,84,32,67,79,78,86,69,82,84,10,0],0,ALLOC_STATIC);__str197=Pointer_make([47,100,101,118,47,115,104,109,47,116,109,112,47,98,117,105,108,100,105,110,103,47,111,112,101,110,106,112,101,103,47,99,111,109,109,111,110,47,99,111,108,111,114,46,99,0],0,ALLOC_STATIC);_opterr=Pointer_make([1],0,ALLOC_STATIC);_optind=Pointer_make([1],0,ALLOC_STATIC);_getopt_place=Pointer_make([0],0,ALLOC_STATIC);
__str98=Pointer_make([0],0,ALLOC_STATIC);_optreset=Pointer_make([0],0,ALLOC_STATIC);_optopt=Pointer_make([0],0,ALLOC_STATIC);__str199=Pointer_make([37,115,58,32,105,108,108,101,103,97,108,32,111,112,116,105,111,110,32,45,45,32,37,99,10,0],0,ALLOC_STATIC);_optarg=Pointer_make([0],0,ALLOC_STATIC);__str2100=Pointer_make([37,115,58,32,111,112,116,105,111,110,32,114,101,113,117,105,114,101,115,32,97,110,32,97,114,103,117,109,101,110,116,32,45,45,32,37,99,10,0],0,ALLOC_STATIC);_getopt_long_lastidx=Pointer_make([0],
0,ALLOC_STATIC);_getopt_long_lastofs=Pointer_make([0],0,ALLOC_STATIC);__str3101=Pointer_make([37,115,58,32,111,112,116,105,111,110,32,100,111,101,115,32,110,111,116,32,114,101,113,117,105,114,101,32,97,110,32,97,114,103,117,109,101,110,116,46,32,73,103,110,111,114,105,110,103,32,37,115,10,0],0,ALLOC_STATIC);__str4102=Pointer_make([37,115,58,32,111,112,116,105,111,110,32,114,101,113,117,105,114,101,115,32,97,110,32,97,114,103,117,109,101,110,116,10,0],0,ALLOC_STATIC);__str5103=Pointer_make([37,115,
58,32,111,112,116,105,111,110,32,114,101,113,117,105,114,101,115,32,97,110,32,97,114,103,117,109,101,110,116,32,10,0],0,ALLOC_STATIC);__str6104=Pointer_make([73,110,118,97,108,105,100,32,111,112,116,105,111,110,32,37,115,10,0],0,ALLOC_STATIC);__str7105=Pointer_make([73,110,118,97,108,105,100,32,111,112,116,105,111,110,10,0],0,ALLOC_STATIC);_str=Pointer_make([69,114,114,111,114,32,58,32,101,120,112,101,99,116,101,100,32,69,80,72,32,109,97,114,107,101,114,0],0,ALLOC_STATIC);IHEAP[_get_file_format_extension]=
__str38;IHEAP[_get_file_format_extension+4]=__str39;IHEAP[_get_file_format_extension+8]=__str40;IHEAP[_get_file_format_extension+12]=__str41;IHEAP[_get_file_format_extension+16]=__str42;IHEAP[_get_file_format_extension+20]=__str43;IHEAP[_get_file_format_extension+24]=__str44;IHEAP[_get_file_format_extension+28]=__str45;IHEAP[_get_file_format_extension+32]=__str46;IHEAP[_get_file_format_extension+36]=__str47;IHEAP[_get_file_format_extension+40]=__str48;IHEAP[_get_file_format_extension+44]=__str49;
IHEAP[_get_file_format_extension+48]=__str50;IHEAP[_get_file_format_extension+52]=__str51;IHEAP[_parse_cmdline_decoder_long_option]=__str56;IHEAP[_parse_cmdline_decoder_long_option+16]=__str57;IHEAP[_j2k_dec_mstab+8]=_j2k_read_soc.__index__;IHEAP[_j2k_dec_mstab+20]=_j2k_read_sot.__index__;IHEAP[_j2k_dec_mstab+32]=_j2k_read_sod.__index__;IHEAP[_j2k_dec_mstab+44]=_j2k_read_eoc.__index__;IHEAP[_j2k_dec_mstab+56]=_j2k_read_siz.__index__;IHEAP[_j2k_dec_mstab+68]=_j2k_read_cod.__index__;IHEAP[_j2k_dec_mstab+
80]=_j2k_read_coc.__index__;IHEAP[_j2k_dec_mstab+92]=_j2k_read_rgn.__index__;IHEAP[_j2k_dec_mstab+104]=_j2k_read_qcd.__index__;IHEAP[_j2k_dec_mstab+116]=_j2k_read_qcc.__index__;IHEAP[_j2k_dec_mstab+128]=_j2k_read_poc.__index__;IHEAP[_j2k_dec_mstab+140]=_j2k_read_tlm.__index__;IHEAP[_j2k_dec_mstab+152]=_j2k_read_plm.__index__;IHEAP[_j2k_dec_mstab+164]=_j2k_read_plt.__index__;IHEAP[_j2k_dec_mstab+176]=_j2k_read_ppm.__index__;IHEAP[_j2k_dec_mstab+188]=_j2k_read_ppt.__index__;IHEAP[_j2k_dec_mstab+212]=
_j2k_read_crg.__index__;IHEAP[_j2k_dec_mstab+224]=_j2k_read_com.__index__;IHEAP[_j2k_dec_mstab+236]=_j2k_read_unk.__index__;IHEAP[_mqc_states+8]=_mqc_states+32;IHEAP[_mqc_states+12]=_mqc_states+48;IHEAP[_mqc_states+24]=_mqc_states+48;IHEAP[_mqc_states+28]=_mqc_states+32;IHEAP[_mqc_states+40]=_mqc_states+64;IHEAP[_mqc_states+44]=_mqc_states+192;IHEAP[_mqc_states+56]=_mqc_states+80;IHEAP[_mqc_states+60]=_mqc_states+208;IHEAP[_mqc_states+72]=_mqc_states+96;IHEAP[_mqc_states+76]=_mqc_states+288;IHEAP[_mqc_states+
88]=_mqc_states+112;IHEAP[_mqc_states+92]=_mqc_states+304;IHEAP[_mqc_states+104]=_mqc_states+128;IHEAP[_mqc_states+108]=_mqc_states+384;IHEAP[_mqc_states+120]=_mqc_states+144;IHEAP[_mqc_states+124]=_mqc_states+400;IHEAP[_mqc_states+136]=_mqc_states+160;IHEAP[_mqc_states+140]=_mqc_states+928;IHEAP[_mqc_states+152]=_mqc_states+176;IHEAP[_mqc_states+156]=_mqc_states+944;IHEAP[_mqc_states+168]=_mqc_states+1216;IHEAP[_mqc_states+172]=_mqc_states+1056;IHEAP[_mqc_states+184]=_mqc_states+1232;IHEAP[_mqc_states+
188]=_mqc_states+1072;IHEAP[_mqc_states+200]=_mqc_states+224;IHEAP[_mqc_states+204]=_mqc_states+208;IHEAP[_mqc_states+216]=_mqc_states+240;IHEAP[_mqc_states+220]=_mqc_states+192;IHEAP[_mqc_states+232]=_mqc_states+256;IHEAP[_mqc_states+236]=_mqc_states+448;IHEAP[_mqc_states+248]=_mqc_states+272;IHEAP[_mqc_states+252]=_mqc_states+464;IHEAP[_mqc_states+264]=_mqc_states+288;IHEAP[_mqc_states+268]=_mqc_states+448;IHEAP[_mqc_states+280]=_mqc_states+304;IHEAP[_mqc_states+284]=_mqc_states+464;IHEAP[_mqc_states+
296]=_mqc_states+320;IHEAP[_mqc_states+300]=_mqc_states+448;IHEAP[_mqc_states+312]=_mqc_states+336;IHEAP[_mqc_states+316]=_mqc_states+464;IHEAP[_mqc_states+328]=_mqc_states+352;IHEAP[_mqc_states+332]=_mqc_states+544;IHEAP[_mqc_states+344]=_mqc_states+368;IHEAP[_mqc_states+348]=_mqc_states+560;IHEAP[_mqc_states+360]=_mqc_states+384;IHEAP[_mqc_states+364]=_mqc_states+576;IHEAP[_mqc_states+376]=_mqc_states+400;IHEAP[_mqc_states+380]=_mqc_states+592;IHEAP[_mqc_states+392]=_mqc_states+416;IHEAP[_mqc_states+
396]=_mqc_states+640;IHEAP[_mqc_states+408]=_mqc_states+432;IHEAP[_mqc_states+412]=_mqc_states+656;IHEAP[_mqc_states+424]=_mqc_states+928;IHEAP[_mqc_states+428]=_mqc_states+672;IHEAP[_mqc_states+440]=_mqc_states+944;IHEAP[_mqc_states+444]=_mqc_states+688;IHEAP[_mqc_states+456]=_mqc_states+480;IHEAP[_mqc_states+460]=_mqc_states+464;IHEAP[_mqc_states+472]=_mqc_states+496;IHEAP[_mqc_states+476]=_mqc_states+448;IHEAP[_mqc_states+488]=_mqc_states+512;IHEAP[_mqc_states+492]=_mqc_states+448;IHEAP[_mqc_states+
504]=_mqc_states+528;IHEAP[_mqc_states+508]=_mqc_states+464;IHEAP[_mqc_states+520]=_mqc_states+544;IHEAP[_mqc_states+524]=_mqc_states+480;IHEAP[_mqc_states+536]=_mqc_states+560;IHEAP[_mqc_states+540]=_mqc_states+496;IHEAP[_mqc_states+552]=_mqc_states+576;IHEAP[_mqc_states+556]=_mqc_states+512;IHEAP[_mqc_states+568]=_mqc_states+592;IHEAP[_mqc_states+572]=_mqc_states+528;IHEAP[_mqc_states+584]=_mqc_states+608;IHEAP[_mqc_states+588]=_mqc_states+544;IHEAP[_mqc_states+600]=_mqc_states+624;IHEAP[_mqc_states+
604]=_mqc_states+560;IHEAP[_mqc_states+616]=_mqc_states+640;IHEAP[_mqc_states+620]=_mqc_states+576;IHEAP[_mqc_states+632]=_mqc_states+656;IHEAP[_mqc_states+636]=_mqc_states+592;IHEAP[_mqc_states+648]=_mqc_states+672;IHEAP[_mqc_states+652]=_mqc_states+608;IHEAP[_mqc_states+664]=_mqc_states+688;IHEAP[_mqc_states+668]=_mqc_states+624;IHEAP[_mqc_states+680]=_mqc_states+704;IHEAP[_mqc_states+684]=_mqc_states+608;IHEAP[_mqc_states+696]=_mqc_states+720;IHEAP[_mqc_states+700]=_mqc_states+624;IHEAP[_mqc_states+
712]=_mqc_states+736;IHEAP[_mqc_states+716]=_mqc_states+640;IHEAP[_mqc_states+728]=_mqc_states+752;IHEAP[_mqc_states+732]=_mqc_states+656;IHEAP[_mqc_states+744]=_mqc_states+768;IHEAP[_mqc_states+748]=_mqc_states+672;IHEAP[_mqc_states+760]=_mqc_states+784;IHEAP[_mqc_states+764]=_mqc_states+688;IHEAP[_mqc_states+776]=_mqc_states+800;IHEAP[_mqc_states+780]=_mqc_states+704;IHEAP[_mqc_states+792]=_mqc_states+816;IHEAP[_mqc_states+796]=_mqc_states+720;IHEAP[_mqc_states+808]=_mqc_states+832;IHEAP[_mqc_states+
812]=_mqc_states+736;IHEAP[_mqc_states+824]=_mqc_states+848;IHEAP[_mqc_states+828]=_mqc_states+752;IHEAP[_mqc_states+840]=_mqc_states+864;IHEAP[_mqc_states+844]=_mqc_states+768;IHEAP[_mqc_states+856]=_mqc_states+880;IHEAP[_mqc_states+860]=_mqc_states+784;IHEAP[_mqc_states+872]=_mqc_states+896;IHEAP[_mqc_states+876]=_mqc_states+800;IHEAP[_mqc_states+888]=_mqc_states+912;IHEAP[_mqc_states+892]=_mqc_states+816;IHEAP[_mqc_states+904]=_mqc_states+928;IHEAP[_mqc_states+908]=_mqc_states+832;IHEAP[_mqc_states+
920]=_mqc_states+944;IHEAP[_mqc_states+924]=_mqc_states+848;IHEAP[_mqc_states+936]=_mqc_states+960;IHEAP[_mqc_states+940]=_mqc_states+864;IHEAP[_mqc_states+952]=_mqc_states+976;IHEAP[_mqc_states+956]=_mqc_states+880;IHEAP[_mqc_states+968]=_mqc_states+992;IHEAP[_mqc_states+972]=_mqc_states+896;IHEAP[_mqc_states+984]=_mqc_states+1008;IHEAP[_mqc_states+988]=_mqc_states+912;IHEAP[_mqc_states+1E3]=_mqc_states+1024;IHEAP[_mqc_states+1004]=_mqc_states+928;IHEAP[_mqc_states+1016]=_mqc_states+1040;IHEAP[_mqc_states+
1020]=_mqc_states+944;IHEAP[_mqc_states+1032]=_mqc_states+1056;IHEAP[_mqc_states+1036]=_mqc_states+960;IHEAP[_mqc_states+1048]=_mqc_states+1072;IHEAP[_mqc_states+1052]=_mqc_states+976;IHEAP[_mqc_states+1064]=_mqc_states+1088;IHEAP[_mqc_states+1068]=_mqc_states+992;IHEAP[_mqc_states+1080]=_mqc_states+1104;IHEAP[_mqc_states+1084]=_mqc_states+1008;IHEAP[_mqc_states+1096]=_mqc_states+1120;IHEAP[_mqc_states+1100]=_mqc_states+1024;IHEAP[_mqc_states+1112]=_mqc_states+1136;IHEAP[_mqc_states+1116]=_mqc_states+
1040;IHEAP[_mqc_states+1128]=_mqc_states+1152;IHEAP[_mqc_states+1132]=_mqc_states+1056;IHEAP[_mqc_states+1144]=_mqc_states+1168;IHEAP[_mqc_states+1148]=_mqc_states+1072;IHEAP[_mqc_states+1160]=_mqc_states+1184;IHEAP[_mqc_states+1164]=_mqc_states+1088;IHEAP[_mqc_states+1176]=_mqc_states+1200;IHEAP[_mqc_states+1180]=_mqc_states+1104;IHEAP[_mqc_states+1192]=_mqc_states+1216;IHEAP[_mqc_states+1196]=_mqc_states+1120;IHEAP[_mqc_states+1208]=_mqc_states+1232;IHEAP[_mqc_states+1212]=_mqc_states+1136;IHEAP[_mqc_states+
1224]=_mqc_states+1248;IHEAP[_mqc_states+1228]=_mqc_states+1152;IHEAP[_mqc_states+1240]=_mqc_states+1264;IHEAP[_mqc_states+1244]=_mqc_states+1168;IHEAP[_mqc_states+1256]=_mqc_states+1280;IHEAP[_mqc_states+1260]=_mqc_states+1184;IHEAP[_mqc_states+1272]=_mqc_states+1296;IHEAP[_mqc_states+1276]=_mqc_states+1200;IHEAP[_mqc_states+1288]=_mqc_states+1312;IHEAP[_mqc_states+1292]=_mqc_states+1216;IHEAP[_mqc_states+1304]=_mqc_states+1328;IHEAP[_mqc_states+1308]=_mqc_states+1232;IHEAP[_mqc_states+1320]=_mqc_states+
1344;IHEAP[_mqc_states+1324]=_mqc_states+1248;IHEAP[_mqc_states+1336]=_mqc_states+1360;IHEAP[_mqc_states+1340]=_mqc_states+1264;IHEAP[_mqc_states+1352]=_mqc_states+1376;IHEAP[_mqc_states+1356]=_mqc_states+1280;IHEAP[_mqc_states+1368]=_mqc_states+1392;IHEAP[_mqc_states+1372]=_mqc_states+1296;IHEAP[_mqc_states+1384]=_mqc_states+1408;IHEAP[_mqc_states+1388]=_mqc_states+1312;IHEAP[_mqc_states+1400]=_mqc_states+1424;IHEAP[_mqc_states+1404]=_mqc_states+1328;IHEAP[_mqc_states+1416]=_mqc_states+1440;IHEAP[_mqc_states+
1420]=_mqc_states+1344;IHEAP[_mqc_states+1432]=_mqc_states+1456;IHEAP[_mqc_states+1436]=_mqc_states+1360;IHEAP[_mqc_states+1448]=_mqc_states+1440;IHEAP[_mqc_states+1452]=_mqc_states+1376;IHEAP[_mqc_states+1464]=_mqc_states+1456;IHEAP[_mqc_states+1468]=_mqc_states+1392;IHEAP[_mqc_states+1480]=_mqc_states+1472;IHEAP[_mqc_states+1484]=_mqc_states+1472;IHEAP[_mqc_states+1496]=_mqc_states+1488;IHEAP[_mqc_states+1500]=_mqc_states+1488;IHEAP[_getopt_place]=__str98;_STDIO.init();__globalConstructor__()}
Module.run=run;
