/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.SequenceList;
import org.emboss.jemboss.programs.RunEmbossApplication2;
import org.emboss.jemboss.server.JembossThread;

public class JembossServer {
    private String fs = System.getProperty("file.separator");
    JembossParams jp = new JembossParams();
    String plplot = this.jp.getPlplot();
    String embossData = this.jp.getEmbossData();
    String embossBin = this.jp.getEmbossBin();
    String embossPath = this.jp.getEmbossPath();
    String acdDirToParse = this.jp.getAcdDirToParse();
    String[] embossCommandA = null;
    private String homeDirectory = System.getProperty("user.home") + this.fs;
    private String username = System.getProperty("user.name") + this.fs;
    private String tmproot = this.jp.getResultsHome() + this.username;
    private File tmprootDir = new File(this.tmproot);
    private String[] envp_emboss = new String[]{"PATH=" + this.embossPath + System.getProperty("path.separator") + this.embossBin, "PLPLOT_LIB=" + this.plplot, "HOME=" + this.homeDirectory, "EMBOSSCYGROOT=" + JembossParams.getCygwinRoot()};
    private String[] envp = this.jp.getEmbossEnvironmentArray(this.envp_emboss);

    public JembossServer() {
    }

    public JembossServer(String tmproot) {
        this.tmproot = tmproot;
        this.tmprootDir = new File(tmproot);
    }

    public String name() {
        return "The EMBOSS Application Suite";
    }

    public String version() {
        String embossCommand = new String(this.embossBin + "embossversion");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, this.envp, null);
        try {
            Process p = rea.getProcess();
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return rea.getProcessStdout();
    }

    public String appversion() {
        String embossCommand = new String(this.embossBin + "embossversion");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, this.envp, null);
        try {
            Process p = rea.getProcess();
            p.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return rea.getProcessStdout();
    }

    public String about() {
        return "Jemboss is an interface to the EMBOSS suite of programs.";
    }

    public String helpurl() {
        return "http://www.uk.embnet.org/Software/EMBOSS/";
    }

    public String abouturl() {
        return "http://www.uk.embnet.org/Software/EMBOSS/overview.html";
    }

    public String docurl() {
        return "http://www.uk.embnet.org/Software/EMBOSS/general.html";
    }

    public Hashtable servicedesc() {
        Hashtable<String, String> desc = new Hashtable<String, String>();
        desc.put("name", this.name());
        desc.put("version", this.version());
        desc.put("appversion", this.appversion());
        desc.put("about", this.about());
        desc.put("helpurl", this.helpurl());
        desc.put("abouturl", this.abouturl());
        desc.put("docurl", this.docurl());
        return desc;
    }

    public Vector show_acd(String appName) {
        Vector<String> acd = new Vector<String>();
        String acdText = new String("");
        String acdToParse = new String(this.acdDirToParse + appName + ".acd");
        try {
            String line;
            BufferedReader in = new BufferedReader(new FileReader(acdToParse));
            while ((line = in.readLine()) != null) {
                if (line.startsWith("#") || line.equals("")) continue;
                line = line.trim();
                line = line.replace('}', ')');
                acdText = acdText.concat(line + "\n");
            }
        }
        catch (IOException e) {
            System.out.println("Cannot open EMBOSS acd file " + acdToParse);
        }
        acd.add("status");
        acd.add("0");
        acd.add("acd");
        acd.add(acdText);
        return acd;
    }

    public Vector getWossname() {
        Vector<String> wossOut = new Vector<String>();
        String embossCommand = new String(this.embossBin + "wossname -colon -auto");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, this.envp, null);
        wossOut.add("status");
        wossOut.add("0");
        try {
            Process p = rea.getProcess();
            p.waitFor();
        }
        catch (InterruptedException iexp) {
            // empty catch block
        }
        wossOut.add("wossname");
        wossOut.add(rea.getProcessStdout());
        return wossOut;
    }

    public Vector show_help(String applName) {
        String command = this.embossBin.concat("tfm " + applName + " -html -nomore");
        RunEmbossApplication2 rea = new RunEmbossApplication2(command, this.envp, null);
        try {
            Process p = rea.getProcess();
            p.waitFor();
        }
        catch (InterruptedException iexp) {
            // empty catch block
        }
        String helptext = rea.getProcessStdout();
        if (helptext.equals("")) {
            helptext = "No help available for this application.";
        }
        Vector<String> vans = new Vector<String>();
        vans.add("helptext");
        vans.add(helptext);
        return vans;
    }

    public Vector call_ajax(String fileContent, String seqtype, String userName) {
        return this.call_ajax(fileContent, seqtype);
    }

    public Vector call_ajax(String fileContent, String seqtype) {
        Vector<Object> vans = new Vector<Object>();
        int ajaxLength = SequenceList.getSeqAttr(fileContent, new JembossParams());
        vans.add("status");
        if (ajaxLength == -1) {
            vans.add("1");
        } else {
            vans.add("0");
            vans.add("length");
            vans.add(new Integer(ajaxLength));
        }
        return vans;
    }

    public Vector show_db() {
        int i;
        Vector<String> showdbOut = new Vector<String>();
        String embossCommand = new String(this.embossBin + "showdb -auto");
        RunEmbossApplication2 rea = new RunEmbossApplication2(embossCommand, this.envp, null);
        showdbOut.add("status");
        showdbOut.add("0");
        try {
            Process p = rea.getProcess();
            p.waitFor();
        }
        catch (InterruptedException iexp) {
            // empty catch block
        }
        showdbOut.add("showdb");
        showdbOut.add(rea.getProcessStdout());
        String[] dataFile = new File(this.embossData).list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File fileName = new File(dir, name);
                return !fileName.isDirectory();
            }
        });
        String matrices = "";
        for (i = 0; i < dataFile.length; ++i) {
            matrices = matrices.concat(dataFile[i] + "\n");
        }
        showdbOut.add("matrices");
        showdbOut.add(matrices);
        dataFile = new File(this.embossData + this.fs + "CODONS").list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File fileName = new File(dir, name);
                return !fileName.isDirectory();
            }
        });
        matrices = "";
        for (i = 0; i < dataFile.length; ++i) {
            matrices = matrices.concat(dataFile[i] + "\n");
        }
        showdbOut.add("codons");
        showdbOut.add(matrices);
        return showdbOut;
    }

    public Vector run_prog(String embossCommand, String options, String[] inFiles) {
        Vector result = new Vector();
        Hashtable<String, String> inF = new Hashtable<String, String>();
        for (int i = 0; i < inFiles.length; i += 2) {
            inF.put(inFiles[i], inFiles[i + 1]);
        }
        result = this.run_prog(embossCommand, options, inF);
        return result;
    }

    public Vector run_prog(String embossCommand, String options, Vector inFiles, String userName) {
        Hashtable hashInFiles = this.getHashtable(inFiles);
        this.tmproot = this.tmproot.concat(userName + this.fs);
        return this.run_prog(embossCommand, options, hashInFiles);
    }

    public Vector run_prog(String embossCommand, String options, Hashtable inFiles) {
        boolean ok;
        Vector result = new Vector();
        if (embossCommand.indexOf(";") > -1) {
            result.add("msg");
            result.add("ERROR: Disallowed command syntax " + embossCommand);
            result.add("status");
            result.add("1");
            return result;
        }
        int stdIndex = embossCommand.indexOf(" stdout ");
        if (stdIndex > -1) {
            String startCmd = embossCommand.substring(0, stdIndex + 7);
            String endCmd = embossCommand.substring(stdIndex + 8);
            embossCommand = startCmd.concat("file ");
            embossCommand = embossCommand.concat(endCmd);
        }
        Enumeration enumFiles = inFiles.keys();
        String appl = embossCommand.substring(0, embossCommand.indexOf(" "));
        String rest = embossCommand.substring(embossCommand.indexOf(" "));
        embossCommand = this.embossBin.concat(embossCommand);
        String msg = new String("");
        if (!this.tmprootDir.isDirectory()) {
            ok = this.tmprootDir.mkdirs();
            if (ok) {
                System.out.println("Created directory " + this.tmproot);
            } else {
                System.out.println("Failed to create directory " + this.tmproot);
            }
        }
        Random rnd = new Random();
        String dat = new Date().toString();
        dat = dat.replace(':', '_');
        String project = new String(this.tmproot + appl + "_" + dat.replace(' ', '_') + "_" + rnd.nextInt(99999));
        File projectDir = new File(project);
        ok = projectDir.mkdirs();
        File desc = new File(new String(project + this.fs + ".desc"));
        String ls = System.getProperty("line.separator");
        String descript = "";
        try {
            PrintWriter dout = new PrintWriter(new FileWriter(desc));
            descript = descript.concat("EMBOSS run details" + ls + ls + "Application: " + appl + ls + rest + "Started at " + dat + ls + ls + "Input files:");
            dout.println("EMBOSS run details" + ls + ls);
            dout.println("Application: " + appl + ls + rest);
            dout.println("Started at " + dat + ls + ls + "Input files:");
            while (enumFiles.hasMoreElements()) {
                String thiskey = enumFiles.nextElement().toString();
                File f = new File(project + this.fs + thiskey);
                descript = descript.concat(project + this.fs + thiskey);
                dout.println(project + this.fs + thiskey);
                try {
                    f.createNewFile();
                    FileOutputStream out = new FileOutputStream(f);
                    out.write((byte[])inFiles.get(thiskey));
                    out.close();
                }
                catch (IOException ioe) {
                    msg = new String("Error making input file");
                }
            }
            dout.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        RunEmbossApplication2 rea = this.embossCommandA != null ? new RunEmbossApplication2(this.embossCommandA, this.envp, new File(project)) : new RunEmbossApplication2(embossCommand, this.envp, new File(project));
        result.add("cmd");
        result.add(appl + " " + rest);
        result.add("msg");
        result.add(msg);
        result.add("status");
        result.add("0");
        if (options.toLowerCase().indexOf("interactive") > -1) {
            String stdout = "";
            String stderr = "";
            try {
                if (rea.getProcess() != null) {
                    rea.getProcess().waitFor();
                    stdout = rea.getProcessStdout();
                    stderr = rea.getProcessStderr();
                } else {
                    System.err.println(rea.getInitialIOError());
                }
            }
            catch (InterruptedException iexp) {
                // empty catch block
            }
            if (!stdout.equals("")) {
                result.add("stdout");
                result.add(stdout);
            }
            if (!stderr.equals("")) {
                result.add("stderr");
                result.add(stderr);
            }
            this.createFinishedFile(project);
        } else {
            JembossThread jt = new JembossThread(rea, project);
            jt.start();
            result.add("job_submitted");
            result.add("Job " + projectDir.getName() + "submitted.");
            result.add("jobid");
            result.add(projectDir.getName());
            result.add("description");
            result.add(descript + ls + "Application pending" + ls);
        }
        result = this.loadFilesContent(projectDir, project, result, inFiles);
        result = this.loadPNGContent(projectDir, project, result);
        return result;
    }

    private void createFinishedFile(String project) {
        File finished = new File(new String(project + this.fs + ".finished"));
        try {
            PrintWriter fout = new PrintWriter(new FileWriter(finished));
            fout.println(new Date().toString());
            fout.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Vector show_saved_results(String project, String cl, String userName) {
        Vector ssr = new Vector();
        this.tmproot = this.tmproot.concat(userName + this.fs);
        ssr = this.show_saved_results(project, cl);
        return ssr;
    }

    public Vector show_saved_results(String project, String cl) {
        Vector ssr = new Vector();
        project = this.tmproot.concat(project);
        File projectDir = new File(project);
        if (cl.equals("")) {
            ssr = this.loadFilesContent(projectDir, project, ssr, null);
            ssr = this.loadPNGContent(projectDir, project, ssr);
        } else {
            try {
                String fc = "";
                File fn = new File(project + this.fs + cl);
                if (fn.exists()) {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(project + this.fs + cl));
                    while ((line = in.readLine()) != null) {
                        fc = fc.concat(line + "\n");
                    }
                }
                ssr.add(cl);
                ssr.add(fc);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        ssr.add("status");
        ssr.add("0");
        ssr.add("msg");
        ssr.add("OK");
        return ssr;
    }

    public Vector save_project_file(String project, String filename, String notes, String userName) {
        return this.save_project_file(userName + this.fs + project, filename, notes);
    }

    public Vector save_project_file(String project, String filename, String notes) {
        Vector<String> v = new Vector<String>();
        String msg = "OK";
        String fn = this.tmproot + this.fs + project + this.fs + filename;
        File f = new File(fn);
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(f);
            out.write(notes.getBytes());
            out.close();
        }
        catch (IOException ioe) {
            msg = new String("Error making input file");
        }
        v.add("status");
        v.add("0");
        v.add("msg");
        v.add(msg);
        return v;
    }

    public Vector delete_saved_results(String project, String cl, String userName) {
        Vector dsr = new Vector();
        this.tmproot = this.tmproot.concat(userName + this.fs);
        dsr = this.delete_saved_results(project, cl);
        return dsr;
    }

    public Vector delete_saved_results(String project, String cl) {
        Vector<String> dsr = new Vector<String>();
        StringTokenizer st = new StringTokenizer(project, "\n");
        while (st.hasMoreTokens()) {
            String proj = this.tmproot.concat(this.fs + st.nextToken());
            File projectDir = new File(proj);
            File[] resFiles = projectDir.listFiles();
            for (int i = 0; i < resFiles.length; ++i) {
                resFiles[i].delete();
            }
            projectDir.delete();
        }
        dsr.add("status");
        dsr.add("0");
        dsr.add("msg");
        dsr.add("Results deleted successfully.");
        return dsr;
    }

    public Vector list_saved_results(String userName) {
        Vector lsr = new Vector();
        this.tmproot = this.tmproot.concat(userName + this.fs);
        this.tmprootDir = new File(this.tmproot);
        lsr = this.list_saved_results();
        return lsr;
    }

    public Vector list_saved_results() {
        Vector<String> lsr = new Vector<String>();
        lsr.add("status");
        lsr.add("0");
        lsr.add("msg");
        lsr.add("OK");
        String[] resFiles = this.tmprootDir.list(new FilenameFilter(){

            public boolean accept(File cwd, String name) {
                return !name.startsWith(".");
            }
        });
        String list = "";
        for (int i = 0; i < resFiles.length; ++i) {
            String line = new String("");
            String fc = new String("");
            try {
                BufferedReader in = new BufferedReader(new FileReader(this.tmproot + this.fs + resFiles[i] + this.fs + ".desc"));
                while ((line = in.readLine()) != null) {
                    fc = fc.concat(line + "\n");
                }
                lsr.add(resFiles[i]);
                lsr.add(fc);
                list = list.concat(resFiles[i] + "\n");
                continue;
            }
            catch (IOException ioe) {
                System.out.println("IOException in list_saved_results " + this.tmproot + this.fs + resFiles[i] + this.fs + ".desc");
            }
        }
        lsr.add("list");
        lsr.add(list);
        return lsr;
    }

    private Vector loadFilesContent(File projectDir, String project, Vector result, Hashtable inFiles) {
        String[] outFiles = projectDir.list(new FilenameFilter(){

            public boolean accept(File cwd, String name) {
                return !name.startsWith(".") && !name.endsWith(".png");
            }
        });
        for (int i = 0; i < outFiles.length; ++i) {
            StringBuffer buf;
            BufferedReader in;
            File outfile;
            String line = new String("");
            String fc = new String("");
            String key = new String(outFiles[i]);
            if (inFiles != null) {
                if (!inFiles.containsKey(key)) {
                    try {
                        outfile = new File(project + this.fs + outFiles[i]);
                        in = new BufferedReader(new FileReader(outfile));
                        buf = new StringBuffer((int)outfile.length());
                        while ((line = in.readLine()) != null) {
                            buf.append(line);
                            buf.append("\n");
                        }
                        fc = buf.toString();
                    }
                    catch (IOException ioe) {}
                }
            } else {
                try {
                    outfile = new File(project + this.fs + outFiles[i]);
                    in = new BufferedReader(new FileReader(outfile));
                    buf = new StringBuffer((int)outfile.length());
                    while ((line = in.readLine()) != null) {
                        buf.append(line);
                        buf.append("\n");
                    }
                    fc = buf.toString();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
            if (fc.equals("")) continue;
            result.add(key);
            result.add(fc);
        }
        return result;
    }

    private Vector loadPNGContent(File projectDir, String project, Vector result) {
        String[] pngFiles = projectDir.list(new FilenameFilter(){

            public boolean accept(File cwd, String name) {
                return name.endsWith(".png") || name.endsWith(".dat");
            }
        });
        for (int i = 0; i < pngFiles.length; ++i) {
            String key = new String(pngFiles[i]);
            byte[] data = JembossServer.readByteFile(project + this.fs + pngFiles[i]);
            if (data == null) continue;
            result.add(key);
            result.add(data);
        }
        return result;
    }

    protected static byte[] readByteFile(String filename) {
        File fn = new File(filename);
        byte[] b = null;
        try {
            long s = fn.length();
            if (s == 0L) {
                return b;
            }
            b = new byte[(int)s];
            FileInputStream fi = new FileInputStream(fn);
            fi.read(b);
            fi.close();
        }
        catch (IOException ioe) {
            System.out.println("Cannot read file: " + filename);
        }
        return b;
    }

    public Vector update_result_status(String prog, String opt, Vector resToQuery, String userName) {
        return this.update_result_status(prog, opt, this.getHashtable(resToQuery), userName);
    }

    public Vector update_result_status(String prog, String opt, Hashtable resToQuery, String userName) {
        this.tmproot = this.tmproot.concat(userName + this.fs);
        return this.update_result_status(prog, opt, resToQuery);
    }

    public Vector update_result_status(String prog, String opt, Hashtable resToQuery) {
        Vector<String> vans = new Vector<String>();
        Enumeration enumRes = resToQuery.keys();
        while (enumRes.hasMoreElements()) {
            String thiskey = enumRes.nextElement().toString();
            File f = new File(this.tmproot + this.fs + thiskey + this.fs + ".finished");
            if (f.exists()) {
                vans.add(thiskey);
                vans.add("complete");
                String fc = "";
                try {
                    String line;
                    BufferedReader in = new BufferedReader(new FileReader(this.tmproot + this.fs + thiskey + this.fs + ".desc"));
                    while ((line = in.readLine()) != null) {
                        fc = fc.concat(line + "\n");
                    }
                }
                catch (IOException ioe) {
                    fc = "Error in reading information file";
                }
                vans.add(thiskey + "-description");
                vans.add(fc);
                continue;
            }
            vans.add(thiskey);
            vans.add("pending");
        }
        return vans;
    }

    private Hashtable getHashtable(Vector v) {
        Hashtable h = new Hashtable();
        Enumeration e = v.elements();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            h.put(s, e.nextElement());
        }
        return h;
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public void setEmbossCommandA(String[] embossCommandA) {
        this.embossCommandA = embossCommandA;
    }
}

