/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.emboss.jemboss.editor.GraphicSequenceCollection;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollectionEvent;
import org.emboss.jemboss.editor.GroutGraphicSequenceCollectionListener;
import org.emboss.jemboss.editor.GroutSequence;
import org.emboss.jemboss.editor.GroutSequenceJPanel;
import org.emboss.jemboss.editor.Sequence;
import org.emboss.jemboss.editor.SequenceJPanel;
import org.emboss.jemboss.editor.SequenceNameJButton;

public class GroutGraphicSequenceCollection
extends GraphicSequenceCollection
implements AdjustmentListener {
    Vector targets;

    public GroutGraphicSequenceCollection(Vector seqs, Hashtable colorScheme, JScrollPane jspSequence, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, boolean drawNumber, JTextField statusField) {
        super(seqs, colorScheme, jspSequence, drawSequence, drawBlackBox, drawColorBox, drawNumber, statusField);
        jspSequence.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public GroutGraphicSequenceCollection(Vector seqs, JScrollPane jspSequence, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, boolean drawNumber, JTextField statusField) {
        super(seqs, null, jspSequence, drawSequence, drawBlackBox, drawColorBox, drawNumber, statusField);
        jspSequence.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public GroutGraphicSequenceCollection(Vector seqs, Vector indents, Hashtable colorScheme, JScrollPane jspSequence, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, boolean drawNumber, JTextField statusField) {
        super(seqs, colorScheme, jspSequence, drawSequence, drawBlackBox, drawColorBox, drawNumber, statusField);
        this.doIndent(indents);
        jspSequence.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public GroutGraphicSequenceCollection(Vector seqs, Vector indents, JScrollPane jspSequence, boolean drawSequence, boolean drawBlackBox, boolean drawColorBox, boolean drawNumber, JTextField statusField) {
        super(seqs, null, jspSequence, drawSequence, drawBlackBox, drawColorBox, drawNumber, statusField);
        this.doIndent(indents);
        jspSequence.getHorizontalScrollBar().addAdjustmentListener(this);
    }

    public void doIndent(Vector indents) {
        int i;
        Vector numberSequenceJpanels = new Vector();
        int limit = this.graphicSequence.size();
        int drawNumberJPanels = 0;
        for (i = 0; i < limit; ++i) {
            if (!((SequenceJPanel)this.graphicSequence.elementAt((int)i)).drawNumber) {
                ((GroutSequenceJPanel)this.graphicSequence.elementAt(i)).setIndent((Integer)indents.elementAt(i - drawNumberJPanels));
                this.setMaxSequenceLength(((GroutSequence)this.seqs.elementAt(i - drawNumberJPanels)).getLength());
                continue;
            }
            numberSequenceJpanels.addElement(this.graphicSequence.elementAt(i));
            ((GroutSequenceJPanel)this.graphicSequence.elementAt(i)).setIndent((Integer)indents.elementAt(drawNumberJPanels));
            ++drawNumberJPanels;
        }
        for (i = 0; i < numberSequenceJpanels.size(); ++i) {
            ((SequenceJPanel)numberSequenceJpanels.elementAt(i)).setSequenceLength(this.MAXSEQLENGTH);
        }
    }

    protected void addSequence(Sequence seq, boolean addToSequences, int ypad, int fontSize, int index) {
        if (addToSequences) {
            this.seqs.add(index, seq);
        }
        if (this.drawNumber) {
            ++index;
        }
        GroutSequenceJPanel gs = new GroutSequenceJPanel(seq, this, this.drawSequence, this.drawBlackBox, this.drawColorBox, this.colorScheme, ypad);
        this.graphicSequence.add(index, gs);
        for (int i = 0; i < this.graphicSequence.size(); ++i) {
        }
        Box XBox = new Box(0);
        XBox.add(gs);
        XBox.add(Box.createHorizontalGlue());
        this.seqBox.add((Component)XBox, index);
        gs.setToolTipText("");
        SequenceNameJButton snj = new SequenceNameJButton(seq, ypad);
        this.graphicName.add(index, snj);
        XBox = new Box(0);
        XBox.add(Box.createHorizontalGlue());
        XBox.add(snj);
        this.seqNameBox.add((Component)XBox, index);
        if (seq.getLength() > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = seq.getLength();
        }
        Dimension actual = gs.getMaximumSize();
        int slen = gs.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
        gs.setMaximumSize(new Dimension(slen, (int)actual.getHeight()));
    }

    protected void addSequence(Sequence seq, boolean addToSequences, int ypad, int fontSize) {
        if (addToSequences) {
            this.seqs.add(seq);
        }
        GroutSequenceJPanel gs = new GroutSequenceJPanel(seq, this, this.drawSequence, this.drawBlackBox, this.drawColorBox, this.colorScheme, fontSize, ypad);
        this.graphicSequence.add(gs);
        Box XBox = new Box(0);
        XBox.add(gs);
        XBox.add(Box.createHorizontalGlue());
        this.seqBox.add(XBox);
        gs.setToolTipText("");
        SequenceNameJButton snj = new SequenceNameJButton(seq, ypad);
        this.graphicName.add(snj);
        XBox = new Box(0);
        XBox.add(Box.createHorizontalGlue());
        XBox.add(snj);
        this.seqNameBox.add(XBox);
        if (seq.getLength() > this.MAXSEQLENGTH) {
            this.MAXSEQLENGTH = seq.getLength();
        }
        Dimension actual = gs.getMaximumSize();
        int slen = gs.getResidueWidth() * (int)((double)this.MAXSEQLENGTH * 1.2);
        gs.setMaximumSize(new Dimension(slen, (int)actual.getHeight()));
    }

    public void setPosition(int position) {
        int extent = this.jspSequence.getHorizontalScrollBar().getVisibleAmount();
        int residueWidth = ((SequenceJPanel)this.graphicSequence.elementAt(0)).getResidueWidth();
        int bottom = position * residueWidth - extent / 2;
        if (bottom < 0) {
            bottom = 0;
        }
        this.jspSequence.getHorizontalScrollBar().setValue(bottom);
    }

    private void addResidue() {
        int resPos = 1;
        int pressedResidue = 0;
        String padChar = new String("-");
        for (int i = 0; i < this.graphicSequence.size(); ++i) {
            SequenceJPanel seqP = (SequenceJPanel)this.graphicSequence.elementAt(i);
            if (seqP.seq == null || resPos != pressedResidue + 1 || resPos <= 0) continue;
            seqP.seq.insertResidue(padChar, pressedResidue);
            this.setMaxSequenceLength(seqP.seq.getLength());
            seqP.paintComponent(this.getGraphics());
            seqP.viewPaneResize();
        }
    }

    public int getScrollableBlockIncrement(Rectangle r, int orientation, int direction) {
        return 60;
    }

    public int getScrollableUnitIncrement(Rectangle r, int orientation, int direction) {
        if (this.graphicSequence.elementAt(0) != null) {
            return ((SequenceJPanel)this.graphicSequence.elementAt(0)).getResidueWidth();
        }
        return 18;
    }

    public synchronized void addGroutGraphicSequenceCollectionListener(GroutGraphicSequenceCollectionListener listener) {
        if (this.targets == null) {
            this.targets = new Vector();
        }
        this.targets.addElement(listener);
    }

    public synchronized void removeGroutGraphicSequenceCollectionListener(GroutGraphicSequenceCollectionListener listener) {
        this.targets.removeElement(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyTargets(String propertyName, Object oldValue, Object newValue) {
        Vector l;
        GroutGraphicSequenceCollectionEvent s = new GroutGraphicSequenceCollectionEvent(this, propertyName, oldValue, newValue);
        GroutGraphicSequenceCollection groutGraphicSequenceCollection = this;
        synchronized (groutGraphicSequenceCollection) {
            l = (Vector)this.targets.clone();
        }
        for (int i = 0; i < l.size(); ++i) {
            GroutGraphicSequenceCollectionListener sl = (GroutGraphicSequenceCollectionListener)l.elementAt(i);
            sl.groutGraphicSequenceCollectionChanged(s);
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent evt) {
        if (this.graphicSequence.size() > 0) {
            int bottom = this.jspSequence.getHorizontalScrollBar().getValue();
            int extent = this.jspSequence.getHorizontalScrollBar().getVisibleAmount();
            int residueWidth = ((SequenceJPanel)this.graphicSequence.elementAt(0)).getResidueWidth();
            int middlePosition = (bottom + extent / 2) / residueWidth;
            this.notifyTargets("sequencePositionChanged", new Integer(0), new Integer(middlePosition));
        }
    }

    protected void drawNumber() {
        this.numberDraw = new GroutSequenceJPanel(10, this.MAXSEQLENGTH);
        this.addGroutGraphicSequenceCollectionListener((GroutSequenceJPanel)this.numberDraw);
        this.graphicSequence.add(this.numberDraw);
        for (int i = 0; i < this.graphicSequence.size(); ++i) {
        }
        Box XBox = new Box(0);
        XBox.add(this.numberDraw);
        XBox.add(Box.createHorizontalGlue());
        this.seqBox.add(XBox);
        this.setNumberSize();
        SequenceNameJButton snjBlank = new SequenceNameJButton(new Sequence(" "), 0);
        this.graphicName.add(snjBlank);
        this.seqNameBox.add(snjBlank);
    }

    public int setSize() {
        Dimension size = this.getPreferredSize();
        size.height = this.numberDraw.seqHeight * this.graphicSequence.size();
        this.setPreferredSize(size);
        return size.height;
    }
}

