# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Author: Benjamin Kampmann <benjamin@fluendo.com>

"""
A simple import and initialize test for the base models.
"""

from elisa.core.media_uri import MediaUri

from elisa.plugins.base.models import audio, video, image, media, network, \
                                      plugin

from twisted.trial.unittest import TestCase

from pkg_resources import Distribution
from distutils.version import LooseVersion


class ModelMixin(object):

    module = None

    def test_import_and_initialize(self):
        models = filter(lambda x: x.endswith('Model'), dir(self.module))
        for model_name in models:
            model_class = getattr(self.module, model_name)
            obj = model_class()


class TestAudioModels(TestCase, ModelMixin):

    module = audio


class TestVideoModels(TestCase, ModelMixin):

    module = video


class TestImageModels(TestCase, ModelMixin):

    module = image


class TestMediaModels(TestCase, ModelMixin):

    module = media

class TestNetworkModels(TestCase, ModelMixin):

    module = network


class TestPluginModels(TestCase, ModelMixin):

    module = plugin

    def test_from_dict(self):
        dictionary = {}
        dictionary['name'] = 'elisa-plugin-test'
        dictionary['tags'] = ['test', 'plugin', 'elisa']
        dictionary['uri'] = 'http://elisa-plugins.com/elisa-plugin-test'
        dictionary['description'] = 'A test plugin that does nothing.'
        dictionary['version'] = '0.1.4'
        dictionary['platforms'] = 'linux, win32'
        dictionary['icons'] = str([{'uri': 'icon1'}, {'uri': 'icon2'}])
        model = plugin.PluginModel.from_dict(dictionary)
        self.failUnlessEqual(model.name, 'elisa-plugin-test')
        self.failUnlessEqual(model.tags, ['test', 'plugin', 'elisa'])
        self.failUnlessEqual(model.uri,
                             'http://elisa-plugins.com/elisa-plugin-test')
        self.failUnlessEqual(model.description,
                             'A test plugin that does nothing.')
        self.failUnlessEqual(model.version, LooseVersion('0.1.4'))
        self.failUnlessEqual(model.platforms, ['linux', 'win32'])
        self.failUnlessEqual(len(model.icons), 2)
        self.failUnless(isinstance(model.icons[0], image.ImageModel))
        self.failUnlessEqual(len(model.icons[0].references), 1)
        self.failUnlessEqual(model.icons[0].references[0], MediaUri('icon1'))
        self.failUnless(isinstance(model.icons[1], image.ImageModel))
        self.failUnlessEqual(len(model.icons[1].references), 1)
        self.failUnlessEqual(model.icons[1].references[0], MediaUri('icon2'))

    def test_from_distribution(self):
        distribution = Distribution(project_name='elisa-plugin-test',
                                    version='0.1.4')
        distribution.author = 'Elisa Developers'
        distribution.license = 'GPLv3'
        distribution.summary = 'A test plugin'
        distribution.description = 'A test plugin that does nothing.'
        model = plugin.PluginModel.from_distribution(distribution)
        self.failUnlessEqual(model.name, 'elisa-plugin-test')
        self.failUnlessEqual(model.version, LooseVersion('0.1.4'))
        self.failUnlessEqual(model.author_name, 'Elisa Developers')
        self.failUnlessEqual(model.license, 'GPLv3')
        self.failUnlessEqual(model.title, 'A test plugin')
        self.failUnlessEqual(model.description,
                             'A test plugin that does nothing.')

    test_from_distribution.todo = "Update test to recent changes"

