import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean, Distribution, build_po

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean, build_po=build_po)

setup(name='elisa-plugin-base',
    version='0.3', 
    description='base elisa components',
    long_description='base elisa components',
    license='UNKNOWN', 
    author='Elisa Developers',
    author_email='elisa@lists.fluendo.com',
    keywords='',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.png'],
                  'elisa.plugins.base.i18n': ['*/LC_MESSAGES/*.[p|m]o', '*.pot']},
    entry_points="""
    [elisa.core.components.resource_provider]
    LocalResource = elisa.plugins.base.local_resource:LocalResource
    """,
    cmdclass=cmdclass,
    distclass=Distribution)
