# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.
#
# Authors: Benjamin Kampmann <benjamin@fluendo.com>
#          Olivier Tilloy <olivier@fluendo.com>
#          Philippe Normand <philippe@fluendo.com>

"""
Common models related to video.
"""

from elisa.core.components.model import Model


class VideoModel(Model):

    """
    Representation of a video.

    @ivar playable_uri: the URI to query the resource provider with to get a
                        playable model containing the real URI of the video
                        file
    @type playable_uri: L{elisa.core.media_uri.MediaUri}
    """

    def __init__(self):
        """
        Constructor. Initialize all the fields.
        """
        super(VideoModel, self).__init__()
        self.playable_uri = None
        
    def get_playable_model(self):
        """
        Return a deferred that will return an instance of
        L{elisa.plugins.base.models.media.PlayableModel} for the video.

        @rtype:  L{elisa.core.utils.defer.Deferred}
        """
        return defer.fail(NotImplementedError())
        
    def get_poster(self):
        """
        Return a deferred that will return the local path of the video poster
        (if available)

        @rtype:  L{elisa.core.utils.defer.Deferred}
        """
        return defer.fail(NotImplementedError())
