# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.graph.text import Text
from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.widgets.theme import Theme
from elisa.plugins.pigment.widgets.widget import Widget
import pgm


class NothingToDisplay(Widget):

    def __init__(self, media_type=None):
        super(NothingToDisplay, self).__init__()
        self._media_type = media_type

        self.text = Text()
        self.add(self.text)
        self.text.alignment = pgm.TEXT_ALIGN_CENTER
        self.text.font_height = 0.32
        self.text.weight = pgm.TEXT_WEIGHT_BOLD

        self.text.x, self.text.y = (0.26, 0.35)
        self.text.width, self.text.height = (0.5, 0.12)
        self.text.bg_color = (0, 200, 0, 0)
        self.text.fg_color = (255, 255, 255, 255)
        self.text.visible = True

        self.icon = Image()
        self.add(self.icon)
        self.icon.alignment = pgm.IMAGE_CENTER
        self.icon.x, self.icon.y = (0.04, 0.25)
        self.icon.width, self.icon.height = (0.2, 0.2)
        self.icon.bg_color = (0, 0, 0, 0)
        self.icon.visible = True
