# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.plugins.pigment.widgets.widget import Widget
from elisa.plugins.pigment.widgets.const import *

from elisa.plugins.pigment.graph.text import Text

import pgm
import gobject

import logging


class Label(Widget):
    """
    A widget displaying text.

    @ivar text: the text of the label
    @type text: unicode
    """

    def __init__(self):
        super(Label, self).__init__()

        self._text = None

        self._text = Text()
        self._text.font_family = "Liberation Sans"
        self._text.font_height = 1.0
        self._text.bg_color = (0, 0, 0, 0)
        self._text.fg_color = (255, 255, 255, 255)
        self._text.ellipsize = pgm.TEXT_ELLIPSIZE_END
        self._text.visible = True

        self.add(self._text)

        self.update_style_properties(self.style.get_items())

    def text__get(self):
        """Get the label's text"""
        return unicode(self._text.label)

    def text__set(self, value):
        """Set the label's text"""
        self._text.label = value or ''

    text = property(text__get, text__set)

    @classmethod
    def _demo_widget(cls, *args, **kwargs):
        widget = cls()
        widget.text = "Hola!"
        widget.height = 0.3
        widget.visible = True

        return widget


if __name__ == '__main__':
    logger = logging.getLogger()
    logger.setLevel(logging.DEBUG)

    label = Label.demo()
    try:
        __IPYTHON__
    except NameError:
        pgm.main()
