# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

import unittest
import sys
import gobject

from pkg_resources import resource_filename

from elisa.plugins.pigment.widgets.range import Range
from elisa.plugins.pigment.widgets.const import *
import pgm

class TestRange(unittest.TestCase):

    def test_simple(self):
        range = Range()

        range.items_number = 12
        self.assertEquals(range.items_number, 12)

        range.current_index = 5
        self.assertEquals(range.current_index, 5)

    def test_update_style_properties(self):
        range = Range()

        range.update_style_properties()

        props = {'background-color': (0, 0, 0, 0),
                 'cursor-color': (0, 0, 0, 0)}
        range.update_style_properties(props)

        self.assertEquals(range._animated_background.bg_color, (0, 0, 0, 0))
        self.assertEquals(range._animated_cursor.bg_color, (0, 0, 0, 0))

    def test_items_number(self):
        range = Range()

        range.items_number = 10
        self.assertEquals(range.items_number, 10)

        range.items_number = 0
        self.assertEquals(range.items_number, 1)

        range.items_number = 10
        range.current_index = 9
        range.items_number = 5
        self.assertEquals(range.current_index, 4)

    def test_current_index(self):
        range = Range()
        range.items_number = 10

        range.current_index = 9
        self.assertEquals(range.current_index, 9)

        range.current_index = 20
        self.assertEquals(range.current_index, 9)

        range.current_index = 0
        self.assertEquals(range.current_index, 0)

        range.current_index = -1
        self.assertEquals(range.current_index, 0)

    def test_do_scrolled(self):
        range = Range()
        range.items_number = 12
        range.current_index = 5

        range.emit('scrolled', 0, 0, 0, pgm.SCROLL_DOWN, 0)
        self.assertEquals(range.current_index, 6)

        range.emit('scrolled', 0, 0, 0, pgm.SCROLL_UP, 0)
        self.assertEquals(range.current_index, 5)

    def test_do_key_press_event(self):
        range = Range()
        range.items_number = 12
        range.current_index = 5

        class FakeEvent(object):
            pass

        event = FakeEvent()
        event.keyval = pgm.keysyms.Down
        range.emit('key-press-event', None, event, None)
        self.assertEquals(range.current_index, 6)

        event = FakeEvent()
        event.keyval = pgm.keysyms.Up
        range.emit('key-press-event', None, event, None)
        self.assertEquals(range.current_index, 5)

    def test_do_focus(self):
        range = Range()

        range.emit('focus', True)
        self.assertEquals(range.state, STATE_SELECTED)

        range.emit('focus', False)
        self.assertEquals(range.state, STATE_NORMAL)

