%%%----------------------------------------------------------------------
%%% File    : ejabberd_tmp_sup.erl
%%% Author  : Alexey Shchepin <alexey@sevcom.net>
%%% Purpose : Supervisor for temporary processess
%%% Created : 18 Jul 2003 by Alexey Shchepin <alexey@sevcom.net>
%%% Id      : $Id: ejabberd_tmp_sup.erl,v 1.1 2003/07/20 20:35:26 aleksey Exp $
%%%----------------------------------------------------------------------

-module(ejabberd_tmp_sup).
-author('alexey@sevcom.net').
-vsn('$Revision: 1.1 $ ').

-export([start_link/2, init/1]).

start_link(Name, Module) ->
    supervisor:start_link({local, Name}, ?MODULE, Module).


init(Module) ->
    {ok, {{simple_one_for_one, 10, 1},
	  [{undefined, {Module, start_link, []},
	    temporary, brutal_kill, worker, [Module]}]}}.
