/*
    Eiciel - GNOME editor of ACL file permissions.
    Copyright (C) 2004-2005 Roger Ferrer Ibez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef EICIEL_MAIN_CONTROLER_HPP
#define EICIEL_MAIN_CONTROLER_HPP

#include <config.hpp>
#include <set>
#include "eiciel_main_window.hpp"
#include "gestor_acl.hpp"
#include "tipus_element_acl.hpp"
#include <gettext.h>

using namespace std;

class EicielWindow;

class EicielMainControler : public sigc::trackable
{
	private:
		GestorACL* gestorACL;
		EicielWindow* finestra;
        set<string> llistatUsuaris;
        set<string> llistatGrups;
		bool hiHaFitxerObert;
        
		bool actualitzantFinestra;
		void actualitzarLlistaACL();
		void actualitzaEntradaACL(TipusElement e, string nom, 
				bool lectura, bool escriptura, bool execucio);
		void eliminarACL(string nomEntrada, TipusElement e);
		void afegirEntradaACL(string s, TipusElement e, bool esDefault);
		void canviACLDefault();
		Glib::ustring ultimMissatgeError;

		bool calActualitzarLlista;
		bool mostrarSystem;

		void generarLlistes();
		void mostrarParticipantsSistema(bool b);
		void comprovarEditable();

        set<string> donaLlistaUsuaris();
        set<string> donaLlistaGrups();
	public:
		void obreFitxer(string s);
		Glib::ustring ultimError();
		bool fitxerObert();
		friend class EicielWindow; 
		EicielMainControler();
		~EicielMainControler();
};

#endif
