/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#include <gtk/gtkmain.h>
#include <gtk/gtkobject.h>

#include "window.h"


namespace { // callback for internal use only

gboolean WinBaseCB::delete_event(GtkWidget*, GdkEvent*, void* data) {
  
  static_cast<WinBase*>(data)->on_delete_event();
  return true; // returning true prevents destroy sig being emitted
               // we call gtk_object_destroy() ourselves in the destructor
}

} // anonymous namespace


WinBase::WinBase(const char* caption, GdkPixbuf* icon_p, bool modal,
		 GtkWindow* parent_p_, GtkWindow* window_p):
			     in_exec_loop(false), is_modal(modal),
			     parent_p(parent_p_) {

  if (window_p) g_window_p = window_p;
  else {
    g_window_p = GTK_WINDOW(gtk_window_new(GTK_WINDOW_TOPLEVEL));
  }
  
  if (caption) gtk_window_set_title(g_window_p, caption);

  if (is_modal) {
    gtk_window_set_modal(g_window_p, true);
    if (parent_p) {
      gtk_window_set_transient_for(g_window_p, parent_p);
      gtk_widget_set_sensitive(GTK_WIDGET(parent_p), false);
    }
  }

  g_signal_connect(G_OBJECT(g_window_p), "delete_event",
		   G_CALLBACK(WinBaseCB::delete_event), this);

  if (icon_p) gtk_window_set_icon(g_window_p, icon_p);
}

WinBase::~WinBase(void) {
  gtk_object_destroy(GTK_OBJECT(g_window_p));
}

int WinBase::get_exec_val(void) const {
  return 0;
}

void WinBase::close(void) {
  if (is_modal && parent_p) gtk_widget_set_sensitive(GTK_WIDGET(parent_p), true);
  gtk_widget_hide_all(GTK_WIDGET(g_window_p));
  if (in_exec_loop) gtk_main_quit();
  // if we have not called exec(), then the dialog is self-owning
  // and it is safe and necessry to call 'delete this'
  else delete this;
}

void WinBase::on_delete_event(void) {
  close();
}

int WinBase::exec(void) {
  in_exec_loop = true;
  gtk_main();
  return get_exec_val();
}
