/* Copyright (C) 2005 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYING distributed with the source files.

*/

#ifndef TREE_PATH_HANDLE_H
#define TREE_PATH_HANDLE_H

#include <gtk/gtktreemodel.h>
#include "shared_handle.h"


class GtkTreePathFree {
public:
  void operator()(GtkTreePath* obj_p) {
    if (obj_p) gtk_tree_path_free(obj_p);
  }
};

typedef ScopedHandle<GtkTreePath*, GtkTreePathFree> TreePathScopedHandle;
typedef SharedHandle<GtkTreePath*, GtkTreePathFree> TreePathSharedHandle;

inline bool operator==(TreePathScopedHandle& h1, TreePathScopedHandle& h2) {
  return !(gtk_tree_path_compare(h1, h2));
}

inline bool operator!=(TreePathScopedHandle& h1, TreePathScopedHandle& h2) {
  return gtk_tree_path_compare(h1, h2);
}

inline bool operator==(TreePathSharedHandle& h1, TreePathSharedHandle& h2) {
  return !(gtk_tree_path_compare(h1, h2));
}

inline bool operator!=(TreePathSharedHandle& h1, TreePathSharedHandle& h2) {
  return gtk_tree_path_compare(h1, h2);
}

#endif
