/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef SETTINGS_H
#define SETTINGS_H

#include "prog_defs.h"

#include <unistd.h>

#include <string>

#include <gtkmm/window.h>
#include <gtkmm/label.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/notebook.h>
#include <gtkmm/entry.h>
#include <gtkmm/checkbutton.h>
#include <gtkmm/radiobutton.h>
#include <gtkmm/box.h>
#include <gtkmm/frame.h>
#include <gtkmm/tooltips.h>
#include <glibmm/convert.h>

#include "settings_help.h"

class IdentityTable: public  Gtk::Table {
  IdentityMessages help_messages;
  Gtk::Label name_label;
  Gtk::Label number_label;
  Gtk::Entry name_entry;
  Gtk::Entry number_entry;
  Gtk::Button name_help_button;
  Gtk::Button number_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_name(void) const {return name_entry.get_text();}
  Glib::ustring get_number(void) const {return number_entry.get_text();}
  void set_name(const Glib::ustring& name) {name_entry.set_text(name);}
  void set_number(const Glib::ustring& number) {number_entry.set_text(number);}
  void clear(void);
  IdentityTable(const int);
};

class ModemTable: public  Gtk::Table {
  ModemMessages help_messages;
  Gtk::Label device_label;
  Gtk::Label lock_label;
  Gtk::Label capabilities_label;
  Gtk::Label rings_label;
  Gtk::Label class_label;
  Gtk::Label dialmode_label;
  Gtk::Entry device_entry;
  Gtk::Entry lock_entry;
  Gtk::Entry capabilities_entry;
  Gtk::Entry rings_entry;
  Gtk::RadioButton auto_button;
  Gtk::RadioButton class1_button;
  Gtk::RadioButton class2_button;
  Gtk::RadioButton class20_button;
  Gtk::RadioButton tone_button;
  Gtk::RadioButton pulse_button;
  Gtk::Label class_box_filler;
  Gtk::Label dialmode_box_filler;
  Gtk::HBox class_box;
  Gtk::HBox dialmode_box;
  Gtk::Frame class_frame;
  Gtk::Frame dialmode_frame;
  Gtk::Button device_help_button;
  Gtk::Button lock_help_button;
  Gtk::Button class_help_button;
  Gtk::Button dialmode_help_button;
  Gtk::Button capabilities_help_button;
  Gtk::Button rings_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_device(void) const {return device_entry.get_text();}
  Glib::ustring get_lock(void) const {return lock_entry.get_text();}
  Glib::ustring get_class(void) const ;
  Glib::ustring get_dialmode(void) const;
  Glib::ustring get_capabilities(void) const {return capabilities_entry.get_text();}
  Glib::ustring get_rings(void) const {return rings_entry.get_text();}
  void set_device(const Glib::ustring& device) {device_entry.set_text(device);}
  void set_lock(const Glib::ustring& lock) {lock_entry.set_text(lock);}
  void set_class(const Glib::ustring& class_string);
  void set_dialmode(const Glib::ustring& dialmode);
  void set_capabilities(const Glib::ustring& capabilities) {capabilities_entry.set_text(capabilities);}
  void set_rings(const Glib::ustring& rings) {rings_entry.set_text(rings);}
  void clear(void);
  ModemTable(const int);
};

class ParmsTable: public  Gtk::Table {
  ParmsMessages help_messages;
  Gtk::Label init_label;
  Gtk::Label reset_label;
  Gtk::Label parms_label;
  Gtk::Entry init_entry;
  Gtk::Entry reset_entry;
  Gtk::Entry parms_entry;
  Gtk::Button init_help_button;
  Gtk::Button reset_help_button;
  Gtk::Button parms_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_init(void) const {return init_entry.get_text();}
  Glib::ustring get_reset(void) const {return reset_entry.get_text();}
  Glib::ustring get_parms(void) const {return parms_entry.get_text();}
  void set_init(const Glib::ustring& init) {init_entry.set_text(init);}
  void set_reset(const Glib::ustring& reset) {reset_entry.set_text(reset);}
  void set_parms(const Glib::ustring& parms) {parms_entry.set_text(parms);}
  void clear(void);
  ParmsTable(const int);
};

class PrintTable: public  Gtk::Table {
  PrintMessages help_messages;
  Gtk::Label command_label;
  Gtk::Label shrink_label;
  Gtk::Entry command_entry;
  Gtk::Entry shrink_entry;
  Gtk::Button command_help_button;
  Gtk::Button shrink_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_command(void) const {return command_entry.get_text();}
  Glib::ustring get_shrink(void) const {return shrink_entry.get_text();}
  void set_command(const Glib::ustring& command) {command_entry.set_text(command);}
  void set_shrink(const Glib::ustring& shrink) {shrink_entry.set_text(shrink);}
  void clear(void);
  PrintTable(const int);
};

class ViewTable: public  Gtk::Table {
  ViewMessages help_messages;
  Gtk::Label ps_view_command_label;
  Gtk::Entry ps_view_command_entry;
  Gtk::Button ps_view_command_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_ps_view_command(void) const {return ps_view_command_entry.get_text();}
  void set_ps_view_command(const Glib::ustring& command) {ps_view_command_entry.set_text(command);}
  void clear(void);
  ViewTable(const int);
};

class LoggingTable: public  Gtk::Table {
  LoggingMessages help_messages;
  Gtk::Label logfile_label;
  Gtk::Entry logfile_entry;
  Gtk::Button logfile_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_logfile(void) const {return logfile_entry.get_text();}
  void set_logfile(const Glib::ustring& logfile) {logfile_entry.set_text(logfile);}
  void clear(void);
  LoggingTable(const int);
};

class PageTable: public  Gtk::Table {
  PageMessages help_messages;
  Gtk::Label page_label;
  Gtk::Label res_label;
  Gtk::RadioButton a4_button;
  Gtk::RadioButton letter_button;
  Gtk::RadioButton legal_button;
  Gtk::RadioButton standard_button;
  Gtk::RadioButton fine_button;
  Gtk::Label page_box_filler;
  Gtk::Label res_box_filler;
  Gtk::HBox page_box;
  Gtk::HBox res_box;
  Gtk::Frame page_frame;
  Gtk::Frame res_frame;
  Gtk::Button page_help_button;
  Gtk::Button res_help_button;
  Gtk::Label filler1;
  Gtk::Label filler2;
  Gtk::Tooltips tooltips;
  void show_help(int);
public:
  SigC::Signal2<void, const Glib::ustring&, const Glib::ustring&> show_help_sig;
  Glib::ustring get_page(void) const;
  Glib::ustring get_res(void) const;
  void set_page(const Glib::ustring& page);
  void set_res(const Glib::ustring& res);
  void clear(void);
  PageTable(const int);
};

class SettingsDialog: public Gtk::Window {

  const int standard_size;
  bool in_run_loop;
  bool is_home_config;
  Glib::ustring rcfile;

  Gtk::Label label;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::Table window_table;
  Gtk::Notebook notebook;
  Gtk::Window& parent;

  IdentityTable identity_table;
  ModemTable modem_table;
  ParmsTable parms_table;
  PrintTable print_table;
  ViewTable view_table;
  LoggingTable logging_table;
  PageTable page_table;

  void selected(bool);
  void read_config(bool search_localfile = true);
  bool write_config(void);
  bool get_prog_parm(const char*, std::string&, Glib::ustring&, Glib::ustring(*)(const std::string&));
  bool get_prog_parm(const char* name, std::string& line, Glib::ustring& result)
    {return get_prog_parm(name, line, result, Glib::locale_to_utf8);}
  bool find_prog_parm(const char*, const std::string&);
  bool get_rcfile_path(bool search_localfile = true);
  void get_reset_settings_prompt(void);
  void get_reset_settings(void);
  void show_help(const Glib::ustring& message, const Glib::ustring& caption);
  void strip(Glib::ustring&);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  // this signal can be used to indicate that settings have changed
  // it is emitted after this dialog has rewritten the ~/.efax-gtkrc
  // and has called configure_prog() and passes the messages
  // returned by configure_prog()
  SigC::Signal1<void, const Glib::ustring&> accepted;
  void run(void);
  SettingsDialog(const int standard_size, Gtk::Window& window, bool skip_old_settings = false);
};

#endif
