/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef PROG_DEFS_H
#define PROG_DEFS_H

#include "config.h"

// deal with any configuration issues arising from config.h

#ifndef HAVE_BOOL
typedef int bool;
const bool false = 0;
const bool true = 1;
#endif

#ifndef HAVE_GETTEXT
inline const char* gettext(const char* text) {
  return text;
}
#endif

// define some common exit codes

#define MEM_ERROR 10
#define CONFIG_ERROR 11
#define COM_ERROR 12
#define FILEOPEN_ERROR 13
#define PIPE_ERROR 14
#define TERM_ERROR 15
#define ARG_ERROR 16
#define EXEC_ERROR 17
#define FORK_ERROR 18

#define RC_FILE "efax-gtkrc"

#include <vector>
#include <string>
#include <glibmm/ustring.h>

using namespace std;    // until I get a Std C++ compliant compiler to test with

#define MAX_TEMP_NAME 12

struct Prog_config {
  Glib::ustring my_name;
  Glib::ustring my_number;
  Glib::ustring lock_file;
  Glib::ustring page_size;  // either 'a4' 'letter' or 'legal'
  Glib::ustring page_dim;
  Glib::ustring resolution;
  char rings;
  bool tone_dial;
  Glib::ustring print_cmd;
  Glib::ustring print_shrink;
  Glib::ustring ps_view_cmd;
  Glib::ustring logfile_name;
  Glib::ustring homedir;
  bool found_rcfile;
  bool GPL_flag;
  std::string fixed_font;
  char receive_dirname[MAX_TEMP_NAME + 1];
  std::vector<std::string> parms;
};

extern Prog_config prog_config;           // defined in main.cpp
Glib::ustring configure_prog(bool reread);// also defined in main.cpp (pass reread as true if
                                          // the program parameters are being reread)

// generic beep() function defined in main.cpp
void beep(void);

// general function for writing an error defined in mainwindow.cpp
// the message must not be larger than PIPE_BUF in size
ssize_t write_error(const char*);

// this function is defined in mainwindow.cpp, and will cause any
// message written to stderr to be taken by the in built error pipe
// in MainWindow.  Only call this in a child process after fork()ing.
int connect_to_stderr(void);

#endif
