/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include "prog_defs.h"

#include <unistd.h>
#include <string>
#include <fstream>

#include <gtkmm/window.h>
#include <gtkmm/menubar.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/box.h>
#include <gtkmm/entry.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <gtkmm/label.h>
#include <gtkmm/frame.h>
#include <glibmm/ustring.h>

#include "efax_controller.h"
#include "fax_list.h"
#include "pipes.h"

class MessageText: public Gtk::ScrolledWindow {

  std::ofstream logfile;
  std::string logfile_name;
  std::string starting_dirname;
  Gtk::TextView text;
  Glib::RefPtr<Gtk::TextTag> red_tag_r;
  SigC::Connection timer_slot_connection;
  void cleanify(string&);
public:
  void write_black_slot(const char* message);
  void write_red_slot(const char* message);
  bool flush_logfile_timer_slot(void);
  void reset_logfile(void);
  MessageText(void);
  ~MessageText(void);
};

class StatusLine: public Gtk::HBox {

  Gtk::Label status_label;
  Gtk::Label help_label;
  Gtk::Frame status_frame;
  Gtk::Frame help_frame;
public:
  void set_colour(const Glib::RefPtr<Gtk::Style>&);
  void write_status(const char* text) {status_label.set_text(text);}
  StatusLine(const int);
};

class MainWindow: public Gtk::Window {

  const int standard_size;
  static Pipe_fifo error_pipe;
  static bool connected_to_stderr;
  Gtk::VBox window_box;
  Gtk::Table table;
  Gtk::MenuBar menu_bar;
  Gtk::HBox file_box;
  Gtk::HBox number_box;
  Gtk::Entry file_entry;
  Gtk::Entry number_entry;
  Gtk::Button file_button;
  Gtk::Button number_button;
  Gtk::Button send_button;
  Gtk::Button receive_answer_button;
  Gtk::Button receive_takeover_button;
  Gtk::Button receive_standby_button;
  Gtk::Button stop_button;
  Glib::ustring max_text;
  MessageText text_window;
  StatusLine status_line;
  EfaxController efax_controller;
  void get_file_slot(void);
  void sendfax_slot(void);
  void receive_slot(int);
  void about_slot(bool);
  void fax_list_slot(FaxListDialog::Mode);
  void addressbook_slot(void);
  void settings_slot(void);
  void settings_changed_slot(const Glib::ustring&);
  void helpfile_slot(void);
  void set_number(const Glib::ustring&);
  bool read_error_slot(Glib::IOCondition);
  bool timer_event_handler(void);
  void get_longest_button_text(void);
protected:
  virtual bool on_delete_event(GdkEventAny*) {quit_slot(); return true;}
  virtual bool on_key_press_event(GdkEventKey*);
  virtual void on_style_changed (const Glib::RefPtr<Gtk::Style>&);
public:
  friend ssize_t write_error(const char*);
  friend int connect_to_stderr(void);

  void quit_slot(void);
  MainWindow(const std::string&, const char* filename = 0);
};

#endif
