/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef FAX_LIST_H
#define FAX_LIST_H

#include "prog_defs.h"

#include <string>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/treeview.h>
#include <gtkmm/treemodel.h>
#include <gtkmm/treemodelcolumn.h>
#include <gtkmm/liststore.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/entry.h>
#include <gtkmm/label.h>
#include <gtkmm/main.h>
#include <gtkmm/toolbar.h>
#include <gtkmm/box.h>

#include "pipes.h"



class FaxListModelColumns: public Gtk::TreeModel::ColumnRecord {
  Gtk::TreeModelColumn<std::string> fax_name;
  Gtk::TreeModelColumn<Glib::ustring> fax_description;
  // private constructor - only FaxListDialog can create objects of this class
  FaxListModelColumns(void) {add(fax_name); add(fax_description);}
public:
  friend class FaxListDialog;
};

// this class is modeless, and does not have a run method
// it is self-owning and will delete itself
class FaxListDialog: public Gtk::Window {
public:
  enum Mode {received, sent};
private:
  Mode mode;
  static int is_fax_received_list;
  static int is_fax_sent_list;
  const int standard_size;
  Gtk::VBox fax_list_box;
  Gtk::Table table;
  Gtk::Toolbar tool_bar;
  Gtk::ScrolledWindow fax_list_scroll_window;
  Gtk::Button close_button;
  Gtk::HButtonBox button_box;
  FaxListModelColumns model_columns;
  Gtk::TreeView tree_view;
  Glib::RefPtr<Gtk::ListStore> list_store_r;
  Gtk::Button* print_button_p;
  Gtk::Button* view_button_p;
  Gtk::Button* describe_button_p;
  Gtk::Button* delete_button_p;
  void get_fax_list_rows(void);
  void close_slot(void);
  void set_buttons_slot(void);
  void refresh_slot(void);
  void describe_fax_prompt(void);
  void describe_fax_prompt_witharg(gint) {describe_fax_prompt();}
  void describe_fax(const Glib::ustring&);
  void print_from_stdin(void);
  void fax_to_ps(const std::string&, bool);
  void write_from_stdin(int);
  void ps_viewer(const char*);
  void print_fax_prompt(void);
  void print_fax(void);
  void view_fax(void);
  void delete_fax_prompt(void);
  void delete_fax(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  static int get_is_fax_received_list(void) {return is_fax_received_list;}
  static int get_is_fax_sent_list(void) {return is_fax_sent_list;}

  FaxListDialog(Mode, const int standard_size_);
  ~FaxListDialog(void);
};

class DescriptionDialog: public Gtk::Window {

  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Entry entry;
  Gtk::Window& parent;
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  void selected(bool);
  SigC::Signal1<void, const Glib::ustring&> accepted;
  void run(void);
  DescriptionDialog(const int standard_size, const std::string& text, Gtk::Window& window);
};


#endif
