/* Copyright (C) 2001 2002 Chris Vine

This program is distributed under the General Public Licence, version 2.
For particulars of this and relevant disclaimers see the file
COPYRIGHT distributed with the source files.

*/

#ifndef DIALOGS_H
#define DIALOGS_H

#include "prog_defs.h"

#include <string>

#include <gtkmm/window.h>
#include <gtkmm/table.h>
#include <gtkmm/label.h>
#include <gtkmm/button.h>
#include <gtkmm/buttonbox.h>
#include <gtkmm/fileselection.h>
#include <gtkmm/scrolledwindow.h>
#include <gtkmm/textview.h>
#include <gtkmm/messagedialog.h>
#include <gtkmm/image.h>
#include <gdkmm/pixbuf.h>


class FileReadSelectDialog: public Gtk::FileSelection {
  bool in_run_loop;
  int standard_size;
  Gtk::Label view_filler;
  Gtk::Button view_button;
  Gtk::Window& parent;
  void selected(bool);
  std::string result;
protected:
  virtual bool on_delete_event(GdkEventAny*);
public:
  void view_file(void);
  void finish(void);
  std::string run(void);
  FileReadSelectDialog(const std::string& filename, int standard_size, Gtk::Window& window);
};

class GplDialog;

class GplEditor: public Gtk::TextView {
  GplEditor(void) {} // private class
                     // only GplDialog can create an object
  friend class GplDialog;
};


class GplDialog: public Gtk::Window {
public:
  enum Result {rejected, accepted};
private:
  bool in_run_loop;
  Result result;
  GplEditor editbox;
  Gtk::ScrolledWindow scrolled_window;
  Gtk::Button accept_button;
  Gtk::Button reject_button;
  Gtk::Label label;
  Gtk::Table table;
  void selected(Result);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  int run(void);
  GplDialog(int standard_size);
};

class InfoDialog: public Gtk::MessageDialog {
  bool in_run_loop;
  Gtk::Window& parent;
  void selected(void);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  void run(void);
  InfoDialog(const Glib::ustring& text, const Glib::ustring& caption, int standard_size, Gtk::MessageType message_type, Gtk::Window&);
};

class PromptDialog: public Gtk::Window {
  bool in_run_loop;
  Gtk::Button ok_button;
  Gtk::Button cancel_button;
  Gtk::HButtonBox button_box;
  Gtk::Label label;
  Gtk::Table table;
  Gtk::Window& parent;
  void selected(bool);
protected:
  virtual bool on_delete_event(GdkEventAny*);
  virtual bool on_key_press_event(GdkEventKey*);
public:
  SigC::Signal0<void> accepted;
  SigC::Signal0<void> rejected;
  void run(void);
  PromptDialog(const Glib::ustring& text, const Glib::ustring& caption, int standard_size, Gtk::Window& window);
};

#endif
