# -*- coding: utf-8; Mode: Python; indent-tabs-mode: nil; tab-width: 4 -*-

# Copyright (C) 2010 Stephane Graber
# Author: Stephane Graber <stgraber@ubuntu.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

import os

from ubiquity.plugin import *
from ubiquity import i18n
from ubiquity import misc

NAME = 'edubuntu-addon'
BEFORE = 'partman'
WEIGHT = 10
OEM = False

class PageBase(PluginUI):
    pass

class PageGtk(PageBase):
    plugin_title = 'ubiquity/text/edubuntu-addon_heading_label'

    def __init__(self, controller, *args, **kwargs):
        self.controller = controller
        try:
            import gtk, subprocess
            builder = gtk.Builder()
            builder.add_from_file(os.path.join(os.environ['UBIQUITY_GLADE'],
                'edubuntu-addon.ui'))
            builder.connect_signals(self)
            self.controller.add_builder(builder)
            self.page = builder.get_object('edubuntu-addon_window')

            # Load required objects
            self.description = builder.get_object('description')

            self.unity_install = builder.get_object('unity_install')
            self.unity_title = builder.get_object('unity_title')
            self.unity_description = builder.get_object('unity_description')

            self.ltsp_install = builder.get_object('ltsp_install')
            self.ltsp_title = builder.get_object('ltsp_title')
            self.ltsp_description = builder.get_object('ltsp_description')
            self.ltsp_interface = builder.get_object('ltsp_interface')
            self.ltsp_interface_label = builder.get_object('ltsp_interface_label')

            # Populate drop-down
            self.model_interface = gtk.ListStore(str)
            for line in subprocess.Popen(['nmcli','-t','-f','DEVICE,STATE','dev'],stderr=subprocess.PIPE,stdout=subprocess.PIPE).stdout.readlines():
                info=line.strip().split(':')
                self.model_interface.append(["%s (%s)" % (info[0],info[1])])
            self.ltsp_interface.set_model(self.model_interface)
            cell = gtk.CellRendererText()
            self.ltsp_interface.pack_start(cell)
            self.ltsp_interface.add_attribute(cell,'text',0)
            self.ltsp_interface.set_active(0)

        except Exception, e:
            self.debug('Could not create edubuntu-addon page: %s', e)
            self.page = None
        self.plugin_widgets = self.page

    def plugin_translate(self, lang):
        self.description.set_markup(self.controller.get_string('edubuntu-addon_description_label', lang))

        self.unity_install.set_property('label',self.controller.get_string('edubuntu-addon_unity_install_label', lang))
        self.unity_title.set_markup(self.controller.get_string('edubuntu-addon_unity_title_label', lang))
        self.unity_description.set_markup(self.controller.get_string('edubuntu-addon_unity_description_label', lang))

        self.ltsp_install.set_property('label',self.controller.get_string('edubuntu-addon_ltsp_install_label', lang))
        self.ltsp_title.set_markup(self.controller.get_string('edubuntu-addon_ltsp_title_label', lang))
        self.ltsp_description.set_markup(self.controller.get_string('edubuntu-addon_ltsp_description_label', lang))
        self.ltsp_interface_label.set_markup(self.controller.get_string('edubuntu-addon_ltsp_interface_label', lang))

class Page(Plugin):
    def Prepare(self):
        self.ui.unity_install.set_active(self.db.get('ubiquity/edubuntu-addon_unity_install') == 'true')
        self.ui.ltsp_install.set_active(self.db.get('ubiquity/edubuntu-addon_ltsp_install') == 'true')
        self.ui.ltsp_interface.set_active(int(self.db.get('ubiquity/edubuntu-addon_ltsp_interface_index')))

    def ok_handler(self):
        self.preseed_bool('ubiquity/edubuntu-addon_unity_install',self.ui.unity_install.get_active())
        self.preseed_bool('ubiquity/edubuntu-addon_ltsp_install',self.ui.ltsp_install.get_active())
        self.preseed('ubiquity/edubuntu-addon_ltsp_interface',self.ui.model_interface[self.ui.ltsp_interface.get_active()][0].split(' ')[0])
        self.preseed('ubiquity/edubuntu-addon_ltsp_interface_index',str(self.ui.ltsp_interface.get_active()))
        Plugin.ok_handler(self)
