/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef guiGTK_h
#define guiGTK_h

#include <glib.h>
#include <gdome.h>

#include <gtkmathview.h>

#ifdef __cplusplus
extern "C" {
#endif

  /* initGUI: some initialization stuff, creates the main window, sets it with a title */
  void GUI_init(int *, char ***, char *, guint, guint, gpointer);
  void GUI_uninit(void);

  int  GUI_load_document(GdomeDocument*);
  int  GUI_load_uri(const char*);
  void GUI_unload_document(void);
  void GUI_dump_entities(void);

  /* main: this is the main event loop, to be called when the program is ready to run */
  void GUI_run(void);

  void GUI_freeze(void);
  void GUI_thaw(void);

#ifdef __cplusplus
}
#endif

#endif /* guiGTK_h */
