/* messages.c
 * Error, warning, and info messages, in your host language,
 * as determined by the variable $LANG.
 * Copyright (c) Karl Dahlke, 2008
 * This file is part of the edbrowse project, released under GPL.
 */

#include "eb.h"

/*********************************************************************
Message strings are in utf8.
If your system expects iso8859-x, don't let edbrowse convert
this file from utf8 to iso8859-x.
Use the iu command to disable this feature.
Multiple codepages are used in this file,
and conversion will never get everything right.
You could screw up some or all of the messages!
You have to edit it as is, without conversions.
*********************************************************************/



/* Arrays of messages, one array for each language. */

static const char *englishMessages[] = {
    "EOF",
    "no file",
    "none",
    "substitutions global",
    "substitutions local",
    "case insensitive",
    "case sensitive",
    "directories readonly",
    "directories writable",
    "directories writable with delete",
    "no http redirection",
    "http redirection",
    "do not send referrer",
    "send referrer",
    "javascript disabled",
    "javascript enabled",
    "treating binary like text",
    "watching for binary files",
    "passive mode",
    "active mode",
    "passive/active mode",
    "don't verify ssl connections (less secure)",
    "verify ssl connections",
    "don't show hidden files in directory mode",
    "show hidden files in directory mode",
    "text areas use unix newlines",
    "text areas use dos newlines",
    "end markers off",
    "end markers on listed lines",
    "end markers on",
    "javascript disabled, no action taken",
    "javascript is disabled, going straight to the url",
    "redirection interrupted by user",
    "empty",
    "new session",
    "no trailing newline",
    "directory mode",
    "binary data",
    "ok",
    " [binary]",
    "no title",
    "no description",
    "no keywords",
    "session %d\n",
    "SendMail link.  Compose your mail, type sm to send, then ^ to get back.",
    "line %d has been updated\n",
    "no subject",
    "no config file present",
    ".ebrc config file does not contain a subjfilter{...} block",
    "interrupt, type qt to quit completely",
    "edbrowse ready",
    "entered command line contains nulls; you can use \\0 in a search/replace string to indicate null",
    "authorization requested - type x to abort.",
    "too many redirections",
    "success",
    "directory",
    "redirect to %s delayed by %d seconds\n",
    "Username: ",
    "user name too long, limit %d characters",
    "Password: ",
    "password too long, limit %d characters",
    "your config file does not specify a cooky jar",
    "warning, the directory is inaccessible - the listing will be empty",
    "disaster, error message length %d is too long\n",
    "line %d: ",
    "browse error: ",
    "The following has been sent to your browser, but there is no buffer to contain it.",
    "no options",
    "form has been reset",
    "submitting form",
    "A separate window has been created in buffer %d\n",
    " many",
    " recommended",
    "]",
    "no options contain the string %s\n",
    "sending mail to %s\n",
    "Your information has been sent; watch for a reply via return mail.",
    "junk",
    "quit",
    "next",
    "delete",
    "ip delete",
    "-p option disables this feature",
    "no blacklist file specified, feature disabled",
    "end of message",
    "not yet implemented",
    "filename: ",
    "Sorry, file %s already exists.\n",
    "abbreviated ",
    "empty attachment",
    "attachment ",
    "no buffers left, atachment discarded",
    "could not copy the attachment into buffer %d",
    "cannot create file %s, attachment is discarded\n",
    "cannot write to file %s, attachment is discarded\n",
    "no mail",
    "%d messages\n",
    "spam",
    " from ",
    "?\tprint this help message.\nq\tquit this program.\nx\texit without changing anything on the mail server.\nspace\tread more of this mail message.\nn\tmove on to the next mail message.\nd\tdelete this message.\nj\tjunk this subject for ten days.\nJ\tjunk this subject for a year.\nw\twrite this message to a file and delete it.\nk\tkeep this message in a file, but don't delete it.\nu\twrite this message unformatted to a file, and delete it.",
    "cannot create file %s\n",
    "cannot write to file %s\n",
    "mail saved, %d bytes",
    " appended",
    "this page is finished, please use your back key or quit",
    "Sorry, innerText update not yet implemented.",
    "no errors",
    "proxy authentication for a non-proxy url",
    "session %d is not active",
    "session 0 is invalid",
    "session %d is out of bounds, limit %d",
    "you are already in session %d",
    "expecting `w'",
    "expecting `w' on session %d",
    "Your limit of 1 million lines has been reached.\nSave your files, then exit and restart this program.",
    "absolute path name too long, limit %d chars",
    "directories are readonly, type dw to enable directory writes",
    "could not create .Trash under your home directory, to hold the deleted files",
    "could not remove file %s",
    "Could not move %s to the trash bin, set dx mode to actually remove the file",
    "destination lies inside the block to be moved or copied",
    "no change",
    "cannot join one line",
    "cannot read from the database into another file",
    "cannot read different tables into the same session",
    "missing file name",
    "empty domain in url",
    "cannot write to a url",
    "cannot write to a database table",
    "cannot write an empty file",
    "cannot create %s",
    "cannot write to %s",
    "session is not interactive",
    "line %c is out of range",
    "cannot embed nulls in a shell command",
    "label %c not set",
    "invalid delimiter",
    "no remembered search string",
    "no remembered replacement string",
    "regular expression too long",
    "line ends in backslash",
    "unexpected closing )",
    "replacement string can only use $1 through $9",
    "%s modifier has no preceding character",
    "no closing ]",
    "no closing )",
    "empty buffer",
    "error in regular expression, %s",
    "unexpected error while evaluating the regular expression at line %d",
    "search string not found",
    "line number too large",
    "negative line number",
    "no regular expression after %c",
    "missing delimiter",
    "no lines match the g pattern",
    "all lines match the v pattern",
    "none of the marked lines were successfully modified",
    "operation interrupted",
    "no match",
    "no changes",
    "agent number %c is not defined",
    "could not print new directory",
    "could not establish current directory",
    "invalid directory",
    "cannot play audio from an empty buffer",
    "cannot play audio in browse mode",
    "cannot play audio in directory mode",
    "cannot play audio in database mode",
    "file has no suffix, use mt.xxx to specify your own suffix",
    "suffix is limited to 5 characters",
    "suffix .%s is not a recognized mime type, please check your config file.",
    "no file name or url to refresh",
    "not in database mode",
    "not in browse mode",
    "file name does not contain /",
    "file name ends in /",
    "invalid characters after the sm command",
    "you must specify exactly one of %s after the B command",
    "line does not contain an open %c",
    "both %c and %c are unbalanced on this line, try B%c or B%c",
    "line does not contain an unbalanced brace, parenthesis, or bracket",
    "cannot find the line that balances %c",
    "session %d is currently in browse mode",
    "session %d is currently in directory mode",
    "no file name",
    "end of buffer",
    "no more lines to join",
    "bad range",
    "cannot break lines in directory mode",
    "cannot break lines in database mode",
    "cannot break lines in browse mode",
    "unknown command %c",
    "%c not available in directory mode",
    "%c not available in database mode",
    "%c not available in browse mode",
    "zero line number",
    "no space after command",
    "the %c command cannot be applied globally",
    "invalid move/copy destination",
    "unexpected text after the %c command",
    "nothing to undo",
    "please enter k[a-z]",
    "cannot label an entire range",
    "backing up 0 is invalid",
    "warning: no buffers available to handle the ancillary window",
    "unexpected text after the q command",
    "cannot change the name of a directory",
    "cannot change the name of a table",
    "cannot append to another buffer",
    "no file specified",
    "cannot write to the directory; files are modified as you go",
    "cannot write to the database; rows are modified as you go",
    "unexpected text after the ^ command",
    "no previous text",
    "unexpected text after the M command",
    "destination session not specified",
    "no previous text, cannot back up",
    "cannot apply the g command to a range",
    "g not available in database mode",
    "cannot apply the i%c command to a range",
    "cannot use i< in a global command",
    "buffer %d is empty",
    "buffer %d contains more than one line",
    "cannot open %s",
    "cannot read from %s",
    "input text contains nulls",
    "line contains an embeded carriage return",
    "first line of %s is too long",
    "file is currently in buffer - please use the rf command to refresh",
    "cannot browse a binary file",
    "cannot browse an empty file",
    "this doesn't look like browsable text",
    "already browsing",
    "label %s is not found",
    "i not available in browse mode",
    "cannot run an insert command from an edbrowse function",
    "cannot read text into a database session",
    "command %c not yet implemented",
    "%d is out of range",
    "no options contain the string %s",
    "multiple options contain the string %s",
    "this is a button; use i* to push the button",
    "this is a submit button; use i* to push the button",
    "this is a reset button; use i* to push the button",
    "this is a textarea, you must edit it from session %d",
    "readonly field",
    "input field cannot contain a newline character",
    "input too long, limit %d characters",
    "field must be set to + or -",
    "you cannot clear a radio button; you must set another one",
    "%s is not an accessible file",
    "number expected",
    "session %d contains nulls",
    "sending a file requires method=post and enctype=multipart/form-data",
    "this is an input field, not a button",
    "this button is not part of a form",
    "no javascript associated with this button",
    "form does not include a destination url",
    "the action of the form is not a url",
    "javascript is disabled, cannot activate this form",
    "This form has changed from https to http, and is now insecure",
    "cannot submit using protocol %s",
    "%d is out of range, please use %c1 through %c%d",
    "%d is out of range, please use %c1, or simply %c",
    "cannot replace multiple instances of the empty string",
    "line exceeds %d bytes after substitution",
    "no regular expression after %c",
    "multiple numbers after the third delimiter",
    "unexpected substitution suffix after the third delimiter",
    "cannot use both a numeric suffix and the `g' suffix simultaneously",
    "sorry, cannot apply the bl command to lines longer than %d bytes",
    "replacement data contains newlines",
    "replacement data contains null characters",
    "cannot embed slash, newline, or null in a directory name",
    "destination file already exists",
    "cannot rename file to %s",
    "cannot embed nulls in an input field",
    "cannot embed newlines in an input field",
    "no input fields present",
    "no links present",
    "no buttons present",
    "multiple input fields present, please use %c1 through %c%d",
    "multiple links present, please use %c1 through %c%d",
    "multiple buttons present, please use %c1 through %c%d",
    "could not read the data from the server",
    "%s is not a url",
    "secure proxy not yet implemented",
    "cannot identify %s on the network",
    "the %s protocol is not supported by edbrowse, and is not included in the mime types in your config file",
    "warning: could not preload <buffer %d> with its initial text\n",
    "warning: fields without names will not be transmitted",
    "cannot connect to %s",
    "cannot establish a secure connection to %s, error %d",
    "The certificate for host %s could not be verified - SSL connection aborted",
    "could not send the request to the web server",
    "authorization method %s not recognized",
    "web page requires authorization",
    "login aborted",
    "cannot create temp file %s to uncompress the web page",
    "cannot write to temp file %s to uncompress the web page",
    "zcat cannot uncompress the data to reconstruct the web page",
    "cannot access the uncompressed web page in %s",
    "cannot read the uncompressed web page in %s",
    "could not spawn subcommand %s, errno %d",
    "ftp could not connect to remote host",
    "ftp could not connect to remote host (timed out)",
    "ftp transfer failed",
    "ftp transfer failed (timed out)",
    "ftp no such directory",
    "ftp could not change directory (timed out)",
    "ftp malformed url",
    "ftp usage error",
    "ftp bad login or password",
    "ftp library initialization failed",
    "ftp session initialization failed",
    "ftp unexpected error %d",
    "edbrowse was not compiled with database access",
    "missing alias in address book line %d",
    "missing : in address book line %d",
    "alias in address book line %d is too long, limit 15 characters",
    "email in address book line %d is too long, limit 63 characters",
    " email in address book line %d does not have an @",
    "cannot handle whitespace in email, address book line %d",
    "unprintable characters in your alias or email, address book line %d",
    "last line of your address book is not terminated",
    "cannot send data to the mail server",
    "cannot read data from the mail server",
    "line from the mail server is too long, or unterminated",
    "cannot locate the mail server %s",
    "cannot connect to the mail server",
    "warning: form url specifies a section %s, which will be ignored\n",
    "file %s is empty",
    "your email should begin with subject:",
    "empty subject line",
    "subject line too long, limit %d characters",
    "invalid characters in the subject line, please use only spaces and printable ascii text",
    ".signature is not a regular file",
    "cannot access .signature file",
    "cannot mail the binary file %s, perhaps this should be an attachment?",
    "either none or all of the attachments must be declared \"alternative\"",
    "too many recipients, limit %d",
    "No address book specified, please check your .ebrc config file",
    "alias %s not found in your address book",
    "no recipients specified",
    "session %d is empty, cannot atach",
    "cannot access attachment %s",
    "file %s is not a regular file, cannot attach",
    "file %s is empty, cannot attach",
    "unexpected prompt \"%s\" at the start of the sendmail session",
    "mail server doesn't recognize %s",
    "mail server rejected %s",
    "mail server is not ready to receive data, %s",
    "could not send mail message, %s",
    "no mail accounts specified, plese check your config file",
    "invalid account number %d, please use 1 through %d",
    "cannot send mail while in browse mode",
    "cannot send mail while in database mode",
    "cannot send mail from directory mode",
    "cannot mail binary data, should this be an attachment?",
    "cannot mail an empty file",
    "no recipient at line %d",
    "cannot cc or bcc to the first recipient",
    "no attachment at line %d",
    "invalid account number at line %d",
    "empty subject",
    "line %d should begin with to: attach: alt: account: or subject:",
    "there is no subject line",
    "no recipients specified, place to: emailaddress at the top of youre file",
    "%s:// expected",
    "unrecognized protocol %s",
    "invalid :port specifier at the end of the domain",
    "domain name too long",
    "user name too long",
    "password too long",
    "too many fetches from the internet, you may want to disable `redirect html'",
    "web page indirectly fetches itself, an infinite loop",
    "no function specified",
    "function name should only contain letters and numbers",
    "no such function %s",
    "too many arguments",
    "~%d has no corresponding argument",
    "could not spawn subcommand %s, errno %d",
    "could not create temp file %s, errno %d",
    "too many sql tables in cache, limit %d",
    "%s is not a regular file",
    "file is too large, limit 40MB",
    "cannot read the contents of %s",
    "cannot access %s",
    "environement variable %s not set",
    "cannot expand * ? or [] prior to the last /",
    "%s is not an accessible directory",
    "shell pattern is too long",
    "sorry, I don't know how to expand filenames with \\ in them",
    "improperly formed [] pattern",
    "error compiling the shell pattern, %s",
    "unexpected error while evaluating the shell pattern",
    "shell pattern does not match any files",
    "shell pattern matches more than one file",
    "line becomes too long when shell variables are expanded",
    "the config file does not specify the database - cannot connect",
    "cannot connect to the database - error %d",
    "database error %d",
    "no primary key for this table",
    "column name %s is too long, limit %d characters",
    "syntax error in where clause",
    "column %d is out of range",
    "multiple columns match %s",
    "no column matches %s",
    "no such table %s",
    "invalid column name",
    "cannot select more than one blob column",
    "the data contains pipes, which is my reserved delimiter",
    "the data contains newlines",
    "line contains too many fields, please do not introduce any pipes into the text",
    "line contains too few fields, please do not remove any pipes from the text",
    "no primary key column for this table",
    "miscelaneous sql error %d",
    "cannot delete more than 100 rows at a time",
    "cannot change a key column",
    "cannot change a blob field",
    "cannot change a text field",
    "oops!  I deleted %d row(s), and %d database record(s) were affected.",
    "oops!  I inserted %d row(s), and %d database record(s) were affected.",
    "oops!  I updated %d row(s), and %d database record(s) were affected.",
    "some other row in the database depends on this row",
    "row or table is locked",
    "you do not have permission to modify the database in this way",
    "deadlock detected",
    "placing null into a not-null column",
    "check constraint violated",
    "database timeout",
    "cannot modify a view",
    "no closing %s",
    "warning, javascript cannot be invoked through keystroke events",
    "javascript cannot be invoked through focus or blur",
    "onchange handler is not accessible",
    "%s is not part of a fill-out form",
    "%s does not have a name",
    "unrecognized method, plese use GET or POST",
    "unrecognized enctype, plese use multipart/form-data or application/x-www-form-urlencoded",
    "form cannot submit using protocol %s",
    "unrecognized input type %s",
    "multiple radio buttons have been selected",
    "%s is closed inside %s",
    "%s begins in the middle of %s",
    "an unexpected closure of %s, which was never opened",
    "a text area begins in the middle of a text area",
    "%s appears inside an anchor",
    "%s contains html tags",
    "option cannot contain a comma when it is part of a multiple select",
    "empty option",
    "multiple titles",
    "%s is not inside a list",
    "%s is not inside a table",
    "%s is not inside a table row",
    "option appears outside a select statement",
    "multiple options are selected",
    "unprocessed tag action %d",
    "%s is not closed at eof",
    "java is opening a blank window",
    "unexpected characters after the encoded attachment",
    "invalid characters in the encoded attachment",
    "onchange handler does not work with textarea",
    "warning, javascript cannot be invoked by a double click",
    "error resolving option %s during sync or form submit",
    "tag cannot have onunload and onclik handlers simultaneously",
    "script is not closed at eof, suspending javascript",
    "could not fetch local javascript, %s",
    "could not fetch javascript from %s, code %d",
    "could not fetch javascript, %s",
    "javascript disabled, skipping the onclick code",
    "javascript disabled, skipping the onchange code",
    "javascript disabled, skipping the onreset code",
    "javascript disabled, skipping the onsubmit code",
    "could not find the html tag associated with the javascript variable being modified",
    "javascript modified a textarea, and that isn't implemented yet",
    "warning: garbled refresh directive, %s\n",
    "warning: unrecognized http compression method %s\n",
    "warning: http redirection %d, but a new url is not specified\n",
    "warning: http error %d, %s\n",
    "warning: page does not have a recognizable http header",
    "warning: cannot update config file",
    "help messages on",
    "ftp download",
    "no ssl certificate file specified; secure connections cannot be verified",
    "could not rewrite your config file; your configuration data may be lost!",
    ".ebrc: null characters at line %d",
    ".ebrc: missing function name at line %d",
    ".ebrc: function name at line %d begins with a digit",
    ".ebrc: function name at line %d is too long, limit ten characters",
    ".ebrc: improper function definition syntax at line %d",
    ".ebrc: line %d, \"condition > file\" expected",
    ".ebrc: line %d, filter rule has no match string",
    ".ebrc: line %d, match on %s is set nowhere",
    ".ebrc: line %d, too many mail filters",
    ".ebrc: unrecognized keyword %s at line %d",
    ".ebrc: line %d, attribute %s canot be set outside of a mail descriptor",
    ".ebrc: line %d, attribute %s canot be set outside of a mime descriptor",
    ".ebrc: line %d, attribute %s canot be set outside of a table descriptor",
    ".ebrc: line %d, attribute %s canot be set inside a mail descriptor or filter block",
    ".ebrc: line %d, attribute %s canot be set inside a mime descriptor",
    ".ebrc: line %d, attribute %s canot be set inside a table descriptor",
    ".ebrc: line %d, attribute %s is set to nothing",
    ".ebrc: line %d, too many columns, limit %d",
    ".ebrc: line %d, keycol should be number or number,number",
    ".ebrc: line %d, keycol is out of range; only %d columns specified",
    ".ebrc: address book %s is not a regular file",
    ".ebrc: ip blacklist %s is not a regular file",
    ".ebrc: %s is not a directory",
    ".ebrc: line %d, too many user agents, limit 9",
    ".ebrc: cookie jar %s is not a regular file",
    ".ebrc: cannot create cookie jar %s",
    ".ebrc: too many no js directives, limit %d",
    ".ebrc: line %d, domain %s does not contain a dot",
    ".ebrc: mail trash can %s is not a regular file",
    ".ebrc: SSL certificate file %s is not a regular file",
    ".ebrc: SSL certificate file %s does not exist or is not readable.",
    ".ebrc: line %d, keyword %s is not yet implemented",
    ".ebrc: setting multiple mail accounts as default",
    ".ebrc: missing inserver at line %d",
    ".ebrc: missing outserver at line %d",
    ".ebrc: missing login at line %d",
    ".ebrc: missing password at line %d",
    ".ebrc: missing from at line %d",
    ".ebrc: missing reply at line %d",
    ".ebrc: missing type at line %d",
    ".ebrc: missing description at line %d",
    ".ebrc: missing suffix or protocol list at line %d",
    ".ebrc: missing program at line %d",
    ".ebrc: missing table name at line %d",
    ".ebrc: missing short name at line %d",
    ".ebrc: missing columns at line %d",
    ".ebrc: unexpected } at line %d",
    ".ebrc: else at line %d is not part of an if statement",
    ".ebrc: garbled text at line %d",
    ".ebrc: line %d, cannot start a function, mail/mime descriptor, or filter block inside %s",
    ".ebrc: statement at line %d must appear inside a function",
    "too many email accounts in your .ebrc config file, limit %d",
    "too many mime types in your .ebrc config file, limit %d",
    "too many sql tables in your .ebrc config file, limit %d",
    "too many functions in your .ebrc config file, limit %d",
    ".ebrc: line %d, control structures are nested too deeply",
    ".ebrc: function %s is not closed at eof",
    ".ebrc: mail or mime block is not closed at EOF",
    "home directory not defined by $HOME.",
    "%s is not a directory",
    "no mail accounts specified, please check your .ebrc config file",
    "invalid account number, please use 1 through %d",
    "edbrowse  -v    (show version)\nedbrowse -h (this message)\nedbrowse -c (edit config file)\nedbrowse  [-e] [-d?] -[u|p]m?    (read your mail) \nedbrowse  [-e] [-d?] -m? address1 address2 ... file [+attachments]\nedbrowse  [-e] [-d?] file1 file2 ...",
    "please specify at least one recipient and the file to send",
    "please specify at least one recipient and the file to send, before your attachments",
    "too many files open simultaneously, limit %d",
    "invalid session %d in fetchLineContext()",
    "invalid line number %d in fetchLineContext()",
    "line %d->%d became null",
    "session %d out of range in cxActive",
    "double init on session %d",
    "quitting a nonactive session %d",
    "empty new piece in addToMap()",
    "no newline on directory entry %s",
    "no closing > at line %d",
    "fieldInBuffer could not find tag %d newtext %s",
    "cannot rebuild your cookie jar %s",
    "too many ip addresses in blacklist, limit %d",
    "fetchmail client is interactive, and cannot run in the background",
    "mailbox directory not specified in your .ebrc file",
    "Cannot change directory to %s",
    "Unexpected pop3 introduction <%s>",
    "Could not complete the pop3 login/password sequence <%s>",
    "Could not obtain status information on your mailbox <%s>",
    "error reading message from the server, errno %d",
    "cannot fetch mail message %d <%s>",
    "Sorry, you took too long; mail server hung up.",
    "unable to delete message <%s>",
    "tag code %d has bad character %c following",
    "calling preFormatTag without parsePage",
    "htmlParse() is not reentrant.",
    "unexpected input type in submitForm()",
    "list = 0 in tagFromJavaVar()",
    "empty host in httpConnect",
    "could not allocate memory for javascript operations.",
    "unable to create javascript context",
    "unable to create window object for javascript",
    "unable to create standard classes for javascript",
    "unable to create document object for javascript",
    "hostname:port is too long",
    "protocol: is too long",
    "error allocating %u bytes",
    "error callocating %u bytes",
    "reallocMem(p,0)",
    "reallocMem(0,%d)",
    "error re-allocating %u bytes",
    "stringInList(null,...)",
    "stringInListCI(null,...)",
    "charInList(null,...)",
    "null pointer in pstLength",
    "canot use ioctl() to manage the tty",
    "cannot open %s",
    "cannot create or write to %s",
    "calling fopen() with invalid mode %s",
    "misplaced / in getDirURL(%s)",
    "misplaced / in %s",
    "decodePostData(0,0)",
    "cannot convert pdf to html; make sure pdftohtml is installed, and try running it on %s",
    "only sendmail `auth login' method is supported at this time",
    "Could not complete the smtp login/password sequence <%s>",
    "cannot reply in directory mode",
    "cannot reply in database mode",
    "cannot reply to an empty file",
    "cannot reply to a binary file",
    "subject and reply lines are required",
    "warning, there is no message ID to reference",
    "Sorry, email headers are not available.\nYou must start with an unformatted email message, browse, then reply all.",
    "l expands control chars into hex",
    "l expands control and nonascii chars into hex",
    "Warning: search/substitution functions will not support utf8 characters,\nbecause your pcre library lacks this functionality.\nexport PCREUTF8=off to disable this feature and suppress this warning message.",
    "converting to iso8859",
    "converting to utf8",
    "do not convert between iso8859 and utf8",
    "automatically convert between iso8859 and utf8",
    "cannot copy a directory tree to your trash bin on another file system;\nuse cpio -p or cp -r from the shell",
    "cannot delete a directory tree; use rm -r from the shell",
    "Failed to initialize libcurl.",
    "This ftp directory listing is empty.",
    "search and substitute using ascii",
    "search and substitute using utf8",
    "Warning: you may need to (temporarily) disable utf8 search and substitute\nwith the su8 command for this to work properly.",
    "primary key comprises more than 3 columns",
    "cannot determine the next value for the serial key(0)",
    "Table names are in buffer %d\n",
    "no datasource specified",
    "connecting to datasource %s\n",
    "row",
    "rows",
    "selected",
    "inserted",
    "updated",
    "deleted",
    "procedure executed",
    "table",
    "sql statement is not terminated by a final semicolon, or a right bracket on the following line",
    "update or delete statement with no where clause",
    "remote access denied",
    "Authorization required to access %s",
    "operation failed because memory could not be allocated",
    "Your version of libcurl is older than version %u.%u.%u.\nYou must upgrade libcurl in order to use edbrowse.",
    "operation timed out",
    "cannot send data to the server",
    "the curl library returned the following error message while performing the requested operation: %s",
    "foreign keys for %s\n",
    "do not fetch blob columns",
    "fetch blob columns",
    "SSL connect error in libcurl: %s",
    "input tty",
    "input readline()",
};

/* Translation by Erwin Bliesenick: erwinb@no-log.org */
static const char *frenchMessages[] = {
    "EOF - fin de fichier",
    "pas de fichier",
    "rien",
    "substitutions globales",
    "substitutions locales",
    "insensible à la casse",
    "sensible à la casse",
    "répertoires en lecture seule",
    "répertoires en lecture écriture",
    "répertoires en lecture écriture avec effacement",
    "pas de redirection http",
    "redirection http",
    "ne pas envoyer le référent",
    "envoyer le référent",
    "javascript dédactivé",
    "javascript activé",
    "binaire traité comme texte",
    "détection des fichiers binaires",
    "mode passif",
    "mode actif",
    "mode passif/actif",
    "pas de vérification des connexions ssl (moins sûr)",
    "vérification des connexions ssl",
    "ne pas afficher les fichiers cachés en mode répertoire",
    "afficher les fichiers cachés en mode répertoire",
    "fins de ligne unix dans les zones de texte",
    "fins de ligne dos dans les zones de texte",
    "marqueurs de fin de ligne désactivés",
    "marqueurs de fin de ligne activés pour les lignes listées",
    "marqueurs de fin de ligne activés",
    "javascript désactivé, aucune action lancée",
    "javascript désactivé, on va directement à l'url",
    "redirection interrompue par l'utilisateur",
    "vide",
    "nouvelle session",
    "pas de saut de ligne à la fin",
    "mode répertoire",
    "données binaires",
    "ok",
    " [binaire]",
    "pas de titre",
    "pas de description",
    "pas de mots-clés",
    "session %d\n",
    "Envoi de courrier. Tapez votre courrier, tapez sm pour l'envoyer, puis ^ pour revenir.",
    "la ligne %d a été modifiée\n",
    "pas de sujet",
    "pas de fichier de configuration",
    "pas de bloc subjfilter{...} dans le fichier de configuration .ebrc",
    "interruption, tapez qt pour quitter complètement",
    "edbrowse prêt",
    "la ligne de commande contient des caractères nuls; vous pouvez utiliser \\0 dans une chaîne de recherche/remplacement pour indiquer le caractère nul",
    "autorisation nécessaire - tapez x pour annuler.",
    "trop de redirections",
    "succès",
    "répertoire",
    "redirection vers %s retardée de %d secondes\n",
    "Nom d'utilisateur: ",
    "nom d'utilisateur trop long, la limite est de %d caractères",
    "Mot de passe: ",
    "nom de passe trop long, la limite est de %d caractères",
    "pas de récipient pour les cookies dans votre fichier de configuration",
    "attention, répertoire inaccessible - la liste des fichiers sera vide",
    "désastre, message d'erreur %d trop long\n",
    "ligne %d: ",
    "erreur de navigation: ",
    "Le navigateur a reçu la suite, mais il n'y a pas de tampon pour la recevoir",
    "pas d'options",
    "formulaire réinitialisé",
    "formulaire en cours de soumission",
    "Une nouvelle fenêtre a été créée dans le tampon %d\n",
    " beaucoup",
    " recommendé",
    "]",
    "aucune option ne contient la chaîne %s\n",
    "envoi du courrier à %s\n",
    "Envoi effectué; attendez une réponse par retour de courrier.",
    "indésirable",
    "quitter",
    "suivant",
    "effacement",
    "ip effacé",
    "l'option -p désactive cette fonctionnalité",
    "pas de fichier liste noire, fonctionnalité désactivée",
    "fin du message",
    "pas encore implémenté",
    "nom de fichier: ",
    "Désolé, le fichier %s existe déjà.\n",
    "abrégé ",
    "pièce jointe vide",
    "pièce jointe ",
    "plus de tampon disponible, pièce jointe ignorée",
    "impossible de copier la pièce jointe dans le tampon %d",
    "impossible de créer le fichier %s, pièce jointe ignorée\n",
    "impossible de sauvegarder le fichier %s, pièce jointe ignorée\n",
    "pas de courrier",
    "%d messages\n",
    "spam",
    " from ",
    "?\taffiche ce message d'aide.\nq\tquitte ce programme.\nx\tquitte sans rien modifier sur le serveur de courrier.\nespace\tcontinuer la lecture de ce message.\nn\taller au message suivant.\nd\teffacer ce message.\nj\ttraiter ce sujet comme indésirable pendant dix jours.\nJ\ttraiter ce sujet comme indésirable pendant un an.\nw\tsauvegarder ce message et l'effacer.\nk\tsauvegarder ce message sans l'effacer.\nu\tsauvegader ce message non formaté, puis l'effacer.",
    "création du fichier %s impossible\n",
    "sauvegarde du fichier %s impossible\n",
    "courrier sauvegardé, %d octets",
    " ajouté",
    "page terminée, utilisez la touche retour arrière ou quittez",
    "Désolé, innerText n'est pas encore implémenté",
    "pas d'erreurs",
    "authentification proxy pour une url non-proxy",
    "session %d non active",
    "session 0 invalide",
    "débordement de la session %d, la limite est de %d",
    "vous êtes déjà dans la session %d",
    "`w' attendu",
    "`w' attendu en session %d",
    "Vous avez atteint la limite d'un million de lignes.\nSauvegardez vos fichiers, puis sortez et redémarrez le programme.",
    "chemin du répertoire trop long, la limite est de %d caractères",
    "répertoires en lecture seule, tapez dw pour autoriser l'écriture",
    "impossible de créer le fichier corbeille .Trash, pour contenir vos fichiers effacés",
    "effacement du fichier %s impossible",
    "impossible de mettre %s à la corbeille, passez en mode dx pour l'effacer",
    "destination à l'intérieur du bloc à déplacer ou à copier",
    "pas de modification",
    "ne peut fusionner une seule ligne",
    "impossible de lire la base de données dans un autre fichier",
    "impossible de lire plusieurs tables dans la même session",
    "nom de fichier absent",
    "nom de domaine vide dans l'url",
    "impossible d'écrire sur une url",
    "impossible d'écrire dans une table de base de données",
    "impossible de sauvegarder un fichier vide",
    "impossible de créer %s",
    "ne peut écrire dans %s",
    "session non interactive",
    "ligne %c trop grande",
    "une commande shell ne peut contenir des caractères nuls",
    "label %c non défini",
    "délimiteur invalide",
    "chaîne de recherche non conservée",
    "chaîne de remplacement non conservée",
    "expression régulière trop grande",
    "ligne terminée par un anti-slash",
    "parenthèse fermante inattendue",
    "on ne peut remplacer que de $1 à $9",
    "le modificateur %s n'est précédé d'aucun caractère",
    "pas de crochet fermant",
    "pas de parenthèse fermante",
    "tampon vide",
    "erreur dans l'expression régulière, %s",
    "erreur inattendue en évaluant l'expression régulière %d",
    "chaîne de recherche non trouvée",
    "numéro de ligne trop grand",
    "numéro de ligne négatif",
    "pas d'expression régulière après %c",
    "délimiteur absent",
    "aucune ligne ne correspond au modèle g",
    "toutes les lignes correspondent au modèle v",
    "aucune des lignes marquées n'a pu être modifiée avec succès",
    "opération interrompue",
    "pas de correspondance",
    "pas de changements",
    "l'agent numéro %c n'est pas défini",
    "impossible d'afficher le nouveau répertoire",
    "impossible d'établir le répertoire courant",
    "répertoire invalide",
    "lecture audio impossible à partir d'un tampon vide audio",
    "lecture audio impossible en mode navigation",
    "lecture audio impossible en mode répertoire",
    "lecture audio impossible en mode base de données",
    "le fichier n'a pas d'extension, utilisez mt.xxx pour définir votre propre extension",
    "extension limitée à 5 caractères",
    "l'extension .%s n'est pas un type mime connu, vérifiez votre fichier de configuration.",
    "pas de nom de fichier ou d'url à réafficher",
    "pas en mode base de données",
    "pas en mode navigation",
    "le nom de fichier ne contient pas le caractère /",
    "le nom de fichier se termine par le caractère /",
    "commande sm suivie de caractères invalides",
    "vous devez spécifier exactement un %s après la commande B",
    "la ligne ne contient pas de %c ouvrant(e)",
    "%c et %c non équilibrés sur cette ligne, essayez B%c ou B%c",
    "la ligne ne contient pas de parenthèses, de crochets ou d'accolades non équilibrés",
    "ne peux trouver de ligne équilibrant %c",
    "session %d actuellement en mode navigation",
    "session %d actuellement en mode répertoire",
    "pas de nom de fichier",
    "fin du tampon",
    "plus de lignes à fusionner",
    "mauvais intervalle",
    "impossible de découper les lignes en mode répertoire",
    "impossible de découper les lignes en mode base de données",
    "impossible de découper les lignes en mode navigation",
    "commande %c inconnue",
    "%c impossible en mode répertoire",
    "%c impossible en mode base de données",
    "%c impossible en mode navigation",
    "ligne numéro zéro",
    "pas d'espace après la commande",
    "la commande %c ne peut s'appliquer globalement",
    "destination du déplacement ou de la copie invalide",
    "texte inattendu après la commande %c",
    "rien à défaire",
    "tapez svp k[a-z]",
    "impossible d'étiqueter un intervalle entier",
    "ne peux sauvegarder 0",
    "attention : pas de tampon pour gérer la fenêtre auxiliaire",
    "texte inattendu après la commande q",
    "impossible de renommer le répertoire",
    "impossible de renommer la table",
    "impossible d'ajouter à un autre tampon",
    "pas de fichier spécifié",
    "ne peut mettre à jour le répertoire; les fichiers seront modifiés quand vous quitterez",
    "ne peut mettre à jour la base de données; les lignes seront modifiées quand vous quitterez",
    "texte inattendu après la commande ^",
    "pas de texte antérieur",
    "texte inattendu après la commande M",
    "destination de la session non spécifiée",
    "pas de texte antérieur, sauvegarde impossible",
    "impossible d'appliquer la commande g à un intervalle",
    "g impossible en mode base de données",
    "impossible d'appliquer la commande i%c à un intervalle",
    "impossible d'utiliser i< dans une commande globale",
    "le tampon %d est vide",
    "le tampon %d contient plus d'une ligne",
    "impossible d'ouvrir %s",
    "impossible de lire %s",
    "le texte entré contient des caractères nuls",
    "il y a un retour-chariot dans la ligne",
    "le première ligne de %s est trop longue",
    "le fichier est actuellement dans le tampon - utilisez la commande rf pour le réafficher",
    "navigation impossible dans un fichier binaire",
    "navigation impossible dans un fichier vide",
    "ce contenu ne semble pas navigable",
    "en cours de navigation",
    "label %s non trouvé",
    "i impossible en mode navigation",
    "impossible de lancer une commande d'insertion à partir d'une fonction d'edbrowse",
    "impossible de lire du texte dans une session base de données",
    "commande %c non implémentée",
    "%d hors limites",
    "aucune option ne contient la chaîne %s",
    "de multiples options contiennent la chaîne %s",
    "c'est un bouton; tapez i* pour le déclencher",
    "c'est un bouton de validation; tapez i* pour le déclencher",
    "c'est un bouton d'annulation; tapez i* pour le déclencher",
    "c'est une zone de texte, vous devez l'éditer dans la session %d",
    "champ en lecture seule",
    "une zone de saisie ne peut contenir un saut de ligne",
    "saisie trop long, la limite est de %d caractères",
    "le champ doit être défini + or -",
    "vous ne pouvez réinitialiser un bouton radio; vous devez en activer un autre",
    "%s n'est pas un fichier accessible",
    "nombre attendu",
    "la session %d contient des caractères nuls",
    "l'envoi d'un fichier exige 'method=post and enctype=multipart/form-data'",
    "c'est une zone de saisie, pas un bouton",
    "ce bouton ne fait pas partie d'un formulaire",
    "pas de javascript associé à ce bouton",
    "le formulaire n'inclut aucune URL de destination",
    "l'action de ce formulaire ne renvoie pas à une destination URL",
    "javascript désactivé, impossible d'activer ce formulaire",
    "Le formulaire est passé du mode https au mode http, il n'est plus sécurisé",
    "impossible de soumettre avec le protocole %s",
    "%d hors limites, utilisez s'il vous plait %c1 à %c%d",
    "%d hors limites, utilisez s'il vous plait  %c1, ou simplement %c",
    "impossible de remplacer plusieurs fois la chaîne vide",
    "la ligne dépasse %d caractères après la substitution",
    "pas d'expression régulière après %c",
    "nombres multiples après le troisième délimiteur",
    "suffixe de substitution inattendu après le troisième délimiteur",
    "impossible d'utiliser simultanément un suffixe numérique et le suffixe `g'",
    "désolé, impossible d'exécuter la commande bl sur les lignes excédant %d caractères",
    "les données de remplacement contiennent des sauts de ligne",
    "les données de remplacement contiennent des caractères nuls",
    "un nom de répertoire ne peut contenir un slash, un saut de ligne ou un caractère nul",
    "le fichier destination existe déjà",
    "impossible de renommer le fichier à %s",
    "une zone de saisie ne peut contenir des caractères nuls",
    "une zone de saisie ne peut contenir des sauts de ligne",
    "aucune zone de saisie présente",
    "aucun lien présent",
    "aucun bouton présent",
    "il y a plusieurs zones de saisie, utilisez svp %c1 à %c%d",
    "il y a plusieurs liens, utilisez svp %c1 à %c%d",
    "il y a plusieurs boutons, utilisez svp %c1 à %c%d",
    "impossible de lire les données sur le serveur",
    "%s n'est pas une url",
    "proxy sécurisé non implémenté",
    "impossible d'identifier %s sur le réseau",
    "le protocole %s n'est pas supporté par edbrowse, et n'est pas défini dans les types mime de votre fichier de configuration",
    "attention : impossible de précharger le texte initial dans le <tampon %d>\n",
    "attention : les champs dépourvus de nom ne seront pas transmis",
    "connexion impossible à %s",
    "connexion sécurisée impossible à %s, erreur %d",
    "Le certificat de sécurité de l'hôte %s ne peut être vérifié - connexion SSL abandonnée",
    "impossible d'envoyer la requête au serveur web",
    "méthode d'autorisation %s inconnue",
    "la page web requiert une autorisation",
    "authentification abandonnée",
    "impossible de créer le fichier temporaire %s pour décompresser la page web",
    "impossible d'écrire dans le fichier temporaire %s pour décompresser la page web",
    "zcat ne peut décompresser les données pour reconstruire la page web",
    "impossible d'accéder à la page web décompressée dans %s",
    "impossible de lire la page web décompressée dans %s",
    "impossible de créer la sous-commande %s, erreur numéro %d",
    "connexion ftp impossible à l'hôte distant",
    "connexion ftp impossible à l'hôte distant (délai dépassé)",
    "échec du transfert ftp",
    "échec du transfert ftp (délai dépassé)",
    "ftp : répertoire inexistant",
    "ftp : ne peut changer de répertoire (délai dépassé)",
    "ftp : url mal formée",
    "ftp : erreur d'utilisation",
    0,
    "ftp : échec de l'initialisation de la librairie",
    "ftp : échec de la session d'initialisation",
    "ftp : erreur inattendue %d",
    "edbrowse n'a pas été compilé avec l'accès aux bases de données",
    "alias manquant dans le carnet d'adresses à la ligne %d",
    "manquant dans le carnet d'adresses à la ligne %d",
    "alias trop long dans le carnet d'adresses, limite 15 caractères",
    "email trop long dans le carnet d'adresses, limite 63 caractères",
    " pas de @ dans l'email à la ligne %d du carnet d'adresses",
    "espaces interdits dans un email, à la ligne %d du carnet d'adresses",
    "caractères non imprimables dans un alias ou un email, à la ligne %d du carnet d'adresses",
    "la dernière ligne de votre carnet d'adresses n'est pas terminée",
    "impossible d'envoyer les données au serveur de courrier",
    "données du serveur de courrier impossibles à lire",
    "la ligne envoyée par le serveur de courrier est trop longue, ou n'est pas close",
    "impossible de localiser le serveur de courrier %s",
    "impossible de se connecter au serveur de courrier",
    "attention : le formulaire url spécifie une section %s, qui sera ignorée\n",
    "le fichier %s est vide",
    "votre mail devrait commencer par 'subject:':",
    "ligne sujet vide",
    "ligne sujet trop longue, la limite est de %d caractères",
    "caractères invalides dans la ligne sujet, n'utilisez svp que des espaces ou des caractères imprimables",
    ".signature n'est pas un fichier régulier",
    "impossible d'accéder au fichier .signature",
    "impossible d'envoyer le fichier binaire %s, serait-ce une pièce jointe ?",
    "aucune ou bien toutes les pièces jointes doivent être spécifiées \"alternative\"",
    "trop de destinataires, la limite est de %d",
    "Pas de carnet d'adresses défini, contrôlez votre fichier de configuration .ebrc",
    "impossible de trouver l'alias %s dans votre carnet d'adresses",
    "aucun destinataire spécifié",
    "la session %d est vide, impossible de joindre quelque chose",
    "impossible d'accéder à la pièce jointe %s",
    "impossible de joindre le fichier %s, ce n'est pas un fichier régulier",
    "le fichier %s est vide, impossible de le joindre",
    "invite inattendue \"%s\" au départ de la session d'envoi",
    "le serveur de courrier ne reconnait pas %s",
    "le serveur de courrier a rejeté %s",
    "le serveur de courrier n'est pas prêt à recevoir les données, %s",
    "impossible d'envoyer le courrier, %s",
    "pas de comptes de courrier définis, contrôlez votre fichier de configuration",
    "numéro de compte de courrier invalide %d, utilisez 1 à %d",
    "impossible d'envoyer du courrier en mode navigation",
    "impossible d'envoyer du courrier en mode base de données",
    "impossible d'envoyer du courrier en mode répertoire",
    "impossible d'envoyer des données binaires, serait-ce une pièce jointe ?",
    "impossible d'envoyer un fichier vide",
    "pas de destinataire à la ligne %d",
    "impossible de mettre le premier destinataire en cc ou bcc",
    "pas de pièce jointe à la ligne %d",
    "numéro de compte de courrier invalide à la ligne %d",
    "pas de sujet",
    "la ligne %d devrait débuter par to: attach: alt: account: ou subject:",
    "pas de ligne subject",
    "pas de destinataires spécifiés, placez to: adresse email au début de votre fichier",
    "%s:// attendu",
    "protocole %s non reconnu",
    ":port invalide à la fin du nom de domaine",
    "nom de domaine trop long",
    "nom d'utilisateur trop long",
    "mot de passe trop long",
    "trop de données provenant de l'internet, peut-être faudrait-il désactiver `redirect html'",
    "la page web s'appelle elle-même indirectement, c'est une boucle infinie",
    "pas de fonction spécifiée",
    "les noms de fonction ne peuvent contenir que des lettres et des chiffres",
    "fonction %s non trouvée",
    "trop d'arguments",
    "~%d n'a pas d'argument correspondant",
    "impossible de créer la sous-commande %s, erreur numéro %d",
    "impossible de créer le fichier temporaire %s, erreur numéro %d",
    "trop de tables sql dans le cache, la limite est de %d",
    "%s n'est pas un fichier régulier",
    "fichier trop grand, la limite est de 40MB",
    "impossible de lire le contenu de %s",
    "impossible d'accéder à %s",
    "la variable d'environnement %s n'est pas définie",
    "impossible de développer * ? ou [] antérieur au dernier /",
    "%s n'est pas un répertoire accessible",
    "modèle shell trop long",
    "désolé, j'ignore comment développer les noms de fichiers contenant \\",
    "modèle [] mal formé",
    "erreur de compilation du modèle shell, %s",
    "erreur inattendue d'évaluation du modèle shell",
    "le modèle shell ne correspond à aucun nom de fichier",
    "le modèle shell correspond à plusieurs noms de fichier",
    "ligne trop longue après expansion des variables shell",
    "le fichier de config ne définit aucune base de données - connexion impossible",
    "connexion à la base de données impossible - erreur %d",
    "erreur sql inattendue %d",
    "pas de colonne index spécifiée",
    "nom de colonne %s trop long, la limite est de %d caractères",
    "erreur de syntaxe dans la clause where",
    "débordement dans la colonne %d",
    "plusieurs colonnes correspondent à %s",
    "aucune colonne ne correspond à %s",
    "la table %s n'existe pas",
    "nom de colonne invalide",
    "impossible de sélectionner plus d'une colonne contenant des données binaires",
    "les données contiennent le caractère pipe, réservé comme délimiteur de champ",
    "les données contiennent des sauts de ligne",
    "trop de champs dans la ligne, s'il vous plait, ne mettez pas de caractères pipe dans le texte",
    "pas assez de champs dans la ligne, s'il vous plait, ne supprimez pas de caractères pipe dans le texte",
    "colonne index non spécifiée",
    "erreur sql %d",
    "impossible de supprimer plus de 100 lignes à la fois",
    "impossible de modifier une colonne index",
    "impossible de modifier un champ de données binaires",
    "impossible de modifier un champ de texte",
    "oups!  j'ai supprimé %d ligne(s), et %d enregistrement(s) de la base de données ont été affectés.",
    "oups!  j'ai supprimé %d ligne(s), et %d enregistrement(s) de la base de données ont été affectés.",
    "oups!  j'ai supprimé %d ligne(s), et %d enregistrement(s) de la base de données ont été affectés.",
    "d'autres lignes de la base de données dépendent de cette ligne",
    "la ligne ou la table sont verrouillées",
    "vous n'avez pas la permission de modifier la base de données par ce moyen",
    "deadlock (verrou mortel) détecté",
    "placement d'un null dans une colonne non null",
    "violation de contrainte",
    "dépassement de délai de la base de données",
    "impossible de modifier une vue",
    "pas de fermeture de %s",
    "attention, javascript ne peut être invoqué par un événement clavier",
    "javascript ne peut être invoqué par un focus ou un blur",
    "gestionnaire onchange inaccessible",
    "%s n'appartient pas à un formulaire",
    "%s n'a pas de nom",
    "méthode inconnue, utilisez s'il vous plaît GET ou POST",
    "codage enctype non reconnu, utilisez s'il vous plaît multipart/form-data or application/x-www-form-urlencoded",
    "le formulaire ne peut être soumis en utilisant le protocole %s",
    "saisie de type inconnu %s",
    "plusieurs boutons radio ont été activés",
    "%s est inclus dans %s",
    "%s débute au milieu de %s",
    "fermeture inattendue de %s, qui n'a jamais été ouvert",
    "une zone de texte débute au milieu d'une zone de texte",
    "%s apparaît dans une ancre",
    "%s contient des balises html",
    "l'option ne peut contenir une virgule lorsqu'elle fait partie d'une sélection multiple",
    "option vide",
    "titres multiples",
    "%s n'est pas dans une liste",
    "%s n'est pas dans une table",
    "%s n'est pas dans une ligne de la table",
    "option apparaît à l'extérieur d'un ordre select",
    "de multiples options sont sélectionnées",
    "commande %d du tag non traitée",
    "%s non fermé à la fin du fichier",
    "java ouvre une fenêtre vide",
    "caractères inattendus après la pièce jointe encodée",
    "caractères invalides dans la pièce jointe encodée",
    "le gestionnaire handler ne fonctionne pas avec les zones de texte",
    "attention, javascript ne peut être invoqué par un double clic",
    "erreur de détermination de l'option %s pendant la synchronisation ou la soumission du formulaire",
    "une balise ne peut simultanément gérer onunload and onclik",
    "le script n'est pas clos en fin de fichier, javascript est suspendu",
    "impossible de charger localement javascript, %s",
    "impossible de charger javascript depuis %s, code %d",
    "impossible de charger javascript, %s",
    "javascript désactivé, code onclick ignoré",
    "javascript désactivé, code onchange ignoré",
    "javascript désactivé, code onreset ignoré",
    "javascript désactivé, code onsubmit ignoré",
    "impossible de trouver la balise html associée à la variable javascript modifiée",
    "javascript a modifié une zone de texte, et ce n'est pas encore implémenté",
    "attention : directive de rafraîchissement altérée, %s\n",
    "attention : méthode %s de compression http inconnue\n",
    "attention: redirection http %d, mais la nouvelle url n'a pas été spécifiée\n",
    "attention : erreur html %d, %s\n",
    "attention : la page n'a pas d'en-tête http reconnaissable",
    "attention : impossible de modifier le fichier de configuration",
    "messages d'aide activés",
    "téléchargement ftp",
    "pas de fichier de certificats ssl; les connexions sécurisées ne pourront être vérifiées",
    "Impossible de ré-écrire votre fichier de configuration : les données risquent d'être perdues !",
    "Caractères nuls à la ligne %d",
    ".ebrc : pas de nom de fonction à la ligne %d",
    ".ebrc : le nom de fonction à la ligne %d commence par un chiffre",
    ".ebrc : nom de fonction à la ligne %d trop long : la limite est de dix caractères",
    ".ebrc : erreur de syntaxe dans la définition de fonction à la ligne %d",
    ".ebrc : ligne %d,  \"condition > fichier\" attendu",
    ".ebrc : ligne %d, la règle de filtrage ne correspond à aucune chaîne",
    ".ebrc : ligne %d, la correspondance sur %s n'est pas définie",
    ".ebrc : ligne %d, trop de filtres de courrier",
    ".ebrc : mot clé %s inconnu à la ligne %d",
    ".ebrc : ligne %d, l'attribut %s ne peut être défini hors d'un descripteur de courrier",
    ".ebrc : ligne %d, l'attribut %s ne peut être défini hors d'un descripteur mime",
    ".ebrc : ligne %d, l'attribut %s ne peut être défini hors d'un descripteur de table",
    ".ebrc : ligne %d, l'attribut %s ne peut être défini dans un descripteur de courrier ou un bloc de filtrage",
    ".ebrc : ligne %d, l'attribut %s ne peut être défini dans un descripteur mime",
    ".ebrc : ligne %d, l'attribut %s ne peut être défini dans un descripteur de table",
    ".ebrc : ligne %d, l'attribut %s n'est pas défini",
    ".ebrc : ligne %d,trop de connes, la limite est de %d",
    ".ebrc : ligne %d, la colonne index ne peut être que numérique",
    ".ebrc : colonne index hors limites; seules %d colonnes ont été spécifiées",
    ".ebrc : le carnet d'adresses %s n'est pas un fichier régulier",
    ".ebrc : la liste noirs des IP n'est pas un fichier régulier",
    ".ebrc : %s n'est pas un répertoire",
    ".ebrc : ligne %d, trop d'agents utilisateurs, la limite est de 9",
    ".ebrc : le récipient de cookies n'est pas un fichier régulier",
    ".ebrc : impossible de créer   le récipient de cookies",
    ".ebrc : trop de directives no js, la limite est de %d",
    ".ebrc : ligne %d, le domaine ne contient pas de point",
    ".ebrc : la corbeille de courrier n'est pas un fichier régulier",
    ".ebrc : le fichier de certificats SSL n'est pas un fichier régulier",
    ".ebrc :  fichier de certificats SSL absent ou illisible",
    ".ebrc : ligne %d, le mot-clé %s n'est pas encore implémenté",
    ".ebrc : plus d'un compte mail est défini comme compte par défaut",
    ".ebrc : serveur entrant manquant",
    ".ebrc : serveur sortant manquant",
    ".ebrc : nom d'utilisateur manquant",
    ".ebrc : mot de passe manquant",
    ".ebrc : ligne from manquante à la ligne %d",
    ".ebrc : ligne reply manquante à la ligne %d",
    ".ebrc : type manquant à la ligne %d",
    ".ebrc : description manquante à la ligne %d",
    ".ebrc : suffixe ou liste de protocoles manquants à la ligne %d",
    ".ebrc : programme manquant à la ligne %d",
    ".ebrc : nom de table manquant à la ligne %d",
    ".ebrc : surnom manquant à la ligne %d",
    ".ebrc : colonnes manquantes à la ligne %d",
    ".ebrc : } inattendue à la ligne %d",
    ".ebrc : else à la ligne %d ne fait pas partie d'une instruction",
    ".ebrc : texte altéré à la ligne %d",
    ".ebrc : la ligne %d ne peut lancer une fonction, un descripteur mime ou de type, ou un filtre dans %s",
    ".ebrc : l'instruction à la ligne %d doit apparaître dans une fonction",
    "Trop de comptes de courrier dans votre fichier de configuration, la limite est de %d",
    "Trop de types mime dans votre fichier de configuration, la limite est de %d",
    "Trop de tables sql dans votre fichier de configuration, la limite est de %d",
    "Trop de fonctions dans votre fichier de configuration, la limite est de %d",
    ".ebrc : ligne %d, trop de structures imbriquées",
    ".ebrc : la fonction %s n'est pas fermée",
    ".ebrc : le bloc mime ou courrier n'est pas fermé",
    "Votre répertoire personnel n'est pas défini par la variable $HOME",
    "%s n'est pas un répertoire",
    "Pas de comptes de courrier définis, vérifiez votre fichier .ebrc",
    "Numéro de compte de courrier invalide, utilisez svp de 1 à %d",
    "edbrowse  -v    (montre version)\nedbrowse -h (ce message)\nedbrowse -c (edit fichier config)\nedbrowse  [-e] [-d?] -[u|p]m?    (lecture courrier \nedbrowse  [-e] [-d?] -m? adresse1 adresse2 ... fichier [+pièces jointes]\nedbrowse  [-e] [-d?] fichier1 fichier2 ...",
    "Définissez s'il vous plaît au moins un destinataire et le fichier à envoyer",
    "Définissez s'il vous plaît au moins un destinataire et le fichier à envoyer, avant vos pièces jointes",
    "Trop de fichiers ouverts, la limite est de %d",
    "Session %d invalide dans la fonction fetchLineContext()",
    "Numéro %d de ligne invalide dans la fonction fetchLineContext()",
    "La ligne %d->%d est devenue nulle",
    "La session %d est hors limites dans cxActive",
    "Double init dans la session %d",
    "Quitte la session %d inactive",
    "Nouveau morceau vide dans la fonction addToMap()",
    "Pas de retour-chariot après la ligne du répertoire %s",
    "Pas de caractère  > dans la ligne %d",
    "FieldInBuffer ne peut trouver le tag %d nouveau texte %s",
    "Impossible de reconstruire votre récipient %s de cookies",
    "Trop d'adresse IP en liste noire, la limite est de %d",
    "Le client de courrier est interactif, et ne peut être lancé en arrière-fond",
    "répertoire de courrier non défini dans votre fichier .ebrc",
    "Ne peut aller dans le répertoire %s",
    "Introduction pop3 inattendue <%>",
    "Séquence pop3 nom utilisateur/mot de passe interrompue <%s>",
    "Ne peut obtenir le statut de votre boîte à lettres",
    "Erreur de lecture du message sur le serveur, numéro d'erreur %d",
    "Impossible de récupérer le message %d <%s>",
    "Désolé, vous avez pris trop de temps; le serveur de courrier a raccroché",
    "Impossible de supprimer le message <%s>",
    "Le tag %d est suivi d'un caractère %c erroné",
    "Appel de preFormat sans parsePage",
    "HtmlParse() n'est pas réentrant",
    "Type de données inattendu dans submitForm()",
    "List = 0 dans tagFromJavaVar()",
    "Pas de nom d'hôte dans httpConnect",
    "Impossible d'allouer de la mémoire pour les opérations javascript",
    "Impossible de créer un contexte javascript",
    "Impossible de créer un objet fenêtre pour javascript",
    "Impossible de créer les classe standards pour javascript",
    "Impossible de créer un document objet pour javascript",
    "Hostname:port trop long",
    "Protocol: trop long",
    "Erreur alloc de %u octets",
    "Erreur calloc de %u octets",
    "reallocMem(p,0)",
    "reallocMem(0,%d)",
    "Erreur de ré-allocation de %u octets",
    "StringInList(null,...)",
    "StringInListCI(null,...)",
    "charInList(null,...)",
    "Pointeur nul dans pstLength",
    "Impossible d'utiliser ioctl() pour gérer le terminal",
    "Impossible d'ouvrir %s",
    "Impossible de créer ou d'écrire %s",
    "Mode d'appel %s de fopen() invalide",
    "/ mal placé dans getDirUrl(%s)",
    "/ mal placé dans %s",
    "decodePostData(0,0)",
    "impossible de convertir le pdf en html : assurez-vous d'avoir pdftohtml installé, et essayez de le lancer sur %s",
    "seule la séquence `auth login' de sendmail est supportée jusqu'à présent",
    "Séquence smtp nom utilisateur/mot de passe interrompue <%s>",
    "impossible de répondre en mode répertoire",
    "impossible de répondre en mode base de données",
    "impossible de répondre à un fichier vide",
    "impossible de répondre à un fichier binaire",
    "lignes 'subject' et 'reply' obligatoires",
    "attention, pas d'identificateur ID de message pour le référencer",
    "Désolé, pas d'en-têtes de courrier.\nVous devez commencer avec un courrier non formaté, le consulter, puis répondre à tous.",
    "l affiche tous les caractères de contrôle en hexadécimal",
    "l affiche tous les caractères non-ascii et de contrôle en hexadécimal",
    "Attention : les fonctions de recherche/remplacement ne fonctionneront pas avec les caractères utf8,\nparce que cette fonctionnalité est absente de la librairie pcre.\nExportez PCREUT8=off pour désactiver cette fonctionnalité et supprimer ce message d'avertissement",
    "converti en utf8",
    "converti en iso8859",
    "pas de conversion entre iso8859 et utf8",
    "conversion automatique entre iso8859 et utf8",
    "impossible de copier un répertoire dans la corbeille sur un autre système de fichiers;n utilisez cpio -p ou cp -r à partir du shell",
    "impossible de supprimer un répertoire; utilisez rm -r à partir du shell",
    "Echec à l'initialisation de libcurl.",
    "Ce répertoire ftp est vide.",
    "recherche et remplacement en ascii",
    "recherche et remplacement en utf8",
    "Attention: vous devriez désactiver (temporairement) la recherche/remplacement en utf8\n avec la commande su8 pour que cela fonctionne correctement.",
    "la clé primaire comprend plus de 3 colonnes",
    "impossible de déterminer la prochaine valeur de la clé auto(0)",
    "les noms de table sont dans le tampon %d\n",
    "pas de source de données spécifiée",
    "connexion à la source de données %s\n",
    "ligne",
    "lignes",
    "sélectionné",
    "inséré",
    "mis à jour",
    "supprimé",
    "procédure exécutée",
    "table",
    "instruction sql non suivie d'un point-virgule ou d'un crochet fermant sur la ligne suivante",
    "instruction update ou delete sans clause where",
    "accès distant refusé",
    "autorisation nécessaire pour accéder à %s",
    "l'opération a échoué : impossibilité d'allouer de la mémoire",
    "votre version de la librairie libcurl est antérieure à %u.%u.%u.\nMettez à jour libcurl pour utiliser edbrowse.",
    "délai d'attente de l'opération dépassé",
    "impossible d'envoyer des données au serveur",
    "la librairie curl a renvoyé ce message d'erreur suite à l'opération demandée : %s",
    "clés extérieures pour %s\n",
    "ne pas extraire de colonnes blob",
    "extraction de colonnes blob",
    0,
    0,
    0,
};

/* Translation by Cleverson: clever92000@yahoo.com.br */
static const char *brazilianPortugueseMessages[] = {
    "Fim do arquivo",
    "nenhum arquivo",
    "nenhum",
    "substituição é global",
    "substituição é local",
    "não diferencia maiúsculas",
    "diferencia maiúsculas",
    "diretório é somente leitura",
    "diretório pode ser escrito",
    "diretório pode ser escrito e seu conteúdo apagado",
    "sem redirecionamento http",
    "redirecionamento http",
    "não envia referência",
    "envia referência",
    "javascript desligado",
    "javascript ligado",
    "criando binário como texto",
    "cuidando arquivos binários",
    "modo passivo",
    "modo ativo",
    "modo passivo/ativo",
    "não verifica conexões SSL (menos seguro)",
    "verifica conexões SSL",
    "não exibe arquivos ocultos no modo diretório",
    "exibe arquivos ocultos no modo diretório",
    "áreas de edição usam fim de linha Unix",
    "áreas de edição usam fim de linha DOS",
    "marcadores de fim desligados",
    "marcadores de fim em linhas listadas",
    "marcadores de fim ligados",
    "javascript desativado; nenhuma ação",
    "javascript está desativado;indo direto à URL",
    "redirecionamento interrompido pelo usuário",
    "vazio",
    "nova sessão",
    "nenhum espaço de linha nova",
    "modo diretório",
    "dados binários",
    "OK",
    " [binário]",
    "sem título",
    "sem descrição",
    "sem palavras chave",
    "sessção %d\n",
    "linque de correio.  Escreva a carta, digite sm para enviar e depois ^ para voltar.",
    "linha %d atualizada\n",
    "sem assunto",
    "sem arquivo de configuração",
    "arquivo de configuração .ebrc não contém blocos subjfilter{...}",
    "interrompendo; digite qt para sair completamente",
    "edbrowse ativado",
    "comando contém caracteres nulos; você pode usar \\0 numa cadeia de busca/substituição para indicar nulos",
    "autorização solicitada - digite x para cancelar.",
    "redirecionamentos demais",
    "sucesso",
    "diretório",
    "redireção para %s atrasada em %d segundos\n",
    "Nome de usuário: ",
    "nome de usuário longo demais; limite %d caracteres",
    "Senha: ",
    "senha longa demais; limite %d caracteres",
    "arquivo de configuração não especifica uma cooky jar",
    "aviso: diretório inacessível - listagem ficará vazia",
    "catástrofe; mensagem de erro %d é comprida demais\n",
    "linha %d: ",
    "erro de navegação: ",
    "O que segue foi enviado ao navegador, mas não há buffer para exibir.",
    "sem opções",
    "formulário limpo",
    "submetendo formulário",
    "criada janela separada no buffer %d\n",
    " muitos",
    " recomendado",
    "]",
    "sem opções com a cadeia %s\n",
    "enviando carta para %s\n",
    "informação enviada; aguarde resposta por e-mail.",
    "lixo",
    "sair",
    "próximo",
    "apagar",
    "apagar IP",
    "a opção -p desativa este recurso",
    "nenhum arquivo de lista negra especificado; recurso desativado",
    "fim da mensagem",
    "não implementado ainda",
    "nome do arquivo: ",
    "arquivo %s já existe.\n",
    "abreviado",
    "anexo vazio",
    "anexo ",
    "sem buffers; anexos descartados",
    "não foi possível copiar o anexo para o buffer %d",
    "impossível criar o arquivo %s; anexo descartado\n",
    "impossível escrever no arquivo %s; anexo descartado\n",
    "sem cartas",
    "%d mensagens\n",
    "spam",
    " de",
    "?\tmostra esta mensagem de ajuda.\nq\tsai do programa.\nx\tsai sem mexer no servidor.\nespaço\tcontinua a ler esta carta.\nn\tvai para próxima carta.\nd\tapaga carta.\nj\tenvia para a lixeira cartas com este assunto durante dez dias.\nJ\tenvia para lixeira cartas com este assunto durante um ano.\nw\tguarda carta em arquivo e apaga carta.\nk\tguarda carta em arquivo mas não a apaga.\nu\tguarda carta em arquivo sem formatar e apaga carta",
    "impossível criar o arquivo %s\n",
    "impossível escrever no arquivo %s\n",
    "carta salva; %d bytes",
    " adicionado",
    "página terminou; por favor use a tecla de retorno ou saia",
    "atualização de texto interno não implementada ainda.",
    "sem erros",
    "autenticação proxy para URL não proxy",
    "sessão %d não ativa",
    "sessão 0 é inválida",
    "a sessão %d está fora do limite %d",
    "já está na sessão %d",
    "esperando `w'",
    "esperando `w' na sessão %d",
    "limite de 1 milhão de linhas alcansado.\nSalve os arquivos, saia e reinicie o programa.",
    "caminho absoluto comprido demais; o limite é de %d caracteres",
    "os diretórios são somente leitura; digite dw para ativar a escrita em diretórios",
    "não foi possível criar o .Trash no seu diretório home para armazenar arquivos apagados",
    "não foi possível remover o arquivo %s",
    "não foi possível mover %s para a lixeira; ative o modo dx para remover permanentemente o arquivo",
    "local de destino fica dentro do bloco a copiar ou mover",
    "sem mudança",
    "impossível juntar uma linha",
    "impossível ler do banco de dados para outro arquivo",
    "impossível ler tabelas diferentes dentro da mesma sessão",
    "nome do arquivo faltando",
    "domínio vazio na URL",
    "impossível escrever numa URL",
    "impossível escrever numa tabela do banco de dados",
    "impossível escrever um arquivo vazio",
    "impossível criar %s",
    "impossível escrever em %s",
    "sessão não interativa",
    "linha %c fora do intervalo",
    "impossível embutir caracteres nulos num comando de shell",
    "rótulo %c não definido",
    "delimitador inválido",
    "nenhuma cadeia de busca memorizada",
    "nenhuma cadeia de substituição memorizada",
    "expressão regular longa demais",
    "a linha termina em barra invertida",
    "fecho inesperado )",
    "cadeia de substituição pode usar apenas $1 até $9",
    "o modificador %s não possui caractere predecessor",
    "sem fecho ]",
    "sem fecho )",
    "buffer vazio",
    "erro na expressão regular; %s",
    "erro inesperado a avaliar a expressão regular na linha %d",
    "cadeia não achada",
    "número de linha grande demais",
    "número de linha negativo",
    "sem expressão regular após %c",
    "delimitador faltando",
    "nenhuma linha condiz com o padrão g",
    "todas as linhas condizem com o padrão v",
    "nenhuma linha marcada modificada com sucesso",
    "operação interrompida",
    "nada similar",
    "sem mudanças",
    "agente número %c não definido",
    "não foi possível mostrar diretório novo",
    "não foi possível estabelecer o diretório atual",
    "diretório inválido",
    "impossível reproduzir áudio a partir de um buffer vazio",
    "impossível reproduzir áudio em modo navegação",
    "impossível reproduzir áudio em modo de diretório",
    "impossível reproduzir áudio em modo banco de dados",
    "arquivo não tem sufixo; use mt.xxx para especificar um sufixo próprio",
    "sufixo pode ter no máximo 5 caracteres",
    "sufixo .%s não é um mime conhecido; consulte por favor o arquivo de configuração.",
    "sem arquivo ou URL para atualizar",
    "não está em modo banco de dados",
    "não está em modo navegação",
    "nome do arquivo não possui /",
    "nome do arquivo termina em /",
    "caracteres inválidos após o comando sm",
    "você deve especificar exatamente um dos %s após o comando B",
    "linha não possui um %c de abertura",
    "ambos %c e %c não estão completados nesta linha; experimente B%c ou B%c",
    "linha não possui uma chave, um parêntese ou um colchete não completado",
    "impossível achar a linha que completa o %c",
    "sessão %d está atualmente em modo navegação",
    "sessão %d está atualmente em modo diretório",
    "sem nome de arquivo",
    "fim do buffer",
    "sem mais linhas para juntar",
    "intervalo não recomendado",
    "impossível quebrar linhas em modo diretório",
    "impossível quebrar linhas em modo banco de dados",
    "impossível quebrar linhas em modo navegação",
    "comando %c desconhecido",
    "%c não disponível em modo diretório",
    "%c não disponível em modo banco de dados",
    "%c não disponível em modo navegação",
    "número de linha zero",
    "sem espaço após comando",
    "o comando %c não se aplica globalmente",
    "local de destino para cópia/moção inválido",
    "texto inesperado após o comando %c",
    "nada a desfazer",
    "por favor entre k[a-z]",
    "impossível rotular um intervalo inteiro",
    "copiar 0 é inválido",
    "aviso: nenhum buffer disponível para gerir a janela auxiliar",
    "texto inesperado após o comando q",
    "impossível trocar o nome de um diretório",
    "impossível trocar o nome de uma tabela",
    "impossível adicionar a outro buffer",
    "sem arquivo especificado",
    "impossível escrever no diretório; os arquivos são modificados conforme você tenta",
    "impossível escrever no banco de dados; as linhas são modificadas conforme você tenta",
    "texto inesperado após o comando ^",
    "sem texto anterior",
    "texto inesperado após o comando M",
    "sessão destino não especificada",
    "sem texto anterior; impossível copiar",
    "impossível aplicar comando g a um intervalo",
    "g não disponível em modo banco de dados",
    "impossível aplicar comando i%c a um intervalo",
    "impossível usar i< num comando global",
    "o buffer %d está vazio",
    "o buffer %d contém mais que uma linha",
    "impossível abrir %s",
    "impossível ler a partir de %s",
    "texto de entrada contém caracteres nulos",
    "a linha possui um retorno de carro embutido",
    "a primeira linha do %s é comprida demais",
    "arquivo atualmente no buffer - use por favor o comando rf para atualizar",
    "impossível navegar num arquivo binário",
    "impossível navegar num arquivo vazio",
    "isto não parece um texto navegável",
    "já está navegando",
    "rótulo %s não achado",
    "i não disponível em modo navegação",
    "impossível executar um comando insert a partir de uma função do edbrowse",
    "impossível ler texto numa sessão de banco de dados",
    "comando %c ainda não implementado",
    "%d está fora do intervalo",
    "não há opções com a cadeia %s",
    "várias opções contêm a cadeia %s",
    "botão; use i* para pressioná-lo",
    "botão de submeter; use i* para pressioná-lo",
    "botão de limpar; use i* para pressioná-lo",
    "área de edição; edite na sessão %d",
    "somente leitura",
    "campo de entrada não pode ter caracteres de nova linha",
    "entrada comprida demais; o limite é de %d caracteres",
    "campo deve ser preenchido com + ou -",
    "não pode desmarcar um botão de opção; tem que marcar outro",
    "%s não é um arquivo acessível",
    "espera-se um número",
    "a sessão %d contém caracteres nulos",
    "enviar um arquivo requer method=post e enctype=multipart/form-data",
    "isto é um campo de entrada e não um botão",
    "botão não faz parte de um formulário",
    "sem javascript associado a este botão",
    "formulário não inclui URL de destino",
    "ação do formulário não é uma URL",
    "javascript desligado; impossível ativar este formulário",
    "formulário mudou de https para http e agora não é seguro",
    "impossível submeter usando protocolo %s",
    "%d fora do intervalo; por favor use %c1 até %c%d",
    "%d fora do intervalo; por favor use %c1 ou simplesmente %c",
    "impossível substituir várias ocorrências de uma cadeia vazia",
    "linha excede %d bytes após a substituição",
    "sem expressão regular após %c",
    "vários números após o terceiro delimitador",
    "sufixo de substituição inesperado após o terceiro delimitador",
    "impossível usar um sufixo numérico e o sufixo `g' simultaneamente",
    "impossível aplicar o comando bl a linhas maiores que %d bytes",
    "dados de substituição contêm linhas novas",
    "dados de substituição contêm caracteres nulos",
    "impossível embutir barra, nova linha ou caractere nulo num nome de diretório",
    "arquivo destino já existe",
    "impossível renomear o arquivo para %s",
    "impossível embutir caracteres nulos num campo de entrada",
    "impossível embutir novas linhas num campo de entrada",
    "sem campos de entrada presentes",
    "sem linques presentes",
    "sem botões presentes",
    "presentes vários campos de entrada; por favor use %c1 até %c%d",
    "presentes vários linques; por favor use %c1 até %c%d",
    "presentes; por favor use %c1 até %c%d",
    "não consegui ler os dados do servidor",
    "%s não é uma URL",
    "proxy seguro não implementado ainda",
    "impossível identificar %s na rede",
    "o protocolo %s não é suportado pelo edbrowse e não está incluído nos tipos mime do arquivo de configuração",
    "aviso: não foi possível precarregar o <buffer %d> com o texto inicial do mesmo\n",
    "aviso: campos sem nome não serão transmitidos",
    "não é possível conectar a %s",
    "não é possível estabelecer uma conexão segura com %s; erro %d",
    "o certificado do servidor %s não pôde ser verificado - conexão SSL abortada",
    "não consegui enviar a solicitação ao servidor web",
    "método de autorização %s não reconhecido",
    "página da web requer autorização",
    "Login cancelado",
    "não é possível criar o arquivo temporário %s para descomprimir a página da web",
    "não é possível escrever no arquivo temporário %s para descomprimir a página da web",
    "o zcat não consegue descomprimir os dados para reconstruir a página da web",
    "não é possível acessar a página da web descomprimida em %s",
    "não é possível ler a página da web descomprimida em %s",
    "não foi possível executar o subcomando %s, erro %d",
    "o FTP não conseguiu conectar ao servidor remoto",
    "o FTP não conseguiu conectar ao servidor remoto (tempo esgotado)",
    "transferência FTP falhou",
    "transferência FTP falhou (tempo esgotado)",
    "diretório FTP não existe",
    "não consegui trocar de diretório FTP (tempo esgotado)",
    "URL FTP mal-formada",
    "erro no uso do FTP",
    "FTP - usuário ou senha incorreto",
    "falha na inicialização da biblioteca de FTP",
    "falha a iniciar sessão de FTP",
    "erro de FTP inesperado %d",
    "o edbrowse não foi compilado com acesso a bancos de dado",
    "faltando apelido na linha %d do catálogo de endereços",
    "faltando : na linha %d do catálogo de endereços",
    "o apelido na linha %d do catálogo de endereços é comprido demais; o limite é de 15 caracteres",
    "o e-mail na linha %d do catálogo de endereços é comprido demais; o limite é de 63 caracteres",
    " o e-mail na linha %d do catálogo de endereços não possui uma @",
    "impossível deixar espaços em branco em endereços de e-mail; linha %d do catálogo de endereços",
    "caracteres não imprimíveis no apelido ou no e-mail; linha %d do catálogo de endereços",
    "a última linha do catálogo de endereços não possui terminação",
    "não é possível enviar dados ao servidor",
    "não é possível ler dados do servidor",
    "a linha do servidor é longa demais ou sem fim",
    "não é possível localizar o servidor %s",
    "não é possível conectar ao servidor",
    "aviso: a URL do formulário especifica uma sessão %s que será ignorada\n",
    "arquivo %s vazio",
    "carta deve começar pelo assunto:",
    "assunto em branco",
    "assunto comprido demais; o limite é de %d caracteres",
    "caracteres inválidos no assunto; por favor use apenas espaços e texto ascii",
    ".signature não é um arquivo regular",
    "impossível acessar o arquivo .signature",
    "não é possível enviar o arquivo binário %s; quem sabe ele devesse ser um anexo ?",
    "ou nenhum ou todos os anexos têm de ser declarados como \"alternative\"",
    "destinatários demais; limite é %d",
    "sem catálogo de endereço; confira por favor seu arquivo de configuração .ebrc",
    "apelido %s não achado no catálogo de endereços",
    "nenhum destinatário especificado",
    "sessão %d vazia; impossível anexar",
    "impossível acessar o anexo %s",
    "o arquivo %s não é regular; impossível anexar",
    " arquivo %s vazio; impossível anexar",
    "prompt inesperado \"%s\" no início da sessão sendmail",
    "servidor não reconhece %s",
    "servidor recusou %s",
    "servidor não está pronto para receber dados; %s",
    "não consegui enciar as cartas; %s",
    "sem contas de correio; confira por favor o arquivo de configuração",
    "número de conta %d inválido; por favor use 1 até %d",
    "não posso enviar cartas em modo navegação",
    "não posso enviar cartas em modo banco de dados",
    "não posso enviar cartas em modo diretório",
    "não posso enviar dados binários; isto não tem que ser um anexo ?",
    "não posso enviar um arquivo vazio",
    "sem destinatário na linha %d",
    "não posso enviar CC ou CCO para o primeiro destinatário",
    "sem anexo na linha %d",
    "número de conta inválido na linha %d",
    "assunto em branco",
    "a linha %d deve começar com to: attach: alt: account: ou subject:",
    "nenhuma linha para assunto",
    "sem destinatário; coloque to: endereco no topo do arquivo",
    "%s:// esperado",
    "protocolo desconhecido  %s",
    ":porta inválida ao final do domínio",
    "nome de domínio longo demais",
    "nome de usuário longo demais",
    "senha longa demais",
    "dados demais trazidos da Internet; talvez você queira desabilitar o `redirect html'",
    "página traz ela própria indiretamente; um lupe infinito",
    "sem função especificada",
    "o nome da função deve conter apenas letras e números",
    "função %s não existe",
    "argumentos demais",
    "~%d não possui argumento correspondente",
    "não consegui executar o subcomando %s; erro %d",
    "não consegui criar o arquivo temporário %s; erro %d",
    "tabelas SQL demais no cache; limite é %d",
    "%s não é um arquivo regular",
    "arquivo muito grande; limite é 40MB",
    "impossível ler o conteúdo do %s",
    "impossível acessar %s",
    "variável de ambiente %s não definida",
    "não é possível expandir * ? ou [] antes da última /",
    "%s não é um diretório acessível",
    "padrão shell comprido demais",
    "Desculpe, não sei como expandir nomes de arquivo que contenham \\",
    "padrão [] formado de maneira inadequada",
    "erro a compilar o padrão shell; %s",
    "erro inesperado a avaliar o padrão shell",
    "padrão shell não condiz com nenhum arquivo",
    "padrão shell condiz com mais que um arquivo",
    "as linhas ficam longas demais quando as variáveis do shell são expandidas",
    "o arquivo de configuração não especifica um banco de dados - impossível conectar",
    "não consigo conectar ao banco de dados - erro %d",
    "erro SQL inesperado; %d",
    "sem coluna chave especificada",
    "nome de coluna %s é longo demais; limite é %d caracteres",
    "erro de sintaxe na cláusula where",
    "coluna %d fora do intervalo",
    "várias colunas condizem com %s",
    "nenhuma coluna condiz com %s",
    "tabela %s não existe",
    "nome de coluna inválido",
    "não posso selecionar mais que uma coluna de bolha",
    "dados possuem pipas que são os meus delimitadores reservados",
    "dados contêm novas linhas",
    "a linha possui campos demais; por favor não insira pipas no texto",
    "a linha possui muito poucos campos; por favor não remova nenhuma pipa do texto",
    "coluna chave não especificada",
    "erro miscelâneo de SQL; %d",
    "não posso apagar mais que 100 linhas de uma vez",
    "não posso alterar uma coluna chave",
    "não posso alterar um campo de bolha",
    "não posso alterar um campo de texto",
    "ops !  Apaguei %d linha(s) e %d entrada(s) de banco de dados foram afetadas.",
    "ops !  Inseri %d linha(s) e %d entrada(s) de banco de dados foram afetadas.",
    "ops !  Atualizei %d linha(s) e %d entrada(s) de banco de dados foram afetadas.",
    "outra linha no banco de dados depende desta",
    "a linha ou a tabela está bloqueada",
    "Você não tem permissão para modificar o banco de dados desse jeito",
    "paralização detectada",
    "colocando nulo numa coluna não nula",
    "restrição de conferência violada",
    "tempo do banco de dados esgotado",
    "impossível modificar um panorama",
    "sem fecho %s",
    "aviso: o javascript não pode ser invocado por eventos de teclas de atalho",
    "o javascript não pode ser invocado por foco ou imagem obscura",
    "manipulador onchange não está acessível",
    "%s não é parte de um formulário a ser preenchido",
    "%s não tem nome",
    "método desconhecido; por favor use GET ou POST",
    "codificação desconhecida; por favor use multipart/form-data ou application/x-www-form-urlencoded",
    "o formulário não pode submeter usando protocolo %s",
    "tipo de entrada %s desconhecido",
    "selecionados vários botões de opção",
    "%s fechado em %s",
    "%s começa no meio de %s",
    "fecho inesperado de %s que não foi aberto",
    "uma área de edição começa no meio de uma área de edição",
    "%s aparece no meio de uma âncora",
    "%s possui etiquetas HTML",
    "a opção não pode conter vírgula quando for parte de seleção múltipla",
    "opção vazia",
    "vários títulos",
    "%s não está numa lista",
    "%s não está numa tabela",
    "%s não está numa linha de tabela",
    "a opção aparece fora de uma seleção",
    "selecionadas várias opções",
    "ação de tag %d não processada",
    "%s não é fechado no fim do arquivo",
    "o java está abrindo uma janela vazia",
    "caracteres inesperados após o anexo codificado",
    "caracteres inválidos no anexo codificado",
    "o manipulador onchange não funciona com áreas de edição",
    "aviso: o javascript não pode ser invocado por duplo clique",
    "erro a resolver a opção %s durante um sync ou submissão de formulário",
    "a etiqueta não pode ter manipuladores onunload and onclik simultaneamente",
    "script não é fechado ao fim do arquivo; suspendendo javascript",
    "não consegui trazer o javascript local; %s",
    "não consegui trazer o javascript de %s; código %d",
    "não consegui trazer o javascript; %s",
    "javascript desligado; ignorando código onclick",
    "javascript desligado; ignorando onchange código",
    "javascript desligado; ignorando código onreset",
    "javascript desligado; ignorando código onsubmit",
    "não consegui achar a etiqueta HTML associada à variável javascript que está sendo modificada",
    "o javascript modificou uma área de edição e isso não foi implementado ainda",
    "aviso: diretiva de atualização adulterada; %s\n",
    "aviso: método de compressão HTTP %s desconhecido\n",
    "aviso: redirecionamento HTTP %d mas não foi especificada uma URL nova\n",
    "aviso: erro de HTTP %d, %s\n",
    "aviso: a página não possui um cabeçalho HTTP conhecido",
    "aviso: impossível atualizar arquivo de configuração",
    "mensagens de ajuda ligadas",
    "download via FTP",
    "nenhum arquivo de certificados SSL; conexões seguras não podem ser verificadas",
    "não foi possível reescrever o arquivo de configuração; dados de configuração podem ser perdidos !",
    ".ebrc: caracteres nulos na linha %d",
    ".ebrc: falta nome de função na linha %d",
    ".ebrc: nome de função na linha %d começa com um algarismo",
    ".ebrc: nome de função na linha %d é longo demais; o limite é dez caracteres",
    ".ebrc: a sintaxe de definição de função na linha %d é imprópria",
    ".ebrc: linha %d, esperado \"condição > arquivo\" ",
    ".ebrc: linha %d, regras de filtragem não têm cadeias a coincidir",
    ".ebrc: linha %d, critério em %s não está definido em lugar algum",
    ".ebrc: linha %d, filtros de e-mail em ecesso",
    ".ebrc: palavra-chave desconhecida %s na linha %d",
    ".ebrc: linha %d, o atributo %s não pode ser definido fora de um descritor de mensagem",
    ".ebrc: linha %d, o atributo %s não pode ser definido fora de um descritor mime",
    ".ebrc: linha %d, o atributo %s não pode ser definido fora de um descritor de tabela",
    ".ebrc: linha %d, o atributo %s não pode ser definido dentro de um descritor de mensagem ou bloco de filtro",
    ".ebrc: linha %d, o atributo %s não pode ser definido dentro de um descritor de mime",
    ".ebrc: linha %d, o atributo %s não pode ser definido dentro de um descritor de tabela",
    ".ebrc: linha %d, o atributo %s está definido para nada",
    ".ebrc: linha %d, colunas em excesso; o limite é %d",
    ".ebrc: linha %d, keycol tem que ser número ou número,número",
    ".ebrc: linha %d, keycol fora do intervalo; especificadas somente %d colunas",
    ".ebrc: o catálogo de endereços %s não é um arquivo regular",
    ".ebrc: a lista negra de IPs %s não é um arquivo regular",
    ".ebrc: %s não é um diretório",
    ".ebrc: linha %d, agentes do usuário em excesso; o limite é 9",
    ".ebrc: cookie jar %s não é um arquivo regular",
    ".ebrc: não posso criar a cookie jar %s",
    ".ebrc: diretivas no js em excesso; o limit é %d",
    ".ebrc: linha %d, o domínio %s não possui ponto",
    ".ebrc: lixeira de cartas %s não é um arquivo regular",
    ".ebrc: arquivo de certificados SSL %s não é um arquivo regular",
    ".ebrc: arquivo de certificados SSL %s não existe ou não é legível.",
    ".ebrc: linha %d, palavra-chave %s não foi implementada ainda",
    ".ebrc: definindo várias contas de e-mail como padrão",
    ".ebrc: falta o servidor de entrada na linha %d",
    ".ebrc: falta o servidor de saída na linha %d",
    ".ebrc: falta o usuário na linha %d",
    ".ebrc: falta a senha na linha %d",
    ".ebrc: falta o remetente na linha %d",
    ".ebrc: falta o endereço para resposta na linha %d",
    ".ebrc: falta o tipo na linha %d",
    ".ebrc: falta a descrição na linha %d",
    ".ebrc: falta o sufixo ou a lista de protocolos na linha %d",
    ".ebrc: falta o programa na linha %d",
    ".ebrc: falta o nome da tabela na linha %d",
    ".ebrc: falta o nome curto na linha %d",
    ".ebrc: faltam colunas na linha %d",
    ".ebrc: } inesperada na linha %d",
    ".ebrc: else na linha %d não faz parte de um comando if",
    ".ebrc: texto adulterado na linha %d",
    ".ebrc: linha %d, impossível iniciar função, descritor de mail/mime ou bloco de filtro dentro de %s",
    ".ebrc: comando na linha %d deve aparecer dentro de uma função",
    "contas de e-mail demais no arquivo de configuração .ebrc; o limite é %d",
    "tipos mime demais no arquivo de configuração .ebrc; o limite é %d",
    "tabelas SQL demais no arquivo de configuração .ebrc; o limite é %d",
    "funções demais no arquivo de configuração .ebrc; o limite é %d",
    ".ebrc: linha %d, as estruturas de controle estão aninhadas até um nível alto demais",
    ".ebrc: função %s não se fecha no fim do arquivo",
    ".ebrc: mail ou bloco mime não se fecha no fim do arquivo",
    "diretório home não definido por $HOME.",
    "%s não é um diretório",
    "nenhuma conta de e-mail especificada; confira por favor o arquivo de configuração .ebrc",
    "número de conta inválido; por favor use 1 até %d",
    "edbrowse  -v    (mostra versão)\nedbrowse -h (esta mensagem)\nedbrowse -c (edita arquivo de configuração)\nedbrowse  [-e] [-d?] -[u|p]m?    (lê e-mail) \nedbrowse  [-e] [-d?] -m? endereco1 endereco2 ... arquivo [+anexos]\nedbrowse  [-e] [-d?] arquivo1 arquivo2 ...",
    "por favor especifique ao menos um destinatário e o arquivo a enviar",
    "por favor especifique ao menos um destinatário e o arquivo a enviar, antes dos anexos",
    "demais arquivos abertos ao mesmo tempo; o limite é %d",
    "sessão %d inválida na fetchLineContext()",
    "número de linha %d inválido na fetchLineContext()",
    "linha %d->%d tornou-se nula",
    "sessão %d fora do intervalo na cxActive",
    "init duplo na sessão %d",
    "fechando sessão não ativa %d",
    "novo trecho vazio na addToMap()",
    "sem linha nova na entrada do diretório %s",
    "sem fecho > na linha %d",
    "fieldInBuffer não encontrou a etiqueta %d newtext %s",
    "impossível refazer a cookie jar %s",
    "endereços em excesso na lista negra de IPs; o limite é %d",
    "o cliente de recepção de cartas é interativo e não pode rodar em segundo plano",
    "diretório para caixa de entrada não especificado no arquivo .ebrc",
    "não posso mudar para o diretório %s",
    "introdução do POP3 <%s> inesperada",
    "não consegui completar a seqüência usuario/senha <%s> no POP3",
    "não consegui obter o status da caixa de entrada <%s>",
    "erro a ler mensagens no servidor; código %d",
    "impossível pegar carta %d <%s>",
    "você esperou demais; servidor desconectou.",
    "não posso apagar carta <%s>",
    "o código da etiqueta %d possui o caractere inválido %c a seguir",
    "chamando preFormatTag sem parsePage",
    "htmlParse() não é reentrante.",
    "dipo de entrada inesperado na submitForm()",
    "lista = 0 in tagFromJavaVar()",
    "servidor vazio na httpConnect",
    "não consegui alocar memória para operação Javascript.",
    "impossível criar contexto Javascript ",
    "impossível criar objeto de janela para o Javascript",
    "impossível criar classes padrão para o Javascript",
    "impossível criar objeto de documento para o Javascript",
    "servidor:porta está comprido demais",
    "protocolo: está comprido demais",
    "erro a alocar %u bytes",
    "erro a alocar %u bytes",
    "reallocMem(p,0)",
    "reallocMem(0,%d)",
    "erro a realocar %u bytes",
    "stringInList(null,...)",
    "stringInListCI(null,...)",
    "charInList(null,...)",
    "ponteiro nulo na pstLength",
    "não posso usar ioctl() para controlar o TTY",
    "não é possível abrir %s",
    "não é possível criar ou escrever em %s",
    "chamando fopen() em modo inválido %s",
    "/ mal posicionada na getDirURL(%s)",
    "/ mal posicionada na %s",
    "decodePostData(0,0)",
    "Não foi possível converter o PDF para HTML; certifique-se que o PDFToHTML esteja instalado e tente usá-lo no %s",
    "No momento, somente o método `auth login' do sendmail é suportado",
    "não consegui completar a seqüência usuario/senha <%s> no SMTP",
    "não é possível replicar em modo diretório",
    "não é possível replicar em modo banco de dados",
    "não posso replicar para um arquivo vazio",
    "não posso replicar para um arquivo binário",
    "linhas subject e reply são obrigatórias",
    "aviso: não há ID da mensagem a referenciar",
    "Desculpe; o cabeçalho da carta não está disponível.\nComece com uma carta não formatada, escolha browse e depois reply all.",
    "l expande caracteres de controle para hexadecimais",
    "l expande caracteres de controle e não-ASCII para hexadecimais",
    "Atenção: as funções buscar e substituir não aceitarão caracteres UTF8\nporque a biblioteca PCRE que você tem instalada não suporta essa funcionalidade.\nExporte PCREUTF8=off para desabilitar esse recurso e suprimir este aviso.",
    "convertendo para iso8859",
    "convertendo para utf8",
    "não converta entre iso8859 e utf8",
    "converte automaticamente entre iso8859 e utf8",
    "Não posso copiar uma árvore de diretórios para uma lixeira em outro sistema de arquivos;\nUse cpio -p ou cp -r a partir do shell",
    "Não posso apagar uma árvore de diretórios; use rm -r a partir do shell",
    "Falha ao inicializar a biblioteca libcurl.",
    "Esta listagem do diretório FTP está vazia.",
    "procurar e substituir usando ASCII",
    "procurar e substituir usando UTF8",
    "Aviso: talvez você precise desabilitar temporariamente o UTF8 no procurar e substituir,\nusando o comando su8, para que isso funcione de modo adequado.",
    "chave primária ocupa mais de 3 colunas",
    "impossível determinar próxima coluna para a chave serial(0)",
    "Nomes das tabelas estão no búfer %d\n",
    "nenhuma fonte de dados especificada",
    "conectando à fonte de dados %s\n",
    "linha",
    "linhas",
    "selecionado",
    "inserido",
    "atualizado",
    "apagado",
    "procedimento executado",
    "tabela",
    "comando SQL não terminado por ponto e vírgula ou fecha colchetes na seguinte linha",
    "comando de atualizar ou apagar sem cláusula where",
    "acesso remoto negado",
    "Autorização necessária para acessar %s",
    "operação falhou porque a memória não pôde ser alocada",
    "A sua versão de libcurl é mais velha que a %u.%u.%u.\nVocê tem que atualizá-la para usar o Edbrowse.",
    "tempo limite da operação esgotado",
    "não é possível enviar dados ao servidor",
    "a biblioteca curl retornou o seguinte erro ao executar a operação solicitada: %s",
    "chaves estrangeiras para %s\n",
    "não pegar colunas de blob",
    "pegar colunas de blob",
    0,
    0,
    0,
};

/* Translation by Jan Mura: jan.mura@volny.cz */
/* I'm afraid we didn't get very far on this one. */
static const char *czechMessages[] = {
    "konec souboru",
    "žádný soubor",
    "NON",
    "globální nahrazení",
    "lokální nahrazení",
    "bez ohledu na velikost písmen",
    "s ohledem na velikost písmen",
    "adresář jen pro čtení",
    "adresář pro zápis",
    "adresář pro zápis a mazání",
    "bez HTTP přesměrování",
    "HTTP přesměrování",
};

/* English by default */
static const char **messageArray = englishMessages;
static int messageArrayLength = sizeof (englishMessages) / sizeof (char *);

bool cons_utf8, iuConvert = true;
char type8859 = 1;

void
selectLanguage(void)
{
    char buf[8];
    char *s = getenv("LANG");
    if(!s)
	return;
    if(!*s)
	return;

    if(strstrCI(s, "utf8") || strstrCI(s, "utf-8"))
	cons_utf8 = true;

/* I thought I needed this; guess I don't, for now. */
#if 0
    if(!setlocale(LC_CTYPE, "")) {
	fprintf(stderr,
	   "Can't set the specified locale.  Check LANG, LC_CTYPE, LC_ALL.\n");
    }
#endif

    strncpy(buf, s, 7);
    buf[7] = 0;
    caseShift(buf, 'l');

    if(!strncmp(buf, "en", 2))
	return;			/* english is default */

    if(!strncmp(buf, "fr", 2)) {
	messageArray = frenchMessages;
	messageArrayLength = sizeof (frenchMessages) / sizeof (char *);
	return;
    }

    if(!strncmp(buf, "pt_br", 5)) {
	messageArray = brazilianPortugueseMessages;
	messageArrayLength =
	   sizeof (brazilianPortugueseMessages) / sizeof (char *);
	return;
    }

    if(!strncmp(buf, "cs_cz", 5)) {
	messageArray = czechMessages;
	messageArrayLength = sizeof (czechMessages) / sizeof (char *);
	type8859 = 2;
	return;
    }

    fprintf(stderr, "Sorry, language %s is not implemented\n", buf);
}				/* selectLanguage */

static const char *
getString(int msg)
{
    const char **a = messageArray;
    const char *s;
    char *t;
    int t_len;
    static char utfbuf[1000];

    if(msg >= messageArrayLength)
	a = englishMessages;
    s = a[msg];
    if(!s)
	s = englishMessages[msg];
    if(!s)
	s = "spurious message";

    if(cons_utf8)
	return s;

/* We have to convert it. */
    utf2iso(s, strlen(s), &t, &t_len);
    strcpy(utfbuf, t);
    nzFree(t);
    return utfbuf;
}				/* getString */

/*********************************************************************
Internationalize the standard puts and printf.
These are simple informational messages, where you don't need to error out,
or check the debug level, or store the error in a buffer.
The i_ prefix means international.
*********************************************************************/

void
i_puts(int msg)
{
    puts(getString(msg));
}				/* i_puts */

void
i_printf(int msg, ...)
{
    const char *realmsg = getString(msg);
    va_list p;
    va_start(p, msg);
    vprintf(realmsg, p);
    va_end(p);
}				/* i_printf */

/* Print and exit.  This puts newline on, like puts. */
void
i_printfExit(int msg, ...)
{
    const char *realmsg = getString(msg);
    va_list p;
    va_start(p, msg);
    vfprintf(stderr, realmsg, p);
    fprintf(stderr, "\n");
    va_end(p);
    ebClose(1);
}				/* i_printfExit */

/* i_stringAndMessage: concatenate a message to an existing string. */
void
i_stringAndMessage(char **s, int *l, int messageNum)
{
    const char *messageText = getString(messageNum);
    stringAndString(s, l, messageText);
}				/* i_stringAndMessage */

/*********************************************************************
The following error display functions are specific to edbrowse,
rather than extended versions of the standard unix print functions.
Thus I don't need the i_ prefix.
*********************************************************************/

char errorMsg[4000];

/* Show the error message, not just the question mark, after these commands. */
static const char showerror_cmd[] = "AbefMqrw^";

/* Set the error message.  Type h to see the message. */
void
setError(int msg, ...)
{
    va_list p;

    if(msg < 0) {
	errorMsg[0] = 0;
	return;
    }

    va_start(p, msg);
    vsprintf(errorMsg, getString(msg), p);
    va_end(p);

/* sanity check */
    if(strlen(errorMsg) >= sizeof (errorMsg)) {
	i_printf(63, strlen(errorMsg));
	puts(errorMsg);
	exit(1);
    }
}				/* setError */

void
showError(void)
{
    if(errorMsg[0])
	puts(errorMsg);
    else
	i_puts(106);
}				/* showError */

void
showErrorConditional(char cmd)
{
    if(helpMessagesOn || strchr(showerror_cmd, cmd))
	showError();
    else
	printf("?\n");
}				/* showErrorConditional */

void
showErrorAbort(void)
{
    errorPrint("1%s", errorMsg);
}				/* showErrorAbort */

void
browseError(int msg, ...)
{
    va_list p;
    if(ismc)
	return;
    if(browseLocal != 1)
	return;
    if(browseLine) {
	i_printf(64, browseLine);
	cw->labels[4] = browseLine;
    } else
	i_printf(65);
    va_start(p, msg);
    vprintf(getString(msg), p);
    va_end(p);
    nl();
    browseLocal = 2;
}				/* browseError */

/* Javascript errors, we need to see these no matter what. */
void
runningError(int msg, ...)
{
    va_list p;
    if(ismc)
	return;
    if(browseLine) {
	i_printf(64, browseLine);
	cw->labels[4] = browseLine;
    }
    va_start(p, msg);
    vprintf(getString(msg), p);
    va_end(p);
    nl();
    browseLocal = 2;
}				/* runningError */


/*********************************************************************
Now for the international version of caseShift.
This converts anything that might reasonably be a letter in your locale.
But it isn't ready for prime time.
I'd have to handle utf8 or not,
and then understand upper and lower case letters per language.
So this is commented out.
It was just a preliminary effort anyways, based on iso8859-1.
*********************************************************************/

#if 0

static const char upperMore[] = "";

static const char lowerMore[] = "";

static const char letterMore[] = "";

static bool
i_isalphaByte(unsigned char c)
{
    if(isalphaByte(c))
	return true;
    if(c == false)
	return 0;
    if(strchr(letterMore, c))
	return true;
    return false;
}				/* i_isalphaByte */

/* assumes the arg is a letter */
static unsigned char
i_tolower(unsigned char c)
{
    char *s;
    if(isalphaByte(c))
	return tolower(c);
    s = strchr(upperMore, c);
    if(s)
	c = lowerMore[s - upperMore];
    return c;
}				/* i_tolower */

static unsigned char
i_toupper(unsigned char c)
{
    char *s;
    if(isalphaByte(c))
	return toupper(c);
    s = strchr(lowerMore, c);
    if(s)
	c = upperMore[s - lowerMore];
    return c;
}				/* i_toupper */

/* This is a variation on the original routine, found in stringfile.c */
void
i_caseShift(unsigned char *s, char action)
{
    unsigned char c;
/* The McDonalds conversion is very English - should we do it in all languages? */
    int mc = 0;
    bool ws = true;

    for(; c = *s; ++s) {
	if(action == 'u') {
	    if(i_isalphaByte(c))
		*s = i_toupper(c);
	    continue;
	}

	if(action == 'l') {
	    if(i_isalphaByte(c))
		*s = i_tolower(c);
	    continue;
	}

/* mixed case left */
	if(i_isalphaByte(c)) {
	    if(ws)
		c = i_toupper(c);
	    else
		c = i_tolower(c);
	    if(ws && c == 'M')
		mc = 1;
	    else if(mc == 1 && c == 'c')
		mc = 2;
	    else if(mc == 2) {
		c = i_toupper(c);
		mc = 0;
	    } else
		mc = 0;
	    *s = c;
	    ws = false;
	    continue;
	}

	ws = true, mc = 0;
    }				/* loop */
}				/* caseShift */

#endif
