/*============================================================================
 *  Conversion big-endian/little-endian d'un fichier NOPO (Simail)
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


/*============================================================================
 *                  Définitions de paramètres et macros
 *============================================================================*/

/* Indices premier et dernier groupe de 4 octets à ne pas permuter */

#define LOC_CHAR_DEB     (1 + 14 + 1) + (1 + 1)
#define LOC_CHAR_FIN     (1 + 14 + 1) + (1 + 30)


/*============================================================================
 *                              Fonctions privées
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Lecture d'un fichier NOPO (Format INRIA utilisé par Simail)
 *   et conversion big-endian/little-endian de ce fichier
 *----------------------------------------------------------------------------*/

static void perm_nopo_permut_4
(
 char *rec
)
{

  char c0, c1, c2, c3;

  c0 = rec[0];
  c1 = rec[1];
  c2 = rec[2];
  c3 = rec[3];

  rec[0] = c3;
  rec[1] = c2;
  rec[2] = c1;
  rec[3] = c0;

}


/*============================================================================
 *                             Fonctions publiques
 *============================================================================*/

int main
(
 int    argc   ,
 char * argv[]
)
{

  FILE *fic_lec, *fic_ecr;
  int   ind, buf, ret;

  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/

  if  (argc < 3) {
    printf("Utilisation :\n%s nom_fic nom_fic_conv\n", argv[0]);
    exit(EXIT_FAILURE);
  }

  fic_lec = fopen(argv[1], "rb");
  if (fic_lec == NULL) {
    fprintf(stderr, "Erreur à l'ouverture en lecture du fichier %s\n", argv[1]);
    return EXIT_FAILURE;
  }
  fic_ecr = fopen(argv[2], "wb");
  if (fic_ecr == NULL) {
    fprintf(stderr, "Erreur à l'ouverture en écriture du fichier %s\n", argv[2]);
    return EXIT_FAILURE;
  }

  ind = 0;

  while (feof(fic_lec) == 0) {

    ret = fread((void *)(&buf), 4, 1, fic_lec);
    if (ret == 1) {
      ind += 1;
      if (ind < LOC_CHAR_DEB || ind > LOC_CHAR_FIN)
        perm_nopo_permut_4((char *)(&buf));
      fwrite((void *)(&buf), 4, 1, fic_ecr);
    }

  }

  fclose(fic_lec);
  fclose(fic_ecr);

  return EXIT_SUCCESS ;

}
