/*============================================================================
 *  Definitions des fonctions
 *   associees a la structure `ecs_champ_t' decrivant un champ
 *   et realisant les sorties pour la communication
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <assert.h>
#include <string.h> /* strlen() */

#include <bft_error.h>
#include <bft_mem.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_chaine_glob.h"
#include "ecs_def.h"
#include "ecs_tab.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Post-Traitement"
 *----------------------------------------------------------------------------*/

#include "ecs_comm.h"


/*----------------------------------------------------------------------------
  *  Fichiers `include' visibles des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_vec_int.h"
#include "ecs_champ_vec_real.h"

#include "ecs_champ.h"


/*----------------------------------------------------------------------------
 *  Fichier  `include' du  paquetage courant associe au fichier courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_comm.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' prives   du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_priv.h"



/*============================================================================
 *                       Prototypes de fonctions privees
 *============================================================================*/


/*============================================================================
 *                             Fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui ecrit le tableau des positions d'un champ
 *   dans le fichier d'interface pour le Noyau
 *----------------------------------------------------------------------------*/

void ecs_champ_comm__ecr_pos
(
       ecs_champ_t  *this_champ,
 const char         *comm_nom_rubrique,
       size_t        location_id,
       size_t        index_id,
       ecs_comm_t   *const comm
)
{

  size_t       nbr_pos ;
  ecs_size_t  *pos_tab ;


  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/


  assert(this_champ != NULL) ;

  nbr_pos = ecs_champ__ret_pos_nbr(this_champ) ;

  assert(nbr_pos > 0) ;

  pos_tab = ecs_champ__ret_pos_tab(this_champ) ;

  ecs_comm_write_section(comm_nom_rubrique,
                         nbr_pos,
                         location_id,
                         index_id,
                         1,
                         false,
                         pos_tab,
                         ECS_TYPE_ecs_size_t,
                         comm) ;

  ecs_champ__libere_pos_tab(this_champ,
                            pos_tab) ;

}


/*----------------------------------------------------------------------------
 *  Fonction qui ecrit le contenu d'un champ
 *   dans le fichier d'interface pour le Noyau
 *----------------------------------------------------------------------------*/

void ecs_champ_comm__ecr
(
       ecs_champ_t  *this_champ,
 const char         *comm_nom_rubrique,
       size_t        location_id,
       size_t        index_id,
       size_t        n_location_values,
       ecs_comm_t   *comm
)
{

  size_t      nbr_val ;


  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/


  assert(this_champ != NULL) ;

  nbr_val = ecs_champ__ret_val_nbr(this_champ) ;

  assert(nbr_val > 0) ;

  ecs_comm_write_section(comm_nom_rubrique,
                         nbr_val,
                         location_id,
                         index_id,
                         n_location_values,
                         false,
                         this_champ->val_tab,
                         this_champ->typ_val,
                         comm) ;

}


/*============================================================================
 *                              Fonctions privees
 *============================================================================*/

