/*============================================================================
 *  Dfinitions des fonctions
 *   associes aux structures `ecs_vec_int_t' et `ecs_vec_real_t' dcrivant
 *   les vecteurs indexes entier et rel
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>

#include <bft_mem.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' systme
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int.h"
#include "ecs_vec_real.h"


/*----------------------------------------------------------------------------
 *  Fichier  `include' du  paquetage courant associ au fichier courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' privs   du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_vec_int_priv.h"
#include "ecs_vec_real_priv.h"


/*============================================================================
 *                       Prototypes de fonctions prives
 *============================================================================*/


/*============================================================================
 *                             Fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui dtermine un nouveau vecteur  partir d'un vecteur donn
 *   en extrayant de ce dernier les lments slectionns
 *   par le tableau de boolens
 *
 *  Cette fonction renvoie le vecteur qui dfinit les anciens lments
 * du vecteur de rfrence en fonction des nouveaux lments du vecteur renvoy
 *----------------------------------------------------------------------------*/

ecs_vec_int_t * ecs_vec_real__extrait
(
       ecs_vec_real_t *const vec_new         ,
 const ecs_vec_real_t *const vec_ref         ,
 const ecs_tab_bool_t        bool_elt_select
)
{

  size_t        cpt_elt_new ;
  size_t        cpt_val_new ;
  size_t        cpt_val_old_new ;
  size_t        nbr_elt_ref ;
  size_t        nbr_val_ref ;
  size_t        pos_ref_inf ;
  size_t        pos_ref_sup ;

  size_t        ielt_ref ;
  size_t        ipos_ref ;

  ecs_vec_int_t * vec_old_new ;


  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/


  nbr_elt_ref = ecs_vec_real__ret_pos_nbr(vec_ref) - 1 ;
  nbr_val_ref = ecs_vec_real__ret_val_nbr(vec_ref)     ;


  vec_old_new = ecs_vec_int__alloue(nbr_elt_ref + 1,
                                    nbr_val_ref) ;


  vec_old_new->pos_tab[0] = 1 ;

  cpt_elt_new     = 0 ;
  cpt_val_new     = 0 ;
  cpt_val_old_new = 0 ;


  for (ielt_ref = 0 ; ielt_ref < nbr_elt_ref ; ielt_ref++) {


    if (bool_elt_select.val[ielt_ref] == ECS_TRUE) {

      /* L'lment est  extraire */

      pos_ref_inf = vec_ref->pos_pas *  ielt_ref ;
      pos_ref_sup = vec_ref->pos_pas * (ielt_ref + 1) ;


      for (ipos_ref = pos_ref_inf ; ipos_ref < pos_ref_sup ; ipos_ref++) {

        vec_new->val_tab[cpt_val_new++] = vec_ref->val_tab[ipos_ref] ;

      }


      vec_old_new->pos_tab[ielt_ref + 1] = vec_old_new->pos_tab[ielt_ref] + 1 ;
      vec_old_new->val_tab[cpt_val_old_new++] = cpt_elt_new + 1 ;

      cpt_elt_new++ ;

    }
    else {

      /* L'lment n'est pas  extraire */

      vec_old_new->pos_tab[ielt_ref + 1] = vec_old_new->pos_tab[ielt_ref] ;

    }


  }


  BFT_REALLOC(vec_new->val_tab, cpt_val_new    , ecs_real_t) ;

  vec_new->pos_nbr = cpt_elt_new + 1 ;
  vec_new->pos_pas = vec_ref->pos_pas ;


  BFT_REALLOC(vec_old_new->val_tab, cpt_val_old_new, ecs_int_t) ;


  return vec_old_new ;


}


/*============================================================================
 *                              Fonctions prives
 *============================================================================*/

