/*============================================================================
 *  Dfinitions des fonctions
 *   associes  la structure `ecs_champ_t' dcrivant un champ
 *   et lies aux structures `ecs_vec_int_t' et `ecs_vec_real_t'
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/

#include <assert.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' systme ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_mem.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_chaine_glob.h"
#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_vec.h"
#include "ecs_vec_int.h"
#include "ecs_vec_real.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ.h"
#include "ecs_champ_vec_int.h"
#include "ecs_champ_vec_real.h"


/*----------------------------------------------------------------------------
 *  Fichier  `include' du  paquetage courant associ au fichier courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_vec.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' privs   du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_champ_priv.h"


/*============================================================================
 *                       Prototypes de fonctions prives
 *============================================================================*/


/*============================================================================
 *                             Fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui dtermine un nouveau champ  partir d'un champ de rfrence
 *   en extrayant de ce dernier les lments slectionns
 *   par le tableau de boolens
 *
 *  Cette fonction renvoie le champ qui dfinit les anciens lments
 *   du champ de rfrence en fonction des nouveaux lments du champ renvoy
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_champ__extrait
(
 ecs_champ_t          * *      this_champ_new  ,
 ecs_champ_t            *const champ_ref       ,
 const ecs_tab_bool_t          bool_elt_select
)
{

  ecs_vec_int_t * vec_old_new ;

  size_t        nbr_elt_ref ;
  size_t        nbr_val_ref ;
  ecs_type_t    typ_val_ref_e ;

  ecs_champ_t   * champ_old_new ;


  /*xxxxxxxxxxxxxxxxxxxxxxxxxxx Instructions xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx*/


  typ_val_ref_e = ecs_champ__ret_val_typ(champ_ref) ;


  switch (typ_val_ref_e) {


  case ECS_TYPE_ecs_int_t:

    {
      ecs_vec_int_t * vec_ref        ;
      ecs_vec_int_t * vec_new        ;

      vec_ref = ecs_champ__initialise_vec_int(champ_ref) ;

      nbr_elt_ref = ecs_vec_int__ret_pos_nbr(vec_ref) - 1 ;
      nbr_val_ref = ecs_vec_int__ret_val_nbr(vec_ref) ;

      vec_new = ecs_vec_int__alloue(nbr_elt_ref + 1,
                                    nbr_val_ref) ;


      vec_old_new = ecs_vec_int__extrait(vec_new,
                                         vec_ref,
                                         bool_elt_select) ;


      ecs_champ__libere_vec_int(champ_ref,
                                vec_ref) ;


      champ_old_new   = ecs_champ__init_avec_vec_int(vec_old_new,
                                                     ECS_CHAMP_NOM_DEFINIT) ;


      *this_champ_new = ecs_champ__init_avec_vec_int(vec_new,
                                                     champ_ref->nom) ;

    }

    break ;

  case ECS_TYPE_ecs_real_t:

    {
      ecs_vec_real_t * vec_ref        ;
      ecs_vec_real_t * vec_new        ;

      vec_ref = ecs_champ__initialise_vec_real(champ_ref) ;

      nbr_elt_ref = ecs_vec_real__ret_pos_nbr(vec_ref) - 1 ;
      nbr_val_ref = ecs_vec_real__ret_val_nbr(vec_ref) ;

      vec_new = ecs_vec_real__alloue(nbr_elt_ref + 1,
                                     nbr_val_ref) ;


      vec_old_new = ecs_vec_real__extrait(vec_new,
                                          vec_ref,
                                          bool_elt_select) ;


      ecs_champ__libere_vec_real(champ_ref,
                                 vec_ref) ;


      champ_old_new   = ecs_champ__init_avec_vec_int(vec_old_new,
                                                     ECS_CHAMP_NOM_DEFINIT) ;


      *this_champ_new = ecs_champ__init_avec_vec_real(vec_new,
                                                     champ_ref->nom) ;

    }

    break ;

  default:

    assert(typ_val_ref_e == ECS_TYPE_ecs_int_t  ||
           typ_val_ref_e == ECS_TYPE_ecs_real_t   ) ;

  }


  (*this_champ_new)->statut_e  = champ_ref->statut_e  ;


  return champ_old_new ;


}


/*============================================================================
 *                              Fonctions prives
 *============================================================================*/


