#ifndef _ECS_ENTMAIL_PRE_H_
#define _ECS_ENTMAIL_PRE_H_

/*============================================================================
 *  Definition des fonctions de base
 *   de remplissage de la structure de maillage a partir des donnees lues
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilite
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/

#include <assert.h>
#include <stdlib.h>
#include <string.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' visibles du  paquetage courant
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichier  `include' du  paquetage courant associe au fichier courant
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' prives   du  paquetage courant
 *----------------------------------------------------------------------------*/


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui renvoie une structure "entite de maillage" pour les sommets,
 *   construite a partir de tableaux remplis lors de la lecture des donnees
 *----------------------------------------------------------------------------*/

ecs_entmail_t * ecs_entmail_pre__cree_som
(
 ecs_dim_t     dim_e,
 size_t        nbr_som,
 ecs_real_t  * som_val_coord,
 ecs_int_t   * som_val_label
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie un vecteur de structures "entite de maillage"
 *   pour les elements (aretes, faces et cellules),
 *   construites a partir de tableaux remplis lors de la lecture des donnees
 *----------------------------------------------------------------------------*/

ecs_entmail_t * * ecs_entmail_pre__cree_elt
(
 const size_t       nbr_elt_ent        [],
       ecs_size_t * elt_pos_som_ent    [],
       ecs_int_t  * elt_val_som_ent    [],
       ecs_int_t  * elt_val_label_ent  [],
       ecs_int_t  * elt_val_famille_ent[],
       ecs_int_t  * elt_val_couleur_ent[],
 const ecs_int_t    nbr_coul_ent       [],
       ecs_int_t  * val_coul_ent       [],
       ecs_size_t * nbr_elt_coul_ent   []
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie l'identificateur de l'entite
 *   auquel appartient le type geometrique donne
 *----------------------------------------------------------------------------*/

ECS_ENTMAIL_E ecs_entmail_pre__ret_typ_geo
(
 ecs_int_t typ_geo
) ;


#endif /* _ECS_ENTMAIL_PRE_H_ */
